<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $title; ?></title>
    <style>
        .dashboard-header {
            background: white;
            border-bottom: 3px solid #17a2b8;
            padding: 25px 30px;
            margin-bottom: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .dashboard-title {
            color: #2c3e50;
            margin: 0;
            font-size: 32px;
            font-weight: 700;
        }
        
        .dashboard-subtitle {
            color: #6c757d;
            margin: 8px 0 0 0;
            font-size: 16px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            border-left: 4px solid;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }
        
        .stat-card.pending {
            border-left-color: #ffc107;
        }
        
        .stat-card.today {
            border-left-color: #17a2b8;
        }
        
        .stat-card.equipment {
            border-left-color: #28a745;
        }
        
        .stat-card.revenue {
            border-left-color: #dc3545;
        }
        
        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: white;
        }
        
        .stat-icon.pending {
            background: #ffc107;
        }
        
        .stat-icon.today {
            background: #17a2b8;
        }
        
        .stat-icon.equipment {
            background: #28a745;
        }
        
        .stat-icon.revenue {
            background: #dc3545;
        }
        
        .stat-number {
            font-size: 36px;
            font-weight: 700;
            color: #2c3e50;
            margin: 0;
        }
        
        .stat-label {
            color: #6c757d;
            font-size: 14px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .content-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .content-panel {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .panel-header {
            background: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            padding: 20px 25px;
        }
        
        .panel-title {
            color: #495057;
            margin: 0;
            font-size: 18px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .panel-body {
            padding: 0;
        }
        
        .order-item {
            padding: 20px 25px;
            border-bottom: 1px solid #f1f3f4;
            transition: background-color 0.3s ease;
        }
        
        .order-item:hover {
            background: #f8f9fa;
        }
        
        .order-item:last-child {
            border-bottom: none;
        }
        
        .order-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .patient-name {
            font-weight: 600;
            color: #2c3e50;
            font-size: 16px;
        }
        
        .order-id {
            color: #6c757d;
            font-size: 12px;
            background: #e9ecef;
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: 500;
        }
        
        .order-details {
            color: #6c757d;
            font-size: 14px;
            margin-bottom: 8px;
        }
        
        .priority-badge {
            padding: 4px 10px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .priority-routine {
            background: #e3f2fd;
            color: #1976d2;
        }
        
        .priority-urgent {
            background: #fff3e0;
            color: #f57c00;
        }
        
        .priority-stat {
            background: #ffebee;
            color: #d32f2f;
        }
        
        .fingerprint-status {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            font-size: 12px;
        }
        
        .fingerprint-available {
            color: #28a745;
        }
        
        .fingerprint-missing {
            color: #ffc107;
        }
        
        .appointment-time {
            font-weight: 600;
            color: #17a2b8;
            font-size: 14px;
        }
        
        .equipment-name {
            color: #6c757d;
            font-size: 13px;
        }
        
        .technician-name {
            color: #495057;
            font-size: 13px;
            font-weight: 500;
        }
        
        .action-buttons {
            display: flex;
            gap: 8px;
            margin-top: 10px;
        }
        
        .btn-action {
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 500;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn-verify {
            background: #007bff;
            color: white;
        }
        
        .btn-verify:hover {
            background: #0056b3;
        }
        
        .btn-schedule {
            background: #28a745;
            color: white;
        }
        
        .btn-schedule:hover {
            background: #1e7e34;
        }
        
        .btn-view {
            background: #6c757d;
            color: white;
        }
        
        .btn-view:hover {
            background: #545b62;
        }
        
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }
        
        .action-card {
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            transition: all 0.3s ease;
            cursor: pointer;
            text-decoration: none;
            color: inherit;
        }
        
        .action-card:hover {
            border-color: #007bff;
            box-shadow: 0 4px 12px rgba(0,123,255,0.15);
            text-decoration: none;
            color: inherit;
        }
        
        .action-icon {
            width: 60px;
            height: 60px;
            background: #f8f9fa;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
            font-size: 24px;
            color: #007bff;
        }
        
        .action-title {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 8px;
        }
        
        .action-description {
            color: #6c757d;
            font-size: 14px;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #6c757d;
        }
        
        .empty-state i {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.5;
        }
        
        @media (max-width: 768px) {
            .content-grid {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: 1fr 1fr;
            }
            
            .quick-actions {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper" style="background: #f8f9fa; min-height: 100vh; padding: 20px;">
        <!-- Dashboard Header -->
        <div class="dashboard-header">
            <h1 class="dashboard-title">
                <i class="fa fa-camera"></i> Radiology Department
            </h1>
            <p class="dashboard-subtitle">Medical imaging services and patient verification dashboard</p>
        </div>

        <!-- Statistics Cards -->
        <div class="stats-grid">
            <div class="stat-card pending">
                <div class="stat-header">
                    <div>
                        <h3 class="stat-number"><?php echo count($pending_orders); ?></h3>
                        <p class="stat-label">Pending Orders</p>
                    </div>
                    <div class="stat-icon pending">
                        <i class="fa fa-clock-o"></i>
                    </div>
                </div>
            </div>
            
            <div class="stat-card today">
                <div class="stat-header">
                    <div>
                        <h3 class="stat-number"><?php echo count($today_appointments); ?></h3>
                        <p class="stat-label">Today's Appointments</p>
                    </div>
                    <div class="stat-icon today">
                        <i class="fa fa-calendar"></i>
                    </div>
                </div>
            </div>
            
            <div class="stat-card equipment">
                <div class="stat-header">
                    <div>
                        <h3 class="stat-number"><?php echo count($equipment_list); ?></h3>
                        <p class="stat-label">Active Equipment</p>
                    </div>
                    <div class="stat-icon equipment">
                        <i class="fa fa-cogs"></i>
                    </div>
                </div>
            </div>
            
            <div class="stat-card revenue">
                <div class="stat-header">
                    <div>
                        <h3 class="stat-number">KES <?php 
                            $total_revenue = 0;
                            foreach($pending_orders as $order) {
                                $total_revenue += $order['total_amount'];
                            }
                            echo number_format($total_revenue, 0);
                        ?></h3>
                        <p class="stat-label">Pending Revenue</p>
                    </div>
                    <div class="stat-icon revenue">
                        <i class="fa fa-money"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <a href="<?php echo base_url(); ?>admin/radiology/patient_verification" class="action-card">
                <div class="action-icon">
                    <i class="fa fa-fingerprint"></i>
                </div>
                <div class="action-title">Patient Verification</div>
                <div class="action-description">Verify patient identity and create new orders</div>
            </a>
            
            <a href="<?php echo base_url(); ?>admin/radiology/orders" class="action-card">
                <div class="action-icon">
                    <i class="fa fa-list-alt"></i>
                </div>
                <div class="action-title">Manage Orders</div>
                <div class="action-description">View and manage all radiology orders</div>
            </a>
            
            <a href="<?php echo base_url(); ?>admin/radiology/schedule" class="action-card">
                <div class="action-icon">
                    <i class="fa fa-calendar-check-o"></i>
                </div>
                <div class="action-title">Scheduling</div>
                <div class="action-description">Schedule and manage appointments</div>
            </a>
            
            <a href="<?php echo base_url(); ?>admin/radiology/reports" class="action-card">
                <div class="action-icon">
                    <i class="fa fa-file-text-o"></i>
                </div>
                <div class="action-title">Reports</div>
                <div class="action-description">Generate and view radiology reports</div>
            </a>
        </div>

        <!-- Main Content Grid -->
        <div class="content-grid">
            <!-- Pending Orders -->
            <div class="content-panel">
                <div class="panel-header">
                    <h3 class="panel-title">
                        <i class="fa fa-clock-o"></i> Pending Orders
                    </h3>
                </div>
                <div class="panel-body">
                    <?php if (empty($pending_orders)): ?>
                        <div class="empty-state">
                            <i class="fa fa-inbox"></i>
                            <h5>No Pending Orders</h5>
                            <p>All radiology orders have been processed.</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($pending_orders as $order): ?>
                            <div class="order-item">
                                <div class="order-header">
                                    <div class="patient-name"><?php echo $order['patient_name']; ?></div>
                                    <div class="order-id">Order #<?php echo $order['id']; ?></div>
                                </div>
                                
                                <div class="order-details">
                                    <div>ID: <?php echo $order['patient_unique_id']; ?> | Mobile: <?php echo $order['mobileno'] ?: 'N/A'; ?></div>
                                    <div>Doctor: <?php echo $order['doctor_name'] ?: 'Not assigned'; ?></div>
                                    <div>Amount: KES <?php echo number_format($order['total_amount'], 2); ?></div>
                                </div>
                                
                                <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 10px;">
                                    <div>
                                        <span class="priority-badge priority-<?php echo $order['priority']; ?>">
                                            <?php echo strtoupper($order['priority']); ?>
                                        </span>
                                        
                                        <span class="fingerprint-status">
                                            <?php if (!empty($order['fingerprint_template'])): ?>
                                                <i class="fa fa-fingerprint fingerprint-available"></i>
                                                <span class="fingerprint-available">Verified</span>
                                            <?php else: ?>
                                                <i class="fa fa-exclamation-triangle fingerprint-missing"></i>
                                                <span class="fingerprint-missing">No Fingerprint</span>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    
                                    <div class="action-buttons">
                                        <button type="button" 
                                                class="btn-action btn-verify" 
                                                onclick="verifyPatient(<?php echo $order['patient_id']; ?>)">
                                            <i class="fa fa-fingerprint"></i> Verify
                                        </button>
                                        <button type="button" 
                                                class="btn-action btn-view" 
                                                onclick="viewOrder(<?php echo $order['id']; ?>)">
                                            <i class="fa fa-eye"></i> View
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Today's Appointments -->
            <div class="content-panel">
                <div class="panel-header">
                    <h3 class="panel-title">
                        <i class="fa fa-calendar"></i> Today's Appointments
                    </h3>
                </div>
                <div class="panel-body">
                    <?php if (empty($today_appointments)): ?>
                        <div class="empty-state">
                            <i class="fa fa-calendar-o"></i>
                            <h5>No Appointments Today</h5>
                            <p>No radiology appointments scheduled for today.</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($today_appointments as $appointment): ?>
                            <div class="order-item">
                                <div class="order-header">
                                    <div class="patient-name"><?php echo $appointment['patient_name']; ?></div>
                                    <div class="appointment-time"><?php echo date('H:i', strtotime($appointment['scheduled_time'])); ?></div>
                                </div>
                                
                                <div class="order-details">
                                    <div>ID: <?php echo $appointment['patient_unique_id']; ?></div>
                                    <div class="equipment-name">Equipment: <?php echo $appointment['equipment_name'] ?: 'Not assigned'; ?></div>
                                    <div class="technician-name">Technician: <?php echo $appointment['technician_name'] ?: 'Not assigned'; ?></div>
                                </div>
                                
                                <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 10px;">
                                    <div>
                                        <span class="priority-badge priority-routine">
                                            <?php echo strtoupper($appointment['status']); ?>
                                        </span>
                                    </div>
                                    
                                    <div class="action-buttons">
                                        <button type="button" 
                                                class="btn-action btn-schedule" 
                                                onclick="startExam(<?php echo $appointment['order_id']; ?>)">
                                            <i class="fa fa-play"></i> Start
                                        </button>
                                        <button type="button" 
                                                class="btn-action btn-view" 
                                                onclick="viewAppointment(<?php echo $appointment['id']; ?>)">
                                            <i class="fa fa-eye"></i> View
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Equipment Status -->
        <div class="content-panel">
            <div class="panel-header">
                <h3 class="panel-title">
                    <i class="fa fa-cogs"></i> Equipment Status
                </h3>
            </div>
            <div class="panel-body">
                <div style="padding: 20px;">
                    <div class="stats-grid">
                        <?php foreach ($equipment_list as $equipment): ?>
                            <div class="stat-card equipment">
                                <div class="stat-header">
                                    <div>
                                        <h4 style="margin: 0; color: #2c3e50; font-size: 16px;"><?php echo $equipment['equipment_name']; ?></h4>
                                        <p style="margin: 5px 0 0 0; color: #6c757d; font-size: 13px;">
                                            <?php echo $equipment['manufacturer']; ?> <?php echo $equipment['model']; ?>
                                        </p>
                                        <p style="margin: 5px 0 0 0; color: #6c757d; font-size: 12px;">
                                            Location: <?php echo $equipment['location']; ?>
                                        </p>
                                    </div>
                                    <div style="width: 40px; height: 40px; border-radius: 50%; background: #28a745; display: flex; align-items: center; justify-content: center;">
                                        <i class="fa fa-check" style="color: white;"></i>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>
    <script>
        function verifyPatient(patientId) {
            window.location.href = '<?php echo base_url(); ?>admin/radiology/patient_verification?patient_id=' + patientId;
        }

        function viewOrder(orderId) {
            window.location.href = '<?php echo base_url(); ?>admin/radiology/view_order/' + orderId;
        }

        function startExam(orderId) {
            if (confirm('Start examination for this patient?')) {
                window.location.href = '<?php echo base_url(); ?>admin/radiology/start_exam/' + orderId;
            }
        }

        function viewAppointment(appointmentId) {
            window.location.href = '<?php echo base_url(); ?>admin/radiology/view_appointment/' + appointmentId;
        }

        // Auto-refresh dashboard every 5 minutes
        setInterval(function() {
            location.reload();
        }, 300000);

        // Initialize dashboard
        $(document).ready(function() {
            console.log('Radiology Dashboard initialized');
            
            // Add any dashboard-specific functionality here
            $('.stat-card').on('click', function() {
                $(this).addClass('clicked');
                setTimeout(() => {
                    $(this).removeClass('clicked');
                }, 200);
            });
        });
    </script>
    
    <style>
        .stat-card.clicked {
            transform: scale(0.98);
        }
        
        .order-item {
            transition: all 0.3s ease;
        }
        
        .order-item:hover {
            transform: translateX(5px);
        }
    </style>
</body>
</html>