<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> Requisition Details
            <small>View requisition information</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/procurement"><i class="fa fa-shopping-cart"></i> Procurement</a></li>
            <li><a href="<?php echo base_url(); ?>admin/procurement/requisitions"><i class="fa fa-file-text-o"></i> Requisitions</a></li>
            <li class="active">View Details</li>
        </ol>
    </section>

    <section class="content">
        <?php if (!empty($requisition)): ?>
            <!-- Requisition Header -->
            <div class="row">
                <div class="col-md-8">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-info-circle"></i> Requisition Information
                            </h3>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-sm btn-info" onclick="printRequisition(<?php echo $requisition['id']; ?>)">
                                    <i class="fa fa-print"></i> Print
                                </button>
                                <?php if (($requisition['status'] ?? '') === 'pending_approval'): ?>
                                    <button type="button" class="btn btn-sm btn-success" onclick="approveRequisition(<?php echo $requisition['id']; ?>)">
                                        <i class="fa fa-check"></i> Approve
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="rejectRequisition(<?php echo $requisition['id']; ?>)">
                                        <i class="fa fa-times"></i> Reject
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-condensed">
                                        <tr>
                                            <th width="40%">Requisition No:</th>
                                            <td><?php echo $requisition['requisition_no'] ?? 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Department:</th>
                                            <td><?php echo $requisition['department_name'] ?? 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Requested By:</th>
                                            <td><?php echo $requisition['requested_by_name'] ?? 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Request Date:</th>
                                            <td><?php echo isset($requisition['request_date']) ? date('M d, Y', strtotime($requisition['request_date'])) : 'N/A'; ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-condensed">
                                        <tr>
                                            <th width="40%">Required Date:</th>
                                            <td><?php echo isset($requisition['required_date']) ? date('M d, Y', strtotime($requisition['required_date'])) : 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Priority:</th>
                                            <td>
                                                <?php 
                                                $priority = $requisition['priority'] ?? 'medium';
                                                $priority_class = [
                                                    'low' => 'label-default',
                                                    'medium' => 'label-info', 
                                                    'high' => 'label-warning',
                                                    'urgent' => 'label-danger'
                                                ];
                                                ?>
                                                <span class="label <?php echo $priority_class[$priority] ?? 'label-default'; ?>">
                                                    <?php echo ucfirst($priority); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Status:</th>
                                            <td>
                                                <?php 
                                                $status = $requisition['status'] ?? 'draft';
                                                $status_class = [
                                                    'draft' => 'label-default',
                                                    'pending_approval' => 'label-warning',
                                                    'approved' => 'label-success',
                                                    'rejected' => 'label-danger',
                                                    'fulfilled' => 'label-success'
                                                ];
                                                ?>
                                                <span class="label <?php echo $status_class[$status] ?? 'label-default'; ?>">
                                                    <?php echo ucfirst(str_replace('_', ' ', $status)); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Total Cost:</th>
                                            <td><strong>KES <?php echo number_format($requisition['total_estimated_cost'] ?? 0, 2); ?></strong></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <h4>Purpose:</h4>
                                    <p><?php echo $requisition['purpose'] ?? 'N/A'; ?></p>
                                    
                                    <?php if (!empty($requisition['justification'])): ?>
                                        <h4>Justification:</h4>
                                        <p><?php echo nl2br(htmlspecialchars($requisition['justification'])); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-clock-o"></i> Approval Information
                            </h3>
                        </div>
                        <div class="box-body">
                            <?php if (!empty($requisition['approved_by']) || !empty($requisition['approved_date'])): ?>
                                <table class="table table-condensed">
                                    <tr>
                                        <th>Approved By:</th>
                                        <td><?php echo $requisition['approved_by_name'] ?? 'N/A'; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Approved Date:</th>
                                        <td><?php echo isset($requisition['approved_date']) ? date('M d, Y H:i', strtotime($requisition['approved_date'])) : 'N/A'; ?></td>
                                    </tr>
                                    <?php if (!empty($requisition['approval_comments'])): ?>
                                    <tr>
                                        <th>Comments:</th>
                                        <td><?php echo nl2br(htmlspecialchars($requisition['approval_comments'])); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </table>
                            <?php else: ?>
                                <p class="text-muted">Approval pending</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Requisition Items -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-list"></i> Requisition Items
                            </h3>
                        </div>
                        <div class="box-body">
                            <?php if (!empty($requisition_items)): ?>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Item Code</th>
                                                <th>Item Name</th>
                                                <th>Quantity</th>
                                                <th>Unit</th>
                                                <th>Unit Cost</th>
                                                <th>Total Cost</th>
                                                <th>Specifications</th>
                                                <th>Notes</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $grand_total = 0; ?>
                                            <?php foreach ($requisition_items as $index => $item): ?>
                                                <?php 
                                                $total_cost = ($item['quantity_requested'] ?? 0) * ($item['unit_cost_estimated'] ?? 0);
                                                $grand_total += $total_cost;
                                                ?>
                                                <tr>
                                                    <td><?php echo $index + 1; ?></td>
                                                    <td><?php echo $item['item_code'] ?? 'N/A'; ?></td>
                                                    <td><?php echo $item['item_name'] ?? 'N/A'; ?></td>
                                                    <td><?php echo $item['quantity_requested'] ?? 0; ?></td>
                                                    <td><?php echo $item['unit_of_measure'] ?? 'pieces'; ?></td>
                                                    <td>KES <?php echo number_format($item['unit_cost_estimated'] ?? 0, 2); ?></td>
                                                    <td>KES <?php echo number_format($total_cost, 2); ?></td>
                                                    <td><?php echo $item['specifications'] ?? '-'; ?></td>
                                                    <td><?php echo $item['urgency_notes'] ?? '-'; ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="info">
                                                <th colspan="6" class="text-right">Grand Total:</th>
                                                <th>KES <?php echo number_format($grand_total, 2); ?></th>
                                                <th colspan="2"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            <?php else: ?>
                                <p class="text-muted">No items found for this requisition.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

        <?php else: ?>
            <div class="box box-danger">
                <div class="box-header">
                    <h3 class="box-title">Error</h3>
                </div>
                <div class="box-body">
                    <p>Requisition not found or you don't have permission to view it.</p>
                    <a href="<?php echo base_url('admin/procurement/requisitions'); ?>" class="btn btn-primary">
                        <i class="fa fa-arrow-left"></i> Back to Requisitions
                    </a>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Back Button -->
        <div class="row">
            <div class="col-md-12">
                <a href="<?php echo base_url('admin/procurement/requisitions'); ?>" class="btn btn-default">
                    <i class="fa fa-arrow-left"></i> Back to Requisitions
                </a>
            </div>
        </div>
    </section>
</div>

<script>
function printRequisition(requisitionId) {
    window.open('<?php echo base_url("admin/procurement/printRequisition/"); ?>' + requisitionId, '_blank');
}

function approveRequisition(requisitionId) {
    if (confirm('Are you sure you want to approve this requisition?')) {
        $.ajax({
            url: '<?php echo base_url("admin/procurement/approveRequisition"); ?>',
            type: 'POST',
            data: {
                requisition_id: requisitionId,
                action: 'approve',
                comments: 'Approved'
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message || 'Failed to approve requisition', 'error');
                }
            },
            error: function() {
                showMessage('Error approving requisition', 'error');
            }
        });
    }
}

function rejectRequisition(requisitionId) {
    var reason = prompt('Please provide reason for rejection:');
    if (reason && reason.trim() !== '') {
        $.ajax({
            url: '<?php echo base_url("admin/procurement/approveRequisition"); ?>',
            type: 'POST',
            data: {
                requisition_id: requisitionId,
                action: 'reject',
                comments: reason
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message || 'Failed to reject requisition', 'error');
                }
            },
            error: function() {
                showMessage('Error rejecting requisition', 'error');
            }
        });
    }
}

function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 
                    type === 'warning' ? 'alert-warning' : 'alert-danger';
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible">';
    alertHtml += '<button type="button" class="close" data-dismiss="alert">&times;</button>';
    alertHtml += message + '</div>';
    
    $('section.content').prepend(alertHtml);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>