<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-shopping-cart"></i> Procurement Dashboard
            <small>Manage hospital procurement processes</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Procurement Dashboard</li>
        </ol>
    </section>

    <section class="content">
        <!-- Stats Boxes -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $stats['pending_requisitions'] ?? 0; ?></h3>
                        <p>Pending Requisitions</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-file-text-o"></i>
                    </div>
                    <a href="<?php echo base_url('admin/procurement/requisitions'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3><?php echo $stats['pending_orders'] ?? 0; ?></h3>
                        <p>Pending Purchase Orders</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-shopping-cart"></i>
                    </div>
                    <a href="<?php echo base_url('admin/procurement/purchaseOrders'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $stats['pending_deliveries'] ?? 0; ?></h3>
                        <p>Pending Deliveries</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-truck"></i>
                    </div>
                    <a href="<?php echo base_url('admin/procurement/goodsReceived'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $stats['low_stock_items'] ?? 0; ?></h3>
                        <p>Low Stock Items</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="<?php echo base_url('admin/procurement/items'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Main Content Row -->
        <div class="row">
            <!-- Recent Requisitions -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-file-text-o"></i> Recent Requisitions
                        </h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url('admin/procurement/requisitions'); ?>" class="btn btn-primary btn-xs">
                                <i class="fa fa-plus"></i> New Requisition
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_requisitions)): ?>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Req. No.</th>
                                        <th>Department</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_requisitions as $req): ?>
                                        <tr>
                                            <td><?php echo $req['requisition_no'] ?? 'N/A'; ?></td>
                                            <td><?php echo $req['department_name'] ?? 'N/A'; ?></td>
                                            <td><?php echo isset($req['request_date']) ? date('M d', strtotime($req['request_date'])) : 'N/A'; ?></td>
                                            <td>
                                                <span class="label label-<?php 
                                                    echo ($req['status'] ?? '') == 'approved' ? 'success' : 
                                                         (($req['status'] ?? '') == 'pending_approval' ? 'warning' : 'default'); 
                                                ?>">
                                                    <?php echo ucfirst(str_replace('_', ' ', $req['status'] ?? 'draft')); ?>
                                                </span>
                                            </td>
                                            <td>KES <?php echo number_format($req['total_estimated_cost'] ?? 0, 2); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <p class="text-muted">No recent requisitions found.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Urgent Items -->
            <div class="col-md-6">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-exclamation-triangle"></i> Items Requiring Urgent Attention
                        </h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url('admin/procurement/items'); ?>" class="btn btn-danger btn-xs">
                                <i class="fa fa-list"></i> View All Items
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($urgent_items)): ?>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Category</th>
                                        <th>Current Stock</th>
                                        <th>Reorder Level</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($urgent_items as $item): ?>
                                        <tr>
                                            <td><?php echo $item['item_name'] ?? 'N/A'; ?></td>
                                            <td><?php echo $item['category_name'] ?? 'N/A'; ?></td>
                                            <td><?php echo $item['current_stock'] ?? 0; ?></td>
                                            <td><?php echo $item['reorder_level'] ?? 0; ?></td>
                                            <td>
                                                <?php 
                                                $current_stock = $item['current_stock'] ?? 0;
                                                $reorder_level = $item['reorder_level'] ?? 0;
                                                ?>
                                                <?php if ($current_stock <= 0): ?>
                                                    <span class="label label-danger">Out of Stock</span>
                                                <?php elseif ($current_stock <= $reorder_level): ?>
                                                    <span class="label label-warning">Low Stock</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <p class="text-muted">All items are adequately stocked.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Budget and Spending Row -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-money"></i> Monthly Spending
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <h5 class="description-header">KES <?php echo number_format($stats['monthly_spend'] ?? 0, 2); ?></h5>
                                    <span class="description-text">This Month</span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <h5 class="description-header"><?php echo number_format(($stats['budget_utilization']['utilization_percentage'] ?? 0), 1); ?>%</h5>
                                    <span class="description-text">Budget Utilized</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-line-chart"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <a href="<?php echo base_url('admin/procurement/requisitions'); ?>" class="btn btn-primary btn-block">
                                    <i class="fa fa-plus"></i> New Requisition
                                </a>
                            </div>
                            <div class="col-sm-6">
                                <a href="<?php echo base_url('admin/procurement/suppliers'); ?>" class="btn btn-info btn-block">
                                    <i class="fa fa-users"></i> Manage Suppliers
                                </a>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-sm-6">
                                <a href="<?php echo base_url('admin/procurement/items'); ?>" class="btn btn-warning btn-block">
                                    <i class="fa fa-cubes"></i> Manage Items
                                </a>
                            </div>
                            <div class="col-sm-6">
                                <a href="<?php echo base_url('admin/procurement/reports'); ?>" class="btn btn-success btn-block">
                                    <i class="fa fa-bar-chart"></i> View Reports
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>