<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Specialized Patient Registration</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper {
            background-color: #ecf0f5;
        }
        
        .specialized-header {
            background: linear-gradient(135deg, #dd4b39 0%, #f56954 100%);
            color: white;
            padding: 20px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .priority-notice {
            background: #fcf8e3;
            border: 1px solid #faebcc;
            color: #8a6d3b;
            padding: 15px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .workflow-step {
            padding: 10px 15px;
            border-bottom: 1px solid #f4f4f4;
            display: flex;
            align-items: center;
        }
        
        .workflow-step:last-child {
            border-bottom: none;
        }
        
        .step-number {
            background: #dd4b39;
            color: white;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 10px;
            font-weight: bold;
            font-size: 12px;
        }
        
        .step-content h6 {
            margin: 0 0 3px 0;
            color: #333;
            font-weight: 600;
        }
        
        .step-content small {
            color: #777;
        }
        
        .mandatory-step {
            background: #fff5f5;
            border-left: 4px solid #dd4b39;
        }
        
        .optional-step {
            background: #f8f9fa;
            border-left: 4px solid #6c757d;
        }
        
        .specialist-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 10px;
            margin: 15px 0;
        }
        
        .specialist-option {
            background: white;
            border: 2px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            min-height: 80px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .specialist-option:hover {
            border-color: #dd4b39;
            background-color: #fff5f5;
        }
        
        .specialist-option.selected {
            border-color: #dd4b39;
            background-color: #dd4b39;
            color: white;
        }
        
        .specialist-option i {
            font-size: 24px;
            margin-bottom: 8px;
            display: block;
        }
        
        .service-checkbox {
            background: white;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 12px;
            margin: 8px 0;
            transition: all 0.3s ease;
        }
        
        .service-checkbox:hover {
            border-color: #dd4b39;
            background-color: #fff5f5;
        }
        
        .service-checkbox input[type="checkbox"]:checked + label {
            font-weight: bold;
            color: #dd4b39;
        }
        
        .service-checkbox input[type="checkbox"]:disabled + label {
            color: #6c757d;
            font-style: italic;
        }
        
        .required {
            color: #dd4b39;
        }
        
        .btn-specialized {
            background-color: #dd4b39;
            border-color: #dd4b39;
            color: white;
        }
        
        .btn-specialized:hover {
            background-color: #c23321;
            border-color: #c23321;
            color: white;
        }
        
        .cost-display {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 8px 15px;
            border-radius: 15px;
            font-weight: bold;
            text-align: center;
        }
        
        .chief-complaint-section {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .priority-levels {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .priority-option {
            padding: 8px 12px;
            margin: 5px 0;
            border-radius: 3px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .priority-routine { border-left: 4px solid #28a745; }
        .priority-urgent { border-left: 4px solid #ffc107; }
        .priority-emergency { border-left: 4px solid #dc3545; }
        
        .priority-option:hover {
            background-color: #f8f9fa;
        }
        
        .priority-option.selected {
            background-color: #e9ecef;
            font-weight: bold;
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Specialized Patient Registration
                <small>Priority Care with Mandatory Triage & Consultation</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="#">Patient</a></li>
                <li class="active">Specialized Registration</li>
            </ol>
        </section>

        <section class="content">
            <!-- Specialized Header -->
            <div class="specialized-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-user-md"></i> Specialized Patient Registration</h3>
                        <p class="margin-bottom-none">Priority care with mandatory triage and consultation - Specialist department routing</p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="cost-display">
                            <i class="fa fa-money"></i> Registration Fee: KES 1,500
                        </div>
                    </div>
                </div>
            </div>

            <!-- Priority Notice -->
            <div class="priority-notice">
                <h4><i class="fa fa-exclamation-triangle"></i> Priority Care Pathway</h4>
                <p class="margin-bottom-none">Triage and consultation are mandatory. Additional services are optional based on specialist recommendations. This workflow ensures immediate assessment and appropriate specialist routing.</p>
            </div>

            <!-- Workflow Process -->
            <div class="box box-danger">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-route"></i> Specialized Workflow Process</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="workflow-step mandatory-step">
                                <div class="step-number">1</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-plus"></i> Registration <span class="label label-danger">MANDATORY</span></h6>
                                    <small>Patient details with presenting symptoms</small>
                                </div>
                            </div>
                            <div class="workflow-step mandatory-step">
                                <div class="step-number">2</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-stethoscope"></i> Priority Triage <span class="label label-danger">MANDATORY</span></h6>
                                    <small>Immediate health assessment and prioritization</small>
                                </div>
                            </div>
                            <div class="workflow-step mandatory-step">
                                <div class="step-number">3</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-md"></i> Specialist Consultation <span class="label label-danger">MANDATORY</span></h6>
                                    <small>Required specialist doctor consultation</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="workflow-step optional-step">
                                <div class="step-number">4</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-flask"></i> Laboratory Tests <span class="label label-default">OPTIONAL</span></h6>
                                    <small>As prescribed by specialist</small>
                                </div>
                            </div>
                            <div class="workflow-step optional-step">
                                <div class="step-number">5</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-pills"></i> Pharmacy Services <span class="label label-default">OPTIONAL</span></h6>
                                    <small>Medication dispensing if required</small>
                                </div>
                            </div>
                            <div class="workflow-step optional-step">
                                <div class="step-number">6</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-camera"></i> Radiology/Imaging <span class="label label-default">OPTIONAL</span></h6>
                                    <small>Medical imaging if ordered</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Registration Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-edit"></i> Patient Information</h3>
                </div>
                
                <form id="specializedForm" action="<?php echo base_url(); ?>admin/patient/add" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="workflow_type" value="specialized">
                    
                    <div class="box-body">
                        <!-- Basic Information -->
                        <h4><i class="fa fa-user"></i> Basic Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient Name <span class="required">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
                                </div>
                                
                                <div class="form-group">
                                    <label>Age <span class="required">*</span></label>
                                    <div class="row">
                                        <div class="col-xs-4">
                                            <input type="number" name="age[year]" class="form-control" placeholder="Years" min="0" max="120" required>
                                            <small class="text-muted">Years</small>
                                        </div>
                                        <div class="col-xs-4">
                                            <input type="number" name="age[month]" class="form-control" placeholder="Months" min="0" max="11" required>
                                            <small class="text-muted">Months</small>
                                        </div>
                                        <div class="col-xs-4">
                                            <input type="number" name="age[day]" class="form-control" placeholder="Days" min="0" max="30" required>
                                            <small class="text-muted">Days</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select name="gender" class="form-control">
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label>Mobile Number</label>
                                    <input type="tel" name="mobileno" class="form-control" placeholder="+254 700 000 000">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email Address</label>
                                    <input type="email" name="email" class="form-control" placeholder="patient@example.com">
                                </div>
                                
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea name="address" class="form-control" rows="2" placeholder="Patient residential address"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Patient Photo</label>
                                    <input type="file" name="file" class="form-control" accept="image/*">
                                    <small class="text-muted">Optional: Upload patient photo</small>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Chief Complaint Section -->
                        <div class="chief-complaint-section">
                            <h4><i class="fa fa-notes-medical"></i> Chief Complaint & Symptoms <span class="required">*</span></h4>
                            <p class="text-muted">Detailed description of symptoms is required for specialized triage and routing</p>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Chief Complaint / Presenting Symptoms <span class="required">*</span></label>
                                        <textarea name="chief_complaint" class="form-control" rows="4" 
                                                placeholder="Describe the primary reason for visit, main symptoms, duration, severity, and any relevant details..." required></textarea>
                                        <small class="text-muted">Required for mandatory triage assessment and specialist routing. Minimum 10 characters.</small>
                                        <div id="complaint_counter" class="text-right text-muted" style="margin-top: 5px;">
                                            <small>0 characters (minimum 10 required)</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Symptom Duration</label>
                                        <select name="symptom_duration" class="form-control">
                                            <option value="">Select Duration</option>
                                            <option value="acute">Acute (Less than 3 days)</option>
                                            <option value="subacute">Subacute (3 days - 3 weeks)</option>
                                            <option value="chronic">Chronic (More than 3 weeks)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Severity Level</label>
                                        <select name="severity_level" class="form-control">
                                            <option value="">Select Severity</option>
                                            <option value="mild">Mild - Minimal impact on daily activities</option>
                                            <option value="moderate">Moderate - Some limitation of activities</option>
                                            <option value="severe">Severe - Significant impact on function</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Priority Level Selection -->
                        <div class="priority-levels">
                            <h4><i class="fa fa-exclamation-triangle"></i> Priority Level</h4>
                            <p class="text-muted">Select the appropriate priority level based on patient condition</p>
                            
                            <div class="priority-option priority-routine" data-value="routine">
                                <strong><i class="fa fa-circle text-success"></i> Routine - Standard Appointment</strong>
                                <br><small>Non-urgent conditions, scheduled appointment within 1-2 weeks</small>
                            </div>
                            
                            <div class="priority-option priority-urgent" data-value="urgent">
                                <strong><i class="fa fa-circle text-warning"></i> Urgent - Same Day Required</strong>
                                <br><small>Conditions requiring attention within 24 hours</small>
                            </div>
                            
                            <div class="priority-option priority-emergency" data-value="emergency">
                                <strong><i class="fa fa-circle text-danger"></i> Emergency - Immediate Attention</strong>
                                <br><small>Life-threatening or severely debilitating conditions</small>
                            </div>
                            
                            <input type="hidden" name="priority_level" id="selected_priority" value="routine">
                        </div>

                        <hr>

                        <!-- Specialist Selection -->
                        <h4><i class="fa fa-user-md"></i> Specialist Department Selection</h4>
                        <p class="text-muted">Choose the most appropriate specialist department based on symptoms</p>
                        
                        <div class="specialist-grid">
                            <div class="specialist-option" data-value="cardiology">
                                <i class="fa fa-heartbeat"></i>
                                <strong>Cardiology</strong>
                                <small>Heart & Cardiovascular</small>
                            </div>
                            <div class="specialist-option" data-value="neurology">
                                <i class="fa fa-brain"></i>
                                <strong>Neurology</strong>
                                <small>Brain & Nervous System</small>
                            </div>
                            <div class="specialist-option" data-value="orthopedics">
                                <i class="fa fa-bone"></i>
                                <strong>Orthopedics</strong>
                                <small>Bones & Joints</small>
                            </div>
                            <div class="specialist-option" data-value="dermatology">
                                <i class="fa fa-hand-paper"></i>
                                <strong>Dermatology</strong>
                                <small>Skin & Hair</small>
                            </div>
                            <div class="specialist-option" data-value="pediatrics">
                                <i class="fa fa-child"></i>
                                <strong>Pediatrics</strong>
                                <small>Children's Health</small>
                            </div>
                            <div class="specialist-option" data-value="gynecology">
                                <i class="fa fa-female"></i>
                                <strong>Gynecology</strong>
                                <small>Women's Health</small>
                            </div>
                            <div class="specialist-option" data-value="psychiatry">
                                <i class="fa fa-head-side-virus"></i>
                                <strong>Psychiatry</strong>
                                <small>Mental Health</small>
                            </div>
                            <div class="specialist-option" data-value="ent">
                                <i class="fa fa-ear-listen"></i>
                                <strong>ENT</strong>
                                <small>Ear, Nose & Throat</small>
                            </div>
                            <div class="specialist-option" data-value="ophthalmology">
                                <i class="fa fa-eye"></i>
                                <strong>Ophthalmology</strong>
                                <small>Eye Care</small>
                            </div>
                            <div class="specialist-option" data-value="general">
                                <i class="fa fa-user-md"></i>
                                <strong>General Medicine</strong>
                                <small>Internal Medicine</small>
                            </div>
                        </div>
                        <input type="hidden" name="preferred_specialist" id="selected_specialist">

                        <hr>

                        <!-- Mandatory and Optional Services -->
                        <h4><i class="fa fa-list-check"></i> Required & Optional Services</h4>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Mandatory Services</h5>
                                <div class="service-checkbox">
                                    <input type="checkbox" name="mandatory_services[]" value="triage" id="spec_triage" checked disabled>
                                    <label for="spec_triage">
                                        <strong><i class="fa fa-stethoscope"></i> Mandatory Triage</strong>
                                        <br><small class="text-muted">Priority assessment and vital signs monitoring</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="mandatory_services[]" value="consultation" id="spec_consultation" checked disabled>
                                    <label for="spec_consultation">
                                        <strong><i class="fa fa-user-md"></i> Required Consultation</strong>
                                        <br><small class="text-muted">Specialist doctor examination and diagnosis</small>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5>Optional Services</h5>
                                <div class="service-checkbox">
                                    <input type="checkbox" name="optional_services[]" value="laboratory" id="spec_lab">
                                    <label for="spec_lab">
                                        <strong><i class="fa fa-flask"></i> Laboratory Tests</strong>
                                        <br><small class="text-muted">Blood work, cultures, pathology</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="optional_services[]" value="pharmacy" id="spec_pharmacy">
                                    <label for="spec_pharmacy">
                                        <strong><i class="fa fa-pills"></i> Pharmacy Services</strong>
                                        <br><small class="text-muted">Medication dispensing and counseling</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="optional_services[]" value="radiology" id="spec_radiology">
                                    <label for="spec_radiology">
                                        <strong><i class="fa fa-camera"></i> Radiology/Imaging</strong>
                                        <br><small class="text-muted">X-rays, MRI, CT scans, ultrasound</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Additional Medical Information -->
                        <h4><i class="fa fa-info-circle"></i> Additional Medical Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Previous Medical History</label>
                                    <textarea name="medical_history" class="form-control" rows="3" placeholder="Relevant previous conditions, surgeries, hospitalizations"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Known Allergies</label>
                                    <textarea name="allergies" class="form-control" rows="2" placeholder="Drug allergies, food allergies, environmental allergies"></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Current Medications</label>
                                    <textarea name="current_medications" class="form-control" rows="3" placeholder="List current medications and dosages"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Emergency Contact</label>
                                    <input type="text" name="emergency_contact" class="form-control" placeholder="Name and phone number">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Patient List
                                </a>
                            </div>
                            <div class="col-md-6 text-right">
                                <button type="submit" class="btn btn-specialized btn-lg">
                                    <i class="fa fa-save"></i> Register Specialized Patient
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Navigation Links -->
            <div class="box box-default">
                <div class="box-header">
                    <h3 class="box-title">Other Registration Types</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/gcc_registration" class="btn btn-success btn-block btn-lg">
                                <i class="fa fa-globe"></i> GCC Process<br>
                                <small>KES 10,500</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/general_registration" class="btn btn-info btn-block btn-lg">
                                <i class="fa fa-users"></i> General Process<br>
                                <small>KES 900</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default btn-block btn-lg">
                                <i class="fa fa-list"></i> Patient Dashboard<br>
                                <small>View All Patients</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>

<script>
$(document).ready(function() {
    // =============================================
    // SPECIALIST SELECTION FUNCTIONALITY
    // =============================================
    
    $('.specialist-option').on('click', function() {
        // Remove selection from all options
        $('.specialist-option').removeClass('selected');
        
        // Add selection to clicked option
        $(this).addClass('selected');
        
        // Update hidden input
        const specialistValue = $(this).data('value');
        $('#selected_specialist').val(specialistValue);
        
        console.log('Selected specialist:', specialistValue);
        
        // Show confirmation
        const specialistName = $(this).find('strong').text();
        $(this).append('<div class="text-center" style="margin-top: 5px;"><small><i class="fa fa-check"></i> Selected</small></div>');
        
        setTimeout(() => {
            $(this).find('small:last').remove();
        }, 2000);
    });

    // =============================================
    // PRIORITY LEVEL SELECTION
    // =============================================
    
    $('.priority-option').on('click', function() {
        // Remove selection from all options
        $('.priority-option').removeClass('selected');
        
        // Add selection to clicked option
        $(this).addClass('selected');
        
        // Update hidden input
        const priorityValue = $(this).data('value');
        $('#selected_priority').val(priorityValue);
        
        console.log('Selected priority:', priorityValue);
        
        // Show priority-specific alert
        if (priorityValue === 'emergency') {
            alert('Emergency priority selected. Patient will be routed for immediate triage and specialist attention.');
        } else if (priorityValue === 'urgent') {
            alert('Urgent priority selected. Patient will be scheduled for same-day assessment.');
        }
    });

    // =============================================
    // CHIEF COMPLAINT VALIDATION
    // =============================================
    
    $('textarea[name="chief_complaint"]').on('input', function() {
        const length = $(this).val().length;
        const minLength = 10;
        
        // Update character counter
        $('#complaint_counter small').text(length + ' characters (minimum ' + minLength + ' required)');
        
        // Color coding
        if (length < minLength) {
            $(this).css('border-color', '#dd4b39');
            $('#complaint_counter').removeClass('text-success').addClass('text-danger');
        } else {
            $(this).css('border-color', '#00a65a');
            $('#complaint_counter').removeClass('text-danger').addClass('text-success');
        }
    });

    // =============================================
    // FORM SUBMISSION HANDLER
    // =============================================
    
$('#specializedForm').on('submit', function(e) {
    e.preventDefault();
    
    // Validate required fields
    const name = $('input[name="name"]').val().trim();
    const ageYear = $('input[name="age[year]"]').val();
    const chiefComplaint = $('textarea[name="chief_complaint"]').val().trim();
    
    if (!name) {
        alert('Patient name is required');
        $('input[name="name"]').focus();
        return false;
    }
    
    if (!ageYear || ageYear <= 0) {
        alert('Valid age is required');
        $('input[name="age[year]"]').focus();
        return false;
    }
    
    if (!chiefComplaint || chiefComplaint.length < 10) {
        alert('Chief complaint is required (minimum 10 characters)');
        $('textarea[name="chief_complaint"]').focus();
        return false;
    }
    
    // Show loading state
    const submitBtn = $(this).find('button[type="submit"]');
    const originalText = submitBtn.html();
    submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Registering...').prop('disabled', true);
    
    // Prepare form data
    const formData = new FormData(this);
    
    // Debug: Log form data
    console.log('=== Form Submission Debug ===');
    for (let pair of formData.entries()) {
        console.log(pair[0] + ':', pair[1]);
    }
    
    // Submit form
    $.ajax({
        url: $(this).attr('action'),
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json', // Expect JSON response
        success: function(response) {
            console.log('Success Response:', response);
            
            if (response && response.status === 'success') {
                let message = 'Specialized Patient Registered Successfully!\n\n';
                message += 'Patient ID: ' + response.patient_id + '\n';
                message += 'Workflow: ' + response.workflow_type + '\n';
                
                if (response.next_step) {
                    message += 'Next Step: ' + response.next_step + '\n';
                }
                
                if (response.specialist_dept) {
                    message += 'Specialist Department: ' + response.specialist_dept + '\n';
                }
                
                if (response.priority_level) {
                    message += 'Priority Level: ' + response.priority_level;
                }
                
                alert(message);
                
                // Reset form
                $('#specializedForm')[0].reset();
                $('.specialist-option').removeClass('selected');
                $('.priority-option').removeClass('selected');
                $('.priority-routine').addClass('selected');
                $('#selected_specialist').val('');
                $('#selected_priority').val('routine');
                
            } else {
                console.log('Error Response:', response);
                
                let errorMsg = 'Registration Failed:\n\n';
                
                if (response && response.error) {
                    if (typeof response.error === 'object') {
                        for (let field in response.error) {
                            if (response.error[field]) {
                                errorMsg += field + ': ' + response.error[field] + '\n';
                            }
                        }
                    } else {
                        errorMsg += response.error + '\n';
                    }
                } else if (response && response.message) {
                    errorMsg += response.message;
                } else {
                    errorMsg += 'Unknown error occurred';
                }
                
                alert(errorMsg);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', {
                status: status,
                error: error,
                responseText: xhr.responseText,
                statusCode: xhr.status
            });
            
            let errorMessage = 'Server Error:\n\n';
            
            if (xhr.status === 404) {
                errorMessage += 'Method not found (404)\nCheck if admin/patient/add exists';
            } else if (xhr.status === 500) {
                errorMessage += 'Server error (500)\nCheck PHP error logs';
                if (xhr.responseText) {
                    errorMessage += '\n\nServer Response:\n' + xhr.responseText.substring(0, 300);
                }
            } else if (xhr.status === 0) {
                errorMessage += 'Network error or CORS issue';
            } else {
                errorMessage += 'HTTP ' + xhr.status + ': ' + error;
            }
            
            alert(errorMessage);
        },
        complete: function() {
            submitBtn.html(originalText).prop('disabled', false);
        }
    });
});

    // =============================================
    // SERVICE SELECTION TRACKING
    // =============================================
    
    $('input[name="optional_services[]"]').on('change', function() {
        const selectedServices = [];
        $('input[name="optional_services[]"]:checked').each(function() {
            selectedServices.push($(this).val());
        });
        
        console.log('Selected optional services:', selectedServices);
    });

    // =============================================
    // AGE CALCULATION HELPER
    // =============================================
    
    $('input[name^="age"]').on('change', function() {
        const year = parseInt($('input[name="age[year]"]').val()) || 0;
        const month = parseInt($('input[name="age[month]"]').val()) || 0;
        const day = parseInt($('input[name="age[day]"]').val()) || 0;
        
        if (year > 0 || month > 0 || day > 0) {
            console.log('Patient Age: ' + year + ' years, ' + month + ' months, ' + day + ' days');
            
            // Auto-suggest specialist based on age
            if (year < 18) {
                console.log('Patient is a minor - consider Pediatrics');
            } else if (year >= 65) {
                console.log('Patient is elderly - consider Geriatrics or General Medicine');
            }
        }
    });

    // =============================================
    // FORM VALIDATION HELPERS
    // =============================================
    
    window.validateSpecializedForm = function() {
        console.log('=== Specialized Form Validation ===');
        
        const name = $('input[name="name"]').val();
        const ageYear = $('input[name="age[year]"]').val();
        const ageMonth = $('input[name="age[month]"]').val();
        const ageDay = $('input[name="age[day]"]').val();
        const chiefComplaint = $('textarea[name="chief_complaint"]').val();
        const selectedSpecialist = $('#selected_specialist').val();
        const selectedPriority = $('#selected_priority').val();
        
        console.log('Required Fields:');
        console.log('- Name:', name || 'MISSING');
        console.log('- Age (Year):', ageYear || 'MISSING');
        console.log('- Age (Month):', ageMonth || 'MISSING');
        console.log('- Age (Day):', ageDay || 'MISSING');
        console.log('- Chief Complaint:', chiefComplaint ? (chiefComplaint.length + ' chars') : 'MISSING');
        console.log('- Selected Specialist:', selectedSpecialist || 'NONE');
        console.log('- Selected Priority:', selectedPriority || 'NONE');
        
        const missingFields = [];
        if (!name) missingFields.push('Name');
        if (!ageYear) missingFields.push('Age Year');
        if (!ageMonth) missingFields.push('Age Month');
        if (!ageDay) missingFields.push('Age Day');
        if (!chiefComplaint || chiefComplaint.length < 10) missingFields.push('Chief Complaint');
        
        if (missingFields.length > 0) {
            console.log('MISSING REQUIRED FIELDS:', missingFields);
            return false;
        } else {
            console.log('✓ All required fields present');
            return true;
        }
    };

    // =============================================
    // SPECIALIST RECOMMENDATION SYSTEM
    // =============================================
    
    window.suggestSpecialist = function() {
        const complaint = $('textarea[name="chief_complaint"]').val().toLowerCase();
        const suggestions = [];
        
        // Simple keyword-based suggestions
        if (complaint.includes('chest pain') || complaint.includes('heart') || complaint.includes('palpitation')) {
            suggestions.push('cardiology');
        }
        if (complaint.includes('headache') || complaint.includes('seizure') || complaint.includes('numbness')) {
            suggestions.push('neurology');
        }
        if (complaint.includes('joint pain') || complaint.includes('back pain') || complaint.includes('fracture')) {
            suggestions.push('orthopedics');
        }
        if (complaint.includes('skin') || complaint.includes('rash') || complaint.includes('itching')) {
            suggestions.push('dermatology');
        }
        if (complaint.includes('eye') || complaint.includes('vision') || complaint.includes('blurred')) {
            suggestions.push('ophthalmology');
        }
        if (complaint.includes('ear') || complaint.includes('throat') || complaint.includes('nose')) {
            suggestions.push('ent');
        }
        
        if (suggestions.length > 0) {
            console.log('Suggested specialists based on symptoms:', suggestions);
            
            // Highlight suggested specialists
            $('.specialist-option').removeClass('suggested');
            suggestions.forEach(specialist => {
                $(`.specialist-option[data-value="${specialist}"]`).addClass('suggested');
            });
        }
        
        return suggestions;
    };

    // Auto-suggest when chief complaint changes
    $('textarea[name="chief_complaint"]').on('blur', function() {
        if ($(this).val().length > 10) {
            suggestSpecialist();
        }
    });

    // Initialize form
    $('.priority-routine').addClass('selected'); // Default priority
    $('#selected_priority').val('routine');
    
    console.log('Specialized patient registration form initialized');
});
</script>

</body>
</html>