<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>General Patient Registration</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper {
            background-color: #ecf0f5;
        }
        
        .general-header {
            background: linear-gradient(135deg, #3c8dbc 0%, #00c0ef 100%);
            color: white;
            padding: 20px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .flexibility-notice {
            background: #fcf8e3;
            border: 1px solid #faebcc;
            color: #8a6d3b;
            padding: 15px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .service-item {
            padding: 12px 15px;
            border-bottom: 1px solid #f4f4f4;
            display: flex;
            align-items: center;
            transition: background-color 0.3s ease;
        }
        
        .service-item:last-child {
            border-bottom: none;
        }
        
        .service-item:hover {
            background-color: #f8f9fa;
        }
        
        .service-icon {
            width: 40px;
            text-align: center;
            margin-right: 15px;
            font-size: 18px;
            color: #3c8dbc;
        }
        
        .service-content h6 {
            margin: 0 0 3px 0;
            color: #333;
            font-weight: 600;
        }
        
        .service-content small {
            color: #777;
        }
        
        .service-checkbox {
            background: white;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 12px;
            margin: 8px 0;
            transition: all 0.3s ease;
        }
        
        .service-checkbox:hover {
            border-color: #3c8dbc;
            background-color: #f8f9fa;
        }
        
        .service-checkbox input[type="checkbox"]:checked + label {
            font-weight: bold;
            color: #3c8dbc;
        }
        
        .required {
            color: #dd4b39;
        }
        
        .btn-general {
            background-color: #3c8dbc;
            border-color: #3c8dbc;
            color: white;
        }
        
        .btn-general:hover {
            background-color: #367fa9;
            border-color: #367fa9;
            color: white;
        }
        
        .cost-display {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 8px 15px;
            border-radius: 15px;
            font-weight: bold;
            text-align: center;
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                General Patient Registration
                <small>Standard Outpatient Care - Flexible Service Selection</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="#">Patient</a></li>
                <li class="active">General Registration</li>
            </ol>
        </section>

        <section class="content">
            <!-- General Header -->
            <div class="general-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-users"></i> General Patient Registration</h3>
                        <p class="margin-bottom-none">Standard outpatient care with flexible service selection - No biometric requirements</p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="cost-display">
                            <i class="fa fa-money"></i> Registration Fee: KES 900
                        </div>
                    </div>
                </div>
            </div>

            <!-- Flexibility Notice -->
            <div class="flexibility-notice">
                <h4><i class="fa fa-lightbulb-o"></i> Flexible Care Pathway</h4>
                <p class="margin-bottom-none">All services are optional and can be selected based on patient needs. This workflow provides maximum flexibility for standard outpatient care without requiring biometric capture.</p>
            </div>

            <!-- Available Services -->
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-cogs"></i> Available Services</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="service-item">
                                <div class="service-icon">
                                    <i class="fa fa-user-plus"></i>
                                </div>
                                <div class="service-content">
                                    <h6>Registration <span class="label label-danger">Required</span></h6>
                                    <small>Basic patient information entry</small>
                                </div>
                            </div>
                            <div class="service-item">
                                <div class="service-icon">
                                    <i class="fa fa-stethoscope"></i>
                                </div>
                                <div class="service-content">
                                    <h6>Optional Triage <span class="label label-default">Optional</span></h6>
                                    <small>Health screening if needed</small>
                                </div>
                            </div>
                            <div class="service-item">
                                <div class="service-icon">
                                    <i class="fa fa-user-md"></i>
                                </div>
                                <div class="service-content">
                                    <h6>Optional Consultation <span class="label label-default">Optional</span></h6>
                                    <small>Doctor consultation as required</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="service-item">
                                <div class="service-icon">
                                    <i class="fa fa-flask"></i>
                                </div>
                                <div class="service-content">
                                    <h6>Optional Laboratory <span class="label label-default">Optional</span></h6>
                                    <small>Lab tests if prescribed</small>
                                </div>
                            </div>
                            <div class="service-item">
                                <div class="service-icon">
                                    <i class="fa fa-camera"></i>
                                </div>
                                <div class="service-content">
                                    <h6>Optional Radiology <span class="label label-default">Optional</span></h6>
                                    <small>Medical imaging if needed</small>
                                </div>
                            </div>
                            <div class="service-item">
                                <div class="service-icon">
                                    <i class="fa fa-pills"></i>
                                </div>
                                <div class="service-content">
                                    <h6>Optional Pharmacy <span class="label label-default">Optional</span></h6>
                                    <small>Medication dispensing</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Registration Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-edit"></i> Patient Information</h3>
                </div>
                
                <form id="generalForm" action="<?php echo base_url(); ?>admin/patient/add" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="workflow_type" value="general">
                    
                    <div class="box-body">
                        <!-- Basic Information -->
                        <h4><i class="fa fa-user"></i> Basic Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient Name <span class="required">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
                                </div>
                                
                                <div class="form-group">
                                    <label>Age <span class="required">*</span></label>
                                    <div class="row">
                                        <div class="col-xs-4">
                                            <input type="number" name="age[year]" class="form-control" placeholder="Years" min="0" max="120" required>
                                            <small class="text-muted">Years</small>
                                        </div>
                                        <div class="col-xs-4">
                                            <input type="number" name="age[month]" class="form-control" placeholder="Months" min="0" max="11" required>
                                            <small class="text-muted">Months</small>
                                        </div>
                                        <div class="col-xs-4">
                                            <input type="number" name="age[day]" class="form-control" placeholder="Days" min="0" max="30" required>
                                            <small class="text-muted">Days</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select name="gender" class="form-control">
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label>Mobile Number</label>
                                    <input type="tel" name="mobileno" class="form-control" placeholder="+254 700 000 000">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email Address</label>
                                    <input type="email" name="email" class="form-control" placeholder="patient@example.com">
                                </div>
                                
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea name="address" class="form-control" rows="3" placeholder="Patient residential address"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Patient Photo</label>
                                    <input type="file" name="file" class="form-control" accept="image/*">
                                    <small class="text-muted">Optional: Upload patient photo</small>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Optional Services Selection -->
                        <h4><i class="fa fa-list-check"></i> Optional Services Selection</h4>
                        <p class="text-muted">Select the services this patient may require during their visit</p>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="triage" id="general_triage">
                                    <label for="general_triage">
                                        <strong><i class="fa fa-stethoscope"></i> Triage Assessment</strong>
                                        <br><small class="text-muted">Initial health screening and vital signs</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="consultation" id="general_consultation">
                                    <label for="general_consultation">
                                        <strong><i class="fa fa-user-md"></i> Doctor Consultation</strong>
                                        <br><small class="text-muted">General practitioner consultation</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="laboratory" id="general_lab">
                                    <label for="general_lab">
                                        <strong><i class="fa fa-flask"></i> Laboratory Tests</strong>
                                        <br><small class="text-muted">Blood tests, urine analysis, etc.</small>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="radiology" id="general_radiology">
                                    <label for="general_radiology">
                                        <strong><i class="fa fa-camera"></i> Radiology/Imaging</strong>
                                        <br><small class="text-muted">X-rays, ultrasound, CT scans</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="pharmacy" id="general_pharmacy">
                                    <label for="general_pharmacy">
                                        <strong><i class="fa fa-pills"></i> Pharmacy Services</strong>
                                        <br><small class="text-muted">Medication dispensing and counseling</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="booking" id="general_booking">
                                    <label for="general_booking">
                                        <strong><i class="fa fa-calendar-check-o"></i> Appointment Booking</strong>
                                        <br><small class="text-muted">Schedule follow-up appointments</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Additional Information -->
                        <h4><i class="fa fa-info-circle"></i> Additional Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Medical History</label>
                                    <textarea name="medical_history" class="form-control" rows="3" placeholder="Brief medical history (optional)"></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Known Allergies</label>
                                    <textarea name="allergies" class="form-control" rows="3" placeholder="Known allergies (optional)"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Patient List
                                </a>
                            </div>
                            <div class="col-md-6 text-right">
                                <button type="submit" class="btn btn-general btn-lg">
                                    <i class="fa fa-save"></i> Register General Patient
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Navigation Links -->
            <div class="box box-default">
                <div class="box-header">
                    <h3 class="box-title">Other Registration Types</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/gcc_registration" class="btn btn-success btn-block btn-lg">
                                <i class="fa fa-globe"></i> GCC Process<br>
                                <small>KES 10,500</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/specialized_registration" class="btn btn-danger btn-block btn-lg">
                                <i class="fa fa-user-md"></i> Specialized Process<br>
                                <small>KES 1,500</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default btn-block btn-lg">
                                <i class="fa fa-list"></i> Patient Dashboard<br>
                                <small>View All Patients</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>

<script>
$(document).ready(function() {
    // Form submission handler
    $('#generalForm').on('submit', function(e) {
        e.preventDefault();
        
        // Show loading state
        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();
        submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Registering...').prop('disabled', true);
        
        // Submit form via AJAX
        const formData = new FormData(this);
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(data) {
                try {
                    const response = typeof data === 'string' ? JSON.parse(data) : data;
                    
                    if (response.status === 'success') {
                        // Get selected services
                        const selectedServices = [];
                        $('input[name="services[]"]:checked').each(function() {
                            selectedServices.push($(this).val());
                        });
                        
                        let message = 'General Patient registered successfully!\n';
                        message += 'Patient ID: ' + response.patient_id + '\n';
                        message += 'Workflow: ' + response.workflow_type + '\n';
                        if (selectedServices.length > 0) {
                            message += 'Selected Services: ' + selectedServices.join(', ');
                        }
                        
                        alert(message);
                        
                        // Reset form
                        $('#generalForm')[0].reset();
                        
                    } else {
                        let errorMsg = 'General Registration failed:\n';
                        if (response.error) {
                            for (let field in response.error) {
                                if (response.error[field]) {
                                    errorMsg += '- ' + response.error[field] + '\n';
                                }
                            }
                        }
                        alert(errorMsg);
                    }
                } catch (e) {
                    console.error('Error parsing response:', e);
                    alert('An unexpected error occurred during registration.');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                alert('An error occurred during general registration. Please try again.');
            },
            complete: function() {
                submitBtn.html(originalText).prop('disabled', false);
            }
        });
    });

    // Service selection tracking
    $('input[name="services[]"]').on('change', function() {
        const selectedServices = [];
        $('input[name="services[]"]:checked').each(function() {
            selectedServices.push($(this).val());
        });
        
        console.log('Selected services:', selectedServices);
        
        // Update UI based on selections if needed
        if (selectedServices.length > 0) {
            $('.box-footer').addClass('bg-light-blue');
        } else {
            $('.box-footer').removeClass('bg-light-blue');
        }
    });

    // Age calculation helper
    $('input[name^="age"]').on('change', function() {
        const year = parseInt($('input[name="age[year]"]').val()) || 0;
        const month = parseInt($('input[name="age[month]"]').val()) || 0;
        const day = parseInt($('input[name="age[day]"]').val()) || 0;
        
        if (year > 0 || month > 0 || day > 0) {
            console.log('Patient Age: ' + year + ' years, ' + month + ' months, ' + day + ' days');
        }
    });
});
</script>

</body>
</html>