<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-heartbeat"></i> Nursing Vital Signs
            <small>Patient Vital Signs Records</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/nursing">Nursing</a></li>
            <li class="active">Vital Signs</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Patient Header -->
        <?php if (isset($patient) && !empty($patient)): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-user"></i> Patient Information
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-bordered table-condensed">
                                    <tr>
                                        <td width="30%"><strong>Name:</strong></td>
                                        <td><?php echo $patient['patient_name']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Patient ID:</strong></td>
                                        <td><?php echo $patient['patient_unique_id'] ?? $patient['id']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Age:</strong></td>
                                        <td><?php echo $patient['age_display'] ?? 'N/A'; ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-bordered table-condensed">
                                    <tr>
                                        <td width="30%"><strong>Gender:</strong></td>
                                        <td><?php echo $patient['gender']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Contact:</strong></td>
                                        <td><?php echo $patient['mobileno'] ?? 'N/A'; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td>
                                            <?php if ($patient['is_ipd']): ?>
                                                <span class="label label-success">IPD Patient</span>
                                            <?php else: ?>
                                                <span class="label label-info">OPD Patient</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Vital Signs Records -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-heartbeat"></i> Vital Signs History
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if (isset($patient) && !empty($patient)): ?>
                            <button type="button" class="btn btn-primary btn-sm" onclick="addVitalSigns()">
                                <i class="fa fa-plus"></i> Add Vital Signs
                            </button>
                            <?php endif; ?>
                            <button type="button" class="btn btn-default btn-sm" onclick="refreshVitalSigns()">
                                <i class="fa fa-refresh"></i> Refresh
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (empty($vital_signs)): ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No vital signs records found.
                                <?php if (isset($patient) && !empty($patient)): ?>
                                    <button type="button" class="btn btn-sm btn-primary" onclick="addVitalSigns()" style="margin-left: 10px;">
                                        <i class="fa fa-plus"></i> Add First Record
                                    </button>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="vitalSignsTable">
                                    <thead>
                                        <tr>
                                            <th>Date & Time</th>
                                            <th>Temperature</th>
                                            <th>Blood Pressure</th>
                                            <th>Pulse</th>
                                            <th>Resp Rate</th>
                                            <th>O2 Sat</th>
                                            <th>Pain Scale</th>
                                            <th>BMI</th>
                                            <th>Recorded By</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($vital_signs as $vital): ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo date('M j, Y', strtotime($vital['recorded_at'])); ?></strong><br>
                                                <small class="text-muted"><?php echo date('g:i A', strtotime($vital['recorded_at'])); ?></small>
                                            </td>
                                            <td>
                                                <?php if ($vital['temperature']): ?>
                                                    <span class="badge <?php echo $vital['temperature'] > 38 ? 'bg-red' : ($vital['temperature'] < 36 ? 'bg-blue' : 'bg-green'); ?>">
                                                        <?php echo $vital['temperature']; ?>°<?php echo $vital['temperature_unit']; ?>
                                                    </span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($vital['systolic_bp'] && $vital['diastolic_bp']): ?>
                                                    <span class="badge <?php echo ($vital['systolic_bp'] > 140 || $vital['diastolic_bp'] > 90) ? 'bg-red' : 'bg-green'; ?>">
                                                        <?php echo $vital['systolic_bp']; ?>/<?php echo $vital['diastolic_bp']; ?>
                                                    </span>
                                                    <small class="text-muted">mmHg</small>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($vital['pulse_rate']): ?>
                                                    <span class="badge <?php echo ($vital['pulse_rate'] > 100 || $vital['pulse_rate'] < 60) ? 'bg-yellow' : 'bg-green'; ?>">
                                                        <?php echo $vital['pulse_rate']; ?>
                                                    </span>
                                                    <small class="text-muted">bpm</small>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($vital['respiratory_rate']): ?>
                                                    <span class="badge <?php echo ($vital['respiratory_rate'] > 20 || $vital['respiratory_rate'] < 12) ? 'bg-yellow' : 'bg-green'; ?>">
                                                        <?php echo $vital['respiratory_rate']; ?>
                                                    </span>
                                                    <small class="text-muted">/min</small>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($vital['oxygen_saturation']): ?>
                                                    <span class="badge <?php echo $vital['oxygen_saturation'] < 95 ? 'bg-red' : 'bg-green'; ?>">
                                                        <?php echo $vital['oxygen_saturation']; ?>%
                                                    </span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($vital['pain_scale'] !== null): ?>
                                                    <span class="badge <?php echo $vital['pain_scale'] > 7 ? 'bg-red' : ($vital['pain_scale'] > 4 ? 'bg-yellow' : 'bg-green'); ?>">
                                                        <?php echo $vital['pain_scale']; ?>/10
                                                    </span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($vital['bmi']): ?>
                                                    <span class="badge <?php echo ($vital['bmi'] > 30 || $vital['bmi'] < 18.5) ? 'bg-yellow' : 'bg-green'; ?>">
                                                        <?php echo $vital['bmi']; ?>
                                                    </span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo $vital['recorded_by_name'] ?? 'Unknown'; ?>
                                                <?php if ($vital['recorded_by_surname']): ?>
                                                    <?php echo $vital['recorded_by_surname']; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-xs btn-info" onclick="viewVitalDetails(<?php echo $vital['id']; ?>)">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-xs btn-warning" onclick="editVitalSigns(<?php echo $vital['id']; ?>)">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-xs btn-danger" onclick="deleteVitalSigns(<?php echo $vital['id']; ?>)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Vital Signs Chart -->
        <?php if (!empty($vital_signs)): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-line-chart"></i> Vital Signs Trends
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="chart">
                            <canvas id="vitalSignsChart" style="height: 300px;"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </section>
</div>

<!-- Add Vital Signs Modal -->
<div class="modal fade" id="addVitalSignsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-heartbeat"></i> Add Vital Signs
                </h4>
            </div>
            <form id="addVitalSignsForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Temperature (°C) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="temperature" step="0.1" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Pulse Rate (bpm) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="pulse_rate" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Systolic BP (mmHg) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="systolic_bp" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Diastolic BP (mmHg) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="diastolic_bp" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Respiratory Rate (/min) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="respiratory_rate" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Oxygen Saturation (%)</label>
                                <input type="number" class="form-control" name="oxygen_saturation">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Weight (kg)</label>
                                <input type="number" class="form-control" name="weight" step="0.1">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Height (cm)</label>
                                <input type="number" class="form-control" name="height">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Pain Scale (0-10)</label>
                                <select class="form-control" name="pain_scale">
                                    <option value="">Select</option>
                                    <?php for ($i = 0; $i <= 10; $i++): ?>
                                        <option value="<?php echo $i; ?>"><?php echo $i; ?> - <?php echo $i == 0 ? 'No Pain' : ($i <= 3 ? 'Mild' : ($i <= 6 ? 'Moderate' : ($i <= 8 ? 'Severe' : 'Worst'))); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Clinical Notes</label>
                        <textarea class="form-control" name="notes" rows="3" placeholder="Additional observations or clinical notes..."></textarea>
                    </div>
                    <input type="hidden" name="patient_id" value="<?php echo $patient['id'] ?? ''; ?>">
                    <input type="hidden" name="ipd_id" value="<?php echo $patient['ipd_id'] ?? ''; ?>">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Vital Signs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Vital Details Modal -->
<div class="modal fade" id="viewVitalDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> Vital Signs Details
                </h4>
            </div>
            <div class="modal-body" id="vitalDetailsContent">
                <!-- Content will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    if ($('#vitalSignsTable').length) {
        $('#vitalSignsTable').DataTable({
            "order": [[ 0, "desc" ]],
            "pageLength": 25,
            "responsive": true
        });
    }
    
    // Initialize Chart
    <?php if (!empty($vital_signs)): ?>
    initializeVitalSignsChart();
    <?php endif; ?>
});

// Add vital signs
function addVitalSigns() {
    $('#addVitalSignsModal').modal('show');
}

// Submit vital signs form
$('#addVitalSignsForm').on('submit', function(e) {
    e.preventDefault();
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/add_vital_signs"); ?>',
        type: 'POST',
        data: $(this).serialize(),
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                $('#addVitalSignsModal').modal('hide');
                $('#addVitalSignsForm')[0].reset();
                location.reload();
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function() {
            alert('Failed to save vital signs');
        }
    });
});

// View vital details
function viewVitalDetails(vitalId) {
    $.ajax({
        url: '<?php echo base_url("admin/nursing/get_vital_details"); ?>',
        type: 'POST',
        data: {vital_id: vitalId},
        success: function(response) {
            $('#vitalDetailsContent').html(response);
            $('#viewVitalDetailsModal').modal('show');
        },
        error: function() {
            alert('Failed to load vital details');
        }
    });
}

// Edit vital signs
function editVitalSigns(vitalId) {
    // Implementation for editing
    alert('Edit functionality will be implemented');
}

// Delete vital signs
function deleteVitalSigns(vitalId) {
    if (confirm('Are you sure you want to delete this vital signs record?')) {
        $.ajax({
            url: '<?php echo base_url("admin/nursing/delete_vital_signs"); ?>',
            type: 'POST',
            data: {vital_id: vitalId},
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Failed to delete vital signs');
            }
        });
    }
}

// Refresh vital signs
function refreshVitalSigns() {
    location.reload();
}

// Initialize vital signs chart
function initializeVitalSignsChart() {
    var ctx = document.getElementById('vitalSignsChart').getContext('2d');
    
    // Prepare chart data
    var dates = [];
    var temperatures = [];
    var systolicBP = [];
    var diastolicBP = [];
    var pulseRates = [];
    
    <?php foreach (array_reverse($vital_signs) as $vital): ?>
        dates.push('<?php echo date('M j', strtotime($vital['recorded_at'])); ?>');
        temperatures.push(<?php echo $vital['temperature'] ?: 'null'; ?>);
        systolicBP.push(<?php echo $vital['systolic_bp'] ?: 'null'; ?>);
        diastolicBP.push(<?php echo $vital['diastolic_bp'] ?: 'null'; ?>);
        pulseRates.push(<?php echo $vital['pulse_rate'] ?: 'null'; ?>);
    <?php endforeach; ?>
    
    var chart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: dates,
            datasets: [
                {
                    label: 'Temperature (°C)',
                    data: temperatures,
                    borderColor: 'rgb(255, 99, 132)',
                    backgroundColor: 'rgba(255, 99, 132, 0.2)',
                    yAxisID: 'y1'
                },
                {
                    label: 'Systolic BP',
                    data: systolicBP,
                    borderColor: 'rgb(54, 162, 235)',
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    yAxisID: 'y2'
                },
                {
                    label: 'Pulse Rate',
                    data: pulseRates,
                    borderColor: 'rgb(255, 205, 86)',
                    backgroundColor: 'rgba(255, 205, 86, 0.2)',
                    yAxisID: 'y2'
                }
            ]
        },
        options: {
            responsive: true,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            scales: {
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    min: 35,
                    max: 42,
                    title: {
                        display: true,
                        text: 'Temperature (°C)'
                    }
                },
                y2: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    min: 40,
                    max: 180,
                    title: {
                        display: true,
                        text: 'BP/Pulse'
                    },
                    grid: {
                        drawOnChartArea: false,
                    },
                }
            }
        }
    });
}
</script>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>