<div class="content-wrapper">
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo $this->lang->line('nurse_assignments'); ?></h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('nurse_assignment', 'can_add')) { ?>
                                <a onclick="addAssignment()" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> <?php echo $this->lang->line('assign_nurse'); ?></a>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover ajaxlist" data-export-title="<?php echo $this->lang->line('nurse_assignments'); ?>">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('ward'); ?></th>
                                        <th><?php echo $this->lang->line('nurse_name'); ?></th>
                                        <th><?php echo $this->lang->line('assigned_date'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($assignments as $assignment) { ?>
                                        <tr>
                                            <td><?php echo $assignment['ward_name']; ?></td>
                                            <td><?php echo $assignment['nurse_name']; ?></td>
                                            <td><?php echo date($this->customlib->getHospitalDateFormat(), strtotime($assignment['assigned_date'])); ?></td>
                                            <td>
                                                <span class="label label-<?php echo ($assignment['status'] == 'active') ? 'success' : 'danger'; ?>">
                                                    <?php echo $assignment['status']; ?>
                                                </span>
                                            </td>
                                            <td class="text-right">
                                                <?php if ($this->rbac->hasPrivilege('nurse_assignment', 'can_edit')) { ?>
                                                    <a onclick="editAssignment('<?php echo $assignment["id"]; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                <?php } ?>
                                                <?php if ($this->rbac->hasPrivilege('nurse_assignment', 'can_delete')) { ?>
                                                    <a onclick="deleteAssignment('<?php echo $assignment["id"]; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" title="<?php echo $this->lang->line('delete'); ?>">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Assignment Modal -->
<div id="addAssignmentModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('assign_nurse'); ?></h4>
            </div>
            <form id="addAssignmentForm" method="post" action="<?php echo site_url('admin/nursing/assignNurse'); ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('nurse'); ?></label><small class="req"> *</small>
                                <select name="nurse_id" class="form-control select2" required>
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php foreach ($nurses as $nurse) { ?>
                                        <option value="<?php echo $nurse['id']; ?>">
                                            <?php echo $nurse['name'] . ' ' . $nurse['surname'] . ' (' . $nurse['employee_id'] . ')'; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('ward'); ?></label><small class="req"> *</small>
                                <select name="ward_id" class="form-control" required>
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <!-- Add ward options dynamically -->
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary"><?php echo $this->lang->line('save'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('.select2').select2();
        
        // Initialize DataTable
        $('.ajaxlist').DataTable({
            "aaSorting": [[2, "desc"]],
        });

        // Load wards
        $.ajax({
            url: '<?php echo base_url(); ?>admin/setup/ward/getWards',
            type: "GET",
            dataType: 'json',
            success: function (data) {
                var wardSelect = $('select[name="ward_id"]');
                $.each(data, function (i, item) {
                    wardSelect.append($('<option>', {
                        value: item.id,
                        text: item.name
                    }));
                });
            }
        });
    });

    function addAssignment() {
        $('#addAssignmentModal').modal('show');
    }

    $(document).on('submit', '#addAssignmentForm', function (e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            url: url,
            type: "POST",
            data: form.serialize(),
            dataType: 'json',
            success: function (data) {
                if (data.status == "success") {
                    successMsg(data.message);
                    window.location.reload(true);
                } else {
                    errorMsg(data.error);
                }
            }
        });
    });

    function editAssignment(id) {
        // Implement edit assignment functionality
    }

    function deleteAssignment(id) {
        if (confirm('<?php echo $this->lang->line("delete_confirm"); ?>')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/nursing/deleteAssignment/' + id,
                type: "POST",
                data: {id: id},
                dataType: 'json',
                success: function (data) {
                    if (data.status == "success") {
                        successMsg(data.message);
                        window.location.reload(true);
                    } else {
                        errorMsg(data.error);
                    }
                }
            });
        }
    }
</script>