<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-flask"></i>
        </div>
        <div class="header-title">
            <h1><?php echo $title; ?></h1>
            <small><?php echo $this->lang->line('configure_laboratory_tests'); ?></small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> <?php echo $this->lang->line('laboratory_tests'); ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_add')): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addTestModal">
                                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_test'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="testsTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('test_name'); ?></th>
                                        <th><?php echo $this->lang->line('short_name'); ?></th>
                                        <th><?php echo $this->lang->line('category'); ?></th>
                                        <th><?php echo $this->lang->line('unit'); ?></th>
                                        <th><?php echo $this->lang->line('cost'); ?></th>
                                        <th><?php echo $this->lang->line('report_days'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data loaded via DataTables -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Test Modal -->
<div class="modal fade" id="addTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_laboratory_test'); ?>
                </h4>
            </div>
            <form id="addTestForm" method="post" role="form">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="test_name"><?php echo $this->lang->line('test_name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="test_name" name="test_name" placeholder="<?php echo $this->lang->line('enter_test_name'); ?>" required>
                                <span class="text-danger" id="test_name_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="short_name"><?php echo $this->lang->line('short_name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="short_name" name="short_name" placeholder="<?php echo $this->lang->line('enter_short_name'); ?>" required>
                                <span class="text-danger" id="short_name_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id"><?php echo $this->lang->line('category'); ?> <span class="text-danger">*</span></label>
                                <select class="form-control" id="category_id" name="category_id" required>
                                    <option value=""><?php echo $this->lang->line('select_category'); ?></option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>"><?php echo $category['category_name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <span class="text-danger" id="category_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="unit_id"><?php echo $this->lang->line('unit'); ?></label>
                                <select class="form-control" id="unit_id" name="unit_id">
                                    <option value=""><?php echo $this->lang->line('select_unit'); ?></option>
                                    <?php foreach ($units as $unit): ?>
                                        <option value="<?php echo $unit['id']; ?>"><?php echo $unit['unit_name']; ?> (<?php echo $unit['unit_symbol']; ?>)</option>
                                    <?php endforeach; ?>
                                </select>
                                <span class="text-danger" id="unit_id_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="cost"><?php echo $this->lang->line('cost'); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon">Ksh.</span>
                                    <input type="number" class="form-control" id="cost" name="cost" step="0.01" min="0" placeholder="0.00" required>
                                </div>
                                <span class="text-danger" id="cost_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="report_days"><?php echo $this->lang->line('report_days'); ?></label>
                                <input type="number" class="form-control" id="report_days" name="report_days" min="1" max="30" placeholder="1">
                                <span class="text-danger" id="report_days_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="test_type"><?php echo $this->lang->line('test_type'); ?></label>
                                <select class="form-control test-type-select" id="test_type" name="test_type">
                                    <option value="qualitative"><?php echo $this->lang->line('qualitative'); ?></option>
                                    <option value="quantitative"><?php echo $this->lang->line('quantitative'); ?></option>
                                    <option value="descriptive"><?php echo $this->lang->line('descriptive'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="method"><?php echo $this->lang->line('method'); ?></label>
                                <input type="text" class="form-control" id="method" name="method" placeholder="<?php echo $this->lang->line('test_method'); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="sample_type"><?php echo $this->lang->line('sample_type'); ?></label>
                                <select class="form-control" id="sample_type" name="sample_type">
                                    <option value=""><?php echo $this->lang->line('select_sample_type'); ?></option>
                                    <option value="Blood">Blood</option>
                                    <option value="Serum">Serum</option>
                                    <option value="Plasma">Plasma</option>
                                    <option value="Urine">Urine</option>
                                    <option value="Stool">Stool</option>
                                    <option value="Sputum">Sputum</option>
                                    <option value="CSF">CSF</option>
                                    <option value="Swab">Swab</option>
                                    <option value="Tissue">Tissue</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description"><?php echo $this->lang->line('description'); ?></label>
                                <textarea class="form-control" id="description" name="description" rows="3" placeholder="<?php echo $this->lang->line('test_description'); ?>"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <?php echo $this->lang->line('cancel'); ?>
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> <?php echo $this->lang->line('save'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Test Modal -->
<div class="modal fade" id="editTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> <?php echo $this->lang->line('edit_laboratory_test'); ?>
                </h4>
            </div>
            <div id="editTestModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- View Test Modal -->
<div class="modal fade" id="viewTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> <?php echo $this->lang->line('view_test_details'); ?>
                </h4>
            </div>
            <div id="viewTestModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Fix dropdown text color
    $('head').append(`
        <style>
        .test-type-select {
            color: #555 !important;
            background-color: #fff !important;
        }
        .test-type-select option {
            color: #333 !important;
            background-color: #fff !important;
        }
        select.form-control {
            color: #555 !important;
        }
        select.form-control option {
            color: #333 !important;
            background-color: #fff !important;
        }
        </style>
    `);

    // Initialize DataTable
    var testsTable = $('#testsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: base_url + 'admin/lab_setup/get_tests_datatable',
            type: 'POST'
        },
        columns: [
            { data: 0, name: 'test_name' },
            { data: 1, name: 'short_name' },
            { data: 2, name: 'category_name' },
            { data: 3, name: 'unit_name', orderable: false },
            { data: 4, name: 'cost', className: 'text-right' },
            { data: 5, name: 'report_days', className: 'text-center' },
            { data: 6, name: 'is_active', orderable: false, className: 'text-center' },
            { data: 7, name: 'actions', orderable: false, searchable: false, className: 'text-right' }
        ],
        order: [[0, 'asc']],
        pageLength: 25,
        responsive: true,
        language: {
            processing: 'Processing...',
            search: 'Search:',
            lengthMenu: 'Show _MENU_ entries',
            info: 'Showing _START_ to _END_ of _TOTAL_ entries',
            infoEmpty: 'No entries found',
            infoFiltered: '(filtered from _MAX_ total entries)',
            zeroRecords: 'No matching records found',
            emptyTable: 'No data available in table',
            paginate: {
                first: 'First',
                previous: 'Previous',
                next: 'Next',
                last: 'Last'
            }
        }
    });

    // FIXED: Add Test Form Submission
    $('#addTestForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        
        // Debug: Log form submission attempt
        console.log('Form submission started');
        console.log('Base URL:', base_url);
        
        var $form = $(this);
        var $submitBtn = $form.find('button[type="submit"]');
        var formData = $form.serialize();
        
        // Show loading state
        $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        
        // Clear previous errors
        $('.text-danger').text('');
        
        // Debug: Log form data
        console.log('Form data being sent:', formData);
        console.log('Submit URL:', base_url + 'admin/lab_setup/add_test');
        
        $.ajax({
            url: base_url + 'admin/lab_setup/add_test',
            type: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function(xhr) {
                console.log('AJAX request starting...');
            },
            success: function(response) {
                console.log('Response received:', response);
                
                if (response.status === 'success') {
                    // Success - close modal and refresh table
                    $('#addTestModal').modal('hide');
                    $form[0].reset();
                    testsTable.ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    // Handle validation errors
                    if (response.error && typeof response.error === 'object') {
                        $.each(response.error, function(field, error) {
                            $('#' + field + '_error').text(error);
                        });
                    }
                    if (response.message) {
                        showMessage(response.message, 'error');
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error Details:');
                console.error('Status:', status);
                console.error('Error:', error);
                console.error('Response Text:', xhr.responseText);
                console.error('Response Status:', xhr.status);
                
                // Try to parse error response
                let errorMessage = 'An error occurred while saving the test.';
                try {
                    const errorResponse = JSON.parse(xhr.responseText);
                    if (errorResponse.message) {
                        errorMessage = errorResponse.message;
                    }
                } catch (e) {
                    // If response is not JSON, use the status text
                    if (xhr.status === 404) {
                        errorMessage = 'The server endpoint was not found. Please check the URL.';
                    } else if (xhr.status === 500) {
                        errorMessage = 'Server error occurred. Please check the logs.';
                    } else if (xhr.status === 0) {
                        errorMessage = 'Network error. Please check your connection.';
                    }
                }
                
                showMessage(errorMessage, 'error');
            },
            complete: function() {
                // Reset button state
                $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> <?php echo $this->lang->line('save'); ?>');
                console.log('AJAX request completed');
            }
        });
        
        return false; // Ensure form doesn't submit normally
    });

    // Auto-generate short name from test name
    $('#test_name').on('input', function() {
        var testName = $(this).val();
        var shortName = generateShortName(testName);
        $('#short_name').val(shortName);
    });

    // Force dropdown refresh
    setTimeout(function() {
        $('#test_type').trigger('change');
    }, 500);
});

// Ensure base_url is defined
if (typeof base_url === 'undefined') {
    var base_url = '<?php echo base_url(); ?>';
    console.log('Base URL set to:', base_url);
}

// Generate short name from test name
function generateShortName(testName) {
    if (!testName) return '';
    
    // Remove common words and get initials
    var commonWords = ['test', 'analysis', 'examination', 'level', 'count', 'screening'];
    var words = testName.toLowerCase().split(' ');
    
    // Filter out common words
    words = words.filter(function(word) {
        return commonWords.indexOf(word) === -1 && word.length > 1;
    });
    
    // Get first letters of remaining words
    var shortName = words.map(function(word) {
        return word.charAt(0).toUpperCase();
    }).join('');
    
    // If too short, use first 3-4 characters of first word
    if (shortName.length < 2) {
        shortName = testName.substring(0, 4).toUpperCase();
    }
    
    return shortName;
}

// Enhanced message function with better error handling
function showMessage(message, type) {
    // Remove any existing alerts first
    $('.alert').remove();
    
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check' : 'fa-exclamation-triangle';
    
    var alert = '<div class="alert ' + alertClass + ' alert-dismissible" style="margin: 15px 0;">' +
                '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                '<h4><i class="icon fa ' + icon + '"></i> ' + 
                (type === 'success' ? '<?php echo $this->lang->line('success'); ?>' : '<?php echo $this->lang->line('error'); ?>') + '</h4>' +
                message + '</div>';
    
    // Insert the alert at the top of the content wrapper
    $('.content-wrapper').prepend(alert);
    
    // Auto-hide after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow', function() {
            $(this).remove();
        });
    }, 5000);
    
    // Scroll to top to show the message
    $('html, body').animate({
        scrollTop: $('.content-wrapper').offset().top
    }, 'fast');
}

// Edit Test Function
function editTest(id) {
    $.ajax({
        url: base_url + 'admin/lab_setup/edit_test/' + id,
        type: 'GET',
        success: function(response) {
            $('#editTestModalContent').html(response);
            $('#editTestModal').modal('show');
        },
        error: function() {
            showMessage('Error loading test data.', 'error');
        }
    });
}

// View Test Function
function viewTest(id) {
    $.ajax({
        url: base_url + 'admin/lab_setup/view_test/' + id,
        type: 'GET',
        success: function(response) {
            $('#viewTestModalContent').html(response);
            $('#viewTestModal').modal('show');
        },
        error: function() {
            showMessage('Error loading test data.', 'error');
        }
    });
}

// Delete Test Function
function deleteTest(id) {
    if (confirm('Are you sure you want to delete this test?')) {
        $.ajax({
            url: base_url + 'admin/lab_setup/delete_test/' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#testsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('An error occurred while deleting.', 'error');
            }
        });
    }
}

// Reference Ranges Management
function manageReferenceRanges(testId) {
    window.open(base_url + 'admin/lab_setup/reference_ranges/' + testId, '_blank');
}

// Export tests to CSV
function exportTests() {
    window.location.href = base_url + 'admin/lab_setup/export_tests';
}

// Bulk actions
function bulkToggleStatus(status) {
    var selectedTests = [];
    $('.test-checkbox:checked').each(function() {
        selectedTests.push($(this).val());
    });
    
    if (selectedTests.length === 0) {
        alert('<?php echo $this->lang->line('please_select_tests'); ?>');
        return;
    }
    
    if (confirm('<?php echo $this->lang->line('are_you_sure'); ?>')) {
        $.ajax({
            url: base_url + 'admin/lab_setup/bulk_toggle_status',
            type: 'POST',
            data: {
                test_ids: selectedTests,
                status: status
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#testsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('<?php echo $this->lang->line('error_occurred'); ?>', 'error');
            }
        });
    }
}

// Toggle all checkboxes
function toggleAllTests() {
    var isChecked = $('#selectAllTests').is(':checked');
    $('.test-checkbox').prop('checked', isChecked);
}

// Cost calculation helper
function calculateTotalCost() {
    var selectedTests = [];
    $('.test-checkbox:checked').each(function() {
        var cost = parseFloat($(this).data('cost')) || 0;
        selectedTests.push(cost);
    });
    
    var total = selectedTests.reduce(function(sum, cost) {
        return sum + cost;
    }, 0);
    
    if (selectedTests.length > 0) {
        $('#selectedTestsInfo').html(
            selectedTests.length + ' <?php echo $this->lang->line('tests_selected'); ?> - ' +
            '<?php echo $this->lang->line('total_cost'); ?>: Ksh. ' + total.toFixed(2)
        ).show();
    } else {
        $('#selectedTestsInfo').hide();
    }
}

// Search functionality
function searchTests() {
    var searchTerm = $('#testSearch').val();
    $('#testsTable').DataTable().search(searchTerm).draw();
}

// Category filter
function filterByCategory(categoryId) {
    if (categoryId === '') {
        $('#testsTable').DataTable().column(2).search('').draw();
    } else {
        var categoryName = $('#categoryFilter option:selected').text();
        $('#testsTable').DataTable().column(2).search(categoryName).draw();
    }
}

// Print test list
function printTestList() {
    var printWindow = window.open('', '_blank');
    var content = '<html><head><title><?php echo $this->lang->line('laboratory_tests'); ?></title>';
    content += '<style>table { border-collapse: collapse; width: 100%; }';
    content += 'th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }';
    content += 'th { background-color: #f2f2f2; }</style></head><body>';
    content += '<h1><?php echo $this->lang->line('laboratory_tests'); ?></h1>';
    content += '<table>' + $('#testsTable thead').html();
    content += '<tbody>' + $('#testsTable tbody').html() + '</tbody></table>';
    content += '</body></html>';
    
    printWindow.document.write(content);
    printWindow.document.close();
    printWindow.print();
}
</script>