<form id="editCategoryForm" role="form">
    <input type="hidden" name="category_id" value="<?php echo $category['id']; ?>">
    <div class="modal-body">
        <div class="form-group">
            <label for="edit_category_name">Category Name <span class="text-danger">*</span></label>
            <input type="text" class="form-control" id="edit_category_name" name="category_name" 
                   value="<?php echo htmlspecialchars($category['category_name']); ?>" 
                   placeholder="Enter category name" required>
            <span class="text-danger" id="edit_category_name_error"></span>
        </div>
        <div class="form-group">
            <label for="edit_description">Description</label>
            <textarea class="form-control" id="edit_description" name="description" rows="3" 
                      placeholder="Enter category description"><?php echo htmlspecialchars($category['description']); ?></textarea>
            <span class="text-danger" id="edit_description_error"></span>
        </div>
        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" <?php echo $category['is_active'] ? 'checked' : ''; ?>>
                Active
            </label>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-primary">
            <i class="fa fa-save"></i> Update Category
        </button>
    </div>
</form>

<script>
$('#editCategoryForm').on('submit', function(e) {
    e.preventDefault();
    
    var formData = $(this).serialize();
    var categoryId = $('input[name="category_id"]').val();
    var $submitBtn = $(this).find('button[type="submit"]');
    
    $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
    
    // Clear previous errors
    $('.text-danger').text('');
    
    $.ajax({
        url: base_url + 'admin/lab_setup/update_category/' + categoryId,
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                $('#editCategoryModal').modal('hide');
                showMessage(response.message, 'success');
                setTimeout(function() {
                    location.reload();
                }, 1500);
            } else {
                if (response.error) {
                    $.each(response.error, function(field, error) {
                        $('#edit_' + field + '_error').text(error);
                    });
                }
                if (response.message) {
                    showMessage(response.message, 'error');
                }
            }
        },
        error: function() {
            showMessage('An error occurred. Please try again.', 'error');
        },
        complete: function() {
            $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Update Category');
        }
    });
});
</script>