<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-list-alt"></i> <?php echo $title; ?></h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix">Lab Result List</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('lab_results', 'can_add')) { ?>
                                <a data-toggle="modal" data-target="#add_result_modal" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add Lab Result</a>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="lab_results_table" class="table table-striped table-bordered table-hover example">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Patient</th>
                                        <th>Test</th>
                                        <th>Result Value</th>
                                        <th>Reference Range</th>
                                        <th>Technician</th>
                                        <th>Result Date</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be loaded by DataTables -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Lab Result Modal -->
<div class="modal fade" id="add_result_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add Lab Result</h4>
            </div>
            <form id="add_result_form" method="post" accept-charset="utf-8">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="add_patient_id">Patient</label><small class="req"> *</small>
                                <select name="patient_id" id="add_patient_id" class="form-control select2">
                                    <option value="">Select Patient</option>
                                    <?php foreach ($patients as $patient) { ?>
                                        <option value="<?php echo $patient['id']; ?>"><?php echo $patient['patient_name'] . " (" . $patient['patient_unique_id'] . ")"; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="add_patient_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="add_test_id">Lab Test</label><small class="req"> *</small>
                                <select name="test_id" id="add_test_id" class="form-control select2">
                                    <option value="">Select Test</option>
                                    <?php foreach ($lab_tests as $test) { ?>
                                        <option value="<?php echo $test['id']; ?>"><?php echo $test['name']; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="add_test_id_error"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="add_result_value">Result Value</label><small class="req"> *</small>
                                <input type="text" name="result_value" id="add_result_value" class="form-control">
                                <span class="text-danger" id="add_result_value_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="add_reference_range">Reference Range</label>
                                <input type="text" name="reference_range" id="add_reference_range" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="add_technician_id">Technician</label><small class="req"> *</small>
                                <select name="technician_id" id="add_technician_id" class="form-control select2">
                                    <option value="">Select Technician</option>
                                     <?php foreach ($technicians as $technician) { ?>
                                        <option value="<?php echo $technician['id']; ?>"><?php echo $technician['name'] . " (" . $technician['employee_id'] . ")"; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="add_technician_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="add_result_date">Result Date</label><small class="req"> *</small>
                                <input type="text" name="result_date" id="add_result_date" class="form-control date">
                                <span class="text-danger" id="add_result_date_error"></span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="add_comments">Comments</label>
                        <textarea name="comments" id="add_comments" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary pull-right">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Lab Result Modal -->
<div class="modal fade" id="edit_result_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Lab Result</h4>
            </div>
            <form id="edit_result_form" method="post" accept-charset="utf-8">
                <input type="hidden" name="id" id="edit_result_id">
                <div class="modal-body">
                     <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_patient_id">Patient</label><small class="req"> *</small>
                                <select name="patient_id" id="edit_patient_id" class="form-control select2">
                                    <option value="">Select Patient</option>
                                    <?php foreach ($patients as $patient) { ?>
                                        <option value="<?php echo $patient['id']; ?>"><?php echo $patient['patient_name'] . " (" . $patient['patient_unique_id'] . ")"; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="edit_patient_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_test_id">Lab Test</label><small class="req"> *</small>
                                <select name="test_id" id="edit_test_id" class="form-control select2">
                                    <option value="">Select Test</option>
                                    <?php foreach ($lab_tests as $test) { ?>
                                        <option value="<?php echo $test['id']; ?>"><?php echo $test['name']; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="edit_test_id_error"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_result_value">Result Value</label><small class="req"> *</small>
                                <input type="text" name="result_value" id="edit_result_value" class="form-control">
                                <span class="text-danger" id="edit_result_value_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_reference_range">Reference Range</label>
                                <input type="text" name="reference_range" id="edit_reference_range" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_technician_id">Technician</label><small class="req"> *</small>
                                <select name="technician_id" id="edit_technician_id" class="form-control select2">
                                    <option value="">Select Technician</option>
                                     <?php foreach ($technicians as $technician) { ?>
                                        <option value="<?php echo $technician['id']; ?>"><?php echo $technician['name'] . " (" . $technician['employee_id'] . ")"; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="edit_technician_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_result_date">Result Date</label><small class="req"> *</small>
                                <input type="text" name="result_date" id="edit_result_date" class="form-control date">
                                <span class="text-danger" id="edit_result_date_error"></span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="edit_comments">Comments</label>
                        <textarea name="comments" id="edit_comments" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary pull-right">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script type="text/javascript">
    $(document).ready(function () {
        $('.select2').select2();
        $('.date').datepicker({ autoclose: true, format: 'yyyy-mm-dd' });

        $('#lab_results_table').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "<?php echo base_url(); ?>admin/lab/get_results_datatable",
                "type": "POST"
            },
            "columns": [
                { "data": "id" },
                { "data": "patient_name" },
                { "data": "test_name" },
                { "data": "result_value" },
                { "data": "reference_range" },
                { "data": "technician_name" },
                { "data": "result_date" },
                { "data": "action", "orderable": false, "searchable": false }
            ],
            responsive: true
        });

        // Add Result Form Submission
        $("#add_result_form").on('submit', (function (e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/lab/add_result',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function (data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function (index, value) {
                            $('#add_' + index + '_error').html(value);
                            message += value + '<br>';
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        $('#add_result_modal').modal('hide');
                        $('#lab_results_table').DataTable().ajax.reload();
                    }
                },
                error: function () {
                    alert("Fail");
                }
            });
        }));

        // Edit Result Form Submission
        $("#edit_result_form").on('submit', (function (e) {
            e.preventDefault();
            var result_id = $('#edit_result_id').val();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/lab/update_lab_result/' + result_id,
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function (data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function (index, value) {
                           $('#edit_' + index + '_error').html(value);
                           message += value + '<br>';
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        $('#edit_result_modal').modal('hide');
                        $('#lab_results_table').DataTable().ajax.reload();
                    }
                },
                error: function () {
                    alert("Fail");
                }
            });
        }));
    });

    function view_result(id) {
        // Implement view functionality - perhaps a modal with result details
        alert('View Result ID: ' + id + ' - (Implement View Modal)');
    }

    function edit_result(id) {
        $('#edit_result_modal').modal('show');
        // Clear previous errors
        $('#edit_result_form .text-danger').html('');
        $.ajax({
            url: '<?php echo base_url(); ?>admin/lab/get_lab_result/' + id,
            type: "GET",
            dataType: 'json',
            success: function (data) {
                $('#edit_result_id').val(data.id);
                $('#edit_patient_id').val(data.patient_id).trigger('change');
                $('#edit_test_id').val(data.test_id).trigger('change');
                $('#edit_result_value').val(data.result_value);
                $('#edit_reference_range').val(data.reference_range);
                $('#edit_technician_id').val(data.technician_id).trigger('change');
                $('#edit_result_date').val(data.result_date.substring(0,10)); // Format date if needed
                $('#edit_comments').val(data.comments);
            },
            error: function () {
                alert("Failed to load result data for editing.");
            }
        });
    }

    function delete_result(id) {
        if (confirm('Are you sure you want to delete this lab result?')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/lab/delete_lab_result/' + id,
                type: "POST",
                dataType: 'json',
                success: function (data) {
                    if (data.status == "success") {
                        successMsg(data.message);
                        $('#lab_results_table').DataTable().ajax.reload();
                    } else {
                        errorMsg('Failed to delete lab result.');
                    }
                },
                error: function () {
                    errorMsg('An error occurred.');
                }
            });
        }
    }
</script>