<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-money"></i> Petty Cash Management
            <small>Track small cash expenses and replenishments</small>
        </h1>
        <ol class="breadcrumb">
            <li>
                <a href="<?php echo base_url(); ?>admin/admin/dashboard">
                    <i class="fa fa-dashboard"></i> Home
                </a>
            </li>
            <li>
                <a href="<?php echo base_url(); ?>admin/financial">Financial</a>
            </li>
            <li class="active">Petty Cash</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Petty Cash Summary Cards -->
        <div class="row">
            <!-- Current Balance Card -->
            <div class="col-md-3">
                <div class="info-box bg-green">
                    <span class="info-box-icon">
                        <i class="fa fa-money"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Current Balance</span>
                        <span class="info-box-number">
                            <?php 
                            echo $this->customlib->getSchoolCurrencyFormat();
                            echo number_format($balance, 2); 
                            ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- This Month Expenses Card -->
            <div class="col-md-3">
                <div class="info-box bg-blue">
                    <span class="info-box-icon">
                        <i class="fa fa-calendar"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">This Month</span>
                        <span class="info-box-number">
                            <?php 
                            $monthly_total = 0;
                            if (!empty($transactions)) {
                                foreach ($transactions as $trans) {
                                    if (date('Y-m', strtotime($trans['created_at'])) == date('Y-m')) {
                                        if ($trans['transaction_type'] == 'expense') {
                                            $monthly_total += $trans['amount'];
                                        }
                                    }
                                }
                            }
                            echo $this->customlib->getSchoolCurrencyFormat() . number_format($monthly_total, 2);
                            ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Total Transactions Card -->
            <div class="col-md-3">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon">
                        <i class="fa fa-shopping-cart"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Transactions</span>
                        <span class="info-box-number">
                            <?php echo !empty($transactions) ? count($transactions) : 0; ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Status Card -->
            <div class="col-md-3">
                <div class="info-box <?php echo ($balance < 500) ? 'bg-red' : 'bg-aqua'; ?>">
                    <span class="info-box-icon">
                        <i class="fa <?php echo ($balance < 500) ? 'fa-warning' : 'fa-check'; ?>"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Status</span>
                        <span class="info-box-number">
                            <?php echo ($balance < 500) ? 'Low Fund' : 'OK'; ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Add Transaction Form Column -->
            <div class="col-md-4">
                <!-- Add Transaction Form -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-plus"></i> Add Transaction
                        </h3>
                    </div>
                    
                    <form method="post" id="pettyCashForm">
                        <div class="box-body">
                            <!-- Transaction Type -->
                            <div class="form-group">
                                <label for="transaction_type">
                                    Transaction Type <span class="text-red">*</span>
                                </label>
                                <select class="form-control" name="transaction_type" id="transaction_type" required>
                                    <option value="">Select Type</option>
                                    <option value="expense">Expense</option>
                                    <option value="replenishment">Replenishment</option>
                                </select>
                            </div>

                            <!-- Amount -->
                            <div class="form-group">
                                <label for="amount">
                                    Amount <span class="text-red">*</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <?php echo $this->customlib->getSchoolCurrencyFormat(); ?>
                                    </span>
                                    <input type="number" 
                                           class="form-control" 
                                           name="amount" 
                                           id="amount" 
                                           step="0.01" 
                                           min="0" 
                                           required 
                                           placeholder="0.00">
                                </div>
                            </div>

                            <!-- Category -->
                            <div class="form-group" id="categoryGroup">
                                <label for="category">Category</label>
                                <select class="form-control" name="category" id="category">
                                    <option value="">Select Category</option>
                                    <?php foreach ($categories as $key => $label) : ?>
                                        <option value="<?php echo $key; ?>">
                                            <?php echo $label; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <!-- Description -->
                            <div class="form-group">
                                <label for="description">
                                    Description <span class="text-red">*</span>
                                </label>
                                <textarea class="form-control" 
                                          name="description" 
                                          id="description" 
                                          rows="3" 
                                          placeholder="Brief description of the transaction" 
                                          required></textarea>
                            </div>

                            <!-- Receipt Number -->
                            <div class="form-group">
                                <label for="receipt_no">Receipt/Reference No</label>
                                <input type="text" 
                                       class="form-control" 
                                       name="receipt_no" 
                                       id="receipt_no" 
                                       placeholder="Receipt or reference number">
                            </div>

                            <!-- Low Balance Warning -->
                            <?php if ($balance < 100) : ?>
                                <div class="alert alert-warning">
                                    <i class="fa fa-warning"></i> 
                                    <strong>Low Balance Alert:</strong> 
                                    Petty cash balance is running low. Consider replenishment.
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="box-footer">
                            <button type="submit" name="submit" class="btn btn-primary">
                                <i class="fa fa-save"></i> Add Transaction
                            </button>
                            <button type="button" class="btn btn-default" id="resetForm">
                                <i class="fa fa-refresh"></i> Reset
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Quick Actions Box -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-flash"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <button type="button" class="btn btn-success btn-block" id="quickReplenish">
                            <i class="fa fa-plus"></i> Quick Replenish (₹1000)
                        </button>
                        <button type="button" class="btn btn-warning btn-block" id="reconcilePettyCash">
                            <i class="fa fa-check-square"></i> Reconcile Cash
                        </button>
                        <button type="button" class="btn btn-info btn-block" id="viewReport">
                            <i class="fa fa-file-text"></i> Monthly Report
                        </button>
                        <button type="button" class="btn btn-default btn-block" id="exportTransactions">
                            <i class="fa fa-download"></i> Export Transactions
                        </button>
                    </div>
                </div>
            </div>

            <!-- Transaction List Column -->
            <div class="col-md-8">
                <!-- Recent Transactions -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> Recent Transactions
                        </h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" class="btn btn-success btn-sm" data-filter="all">
                                    All
                                </button>
                                <button type="button" class="btn btn-default btn-sm" data-filter="expense">
                                    Expenses
                                </button>
                                <button type="button" class="btn btn-default btn-sm" data-filter="replenishment">
                                    Replenishments
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <?php if (!empty($transactions)) : ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="transactionsTable">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Type</th>
                                            <th>Category</th>
                                            <th>Description</th>
                                            <th class="text-right">Amount</th>
                                            <th class="text-right">Balance</th>
                                            <th>Staff</th>
                                            <th class="text-center">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $running_balance = $balance;
                                        
                                        // Calculate running balance from latest to oldest
                                        foreach (array_reverse($transactions) as $transaction) : 
                                            if ($transaction['transaction_type'] == 'expense') {
                                                $running_balance += $transaction['amount'];
                                            } else {
                                                $running_balance -= $transaction['amount'];
                                            }
                                        endforeach;
                                        
                                        // Display transactions with correct running balance
                                        foreach ($transactions as $transaction) : 
                                            if ($transaction['transaction_type'] == 'expense') {
                                                $running_balance -= $transaction['amount'];
                                            } else {
                                                $running_balance += $transaction['amount'];
                                            }
                                        ?>
                                            <tr class="transaction-row" data-type="<?php echo $transaction['transaction_type']; ?>">
                                                <td>
                                                    <?php echo date('d-M-Y', strtotime($transaction['created_at'])); ?>
                                                </td>
                                                <td>
                                                    <span class="label <?php echo ($transaction['transaction_type'] == 'expense') ? 'label-danger' : 'label-success'; ?>">
                                                        <?php echo ucfirst($transaction['transaction_type']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($transaction['category']) : ?>
                                                        <span class="category-badge">
                                                            <?php echo isset($categories[$transaction['category']]) 
                                                                ? $categories[$transaction['category']] 
                                                                : ucfirst($transaction['category']); ?>
                                                        </span>
                                                    <?php else : ?>
                                                        <span class="text-muted">-</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <div class="transaction-description">
                                                        <?php echo $transaction['description']; ?>
                                                        <?php if ($transaction['receipt_no']) : ?>
                                                            <br>
                                                            <small class="text-muted">
                                                                Ref: <?php echo $transaction['receipt_no']; ?>
                                                            </small>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                                <td class="text-right">
                                                    <span class="currency-amount <?php echo ($transaction['transaction_type'] == 'expense') ? 'text-red' : 'text-green'; ?>">
                                                        <?php echo ($transaction['transaction_type'] == 'expense') ? '-' : '+'; ?>
                                                        <?php echo $this->customlib->getSchoolCurrencyFormat(); ?>
                                                        <?php echo number_format($transaction['amount'], 2); ?>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    <span class="running-balance">
                                                        <?php echo $this->customlib->getSchoolCurrencyFormat(); ?>
                                                        <?php echo number_format($running_balance, 2); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php echo $transaction['staff_name'] . ' ' . $transaction['staff_surname']; ?>
                                                </td>
                                                <td class="text-center">
                                                    <div class="btn-group">
                                                        <button type="button" 
                                                                class="btn btn-xs btn-info view-transaction" 
                                                                data-id="<?php echo $transaction['id']; ?>" 
                                                                title="View Details">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                        <?php if ($transaction['transaction_type'] == 'expense') : ?>
                                                            <button type="button" 
                                                                    class="btn btn-xs btn-warning edit-transaction" 
                                                                    data-id="<?php echo $transaction['id']; ?>" 
                                                                    title="Edit">
                                                                <i class="fa fa-edit"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                        <button type="button" 
                                                                class="btn btn-xs btn-danger delete-transaction" 
                                                                data-id="<?php echo $transaction['id']; ?>" 
                                                                title="Delete">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <th colspan="4">Current Balance</th>
                                            <th class="text-right">-</th>
                                            <th class="text-right">
                                                <strong>
                                                    <?php echo $this->customlib->getSchoolCurrencyFormat(); ?>
                                                    <?php echo number_format($balance, 2); ?>
                                                </strong>
                                            </th>
                                            <th colspan="2"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php else : ?>
                            <div class="alert alert-info text-center">
                                <h4><i class="icon fa fa-info"></i> No Transactions</h4>
                                <p>
                                    No petty cash transactions found. 
                                    Add your first transaction using the form on the left.
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Category Summary -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-pie-chart"></i> Expense Categories (This Month)
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <canvas id="categoryChart" height="200"></canvas>
                            </div>
                            <div class="col-md-6">
                                <div class="category-summary">
                                    <?php 
                                    $category_totals = [];
                                    $monthly_expenses = 0;
                                    
                                    if (!empty($transactions)) {
                                        foreach ($transactions as $trans) {
                                            if ($trans['transaction_type'] == 'expense' && 
                                                date('Y-m', strtotime($trans['created_at'])) == date('Y-m')) {
                                                $cat = $trans['category'] ?: 'uncategorized';
                                                $category_totals[$cat] = ($category_totals[$cat] ?? 0) + $trans['amount'];
                                                $monthly_expenses += $trans['amount'];
                                            }
                                        }
                                    }
                                    
                                    if (!empty($category_totals)) :
                                        arsort($category_totals);
                                        foreach ($category_totals as $cat => $total) :
                                            $percentage = $monthly_expenses > 0 ? ($total / $monthly_expenses) * 100 : 0;
                                            $cat_label = isset($categories[$cat]) ? $categories[$cat] : ucfirst($cat);
                                    ?>
                                        <div class="category-item">
                                            <div class="category-header">
                                                <span class="category-name"><?php echo $cat_label; ?></span>
                                                <span class="category-amount">
                                                    <?php echo $this->customlib->getSchoolCurrencyFormat(); ?>
                                                    <?php echo number_format($total, 2); ?>
                                                </span>
                                            </div>
                                            <div class="progress progress-sm">
                                                <div class="progress-bar bg-yellow" 
                                                     style="width: <?php echo $percentage; ?>%"></div>
                                            </div>
                                            <small class="text-muted">
                                                <?php echo number_format($percentage, 1); ?>% of total expenses
                                            </small>
                                        </div>
                                    <?php 
                                        endforeach;
                                    else :
                                    ?>
                                        <p class="text-muted text-center">
                                            No expenses recorded this month.
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Transaction Details Modal -->
<div class="modal fade" id="transactionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Transaction Details</h4>
            </div>
            <div class="modal-body" id="transactionDetails">
                <!-- Transaction details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Reconciliation Modal -->
<div class="modal fade" id="reconcileModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Petty Cash Reconciliation</h4>
            </div>
            <form id="reconcileForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>System Balance</label>
                                <input type="text" 
                                       class="form-control" 
                                       value="<?php echo $this->customlib->getSchoolCurrencyFormat() . number_format($balance, 2); ?>" 
                                       readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="physical_count">
                                    Physical Count <span class="text-red">*</span>
                                </label>
                                <input type="number" 
                                       class="form-control" 
                                       name="physical_count" 
                                       id="physical_count" 
                                       step="0.01" 
                                       required 
                                       placeholder="0.00">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Difference</label>
                        <input type="text" class="form-control" id="difference" readonly>
                    </div>
                    
                    <div class="form-group" id="reasonGroup" style="display: none;">
                        <label for="reconcile_reason">Reason for Difference</label>
                        <textarea class="form-control" 
                                  name="reason" 
                                  id="reconcile_reason" 
                                  rows="3" 
                                  placeholder="Explain the reason for the difference..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        Reconcile
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
$(document).ready(function() {
    // =============================================
    // INITIALIZATION
    // =============================================
    
    // Initialize DataTable
    $('#transactionsTable').DataTable({
        "order": [[ 0, "desc" ]], // Sort by date
        "pageLength": 25,
        "responsive": true,
        "columnDefs": [
            { "orderable": false, "targets": [7] }
        ]
    });

    // Initialize category chart
    initializeCategoryChart();

    // =============================================
    // FORM HANDLING
    // =============================================
    
    // Transaction type change
    $('#transaction_type').change(function() {
        if ($(this).val() === 'replenishment') {
            $('#categoryGroup').hide();
            $('#category').prop('required', false);
        } else {
            $('#categoryGroup').show();
            $('#category').prop('required', true);
        }
    });

    // Amount validation for expenses
    $('#amount').on('input', function() {
        var amount = parseFloat($(this).val()) || 0;
        var currentBalance = <?php echo $balance; ?>;
        var transactionType = $('#transaction_type').val();
        
        if (transactionType === 'expense' && amount > currentBalance) {
            $(this).addClass('error');
            $('.box-footer button[type="submit"]').prop('disabled', true);
            showAlert('warning', 'Expense amount cannot exceed current balance (' + 
                     '<?php echo $this->customlib->getSchoolCurrencyFormat(); ?>' + 
                     currentBalance.toFixed(2) + ')');
        } else {
            $(this).removeClass('error');
            $('.box-footer button[type="submit"]').prop('disabled', false);
            $('.alert-warning').fadeOut();
        }
    });

    // Form submission
    $('#pettyCashForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/pettycash',
            type: 'POST',
            data: formData + '&submit=1',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showAlert('success', 'Transaction added successfully!');
                    $('#pettyCashForm')[0].reset();
                    $('#transaction_type').trigger('change');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('danger', response.message || 'Error adding transaction');
                }
            },
            error: function() {
                showAlert('danger', 'An error occurred while adding transaction');
            }
        });
    });

    // Reset form
    $('#resetForm').click(function() {
        $('#pettyCashForm')[0].reset();
        $('#transaction_type').trigger('change');
    });

    // =============================================
    // TRANSACTION FILTERING
    // =============================================
    
    // Filter transactions
    $('[data-filter]').click(function() {
        var filter = $(this).data('filter');
        $('[data-filter]').removeClass('btn-success').addClass('btn-default');
        $(this).removeClass('btn-default').addClass('btn-success');
        
        if (filter === 'all') {
            $('.transaction-row').show();
        } else {
            $('.transaction-row').hide();
            $('.transaction-row[data-type="' + filter + '"]').show();
        }
    });

    // =============================================
    // QUICK ACTIONS
    // =============================================
    
    // Quick replenish
    $('#quickReplenish').click(function() {
        $('#transaction_type').val('replenishment').trigger('change');
        $('#amount').val('1000');
        $('#description').val('Quick replenishment of petty cash fund');
    });

    // Reconcile petty cash
    $('#reconcilePettyCash').click(function() {
        $('#reconcileModal').modal('show');
    });

    // Export transactions
    $('#exportTransactions').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/exportPettyCash', '_blank');
    });

    // View monthly report
    $('#viewReport').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/pettyCashReport', '_blank');
    });

    // =============================================
    // RECONCILIATION HANDLING
    // =============================================
    
    // Physical count change
    $('#physical_count').on('input', function() {
        var systemBalance = <?php echo $balance; ?>;
        var physicalCount = parseFloat($(this).val()) || 0;
        var difference = physicalCount - systemBalance;
        
        $('#difference').val('<?php echo $this->customlib->getSchoolCurrencyFormat(); ?>' + 
                            difference.toFixed(2));
        
        if (Math.abs(difference) > 0.01) {
            $('#reasonGroup').show();
            $('#reconcile_reason').prop('required', true);
        } else {
            $('#reasonGroup').hide();
            $('#reconcile_reason').prop('required', false);
        }
    });

    // Reconciliation form submission
    $('#reconcileForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/reconcilePettyCash',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#reconcileModal').modal('hide');
                    showAlert('success', 'Petty cash reconciled successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('danger', response.message || 'Error reconciling petty cash');
                }
            },
            error: function() {
                showAlert('danger', 'An error occurred during reconciliation');
            }
        });
    });

    // =============================================
    // TRANSACTION ACTIONS
    // =============================================
    
    // View transaction details
    $('.view-transaction').click(function() {
        var transactionId = $(this).data('id');
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/getPettyCashTransaction/' + transactionId,
            type: 'GET',
            success: function(response) {
                $('#transactionDetails').html(response);
                $('#transactionModal').modal('show');
            },
            error: function() {
                showAlert('danger', 'Error loading transaction details');
            }
        });
    });

    // Delete transaction
    $('.delete-transaction').click(function() {
        var transactionId = $(this).data('id');
        
        if (confirm('Are you sure you want to delete this transaction?')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/financial/deletePettyCashTransaction',
                type: 'POST',
                data: { transaction_id: transactionId },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        showAlert('success', 'Transaction deleted successfully!');
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    } else {
                        showAlert('danger', response.message || 'Error deleting transaction');
                    }
                },
                error: function() {
                    showAlert('danger', 'An error occurred while deleting transaction');
                }
            });
        }
    });

    // =============================================
    // UTILITY FUNCTIONS
    // =============================================
    
    // Real-time balance calculation
    function updateBalancePreview() {
        var currentBalance = <?php echo $balance; ?>;
        var transactionType = $('#transaction_type').val();
        var amount = parseFloat($('#amount').val()) || 0;
        
        if (transactionType && amount > 0) {
            var newBalance = transactionType === 'expense' 
                ? currentBalance - amount 
                : currentBalance + amount;
            
            var previewHtml = '<small class="text-muted">New balance will be: ' +
                             '<?php echo $this->customlib->getSchoolCurrencyFormat(); ?>' + 
                             newBalance.toFixed(2) + '</small>';
            
            $('.balance-preview').remove();
            $('#amount').parent().after('<div class="balance-preview">' + previewHtml + '</div>');
        } else {
            $('.balance-preview').remove();
        }
    }

    // Add event listeners for balance preview
    $('#transaction_type, #amount').on('change input', updateBalancePreview);

    // =============================================
    // KEYBOARD SHORTCUTS
    // =============================================
    
    $(document).keydown(function(e) {
        // Ctrl+N for new transaction
        if (e.ctrlKey && e.keyCode === 78) {
            e.preventDefault();
            $('#transaction_type').focus();
        }
        
        // Ctrl+R for reconcile
        if (e.ctrlKey && e.keyCode === 82) {
            e.preventDefault();
            $('#reconcilePettyCash').click();
        }
    });
});

// =============================================
// CHART INITIALIZATION
// =============================================

function initializeCategoryChart() {
    var ctx = document.getElementById('categoryChart').getContext('2d');
    
    // Prepare data from PHP
    var categoryData = {
        labels: [
            <?php 
            if (!empty($category_totals)) {
                foreach ($category_totals as $cat => $total) {
                    $cat_label = isset($categories[$cat]) ? $categories[$cat] : ucfirst($cat);
                    echo "'" . addslashes($cat_label) . "',";
                }
            }
            ?>
        ],
        datasets: [{
            data: [
                <?php 
                if (!empty($category_totals)) {
                    foreach ($category_totals as $cat => $total) {
                        echo $total . ',';
                    }
                }
                ?>
            ],
            backgroundColor: [
                '#f39c12', '#dd4b39', '#00a65a', '#3c8dbc', '#605ca8',
                '#00c0ef', '#39cccc', '#d2d6de', '#001f3f', '#85144b'
            ]
        }]
    };
    
    if (categoryData.labels.length > 0) {
        new Chart(ctx, {
            type: 'doughnut',
            data: categoryData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                var value = context.parsed || 0;
                                var total = context.dataset.data.reduce((a, b) => a + b, 0);
                                var percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                                return context.label + ': <?php echo $this->customlib->getSchoolCurrencyFormat(); ?>' + 
                                       value.toLocaleString() + ' (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    } else {
        // Show "No data" message
        ctx.font = "16px Arial";
        ctx.textAlign = "center";
        ctx.fillText("No expense data for this month", ctx.canvas.width/2, ctx.canvas.height/2);
    }
}

// =============================================
// ALERT SYSTEM
// =============================================

function showAlert(type, message) {
    var alertHtml = '<div class="alert alert-' + type + ' alert-dismissible">' +
                   '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                   message +
                   '</div>';
    
    $('.content').prepend(alertHtml);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>

<!-- Custom CSS Styles -->
<style>
/* =============================================
   INFO BOX STYLING
   ============================================= */
.info-box-number {
    font-size: 18px !important;
    font-weight: bold;
}

/* =============================================
   TRANSACTION STYLING
   ============================================= */
.currency-amount {
    font-family: 'Courier New', monospace;
    font-weight: bold;
}

.running-balance {
    font-family: 'Courier New', monospace;
    font-weight: bold;
    color: #333;
}

.transaction-description {
    max-width: 200px;
    word-wrap: break-word;
}

.transaction-row:hover {
    background-color: #f5f5f5;
}

.transaction-type-expense {
    border-left: 4px solid #dc3545;
}

.transaction-type-replenishment {
    border-left: 4px solid #28a745;
}

/* =============================================
   CATEGORY STYLING
   ============================================= */
.category-badge {
    background-color: #f0f0f0;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 11px;
    color: #666;
}

.category-item {
    margin-bottom: 15px;
    padding: 10px;
    background: #f8f9fa;
    border-radius: 5px;
}

.category-header {
    display: flex;
    justify-content: space-between;
    margin-bottom: 5px;
}

.category-name {
    font-weight: bold;
    color: #333;
}

.category-amount {
    font-weight: bold;
    color: #f39c12;
    font-family: 'Courier New', monospace;
}

.category-summary {
    max-height: 200px;
    overflow-y: auto;
}

/* =============================================
   PROGRESS BAR STYLING
   ============================================= */
.progress-sm {
    height: 6px;
    margin-bottom: 5px;
}

/* =============================================
   FORM STYLING
   ============================================= */
.error {
    border-color: #dd4b39 !important;
    box-shadow: 0 0 0 0.2rem rgba(221, 75, 57, 0.25) !important;
}

.balance-preview {
    margin-top: 5px;
}

.amount-input-group {
    position: relative;
}

.balance-status {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 12px;
}

/* =============================================
   ALERT STYLING
   ============================================= */
.low-balance-warning {
    background-color: #fff3cd;
    border: 1px solid #ffeaa7;
    color: #856404;
    padding: 10px;
    border-radius: 3px;
    margin-bottom: 15px;
}

/* =============================================
   RECONCILIATION STYLING
   ============================================= */
.reconcile-difference {
    font-weight: bold;
    padding: 5px 10px;
    border-radius: 3px;
}

.difference-positive {
    background-color: #d4edda;
    color: #155724;
}

.difference-negative {
    background-color: #f8d7da;
    color: #721c24;
}

.reconcile-info {
    background: #e8f4fd;
    border: 1px solid #bee5eb;
    padding: 10px;
    border-radius: 3px;
    margin-bottom: 15px;
}

/* =============================================
   BUTTON GROUP STYLING
   ============================================= */
.btn-group [data-filter] {
    transition: all 0.3s ease;
}

.quick-actions {
    margin-bottom: 20px;
}

.quick-actions .btn {
    margin-bottom: 10px;
}

/* =============================================
   SUMMARY BOXES
   ============================================= */
.petty-cash-summary {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    margin-bottom: 20px;
}

.monthly-summary {
    background: #fff;
    border: 1px solid #dee2e6;
    border-radius: 5px;
    padding: 15px;
    margin-bottom: 20px;
}

/* =============================================
   CASH FLOW INDICATORS
   ============================================= */
.cash-flow-indicator {
    display: inline-block;
    width: 10px;
    height: 10px;
    border-radius: 50%;
    margin-right: 5px;
}

.cash-flow-positive {
    background-color: #28a745;
}

.cash-flow-negative {
    background-color: #dc3545;
}

/* =============================================
   FILTER AND SEARCH
   ============================================= */
.transaction-filters {
    margin-bottom: 15px;
}

.transaction-search {
    margin-bottom: 15px;
}

.petty-cash-controls {
    background: #f8f9fa;
    padding: 10px;
    border-radius: 3px;
    margin-bottom: 15px;
}

/* =============================================
   EXPENSE TRENDS
   ============================================= */
.expense-trend {
    font-size: 12px;
    color: #6c757d;
    margin-top: 5px;
}

/* =============================================
   PRINT STYLES
   ============================================= */
@media print {
    .box-tools,
    .btn,
    .breadcrumb,
    .modal {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .col-md-4 {
        display: none !important;
    }
    
    .col-md-8 {
        width: 100% !important;
    }
}

/* =============================================
   RESPONSIVE DESIGN
   ============================================= */
@media (max-width: 768px) {
    .info-box-number {
        font-size: 14px !important;
    }
    
    .transaction-description {
        max-width: 150px;
    }
    
    .category-header {
        flex-direction: column;
    }
    
    .btn-group {
        width: 100%;
    }
    
    .btn-group .btn {
        width: 33.33%;
    }
}

/* =============================================
   ACCESSIBILITY IMPROVEMENTS
   ============================================= */
.btn:focus,
.form-control:focus {
    outline: 2px solid #007bff;
    outline-offset: 2px;
}

.sr-only {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
</style>