<?php
// File: application/views/admin/reports/financial/income_statement.php
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-line-chart"></i> Financial Reports
            <small><?php echo $this->lang->line('student_information'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('home'); ?></a></li>
            <li><a href="#"><?php echo $this->lang->line('reports'); ?></a></li>
            <li class="active">Financial Reports</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box removeboxmius">
                    <div class="box-header ptbnull"></div>
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> Financial Reports</h3>
                        <div class="box-tools pull-right">
                            <label class="checkbox-inline">
                                <input type="checkbox" id="auto-refresh" value="1"> Auto-refresh (5 min)
                            </label>
                        </div>
                    </div>
                    
                    <!-- Financial Reports Navigation Tabs -->
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#income_statement" data-toggle="tab">
                                    <i class="fa fa-bar-chart"></i> Income Statement
                                </a>
                            </li>
                            <li>
                                <a href="#trial_balance" data-toggle="tab">
                                    <i class="fa fa-balance-scale"></i> Trial Balance
                                </a>
                            </li>
                            <li>
                                <a href="#daily_income" data-toggle="tab">
                                    <i class="fa fa-calendar-o"></i> Daily Income
                                </a>
                            </li>
                        </ul>
                        
                        <div class="tab-content">
                            <!-- Income Statement Tab -->
                            <div class="tab-pane active" id="income_statement">
                                <h4><i class="fa fa-bar-chart"></i> Income Statement</h4>
                                
                                <!-- Date Range Form -->
                                <form id="income-statement-form" method="post" class="row">
                                    <div class="col-sm-3">
                                        <label>Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control" 
                                               value="<?php echo isset($start_date) ? $start_date : date('Y-m-01'); ?>">
                                    </div>
                                    <div class="col-sm-3">
                                        <label>End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control" 
                                               value="<?php echo isset($end_date) ? $end_date : date('Y-m-d'); ?>">
                                    </div>
                                    <div class="col-sm-3">
                                        <label>&nbsp;</label><br>
                                        <button type="button" class="btn btn-primary btn-sm" id="generate-report">
                                            <i class="fa fa-search"></i> Generate Report
                                        </button>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown">
                                                This Month <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a href="#" data-range="this_month">This Month</a></li>
                                                <li><a href="#" data-range="last_month">Last Month</a></li>
                                                <li><a href="#" data-range="this_year">This Year</a></li>
                                                <li><a href="#" data-range="financial_year">Financial Year</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <label>&nbsp;</label><br>
                                        <button type="button" class="btn btn-info btn-sm" id="export-excel">
                                            <i class="fa fa-download"></i> Export
                                        </button>
                                    </div>
                                </form>
                                
                                <br>
                                
                                <!-- Income Statement Display -->
                                <div id="income-statement-content">
                                    <?php if (isset($error)): ?>
                                        <div class="alert alert-danger">
                                            <i class="fa fa-exclamation-triangle"></i> <?php echo $error; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if (isset($income_statement)): ?>
                                        <div class="box box-primary">
                                            <div class="box-header with-border">
                                                <h3 class="box-title">
                                                    Income Statement - <?php echo isset($date_range) ? $date_range : 'Current Period'; ?>
                                                </h3>
                                            </div>
                                            <div class="box-body">
                                                <div class="row">
                                                    <!-- Revenue Section -->
                                                    <div class="col-md-6">
                                                        <h4 style="background-color: #f4f4f4; padding: 10px; margin-bottom: 15px;">
                                                            <strong>REVENUE</strong>
                                                        </h4>
                                                        <table class="table table-condensed">
                                                            <tr>
                                                                <td>OPD Consultations</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['opd_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>IPD Services</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['ipd_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Pharmacy Sales</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['pharmacy_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Laboratory Tests</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['pathology_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Radiology Services</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['radiology_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Ambulance Services</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['ambulance_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Blood Bank</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['blood_bank_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Other Income</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['other_income'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr style="background-color: #d4edda; font-weight: bold;">
                                                                <td><strong>TOTAL REVENUE</strong></td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['net_revenue'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                    
                                                    <!-- Expenses Section -->
                                                    <div class="col-md-6">
                                                        <h4 style="background-color: #f4f4f4; padding: 10px; margin-bottom: 15px;">
                                                            <strong>EXPENSES</strong>
                                                        </h4>
                                                        <table class="table table-condensed">
                                                            <tr>
                                                                <td>Staff Salaries</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['staff_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Medical Supplies</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['supply_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Utilities</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['utility_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Maintenance</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['maintenance_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Administrative</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['admin_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Other Expenses</td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['other_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                            <tr style="background-color: #f8d7da; font-weight: bold;">
                                                                <td><strong>TOTAL EXPENSES</strong></td>
                                                                <td class="text-right">
                                                                    <strong>Ksh.<?php echo number_format($income_statement['total_expenses'], 2); ?></strong>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                                
                                                <!-- Net Profit Summary -->
                                                <div class="row" style="margin-top: 20px;">
                                                    <div class="col-md-12">
                                                        <div class="box box-success">
                                                            <div class="box-header with-border">
                                                                <h3 class="box-title"><strong>Financial Summary</strong></h3>
                                                            </div>
                                                            <div class="box-body">
                                                                <div class="row">
                                                                    <div class="col-md-3">
                                                                        <div class="info-box bg-green">
                                                                            <span class="info-box-icon"><i class="fa fa-money"></i></span>
                                                                            <div class="info-box-content">
                                                                                <span class="info-box-text">Total Revenue</span>
                                                                                <span class="info-box-number">Ksh.<?php echo number_format($income_statement['net_revenue'], 0); ?></span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="info-box bg-red">
                                                                            <span class="info-box-icon"><i class="fa fa-credit-card"></i></span>
                                                                            <div class="info-box-content">
                                                                                <span class="info-box-text">Total Expenses</span>
                                                                                <span class="info-box-number">Ksh.<?php echo number_format($income_statement['total_expenses'], 0); ?></span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="info-box bg-<?php echo $income_statement['net_profit'] >= 0 ? 'blue' : 'yellow'; ?>">
                                                                            <span class="info-box-icon"><i class="fa fa-line-chart"></i></span>
                                                                            <div class="info-box-content">
                                                                                <span class="info-box-text">Net Profit</span>
                                                                                <span class="info-box-number">Ksh.<?php echo number_format($income_statement['net_profit'], 0); ?></span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <div class="info-box bg-aqua">
                                                                            <span class="info-box-icon"><i class="fa fa-percent"></i></span>
                                                                            <div class="info-box-content">
                                                                                <span class="info-box-text">Profit Margin</span>
                                                                                <span class="info-box-number"><?php echo number_format($income_statement['profit_margin'], 1); ?>%</span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- Revenue Breakdown Chart -->
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="box box-info">
                                                            <div class="box-header with-border">
                                                                <h3 class="box-title">Revenue Breakdown</h3>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="revenueChart" width="400" height="200"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="box box-warning">
                                            <div class="box-body">
                                                <p><i class="fa fa-info-circle"></i> Please select a date range and click "Generate Report" to view the income statement.</p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Trial Balance Tab -->
                            <div class="tab-pane" id="trial_balance">
                                <h4><i class="fa fa-balance-scale"></i> Trial Balance</h4>
                                <p>Trial balance functionality will be implemented here.</p>
                            </div>
                            
                            <!-- Daily Income Tab -->
                            <div class="tab-pane" id="daily_income">
                                <h4><i class="fa fa-calendar-o"></i> Daily Income</h4>
                                <p>Daily income breakdown functionality will be implemented here.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Generate Report Button
    $('#generate-report').click(function() {
        var startDate = $('#start_date').val();
        var endDate = $('#end_date').val();
        
        if (!startDate || !endDate) {
            alert('Please select both start and end dates');
            return;
        }
        
        // Show loading
        $(this).html('<i class="fa fa-spinner fa-spin"></i> Generating...');
        $(this).prop('disabled', true);
        
        // AJAX call to generate report
        $.ajax({
            url: '<?php echo base_url('admin/financialreports/generate_income_statement'); ?>',
            type: 'POST',
            data: {
                start_date: startDate,
                end_date: endDate
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    location.reload(); // Simple reload for now
                } else {
                    alert('Error: ' + (response.error || 'Unknown error occurred'));
                }
            },
            error: function() {
                alert('Network error occurred. Please try again.');
            },
            complete: function() {
                $('#generate-report').html('<i class="fa fa-search"></i> Generate Report');
                $('#generate-report').prop('disabled', false);
            }
        });
    });
    
    // Quick date range buttons
    $('.dropdown-menu a[data-range]').click(function(e) {
        e.preventDefault();
        var range = $(this).data('range');
        var today = new Date();
        var startDate, endDate;
        
        switch(range) {
            case 'this_month':
                startDate = new Date(today.getFullYear(), today.getMonth(), 1);
                endDate = today;
                break;
            case 'last_month':
                startDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
                endDate = new Date(today.getFullYear(), today.getMonth(), 0);
                break;
            case 'this_year':
                startDate = new Date(today.getFullYear(), 0, 1);
                endDate = today;
                break;
            case 'financial_year':
                // Assuming financial year starts in April
                var fyStart = today.getMonth() >= 3 ? today.getFullYear() : today.getFullYear() - 1;
                startDate = new Date(fyStart, 3, 1); // April 1st
                endDate = today;
                break;
        }
        
        $('#start_date').val(formatDate(startDate));
        $('#end_date').val(formatDate(endDate));
        $('.dropdown-toggle').html($(this).text() + ' <span class="caret"></span>');
    });
    
    // Export functionality
    $('#export-excel').click(function() {
        var startDate = $('#start_date').val();
        var endDate = $('#end_date').val();
        
        if (!startDate || !endDate) {
            alert('Please select date range first');
            return;
        }
        
        window.open('<?php echo base_url('admin/financialreports/export_income_statement'); ?>?start_date=' + startDate + '&end_date=' + endDate + '&format=excel');
    });
    
    // Auto-refresh functionality
    var autoRefreshInterval;
    $('#auto-refresh').change(function() {
        if ($(this).is(':checked')) {
            autoRefreshInterval = setInterval(function() {
                $('#generate-report').click();
            }, 300000); // 5 minutes
        } else {
            clearInterval(autoRefreshInterval);
        }
    });
    
    // Revenue Chart
    <?php if (isset($income_statement)): ?>
    var ctx = document.getElementById('revenueChart').getContext('2d');
    var revenueChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['OPD', 'IPD', 'Pharmacy', 'Laboratory', 'Radiology', 'Ambulance', 'Blood Bank', 'Other'],
            datasets: [{
                data: [
                    <?php echo $income_statement['opd_revenue']; ?>,
                    <?php echo $income_statement['ipd_revenue']; ?>,
                    <?php echo $income_statement['pharmacy_revenue']; ?>,
                    <?php echo $income_statement['pathology_revenue']; ?>,
                    <?php echo $income_statement['radiology_revenue']; ?>,
                    <?php echo $income_statement['ambulance_revenue']; ?>,
                    <?php echo $income_statement['blood_bank_revenue']; ?>,
                    <?php echo $income_statement['other_income']; ?>
                ],
                backgroundColor: [
                    '#FF6384',
                    '#36A2EB', 
                    '#FFCE56',
                    '#4BC0C0',
                    '#9966FF',
                    '#FF9F40',
                    '#FF6384',
                    '#C9CBCF'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'bottom'
            }
        }
    });
    <?php endif; ?>
});

function formatDate(date) {
    var year = date.getFullYear();
    var month = (date.getMonth() + 1).toString().padStart(2, '0');
    var day = date.getDate().toString().padStart(2, '0');
    return year + '-' + month + '-' + day;
}
</script>

<!-- Include Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
.info-box {
    margin-bottom: 15px;
}

.table-condensed td {
    padding: 5px 8px;
}

.nav-tabs-custom > .nav-tabs > li.active {
    border-top-color: #3c8dbc;
}

#revenueChart {
    max-height: 300px;
}

.box-header h3 {
    margin: 0;
}
</style>