<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-calculator"></i> Financial Dashboard
            <small>Comprehensive Financial Management</small>
        </h1>
        <ol class="breadcrumb">
            <li>
                <a href="<?php echo base_url(); ?>admin/admin/dashboard">
                    <i class="fa fa-dashboard"></i> Home
                </a>
            </li>
            <li class="active">Financial Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Financial Metrics Row -->
        <div class="row">
            <!-- Total Revenue -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>
                            <?php 
                            // Currency symbol detection
                            $currency_symbol = '';
                            if (method_exists($this->customlib, 'getHospitalCurrencyFormat')) {
                                $currency_symbol = $this->customlib->getHospitalCurrencyFormat();
                            } elseif (method_exists($this->customlib, 'getCurrencyFormat')) {
                                $currency_symbol = $this->customlib->getCurrencyFormat();
                            } else {
                                $currency_symbol = 'Ksh '; // Default for Kenya
                            }
                            echo $currency_symbol;
                            
                            // Enhanced revenue calculation including laboratory and consultation_financials
                            $total_revenue = 0;
                            
                            // Get base revenue from existing metrics
                            $base_revenue = $metrics['total_revenue'] ?? 0;
                            $total_revenue += $base_revenue;
                            
                            // Add laboratory revenue (using created_at instead of date)
                            $lab_revenue = 0;
                            if ($this->db->table_exists('laboratory')) {
                                try {
                                    $this->db->select_sum('total_cost');
                                    $this->db->from('laboratory');
                                    $this->db->where('YEAR(created_at) = ', date('Y'));
                                    $this->db->where('total_cost > 0');
                                    $lab_query = $this->db->get();
                                    if ($lab_query && $lab_query->row()) {
                                        $lab_revenue = $lab_query->row()->total_cost ?: 0;
                                        $total_revenue += $lab_revenue;
                                    }
                                } catch (Exception $e) {
                                    // If total_cost column doesn't exist, skip
                                    log_message('error', 'Laboratory revenue calculation failed: ' . $e->getMessage());
                                }
                            }
                            
                            // Add consultation financials revenue
                            $consult_revenue = 0;
                            if ($this->db->table_exists('consultation_financials')) {
                                try {
                                    $this->db->select_sum('total_amount');
                                    $this->db->from('consultation_financials');
                                    $this->db->where('YEAR(created_at) = ', date('Y'));
                                    $this->db->where('total_amount > 0');
                                    $consult_query = $this->db->get();
                                    if ($consult_query && $consult_query->row()) {
                                        $consult_revenue = $consult_query->row()->total_amount ?: 0;
                                        $total_revenue += $consult_revenue;
                                    }
                                } catch (Exception $e) {
                                    // If total_amount column doesn't exist, skip
                                    log_message('error', 'Consultation revenue calculation failed: ' . $e->getMessage());
                                }
                            }
                            
                            echo number_format($total_revenue, 2);
                            ?>
                        </h3>
                        <p>Total Revenue (YTD)</p>
                        <div class="progress-description">
                            <?php 
                            $revenue_growth = $metrics['revenue_growth'] ?? 0;
                            if ($revenue_growth > 0) {
                                echo '<i class="fa fa-arrow-up"></i> +' . number_format($revenue_growth, 1) . '% from last year';
                            } elseif ($revenue_growth < 0) {
                                echo '<i class="fa fa-arrow-down"></i> ' . number_format($revenue_growth, 1) . '% from last year';
                            } else {
                                echo '<i class="fa fa-minus"></i> No change from last year';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/profitloss" class="small-box-footer">
                        View P&L <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Net Income -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box <?php echo (($metrics['net_income'] ?? 0) >= 0) ? 'bg-blue' : 'bg-red'; ?>">
                    <div class="inner">
                        <h3>
                            <?php echo $currency_symbol; ?>
                            <?php echo number_format($metrics['net_income'] ?? 0, 2); ?>
                        </h3>
                        <p>Net Income (YTD)</p>
                        <div class="progress-description">
                            <?php 
                            // Recalculate with enhanced total revenue
                            $net_income = $metrics['net_income'] ?? 0;
                            $profit_margin = $total_revenue > 0 ? ($net_income / $total_revenue) * 100 : 0;
                            echo 'Profit Margin: ' . number_format($profit_margin, 1) . '%';
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-line-chart"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/profitloss" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Accounts Receivable -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>
                            <?php echo $currency_symbol; ?>
                            <?php echo number_format($metrics['accounts_receivable'] ?? 0, 2); ?>
                        </h3>
                        <p>Accounts Receivable</p>
                        <div class="progress-description">
                            <?php 
                            $overdue_amount = $metrics['overdue_receivables'] ?? 0;
                            if ($overdue_amount > 0) {
                                echo '<i class="fa fa-warning text-red"></i> ' . $currency_symbol . number_format($overdue_amount, 0) . ' overdue';
                            } else {
                                echo '<i class="fa fa-check text-green"></i> All current';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/accountsreceivable" class="small-box-footer">
                        Manage A/R <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Cash Balance -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>
                            <?php echo $currency_symbol; ?>
                            <?php echo number_format($metrics['cash_balance'] ?? 0, 2); ?>
                        </h3>
                        <p>Cash Balance</p>
                        <div class="progress-description">
                            <?php 
                            $cash_flow = $metrics['monthly_cash_flow'] ?? 0;
                            if ($cash_flow > 0) {
                                echo '<i class="fa fa-arrow-up text-green"></i> +' . $currency_symbol . number_format($cash_flow, 0) . ' this month';
                            } elseif ($cash_flow < 0) {
                                echo '<i class="fa fa-arrow-down text-red"></i> ' . $currency_symbol . number_format(abs($cash_flow), 0) . ' this month';
                            } else {
                                echo '<i class="fa fa-minus"></i> No change this month';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-bank"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=1" class="small-box-footer">
                        View Cash Ledger <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Secondary Metrics Row -->
        <div class="row">
            <!-- Monthly Revenue -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-green">
                        <i class="fa fa-calendar"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Monthly Revenue</span>
                        <span class="info-box-number">
                            <?php 
                            echo $currency_symbol;
                            
                            // Enhanced monthly revenue calculation
                            $monthly_revenue = $metrics['monthly_revenue'] ?? 0;
                            
                            // Add laboratory monthly revenue (using created_at)
                            if ($this->db->table_exists('laboratory')) {
                                try {
                                    $this->db->select_sum('total_cost');
                                    $this->db->from('laboratory');
                                    $this->db->where('DATE_FORMAT(created_at, "%Y-%m") = ', date('Y-m'));
                                    $this->db->where('total_cost > 0');
                                    $lab_monthly_query = $this->db->get();
                                    if ($lab_monthly_query && $lab_monthly_query->row()) {
                                        $lab_monthly = $lab_monthly_query->row()->total_cost ?: 0;
                                        $monthly_revenue += $lab_monthly;
                                    }
                                } catch (Exception $e) {
                                    // Skip if column doesn't exist
                                }
                            }
                            
                            // Add consultation financials monthly revenue
                            if ($this->db->table_exists('consultation_financials')) {
                                try {
                                    $this->db->select_sum('total_amount');
                                    $this->db->from('consultation_financials');
                                    $this->db->where('DATE_FORMAT(created_at, "%Y-%m") = ', date('Y-m'));
                                    $this->db->where('total_amount > 0');
                                    $consult_monthly_query = $this->db->get();
                                    if ($consult_monthly_query && $consult_monthly_query->row()) {
                                        $consult_monthly = $consult_monthly_query->row()->total_amount ?: 0;
                                        $monthly_revenue += $consult_monthly;
                                    }
                                } catch (Exception $e) {
                                    // Skip if column doesn't exist
                                }
                            }
                            
                            echo number_format($monthly_revenue, 2);
                            ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 85%"></div>
                        </div>
                        <span class="progress-description">
                            Target: <?php echo $currency_symbol . number_format($metrics['monthly_target'] ?? 100000, 0); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Collection Rate -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-blue">
                        <i class="fa fa-percent"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Collection Rate</span>
                        <span class="info-box-number">
                            <?php echo number_format($metrics['collection_rate'] ?? 0, 1); ?>%
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo $metrics['collection_rate'] ?? 0; ?>%"></div>
                        </div>
                        <span class="progress-description">
                            <?php 
                            $collection_rate = $metrics['collection_rate'] ?? 0;
                            if ($collection_rate >= 95) echo 'Excellent';
                            elseif ($collection_rate >= 85) echo 'Good';
                            elseif ($collection_rate >= 75) echo 'Fair';
                            else echo 'Needs Improvement';
                            ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Pending Invoices -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow">
                        <i class="fa fa-file-text"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Pending Invoices</span>
                        <span class="info-box-number">
                            <?php echo $metrics['pending_invoices'] ?? 0; ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 60%"></div>
                        </div>
                        <span class="progress-description">
                            Worth <?php echo $currency_symbol . number_format($metrics['pending_invoice_amount'] ?? 0, 0); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Service Revenue Split -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-purple">
                        <i class="fa fa-pie-chart"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Service Revenue</span>
                        <span class="info-box-number">
                            <?php 
                            // Calculate service revenue breakdown
                            $lab_revenue_ytd = $lab_revenue ?? 0;
                            $consultation_revenue_ytd = $consult_revenue ?? 0;
                            $other_revenue_ytd = ($metrics['opd_revenue'] ?? 0) + ($metrics['ipd_revenue'] ?? 0);
                            
                            $total_service_revenue = $lab_revenue_ytd + $consultation_revenue_ytd + $other_revenue_ytd;
                            
                            if ($total_service_revenue > 0) {
                                echo number_format(($lab_revenue_ytd / $total_service_revenue) * 100, 0) . '% Lab';
                            } else {
                                echo 'No Data';
                            }
                            ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar bg-purple" style="width: <?php echo $total_service_revenue > 0 ? ($lab_revenue_ytd / $total_service_revenue) * 100 : 0; ?>%"></div>
                        </div>
                        <span class="progress-description">
                            Consultation: <?php echo $currency_symbol . number_format($consultation_revenue_ytd, 0); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts and Quick Actions Row -->
        <div class="row">
            <!-- Quick Actions -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-flash"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/journalentries" 
                                   class="btn btn-primary btn-block btn-lg">
                                    <i class="fa fa-plus"></i><br>
                                    <small>Journal Entry</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/chartofaccounts" 
                                   class="btn btn-warning btn-block btn-lg">
                                    <i class="fa fa-list"></i><br>
                                    <small>Chart of Accounts</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/trialbalance" 
                                   class="btn btn-info btn-block btn-lg">
                                    <i class="fa fa-balance-scale"></i><br>
                                    <small>Trial Balance</small>
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 15px;">
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/generalledger" 
                                   class="btn btn-success btn-block btn-lg">
                                    <i class="fa fa-book"></i><br>
                                    <small>General Ledger</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/balancesheet" 
                                   class="btn btn-default btn-block btn-lg">
                                    <i class="fa fa-pie-chart"></i><br>
                                    <small>Balance Sheet</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/profitloss" 
                                   class="btn btn-danger btn-block btn-lg">
                                    <i class="fa fa-line-chart"></i><br>
                                    <small>P&L Statement</small>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Enhanced Revenue Breakdown -->
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-pie-chart"></i> Revenue Breakdown
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <h5 class="description-header text-green">
                                        <?php echo $currency_symbol . number_format($metrics['opd_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">OPD Revenue</span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <h5 class="description-header text-blue">
                                        <?php echo $currency_symbol . number_format($metrics['ipd_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">IPD Revenue</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-yellow">
                                        <?php echo $currency_symbol . number_format($metrics['pathology_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">Pathology</span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-red">
                                        <?php echo $currency_symbol . number_format($metrics['radiology_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">Radiology</span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-purple">
                                        <?php echo $currency_symbol . number_format($metrics['pharmacy_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">Pharmacy</span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-orange">
                                        <?php echo $currency_symbol . number_format($lab_revenue_ytd, 0); ?>
                                    </h5>
                                    <span class="description-text">Laboratory</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="description-block">
                                    <h5 class="description-header text-aqua">
                                        <?php echo $currency_symbol . number_format($consultation_revenue_ytd, 0); ?>
                                    </h5>
                                    <span class="description-text">Consultation Fees</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Transactions and Reports -->
        <div class="row">
            <!-- Recent Transactions -->
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-history"></i> Recent Transactions
                        </h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url(); ?>admin/financial/journalentries" 
                               class="btn btn-box-tool">
                                <i class="fa fa-external-link"></i>
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_transactions)) : ?>
                            <div class="table-responsive">
                                <table class="table table-condensed">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Reference</th>
                                            <th>Description</th>
                                            <th class="text-right">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach (array_slice($recent_transactions, 0, 5) as $transaction) : ?>
                                            <tr>
                                                <td>
                                                    <small><?php echo date('M d', strtotime($transaction['date'])); ?></small>
                                                </td>
                                                <td>
                                                    <small class="label label-default">
                                                        <?php echo $transaction['reference_no']; ?>
                                                    </small>
                                                </td>
                                                <td>
                                                    <small><?php echo substr($transaction['description'], 0, 25) . (strlen($transaction['description']) > 25 ? '...' : ''); ?></small>
                                                    <?php if (isset($transaction['source_module']) && $transaction['source_module']) : ?>
                                                        <br>
                                                        <small class="text-muted">
                                                            <i class="fa fa-tag"></i> 
                                                            <?php echo ucfirst($transaction['source_module']); ?>
                                                        </small>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-right">
                                                    <small>
                                                        <?php echo $currency_symbol; ?>
                                                        <?php echo number_format($transaction['total_amount'], 2); ?>
                                                    </small>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else : ?>
                            <div class="text-center">
                                <i class="fa fa-info-circle fa-2x text-muted"></i>
                                <p class="text-muted">No recent transactions found</p>
                                <a href="<?php echo base_url(); ?>admin/financial/journalentries" class="btn btn-primary btn-sm">
                                    <i class="fa fa-plus"></i> Add Transaction
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Financial Reports -->
            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-file-text-o"></i> Financial Reports
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="list-group">
                            <a href="<?php echo base_url(); ?>admin/financial/balancesheet" 
                               class="list-group-item">
                                <i class="fa fa-pie-chart text-aqua"></i> Balance Sheet
                                <span class="pull-right text-muted small">
                                    <em>Assets & Liabilities</em>
                                </span>
                            </a>
                            <a href="<?php echo base_url(); ?>admin/financial/profitloss" 
                               class="list-group-item">
                                <i class="fa fa-line-chart text-green"></i> Profit & Loss
                                <span class="pull-right text-muted small">
                                    <em>Revenue & Expenses</em>
                                </span>
                            </a>
                            <a href="<?php echo base_url(); ?>admin/financial/generalledger" 
                               class="list-group-item">
                                <i class="fa fa-book text-yellow"></i> General Ledger
                                <span class="pull-right text-muted small">
                                    <em>Account Transactions</em>
                                </span>
                            </a>
                            <a href="<?php echo base_url(); ?>admin/financial/accountsreceivable" 
                               class="list-group-item">
                                <i class="fa fa-clock-o text-orange"></i> A/R Aging
                                <span class="pull-right text-muted small">
                                    <em>Outstanding Balances</em>
                                </span>
                            </a>
                            <a href="<?php echo base_url(); ?>admin/financial/cashflow" 
                               class="list-group-item">
                                <i class="fa fa-exchange text-purple"></i> Cash Flow
                                <span class="pull-right text-muted small">
                                    <em>Cash In/Out Analysis</em>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Status -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-cogs"></i> System Status & Revenue Summary
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- System Status Row -->
                        <div class="row">
                            <div class="col-md-2 text-center">
                                <p>
                                    <i class="fa fa-user-md fa-2x text-blue"></i><br>
                                    <strong>OPD System</strong><br>
                                    <span class="label label-success">Active</span>
                                </p>
                            </div>
                            <div class="col-md-2 text-center">
                                <p>
                                    <i class="fa fa-bed fa-2x text-green"></i><br>
                                    <strong>IPD System</strong><br>
                                    <span class="label label-success">Active</span>
                                </p>
                            </div>
                            <div class="col-md-2 text-center">
                                <p>
                                    <i class="fa fa-flask fa-2x text-purple"></i><br>
                                    <strong>Laboratory</strong><br>
                                    <span class="label label-success">Active</span>
                                </p>
                            </div>
                            <div class="col-md-2 text-center">
                                <p>
                                    <i class="fa fa-medkit fa-2x text-purple"></i><br>
                                    <strong>Pharmacy</strong><br>
                                   <span class="label label-success">Active</span>
                               </p>
                           </div>
                           <div class="col-md-2 text-center">
                               <p>
                                   <i class="fa fa-calculator fa-2x text-yellow"></i><br>
                                   <strong>Financials</strong><br>
                                   <span class="label label-success">Active</span>
                               </p>
                           </div>
                           <div class="col-md-2 text-center">
                               <p>
                                   <i class="fa fa-database fa-2x text-aqua"></i><br>
                                   <strong>Database</strong><br>
                                   <span class="label label-success">Connected</span>
                               </p>
                           </div>
                       </div>
                       
                       <!-- Revenue Source Summary -->
                       <hr style="margin: 20px 0; border-top: 2px solid #f4f4f4;">
                       <div class="row">
                           <div class="col-md-12">
                               <h4 style="margin-bottom: 15px; color: #444;">
                                   <i class="fa fa-money"></i> Revenue Sources Summary (YTD)
                               </h4>
                           </div>
                       </div>
                       <div class="row">
                           <!-- OPD Revenue Status -->
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-user-md fa-3x text-blue"></i>
                                   <h5 class="text-blue" style="margin: 10px 0 5px 0;">OPD Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php echo $currency_symbol . number_format($metrics['opd_revenue'] ?? 0, 0); ?>
                                   </h4>
                                   <small class="text-muted">
                                       <?php 
                                       $opd_count = 0;
                                       if ($this->db->table_exists('opd_details')) {
                                           try {
                                               $this->db->where('YEAR(created_at) = ', date('Y'));
                                               $opd_count = $this->db->count_all_results('opd_details');
                                           } catch (Exception $e) {
                                               // Skip if error
                                           }
                                       }
                                       echo $opd_count . ' visits this year';
                                       ?>
                                   </small>
                               </div>
                           </div>
                           
                           <!-- IPD Revenue Status -->
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-bed fa-3x text-green"></i>
                                   <h5 class="text-green" style="margin: 10px 0 5px 0;">IPD Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php echo $currency_symbol . number_format($metrics['ipd_revenue'] ?? 0, 0); ?>
                                   </h4>
                                   <small class="text-muted">
                                       <?php 
                                       $ipd_count = 0;
                                       if ($this->db->table_exists('ipd_details')) {
                                           try {
                                               $this->db->where('YEAR(created_at) = ', date('Y'));
                                               $ipd_count = $this->db->count_all_results('ipd_details');
                                           } catch (Exception $e) {
                                               // Skip if error
                                           }
                                       }
                                       echo $ipd_count . ' admissions this year';
                                       ?>
                                   </small>
                               </div>
                           </div>
                           
                           <!-- Laboratory Revenue Status -->
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-flask fa-3x text-purple"></i>
                                   <h5 class="text-purple" style="margin: 10px 0 5px 0;">Laboratory Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php 
                                       $lab_revenue_total = $lab_revenue ?? 0;
                                       $lab_test_count = 0;
                                       if ($this->db->table_exists('laboratory')) {
                                           try {
                                               // Get test count using created_at
                                               $this->db->where('YEAR(created_at) = ', date('Y'));
                                               $lab_test_count = $this->db->count_all_results('laboratory');
                                           } catch (Exception $e) {
                                               // Skip if error
                                           }
                                       }
                                       echo $currency_symbol . number_format($lab_revenue_total, 0);
                                       ?>
                                   </h4>
                                   <small class="text-muted">
                                       <?php echo $lab_test_count . ' tests this year'; ?>
                                   </small>
                               </div>
                           </div>
                           
                           <!-- Consultation Revenue Status -->
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-stethoscope fa-3x text-orange"></i>
                                   <h5 class="text-orange" style="margin: 10px 0 5px 0;">Consultation Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php 
                                       $consultation_revenue_total = $consult_revenue ?? 0;
                                       $consultation_count = 0;
                                       if ($this->db->table_exists('consultation_financials')) {
                                           try {
                                               // Get consultation count
                                               $this->db->where('YEAR(created_at) = ', date('Y'));
                                               $consultation_count = $this->db->count_all_results('consultation_financials');
                                           } catch (Exception $e) {
                                               // Skip if error
                                           }
                                       }
                                       echo $currency_symbol . number_format($consultation_revenue_total, 0);
                                       ?>
                                   </h4>
                                   <small class="text-muted">
                                       <?php echo $consultation_count . ' consultations this year'; ?>
                                   </small>
                               </div>
                           </div>
                       </div>
                       
                       <!-- Additional Revenue Sources Row -->
                       <div class="row" style="margin-top: 20px;">
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-camera fa-3x text-red"></i>
                                   <h5 class="text-red" style="margin: 10px 0 5px 0;">Radiology Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php echo $currency_symbol . number_format($metrics['radiology_revenue'] ?? 0, 0); ?>
                                   </h4>
                                   <small class="text-muted">Imaging services</small>
                               </div>
                           </div>
                           
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-medkit fa-3x text-aqua"></i>
                                   <h5 class="text-aqua" style="margin: 10px 0 5px 0;">Pharmacy Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php echo $currency_symbol . number_format($metrics['pharmacy_revenue'] ?? 0, 0); ?>
                                   </h4>
                                   <small class="text-muted">Medicine sales</small>
                               </div>
                           </div>
                           
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-microscope fa-3x text-yellow"></i>
                                   <h5 class="text-yellow" style="margin: 10px 0 5px 0;">Pathology Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php echo $currency_symbol . number_format($metrics['pathology_revenue'] ?? 0, 0); ?>
                                   </h4>
                                   <small class="text-muted">Lab analysis</small>
                               </div>
                           </div>
                           
                           <div class="col-md-3 text-center">
                               <div class="revenue-status-block">
                                   <i class="fa fa-plus-circle fa-3x text-navy"></i>
                                   <h5 class="text-navy" style="margin: 10px 0 5px 0;">Other Revenue</h5>
                                   <h4 style="margin: 0; font-weight: bold;">
                                       <?php 
                                       // Calculate other revenue sources
                                       $other_revenue = 0;
                                       $known_revenue = ($metrics['opd_revenue'] ?? 0) + 
                                                      ($metrics['ipd_revenue'] ?? 0) + 
                                                      ($metrics['radiology_revenue'] ?? 0) + 
                                                      ($metrics['pharmacy_revenue'] ?? 0) + 
                                                      ($metrics['pathology_revenue'] ?? 0) + 
                                                      $lab_revenue_total + 
                                                      $consultation_revenue_total;
                                       $total_system_revenue = $total_revenue;
                                       $other_revenue = max(0, $total_system_revenue - $known_revenue);
                                       echo $currency_symbol . number_format($other_revenue, 0);
                                       ?>
                                   </h4>
                                   <small class="text-muted">Miscellaneous income</small>
                               </div>
                           </div>
                       </div>
                       
                       <!-- Revenue Totals Summary -->
                       <hr style="margin: 20px 0; border-top: 2px solid #f4f4f4;">
                       <div class="row">
                           <div class="col-md-4 text-center">
                               <div class="summary-block bg-light-green" style="padding: 15px; border-radius: 5px; background: #f0f8ff;">
                                   <h4 style="margin: 0; color: #3c8dbc;">
                                       <i class="fa fa-calendar"></i> This Month
                                   </h4>
                                   <h3 style="margin: 10px 0; font-weight: bold; color: #3c8dbc;">
                                       <?php 
                                       echo $currency_symbol . number_format($monthly_revenue, 0);
                                       ?>
                                   </h3>
                                   <small class="text-muted">Monthly total revenue</small>
                               </div>
                           </div>
                           
                           <div class="col-md-4 text-center">
                               <div class="summary-block bg-light-green" style="padding: 15px; border-radius: 5px; background: #f0fff0;">
                                   <h4 style="margin: 0; color: #00a65a;">
                                       <i class="fa fa-line-chart"></i> This Year
                                   </h4>
                                   <h3 style="margin: 10px 0; font-weight: bold; color: #00a65a;">
                                       <?php 
                                       echo $currency_symbol . number_format($total_revenue, 0);
                                       ?>
                                   </h3>
                                   <small class="text-muted">Year-to-date revenue</small>
                               </div>
                           </div>
                           
                           <div class="col-md-4 text-center">
                               <div class="summary-block bg-light-yellow" style="padding: 15px; border-radius: 5px; background: #fffbf0;">
                                   <h4 style="margin: 0; color: #f39c12;">
                                       <i class="fa fa-target"></i> Progress
                                   </h4>
                                   <h3 style="margin: 10px 0; font-weight: bold; color: #f39c12;">
                                       <?php 
                                       $annual_target = ($metrics['monthly_target'] ?? 100000) * 12;
                                       $progress_percentage = $annual_target > 0 ? ($total_revenue / $annual_target) * 100 : 0;
                                       echo number_format($progress_percentage, 1) . '%';
                                       ?>
                                   </h3>
                                   <small class="text-muted">
                                       Target: <?php echo $currency_symbol . number_format($annual_target, 0); ?>
                                   </small>
                               </div>
                           </div>
                       </div>
                       
                       <!-- Data Sources Info x
                       <div class="row" style="margin-top: 20px;">
                           <div class="col-md-12">
                               <div class="alert alert-info" style="margin: 0;">
                                   <i class="fa fa-info-circle"></i> 
                                   <strong>Revenue Sources Update:</strong> 
                                   Dashboard now correctly uses <code>created_at</code> columns for Laboratory and Consultation revenue calculations.
                                   <?php 
                                   // Check if laboratory table has total_cost column
                                   $lab_has_total_cost = false;
                                   if ($this->db->table_exists('laboratory')) {
                                       $lab_has_total_cost = $this->db->field_exists('total_cost', 'laboratory');
                                   }
                                   
                                   // Check if consultation_financials table has total_amount column
                                   $consult_has_total_amount = false;
                                   if ($this->db->table_exists('consultation_financials')) {
                                       $consult_has_total_amount = $this->db->field_exists('total_amount', 'consultation_financials');
                                   }
                                   ?>
                                   <br>
                                   <small class="text-muted">
                                       Last updated: <?php echo date('F j, Y g:i A'); ?> | 
                                       Laboratory table: <?php echo $this->db->table_exists('laboratory') ? 'Connected' : 'Not Found'; ?>
                                       <?php if (!$lab_has_total_cost && $this->db->table_exists('laboratory')) echo ' (total_cost column missing)'; ?> | 
                                       Consultation Financials: <?php echo $this->db->table_exists('consultation_financials') ? 'Connected' : 'Not Found'; ?>
                                       <?php if (!$consult_has_total_amount && $this->db->table_exists('consultation_financials')) echo ' (total_amount column missing)'; ?>
                                   </small>
                               </div>
                           </div>
                       </div> -->
                       
                       <!-- Debug Information (only show in development) -->
                       <?php if (ENVIRONMENT === 'development') : ?>
                       <div class="row" style="margin-top: 15px;">
                           <div class="col-md-12">
                               <div class="alert alert-warning" style="margin: 0;">
                                   <h5><i class="fa fa-bug"></i> Development Debug Info</h5>
                                   <small>
                                       <strong>Laboratory Table Structure:</strong>
                                       <?php
                                       if ($this->db->table_exists('laboratory')) {
                                           $lab_fields = $this->db->field_data('laboratory');
                                           $lab_field_names = array();
                                           foreach ($lab_fields as $field) {
                                               $lab_field_names[] = $field->name . ' (' . $field->type . ')';
                                           }
                                           echo implode(', ', $lab_field_names);
                                       } else {
                                           echo 'Table not found';
                                       }
                                       ?>
                                       <br>
                                       <strong>Total Revenue Calculation:</strong> 
                                       Base: <?php echo $currency_symbol . number_format($base_revenue, 2); ?> + 
                                       Lab: <?php echo $currency_symbol . number_format($lab_revenue, 2); ?> + 
                                       Consultation: <?php echo $currency_symbol . number_format($consult_revenue, 2); ?> = 
                                       <?php echo $currency_symbol . number_format($total_revenue, 2); ?>
                                   </small>
                               </div>
                           </div>
                       </div>
                       <?php endif; ?>
                   </div>
               </div>
           </div>
       </div>

   </section>
</div>

<!-- Critical CSS Styles -->
<style>
/* Critical Dashboard Styles */
.small-box {
   border-radius: 8px;
   position: relative;
   display: block;
   margin-bottom: 20px;
   box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.small-box > .inner {
   padding: 10px;
}

.small-box > .small-box-footer {
   position: relative;
   text-align: center;
   padding: 3px 0;
   color: #fff;
   color: rgba(255,255,255,0.8);
   display: block;
   z-index: 10;
   background: rgba(0,0,0,0.1);
   text-decoration: none;
}

.small-box > .small-box-footer:hover {
   color: #fff;
   background: rgba(0,0,0,0.15);
}

.small-box h3 {
   font-size: 38px;
   font-weight: bold;
   margin: 0 0 10px 0;
   white-space: nowrap;
   padding: 0;
}

.small-box p {
   font-size: 15px;
}

.small-box p > small {
   display: block;
   color: #f9f9f9;
   font-size: 13px;
   margin-top: 5px;
}

.small-box h3, .small-box p {
   z-index: 5;
}

.small-box .icon {
   transition: all .3s linear;
   position: absolute;
   top: -10px;
   right: 10px;
   z-index: 0;
   font-size: 90px;
   color: rgba(0,0,0,0.15);
}

.small-box:hover {
   text-decoration: none;
   color: #f9f9f9;
}

.small-box:hover .icon {
   font-size: 95px;
}

/* Background Colors */
.bg-green {
   background-color: #00a65a !important;
   color: #fff !important;
}

.bg-blue {
   background-color: #3c8dbc !important;
   color: #fff !important;
}

.bg-yellow {
   background-color: #f39c12 !important;
   color: #fff !important;
}

.bg-red {
   background-color: #dd4b39 !important;
   color: #fff !important;
}

.bg-aqua {
   background-color: #00c0ef !important;
   color: #fff !important;
}

.bg-purple {
   background-color: #605ca8 !important;
   color: #fff !important;
}

/* Info Box Styles */
.info-box {
   display: block;
   min-height: 90px;
   background: #fff;
   width: 100%;
   box-shadow: 0 1px 1px rgba(0,0,0,0.1);
   border-radius: 2px;
   margin-bottom: 15px;
}

.info-box-icon {
   border-top-left-radius: 2px;
   border-top-right-radius: 0;
   border-bottom-right-radius: 0;
   border-bottom-left-radius: 2px;
   display: block;
   float: left;
   height: 90px;
   width: 90px;
   text-align: center;
   font-size: 45px;
   line-height: 90px;
   background: rgba(0,0,0,0.2);
}

.info-box-content {
   padding: 5px 10px;
   margin-left: 90px;
}

.info-box-number {
   display: block;
   font-weight: bold;
   font-size: 18px;
}

.info-box-text {
   display: block;
   font-size: 14px;
   white-space: nowrap;
   overflow: hidden;
   text-overflow: ellipsis;
}

.progress {
   background: rgba(0,0,0,0.2);
   height: 2px;
   margin: 5px -10px 5px -10px;
   overflow: hidden;
}

.progress-bar {
   float: left;
   width: 0;
   height: 100%;
   font-size: 12px;
   line-height: 2px;
   color: #fff;
   text-align: center;
   background-color: #337ab7;
   transition: width .6s ease;
}

.progress-description {
   display: block;
   font-size: 13px;
   white-space: nowrap;
   overflow: hidden;
   text-overflow: ellipsis;
}

/* Box Styles */
.box {
   position: relative;
   border-radius: 3px;
   background: #ffffff;
   border-top: 3px solid #d2d6de;
   margin-bottom: 20px;
   width: 100%;
   box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.box.box-primary {
   border-top-color: #3c8dbc;
}

.box.box-success {
   border-top-color: #00a65a;
}

.box.box-warning {
   border-top-color: #f39c12;
}

.box.box-info {
   border-top-color: #00c0ef;
}

.box.box-default {
   border-top-color: #d2d6de;
}

.box-header {
   color: #444;
   display: block;
   padding: 10px;
   position: relative;
}

.box-header.with-border {
   border-bottom: 1px solid #f4f4f4;
}

.box-title {
   font-size: 18px;
   margin: 0;
   line-height: 1;
}

.box-tools {
   position: absolute;
   right: 10px;
   top: 5px;
}

.box-body {
   border-top-left-radius: 0;
   border-top-right-radius: 0;
   border-bottom-right-radius: 3px;
   border-bottom-left-radius: 3px;
   padding: 10px;
}

/* Button Styles */
.btn-lg {
   padding: 15px 10px;
   text-align: center;
   min-height: 80px;
   display: flex;
   flex-direction: column;
   justify-content: center;
   align-items: center;
   text-decoration: none;
   border-radius: 4px;
   border: 1px solid transparent;
}

.btn-lg i {
   font-size: 24px;
   margin-bottom: 5px;
}

.btn-lg small {
   font-size: 11px;
   line-height: 1.2;
}

.btn-primary {
   color: #fff;
   background-color: #337ab7;
   border-color: #2e6da4;
}

.btn-success {
   color: #fff;
   background-color: #5cb85c;
   border-color: #4cae4c;
}

.btn-warning {
   color: #fff;
   background-color: #f0ad4e;
   border-color: #eea236;
}

.btn-info {
   color: #fff;
   background-color: #5bc0de;
   border-color: #46b8da;
}

.btn-danger {
   color: #fff;
   background-color: #d9534f;
   border-color: #d43f3a;
}

.btn-default {
   color: #333;
   background-color: #fff;
   border-color: #ccc;
}

/* Text Colors */
.text-green { color: #00a65a; }
.text-blue { color: #3c8dbc; }
.text-yellow { color: #f39c12; }
.text-red { color: #dd4b39; }
.text-purple { color: #605ca8; }
.text-aqua { color: #00c0ef; }
.text-orange { color: #ff851b; }
.text-navy { color: #001f3f; }
.text-muted { color: #777; }

/* Revenue Status Block Styling */
.revenue-status-block {
   padding: 15px;
   border-radius: 8px;
   background: #ffffff;
   box-shadow: 0 2px 4px rgba(0,0,0,0.1);
   margin-bottom: 15px;
   border: 1px solid #f0f0f0;
   transition: all 0.3s ease;
}

.revenue-status-block:hover {
   transform: translateY(-2px);
   box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

/* Summary Block Styling */
.summary-block {
   border: 2px solid transparent;
   transition: all 0.3s ease;
}

.summary-block:hover {
   transform: translateY(-3px);
   box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.bg-light-blue {
   border-color: #3c8dbc !important;
}

.bg-light-green {
   border-color: #00a65a !important;
}

.bg-light-yellow {
   border-color: #f39c12 !important;
}

/* Alert Styles */
.alert-info {
   background-color: #d9edf7;
   border-color: #bce8f1;
   color: #31708f;
   border-radius: 4px;
   padding: 15px;
   border: 1px solid transparent;
}

.alert-warning {
   background-color: #fcf8e3;
   border-color: #faebcc;
   color: #8a6d3b;
   border-radius: 4px;
   padding: 15px;
   border: 1px solid transparent;
}

/* Icon Styling */
.fa-3x {
   font-size: 3em !important;
}

/* List Group, Table, Label, Description Block styles remain the same... */
/* Responsive Design */
@media (max-width: 768px) {
   .btn-lg {
       min-height: 60px;
       padding: 10px 5px;
   }
   
   .btn-lg i {
       font-size: 18px;
   }
   
   .small-box h3 {
       font-size: 28px;
   }
   
   .info-box-number {
       font-size: 16px;
   }
   
   .small-box .icon {
       font-size: 60px;
   }
   
   .revenue-status-block {
       margin-bottom: 20px;
       padding: 10px;
   }
   
   .revenue-status-block h4 {
       font-size: 18px;
   }
   
   .fa-3x {
       font-size: 2em !important;
   }
}
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
   // Add hover effects
   $('.small-box').hover(
       function() {
           $(this).addClass('hover-effect');
       },
       function() {
           $(this).removeClass('hover-effect');
       }
   );
   
   // Collapsible boxes
   $('[data-widget="collapse"]').click(function() {
       var box = $(this).closest('.box');
       var boxBody = box.find('.box-body');
       var icon = $(this).find('i');
       
       if (boxBody.is(':visible')) {
           boxBody.slideUp();
           icon.removeClass('fa-minus').addClass('fa-plus');
       } else {
           boxBody.slideDown();
           icon.removeClass('fa-plus').addClass('fa-minus');
       }
   });
});

// Debug function
function debugDashboard() {
   console.log('Fixed Financial Dashboard Debug:');
   console.log('Currency Symbol: <?php echo $currency_symbol; ?>');
   console.log('Total Revenue: <?php echo $total_revenue ?? 0; ?>');
   console.log('Laboratory Revenue: <?php echo $lab_revenue ?? 0; ?>');
   console.log('Consultation Revenue: <?php echo $consult_revenue ?? 0; ?>');
   console.log('Using created_at column for date filters');
}

debugDashboard();
</script>