<?php
// Include SecuGen WebAPI scripts at the top
?>
<script src="<?php echo base_url('WebAPI-JavaScript/secugen.js'); ?>"></script>

<div class="content-wrapper">
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-user-md"></i> Patient Consultation with SecuGen Fingerprint Verification & Lab Tests
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" id="addConsultationBtn" class="btn btn-primary btn-sm">
                                <i class="fa fa-plus"></i> New Consultation
                            </button>
                            <button type="button" id="labReportBtn" class="btn btn-success btn-sm">
                                <i class="fa fa-flask"></i> Lab Reports
                            </button>
                        </div>
                    </div>

                    <ul class="nav nav-tabs navlistscroll">
                        <li class="active"><a href="#tab_patient_search" data-toggle="tab">
                            <i class="fa fa-search"></i> Patient Search & Verification
                        </a></li>
                        <li><a href="#tab_consultation_list" data-toggle="tab">
                            <i class="fa fa-list"></i> Consultation Records
                        </a></li>
                        <!--<li><a href="#tab_lab_dashboard" data-toggle="tab">
                            <i class="fa fa-flask"></i> Lab Dashboard
                        </a></li>
                        <li><a href="#tab_verification_logs" data-toggle="tab">
                            <i class="fa fa-shield"></i> Verification Logs
                        </a></li>-->
                    </ul>

                    <div class="tab-content">
                        <!-- Patient Search & Verification Tab -->
                        <div class="tab-pane active" id="tab_patient_search">
                            <div class="box-body">
                                <!-- Patient Search Section -->
                                <div class="row" style="margin-top: 20px;">
                                    <div class="col-md-10">
                                        <div class="form-group">
                                            <label>Search Patient</label>
                                            <select class="form-control" id="consultation_patient_search" name="patient_search" style="width: 100%;">
                                                <option value="">Loading patients...</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label>&nbsp;</label><br>
                                        <button type="button" class="btn btn-success btn-block" onclick="$('#addPatientModal').modal('show')">
                                            <i class="fa fa-plus"></i> Add Patient
                                        </button>
                                    </div>
                                </div>

                                <!-- Patient Details Section -->
                                <div id="patientDetailsSection" style="display:none; margin-top: 20px;">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title">
                                                <i class="fa fa-user"></i> Patient Information
                                                <span class="pull-right" id="verificationStatus"></span>
                                            </h4>
                                        </div>
                                        <div class="panel-body">
                                            <!-- Patient Basic Information -->
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <p><strong>Name:</strong> <span id="patientName"></span></p>
                                                            <p><strong>Age:</strong> <span id="patientAge"></span></p>
                                                            <p><strong>Gender:</strong> <span id="patientGender"></span></p>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <p><strong>Phone:</strong> <span id="patientPhone"></span></p>
                                                            <p><strong>Blood Group:</strong> <span id="patientBloodGroup"></span></p>
                                                            <p><strong>Allergies:</strong> <span id="patientAllergies"></span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="text-center">
                                                        <img id="patientPhoto" src="<?php echo base_url('uploads/patient_images/no_image.png'); ?>" alt="Patient Photo" class="img-responsive" style="max-height: 120px; border: 1px solid #ddd; border-radius: 4px;">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Enhanced SecuGen Fingerprint Verification Section -->
                                            <div class="row" style="margin-top: 20px;">
                                                <div class="col-md-8">
                                                    <div class="panel panel-info">
                                                        <div class="panel-heading">
                                                            <h5 class="panel-title">
                                                                <i class="fa fa-fingerprint"></i> SecuGen Biometric Verification System
                                                            </h5>
                                                        </div>
                                                        <div class="panel-body">
                                                            <!-- Service Status -->
                                                            <div id="secugen_service_status" class="mb-2"></div>
                                                            
                                                            <!-- Fingerprint Display -->
                                                            <div class="row mb-3">
                                                                <div class="col-md-6">
                                                                    <div class="panel panel-default">
                                                                        <div class="panel-heading" style="padding: 5px 10px;">
                                                                            <h6 class="panel-title">Stored Template</h6>
                                                                        </div>
                                                                        <div class="panel-body text-center" style="padding: 10px;">
                                                                            <img id="storedFingerprintImage" src="./Images/PlaceFinger.bmp" alt="Stored Fingerprint" 
                                                                                 style="height: 100px; width: 80px; border: 1px solid #ddd; border-radius: 4px;">
                                                                            <div id="storedTemplateInfo" style="margin-top: 8px; font-size: 11px;">
                                                                                <div id="storedTemplateDetails" class="text-muted">No template loaded</div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="panel panel-default">
                                                                        <div class="panel-heading" style="padding: 5px 10px;">
                                                                            <h6 class="panel-title">Live Capture</h6>
                                                                        </div>
                                                                        <div class="panel-body text-center" style="padding: 10px;">
                                                                            <img id="liveFingerprintImage" src="./Images/PlaceFinger.bmp" alt="Live Fingerprint" 
                                                                                 style="height: 100px; width: 80px; border: 1px solid #ddd; border-radius: 4px;">
                                                                            <div id="liveTemplateInfo" style="margin-top: 8px; font-size: 11px;">
                                                                                <div id="liveTemplateDetails" class="text-muted">Ready for capture</div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <!-- Verification Status -->
                                                            <div id="fingerprintStatus" class="text-center mb-3">
                                                                <div class="alert alert-info">
                                                                    <i class="fa fa-info-circle"></i> Ready for SecuGen biometric verification
                                                                </div>
                                                            </div>
                                                            
                                                            <!-- Verification Controls -->
                                                            <div class="text-center">
                                                                <div class="btn-group" style="margin-bottom: 10px;">
                                                                    <button type="button" id="manualVerifyBtn" class="btn btn-info">
                                                                        <i class="fa fa-hand-pointer-o"></i> Manual Print Capture
                                                                    </button>
                                                                    <button type="button" id="verifyIdentity" class="btn btn-success" disabled>
                                                                        <i class="fa fa-shield"></i> Verify Print
                                                                    </button>
                                                                </div>
                                                                <div>
                                                                    <button type="button" id="skipVerificationBtn" class="btn btn-warning">
                                                                        <i class="fa fa-user-shield"></i> Admin Override
                                                                    </button>
                                                                    <button type="button" id="clearCaptureData" class="btn btn-default">
                                                                        <i class="fa fa-refresh"></i> Clear Data
                                                                    </button>
                                                                </div>
                                                            </div>
                                                            
                                                            <!-- Hidden fields -->
                                                            <input type="hidden" id="patientStoredTemplate" value="">
                                                            <input type="hidden" id="liveScannedTemplate" value="">
                                                            <input type="hidden" id="lastMatchScore" value="0">
                                                            <input type="hidden" id="verificationQuality" value="">
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- Recent Consultations Panel -->
                                                <div class="col-md-4">
                                                    <div class="panel panel-success">
                                                        <div class="panel-heading">
                                                            <h5 class="panel-title">
                                                                <i class="fa fa-history"></i> Recent Consultations
                                                            </h5>
                                                        </div>
                                                        <div class="panel-body">
                                                            <div id="recentConsultations">
                                                                <p class="text-muted">Select a patient to view consultation history</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!-- Verification History Panel -->
                                                    <div class="panel panel-warning">
                                                        <div class="panel-heading">
                                                            <h5 class="panel-title">
                                                                <i class="fa fa-shield"></i> Verification History
                                                            </h5>
                                                        </div>
                                                        <div class="panel-body">
                                                            <div id="verificationHistory" style="max-height: 200px; overflow-y: auto;">
                                                                <p class="text-muted">No verification attempts yet</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Start Consultation Button -->
                                            <div class="text-center" style="margin-top: 20px;">
                                                <button type="button" id="startConsultationBtn" class="btn btn-primary btn-lg" disabled>
                                                    <i class="fa fa-user-md"></i> Start Consultation
                                                </button>
                                                <div id="verificationMessage" style="margin-top: 10px;"></div>
                                            </div>

                                            <!-- Hidden fields -->
                                            <input type="hidden" id="selectedPatientId" value="">
                                            <input type="hidden" id="verificationPassed" value="0">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Consultation List Tab -->
                        <div class="tab-pane" id="tab_consultation_list">
                            <div class="box-body">
                                <div class="download_label">Consultation Records</div>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered table-hover" id="consultationListTable">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Date</th>
                                                <th>Patient</th>
                                                <th>Doctor</th>
                                                <th>Symptoms</th>
                                                <th>Tests Ordered</th>
                                                <th>Verification</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- NEW: Lab Dashboard Tab -->
                        <div class="tab-pane" id="tab_lab_dashboard">
                            <div class="box-body">
                                <div class="download_label">Laboratory Dashboard</div>
                                
                                <!-- Lab Summary Cards -->
                                <div class="row">
                                    <div class="col-lg-3 col-xs-6">
                                        <div class="small-box bg-aqua">
                                            <div class="inner">
                                                <h3 id="total_tests">0</h3>
                                                <p>Total Tests</p>
                                            </div>
                                            <div class="icon">
                                                <i class="fa fa-flask"></i>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-3 col-xs-6">
                                        <div class="small-box bg-green">
                                            <div class="inner">
                                                <h3 id="pending_tests">0</h3>
                                                <p>Pending Tests</p>
                                            </div>
                                            <div class="icon">
                                                <i class="fa fa-clock-o"></i>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-3 col-xs-6">
                                        <div class="small-box bg-yellow">
                                            <div class="inner">
                                                <h3 id="completed_tests">0</h3>
                                                <p>Completed Tests</p>
                                            </div>
                                            <div class="icon">
                                                <i class="fa fa-check-circle"></i>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-3 col-xs-6">
                                        <div class="small-box bg-red">
                                            <div class="inner">
                                                <h3 id="critical_results">0</h3>
                                                <p>Critical Results</p>
                                            </div>
                                            <div class="icon">
                                                <i class="fa fa-exclamation-triangle"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Lab Tests by Category -->
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="box box-primary">
                                            <div class="box-header with-border">
                                                <h3 class="box-title">Test Distribution by Category</h3>
                                            </div>
                                            <div class="box-body">
                                                <canvas id="testsChart" style="height: 300px;"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="box box-info">
                                            <div class="box-header with-border">
                                                <h3 class="box-title">Test Status</h3>
                                            </div>
                                            <div class="box-body">
                                                <canvas id="testStatusChart" style="height: 300px;"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Recent Lab Tests Table -->
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="box box-success">
                                            <div class="box-header with-border">
                                                <h3 class="box-title">Recent Lab Tests</h3>
                                                <div class="box-tools pull-right">
                                                    <button type="button" id="exportLabReport" class="btn btn-success btn-sm">
                                                        <i class="fa fa-download"></i> Export Report
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="box-body">
                                                <div class="table-responsive">
                                                    <table class="table table-striped table-bordered" id="labTestsTable">
                                                        <thead>
                                                            <tr>
                                                                <th>Date</th>
                                                                <th>Patient</th>
                                                                <th>Test Name</th>
                                                                <th>Category</th>
                                                                <th>Status</th>
                                                                <th>Result</th>
                                                                <th>Actions</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody></tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Verification Logs Tab -->
                        <div class="tab-pane" id="tab_verification_logs">
                            <div class="box-body">
                                <div class="download_label">SecuGen Verification Logs</div>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered table-hover" id="verificationLogsTable">
                                        <thead>
                                            <tr>
                                                <th>Timestamp</th>
                                                <th>Patient</th>
                                                <th>Staff</th>
                                                <th>Match Score</th>
                                                <th>Result</th>
                                                <th>Quality</th>
                                                <th>Device</th>
                                                <th>Details</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Enhanced Consultation Modal with Lab Tests Section -->
<div class="modal fade" id="consultationModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-user-md"></i> <span id="modalTitle">New Consultation</span>
                </h4>
            </div>
            <form id="consultationForm">
                <div class="modal-body">
                    <!-- Patient Info Display -->
                    <div class="alert alert-info">
                        <div class="row">
                            <div class="col-md-8">
                                <strong>Patient:</strong> <span id="modalPatientName"></span><br>
                                <small>ID: <span id="modalPatientId"></span></small>
                            </div>
                            <div class="col-md-4 text-right">
                                <span id="modalVerificationBadge"></span>
                                <div id="modalVerificationDetails" style="font-size: 11px; margin-top: 5px;"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Consultation Date <span class="text-danger">*</span></label>
                                <input type="date" name="consultation_date" id="consultationDate" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Doctor <span class="text-danger">*</span></label>
                                <select name="doctor" id="consultationDoctor" class="form-control" required>
                                    <option value="">Select Doctor</option>
                                    <?php if (isset($doctors)) { foreach ($doctors as $doctor) { ?>
                                        <option value="<?php echo $doctor['id']; ?>">
                                            Dr. <?php echo $doctor['name'] . ' ' . ($doctor['surname'] ?? ''); ?>
                                        </option>
                                    <?php }} ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Symptoms <span class="text-danger">*</span></label>
                        <textarea name="symptoms" id="consultationSymptoms" class="form-control" rows="4" placeholder="Describe patient symptoms..." required></textarea>
                    </div>

                    <!-- ICD-10 Diagnosis Dropdown -->
                    <div class="form-group">
                        <label>Primary Diagnosis (ICD-10)</label>
                        <div class="row">
                            <div class="col-md-8">
                                <select name="diagnosis_code_id" id="consultationDiagnosis" class="form-control" style="width: 100%;">
                                    <option value="">Search and select ICD-10 diagnosis...</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <button type="button" id="addCustomDiagnosis" class="btn btn-info btn-sm">
                                    <i class="fa fa-plus"></i> Add Custom
                                </button>
                                <button type="button" id="clearDiagnosis" class="btn btn-default btn-sm">
                                    <i class="fa fa-times"></i> Clear
                                </button>
                            </div>
                        </div>
                        <div id="selectedDiagnosisInfo" style="margin-top: 8px; display: none;">
                            <div class="alert alert-success" style="padding: 8px; margin-bottom: 8px;">
                                <strong>Selected:</strong> <span id="selectedDiagnosisCode"></span> - <span id="selectedDiagnosisTitle"></span><br>
                                <small class="text-muted" id="selectedDiagnosisCategory"></small>
                            </div>
                        </div>
                    </div>

                    <!-- Custom Diagnosis Input -->
                    <div class="form-group" id="customDiagnosisGroup" style="display: none;">
                        <label>Custom Diagnosis Description</label>
                        <textarea name="diagnosis_custom" id="consultationDiagnosisCustom" class="form-control" rows="2" placeholder="Enter custom diagnosis if not found in ICD-10 codes..."></textarea>
                        <small class="text-info">Use this field for diagnoses not covered by standard ICD-10 codes</small>
                    </div>

                    <!-- NEW: Laboratory Tests Section (Replacing Financial Details) -->
                    <div class="panel panel-success" style="margin-top: 15px;">
                        
                        <div class="panel-body">
                            
                            <!-- Test Priority and Notes -->
                            <div class="row" style="margin-top: 10px;">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Test Priority</label>
                                        <select name="test_priority" id="testPriority" class="form-control">
                                            <option value="normal">Normal</option>
                                            <option value="urgent">Urgent</option>
                                            <option value="stat">STAT</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Special Instructions</label>
                                        <input type="text" name="test_instructions" id="testInstructions" class="form-control" placeholder="Special instructions for lab...">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Notes</label>
                        <textarea name="notes" id="consultationNotes" class="form-control" rows="3" placeholder="Additional consultation notes..."></textarea>
                    </div>

                    <!-- Hidden fields for verification data -->
                    <input type="hidden" name="patient_id" id="modalPatientIdHidden">
                    <input type="hidden" name="consultation_id" id="modalConsultationId">
                    <input type="hidden" name="verification_status" id="modalVerificationStatus" value="0">
                    <input type="hidden" name="verification_score" id="modalVerificationScore" value="0">
                    <input type="hidden" name="verification_quality" id="modalVerificationQuality" value="">
                    <input type="hidden" name="verification_method" id="modalVerificationMethod" value="">
                    <input type="hidden" name="device_info" id="modalDeviceInfo" value="">
                    <input type="hidden" name="selected_tests" id="selectedTestsInput" value="">
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Consultation & Tests
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Lab Test Results Modal -->
<div class="modal fade" id="testResultsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-flask"></i> Test Results
               </h4>
           </div>
           <form id="testResultsForm">
               <div class="modal-body">
                   <div class="alert alert-info">
                       <strong>Patient:</strong> <span id="resultPatientName"></span><br>
                       <strong>Test:</strong> <span id="resultTestName"></span>
                   </div>
                   
                   <div class="form-group">
                       <label>Test Result <span class="text-danger">*</span></label>
                       <textarea name="test_result" id="testResult" class="form-control" rows="4" placeholder="Enter test results..." required></textarea>
                   </div>
                   
                   <div class="row">
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Result Status</label>
                               <select name="result_status" id="resultStatus" class="form-control">
                                   <option value="normal">Normal</option>
                                   <option value="abnormal">Abnormal</option>
                                   <option value="critical">Critical</option>
                                   <option value="pending">Pending</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Reference Range</label>
                               <input type="text" name="reference_range" id="referenceRange" class="form-control" placeholder="Normal range...">
                           </div>
                       </div>
                   </div>
                   
                   <div class="form-group">
                       <label>Lab Notes</label>
                       <textarea name="lab_notes" id="labNotes" class="form-control" rows="2" placeholder="Laboratory notes..."></textarea>
                   </div>
                   
                   <input type="hidden" name="test_id" id="resultTestId">
               </div>
               
               <div class="modal-footer">
                   <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                   <button type="submit" class="btn btn-success">
                       <i class="fa fa-save"></i> Save Results
                   </button>
               </div>
           </form>
       </div>
   </div>
</div>

<!-- Lab Report Modal -->
<div class="modal fade" id="labReportModal" tabindex="-1" role="dialog">
   <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
           <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title">
                   <i class="fa fa-bar-chart"></i> Laboratory Report Generator
               </h4>
           </div>
           <div class="modal-body">
               <div class="row">
                   <div class="col-md-6">
                       <div class="form-group">
                           <label>From Date</label>
                           <input type="date" id="labReportDateFrom" class="form-control">
                       </div>
                   </div>
                   <div class="col-md-6">
                       <div class="form-group">
                           <label>To Date</label>
                           <input type="date" id="labReportDateTo" class="form-control">
                       </div>
                   </div>
               </div>
               
               <div class="row">
                   <div class="col-md-6">
                       <div class="form-group">
                           <label>Test Category</label>
                           <select id="reportTestCategory" class="form-control">
                               <option value="">All Categories</option>
                               <option value="1">Hematology</option>
                               <option value="2">Clinical Chemistry</option>
                               <option value="3">Microbiology</option>
                               <option value="4">Immunology</option>
                               <option value="5">Urine Analysis</option>
                               <option value="6">Serology</option>
                           </select>
                       </div>
                   </div>
                   <div class="col-md-6">
                       <div class="form-group">
                           <label>Test Status</label>
                           <select id="reportTestStatus" class="form-control">
                               <option value="">All Statuses</option>
                               <option value="pending">Pending</option>
                               <option value="completed">Completed</option>
                               <option value="abnormal">Abnormal</option>
                               <option value="critical">Critical</option>
                           </select>
                       </div>
                   </div>
               </div>
               
               <div id="labReportResults" style="margin-top: 20px; display: none;">
                   <h5>Report Summary</h5>
                   <div class="well">
                       <div class="row">
                           <div class="col-md-3">
                               <strong>Total Tests:</strong><br>
                               <span id="reportTotalTests" class="text-primary">0</span>
                           </div>
                           <div class="col-md-3">
                               <strong>Completed:</strong><br>
                               <span id="reportCompletedTests" class="text-success">0</span>
                           </div>
                           <div class="col-md-3">
                               <strong>Pending:</strong><br>
                               <span id="reportPendingTests" class="text-warning">0</span>
                           </div>
                           <div class="col-md-3">
                               <strong>Critical:</strong><br>
                               <span id="reportCriticalTests" class="text-danger">0</span>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
           
           <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="button" id="generateLabReport" class="btn btn-info">
                   <i class="fa fa-search"></i> Generate Report
               </button>
               <button type="button" id="exportLabReportPDF" class="btn btn-success" style="display: none;">
                   <i class="fa fa-file-pdf-o"></i> Export PDF
               </button>
               <button type="button" id="exportLabReportExcel" class="btn btn-warning" style="display: none;">
                   <i class="fa fa-file-excel-o"></i> Export Excel
               </button>
           </div>
       </div>
   </div>
</div>

<!-- Add Patient Modal -->
<div class="modal fade" id="addPatientModal" tabindex="-1" role="dialog">
   <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
           <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title">
                   <i class="fa fa-plus"></i> Add New Patient
               </h4>
           </div>
           <form id="addPatientForm">
               <div class="modal-body">
                   <div class="row">
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Name <span class="text-danger">*</span></label>
                               <input type="text" class="form-control" name="patientName" required>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Age <span class="text-danger">*</span></label>
                               <input type="number" class="form-control" name="patientAge" required>
                           </div>
                       </div>
                   </div>
                   <div class="row">
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Gender <span class="text-danger">*</span></label>
                               <select class="form-control" name="patientGender" required>
                                   <option value="">Select Gender</option>
                                   <option value="Male">Male</option>
                                   <option value="Female">Female</option>
                                   <option value="Other">Other</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Phone <span class="text-danger">*</span></label>
                               <input type="text" class="form-control" name="patientPhone" required>
                           </div>
                       </div>
                   </div>
               </div>
               <div class="modal-footer">
                   <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                   <button type="submit" class="btn btn-primary">
                       <i class="fa fa-save"></i> Save Patient
                   </button>
               </div>
           </form>
       </div>
   </div>
</div>

<script type="text/javascript">
'use strict';

$(document).ready(function() {
   console.log('🔬 Enhanced Consultation System with SecuGen WebAPI & Lab Tests Integration Starting...');
   
   // =============================================
   // GLOBAL CONFIGURATION
   // =============================================
   
   window.secugenConfig = {
       baseUrl: 'https://localhost:8443',
       httpUrl: 'http://localhost:8443',
       endpoints: {
           capture: '/SGIFPCapture',
           matchScore: '/SGIMatchScore', 
           getInfo: '/SGIFPGetInfo',
           getVersion: '/SGIFPGetVersion'
       },
       serviceActive: false,
       quality: 50,
       timeout: 20000,
       lastError: null
   };

   window.consultationState = {
       verificationPassed: false,
       selectedPatientId: null,
       storedTemplate: null,
       liveTemplate: null,
       lastVerificationResult: null,
       verificationHistory: [],
       currentMatchScore: 0,
       verificationQuality: 'Unknown',
       selectedDiagnosis: null,
       
       // NEW: Lab tests state
       labTests: {
           available: {},
           selected: [],
           categories: {},
           estimatedCost: 0
       }
   };

   // =============================================
   // UTILITY FUNCTIONS
   // =============================================
   
   function showMessage(message, type = 'info', duration = 5000) {
       const alertClass = type === 'success' ? 'alert-success' : 
                         type === 'warning' ? 'alert-warning' : 
                         type === 'error' ? 'alert-danger' : 'alert-info';
       
       const html = `
           <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
               <button type="button" class="close" data-dismiss="alert">&times;</button>
               <strong>${type.toUpperCase()}:</strong> ${message}
           </div>
       `;
       
       $('body').append(html);
       
       setTimeout(() => {
           $('.alert').fadeOut(() => $('.alert').remove());
       }, duration);
   }
   
   window.showMessage = showMessage;

   // =============================================
   // NEW: LAB TESTS LOADING FUNCTIONS
   // =============================================
   
   function loadLabTestsData() {
       console.log('Loading lab tests data...');
       
       // Load test categories and their tests
       $.ajax({
           url: '<?php echo base_url("admin/consultation/getLabTestsForConsultation"); ?>',
           type: 'GET',
           dataType: 'json',
           success: function(response) {
               console.log('Lab tests response:', response);
               
               if (response && response.status === 'success') {
                   window.consultationState.labTests.available = response.tests_by_category || {};
                   window.consultationState.labTests.categories = response.categories || {};
                   
                   populateTestCategories();
                   showMessage(`Loaded ${Object.keys(response.tests_by_category || {}).length} test categories`, 'success');
               } else {
                   handleLabTestsLoadError('Invalid response from server');
               }
           },
           error: function(xhr, status, error) {
               console.error('Error loading lab tests:', error);
               handleLabTestsLoadError(`Error loading lab tests: ${error}`);
           }
       });
   }

   function populateTestCategories() {
       const categories = {
           1: { id: 'hematology', name: 'Hematology', container: '#hematologyTestsList' },
           2: { id: 'chemistry', name: 'Clinical Chemistry', container: '#chemistryTestsList' },
           3: { id: 'microbiology', name: 'Microbiology', container: '#microbiologyTestsList' },
           6: { id: 'serology', name: 'Serology', container: '#serologyTestsList' },
           'other': { id: 'other', name: 'Other Tests', container: '#otherTestsList' }
       };
       
       Object.keys(categories).forEach(categoryId => {
           const category = categories[categoryId];
           const tests = window.consultationState.labTests.available[categoryId] || [];
           const container = $(category.container);
           
           if (tests.length > 0) {
               populateTestCheckboxes(container, tests, categoryId);
           } else {
               container.html(`
                   <div class="col-md-12 text-center text-muted">
                       <i class="fa fa-info-circle"></i> No ${category.name.toLowerCase()} tests available
                   </div>
               `);
           }
       });
   }

   function populateTestCheckboxes(container, tests, categoryId) {
       container.empty();
       
       tests.forEach(test => {
           const costDisplay = test.cost > 0 ? `(Ksh.${parseFloat(test.cost).toFixed(2)})` : '';
           const checkboxHtml = `
               <div class="col-md-6 col-sm-12">
                   <div class="checkbox test-checkbox" style="margin: 5px 0; padding: 8px; border: 1px solid #e3e3e3; border-radius: 4px;">
                       <label style="font-weight: normal; width: 100%; cursor: pointer;">
                           <input type="checkbox" 
                                  value="${test.id}" 
                                  data-test-name="${test.test_name}"
                                  data-short-name="${test.short_name || ''}"
                                  data-cost="${test.cost || 0}"
                                  data-category="${categoryId}"
                                  data-sample-type="${test.sample_type || ''}"
                                  data-method="${test.method || ''}"
                                  class="lab-test-checkbox">
                           <strong>${test.test_name}</strong>
                           ${test.short_name ? `<small class="text-muted">(${test.short_name})</small>` : ''}
                           <br>
                           <small class="text-info">
                               ${test.sample_type ? `Sample: ${test.sample_type}` : ''}
                               ${test.method ? ` | Method: ${test.method}` : ''}
                               ${costDisplay ? ` | ${costDisplay}` : ''}
                           </small>
                       </label>
                   </div>
               </div>
           `;
           container.append(checkboxHtml);
       });
   }

   function handleLabTestsLoadError(errorMsg) {
       const containers = ['#hematologyTestsList', '#chemistryTestsList', '#microbiologyTestsList', '#serologyTestsList', '#otherTestsList'];
       
       containers.forEach(container => {
           $(container).html(`
               <div class="col-md-12 text-center text-danger">
                   <i class="fa fa-exclamation-triangle"></i> ${errorMsg}
               </div>
           `);
       });
       
       showMessage(errorMsg, 'error');
   }

   function updateSelectedTestsSummary() {
       const selectedTests = $('.lab-test-checkbox:checked');
       const selectedCount = selectedTests.length;
       let totalCost = 0;
       let testsList = [];
       
       selectedTests.each(function() {
           const $this = $(this);
           const cost = parseFloat($this.data('cost')) || 0;
           totalCost += cost;
           testsList.push($this.data('test-name'));
       });
       
       $('#selectedTestsCount').text(selectedCount);
       $('#estimatedTestsCost').text(totalCost.toFixed(2));
       
       if (selectedCount > 0) {
           $('#selectedTestsList').html(testsList.map(test => `<span class="label label-info" style="margin: 2px;">${test}</span>`).join(' '));
       } else {
           $('#selectedTestsList').html('<em class="text-muted">No tests selected</em>');
       }
       
       // Update global state
       window.consultationState.labTests.selected = [];
       selectedTests.each(function() {
           const $this = $(this);
           window.consultationState.labTests.selected.push({
               id: $this.val(),
               test_name: $this.data('test-name'),
               short_name: $this.data('short-name'),
               cost: $this.data('cost'),
               category: $this.data('category'),
               sample_type: $this.data('sample-type'),
               method: $this.data('method')
           });
       });
       
       window.consultationState.labTests.estimatedCost = totalCost;
       
       // Update hidden input for form submission
       $('#selectedTestsInput').val(JSON.stringify(window.consultationState.labTests.selected));
   }

   // =============================================
   // LAB DASHBOARD FUNCTIONS
   // =============================================
   
   function loadLabDashboard() {
       console.log('Loading lab dashboard...');
       
       $.ajax({
           url: '<?php echo base_url("admin/consultation/getLabSummary"); ?>',
           type: 'GET',
           dataType: 'json',
           success: function(response) {
               if (response && response.status === 'success') {
                   updateLabCards(response.summary);
                   updateLabCharts(response.charts);
                   loadLabTestsTable();
               } else {
                   showMessage('Failed to load lab dashboard', 'error');
               }
           },
           error: function(xhr, status, error) {
               console.error('Error loading lab dashboard:', error);
               showMessage(`Error loading lab data: ${error}`, 'error');
           }
       });
   }

   function updateLabCards(summary) {
       $('#total_tests').text(summary.total_tests || 0);
       $('#pending_tests').text(summary.pending_tests || 0);
       $('#completed_tests').text(summary.completed_tests || 0);
       $('#critical_results').text(summary.critical_results || 0);
   }

   function updateLabCharts(chartData) {
       // Initialize Chart.js charts if available
       if (typeof Chart !== 'undefined') {
           // Test Distribution Chart
           const testsCtx = document.getElementById('testsChart').getContext('2d');
           new Chart(testsCtx, {
               type: 'bar',
               data: {
                   labels: chartData.category_labels || [],
                   datasets: [{
                       label: 'Tests',
                       data: chartData.category_data || [],
                       backgroundColor: ['#3c8dbc', '#00a65a', '#f39c12', '#dd4b39', '#605ca8'],
                       borderWidth: 1
                   }]
               },
               options: {
                   responsive: true,
                   maintainAspectRatio: false
               }
           });

           // Test Status Chart
           const statusCtx = document.getElementById('testStatusChart').getContext('2d');
           new Chart(statusCtx, {
               type: 'doughnut',
               data: {
                   labels: ['Pending', 'Completed', 'Critical'],
                   datasets: [{
                       data: chartData.status_data || [0, 0, 0],
                       backgroundColor: ['#f0ad4e', '#5cb85c', '#d9534f']
                   }]
               },
               options: {
                   responsive: true,
                   maintainAspectRatio: false
               }
           });
       }
   }

   function loadLabTestsTable() {
       $.ajax({
           url: '<?php echo base_url("admin/consultation/getRecentLabTests"); ?>',
           type: 'GET',
           dataType: 'json',
           success: function(response) {
               if (response && response.status === 'success') {
                   populateLabTestsTable(response.tests);
               }
           },
           error: function(xhr, status, error) {
               console.error('Error loading lab tests table:', error);
           }
       });
   }

   function populateLabTestsTable(tests) {
       const tbody = $('#labTestsTable tbody');
       tbody.empty();
       
       if (tests && tests.length > 0) {
           tests.forEach(function(test) {
               const statusClass = test.result_status === 'completed' ? 'success' : 
                                 test.result_status === 'critical' ? 'danger' :
                                 test.result_status === 'abnormal' ? 'warning' : 'info';
               
               const row = `
                   <tr>
                       <td>${test.test_date || test.created_at}</td>
                       <td>${test.patient_name}</td>
                       <td>${test.test_name}</td>
                       <td>${test.category_name || 'N/A'}</td>
                       <td><span class="label label-${statusClass}">${test.result_status || 'pending'}</span></td>
                       <td>${test.test_result ? test.test_result.substring(0, 50) + '...' : 'Pending'}</td>
                       <td>
                           <button class="btn btn-xs btn-info" onclick="viewTestDetails(${test.id})">
                               <i class="fa fa-eye"></i>
                           </button>
                           ${test.result_status !== 'completed' ? 
                               `<button class="btn btn-xs btn-success" onclick="enterTestResults(${test.id})">
                                   <i class="fa fa-edit"></i>
                               </button>` : ''
                           }
                           <button class="btn btn-xs btn-primary" onclick="printTestReport(${test.id})">
                               <i class="fa fa-print"></i>
                           </button>
                       </td>
                   </tr>
               `;
               tbody.append(row);
           });
       } else {
           tbody.append('<tr><td colspan="7" class="text-center">No lab tests found</td></tr>');
       }
   }

   // =============================================
   // SECUGEN SERVICE INITIALIZATION
   // =============================================
   
   function initializeSecuGenService() {
       $("#secugen_service_status").html(`
           <div class="alert alert-info">
               <i class="fa fa-info-circle"></i> <strong>SecuGen WebAPI Ready</strong><br>
               <small>Use SGIFPCapture to scan fingerprint, then SGIMatchScore to verify</small>
           </div>
       `);
       
       $('#manualVerifyBtn').prop('disabled', false);
       $('#verifyIdentity').prop('disabled', true);
       
       setTimeout(() => {
           $.ajax({
               url: 'https://localhost:8443/SGIFPGetInfo',
               type: 'GET',
               timeout: 3000,
               success: function(data) {
                   $("#secugen_service_status").html(`
                       <div class="alert alert-success">
                           <i class="fa fa-check-circle"></i> <strong>SecuGen WebAPI Connected</strong><br>
                           <small>Service active at https://localhost:8443</small>
                       </div>
                   `);
               },
               error: function() {
                   $("#secugen_service_status").html(`
                       <div class="alert alert-warning">
                           <i class="fa fa-exclamation-triangle"></i> <strong>SecuGen Service Check</strong><br>
                           <small>Service not detected. Buttons will attempt direct connection.</small><br>
                           <small><a href="https://localhost:8443/SGIFPGetInfo" target="_blank">Click to accept SSL certificate</a></small>
                       </div>
                   `);
               }
           });
       }, 1000);
   }

   // =============================================
   // PATIENT MANAGEMENT FUNCTIONS
   // =============================================
   
function loadPatients() {
    console.log('Loading patients for consultation...');
    
    $('#consultation_patient_search').html('<option value="">Loading patients...</option>');
    
    $.ajax({
        url: '<?php echo base_url("admin/consultation/getAllPatients"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log('Patients response:', response);
            
            let patients = [];
            if (response && response.patients && Array.isArray(response.patients)) {
                patients = response.patients;
            } else if (response && Array.isArray(response)) {
                patients = response;
            } else if (response && response.count !== undefined) {
                patients = response.patients || [];
            } else {
                console.error('Unexpected response format:', response);
                $('#consultation_patient_search').html('<option value="">Error: Invalid response format</option>');
                showMessage('Invalid response format from server', 'error');
                return;
            }
            
            if (patients.length > 0) {
                const select = $('#consultation_patient_search');
                select.empty();
                select.append(`<option value="">Select Patient (${patients.length} total)</option>`);
                
                $.each(patients, function(index, patient) {
                    let text = `${patient.patient_name} (${patient.id})`;
                    if (patient.mobileno) {
                        text += ` - ${patient.mobileno}`;
                    }
                    if (patient.has_fingerprint) {
                        text += ' 🔐';
                    }
                    select.append(`<option value="${patient.id}">${text}</option>`);
                });
                
                console.log(`Successfully loaded ${patients.length} patients`);
                showMessage(`Loaded ${patients.length} patients`, 'success');
                
                if (typeof $.fn.select2 !== 'undefined') {
                    select.select2({
                        placeholder: 'Search patients...',
                        allowClear: true,
                        width: '100%'
                    });
                }
            } else {
                $('#consultation_patient_search').html('<option value="">No patients found</option>');
                showMessage('No patients found in database', 'warning');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading patients:', error);
            console.error('XHR Status:', xhr.status);
            console.error('Response Text:', xhr.responseText);
            
            $('#consultation_patient_search').html('<option value="">Error loading patients</option>');
            
            let errorMessage = `Error loading patients: ${error}`;
            if (xhr.status === 404) {
                errorMessage = 'Patient loading endpoint not found (404)';
            } else if (xhr.status === 500) {
                errorMessage = 'Server error loading patients (500)';
            } else if (xhr.status === 0) {
                errorMessage = 'Network error - check connection';
            }
            
            showMessage(errorMessage, 'error');
        }
    });
}

   function loadPatientDetails(patientId) {
       window.consultationState.selectedPatientId = patientId;
       $('#selectedPatientId').val(patientId);
       $('#patientDetailsSection').show();
       resetVerificationState();
       
       $.ajax({
           url: '<?php echo base_url("admin/consultation/getPatientDetails"); ?>',
           type: 'POST',
           data: { id: patientId },
           dataType: 'json',
           success: function(response) {
               console.log('Patient details response:', response);
               
               if (response && response.patient_name) {
                   populatePatientDetails(response);
                   loadStoredFingerprint(response);
                   loadPatientConsultations(patientId);
               } else {
                   console.error('Invalid patient details response:', response);
                   showMessage('Failed to load patient details', 'error');
               }
           },
           error: function(xhr, status, error) {
               console.error('Error loading patient details:', error);
               showMessage(`Error loading patient details: ${error}`, 'error');
           }
       });
   }

   function populatePatientDetails(patient) {
       $('#patientName').text(patient.patient_name || 'N/A');
       $('#patientAge').text((patient.age || 'N/A') + ' years');
       $('#patientGender').text(patient.gender || 'N/A');
       $('#patientPhone').text(patient.mobileno || 'N/A');
       $('#patientBloodGroup').text(patient.blood_group_name || 'N/A');
       $('#patientAllergies').text(patient.known_allergies || 'None');
       
       if (patient.image) {
           $('#patientPhoto').attr('src', '<?php echo base_url(); ?>' + patient.image);
       }
   }

   function loadStoredFingerprint(patient) {
       if (patient.fingerprint_status && patient.fingerprint_status.enrolled) {
           $.ajax({
               url: '<?php echo base_url("admin/consultation/getStoredFingerprintTemplate"); ?>',
               type: 'POST',
               data: { patient_id: patient.id },
               dataType: 'json',
               success: function(response) {
                   if (response.status === 'success') {
                       window.consultationState.storedTemplate = response.fingerprint_template;
                       $('#patientStoredTemplate').val(response.fingerprint_template);
                       
                       if (response.fingerprint_image) {
                           $('#storedFingerprintImage').attr('src', 'data:image/bmp;base64,' + response.fingerprint_image);
                       }
                       
                       $('#storedTemplateDetails').text(`Template loaded (${response.template_size} chars)`);
                       
                       $("#fingerprintStatus").html(`
                           <div class="alert alert-info">
                               <i class="fa fa-fingerprint"></i> <strong>Biometric template on file</strong><br>
                               <small>Use SGIFPCapture to scan fingerprint, then SGIMatchScore to verify</small>
                           </div>
                       `);
                   } else {
                       handleNoStoredFingerprint();
                   }
               },
               error: function() {
                   handleNoStoredFingerprint();
               }
           });
       } else {
           handleNoStoredFingerprint();
       }
   }

   function handleNoStoredFingerprint() {
       $("#fingerprintStatus").html(`
           <div class="alert alert-warning">
               <i class="fa fa-exclamation-triangle"></i> <strong>No biometric template on file</strong><br>
               <small>Admin verification only - fingerprint enrollment required for biometric verification</small>
           </div>
       `);
       
       $('#storedTemplateDetails').text('No template');
       window.consultationState.storedTemplate = null;
       
       $('#skipVerificationBtn').prop('disabled', false);
       $('#manualVerifyBtn').prop('disabled', false);
       $('#verifyIdentity').prop('disabled', true);
   }

   function loadPatientConsultations(patientId) {
       $.ajax({
           url: '<?php echo base_url("admin/consultation/getPatientConsultations"); ?>',
           type: 'POST',
           data: { patient_id: patientId },
           dataType: 'json',
           success: function(response) {
               if (response.status === 'success' && response.consultations.length > 0) {
                   let html = '';
                   response.consultations.forEach(function(consultation) {
                       const testsInfo = consultation.tests_count > 0 ? 
                           `<br><small class="text-info">Tests: ${consultation.tests_count} ordered</small>` : '';
                           
                       html += `
                           <div style="border-left: 3px solid #007bff; padding: 8px; margin-bottom: 8px; background-color: #f8f9fa; border-radius: 3px;">
                               <strong>${consultation.consultation_date}</strong><br>
                               <small>Dr. ${consultation.doctor_name}</small><br>
                               <span class="text-muted">${consultation.symptoms.substring(0, 50)}${consultation.symptoms.length > 50 ? '...' : ''}</span>
                               ${testsInfo}
                           </div>
                       `;
                   });
                   $('#recentConsultations').html(html);
               } else {
                   $('#recentConsultations').html('<p class="text-muted">No previous consultations found</p>');
               }
           },
           error: function() {
               $('#recentConsultations').html('<p class="text-danger">Error loading consultation history</p>');
           }
       });
   }

   function resetVerificationState() {
       window.consultationState.verificationPassed = false;
       window.consultationState.storedTemplate = null;
       window.consultationState.liveTemplate = null;
       window.consultationState.currentMatchScore = 0;
       window.consultationState.verificationQuality = 'Unknown';
       
       $('#verificationPassed').val('0');
       $('#verificationStatus').html('');
       
       $("#fingerprintStatus").html(`
           <div class="alert alert-info">
               <i class="fa fa-info-circle"></i> Ready for SecuGen biometric verification
           </div>
       `);
       
       $('#storedFingerprintImage, #liveFingerprintImage').attr('src', './Images/PlaceFinger.bmp');
       $('#storedTemplateDetails, #liveTemplateDetails').text('');
       $('#startConsultationBtn').prop('disabled', true);
       $('#patientStoredTemplate, #liveScannedTemplate').val('');
       
       window.consultationState.verificationHistory = [];
       updateVerificationHistoryDisplay();
   }

   // =============================================
   // SECUGEN FINGERPRINT OPERATIONS
   // =============================================
   
   function performManualVerification() {
       const captureUrl = 'https://localhost:8443/SGIFPCapture';
       
       $('#fingerprintStatus').html(`
           <div class="alert alert-info">
               <i class="fa fa-spinner fa-spin"></i> <strong>Manual capture - place finger on scanner...</strong><br>
               <small>Using XMLHttpRequest for compatibility</small>
           </div>
       `);
       
       $('#manualVerifyBtn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Scanning...');
       
       const xhr = new XMLHttpRequest();
       xhr.open('POST', captureUrl, true);
       xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
       xhr.timeout = 20000;
       
       xhr.onreadystatechange = function() {
           if (xhr.readyState === 4) {
               $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Print Capture');
               
               if (xhr.status === 200) {
                   try {
                       const result = JSON.parse(xhr.responseText);
                       
                       if (result.ErrorCode === 0 && result.TemplateBase64) {
                           window.consultationState.liveTemplate = result.TemplateBase64;
                           $('#liveScannedTemplate').val(result.TemplateBase64);
                           
                           if (result.BMPBase64) {
                               $('#liveFingerprintImage').attr('src', 'data:image/bmp;base64,' + result.BMPBase64);
                               $('#liveTemplateDetails').text('Manual capture');
                           }
                           
                           $("#fingerprintStatus").html(`
                               <div class="alert alert-success">
                                   <i class="fa fa-check-circle"></i> <strong>Manual capture successful!</strong><br>
                                   <small>Ready for comparison</small>
                               </div>
                           `);
                           
                           if (window.consultationState.storedTemplate) {
                               $('#verifyIdentity').prop('disabled', false);
                               showMessage('Manual capture successful. Click Verify Print to compare.', 'success');
                           }
                           
                       } else {
                           handleCaptureError(result.ErrorDescription || 'Manual capture failed');
                       }
                   } catch (e) {
                       handleCaptureError('Invalid response during manual capture: ' + e.message);
                   }
               } else {
                   handleCaptureError(`Manual capture HTTP error: ${xhr.status}`);
               }
           }
       };
       
       xhr.onerror = function() {
           $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Print Capture');
           handleCaptureError('Network error during manual capture');
       };
       
       xhr.ontimeout = function() {
           $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Print Capture');
           handleCaptureError('Timeout during manual capture');
       };
       
       const postData = 'Quality=50&Timeout=20000&WSQCompression=2.25';
       xhr.send(postData);
   }

   function performBiometricVerification() {
       if (!window.consultationState.storedTemplate || !window.consultationState.liveTemplate) {
           showMessage('Both stored and captured templates required for comparison', 'error');
           return;
       }
       
       const matchUrl = 'https://localhost:8443/SGIMatchScore';
       
       $("#fingerprintStatus").html(`
           <div class="alert alert-info">
               <i class="fa fa-spinner fa-spin"></i> <strong>Comparing fingerprints...</strong><br>
               <small>SGIMatchScore in progress</small>
           </div>
       `);
       
       $("#verifyIdentity").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Matching...');
       
       $.ajax({
           url: matchUrl,
           type: 'POST',
           data: {
               Template1: window.consultationState.storedTemplate,
               Template2: window.consultationState.liveTemplate,
               TemplateFormat: 'ISO'
           },
           timeout: 15000,
           success: function(response) {
               $("#verifyIdentity").prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
               
               try {
                   const result = typeof response === 'string' ? JSON.parse(response) : response;
                   handleMatchingResponse(result);
               } catch (e) {
                   handleMatchingError('Invalid response from SGIMatchScore: ' + e.message);
               }
           },
           error: function(xhr, status, error) {
               $("#verifyIdentity").prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
               handleMatchingError(`SGIMatchScore failed: ${error}`);
           }
       });
   }

   function handleMatchingResponse(result) {
       if (result.ErrorCode === 0) {
           const matchScore = parseInt(result.MatchingScore || 0);
           const threshold = 60;
           const isMatch = matchScore >= threshold;
           
           window.consultationState.currentMatchScore = matchScore;
           
           let quality, qualityClass;
           if (matchScore >= 100) {
               quality = 'Excellent';
               qualityClass = 'label-success';
           } else if (matchScore >= 80) {
               quality = 'Very Good';
               qualityClass = 'label-success';
           } else if (matchScore >= threshold) {
               quality = 'Good';
               qualityClass = 'label-info';
           } else {
               quality = 'Poor';
               qualityClass = 'label-danger';
           }
           
           window.consultationState.verificationQuality = quality;
           
           if (isMatch) {
               window.consultationState.verificationPassed = true;
               $('#verificationPassed').val('1');
               
               $("#fingerprintStatus").html(`
                  <div class="alert alert-success">
                      <i class="fa fa-check-circle"></i> <strong>Identity Verified Successfully!</strong><br>
                      <small>Match Score: <strong>${matchScore}/199</strong> | Quality: <span class="label ${qualityClass}">${quality}</span></small><br>
                      <small class="text-success">Patient identity confirmed</small>
                  </div>
              `);
              
              $('#verificationStatus').html('<span class="label label-success"><i class="fa fa-shield"></i> Verified</span>');
              $('#startConsultationBtn').prop('disabled', false);
              
              addToVerificationHistory('Success', matchScore, quality);
              showMessage(`Identity verified! Match score: ${matchScore}/199 (${quality})`, 'success');
              
          } else {
              window.consultationState.verificationPassed = false;
              
              $("#fingerprintStatus").html(`
                  <div class="alert alert-danger">
                      <i class="fa fa-times-circle"></i> <strong>Verification Failed!</strong><br>
                      <small>Match Score: <strong>${matchScore}/199</strong> (Required: ${threshold}+)</small><br>
                      <small>Quality: <span class="label ${qualityClass}">${quality}</span></small>
                  </div>
              `);
              
              $('#verificationStatus').html('<span class="label label-danger"><i class="fa fa-times"></i> Failed</span>');
              
              addToVerificationHistory('Failed', matchScore, quality);
              showMessage(`Verification failed. Score ${matchScore}/199 below threshold.`, 'error');
          }
          
      } else {
          const errorDescription = result.ErrorDescription || `Error code: ${result.ErrorCode}`;
          handleMatchingError(`SGIMatchScore Error ${result.ErrorCode}: ${errorDescription}`);
      }
  }

  function handleMatchingError(errorMsg) {
      $("#fingerprintStatus").html(`
          <div class="alert alert-danger">
              <i class="fa fa-exclamation-triangle"></i> <strong>Matching Error:</strong><br>
              <small>${errorMsg}</small>
          </div>
      `);
      
      showMessage(errorMsg, 'error');
  }

  function handleCaptureError(errorMsg) {
      $("#fingerprintStatus").html(`
          <div class="alert alert-danger">
              <i class="fa fa-exclamation-triangle"></i> <strong>Capture Failed:</strong><br>
              <small>${errorMsg}</small>
          </div>
      `);
      
      showMessage(errorMsg, 'error');
  }

  // =============================================
  // VERIFICATION HISTORY
  // =============================================
  
  function addToVerificationHistory(result, score, quality) {
      const timestamp = new Date().toLocaleTimeString();
      const patientName = $('#patientName').text() || 'Unknown';
      
      const historyItem = {
          timestamp: timestamp,
          patient: patientName,
          result: result,
          score: score,
          quality: quality,
          method: 'SecuGen SGIMatchScore'
      };
      
      window.consultationState.verificationHistory.unshift(historyItem);
      
      if (window.consultationState.verificationHistory.length > 10) {
          window.consultationState.verificationHistory.pop();
      }
      
      updateVerificationHistoryDisplay();
  }

  function updateVerificationHistoryDisplay() {
      let html = '';
      
      if (window.consultationState.verificationHistory.length === 0) {
          html = '<p class="text-muted">No verification attempts yet</p>';
      } else {
          window.consultationState.verificationHistory.forEach(item => {
              const resultClass = item.result === 'Success' ? 'text-success' : 'text-danger';
              const resultIcon = item.result === 'Success' ? 'fa-check' : 'fa-times';
              
              html += `
                  <div style="border-left: 3px solid ${item.result === 'Success' ? '#5cb85c' : '#d9534f'}; padding: 8px; margin-bottom: 8px; background-color: #f9f9f9; border-radius: 3px;">
                      <div class="${resultClass}">
                          <i class="fa ${resultIcon}"></i> <strong>${item.result}</strong> - ${item.timestamp}
                      </div>
                      <small>Score: ${item.score}/199 | Quality: ${item.quality}</small><br>
                      <small class="text-muted">${item.method}</small>
                  </div>
              `;
          });
      }
      
      $('#verificationHistory').html(html);
  }

  // =============================================
  // CONSULTATION MANAGEMENT WITH LAB TESTS
  // =============================================

  function startConsultation() {
      const patientId = $('#selectedPatientId').val();
      if (!patientId) {
          showMessage('Please select a patient first', 'warning');
          return;
      }
      
      if (!window.consultationState.verificationPassed) {
          showMessage('Patient identity verification required before consultation', 'warning');
          return;
      }
      
      // Populate modal fields
      $('#modalPatientIdHidden').val(patientId);
      $('#modalPatientId').text(patientId);
      $('#modalPatientName').text($('#patientName').text());
      $('#consultationDate').val(new Date().toISOString().split('T')[0]);
      $('#modalVerificationStatus').val('1');
      
      // Clear selected tests
      $('.lab-test-checkbox').prop('checked', false);
      updateSelectedTestsSummary();
      
      const verificationBadge = window.consultationState.verificationPassed ? 
          '<span class="label label-success"><i class="fa fa-shield"></i> Biometric Verified</span>' : 
          '<span class="label label-warning"><i class="fa fa-exclamation-triangle"></i> Unverified</span>';
      
      $('#modalVerificationBadge').html(verificationBadge);
      
      if (window.consultationState.verificationPassed) {
          $('#modalVerificationDetails').html(`
              <small>SecuGen Score: ${window.consultationState.currentMatchScore}/199</small><br>
              <small>Quality: ${window.consultationState.verificationQuality}</small>
          `);
      }
      
      // Load lab tests data and ICD diagnoses when modal opens
      loadLabTestsData();
      loadIcdDiagnoses();
      
      $('#consultationModal').modal('show');
  }

  function saveConsultation() {
      const submitBtn = $('#consultationForm').find('button[type="submit"]');
      submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
      
      // Validate required fields
      const requiredFields = {
          patient_id: $('#modalPatientIdHidden').val(),
          symptoms: $('#consultationSymptoms').val(),
          doctor: $('#consultationDoctor').val(),
          consultation_date: $('#consultationDate').val()
      };
      
      const missingFields = [];
      for (const [field, value] of Object.entries(requiredFields)) {
          if (!value || value.trim() === '') {
              missingFields.push(field);
          }
      }
      
      if (missingFields.length > 0) {
          showMessage(`Missing required fields: ${missingFields.join(', ')}`, 'error');
          submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation & Tests');
          return;
      }
      
      // Prepare form data with diagnosis and lab tests information
      let formData = $('#consultationForm').serialize();
      
      // Add diagnosis information based on selection type
      if (window.consultationState.selectedDiagnosis) {
          formData += `&diagnosis_code=${window.consultationState.selectedDiagnosis.code}`;
          formData += `&diagnosis_title=${encodeURIComponent(window.consultationState.selectedDiagnosis.title)}`;
          formData += `&diagnosis_type=icd10`;
      } else if ($('#consultationDiagnosisCustom').val().trim()) {
          formData += `&diagnosis_custom=${encodeURIComponent($('#consultationDiagnosisCustom').val())}`;
          formData += `&diagnosis_type=custom`;
      }
      
      // Add lab tests data
      const selectedTests = window.consultationState.labTests.selected;
      if (selectedTests.length > 0) {
          formData += `&selected_tests=${encodeURIComponent(JSON.stringify(selectedTests))}`;
          formData += `&total_tests=${selectedTests.length}`;
          formData += `&estimated_tests_cost=${window.consultationState.labTests.estimatedCost}`;
      }
      
      $.ajax({
          url: '<?php echo base_url("admin/consultation/saveWithLabTests"); ?>',
          type: 'POST',
          data: formData,
          dataType: 'json',
          success: function(response) {
              if (response.status === 'success') {
                  showMessage(response.message, 'success');
                  $('#consultationModal').modal('hide');
                  
                  const patientId = $('#selectedPatientId').val();
                  if (patientId) {
                      loadPatientConsultations(patientId);
                  }
                  
                  // Refresh lab dashboard
                  loadLabDashboard();
                  loadConsultationsList();
                  
                  resetConsultationForm();
              } else {
                  showMessage(response.message || 'Failed to save consultation', 'error');
              }
          },
          error: function(xhr, status, error) {
              console.error('Save consultation error:', xhr.responseText);
              showMessage(`Error saving consultation: ${error}`, 'error');
          },
          complete: function() {
              submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation & Tests');
          }
      });
  }

  function resetConsultationForm() {
      $('#consultationForm')[0].reset();
      $('#selectedDiagnosisInfo').hide();
      $('#customDiagnosisGroup').hide();
      $('#consultationDiagnosis').val('').trigger('change');
      window.consultationState.selectedDiagnosis = null;
      
      // Reset lab tests selection
      $('.lab-test-checkbox').prop('checked', false);
      updateSelectedTestsSummary();
      window.consultationState.labTests.selected = [];
      window.consultationState.labTests.estimatedCost = 0;
  }

  function loadConsultationsList() {
      $.ajax({
          url: '<?php echo base_url("admin/consultation/getConsultationsWithLabTests"); ?>',
          type: 'GET',
          dataType: 'json',
          success: function(response) {
              if (response && response.status === 'success') {
                  populateConsultationsTable(response.consultations);
              }
          },
          error: function(xhr, status, error) {
              console.error('Error loading consultations:', error);
          }
      });
  }

  function populateConsultationsTable(consultations) {
      const tbody = $('#consultationListTable tbody');
      tbody.empty();
      
      if (consultations && consultations.length > 0) {
          consultations.forEach(function(consultation) {
              const verificationBadge = consultation.verification_status === 'verified' ? 
                  '<span class="label label-success">Verified</span>' : 
                  '<span class="label label-warning">Unverified</span>';
              
              const testsInfo = consultation.tests_count > 0 ? 
                  `${consultation.tests_count} test(s) ordered` : 'No tests';
              
              const row = `
                  <tr>
                      <td>${consultation.id}</td>
                      <td>${consultation.consultation_date}</td>
                      <td>${consultation.patient_name}</td>
                      <td>Dr. ${consultation.doctor_name}</td>
                      <td>${consultation.symptoms.substring(0, 50)}${consultation.symptoms.length > 50 ? '...' : ''}</td>
                      <td><small class="text-info">${testsInfo}</small></td>
                      <td>${verificationBadge}</td>
                      <td>
                          <button class="btn btn-xs btn-info" onclick="viewConsultation(${consultation.id})">
                              <i class="fa fa-eye"></i>
                          </button>
                          <button class="btn btn-xs btn-warning" onclick="editConsultation(${consultation.id})">
                              <i class="fa fa-edit"></i>
                          </button>
                          ${consultation.tests_count > 0 ? 
                              `<button class="btn btn-xs btn-success" onclick="viewConsultationTests(${consultation.id})">
                                  <i class="fa fa-flask"></i>
                              </button>` : ''
                          }
                      </td>
                  </tr>
              `;
              tbody.append(row);
          });
      } else {
          tbody.append('<tr><td colspan="8" class="text-center">No consultations found</td></tr>');
      }
  }

  // =============================================
  // LAB TEST RESULTS FUNCTIONS
  // =============================================
  
  function enterTestResults(testId) {
      // Load test details for results entry
      $.ajax({
          url: '<?php echo base_url("admin/consultation/getTestDetails"); ?>',
          type: 'POST',
          data: { test_id: testId },
          dataType: 'json',
          success: function(response) {
              if (response && response.status === 'success') {
                  const test = response.test;
                  
                  $('#resultPatientName').text(test.patient_name);
                  $('#resultTestName').text(test.test_name);
                  $('#resultTestId').val(testId);
                  
                  // Pre-fill existing data if available
                  if (test.test_result) {
                      $('#testResult').val(test.test_result);
                  }
                  if (test.result_status) {
                      $('#resultStatus').val(test.result_status);
                  }
                  if (test.reference_range) {
                      $('#referenceRange').val(test.reference_range);
                  }
                  if (test.notes) {
                      $('#labNotes').val(test.notes);
                  }
                  
                  $('#testResultsModal').modal('show');
              } else {
                  showMessage('Failed to load test details', 'error');
              }
          },
          error: function(xhr, status, error) {
              showMessage(`Error loading test: ${error}`, 'error');
          }
      });
  }

  function submitTestResults() {
      const submitBtn = $('#testResultsForm').find('button[type="submit"]');
      submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
      
      $.ajax({
          url: '<?php echo base_url("admin/consultation/saveTestResults"); ?>',
          type: 'POST',
          data: $('#testResultsForm').serialize(),
          dataType: 'json',
          success: function(response) {
              if (response.status === 'success') {
                  showMessage(response.message, 'success');
                  $('#testResultsModal').modal('hide');
                  
                  // Refresh lab data
                  loadLabDashboard();
                  loadLabTestsTable();
                  
                  // Reset form
                  $('#testResultsForm')[0].reset();
              } else {
                  showMessage(response.message || 'Failed to save test results', 'error');
              }
          },
          error: function(xhr, status, error) {
              console.error('Test results saving error:', xhr.responseText);
              showMessage(`Error saving results: ${error}`, 'error');
          },
          complete: function() {
              submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Results');
          }
      });
  }

  // =============================================
  // ICD-10 DIAGNOSIS FUNCTIONS (KEPT FROM ORIGINAL)
  // =============================================
  
  function loadIcdDiagnoses() {
      console.log('Loading ICD-10 diagnoses...');
      
      $('#consultationDiagnosis').html('<option value="">Loading ICD-10 codes...</option>');
      
      $.ajax({
          url: '<?php echo base_url("admin/consultation/getIcdDiagnoses"); ?>',
          type: 'GET',
          dataType: 'json',
          success: function(response) {
              console.log('ICD diagnoses response:', response);
              
              if (response && response.status === 'success' && response.diagnoses) {
                  populateIcdSelect(response.diagnoses);
                  initializeDiagnosisSelect2();
              } else {
                  handleIcdLoadError('Invalid response format from server');
              }
          },
          error: function(xhr, status, error) {
              console.error('Error loading ICD diagnoses:', error);
              handleIcdLoadError(`Error loading ICD codes: ${error}`);
          }
      });
  }

  function populateIcdSelect(diagnoses) {
      const select = $('#consultationDiagnosis');
      select.empty();
      select.append('<option value="">Search and select ICD-10 diagnosis...</option>');
      
      diagnoses.forEach(diagnosis => {
          const optionText = `${diagnosis.code} - ${diagnosis.title}`;
          const option = $(`<option value="${diagnosis.id}" 
              data-code="${diagnosis.code}" 
              data-title="${diagnosis.title}" 
              data-category="${diagnosis.category || ''}" 
              data-subcategory="${diagnosis.subcategory || ''}"
              data-description="${diagnosis.description || ''}">${optionText}</option>`);
          select.append(option);
      });
      
      console.log(`Populated ${diagnoses.length} ICD-10 diagnoses in dropdown`);
      showMessage(`Loaded ${diagnoses.length} ICD-10 diagnoses`, 'success');
  }

  function initializeDiagnosisSelect2() {
      if ($('#consultationDiagnosis').hasClass('select2-hidden-accessible')) {
          $('#consultationDiagnosis').select2('destroy');
      }
      
      $('#consultationDiagnosis').select2({
          placeholder: 'Search ICD-10 codes by code, title, or category...',
          allowClear: true,
          width: '100%',
          dropdownParent: $('#consultationModal'),
          minimumInputLength: 0
      });
      
      console.log('Select2 initialized for diagnosis dropdown');
  }

  function handleIcdLoadError(errorMsg) {
      $('#consultationDiagnosis').html('<option value="">Error loading ICD codes</option>');
      showMessage(errorMsg, 'error');
      
      $('#addCustomDiagnosis').trigger('click');
      showMessage('Using custom diagnosis input as fallback', 'warning');
  }

  function selectDiagnosis(diagnosisId) {
      const selectedOption = $(`#consultationDiagnosis option[value="${diagnosisId}"]`);
      
      if (selectedOption.length) {
          const diagnosisData = {
              id: diagnosisId,
              code: selectedOption.data('code'),
              title: selectedOption.data('title'),
              category: selectedOption.data('category'),
              subcategory: selectedOption.data('subcategory'),
              description: selectedOption.data('description')
          };
          
          window.consultationState.selectedDiagnosis = diagnosisData;
          
          $('#selectedDiagnosisCode').text(diagnosisData.code);
          $('#selectedDiagnosisTitle').text(diagnosisData.title);
          $('#selectedDiagnosisCategory').text(`${diagnosisData.category}${diagnosisData.subcategory ? ' → ' + diagnosisData.subcategory : ''}`);
          $('#selectedDiagnosisInfo').show();
          
          $('#customDiagnosisGroup').hide();
          $('#consultationDiagnosisCustom').val('');
          
          console.log('Selected diagnosis:', diagnosisData);
      }
  }

  function clearDiagnosis() {
      $('#consultationDiagnosis').val('').trigger('change');
      $('#selectedDiagnosisInfo').hide();
      $('#customDiagnosisGroup').hide();
      $('#consultationDiagnosisCustom').val('');
      window.consultationState.selectedDiagnosis = null;
      
      console.log('Diagnosis selection cleared');
  }

  function showCustomDiagnosis() {
      $('#customDiagnosisGroup').show();
      $('#consultationDiagnosisCustom').focus();
      $('#selectedDiagnosisInfo').hide();
      $('#consultationDiagnosis').val('').trigger('change');
      window.consultationState.selectedDiagnosis = null;
      
      showMessage('Custom diagnosis mode enabled', 'info');
  }

  // =============================================
  // VERIFICATION CONTROLS
  // =============================================
  
  function skipVerification() {
      window.consultationState.verificationPassed = true;
      $('#verificationPassed').val('1');
      
      $('#verificationStatus').html('<span class="label label-warning"><i class="fa fa-user-shield"></i> Admin Override</span>');
      
      $("#fingerprintStatus").html(`
          <div class="alert alert-warning">
              <i class="fa fa-shield"></i> <strong>Verification bypassed - Admin override active</strong><br>
              <small>Biometric verification skipped by administrator</small>
          </div>
      `);
      
      $('#startConsultationBtn').prop('disabled', false);
      
      addToVerificationHistory('Admin Override', 0, 'Bypassed');
      
      showMessage('Verification bypassed - Admin override active', 'warning');
  }

  function clearCaptureData() {
      window.consultationState.liveTemplate = null;
      $('#liveScannedTemplate').val('');
      $('#liveFingerprintImage').attr('src', './Images/PlaceFinger.bmp');
      $('#liveTemplateDetails').text('Ready for capture');
      
      $("#fingerprintStatus").html(`
          <div class="alert alert-info">
              <i class="fa fa-info-circle"></i> Capture data cleared - Ready for new verification
          </div>
      `);
      
      if (window.consultationState.storedTemplate) {
          $('#verifyIdentity').prop('disabled', true);
          showMessage('Live capture cleared. Use Manual Print Capture again.', 'info');
      }
  }

  // =============================================
  // LAB REPORT FUNCTIONS
  // =============================================
  
  function generateLabReport() {
      const dateFrom = $('#labReportDateFrom').val();
      const dateTo = $('#labReportDateTo').val();
      const categoryId = $('#reportTestCategory').val();
      const testStatus = $('#reportTestStatus').val();
      
      if (!dateFrom || !dateTo) {
          showMessage('Please select both from and to dates', 'warning');
          return;
      }
      
      $('#generateLabReport').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Generating...');
      
      $.ajax({
          url: '<?php echo base_url("admin/consultation/generateLabReport"); ?>',
          type: 'POST',
          data: {
              date_from: dateFrom,
              date_to: dateTo,
              category_id: categoryId,
              test_status: testStatus
          },
          dataType: 'json',
          success: function(response) {
              if (response && response.status === 'success') {
                  displayLabReportResults(response.report);
                  $('#exportLabReportPDF, #exportLabReportExcel').show();
              } else {
                  showMessage('Failed to generate lab report', 'error');
              }
          },
          error: function(xhr, status, error) {
              showMessage(`Error generating lab report: ${error}`, 'error');
          },
          complete: function() {
              $('#generateLabReport').prop('disabled', false).html('<i class="fa fa-search"></i> Generate Report');
          }
      });
  }

  function displayLabReportResults(report) {
      $('#reportTotalTests').text(report.total_tests || 0);
      $('#reportCompletedTests').text(report.completed_tests || 0);
      $('#reportPendingTests').text(report.pending_tests || 0);
      $('#reportCriticalTests').text(report.critical_tests || 0);
      
      $('#labReportResults').show();
  }

  // =============================================
  // EVENT HANDLERS
  // =============================================

  function initializeEvents() {
      // Patient selection
      $('#consultation_patient_search').on('change', function() {
          const patientId = $(this).val();
          if (patientId) {
              loadPatientDetails(patientId);
          } else {
              $('#patientDetailsSection').hide();
              resetVerificationState();
          }
      });
      
      // SecuGen fingerprint operations
      $('#manualVerifyBtn').on('click', function(e) {
          e.preventDefault();
          performManualVerification();
      });

      $('#verifyIdentity').on('click', function(e) {
          e.preventDefault();
          performBiometricVerification();
      });
      
      // Verification controls
      $('#skipVerificationBtn').on('click', function() {
          skipVerification();
      });
      
      $('#clearCaptureData').on('click', function() {
          clearCaptureData();
      });
      
      // Consultation management
      $('#startConsultationBtn').on('click', function() {
          startConsultation();
      });
      
      // Lab tests selection
      $(document).on('change', '.lab-test-checkbox', function() {
          updateSelectedTestsSummary();
      });
      
      $('#selectAllTests').on('click', function() {
          const activeTab = $('.tab-pane.active');
          activeTab.find('.lab-test-checkbox').prop('checked', true);
          updateSelectedTestsSummary();
          showMessage('All tests in current category selected', 'info');
      });
      
      $('#clearAllTests').on('click', function() {
          $('.lab-test-checkbox').prop('checked', false);
          updateSelectedTestsSummary();
          showMessage('All test selections cleared', 'info');
      });
      
      // Lab dashboard
      $('#labReportBtn').on('click', function() {
          $('#labReportModal').modal('show');
          // Set default dates
          const today = new Date().toISOString().split('T')[0];
          const firstDay = new Date(new Date().getFullYear(), new Date().getMonth(), 1).toISOString().split('T')[0];
          $('#labReportDateFrom').val(firstDay);
          $('#labReportDateTo').val(today);
      });
      
      $('#generateLabReport').on('click', function() {
          generateLabReport();
      });
      
      // Tab changes
      $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
          const target = $(e.target).attr("href");
          if (target === '#tab_lab_dashboard') {
              loadLabDashboard();
          } else if (target === '#tab_consultation_list') {
              loadConsultationsList();
          }
      });
      
      // Diagnosis selection events
      $('#consultationDiagnosis').on('change', function() {
          const selectedValue = $(this).val();
          if (selectedValue) {
              selectDiagnosis(selectedValue);
          } else {
              $('#selectedDiagnosisInfo').hide();
              window.consultationState.selectedDiagnosis = null;
          }
      });
      
      $('#addCustomDiagnosis').on('click', function() {
          showCustomDiagnosis();
      });
      
      $('#clearDiagnosis').on('click', function() {
          clearDiagnosis();
      });
      
      // Form submissions
      $('#consultationForm').on('submit', function(e) {
          e.preventDefault();
          saveConsultation();
      });
      
      $('#addPatientForm').on('submit', function(e) {
          e.preventDefault();
          addNewPatient();
      });
      
      $('#testResultsForm').on('submit', function(e) {
          e.preventDefault();
          submitTestResults();
      });
  }

  function addNewPatient() {
      const submitBtn = $('#addPatientForm').find('button[type="submit"]');
      submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
      
      $.ajax({
          url: '<?php echo base_url("admin/consultation/addPatient"); ?>',
          type: 'POST',
          data: $('#addPatientForm').serialize(),
          dataType: 'json',
          success: function(response) {
              if (response.status === 'success') {
                  showMessage(response.message, 'success');
                  $('#addPatientModal').modal('hide');
                  loadPatients();
                  $('#addPatientForm')[0].reset();
              } else {
                  showMessage(response.message || 'Failed to add patient', 'error');
              }
          },
          error: function(xhr, status, error) {
              showMessage(`Error adding patient: ${error}`, 'error');
          },
          complete: function() {
              submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Patient');
          }
      });
  }

  // =============================================
  // MODAL RESET HANDLERS
  // =============================================

  $('#consultationModal').on('hidden.bs.modal', function() {
      resetConsultationForm();
      $('#modalTitle').text('New Consultation');
      $('#modalConsultationId').val('');
      $('#modalVerificationDetails').html('');
  });

  $('#addPatientModal').on('hidden.bs.modal', function() {
      $('#addPatientForm')[0].reset();
  });

  $('#testResultsModal').on('hidden.bs.modal', function() {
      $('#testResultsForm')[0].reset();
  });

  $('#labReportModal').on('hidden.bs.modal', function() {
      $('#labReportResults').hide();
      $('#exportLabReportPDF, #exportLabReportExcel').hide();
  });

  // =============================================
  // INITIALIZATION SEQUENCE
  // =============================================

  try {
      console.log('Starting Enhanced Consultation System with SecuGen WebAPI & Lab Tests Integration');
      
      // Initialize SecuGen service
      initializeSecuGenService();
      
      // Load patients and set up events
      loadPatients();
      initializeEvents();
      
      // Set default dates for lab report
      const today = new Date().toISOString().split('T')[0];
      const firstDay = new Date(new Date().getFullYear(), new Date().getMonth(), 1).toISOString().split('T')[0];
      $('#labReportDateFrom').val(firstDay);
      $('#labReportDateTo').val(today);
      
      console.log('🔬 Enhanced Consultation System with Lab Tests Integration Ready');
      
      setTimeout(function() {
          showMessage('Consultation system with lab tests ready - SGIFPCapture and SGIMatchScore available', 'success');
      }, 1000);
      
  } catch (error) {
      console.error('System initialization failed:', error);
      showMessage(`Failed to initialize consultation system: ${error.message}`, 'error');
  }

 // =============================================
  // GLOBAL HELPER FUNCTIONS
  // =============================================

  // Global functions for table actions
  window.viewConsultation = function(consultationId) {
      console.log('View consultation:', consultationId);
      // TODO: Implement view consultation details modal
  };

  window.editConsultation = function(consultationId) {
      console.log('Edit consultation:', consultationId);
      // TODO: Implement edit consultation functionality
  };

  window.viewConsultationTests = function(consultationId) {
      console.log('View consultation tests:', consultationId);
      // TODO: Implement view consultation tests modal
  };

  window.viewTestDetails = function(testId) {
      console.log('View test details:', testId);
      // TODO: Implement view test details modal
  };

  window.enterTestResults = enterTestResults;
  window.printTestReport = function(testId) {
      console.log('Print test report:', testId);
      // TODO: Implement print test report functionality
  };

  // =============================================
  // DEBUG FUNCTIONS
  // =============================================

  window.debugConsultationSystem = function() {
      console.log('=== Enhanced Consultation System with Lab Tests Integration Debug Information ===');
      console.log('SecuGen Configuration:', window.secugenConfig);
      console.log('Consultation State:', window.consultationState);
      console.log('Lab Tests Data:', window.consultationState.labTests);
      console.log('Service Active:', window.secugenConfig.serviceActive);
      console.log('Current Base URL:', window.secugenConfig.baseUrl);
      console.log('Selected Patient:', window.consultationState.selectedPatientId);
      console.log('Verification Passed:', window.consultationState.verificationPassed);
      console.log('Selected Diagnosis:', window.consultationState.selectedDiagnosis);
      console.log('Selected Tests:', window.consultationState.labTests.selected);
      console.log('Estimated Tests Cost:', window.consultationState.labTests.estimatedCost);
      console.log('Available Tests:', window.consultationState.labTests.available);
      console.log('Stored Template Size:', window.consultationState.storedTemplate ? window.consultationState.storedTemplate.length : 0);
      console.log('Live Template Size:', window.consultationState.liveTemplate ? window.consultationState.liveTemplate.length : 0);
      console.log('Last Match Score:', window.consultationState.currentMatchScore);
      console.log('Verification History:', window.consultationState.verificationHistory);
      
      // Test patient loading
      console.log('Testing patient loading...');
      loadPatients();
  };

  window.testLabTestsLoading = function() {
      console.log('Testing lab tests loading...');
      loadLabTestsData();
  };

  window.testIcdLoading = function() {
      console.log('Testing ICD-10 diagnosis loading...');
      loadIcdDiagnoses();
  };

}); // End of $(document).ready

// =============================================
// CONSOLE HELP AND DOCUMENTATION
// =============================================

console.log(`
=== Enhanced Consultation System with SecuGen WebAPI & Lab Tests Integration ===

🔐 SECUGEN WEBAPI INTEGRATION FEATURES:
✓ Official SGIFPCapture endpoint for fingerprint capture
✓ Official SGIMatchScore endpoint for template comparison  
✓ Comprehensive error handling with SecuGen error codes
✓ Manual verification fallback using XMLHttpRequest
✓ Advanced diagnostics and troubleshooting tools

🏥 ICD-10 DIAGNOSIS FEATURES:
✓ Searchable dropdown with ICD-10 diagnosis codes
✓ Select2 integration for enhanced search experience
✓ Grouped diagnosis codes by category
✓ Custom diagnosis fallback option
✓ Proper storage in consultation_diagnosis table

🔬 NEW LAB TESTS INTEGRATION FEATURES:
✓ Categorized lab tests selection (Hematology, Chemistry, Microbiology, Serology, Others)
✓ Real-time test selection with cost estimation
✓ Integration with existing lab_tests and pathology tables
✓ Test priority and special instructions support
✓ Lab dashboard with test statistics and charts
✓ Test results entry and management
✓ Lab reporting and export capabilities
✓ Test status tracking (pending, completed, critical, abnormal)

📋 AVAILABLE DEBUG COMMANDS:
- debugConsultationSystem() - Show detailed system status including lab tests data
- testLabTestsLoading() - Test the lab tests loading functionality
- testIcdLoading() - Test ICD-10 diagnosis loading functionality
- testSecuGenCapture() - Test fingerprint capture functionality  
- testSecuGenMatching() - Test template matching (requires templates)

🔧 REQUIRED BACKEND MODIFICATIONS:
1. Add lab tests fields to consultations table
2. Create getLabTestsForConsultation() method in Consultation controller
3. Create saveWithLabTests() method for consultation saving with tests
4. Create getLabSummary() method for lab dashboard
5. Create getRecentLabTests() method for lab tests table
6. Create saveTestResults() method for test results entry
7. Create generateLabReport() method for lab reporting
8. Update consultation table with lab tests reference columns
9. Create consultation_lab_tests pivot table for many-to-many relationship
10. Ensure proper integration with existing lab_tests and pathology tables

🔬 LAB TESTS SYSTEM USAGE:
- Automatic loading of tests by category from lab_tests/pathology tables
- Real-time selection with cost calculation
- Test priority assignment (Normal, Urgent, STAT)
- Special instructions for lab technicians
- Integration with existing laboratory workflow
- Test results entry and status tracking
- Lab dashboard with comprehensive analytics
- Detailed lab reporting with export options
- Integration with existing patient consultation system

📊 LAB DASHBOARD FEATURES:
- Total tests, pending tests, completed tests, and critical results counters
- Test distribution charts by category
- Test status pie charts
- Recent lab tests table with action buttons
- Export capabilities for reports and data
- Real-time updates and analytics

🧪 TEST CATEGORIES SUPPORTED:
- Hematology: CBC, Hemoglobin, Hematocrit, ESR
- Clinical Chemistry: Glucose tests, Liver function, Kidney function, Lipid profile
- Microbiology: Blood culture, Urine culture, Stool culture
- Serology: HIV, Hepatitis B/C, VDRL, Widal test
- Others: Urinalysis, Pregnancy test, Thyroid function tests

🔗 INTEGRATION POINTS:
- Patient consultation workflow
- SecuGen biometric verification system
- ICD-10 diagnosis coding
- Lab tests from existing pathology/lab_tests tables
- Test results management
- Financial cost estimation
- Report generation and export

🚀 PERFORMANCE OPTIMIZATIONS:
- Lazy loading of test categories
- Real-time UI updates
- Efficient AJAX calls with error handling
- Responsive design for mobile devices
- Chart.js integration for visual analytics
- Select2 for enhanced dropdown experiences

⚡ QUICK START GUIDE:
1. Select a patient from the dropdown
2. Perform biometric verification (or admin override)
3. Click "Start Consultation" 
4. Fill in symptoms and diagnosis
5. Select relevant lab tests by category
6. Set test priority and special instructions
7. Save consultation with selected tests
8. View lab dashboard for test management
9. Enter test results as they become available
10. Generate reports and export data

💡 TIPS FOR USAGE:
- Use Select All/Clear All buttons for efficient test selection
- Monitor estimated costs in real-time
- Use test priority levels appropriately (STAT for emergencies)
- Check lab dashboard regularly for pending results
- Use verification history for audit trails
- Export reports for external analysis
- Utilize debug functions for troubleshooting

🔧 TROUBLESHOOTING:
- If SecuGen service fails, check SSL certificate acceptance
- If lab tests don't load, verify backend endpoints exist
- For verification issues, check fingerprint template quality
- If forms fail to submit, check console for JavaScript errors
- For missing data, verify database table structures
- Use debug functions to inspect system state

📞 SUPPORT:..
- Use browser developer tools for debugging
- Check console logs for detailed error messages
- Verify all required backend endpoints are implemented
- Test with sample data before production use
- Monitor network tab for failed AJAX requests
- Ensure proper database permissions and structure
`);
</script>