<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Setup extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }
    
    public function procurement() {
        echo "<h2>Setting up Procurement Module</h2>";
        
        // Create basic tables
        $this->createDepartments();
        $this->createBasicProcurementTables();
        
        echo "<p>✓ Basic tables created</p>";
        echo "<p><a href='" . base_url('admin/procurement') . "'>Go to Procurement Module</a></p>";
    }
    
    private function createDepartments() {
        if (!$this->db->table_exists('departments')) {
            $sql = "CREATE TABLE `departments` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `department_name` varchar(100) NOT NULL,
                `department_code` varchar(20) UNIQUE NOT NULL,
                `is_active` enum('yes','no') DEFAULT 'yes',
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            
            $this->db->query($sql);
            
            $departments = [
                ['department_name' => 'Pharmacy', 'department_code' => 'PHARM'],
                ['department_name' => 'Laboratory', 'department_code' => 'LAB'],
                ['department_name' => 'Radiology', 'department_code' => 'RAD'],
                ['department_name' => 'Surgery', 'department_code' => 'SURG'],
                ['department_name' => 'Emergency', 'department_code' => 'EMER']
            ];
            
            $this->db->insert_batch('departments', $departments);
        }
    }
    
    private function createBasicProcurementTables() {
        // Purchase Requisitions
        if (!$this->db->table_exists('purchase_requisitions')) {
            $sql = "CREATE TABLE `purchase_requisitions` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `requisition_no` varchar(50) UNIQUE NOT NULL,
                `requesting_department_id` int(11) NOT NULL,
                `requested_by` int(11) NOT NULL,
                `request_date` date NOT NULL,
                `required_date` date DEFAULT NULL,
                `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
                `purpose` text,
                `total_estimated_cost` decimal(15,2) DEFAULT 0.00,
                `status` enum('draft','pending_approval','approved','rejected','fulfilled') DEFAULT 'draft',
                `approved_by` int(11) DEFAULT NULL,
                `approved_date` datetime DEFAULT NULL,
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $this->db->query($sql);
        }
        
        // Purchase Requisition Items
        if (!$this->db->table_exists('purchase_requisition_items')) {
            $sql = "CREATE TABLE `purchase_requisition_items` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `requisition_id` int(11) NOT NULL,
                `item_id` int(11) NOT NULL,
                `quantity_requested` int(11) NOT NULL,
                `unit_cost_estimated` decimal(10,2) DEFAULT 0.00,
                `total_cost_estimated` decimal(15,2) DEFAULT 0.00,
                `quantity_approved` int(11) DEFAULT NULL,
                `specifications` text,
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $this->db->query($sql);
        }
        
        // Purchase Orders
        if (!$this->db->table_exists('purchase_orders')) {
            $sql = "CREATE TABLE `purchase_orders` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `lpo_number` varchar(50) UNIQUE NOT NULL,
                `supplier_id` int(11) NOT NULL,
                `requisition_id` int(11) DEFAULT NULL,
                `order_date` date NOT NULL,
                `expected_delivery_date` date DEFAULT NULL,
                `subtotal` decimal(15,2) DEFAULT 0.00,
                `tax_amount` decimal(15,2) DEFAULT 0.00,
                `total_amount` decimal(15,2) DEFAULT 0.00,
                `status` enum('draft','sent','confirmed','partially_received','fully_received','cancelled') DEFAULT 'draft',
                `created_by` int(11) NOT NULL,
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $this->db->query($sql);
        }
        
        // Purchase Order Items
        if (!$this->db->table_exists('purchase_order_items')) {
            $sql = "CREATE TABLE `purchase_order_items` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `purchase_order_id` int(11) NOT NULL,
                `item_id` int(11) NOT NULL,
                `quantity_ordered` int(11) NOT NULL,
                `unit_cost` decimal(10,2) NOT NULL,
                `total_cost` decimal(15,2) NOT NULL,
                `quantity_received` int(11) DEFAULT 0,
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $this->db->query($sql);
        }
    }
}