<?php

defined('BASEPATH') or exit('No direct script access allowed');


function my_autoloader($class)
{

    if (substr($class, 0, 9) == "MY_Addon_") {
   
       if (file_exists($file = APPPATH . 'core/' . $class . '.php')) {
            include $file;
        }
    }
}
spl_autoload_register('my_autoloader');

$route['default_controller']                 = 'welcome/index';
$route['user/resetpassword/([a-z]+)/(:any)'] = 'site/resetpassword/$1/$2';
$route['admin/resetpassword/(:any)']         = 'site/admin_resetpassword/$1';
$route['admin/unauthorized']                 = 'admin/admin/unauthorized';
$route['404_override'] = 'welcome/show_404';
$route['translate_uri_dashes'] = false;
$route['form/appointment']     = 'welcome/appointment';
$route['page/annual_calendar']     = 'welcome/annual_calendar';

//======= front url rewriting==========
$route['page/(:any)'] = 'welcome/page/$1';
$route['read/(:any)'] = 'welcome/read/$1';
$route['frontend']    = 'welcome';

// =============================================
// NURSING MODULE ROUTES - COMPREHENSIVE
// =============================================

// Main Nursing Dashboard
$route['admin/nursing'] = 'admin/Nursing/index';
$route['admin/nursing/index'] = 'admin/Nursing/index';
$route['admin/nursing/dashboard'] = 'admin/Nursing/index';

// Patient Search and Management
$route['admin/nursing/searchPatients'] = 'admin/Nursing/searchPatients';
$route['admin/nursing/getPatientDetails'] = 'admin/Nursing/getPatientDetails';
$route['admin/nursing/patient_profile/(:num)'] = 'admin/Nursing/patient_profile/$1';
$route['admin/nursing/get_patient_info/(:num)'] = 'admin/Nursing/get_patient_info/$1';
$route['admin/nursing/patient_search'] = 'admin/Nursing/patient_search';

// Vital Signs Management
$route['admin/nursing/vital_signs'] = 'admin/Nursing/vital_signs';
$route['admin/nursing/vital_signs/(:num)'] = 'admin/Nursing/vital_signs/$1';
$route['admin/nursing/all_vital_signs'] = 'admin/Nursing/all_vital_signs';
$route['admin/nursing/add_vital_signs'] = 'admin/Nursing/add_vital_signs';
$route['admin/nursing/get_vital_signs/(:num)'] = 'admin/Nursing/get_vital_signs/$1';
$route['admin/nursing/get_vital_details'] = 'admin/Nursing/get_vital_details';
$route['admin/nursing/delete_vital_signs'] = 'admin/Nursing/delete_vital_signs';

// Nursing Notes Management
$route['admin/nursing/add_nurse_note'] = 'admin/Nursing/add_nurse_note';
$route['admin/nursing/getAllNursingNotes'] = 'admin/Nursing/getAllNursingNotes';
$route['admin/nursing/getNoteDetails'] = 'admin/Nursing/getNoteDetails';
$route['admin/nursing/getNursingStaff'] = 'admin/Nursing/getNursingStaff';

// Procedures Management
$route['admin/nursing/add_procedure'] = 'admin/Nursing/add_procedure';
$route['admin/nursing/get_procedure_templates'] = 'admin/Nursing/get_procedure_templates';
$route['admin/nursing/update_procedure_status'] = 'admin/Nursing/update_procedure_status';

// Assessments Management
$route['admin/nursing/add_assessment'] = 'admin/Nursing/add_assessment';

// Care Plans Management
$route['admin/nursing/create_care_plan'] = 'admin/Nursing/create_care_plan';

// Reports and Analytics
$route['admin/nursing/reports'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/daily'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/procedures'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/medication'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/vital_signs'] = 'admin/Nursing/reports';

// Export Functionality
$route['admin/nursing/exportNursingNotes'] = 'admin/Nursing/exportNursingNotes';
$route['admin/nursing/exportVitalSigns'] = 'admin/Nursing/exportVitalSigns';
$route['admin/nursing/exportProcedures'] = 'admin/Nursing/exportProcedures';
$route['admin/nursing/exportAssessments'] = 'admin/Nursing/exportAssessments';

// Report Generation
$route['admin/nursing/generateDailyReport'] = 'admin/Nursing/generateDailyReport';
$route['admin/nursing/generateWeeklyReport'] = 'admin/Nursing/generateWeeklyReport';
$route['admin/nursing/generateMonthlyReport'] = 'admin/Nursing/generateMonthlyReport';

// Setup and Testing
$route['admin/nursing/setup'] = 'admin/Nursing/setup';
$route['admin/nursing/test'] = 'admin/Nursing/test';
$route['admin/nursing/debug_forms'] = 'admin/Nursing/debug_forms';
$route['admin/nursing/test_vital_signs'] = 'admin/Nursing/test_vital_signs';
$route['admin/nursing/test_nursing_note'] = 'admin/Nursing/test_nursing_note';

// Consultation routes
$route['admin/consultation'] = 'admin/consultation/index';
$route['admin/consultation/test'] = 'admin/consultation/test';
$route['admin/consultation/debug_patients'] = 'admin/consultation/debug_patients';
$route['admin/consultation/patient_search'] = 'admin/consultation/patient_search';
$route['admin/consultation/getAllPatients'] = 'admin/consultation/getAllPatients';
$route['admin/consultation/getPatientDetails'] = 'admin/consultation/getPatientDetails';
$route['admin/consultation/save'] = 'admin/consultation/save';
$route['admin/consultation/getConsultationList'] = 'admin/consultation/getConsultationList';
$route['admin/consultation/getPatientConsultations'] = 'admin/consultation/getPatientConsultations';

$route['admin/financial_reports'] = 'admin/financial_reports';
$route['admin/financial_reports/(:any)'] = 'admin/financial_reports/$1';

// Main procurement dashboard
$route['admin/procurement'] = 'admin/procurement/index';
$route['admin/procurement/dashboard'] = 'admin/procurement/index';

// =============================================
// REQUISITIONS ROUTES
// =============================================

// Requisitions management
$route['admin/procurement/requisitions'] = 'admin/procurement/requisitions';
$route['admin/procurement/requisitions/(:any)'] = 'admin/procurement/requisitions/$1';

// AJAX routes for requisitions
$route['admin/procurement/getRequisitionsList'] = 'admin/procurement/getRequisitionsList';
$route['admin/procurement/saveRequisition'] = 'admin/procurement/saveRequisition';
$route['admin/procurement/updateRequisition'] = 'admin/procurement/updateRequisition';
$route['admin/procurement/approveRequisition'] = 'admin/procurement/approveRequisition';
$route['admin/procurement/rejectRequisition'] = 'admin/procurement/rejectRequisition';
$route['admin/procurement/deleteRequisition/(:num)'] = 'admin/procurement/deleteRequisition/$1';

// Requisition details and items
$route['admin/procurement/viewRequisition/(:num)'] = 'admin/procurement/viewRequisition/$1';
$route['admin/procurement/getRequisitionItems/(:num)'] = 'admin/procurement/getRequisitionItems/$1';
$route['admin/procurement/printRequisition/(:num)'] = 'admin/procurement/printRequisition/$1';

// =============================================
// PURCHASE ORDERS (LPO) ROUTES
// =============================================

// Purchase orders management
$route['admin/procurement/purchaseOrders'] = 'admin/procurement/purchaseOrders';
$route['admin/procurement/purchase-orders'] = 'admin/procurement/purchaseOrders';
$route['admin/procurement/lpo'] = 'admin/procurement/purchaseOrders';

// AJAX routes for purchase orders
$route['admin/procurement/getPurchaseOrdersList'] = 'admin/procurement/getPurchaseOrdersList';
$route['admin/procurement/createLPOFromRequisition'] = 'admin/procurement/createLPOFromRequisition';
$route['admin/procurement/savePurchaseOrder'] = 'admin/procurement/savePurchaseOrder';
$route['admin/procurement/updatePurchaseOrder'] = 'admin/procurement/updatePurchaseOrder';
$route['admin/procurement/cancelPurchaseOrder/(:num)'] = 'admin/procurement/cancelPurchaseOrder/$1';

// Purchase order details and printing
$route['admin/procurement/viewLPO/(:num)'] = 'admin/procurement/viewLPO/$1';
$route['admin/procurement/printLPO/(:num)'] = 'admin/procurement/printLPO/$1';
$route['admin/procurement/emailLPO/(:num)'] = 'admin/procurement/emailLPO/$1';
$route['admin/procurement/downloadLPO/(:num)'] = 'admin/procurement/downloadLPO/$1';

// LPO status updates
$route['admin/procurement/markLPOSent/(:num)'] = 'admin/procurement/markLPOSent/$1';
$route['admin/procurement/confirmLPO/(:num)'] = 'admin/procurement/confirmLPO/$1';

// =============================================
// GOODS RECEIVED NOTES (GRN) ROUTES
// =============================================

// GRN management
$route['admin/procurement/goodsReceived'] = 'admin/procurement/goodsReceived';
$route['admin/procurement/goods-received'] = 'admin/procurement/goodsReceived';
$route['admin/procurement/grn'] = 'admin/procurement/goodsReceived';

// AJAX routes for GRN
$route['admin/procurement/getGRNList'] = 'admin/procurement/getGRNList';
$route['admin/procurement/createGRN'] = 'admin/procurement/createGRN';
$route['admin/procurement/saveGRN'] = 'admin/procurement/saveGRN';
$route['admin/procurement/updateGRN'] = 'admin/procurement/updateGRN';

// GRN details and printing
$route['admin/procurement/viewGRN/(:num)'] = 'admin/procurement/viewGRN/$1';
$route['admin/procurement/printGRN/(:num)'] = 'admin/procurement/printGRN/$1';
$route['admin/procurement/getPOItemsForGRN/(:num)'] = 'admin/procurement/getPOItemsForGRN/$1';

// Quality control and verification
$route['admin/procurement/verifyGRN/(:num)'] = 'admin/procurement/verifyGRN/$1';
$route['admin/procurement/postGRN/(:num)'] = 'admin/procurement/postGRN/$1';

// =============================================
// SUPPLIERS MANAGEMENT ROUTES
// =============================================

// Suppliers management
$route['admin/procurement/suppliers'] = 'admin/procurement/suppliers';
$route['admin/procurement/vendors'] = 'admin/procurement/suppliers';

// AJAX routes for suppliers
$route['admin/procurement/getSuppliersList'] = 'admin/procurement/getSuppliersList';
$route['admin/procurement/saveSupplier'] = 'admin/procurement/saveSupplier';
$route['admin/procurement/updateSupplier'] = 'admin/procurement/updateSupplier';
$route['admin/procurement/deleteSupplier/(:num)'] = 'admin/procurement/deleteSupplier/$1';

// Supplier details
$route['admin/procurement/viewSupplier/(:num)'] = 'admin/procurement/viewSupplier/$1';
$route['admin/procurement/getSupplierDetails/(:num)'] = 'admin/procurement/getSupplierDetails/$1';
$route['admin/procurement/searchSuppliers'] = 'admin/procurement/searchSuppliers';

// Supplier performance and evaluation
$route['admin/procurement/supplierPerformance/(:num)'] = 'admin/procurement/supplierPerformance/$1';
$route['admin/procurement/evaluateSupplier/(:num)'] = 'admin/procurement/evaluateSupplier/$1';

// =============================================
// ITEMS/PRODUCTS MANAGEMENT ROUTES
// =============================================

// Items management
$route['admin/procurement/items'] = 'admin/procurement/items';
$route['admin/procurement/products'] = 'admin/procurement/items';
$route['admin/procurement/inventory'] = 'admin/procurement/items';

// AJAX routes for items
$route['admin/procurement/getItemsList'] = 'admin/procurement/getItemsList';
$route['admin/procurement/saveItem'] = 'admin/procurement/saveItem';
$route['admin/procurement/updateItem'] = 'admin/procurement/updateItem';
$route['admin/procurement/deleteItem/(:num)'] = 'admin/procurement/deleteItem/$1';

// Item details and search
$route['admin/procurement/viewItem/(:num)'] = 'admin/procurement/viewItem/$1';
$route['admin/procurement/getItemDetails/(:num)'] = 'admin/procurement/getItemDetails/$1';
$route['admin/procurement/searchItems'] = 'admin/procurement/searchItems';
$route['admin/procurement/getItemsForSelect'] = 'admin/procurement/getItemsForSelect';

// Item categories
$route['admin/procurement/categories'] = 'admin/procurement/categories';
$route['admin/procurement/itemCategories'] = 'admin/procurement/categories';
$route['admin/procurement/getCategoriesList'] = 'admin/procurement/getCategoriesList';
$route['admin/procurement/saveCategory'] = 'admin/procurement/saveCategory';

// Stock management
$route['admin/procurement/stockReport'] = 'admin/procurement/stockReport';
$route['admin/procurement/lowStockItems'] = 'admin/procurement/lowStockItems';
$route['admin/procurement/stockMovement'] = 'admin/procurement/stockMovement';
$route['admin/procurement/updateStock'] = 'admin/procurement/updateStock';

// =============================================
// BUDGET AND FINANCIAL ROUTES
// =============================================

// Budget management
$route['admin/procurement/budgets'] = 'admin/procurement/budgets';
$route['admin/procurement/budget-tracking'] = 'admin/procurement/budgets';

// AJAX routes for budgets
$route['admin/procurement/getBudgetsList'] = 'admin/procurement/getBudgetsList';
$route['admin/procurement/saveBudget'] = 'admin/procurement/saveBudget';
$route['admin/procurement/updateBudget'] = 'admin/procurement/updateBudget';
$route['admin/procurement/getBudgetUtilization'] = 'admin/procurement/getBudgetUtilization';

// Financial tracking
$route['admin/procurement/commitBudget'] = 'admin/procurement/commitBudget';
$route['admin/procurement/releaseBudget'] = 'admin/procurement/releaseBudget';
$route['admin/procurement/budgetReport'] = 'admin/procurement/budgetReport';

// =============================================
// APPROVAL WORKFLOW ROUTES
// =============================================

// Approval management
$route['admin/procurement/approvals'] = 'admin/procurement/approvals';
$route['admin/procurement/workflow'] = 'admin/procurement/approvals';

// AJAX routes for approvals
$route['admin/procurement/getPendingApprovals'] = 'admin/procurement/getPendingApprovals';
$route['admin/procurement/processApproval'] = 'admin/procurement/processApproval';
$route['admin/procurement/getApprovalHistory/(:any)/(:num)'] = 'admin/procurement/getApprovalHistory/$1/$2';

// Approval workflow configuration
$route['admin/procurement/approvalSettings'] = 'admin/procurement/approvalSettings';
$route['admin/procurement/setApprovalLimits'] = 'admin/procurement/setApprovalLimits';

// =============================================
// REPORTS AND ANALYTICS ROUTES
// =============================================

// Reports dashboard
$route['admin/procurement/reports'] = 'admin/procurement/reports';
$route['admin/procurement/analytics'] = 'admin/procurement/reports';

// Specific reports
$route['admin/procurement/procurementReport'] = 'admin/procurement/procurementReport';
$route['admin/procurement/requisitionReport'] = 'admin/procurement/requisitionReport';
$route['admin/procurement/purchaseOrderReport'] = 'admin/procurement/purchaseOrderReport';
$route['admin/procurement/supplierReport'] = 'admin/procurement/supplierReport';
$route['admin/procurement/spendAnalysis'] = 'admin/procurement/spendAnalysis';
$route['admin/procurement/complianceReport'] = 'admin/procurement/complianceReport';

// Report generation
$route['admin/procurement/generateReport'] = 'admin/procurement/generateReport';
$route['admin/procurement/exportReport/(:any)'] = 'admin/procurement/exportReport/$1';
$route['admin/procurement/downloadReport/(:any)'] = 'admin/procurement/downloadReport/$1';

// =============================================
// SETTINGS AND CONFIGURATION ROUTES
// =============================================

// Procurement settings
$route['admin/procurement/settings'] = 'admin/procurement/settings';
$route['admin/procurement/configuration'] = 'admin/procurement/settings';

// Settings management
$route['admin/procurement/updateSettings'] = 'admin/procurement/updateSettings';
$route['admin/procurement/resetSettings'] = 'admin/procurement/resetSettings';

// Number sequences and prefixes
$route['admin/procurement/numberSequences'] = 'admin/procurement/numberSequences';
$route['admin/procurement/updateSequence'] = 'admin/procurement/updateSequence';

// =============================================
// API ROUTES FOR MOBILE/EXTERNAL ACCESS
// =============================================

// API authentication
$route['api/procurement/auth'] = 'api/procurement/authenticate';
$route['api/procurement/login'] = 'api/procurement/authenticate';

// API data endpoints
$route['api/procurement/requisitions'] = 'api/procurement/getRequisitions';
$route['api/procurement/purchase-orders'] = 'api/procurement/getPurchaseOrders';
$route['api/procurement/suppliers'] = 'api/procurement/getSuppliers';
$route['api/procurement/items'] = 'api/procurement/getItems';

// API operations
$route['api/procurement/create-requisition'] = 'api/procurement/createRequisition';
$route['api/procurement/approve-requisition/(:num)'] = 'api/procurement/approveRequisition/$1';
$route['api/procurement/receive-goods'] = 'api/procurement/receiveGoods';

// =============================================
// DASHBOARD AND WIDGET ROUTES
// =============================================

// Dashboard widgets
$route['admin/procurement/getDashboardStats'] = 'admin/procurement/getDashboardStats';
$route['admin/procurement/getRecentActivity'] = 'admin/procurement/getRecentActivity';
$route['admin/procurement/getPendingItems'] = 'admin/procurement/getPendingItems';
$route['admin/procurement/getBudgetWidget'] = 'admin/procurement/getBudgetWidget';

// Chart data
$route['admin/procurement/getSpendingChart'] = 'admin/procurement/getSpendingChart';
$route['admin/procurement/getSupplierChart'] = 'admin/procurement/getSupplierChart';
$route['admin/procurement/getCategoryChart'] = 'admin/procurement/getCategoryChart';

// =============================================
// INTEGRATION ROUTES
// =============================================

// Finance system integration
$route['admin/procurement/syncWithFinance'] = 'admin/procurement/syncWithFinance';
$route['admin/procurement/postToAccounting'] = 'admin/procurement/postToAccounting';

// Inventory system integration
$route['admin/procurement/syncWithInventory'] = 'admin/procurement/syncWithInventory';
$route['admin/procurement/updateInventoryLevels'] = 'admin/procurement/updateInventoryLevels';

// External system webhooks
$route['webhook/procurement/supplier-update'] = 'webhook/procurement/handleSupplierUpdate';
$route['webhook/procurement/price-update'] = 'webhook/procurement/handlePriceUpdate';

// =============================================
// UTILITY AND HELPER ROUTES
// =============================================

// Autocomplete and search
$route['admin/procurement/autocomplete/items'] = 'admin/procurement/autocompleteItems';
$route['admin/procurement/autocomplete/suppliers'] = 'admin/procurement/autocompleteSuppliers';
$route['admin/procurement/search/(:any)'] = 'admin/procurement/globalSearch/$1';

// File uploads and downloads
$route['admin/procurement/uploadFile'] = 'admin/procurement/uploadFile';
$route['admin/procurement/downloadTemplate/(:any)'] = 'admin/procurement/downloadTemplate/$1';
$route['admin/procurement/importData'] = 'admin/procurement/importData';

// Validation and checks
$route['admin/procurement/validateData'] = 'admin/procurement/validateData';
$route['admin/procurement/checkDuplicates'] = 'admin/procurement/checkDuplicates';
$route['admin/procurement/verifyBudget'] = 'admin/procurement/verifyBudget';

// =============================================
// AUDIT AND LOGGING ROUTES
// =============================================

// Audit trail
$route['admin/procurement/auditTrail'] = 'admin/procurement/auditTrail';
$route['admin/procurement/getAuditLogs'] = 'admin/procurement/getAuditLogs';
$route['admin/procurement/viewAuditDetails/(:num)'] = 'admin/procurement/viewAuditDetails/$1';

// Activity logging
$route['admin/procurement/logActivity'] = 'admin/procurement/logActivity';
$route['admin/procurement/getUserActivity/(:num)'] = 'admin/procurement/getUserActivity/$1';

// =============================================
// NOTIFICATIONS AND ALERTS ROUTES
// =============================================

// Notification management
$route['admin/procurement/notifications'] = 'admin/procurement/notifications';
$route['admin/procurement/getNotifications'] = 'admin/procurement/getNotifications';
$route['admin/procurement/markNotificationRead/(:num)'] = 'admin/procurement/markNotificationRead/$1';

// Alert settings
$route['admin/procurement/alertSettings'] = 'admin/procurement/alertSettings';
$route['admin/procurement/updateAlerts'] = 'admin/procurement/updateAlerts';

// Email notifications
$route['admin/procurement/sendEmailNotification'] = 'admin/procurement/sendEmailNotification';
$route['admin/procurement/emailTemplates'] = 'admin/procurement/emailTemplates';

// =============================================
// BACKUP AND MAINTENANCE ROUTES
// =============================================

// Data backup
$route['admin/procurement/backup'] = 'admin/procurement/backup';
$route['admin/procurement/createBackup'] = 'admin/procurement/createBackup';
$route['admin/procurement/restoreBackup'] = 'admin/procurement/restoreBackup';

// System maintenance
$route['admin/procurement/maintenance'] = 'admin/procurement/maintenance';
$route['admin/procurement/clearCache'] = 'admin/procurement/clearCache';
$route['admin/procurement/optimizeDatabase'] = 'admin/procurement/optimizeDatabase';

// Ensure the route exists
$route['admin/financial/dashboard'] = 'admin/financial/dashboard';
$route['admin/financial/(.+)'] = 'admin/financial/$1';

$route['admin/radio/gettestreportbatch'] = 'radio/gettestreportbatch';

// Patient Billing Routes
$route['admin/patient_billing'] = 'admin/patient_billing/index';
$route['admin/patient_billing/search'] = 'admin/patient_billing/search_patients';
$route['admin/patient_billing/billing/(:num)'] = 'admin/patient_billing/get_billing/$1';
$route['admin/patient_billing/details/(:any)'] = 'admin/patient_billing/get_bill_details/$1';
$route['admin/patient_billing/payment'] = 'admin/patient_billing/process_payment';
$route['admin/patient_billing/export/(:num)'] = 'admin/patient_billing/export_csv/$1';
$route['admin/patient_billing/print/(:num)'] = 'admin/patient_billing/print_statement/$1';

// Alternative direct routes (if API-style doesn't work)
$route['admin/billing/search'] = 'admin/patient_billing/direct_search';
$route['admin/billing/view/(:num)'] = 'admin/patient_billing/view_billing/$1';

$route['admin/laboratory/import-excel'] = 'admin/laboratory/importExcelData';
$route['admin/laboratory/setup-lab-system'] = 'admin/laboratory/setupLabSystem';
$route['admin/laboratory/test-selection'] = 'admin/laboratory/testSelection';
$route['admin/laboratory/results'] = 'admin/laboratory/results';
$route['admin/laboratory/print_result'] = 'admin/laboratory/print_result';

// Main radiology routes
$route['admin/radiology'] = 'admin/radiology/index';
$route['admin/radiology/index'] = 'admin/radiology/index';

// Patient management routes
$route['admin/radiology/getAllPatients'] = 'admin/radiology/getAllPatients';
$route['admin/radiology/getPatientDetails'] = 'admin/radiology/getPatientDetails';
$route['admin/radiology/verifyPatientIdentity'] = 'admin/radiology/verifyPatientIdentity';

// Order management routes
$route['admin/radiology/createRadiologyOrder'] = 'admin/radiology/createRadiologyOrder';
$route['admin/radiology/getRadiologyQueue'] = 'admin/radiology/getRadiologyQueue';
$route['admin/radiology/updateOrderStatus'] = 'admin/radiology/updateOrderStatus';
$route['admin/radiology/getOrderDetails'] = 'admin/radiology/getOrderDetails';

// Reporting and analytics routes
$route['admin/radiology/reports'] = 'admin/radiology/reports';
$route['admin/radiology/statistics'] = 'admin/radiology/statistics';
$route['admin/radiology/generateReport'] = 'admin/radiology/generateReport';

// Equipment management routes
$route['admin/radiology/equipment'] = 'admin/radiology/equipment';
$route['admin/radiology/equipmentStatus'] = 'admin/radiology/equipmentStatus';

// Scheduling routes
$route['admin/radiology/schedule'] = 'admin/radiology/schedule';
$route['admin/radiology/scheduleAppointment'] = 'admin/radiology/scheduleAppointment';
$route['admin/radiology/getSchedule'] = 'admin/radiology/getSchedule';

// Test routes
$route['admin/radiology/test'] = 'admin/radiology/test';

$route['admin/patient_billing'] = 'admin/patient_billing/index';
$route['admin/patient_billing/(:any)'] = 'admin/patient_billing/$1';

// Main pharmacy dashboard (landing page)
$route['admin/pharmacy'] = 'admin/pharmacy/dashboard';
$route['admin/pharmacy/dashboard'] = 'admin/pharmacy/dashboard';

// Keep original medicine stock page accessible
$route['admin/pharmacy/stock'] = 'admin/pharmacy/medicineStock';

// Dashboard and analytics routes
$route['admin/pharmacy/getDashboardStats'] = 'admin/pharmacy/getDashboardStats';
$route['admin/pharmacy/getRecentBills'] = 'admin/pharmacy/getRecentBills';
$route['admin/pharmacy/getPharmacyAlerts'] = 'admin/pharmacy/getPharmacyAlerts';
$route['admin/pharmacy/getStockAlertsCount'] = 'admin/pharmacy/getStockAlertsCount';

// Patient-related pharmacy routes
$route['admin/pharmacy/getPatientBills'] = 'admin/pharmacy/getPatientBills';
$route['admin/pharmacy/getPatientPendingBills'] = 'admin/pharmacy/getPatientPendingBills';
$route['admin/pharmacy/getPatientPharmacySummary'] = 'admin/pharmacy/getPatientPharmacySummary';

// Medicine search and dispensing routes
$route['admin/pharmacy/searchMedicinesForDispensing'] = 'admin/pharmacy/searchMedicinesForDispensing';
$route['admin/pharmacy/quickDispense'] = 'admin/pharmacy/quickDispense';
$route['admin/pharmacy/processQuickDispensing'] = 'admin/pharmacy/processQuickDispensing';
$route['admin/pharmacy/quickMedicineLookup'] = 'admin/pharmacy/quickMedicineLookup';

// Stock management routes
$route['admin/pharmacy/getLowStockMedicines'] = 'admin/pharmacy/getLowStockMedicines';
$route['admin/pharmacy/getExpiredMedicines'] = 'admin/pharmacy/getExpiredMedicines';
$route['admin/pharmacy/getMedicinesExpiringSoon'] = 'admin/pharmacy/getMedicinesExpiringSoon';

// Enhanced bill creation
$route['admin/pharmacy/createBillEnhanced'] = 'admin/pharmacy/createBillEnhanced';

// Analytics and reporting routes
$route['admin/pharmacy/getTopSellingMedicines'] = 'admin/pharmacy/getTopSellingMedicines';
$route['admin/pharmacy/getSalesChartData'] = 'admin/pharmacy/getSalesChartData';
$route['admin/pharmacy/getPerformanceMetrics'] = 'admin/pharmacy/getPerformanceMetrics';
$route['admin/pharmacy/getInventoryValuation'] = 'admin/pharmacy/getInventoryValuation';
$route['admin/pharmacy/getMedicineUsageAnalytics'] = 'admin/pharmacy/getMedicineUsageAnalytics';

// Medicine interaction and workflow routes
$route['admin/pharmacy/checkMedicineInteractions'] = 'admin/pharmacy/checkMedicineInteractions';
$route['admin/pharmacy/getPharmacyWorkflow'] = 'admin/pharmacy/getPharmacyWorkflow';

// Payment processing routes (if implementing bulk payments)
$route['admin/pharmacy/processBulkPayment'] = 'admin/pharmacy/processBulkPayment';
$route['admin/pharmacy/processPartialPayment'] = 'admin/pharmacy/processPartialPayment';
$route['admin/pharmacy/sendPaymentReminder'] = 'admin/pharmacy/sendPaymentReminder';
$route['admin/pharmacy/sendBulkReminders'] = 'admin/pharmacy/sendBulkReminders';

// Enhanced datatable route (if replacing the original)
$route['admin/pharmacy/getpharmacyDatatableEnhanced'] = 'admin/pharmacy/getpharmacyDatatableEnhanced';

// =============================================================================
// PATIENT MODULE ROUTES (for pharmacy integration)
// =============================================================================

// Patient search routes for pharmacy
$route['admin/patient/searchPatients'] = 'admin/patient/searchPatients';
$route['admin/patient/getPatientForPharmacy'] = 'admin/patient/getPatientForPharmacy';

// =============================================================================
// OPTIONAL: URL ALIASES FOR BETTER UX
// =============================================================================

// Friendly URLs for common pharmacy operations
$route['pharmacy'] = 'admin/pharmacy/dashboard';
$route['pharmacy/dashboard'] = 'admin/pharmacy/dashboard';
$route['pharmacy/stock'] = 'admin/pharmacy/medicineStock';
$route['pharmacy/bills'] = 'admin/pharmacy/bill';
$route['pharmacy/reports'] = 'admin/pharmacy/billreport';

// Patient profile route
$route['admin/patient/profile/(:num)'] = 'admin/patient/profile/$1';

// Alternative routes for patient management
$route['admin/patient/view/(:num)'] = 'admin/patient/profile/$1';
$route['admin/patient/details/(:num)'] = 'admin/patient/profile/$1';

// If you want to make it even cleaner, you can also add:
$route['patient/(:num)'] = 'admin/patient/profile/$1';

// Add if not already present
$route['admin/radiology/get_patients'] = 'admin/radiology/get_patients';
$route['admin/radiology/verify_patient'] = 'admin/radiology/verify_patient';
$route['admin/radiology/createRadiologyOrder'] = 'admin/radiology/createRadiologyOrder';
$route['admin/radiology/dashboard'] = 'admin/radiology/dashboard';