<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-bar-chart"></i> Wellness Reports <small>Outreach Analytics</small></h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/wellness'); ?>">Wellness</a></li>
            <li class="active">Reports</li>
        </ol>
    </section>

    <section class="content">
        <?php echo $this->session->flashdata('msg'); ?>
        
        <!-- Filter Section -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Report Filters</h3>
            </div>
            <div class="box-body">
                <?php echo form_open('admin/wellness/reports', array('method' => 'get', 'class' => 'form-horizontal')); ?>
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Location</label>
                            <select class="form-control" name="location">
                                <option value="">All Locations</option>
                                <?php if(isset($locations) && !empty($locations)): ?>
                                    <?php foreach($locations as $location): ?>
                                        <option value="<?php echo $location->location_name; ?>" 
                                                <?php echo (isset($filters['location']) && $filters['location'] == $location->location_name) ? 'selected' : ''; ?>>
                                            <?php echo $location->location_name; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date From</label>
                            <input type="date" class="form-control" name="date_from" 
                                   value="<?php echo isset($filters['date_from']) ? $filters['date_from'] : ''; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date To</label>
                            <input type="date" class="form-control" name="date_to" 
                                   value="<?php echo isset($filters['date_to']) ? $filters['date_to'] : ''; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label><br>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-search"></i> Generate Report
                            </button>
                            <a href="<?php echo base_url('admin/wellness/reports'); ?>" class="btn btn-default">
                                <i class="fa fa-refresh"></i> Reset
                            </a>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>

        <!-- Summary Cards -->
        <?php if (isset($report_data) && !empty($report_data)): ?>
        <?php
        $total_visits = array_sum(array_column($report_data, 'total_visits'));
        $total_revenue = array_sum(array_column($report_data, 'total_revenue'));
        $total_payments = array_sum(array_column($report_data, 'total_payments'));
        $total_outstanding = array_sum(array_column($report_data, 'total_outstanding'));
        $total_consultations = array_sum(array_column($report_data, 'consultations'));
        $total_dental = array_sum(array_column($report_data, 'dental_services'));
        $total_lab = array_sum(array_column($report_data, 'lab_services'));
        ?>
        
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo number_format($total_visits); ?></h3>
                        <p>Total Visits</p>
                    </div>
                    <div class="icon"><i class="fa fa-users"></i></div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>KSh <?php echo number_format($total_revenue); ?></h3>
                        <p>Total Revenue</p>
                    </div>
                    <div class="icon"><i class="fa fa-money"></i></div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>KSh <?php echo number_format($total_payments); ?></h3>
                        <p>Total Payments</p>
                    </div>
                    <div class="icon"><i class="fa fa-credit-card"></i></div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>KSh <?php echo number_format($total_outstanding); ?></h3>
                        <p>Outstanding</p>
                    </div>
                    <div class="icon"><i class="fa fa-exclamation-triangle"></i></div>
                </div>
            </div>
        </div>

        <!-- Service Statistics -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Services Breakdown</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-condensed">
                                    <tr>
                                        <td><i class="fa fa-user-md text-blue"></i> Consultations:</td>
                                        <td><strong><?php echo number_format($total_consultations); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-tooth text-green"></i> Dental:</td>
                                        <td><strong><?php echo number_format($total_dental); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-flask text-yellow"></i> Laboratory:</td>
                                        <td><strong><?php echo number_format($total_lab); ?></strong></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-condensed">
                                    <tr>
                                        <td><i class="fa fa-pills text-red"></i> Pharmacy:</td>
                                        <td><strong><?php echo number_format(array_sum(array_column($report_data, 'pharmacy_services'))); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-x-ray text-purple"></i> Radiology:</td>
                                        <td><strong><?php echo number_format(array_sum(array_column($report_data, 'radiology_services'))); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-eye text-orange"></i> Optical:</td>
                                        <td><strong><?php echo number_format(array_sum(array_column($report_data, 'optical_services'))); ?></strong></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calculator"></i> Financial Summary</h3>
                    </div>
                    <div class="box-body">
                        <table class="table">
                            <tr>
                                <th>Total Billed:</th>
                                <td>KSh <?php echo number_format($total_revenue, 2); ?></td>
                            </tr>
                            <tr>
                                <th>Total Collected:</th>
                                <td class="text-green">KSh <?php echo number_format($total_payments, 2); ?></td>
                            </tr>
                            <tr>
                                <th>Outstanding:</th>
                                <td class="text-red">KSh <?php echo number_format($total_outstanding, 2); ?></td>
                            </tr>
                            <tr>
                                <th>Collection Rate:</th>
                                <td>
                                    <strong>
                                        <?php echo $total_revenue > 0 ? number_format(($total_payments / $total_revenue) * 100, 1) : 0; ?>%
                                    </strong>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Detailed Report Table -->
        <div class="box box-warning">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-table"></i> Detailed Report</h3>
                <div class="box-tools pull-right">
                    <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                        <i class="fa fa-file-excel-o"></i> Export to Excel
                    </button>
                    <button class="btn btn-sm btn-danger" onclick="exportToPDF()">
                        <i class="fa fa-file-pdf-o"></i> Export to PDF
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="report-table" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Location</th>
                                <th>Total Visits</th>
                                <th>Consultations</th>
                                <th>Dental</th>
                                <th>Laboratory</th>
                                <th>Pharmacy</th>
                                <th>Radiology</th>
                                <th>Optical</th>
                                <th>Revenue</th>
                                <th>Payments</th>
                                <th>Outstanding</th>
                                <th>Collection %</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($report_data as $row): ?>
                            <tr>
                                <td><?php echo date('Y-m-d', strtotime($row->visit_date)); ?></td>
                                <td><?php echo $row->location; ?></td>
                                <td><?php echo number_format($row->total_visits); ?></td>
                                <td><?php echo number_format($row->consultations); ?></td>
                                <td><?php echo number_format($row->dental_services); ?></td>
                                <td><?php echo number_format($row->lab_services); ?></td>
                                <td><?php echo number_format($row->pharmacy_services); ?></td>
                                <td><?php echo number_format($row->radiology_services); ?></td>
                                <td><?php echo number_format($row->optical_services); ?></td>
                                <td>KSh <?php echo number_format($row->total_revenue, 2); ?></td>
                                <td>KSh <?php echo number_format($row->total_payments, 2); ?></td>
                                <td>KSh <?php echo number_format($row->total_outstanding, 2); ?></td>
                                <td>
                                    <?php 
                                    $collection_rate = $row->total_revenue > 0 ? ($row->total_payments / $row->total_revenue) * 100 : 0;
                                    echo number_format($collection_rate, 1) . '%';
                                    ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr class="bg-gray">
                                <th colspan="2">TOTALS</th>
                                <th><?php echo number_format($total_visits); ?></th>
                                <th><?php echo number_format($total_consultations); ?></th>
                                <th><?php echo number_format($total_dental); ?></th>
                                <th><?php echo number_format($total_lab); ?></th>
                                <th><?php echo number_format(array_sum(array_column($report_data, 'pharmacy_services'))); ?></th>
                                <th><?php echo number_format(array_sum(array_column($report_data, 'radiology_services'))); ?></th>
                                <th><?php echo number_format(array_sum(array_column($report_data, 'optical_services'))); ?></th>
                                <th>KSh <?php echo number_format($total_revenue, 2); ?></th>
                                <th>KSh <?php echo number_format($total_payments, 2); ?></th>
                                <th>KSh <?php echo number_format($total_outstanding, 2); ?></th>
                                <th><?php echo $total_revenue > 0 ? number_format(($total_payments / $total_revenue) * 100, 1) : 0; ?>%</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <?php else: ?>
        <div class="box box-warning">
            <div class="box-body">
                <div class="alert alert-info">
                    <i class="fa fa-info-circle"></i> No data found for the selected filters. Please adjust your search criteria.
                </div>
            </div>
        </div>
        <?php endif; ?>
    </section>
</div>

<script>
$(document).ready(function() {
    $('#report-table').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[ 0, "desc" ]]
    });
});

function exportToExcel() {
    var filters = '<?php echo isset($filters) ? http_build_query($filters) : ""; ?>';
    window.open('<?php echo base_url("admin/wellness/export_excel"); ?>?' + filters, '_blank');
}

function exportToPDF() {
    var filters = '<?php echo isset($filters) ? http_build_query($filters) : ""; ?>';
    window.open('<?php echo base_url("admin/wellness/export_pdf"); ?>?' + filters, '_blank');
}
</script>