<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-map-marker"></i> Wellness Locations <small>Manage Outreach Locations</small></h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/wellness'); ?>">Wellness</a></li>
            <li class="active">Locations</li>
        </ol>
    </section>

    <section class="content">
        <?php echo $this->session->flashdata('msg'); ?>
        
        <div class="row">
            <!-- Add New Location -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-plus"></i> Add New Location</h3>
                    </div>
                    <?php echo form_open('admin/wellness/add_location', array('id' => 'location-form')); ?>
                    <div class="box-body">
                        <div class="form-group">
                            <label>Location Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="location_name" required 
                                   placeholder="e.g., Kisumu Central">
                        </div>

                        <div class="form-group">
                            <label>Location Code <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="location_code" required 
                                   placeholder="e.g., KSM-001" maxlength="20">
                            <small class="text-muted">Unique identifier for this location</small>
                        </div>

                        <div class="form-group">
                            <label>County <span class="text-danger">*</span></label>
                            <select class="form-control" name="county" required id="county-select">
                                <option value="">Select County</option>
                                <option value="Kisumu">Kisumu</option>
                                <option value="Siaya">Siaya</option>
                                <option value="Homa Bay">Homa Bay</option>
                                <option value="Migori">Migori</option>
                                <option value="Kisii">Kisii</option>
                                <option value="Nyamira">Nyamira</option>
                                <option value="Vihiga">Vihiga</option>
                                <option value="Kakamega">Kakamega</option>
                                <option value="Bungoma">Bungoma</option>
                                <option value="Busia">Busia</option>
                                <!-- Add more counties as needed -->
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Sub County</label>
                            <input type="text" class="form-control" name="sub_county" 
                                   placeholder="e.g., Kisumu Central">
                        </div>

                        <div class="form-group">
                            <label>Address</label>
                            <textarea class="form-control" name="address" rows="3" 
                                      placeholder="Full address of the location"></textarea>
                        </div>

                        <div class="form-group">
                            <label>GPS Coordinates</label>
                            <input type="text" class="form-control" name="gps_coordinates" 
                                   placeholder="e.g., -0.0917, 34.7680">
                            <small class="text-muted">Format: Latitude, Longitude</small>
                        </div>

                        <div class="form-group">
                            <label>Contact Person</label>
                            <input type="text" class="form-control" name="contact_person" 
                                   placeholder="Name of local contact person">
                        </div>

                        <div class="form-group">
                            <label>Contact Phone</label>
                            <input type="text" class="form-control" name="contact_phone" 
                                   placeholder="+254...">
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> Add Location
                        </button>
                        <button type="reset" class="btn btn-default">
                            <i class="fa fa-refresh"></i> Reset
                        </button>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>

            <!-- Locations List -->
            <div class="col-md-8">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Wellness Locations</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-info" id="total-locations">
                                <?php echo isset($locations) ? count($locations) : 0; ?> locations
                            </span>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (isset($locations) && !empty($locations)): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="locations-table">
                                <thead>
                                    <tr>
                                        <th>Code</th>
                                        <th>Location Name</th>
                                        <th>County</th>
                                        <th>Sub County</th>
                                        <th>Contact Person</th>
                                        <th>Phone</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($locations as $location): ?>
                                    <tr>
                                        <td><code><?php echo $location->location_code; ?></code></td>
                                        <td>
                                            <strong><?php echo $location->location_name; ?></strong>
                                            <?php if ($location->address): ?>
                                                <br><small class="text-muted"><?php echo $location->address; ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $location->county; ?></td>
                                        <td><?php echo $location->sub_county ?: '-'; ?></td>
                                        <td><?php echo $location->contact_person ?: '-'; ?></td>
                                        <td><?php echo $location->contact_phone ?: '-'; ?></td>
                                        <td>
                                            <?php if ($location->is_active): ?>
                                                <span class="label label-success">Active</span>
                                            <?php else: ?>
                                                <span class="label label-danger">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-xs">
                                                <button class="btn btn-info" onclick="editLocation(<?php echo $location->id; ?>)" 
                                                        title="Edit Location">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button class="btn btn-warning" onclick="toggleLocationStatus(<?php echo $location->id; ?>, <?php echo $location->is_active; ?>)" 
                                                        title="<?php echo $location->is_active ? 'Deactivate' : 'Activate'; ?>">
                                                    <i class="fa fa-<?php echo $location->is_active ? 'pause' : 'play'; ?>"></i>
                                                </button>
                                                <button class="btn btn-danger" onclick="deleteLocation(<?php echo $location->id; ?>)" 
                                                        title="Delete Location">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No wellness locations have been added yet. Add your first location using the form on the left.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Location Statistics -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bar-chart"></i> Location Statistics</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-aqua"><i class="fa fa-map-marker"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Locations</span>
                                        <span class="info-box-number"><?php echo isset($locations) ? count($locations) : 0; ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-green"><i class="fa fa-check"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Active Locations</span>
                                        <span class="info-box-number">
                                            <?php 
                                            $active_count = 0;
                                            if (isset($locations)) {
                                                foreach ($locations as $loc) {
                                                    if ($loc->is_active) $active_count++;
                                                }
                                            }
                                            echo $active_count;
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-yellow"><i class="fa fa-building"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Counties Covered</span>
                                        <span class="info-box-number">
                                            <?php 
                                            $counties = array();
                                            if (isset($locations)) {
                                                foreach ($locations as $loc) {
                                                    if (!in_array($loc->county, $counties)) {
                                                        $counties[] = $loc->county;
                                                    }
                                                }
                                            }
                                            echo count($counties);
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-red"><i class="fa fa-users"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">This Month Visits</span>
                                        <span class="info-box-number" id="month-visits">0</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Edit Location Modal -->
<div class="modal fade" id="edit-location-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Location</h4>
            </div>
            <?php echo form_open('admin/wellness/update_location'); ?>
            <input type="hidden" name="location_id" id="edit-location-id">
            <div class="modal-body">
                <div class="form-group">
                    <label>Location Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="location_name" id="edit-location-name" required>
                </div>

                <div class="form-group">
                    <label>Location Code <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="location_code" id="edit-location-code" required readonly>
                    <small class="text-muted">Location code cannot be changed</small>
                </div>

                <div class="form-group">
                    <label>County <span class="text-danger">*</span></label>
                    <select class="form-control" name="county" id="edit-county" required>
                        <option value="">Select County</option>
                        <option value="Kisumu">Kisumu</option>
                        <option value="Siaya">Siaya</option>
                        <option value="Homa Bay">Homa Bay</option>
                        <option value="Migori">Migori</option>
                        <option value="Kisii">Kisii</option>
                        <option value="Nyamira">Nyamira</option>
                        <option value="Vihiga">Vihiga</option>
                        <option value="Kakamega">Kakamega</option>
                        <option value="Bungoma">Bungoma</option>
                        <option value="Busia">Busia</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Sub County</label>
                    <input type="text" class="form-control" name="sub_county" id="edit-sub-county">
                </div>

                <div class="form-group">
                    <label>Address</label>
                    <textarea class="form-control" name="address" id="edit-address" rows="3"></textarea>
                </div>

                <div class="form-group">
                    <label>GPS Coordinates</label>
                    <input type="text" class="form-control" name="gps_coordinates" id="edit-gps">
                </div>

                <div class="form-group">
                    <label>Contact Person</label>
                    <input type="text" class="form-control" name="contact_person" id="edit-contact-person">
                </div>

                <div class="form-group">
                    <label>Contact Phone</label>
                    <input type="text" class="form-control" name="contact_phone" id="edit-contact-phone">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Update Location
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#locations-table').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 10
    });

    // Load monthly visit statistics
    loadMonthlyVisits();

    // Form validation
    $('#location-form').on('submit', function(e) {
        var locationCode = $('input[name="location_code"]').val();
        if (!validateLocationCode(locationCode)) {
            e.preventDefault();
            alert('Location code must be in format: XXX-001 (3 letters, dash, 3 numbers)');
            return false;
        }
    });
});

function validateLocationCode(code) {
    var pattern = /^[A-Z]{3}-\d{3}$/;
    return pattern.test(code);
}

function editLocation(locationId) {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_location"); ?>',
        type: 'GET',
        data: { location_id: locationId },
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                var location = data.location;
                $('#edit-location-id').val(location.id);
                $('#edit-location-name').val(location.location_name);
                $('#edit-location-code').val(location.location_code);
                $('#edit-county').val(location.county);
                $('#edit-sub-county').val(location.sub_county);
                $('#edit-address').val(location.address);
                $('#edit-gps').val(location.gps_coordinates);
                $('#edit-contact-person').val(location.contact_person);
                $('#edit-contact-phone').val(location.contact_phone);
                
                $('#edit-location-modal').modal('show');
            } else {
                alert('Error loading location data');
            }
        },
        error: function() {
            alert('Error loading location data');
        }
    });
}

function toggleLocationStatus(locationId, currentStatus) {
    var action = currentStatus ? 'deactivate' : 'activate';
    var newStatus = currentStatus ? 0 : 1;
    
    if (confirm('Are you sure you want to ' + action + ' this location?')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/toggle_location_status"); ?>',
            type: 'POST',
            data: { 
                location_id: locationId, 
                status: newStatus 
            },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error updating location status');
                }
            },
            error: function() {
                alert('Error updating location status');
            }
        });
    }
}

function deleteLocation(locationId) {
    if (confirm('Are you sure you want to delete this location? This action cannot be undone.\n\nNote: You can only delete locations that have no associated visits.')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/delete_location"); ?>',
            type: 'POST',
            data: { location_id: locationId },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error deleting location: ' + (data.message || 'Location may have associated visits'));
                }
            },
            error: function() {
                alert('Error deleting location');
            }
        });
    }
}

function loadMonthlyVisits() {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_monthly_visit_stats"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            $('#month-visits').text(data.monthly_visits || 0);
        }
    });
}

// Auto-generate location code based on county and existing codes
$('#county-select').change(function() {
    var county = $(this).val();
    if (county) {
        generateLocationCode(county);
    }
});

function generateLocationCode(county) {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/generate_location_code"); ?>',
        type: 'GET',
        data: { county: county },
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                $('input[name="location_code"]').val(data.code);
            }
        }
    });
}

// Format phone number input
$('input[name="contact_phone"], #edit-contact-phone').on('input', function() {
    var phone = $(this).val().replace(/\D/g, '');
    if (phone.length > 0 && !phone.startsWith('254')) {
        if (phone.startsWith('0')) {
            phone = '254' + phone.substring(1);
        } else if (phone.startsWith('7') || phone.startsWith('1')) {
            phone = '254' + phone;
        }
    }
    if (phone.length > 12) {
        phone = phone.substring(0, 12);
    }
    $(this).val('+' + phone);
});

// GPS coordinates validation
$('input[name="gps_coordinates"], #edit-gps').on('blur', function() {
    var coords = $(this).val();
    if (coords && !validateGPSCoordinates(coords)) {
        alert('Invalid GPS coordinates format. Use: latitude, longitude (e.g., -0.0917, 34.7680)');
        $(this).focus();
    }
});

function validateGPSCoordinates(coords) {
    var pattern = /^-?\d+\.?\d*,\s*-?\d+\.?\d*$/;
    return pattern.test(coords);
}
</script>

<style>
.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 2px;
    margin-bottom: 15px;
}

.info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.info-box-text {
    display: block;
    font-size: 14px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.bg-aqua { background-color: #00c0ef !important; }
.bg-green { background-color: #00a65a !important; }
.bg-yellow { background-color: #f39c12 !important; }
.bg-red { background-color: #dd4b39 !important; }
</style>