<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-heartbeat"></i> <?php echo $this->lang->line('wellness_module'); ?> <small>Outreach Services</small></h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Wellness</li>
        </ol>
    </section>

    <section class="content">
        <?php echo $this->session->flashdata('msg'); ?>
        
        <!-- Quick Stats -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="today-visits">0</h3>
                        <p>Today's Visits</p>
                    </div>
                    <div class="icon"><i class="fa fa-users"></i></div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="today-revenue">KSh 0</h3>
                        <p>Today's Revenue</p>
                    </div>
                    <div class="icon"><i class="fa fa-money"></i></div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="pending-payments">0</h3>
                        <p>Pending Payments</p>
                    </div>
                    <div class="icon"><i class="fa fa-exclamation-triangle"></i></div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="active-locations"><?php echo count($locations); ?></h3>
                        <p>Active Locations</p>
                    </div>
                    <div class="icon"><i class="fa fa-map-marker"></i></div>
                </div>
            </div>
        </div>

        <!-- New Visit Form -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-plus"></i> New Wellness Visit</h3>
            </div>
            
            <?php echo form_open('admin/wellness/create_visit', array('class' => 'form-horizontal', 'id' => 'wellness-form')); ?>
            <div class="box-body">
                <div class="row">
                    <!-- Patient Information -->
                    <div class="col-md-6">
                        <h4 class="box-title">Patient Information</h4>
                        
                        <div class="form-group">
                            <label class="col-sm-3 control-label">Location <span class="text-danger">*</span></label>
                            <div class="col-sm-9">
                                <select class="form-control" name="location" required>
                                    <option value="">Select Location</option>
                                    <?php foreach($locations as $location): ?>
                                        <option value="<?php echo $location->location_name; ?>">
                                            <?php echo $location->location_name . ' (' . $location->county . ')'; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">Patient Name <span class="text-danger">*</span></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="patient_name" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-4">
                                <label class="control-label">Age</label>
                                <input type="number" class="form-control" name="age" min="0" max="150">
                            </div>
                            <div class="col-sm-5">
                                <label class="control-label">Gender <span class="text-danger">*</span></label>
                                <select class="form-control" name="gender" required>
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">Phone Number</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="phone_number" placeholder="+254...">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">National ID</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="national_id">
                            </div>
                        </div>
                    </div>

                    <!-- Location & Insurance -->
                    <div class="col-md-6">
                        <h4 class="box-title">Location & Insurance Details</h4>
                        
                        <div class="form-group">
                            <label class="col-sm-3 control-label">County</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="county">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">Sub County</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="sub_county">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">Village</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="village">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">Emergency Contact</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="emergency_contact" placeholder="+254...">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-5">
                                <label class="control-label">Insurance Type</label>
                                <select class="form-control" name="insurance_type">
                                    <option value="cash">Cash</option>
                                    <option value="nhif">NHIF</option>
                                    <option value="private">Private Insurance</option>
                                </select>
                            </div>
                            <div class="col-sm-7">
                                <label class="control-label">Insurance Number</label>
                                <input type="text" class="form-control" name="insurance_number">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Chief Complaint</label>
                            <div class="col-sm-10">
                                <textarea class="form-control" name="chief_complaint" rows="3" placeholder="Patient's main complaint or reason for visit"></textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Served By</label>
                            <div class="col-sm-4">
                                <select class="form-control" name="served_by">
                                    <option value="">Select Staff</option>
                                    <?php foreach($staff as $staff_member): ?>
                                        <option value="<?php echo $staff_member['id']; ?>">
                                            <?php echo $staff_member['name'] . ' ' . $staff_member['surname']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Notes</label>
                            <div class="col-sm-10">
                                <textarea class="form-control" name="notes" rows="2" placeholder="Additional notes"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="box-footer">
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Create Wellness Visit
                </button>
                <button type="reset" class="btn btn-default">
                    <i class="fa fa-refresh"></i> Reset Form
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>

        <!-- Recent Visits -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-history"></i> Recent Wellness Visits</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo base_url('admin/wellness/reports'); ?>" class="btn btn-sm btn-success">
                        <i class="fa fa-bar-chart"></i> View Reports
                    </a>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="recent-visits-table" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Visit Ref</th>
                                <th>Date</th>
                                <th>Location</th>
                                <th>Patient</th>
                                <th>Services</th>
                                <th>Amount</th>
                                <th>Payment Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="recent-visits-tbody">
                            <!-- Dynamic content will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Load dashboard stats
    loadDashboardStats();
    
    // Load recent visits
    loadRecentVisits();
    
    // Auto-refresh every 5 minutes
    setInterval(function() {
        loadDashboardStats();
        loadRecentVisits();
    }, 300000);
});

function loadDashboardStats() {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_dashboard_stats"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            $('#today-visits').text(data.today_visits || 0);
            $('#today-revenue').text('KSh ' + (data.today_revenue || 0).toLocaleString());
            $('#pending-payments').text(data.pending_payments || 0);
        }
    });
}

function loadRecentVisits() {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_recent_visits"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            var tbody = $('#recent-visits-tbody');
            tbody.empty();
            
            if (data.length > 0) {
                $.each(data, function(index, visit) {
                    var statusBadge = getPaymentStatusBadge(visit.payment_status);
                    var row = '<tr>' +
                        '<td><a href="<?php echo base_url("admin/wellness/visit_details/"); ?>' + visit.id + '">' + visit.visit_reference + '</a></td>' +
                        '<td>' + visit.visit_date + '</td>' +
                        '<td>' + visit.location + '</td>' +
                        '<td>' + visit.patient_name + '</td>' +
                        '<td>' + (visit.service_count || 0) + '</td>' +
                        '<td>KSh ' + parseFloat(visit.total_amount || 0).toLocaleString() + '</td>' +
                        '<td>' + statusBadge + '</td>' +
                        '<td>' +
                            '<a href="<?php echo base_url("admin/wellness/visit_details/"); ?>' + visit.id + '" class="btn btn-xs btn-primary" title="View Details">' +
                                '<i class="fa fa-eye"></i>' +
                            '</a>' +
                        '</td>' +
                    '</tr>';
                    tbody.append(row);
                });
            } else {
                tbody.append('<tr><td colspan="8" class="text-center">No recent visits found</td></tr>');
            }
        }
    });
}

function getPaymentStatusBadge(status) {
    switch(status) {
        case 'paid':
            return '<span class="label label-success">Paid</span>';
        case 'partial':
            return '<span class="label label-warning">Partial</span>';
        case 'pending':
            return '<span class="label label-danger">Pending</span>';
        default:
            return '<span class="label label-default">Unknown</span>';
    }
}
</script>