<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Triage Record - <?php echo $record['patient_name']; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/3.4.1/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 15px; }
        }
        
        .header-section {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .priority-badge {
            padding: 6px 12px;
            border-radius: 4px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .priority-urgent { background-color: #d9534f; color: white; }
        .priority-high { background-color: #f0ad4e; color: white; }
        .priority-normal { background-color: #5cb85c; color: white; }
        .priority-low { background-color: #5bc0de; color: white; }
        
        .vital-table td {
            padding: 8px;
            border: 1px solid #ddd;
        }
        
        .vital-label {
            font-weight: bold;
            background-color: #f5f5f5;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <div class="header-section">
            <h2>Hospital Management System</h2>
            <h3>Triage Assessment Record</h3>
            <p><strong>Record ID:</strong> <?php echo str_pad($record['id'], 6, '0', STR_PAD_LEFT); ?> | 
               <strong>Date:</strong> <?php echo date('F j, Y g:i A', strtotime($record['created_at'])); ?></p>
        </div>

        <!-- Patient Information -->
        <div class="row">
            <div class="col-md-6">
                <h4>Patient Information</h4>
                <table class="table table-bordered table-condensed">
                    <tr>
                        <td class="vital-label" width="35%">Patient Name:</td>
                        <td><?php echo $record['patient_name']; ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Patient ID:</td>
                        <td><?php echo $record['patient_id']; ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Age:</td>
                        <td><?php echo $record['age'] ? $record['age'] . ' years' : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Gender:</td>
                        <td><?php echo $record['gender'] ?: 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Contact:</td>
                        <td><?php echo $record['mobileno'] ?: 'N/A'; ?></td>
                    </tr>
                </table>
            </div>
            
            <div class="col-md-6">
                <h4>Triage Assessment</h4>
                <table class="table table-bordered table-condensed">
                    <tr>
                        <td class="vital-label" width="35%">Priority Level:</td>
                        <td>
                            <span class="priority-badge priority-<?php echo $record['priority']; ?>">
                                <?php echo strtoupper($record['priority']); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td class="vital-label">Status:</td>
                        <td><?php echo strtoupper(str_replace('_', ' ', $record['status'])); ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Department:</td>
                        <td><?php echo $record['department'] ?: 'Not Assigned'; ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Triaged By:</td>
                        <td><?php echo $record['staff_name']; ?></td>
                    </tr>
                    <tr>
                        <td class="vital-label">Verification:</td>
                        <td><?php echo ucfirst($record['verification_status'] ?: 'N/A'); ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Vital Signs -->
        <div class="row" style="margin-top: 30px;">
            <div class="col-md-12">
                <h4>Vital Signs Assessment</h4>
                <?php if (!empty($record['vitals'])): ?>
                    <?php $vitals = $record['vitals']; ?>
                    <table class="table table-bordered vital-table">
                        <tbody>
                            <tr>
                                <td class="vital-label" width="20%">Temperature</td>
                                <td width="20%">
                                    <?php if (isset($vitals['temperature'])): ?>
                                        <?php 
                                        $temp_status = '';
                                        if ($vitals['temperature'] > 38) $temp_status = ' (HIGH)';
                                        elseif ($vitals['temperature'] < 36) $temp_status = ' (LOW)';
                                        else $temp_status = ' (Normal)';
                                        ?>
                                        <strong><?php echo $vitals['temperature']; ?>°C</strong><?php echo $temp_status; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td class="vital-label" width="20%">Blood Pressure</td>
                                <td width="20%">
                                    <?php if (isset($vitals['blood_pressure'])): ?>
                                        <?php 
                                        $bp = $vitals['blood_pressure'];
                                        $bp_status = '';
                                        if ($bp['systolic'] > 140 || $bp['diastolic'] > 90) $bp_status = ' (HIGH)';
                                        elseif ($bp['systolic'] < 90 || $bp['diastolic'] < 60) $bp_status = ' (LOW)';
                                        else $bp_status = ' (Normal)';
                                        ?>
                                        <strong><?php echo $bp['systolic']; ?>/<?php echo $bp['diastolic']; ?> mmHg</strong><?php echo $bp_status; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td class="vital-label" width="20%">BMI</td>
                                <td>
                                    <?php if (isset($vitals['bmi'])): ?>
                                        <?php 
                                        $bmi_status = '';
                                        if ($vitals['bmi'] < 18.5) $bmi_status = ' (Underweight)';
                                        elseif ($vitals['bmi'] < 25) $bmi_status = ' (Normal)';
                                        elseif ($vitals['bmi'] < 30) $bmi_status = ' (Overweight)';
                                        else $bmi_status = ' (Obese)';
                                        ?>
                                        <strong><?php echo $vitals['bmi']; ?></strong><?php echo $bmi_status; ?>
                                    <?php else: ?>
                                        <em>Not calculated</em>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="vital-label">Heart Rate</td>
                                <td>
                                    <?php if (isset($vitals['heart_rate']) || isset($vitals['pulse_rate'])): ?>
                                        <?php 
                                        $hr = $vitals['heart_rate'] ?? $vitals['pulse_rate'];
                                        $hr_status = '';
                                        if ($hr > 100) $hr_status = ' (HIGH)';
                                        elseif ($hr < 60) $hr_status = ' (LOW)';
                                        else $hr_status = ' (Normal)';
                                        ?>
                                        <strong><?php echo $hr; ?> bpm</strong><?php echo $hr_status; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td class="vital-label">Respiratory Rate</td>
                                <td>
                                    <?php if (isset($vitals['respiratory_rate'])): ?>
                                        <?php 
                                        $rr_status = '';
                                        if ($vitals['respiratory_rate'] > 20) $rr_status = ' (HIGH)';
                                        elseif ($vitals['respiratory_rate'] < 12) $rr_status = ' (LOW)';
                                        else $rr_status = ' (Normal)';
                                        ?>
                                        <strong><?php echo $vitals['respiratory_rate']; ?> /min</strong><?php echo $rr_status; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td class="vital-label">Blood Glucose</td>
                                <td>
                                    <?php if (isset($vitals['blood_glucose'])): ?>
                                        <?php 
                                        $bg_status = '';
                                        if ($vitals['blood_glucose'] > 180) $bg_status = ' (HIGH)';
                                        elseif ($vitals['blood_glucose'] < 70) $bg_status = ' (LOW)';
                                        else $bg_status = ' (Normal)';
                                        ?>
                                        <strong><?php echo $vitals['blood_glucose']; ?> mg/dL</strong><?php echo $bg_status; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="vital-label">Oxygen Saturation</td>
                                <td>
                                    <?php if (isset($vitals['oxygen_saturation'])): ?>
                                        <?php 
                                        $o2_status = $vitals['oxygen_saturation'] < 95 ? ' (LOW)' : ' (Normal)';
                                        ?>
                                        <strong><?php echo $vitals['oxygen_saturation']; ?>%</strong><?php echo $o2_status; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td class="vital-label">Pain Scale</td>
                                <td>
                                    <?php if (isset($vitals['pain_scale'])): ?>
                                        <?php 
                                        $pain_level = '';
                                        if ($vitals['pain_scale'] == 0) $pain_level = ' (No Pain)';
                                        elseif ($vitals['pain_scale'] <= 3) $pain_level = ' (Mild)';
                                        elseif ($vitals['pain_scale'] <= 6) $pain_level = ' (Moderate)';
                                        elseif ($vitals['pain_scale'] <= 8) $pain_level = ' (Severe)';
                                        else $pain_level = ' (Worst)';
                                        ?>
                                        <strong><?php echo $vitals['pain_scale']; ?>/10</strong><?php echo $pain_level; ?>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td class="vital-label">Weight</td>
                                <td>
                                    <?php if (isset($vitals['weight'])): ?>
                                        <strong><?php echo $vitals['weight']; ?> kg</strong>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="vital-label">Height</td>
                                <td>
                                    <?php if (isset($vitals['height'])): ?>
                                        <strong><?php echo $vitals['height']; ?> cm</strong>
                                    <?php else: ?>
                                        <em>Not recorded</em>
                                    <?php endif; ?>
                                </td>
                                <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning">
                        <strong>Notice:</strong> No vital signs data recorded for this triage assessment.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Clinical Notes -->
        <?php if (!empty($record['notes'])): ?>
        <div class="row" style="margin-top: 30px;">
            <div class="col-md-12">
                <h4>Clinical Notes & Observations</h4>
                <div style="border: 1px solid #ddd; padding: 15px; background-color: #f9f9f9;">
                    <?php echo nl2br(htmlspecialchars($record['notes'])); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Normal Ranges Reference -->
        <div class="row" style="margin-top: 30px;">
            <div class="col-md-12">
                <h4>Normal Ranges Reference</h4>
                <table class="table table-striped table-condensed table-bordered">
                    <thead>
                        <tr>
                            <th>Parameter</th>
                            <th>Normal Range</th>
                            <th>Patient Value</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Temperature</td>
                            <td>36.1 - 37.2°C</td>
                            <td>
                                <?php 
                                if (isset($vitals['temperature'])) {
                                    echo $vitals['temperature'] . '°C';
                                } else {
                                    echo 'Not recorded';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                if (isset($vitals['temperature'])) {
                                    if ($vitals['temperature'] > 37.2) echo '<strong>HIGH</strong>';
                                    elseif ($vitals['temperature'] < 36.1) echo '<strong>LOW</strong>';
                                    else echo 'Normal';
                                } else {
                                    echo '-';
                                }
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Blood Pressure</td>
                            <td>&lt;120/80 mmHg</td>
                            <td>
                                <?php 
                                if (isset($vitals['blood_pressure'])) {
                                    echo $vitals['blood_pressure']['systolic'] . '/' . $vitals['blood_pressure']['diastolic'] . ' mmHg';
                                } else {
                                    echo 'Not recorded';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                if (isset($vitals['blood_pressure'])) {
                                    $bp = $vitals['blood_pressure'];
                                    if ($bp['systolic'] > 140 || $bp['diastolic'] > 90) echo '<strong>HIGH</strong>';
                                    elseif ($bp['systolic'] < 90 || $bp['diastolic'] < 60) echo '<strong>LOW</strong>';
                                    else echo 'Normal';
                                } else {
                                    echo '-';
                                }
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Heart Rate</td>
                            <td>60 - 100 bpm</td>
                            <td>
                                <?php 
                                $hr = $vitals['heart_rate'] ?? $vitals['pulse_rate'] ?? null;
                                if ($hr) {
                                    echo $hr . ' bpm';
                                } else {
                                    echo 'Not recorded';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                if ($hr) {
                                    if ($hr > 100) echo '<strong>HIGH</strong>';
                                    elseif ($hr < 60) echo '<strong>LOW</strong>';
                                    else echo 'Normal';
                                } else {
                                    echo '-';
                                }
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Oxygen Saturation</td>
                            <td>&gt;95%</td>
                            <td>
                                <?php 
                                if (isset($vitals['oxygen_saturation'])) {
                                    echo $vitals['oxygen_saturation'] . '%';
                                } else {
                                    echo 'Not recorded';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                if (isset($vitals['oxygen_saturation'])) {
                                    if ($vitals['oxygen_saturation'] < 95) echo '<strong>LOW</strong>';
                                    else echo 'Normal';
                                } else {
                                    echo '-';
                                }
                                ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Footer -->
        <div class="row" style="margin-top: 40px; border-top: 1px solid #ddd; padding-top: 15px;">
            <div class="col-md-6">
                <p><strong>Generated:</strong> <?php echo date('F j, Y g:i A'); ?></p>
                <p><strong>System:</strong> Hospital Management System - Triage Module</p>
            </div>
            <div class="col-md-6 text-right">
                <p><strong>Authorized by:</strong> <?php echo $record['staff_name']; ?></p>
                <p><strong>Digital Record ID:</strong> TR-<?php echo str_pad($record['id'], 6, '0', STR_PAD_LEFT); ?></p>
            </div>
        </div>

        <!-- Print Button (hidden when printing) -->
        <div class="row no-print" style="margin-top: 20px;">
            <div class="col-md-12 text-center">
                <button type="button" class="btn btn-primary btn-lg" onclick="window.print();">
                    <i class="fa fa-print"></i> Print This Record
                </button>
                <button type="button" class="btn btn-default btn-lg" onclick="window.close();" style="margin-left: 10px;">
                    <i class="fa fa-times"></i> Close
                </button>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    
    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() { window.print(); }
        
        // Print function
        function printRecord() {
            window.print();
        }
        
        // Keyboard shortcut for printing
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.keyCode === 80) { // Ctrl+P
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html>