<!-- View Service Modal Content - save as: views/admin/specialized_services/view_service_modal.php -->
<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <tr>
                        <th width="25%">Service Name:</th>
                        <td>
                            <i class="fa <?php echo $this->getCategoryIcon($service->category_type); ?>" 
                               style="color: <?php echo $this->getCategoryColor($service->category_type); ?>;"></i>
                            <?php echo $service->service_name; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Service Code:</th>
                        <td><?php echo $service->service_code ?: 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>Category:</th>
                        <td>
                            <span class="badge" style="background-color: <?php echo $this->getCategoryColor($service->category_type); ?>;">
                                <?php echo $service->category_name; ?>
                            </span>
                            <small class="text-muted">(<?php echo ucfirst($service->category_type); ?>)</small>
                        </td>
                    </tr>
                    <tr>
                        <th>Service Type:</th>
                        <td>
                            <span class="label label-info"><?php echo ucfirst($service->service_type); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>Pricing:</th>
                        <td>
                            <strong>Cash Price:</strong> <?php echo $currency_symbol; ?> <?php echo number_format($service->cash_price, 2); ?><br>
                            <?php if ($service->insurance_price && $service->insurance_price != $service->cash_price): ?>
                                <strong>Insurance Price:</strong> <?php echo $currency_symbol; ?> <?php echo number_format($service->insurance_price, 2); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Duration:</th>
                        <td><?php echo $service->duration_minutes ? $service->duration_minutes . ' minutes' : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>Specialist Required:</th>
                        <td>
                            <?php if ($service->requires_specialist == 1): ?>
                                <span class="badge badge-warning" style="background-color: #f39c12; color: white;">
                                    <i class="fa fa-user-md"></i> Yes - Specialist Required
                                </span>
                                <br><small class="text-muted">This service requires a certified specialist</small>
                            <?php else: ?>
                                <span class="badge badge-secondary" style="background-color: #95a5a6; color: white;">
                                    <i class="fa fa-user"></i> No - General Staff Can Perform
                                </span>
                                <br><small class="text-muted">General staff can perform this service</small>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Equipment Required:</th>
                        <td>
                            <?php if ($service->requires_equipment == 1): ?>
                                <span class="badge badge-info" style="background-color: #17a2b8; color: white;">
                                    <i class="fa fa-cogs"></i> Yes
                                </span>
                                <?php if ($service->equipment_list): ?>
                                    <br><small class="text-muted"><strong>Equipment:</strong> <?php echo nl2br(htmlspecialchars($service->equipment_list)); ?></small>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge badge-secondary" style="background-color: #6c757d; color: white;">
                                    <i class="fa fa-times"></i> No Special Equipment
                                </span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Risk Level:</th>
                        <td>
                            <?php 
                            $risk_colors = array(
                                'low' => '#28a745',
                                'medium' => '#ffc107', 
                                'high' => '#dc3545'
                            );
                            $risk_color = isset($risk_colors[$service->complications_risk_level]) ? $risk_colors[$service->complications_risk_level] : '#6c757d';
                            ?>
                            <span class="badge" style="background-color: <?php echo $risk_color; ?>; color: white;">
                                <?php echo ucfirst($service->complications_risk_level); ?> Risk
                            </span>
                        </td>
                    </tr>
                    <?php if ($service->age_restrictions): ?>
                    <tr>
                        <th>Age Restrictions:</th>
                        <td><?php echo htmlspecialchars($service->age_restrictions); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($service->billing_code): ?>
                    <tr>
                        <th>Billing Code:</th>
                        <td><code><?php echo htmlspecialchars($service->billing_code); ?></code></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($service->description): ?>
                    <tr>
                        <th>Description:</th>
                        <td><?php echo nl2br(htmlspecialchars($service->description)); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($service->pre_procedure_requirements): ?>
                    <tr>
                        <th>Pre-Procedure Requirements:</th>
                        <td>
                            <div class="alert alert-info" style="margin-bottom: 0;">
                                <i class="fa fa-info-circle"></i>
                                <?php echo nl2br(htmlspecialchars($service->pre_procedure_requirements)); ?>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($service->post_procedure_instructions): ?>
                    <tr>
                        <th>Post-Procedure Instructions:</th>
                        <td>
                            <div class="alert alert-success" style="margin-bottom: 0;">
                                <i class="fa fa-check-circle"></i>
                                <?php echo nl2br(htmlspecialchars($service->post_procedure_instructions)); ?>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($service->contraindications): ?>
                    <tr>
                        <th>Contraindications:</th>
                        <td>
                            <div class="alert alert-warning" style="margin-bottom: 0;">
                                <i class="fa fa-exclamation-triangle"></i>
                                <?php echo nl2br(htmlspecialchars($service->contraindications)); ?>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <?php if ($service->is_active == 1): ?>
                                <span class="badge badge-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Inactive</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Created:</th>
                        <td><?php echo date('d M Y, h:i A', strtotime($service->created_at)); ?></td>
                    </tr>
                    <?php if ($service->updated_at): ?>
                    <tr>
                        <th>Last Updated:</th>
                        <td><?php echo date('d M Y, h:i A', strtotime($service->updated_at)); ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    <?php if ($this->rbac->hasPrivilege('specialized_services', 'can_edit')): ?>
        <button type="button" class="btn btn-primary" onclick="editService(<?php echo $service->id; ?>)">
            <i class="fa fa-edit"></i> Edit Service
        </button>
        
        <!-- Specialist Toggle Button -->
        <?php if ($service->requires_specialist == 1): ?>
            <button type="button" class="btn btn-warning" onclick="toggleSpecialist(<?php echo $service->id; ?>, 1)">
                <i class="fa fa-user"></i> Remove Specialist Requirement
            </button>
        <?php else: ?>
            <button type="button" class="btn btn-info" onclick="toggleSpecialist(<?php echo $service->id; ?>, 0)">
                <i class="fa fa-user-md"></i> Require Specialist
            </button>
        <?php endif; ?>
    <?php endif; ?>
</div>