<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-stethoscope"></i>
        </div>
        <div class="header-title">
            <h1><?php echo $title; ?></h1>
            <small>Overview of dental, optical and specialized medical services</small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Statistics Row -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo $stats['total_services'] ?? 0; ?></h3>
                        <p>Total Services</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-stethoscope"></i>
                    </div>
                    <a href="<?php echo base_url('admin/specialized_services/services'); ?>" class="small-box-footer">
                        Manage Services <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $stats['dental_services'] ?? 0; ?></h3>
                        <p>Dental Services</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-tooth"></i>
                    </div>
                    <a href="<?php echo base_url('admin/specialized_services/services?type=dental'); ?>" class="small-box-footer">
                        View Dental <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $stats['optical_services'] ?? 0; ?></h3>
                        <p>Optical Services</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-eye"></i>
                    </div>
                    <a href="<?php echo base_url('admin/specialized_services/services?type=optical'); ?>" class="small-box-footer">
                        View Optical <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $stats['specialist_services'] ?? 0; ?></h3>
                        <p>Specialist Required</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user-md"></i>
                    </div>
                    <a href="<?php echo base_url('admin/specialized_services/services?specialist=1'); ?>" class="small-box-footer">
                        View Specialist <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Services by Category Chart -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-pie-chart"></i> Services by Category
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshStats()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div id="services-by-category-chart">
                            <?php if (!empty($stats['services_by_category'])): ?>
                                <div class="row">
                                    <?php foreach ($stats['services_by_category'] as $category): ?>
                                        <?php if ($category['service_count'] > 0): ?>
                                            <div class="col-md-6" style="margin-bottom: 15px;">
                                                <div class="info-box">
                                                    <span class="info-box-icon" style="background-color: <?php echo getCategoryColor($category['category_type']); ?>;">
                                                        <i class="fa <?php echo getCategoryIcon($category['category_type']); ?>"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text"><?php echo $category['category_name']; ?></span>
                                                        <span class="info-box-number"><?php echo $category['service_count']; ?></span>
                                                        <div class="progress">
                                                            <div class="progress-bar" style="width: <?php echo ($stats['total_services'] > 0) ? round(($category['service_count'] / $stats['total_services']) * 100) : 0; ?>%; background-color: <?php echo getCategoryColor($category['category_type']); ?>;"></div>
                                                        </div>
                                                        <span class="progress-description">
                                                            <?php echo ($stats['total_services'] > 0) ? round(($category['service_count'] / $stats['total_services']) * 100) : 0; ?>% of total
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            <?php else: ?>
                                <p class="text-center text-muted">No services found. <a href="<?php echo base_url('admin/specialized_services/setup_system'); ?>">Setup system</a></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pricing Overview -->
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-money"></i> Pricing Overview
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <tr>
                                    <th>Average Cash Price:</th>
                                    <td class="text-right">
                                        <strong><?php echo $currency_symbol; ?> <?php echo number_format($stats['avg_cash_price'] ?? 0, 2); ?></strong>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Average Insurance Price:</th>
                                    <td class="text-right">
                                        <strong><?php echo $currency_symbol; ?> <?php echo number_format($stats['avg_insurance_price'] ?? 0, 2); ?></strong>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <?php if (!empty($stats['high_value_services'])): ?>
                            <h5><i class="fa fa-star"></i> High-Value Services</h5>
                            <div style="max-height: 200px; overflow-y: auto;">
                                <?php foreach ($stats['high_value_services'] as $service): ?>
                                    <div class="progress-group">
                                        <span class="progress-text"><?php echo htmlspecialchars($service['service_name']); ?></span>
                                        <span class="float-right"><b><?php echo $currency_symbol; ?> <?php echo number_format($service['cash_price'], 2); ?></b></span>
                                        <div class="progress progress-sm">
                                            <div class="progress-bar bg-primary" style="width: <?php echo ($stats['avg_cash_price'] > 0) ? min(($service['cash_price'] / ($stats['avg_cash_price'] * 2)) * 100, 100) : 0; ?>%"></div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-flash"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/specialized_services/services'); ?>" class="btn btn-app">
                                    <i class="fa fa-plus"></i> Add Service
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/specialized_services/categories'); ?>" class="btn btn-app">
                                    <i class="fa fa-folder"></i> Manage Categories
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/specialized_services/services?type=dental'); ?>" class="btn btn-app">
                                    <i class="fa fa-tooth"></i> Dental Services
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/specialized_services/services?type=optical'); ?>" class="btn btn-app">
                                    <i class="fa fa-eye"></i> Optical Services
                                </a>
                            </div>
                        </div>
                        
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/specialized_services/debug_database'); ?>" class="btn btn-app">
                                    <i class="fa fa-cog"></i> System Debug
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/specialized_services/setup_system'); ?>" class="btn btn-app">
                                    <i class="fa fa-refresh"></i> Refresh Data
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="#" onclick="exportServices()" class="btn btn-app">
                                    <i class="fa fa-download"></i> Export
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="#" onclick="showServiceStats()" class="btn btn-app">
                                    <i class="fa fa-bar-chart"></i> View Stats
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity (if you have booking/usage data) -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-clock-o"></i> System Information
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> <?php echo $stats['total_categories'] ?? 0; ?></span>
                                    <h5 class="description-header">Categories</h5>
                                    <span class="description-text">Active service categories</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-yellow"><i class="fa fa-user-md"></i> <?php echo $stats['specialist_services'] ?? 0; ?></span>
                                    <h5 class="description-header">Specialist</h5>
                                    <span class="description-text">Services requiring specialists</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="description-block">
                                    <span class="description-percentage text-red"><i class="fa fa-cogs"></i> Equipment</span>
                                    <h5 class="description-header">Advanced</h5>
                                    <span class="description-text">Services with equipment needs</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php
// Helper functions for the dashboard
function getCategoryIcon($category_type) {
    $icons = array(
        'dental' => 'fa-tooth',
        'optical' => 'fa-eye',
        'physiotherapy' => 'fa-heartbeat',
        'orthopedic' => 'fa-wheelchair',
        'cardiology' => 'fa-heart',
        'neurology' => 'fa-brain',
        'other' => 'fa-stethoscope'
    );
    return isset($icons[$category_type]) ? $icons[$category_type] : 'fa-stethoscope';
}

function getCategoryColor($category_type) {
    $colors = array(
        'dental' => '#2E86AB',
        'optical' => '#1B998B',
        'physiotherapy' => '#FF6B35',
        'orthopedic' => '#A23B72',
        'cardiology' => '#F18F01',
        'neurology' => '#C73E1D',
        'other' => '#6C757D'
    );
    return isset($colors[$category_type]) ? $colors[$category_type] : '#6C757D';
}
?>

<script>
$(document).ready(function() {
    console.log('Specialized Services Dashboard loaded');
});

function refreshStats() {
    location.reload();
}

function exportServices() {
    window.open(base_url + 'admin/specialized_services/export_services', '_blank');
}

function showServiceStats() {
    Swal.fire({
        title: 'Service Statistics',
        html: `
            <div class="text-left">
                <h4>📊 Current Statistics:</h4>
                <ul>
                    <li><strong>Total Services:</strong> <?php echo $stats['total_services'] ?? 0; ?></li>
                    <li><strong>Total Categories:</strong> <?php echo $stats['total_categories'] ?? 0; ?></li>
                    <li><strong>Dental Services:</strong> <?php echo $stats['dental_services'] ?? 0; ?></li>
                    <li><strong>Optical Services:</strong> <?php echo $stats['optical_services'] ?? 0; ?></li>
                    <li><strong>Specialist Required:</strong> <?php echo $stats['specialist_services'] ?? 0; ?></li>
                </ul>
                
                <h4>💰 Pricing Information:</h4>
                <ul>
                    <li><strong>Average Cash Price:</strong> <?php echo $currency_symbol; ?> <?php echo number_format($stats['avg_cash_price'] ?? 0, 2); ?></li>
                    <li><strong>Average Insurance Price:</strong> <?php echo $currency_symbol; ?> <?php echo number_format($stats['avg_insurance_price'] ?? 0, 2); ?></li>
                </ul>
            </div>
        `,
        width: 600,
        confirmButtonText: 'Close',
        confirmButtonColor: '#28a745'
    });
}

// Auto-refresh stats every 5 minutes
setInterval(function() {
    console.log('Auto-refreshing dashboard stats...');
    // You can implement AJAX refresh here if needed
}, 300000);
</script>