<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-folder"></i>
        </div>
        <div class="header-title">
            <h1><?php echo $title; ?></h1>
            <small>Manage service categories for dental, optical and other specialized services</small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> Service Categories
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if (method_exists($this->rbac, 'hasPrivilege') && $this->rbac->hasPrivilege('specialized_services', 'can_add')): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addCategoryModal">
                                    <i class="fa fa-plus"></i> Add Category
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="categoriesTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Category Name</th>
                                        <th>Type</th>
                                        <th>Services Count</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($categories)): ?>
                                        <?php foreach ($categories as $category): ?>
                                            <tr>
                                                <td>
                                                    <i class="fa <?php echo getCategoryIcon($category['category_type']); ?>" 
                                                       style="color: <?php echo getCategoryColor($category['category_type']); ?>; margin-right: 8px;"></i>
                                                    <?php echo htmlspecialchars($category['category_name']); ?>
                                                </td>
                                                <td>
                                                    <span class="badge" style="background-color: <?php echo getCategoryColor($category['category_type']); ?>;">
                                                        <?php echo ucfirst($category['category_type']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-info">
                                                        <?php echo $this->db->where('category_id', $category['id'])->count_all_results('specialized_services'); ?> services
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($category['description'] ?: 'No description'); ?></td>
                                                <td>
                                                    <?php if ($category['is_active'] == 1): ?>
                                                        <span class="badge badge-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-danger">Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-right">
                                                    <?php if (method_exists($this->rbac, 'hasPrivilege') && $this->rbac->hasPrivilege('specialized_services', 'can_view')): ?>
                                                        <button type="button" class="btn btn-xs btn-info" onclick="viewCategory(<?php echo $category['id']; ?>)" title="View">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                    
                                                    <?php if (method_exists($this->rbac, 'hasPrivilege') && $this->rbac->hasPrivilege('specialized_services', 'can_edit')): ?>
                                                        <button type="button" class="btn btn-xs btn-primary" onclick="editCategory(<?php echo $category['id']; ?>)" title="Edit">
                                                            <i class="fa fa-edit"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                    
                                                    <?php if (method_exists($this->rbac, 'hasPrivilege') && $this->rbac->hasPrivilege('specialized_services', 'can_delete')): ?>
                                                        <button type="button" class="btn btn-xs btn-danger" onclick="deleteCategory(<?php echo $category['id']; ?>)" title="Delete">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                No categories found. <a href="#" onclick="$('#addCategoryModal').modal('show');">Add your first category</a>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> Add Service Category
                </h4>
            </div>
            <form id="addCategoryForm" method="post" role="form">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="category_name">Category Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="category_name" name="category_name" placeholder="Enter category name" required>
                        <span class="text-danger" id="category_name_error"></span>
                    </div>

                    <div class="form-group">
                        <label for="category_type">Category Type <span class="text-danger">*</span></label>
                        <select class="form-control" id="category_type" name="category_type" required>
                            <option value="">Select Type</option>
                            <option value="dental">🦷 Dental</option>
                            <option value="optical">👁️ Optical</option>
                            <option value="physiotherapy">💪 Physiotherapy</option>
                            <option value="orthopedic">🦴 Orthopedic</option>
                            <option value="cardiology">❤️ Cardiology</option>
                            <option value="neurology">🧠 Neurology</option>
                            <option value="other">🏥 Other</option>
                        </select>
                        <span class="text-danger" id="category_type_error"></span>
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" placeholder="Category description"></textarea>
                        <span class="text-danger" id="description_error"></span>
                    </div>

                    <div class="form-group">
                        <label for="icon_class">Icon Class (Font Awesome)</label>
                        <input type="text" class="form-control" id="icon_class" name="icon_class" placeholder="e.g., fa-tooth, fa-eye">
                        <small class="text-muted">Visit <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">Font Awesome</a> for icon names</small>
                    </div>

                    <div class="form-group">
                        <label for="color_code">Color Code</label>
                        <input type="color" class="form-control" id="color_code" name="color_code" value="#007bff">
                        <small class="text-muted">Choose a color for this category</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Category
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Category Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Edit Service Category
                </h4>
            </div>
            <div id="editCategoryModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- View Category Modal -->
<div class="modal fade" id="viewCategoryModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> Category Details
                </h4>
            </div>
            <div id="viewCategoryModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<?php
// Helper functions for the categories page
function getCategoryIcon($category_type) {
    $icons = array(
        'dental' => 'fa-tooth',
        'optical' => 'fa-eye',
        'physiotherapy' => 'fa-heartbeat',
        'orthopedic' => 'fa-wheelchair',
        'cardiology' => 'fa-heart',
        'neurology' => 'fa-brain',
        'other' => 'fa-stethoscope'
    );
    return isset($icons[$category_type]) ? $icons[$category_type] : 'fa-stethoscope';
}

function getCategoryColor($category_type) {
    $colors = array(
        'dental' => '#2E86AB',
        'optical' => '#1B998B',
        'physiotherapy' => '#FF6B35',
        'orthopedic' => '#A23B72',
        'cardiology' => '#F18F01',
        'neurology' => '#C73E1D',
        'other' => '#6C757D'
    );
    return isset($colors[$category_type]) ? $colors[$category_type] : '#6C757D';
}
?>

<!-- Include SweetAlert2 -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.all.min.js"></script>

<script>
$(document).ready(function() {
    console.log('Specialized Services Categories page loaded');
    
    // Initialize DataTable
    $('#categoriesTable').DataTable({
        responsive: true,
        pageLength: 25,
        order: [[1, 'asc'], [0, 'asc']], // Sort by type, then name
        language: {
            emptyTable: 'No categories found. <a href="#" onclick="$(\'#addCategoryModal\').modal(\'show\');">Add your first category</a>'
        }
    });
    
    // Update icon preview when category type changes
    $('#category_type').change(function() {
        var type = $(this).val();
        var icons = {
            'dental': 'fa-tooth',
            'optical': 'fa-eye',
            'physiotherapy': 'fa-heartbeat',
            'orthopedic': 'fa-wheelchair',
            'cardiology': 'fa-heart',
            'neurology': 'fa-brain',
            'other': 'fa-stethoscope'
        };
        
        var colors = {
            'dental': '#2E86AB',
            'optical': '#1B998B',
            'physiotherapy': '#FF6B35',
            'orthopedic': '#A23B72',
            'cardiology': '#F18F01',
            'neurology': '#C73E1D',
            'other': '#6C757D'
        };
        
        if (icons[type]) {
            $('#icon_class').val(icons[type]);
            $('#color_code').val(colors[type]);
        }
    });
});

// Enhanced form submission with SweetAlert2
$('#addCategoryForm').on('submit', function(e) {
    e.preventDefault();
    
    console.log('Category form submission started');
    
    var $form = $(this);
    var $submitBtn = $form.find('button[type="submit"]');
    var formData = $form.serialize();
    
    // Show loading state
    $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
    
    // Clear previous errors
    $('.text-danger').text('');
    
    // Show loading SweetAlert
    Swal.fire({
        title: 'Saving Category...',
        html: 'Please wait while we save your service category.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/add_category',
        type: 'POST',
        data: formData,
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('Add category response:', response);
            
            if (response.status === 'success') {
                $('#addCategoryModal').modal('hide');
                $form[0].reset();
                
                // Reload the page to show new category
                location.reload();
            } else {
                // Handle validation errors
                if (response.error && typeof response.error === 'object') {
                    let errorList = '<ul class="text-left">';
                    $.each(response.error, function(field, error) {
                        $('#' + field + '_error').text(error);
                        errorList += '<li>' + error + '</li>';
                    });
                    errorList += '</ul>';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Errors',
                        html: errorList,
                        confirmButtonColor: '#dc3545'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error Adding Category',
                        html: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            }
        },
        error: function(xhr, status, error) {
            console.error('Add category AJAX error:', xhr.responseText);
            
            let errorMessage = 'An unexpected error occurred while saving the category.';
            
            if (xhr.status === 404) {
                errorMessage = 'The server endpoint was not found. Please check your configuration.';
            } else if (xhr.status === 500) {
                errorMessage = 'A server error occurred. Please contact your administrator.';
            } else if (xhr.status === 0) {
                errorMessage = 'Network connection error. Please check your internet connection.';
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Connection Error',
                html: errorMessage,
                confirmButtonColor: '#dc3545',
                footer: '<small>Check the browser console for more details</small>'
            });
        },
        complete: function() {
            // Reset button state
            $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Category');
        }
    });
    
    return false;
});

// Function to view a category
function viewCategory(id) {
    console.log('Viewing category ID:', id);
    
    Swal.fire({
        title: 'Loading Category Details...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/view_category/' + id,
        type: 'GET',
        timeout: 10000,
        success: function(response) {
            Swal.close();
            $('#viewCategoryModalContent').html(response);
            $('#viewCategoryModal').modal('show');
        },
        error: function(xhr, status, error) {
            console.error('View category error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Failed to Load Category Details',
                html: 'Unable to retrieve category information. Please try again.',
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Function to edit a category
function editCategory(id) {
    console.log('Editing category ID:', id);
    
    Swal.fire({
        title: 'Loading Category for Editing...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/edit_category/' + id,
        type: 'GET',
        timeout: 10000,
        success: function(response) {
            Swal.close();
            $('#editCategoryModalContent').html(response);
            $('#editCategoryModal').modal('show');
        },
        error: function(xhr, status, error) {
            console.error('Edit category error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Failed to Load Category for Editing',
                html: 'Unable to retrieve category information for editing. Please try again.',
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Function to delete a category
function deleteCategory(id) {
    console.log('Deleting category ID:', id);
    
    Swal.fire({
        title: 'Delete Service Category?',
        html: `
            <p>Are you sure you want to delete this service category?</p>
            <div class="alert alert-warning mt-3">
                <i class="fa fa-exclamation-triangle"></i>
                <strong>Warning:</strong> This will also affect all services in this category!
            </div>
        `,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="fa fa-trash"></i> Yes, Delete It!',
        cancelButtonText: '<i class="fa fa-times"></i> Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Deleting Category...',
                html: 'Please wait while we delete the service category.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            $.ajax({
                url: base_url + 'admin/specialized_services/delete_category/' + id,
                type: 'POST',
                dataType: 'json',
                timeout: 10000,
                success: function(response) {
                    if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Category Deleted!',
                            html: response.message,
                            confirmButtonColor: '#28a745',
                            timer: 3000,
                            timerProgressBar: true
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Delete Failed',
                            html: response.message,
                            confirmButtonColor: '#dc3545'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Delete category error:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Delete Failed',
                        html: 'An error occurred while deleting the category. Please try again.',
                        confirmButtonColor: '#dc3545'
                    });
                }
            });
        }
    });
}

console.log('Specialized Services Categories JavaScript loaded successfully');
</script>