<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
$genderList = $this->customlib->getGender();
$genderList_Patient = $this->customlib->getGender_Patient();
$marital_status = $this->config->item('marital_status');

// ENHANCED workflow types with step tracking and restrictions
$workflows = [
    'gcc' => [
        'name' => 'GCC Workflow',
        'description' => 'Registration → Mandatory Triage → Lab → Radiology → Consultation → Complete',
        'mandatory_steps' => ['triage', 'lab', 'radiology', 'consultation'],
        'optional_steps' => [],
        'sequence' => ['registration', 'triage', 'lab', 'radiology', 'consultation'],
        'requires_triage' => true,
        'excludes_icd_diagnosis' => true,
        'base_cost' => 10500.00,
        'step_restrictions' => [
            'lab' => ['triage'],
            'radiology' => ['triage'],
            'consultation' => ['triage', 'lab', 'radiology']
        ]
    ],
    'general' => [
        'name' => 'General Workflow', 
        'description' => 'Registration → (Optional services) → Flexible routing',
        'mandatory_steps' => [],
        'optional_steps' => ['triage', 'lab', 'radiology', 'consultation', 'pharmacy'],
        'sequence' => ['registration'],
        'requires_triage' => false,
        'excludes_icd_diagnosis' => false,
        'base_cost' => 900.00,
        'step_restrictions' => []
    ],
    'specialized' => [
        'name' => 'Specialized Workflow',
        'description' => 'Registration → Mandatory Triage → Mandatory Consultation → (Optional services)',
        'mandatory_steps' => ['triage', 'consultation'],
        'optional_steps' => ['lab', 'radiology', 'pharmacy'],
        'sequence' => ['registration', 'triage', 'consultation'],
        'requires_triage' => true,
        'excludes_icd_diagnosis' => false,
        'base_cost' => 1900.00,
        'step_restrictions' => [
            'consultation' => ['triage'],
            'lab' => ['triage'],
            'radiology' => ['triage']
        ]
    ]
];
?>

<!-- Include Required CSS and JS Libraries -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

<!-- Include SecuGen WebAPI scripts -->
<script src="<?php echo base_url('WebAPI-JavaScript/secugen.js'); ?>"></script>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-user-plus"></i> <?php echo $this->lang->line('patient_information'); ?>
            <small><?php echo $this->lang->line('patient_registration'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('home'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('patient_information'); ?></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-user-plus"></i> Enhanced Patient Registration with Workflow Tracking
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('patient', 'can_add')) { ?>
                                <a data-toggle="modal" data-target="#addpatientModal" class="btn btn-primary btn-sm">
                                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_patient'); ?>
                                </a>
                            <?php } ?>
                            <button type="button" class="btn btn-sm btn-info" onclick="showWorkflowGuide()">
                                <i class="fa fa-question-circle"></i> Workflow Guide
                            </button>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <div class="download_label"><?php echo $this->lang->line('patient_list'); ?></div>
                        <table class="table table-striped table-bordered table-hover ajaxlist" cellspacing="0" width="100%" data-export-title="<?php echo $this->lang->line('patient_list'); ?>">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                                    <th><?php echo $this->lang->line('patient_name'); ?></th>
                                    <th><?php echo $this->lang->line('guardian_name'); ?></th>
                                    <th><?php echo $this->lang->line('gender'); ?></th>
                                    <th><?php echo $this->lang->line('phone'); ?></th>
                                    <th>Workflow Type</th>
                                    <th>Triage Status</th>
                                    <th>Lab Status</th>
                                    <th>Radiology Status</th>
                                    <th>Consultation Status</th>
                                    <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Patient Modal -->
<div class="modal fade" id="addpatientModal" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-user-plus"></i> Enhanced Patient Registration with Workflow Enforcement
                </h4>
            </div>
            
            <form id="formaddpa" accept-charset="utf-8" action="<?php echo base_url() ?>admin/patient/create" enctype="multipart/form-data" method="post">
                <div class="modal-body pt0 pb0">
                    <div class="row">
                        <!-- Workflow Selection Section -->
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <h4><i class="fa fa-info-circle"></i> Workflow Selection</h4>
                                <p>Select the appropriate workflow type for this patient to enforce proper service ordering and tracking.</p>
                            </div>
                            
                            <div class="form-group">
                                <label><i class="fa fa-flow-chart"></i> Patient Workflow Type <span class="req">*</span></label>
                                <div class="workflow-selection">
                                    <?php foreach ($workflows as $key => $workflow): ?>
                                    <div class="radio workflow-radio" style="margin-bottom: 15px; border: 1px solid #ddd; padding: 15px; border-radius: 5px;">
                                        <label>
                                            <input type="radio" name="patient_workflow" value="<?php echo $key; ?>" 
                                                   data-description="<?php echo $workflow['description']; ?>"
                                                   data-cost="<?php echo $workflow['base_cost']; ?>"
                                                   data-restrictions='<?php echo json_encode($workflow['step_restrictions']); ?>'
                                                   onchange="updateWorkflowInfo()" required>
                                            <strong><?php echo $workflow['name']; ?></strong>
                                            <span class="workflow-cost text-muted">(KES <?php echo number_format($workflow['base_cost']); ?>)</span>
                                            <br>
                                            <small class="text-muted"><?php echo $workflow['description']; ?></small>
                                        </label>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <!-- Workflow Information Panel -->
                            <div id="workflow-info-panel" class="alert alert-warning" style="display: none;">
                                <h4><i class="fa fa-exclamation-triangle"></i> Workflow Restrictions</h4>
                                <div id="workflow-description"></div>
                                <div id="workflow-restrictions" class="mt-2"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Basic Patient Information -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('name'); ?></label><small class="req"> *</small>
                                <input id="name" name="name" placeholder="" type="text" class="form-control" value="<?php echo set_value('name'); ?>" />
                                <span class="text-danger"><?php echo form_error('name'); ?></span>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('gender'); ?></label><small class="req"> *</small>
                                <select class="form-control" name="gender">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php foreach ($genderList_Patient as $key => $value) { ?>
                                        <option value="<?php echo $key; ?>" <?php echo set_select('gender', $key); ?>><?php echo $value; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger"><?php echo form_error('gender'); ?></span>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="exampleInputFile">
                                    <?php echo $this->lang->line('patient') . " " . $this->lang->line('photo'); ?>
                                </label>
                                <div>
                                    <input class="filestyle form-control" type='file' name='file' id="file" size='20' />
                                </div>
                                <span class="text-danger"><?php echo form_error('file'); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('date_of_birth'); ?></label>
                                <input id="dob" name="dob" placeholder="yyyy-mm-dd" type="text" class="form-control date patient_dob" value="<?php echo set_value('dob'); ?>" />
                                <span class="text-danger"><?php echo form_error('dob'); ?></span>
                            </div>
                        </div>
                        
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('age'); ?></label>
                                <div style="clear: both;overflow: hidden;">
                                    <input type="number" placeholder="<?php echo $this->lang->line('year'); ?>" name="age" id="age_year" class="form-control" style="width: 100px; float: left;margin-right: 5px;" value="<?php echo set_value('age'); ?>" />
                                    <span class="text-danger"><?php echo form_error('age'); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('month'); ?></label>
                                <input type="number" placeholder="<?php echo $this->lang->line('month'); ?>" name="month" id="age_month" class="form-control" style="width: 100px;" value="<?php echo set_value('month'); ?>" />
                                <span class="text-danger"><?php echo form_error('month'); ?></span>
                            </div>
                        </div>
                        
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('day'); ?></label>
                                <input type="number" placeholder="<?php echo $this->lang->line('day'); ?>" name="day" id="age_day" class="form-control" style="width: 100px;" value="<?php echo set_value('day'); ?>" />
                                <span class="text-danger"><?php echo form_error('day'); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('blood_group'); ?></label>
                                <select class="form-control" name="blood_group" id="blood_group">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php foreach ($bloodgroup as $key => $value) { ?>
                                        <option value="<?php echo $value; ?>" <?php echo set_select('blood_group', $value); ?>><?php echo $value; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('marital_status'); ?></label>
                                <select class="form-control" name="marital_status">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php foreach ($marital_status as $mkey => $mvalue) { ?>
                                        <option value="<?php echo $mkey; ?>" <?php echo set_select('marital_status', $mkey); ?>><?php echo $mvalue; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('phone'); ?></label>
                                <input id="contact" name="mobileno" placeholder="" type="text" class="form-control" value="<?php echo set_value('mobileno'); ?>" />
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('email'); ?></label>
                                <input type="text" id="email" name="email" class="form-control" value="<?php echo set_value('email'); ?>" />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('address'); ?></label>
                                <input name="address" id="address" placeholder="" type="text" class="form-control" value="<?php echo set_value('address'); ?>" />
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('guardian_name'); ?></label>
                                <input type="text" name="guardian_name" id="guardian_name" class="form-control" value="<?php echo set_value('guardian_name'); ?>" />
                            </div>
                        </div>
                    </div>

                    <!-- Biometric Section for GCC -->
                    <div id="biometric-section" style="display: none;">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4><i class="fa fa-fingerprint"></i> Biometric Data Collection (Required for GCC)</h4>
                                    </div>
                                    <div class="panel-body">
                                        <!-- Fingerprint Capture Section -->
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="fingerprint-capture-section">
                                                    <h5><i class="fa fa-hand-paper-o"></i> Fingerprint Capture</h5>
                                                    
                                                    <!-- SecuGen Integration -->
                                                    <div id="fingerprint_container" style="border: 2px solid #ccc; padding: 20px; text-align: center; background-color: #f9f9f9; min-height: 200px;">
                                                        <div id="fingerprint_display" style="margin-bottom: 15px;">
                                                            <canvas id="fingerprint_canvas" width="300" height="200" style="border: 1px solid #ddd; background: white; display: none;"></canvas>
                                                            <div id="fingerprint_placeholder" style="color: #666; margin-top: 50px;">
                                                                <i class="fa fa-hand-paper-o fa-3x"></i>
                                                                <p>Click "Capture Fingerprint" to start</p>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="fingerprint-actions" style="margin-top: 15px;">
                                                            <button type="button" id="captureFingerprint" class="btn btn-primary">
                                                                <i class="fa fa-hand-paper-o"></i> Capture Fingerprint
                                                            </button>
                                                            <button type="button" id="clearFingerprint" class="btn btn-warning" style="display: none;">
                                                                <i class="fa fa-trash"></i> Clear Fingerprint
                                                            </button>
                                                        </div>
                                                        
                                                        <!-- Status Messages -->
                                                        <div id="fingerprintStatus" style="margin-top: 10px;"></div>
                                                    </div>
                                                    
                                                    <!-- Hidden inputs for fingerprint data -->
                                                    <input type="hidden" name="fingerprint_template" id="fingerprint_template" value="">
                                                    <input type="hidden" name="fingerprint_image" id="fingerprint_image" value="">
                                                </div>
                                            </div>
                                            
                                            <!-- Camera Photo Capture Section -->
                                            <div class="col-md-6">
                                                <div class="camera-capture-section">
                                                    <h5><i class="fa fa-camera"></i> Photo Capture</h5>
                                                    
                                                    <div id="camera_container" style="border: 2px solid #ccc; padding: 20px; text-align: center; background-color: #f9f9f9; min-height: 200px;">
                                                        <video id="camera_stream" width="280" height="200" style="border: 1px solid #ddd; display: none;" autoplay></video>
                                                        <canvas id="photo_canvas" width="280" height="200" style="border: 1px solid #ddd; display: none;"></canvas>
                                                        <img id="captured_image" width="280" height="200" style="border: 1px solid #ddd; display: none;" />
                                                        
                                                        <div id="camera_placeholder" style="color: #666; margin-top: 50px;">
                                                            <i class="fa fa-camera fa-3x"></i>
                                                            <p>Click "Take Photo" to capture</p>
                                                        </div>
                                                        
                                                        <div class="camera-controls" style="margin-top: 15px;">
                                                            <button type="button" id="capturePhotoBtn" class="btn btn-success">
                                                                <i class="fa fa-camera"></i> Start Camera
                                                            </button>
                                                            <button type="button" id="takePhotoBtn" class="btn btn-primary" style="display: none;">
                                                                <i class="fa fa-camera"></i> Take Photo
                                                            </button>
                                                            <button type="button" id="cancelPhotoBtn" class="btn btn-default" style="display: none;">
                                                                Cancel
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Workflow-Specific Fields -->
                    <div id="workflow-specific-fields" style="display: none;">
                        <!-- GCC Specific Fields -->
                        <div id="gcc-fields" class="workflow-fields" style="display: none;">
                            <div class="panel panel-primary">
                                <div class="panel-heading">
                                    <h4><i class="fa fa-globe"></i> GCC Process Information</h4>
                                </div>
                                <div class="panel-body">
                                    <div class="alert alert-warning">
                                        <i class="fa fa-exclamation-triangle"></i>
                                        <strong>Workflow Restrictions:</strong> Triage must be completed before Lab/Radiology. All services must be completed before Consultation.
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>GCC Package Type</label>
                                                <select name="gcc_package" class="form-control">
                                                    <option value="">Select Package</option>
                                                    <option value="basic">Basic Health Screening</option>
                                                    <option value="comprehensive">Comprehensive Health Check</option>
                                                    <option value="executive">Executive Health Package</option>
                                                    <option value="women">Women's Health Package</option>
                                                    <option value="cardiac">Cardiac Screening</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Purpose of Visit</label>
                                                <select name="gcc_purpose" class="form-control">
                                                    <option value="">Select Purpose</option>
                                                    <option value="employment">Employment Medical</option>
                                                    <option value="visa">Visa Application</option>
                                                    <option value="residence">Residence Permit</option>
                                                    <option value="renewal">Medical Renewal</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Preferred Appointment Date</label>
                                                <input type="text" name="gcc_appointment_date" class="form-control datepicker-appointment" placeholder="Select date">
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Nationality</label>
                                                <input type="text" name="nationality" class="form-control" placeholder="Patient's nationality">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Specialized Workflow Fields -->
                        <div id="specialized-fields" class="workflow-fields" style="display: none;">
                            <div class="panel panel-warning">
                                <div class="panel-heading">
                                    <h4><i class="fa fa-stethoscope"></i> Specialized Medical Process</h4>
                                </div>
                                <div class="panel-body">
                                    <div class="alert alert-warning">
                                        <i class="fa fa-exclamation-triangle"></i>
                                        <strong>Workflow Restrictions:</strong> Triage must be completed before Consultation or other services.
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Chief Complaint / Presenting Symptoms <span class="req">*</span></label>
                                                <textarea name="chief_complaint" class="form-control" rows="3" 
                                                        placeholder="Primary reason for visit (required for specialized workflow)"></textarea>
                                                <small class="text-muted">Required for mandatory triage in specialized workflow</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Priority Level</label>
                                                <select name="priority_level" class="form-control">
                                                    <option value="normal">Normal</option>
                                                    <option value="high">High Priority</option>
                                                    <option value="urgent">Urgent</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Specialty Required</label>
                                                <select name="specialty_required" class="form-control">
                                                    <option value="">Select Specialty</option>
                                                    <option value="cardiology">Cardiology</option>
                                                    <option value="neurology">Neurology</option>
                                                    <option value="orthopedics">Orthopedics</option>
                                                    <option value="gastroenterology">Gastroenterology</option>
                                                    <option value="endocrinology">Endocrinology</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- General Workflow Fields -->
                        <div id="general-fields" class="workflow-fields" style="display: none;">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4><i class="fa fa-user"></i> General Medical Process</h4>
                                </div>
                                <div class="panel-body">
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i>
                                        <strong>Flexible Workflow:</strong> You can access any service as needed without strict ordering requirements.
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Services Requested (Optional)</label>
                                                <div class="checkbox-group">
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="requested_services[]" value="triage"> Triage
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="requested_services[]" value="consultation"> Consultation
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="requested_services[]" value="laboratory"> Laboratory
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="requested_services[]" value="radiology"> Radiology
                                                    </label>
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" name="requested_services[]" value="pharmacy"> Pharmacy
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Fields -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('known_allergies'); ?></label>
                                <textarea name="known_allergies" id="known_allergies" class="form-control" rows="2"><?php echo set_value('known_allergies'); ?></textarea>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('note'); ?></label>
                                <textarea name="note" id="note" class="form-control" rows="2"><?php echo set_value('note'); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <!-- TPA Information -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('organisation'); ?></label>
                                <select class="form-control select2" style="width:100%" name="organisation" id="organisation">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                   <?php foreach ($organisation as $orgkey => $orgvalue) { ?>
                                       <option value="<?php echo $orgvalue["id"]; ?>" <?php echo set_select('organisation', $orgvalue["id"]); ?>><?php echo $orgvalue["organisation_name"] ?></option>
                                   <?php } ?>
                               </select>
                           </div>
                       </div>
                       
                       <div class="col-md-4">
                           <div class="form-group">
                               <label><?php echo $this->lang->line('insurance_id'); ?></label>
                               <input type="text" name="insurance_id" id="insurance_id" class="form-control" value="<?php echo set_value('insurance_id'); ?>" />
                           </div>
                       </div>
                       
                       <div class="col-md-4">
                           <div class="form-group">
                               <label><?php echo $this->lang->line('insurance_validity'); ?></label>
                               <input id="insurance_validity" name="insurance_validity" placeholder="yyyy-mm-dd" type="text" class="form-control date tpa_validity" value="<?php echo set_value('insurance_validity'); ?>" />
                           </div>
                       </div>
                   </div>

                   <div class="row">
                       <div class="col-md-6">
                           <div class="form-group">
                               <label><?php echo $this->lang->line('identification_number'); ?></label>
                               <input type="text" name="identification_number" id="identification_number" class="form-control" value="<?php echo set_value('identification_number'); ?>" />
                           </div>
                       </div>
                       
                       <div class="col-md-6">
                           <div class="form-group">
                               <label for="pwd"><?php echo $this->lang->line('patient_type'); ?></label>
                               <select class="form-control" name="patient_type" id="patient_type">
                                   <option value=""><?php echo $this->lang->line('select'); ?></option>
                                   <?php foreach ($patienttype as $ptkey => $ptvalue) { ?>
                                       <option value="<?php echo $ptvalue["id"]; ?>" <?php echo set_select('patient_type', $ptvalue["id"]); ?>><?php echo $ptvalue["patient_type"] ?></option>
                                   <?php } ?>
                               </select>
                           </div>
                       </div>
                   </div>

                   <!-- Hidden Fields for Workflow Tracking -->
                   <input type="hidden" name="is_triage" id="is_triage" value="not_required">
                   <input type="hidden" name="is_consultation" id="is_consultation" value="not_required">
                   <input type="hidden" name="is_laboratory" id="is_laboratory" value="not_required">
                   <input type="hidden" name="is_radiology" id="is_radiology" value="not_required">
                   <input type="hidden" name="workflow_restrictions" id="workflow_restrictions" value="">

                   <!-- Custom Fields -->
                   <div class="row">
                       <div class="col-md-12">
                           <?php echo display_custom_fields('patient'); ?>
                       </div>
                   </div>
               </div>
               
               <div class="modal-footer">
                   <div class="pull-right">
                       <button type="submit" id="formaddpabtn" data-loading-text="<?php echo $this->lang->line('processing'); ?>" class="btn btn-info pull-right">
                           <i class="fa fa-check-circle"></i> <?php echo $this->lang->line('save'); ?>
                       </button>
                   </div>
               </div>
           </form>
       </div>
   </div>
</div>

<!-- Edit Patient Modal -->
<div class="modal fade" id="editModal" role="dialog" aria-labelledby="myModalLabel">
   <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content modal-media-content mx-2">
           <div class="modal-header modal-media-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title"><?php echo $this->lang->line('edit_patient_details'); ?></h4>
           </div>
           <form id="formeditpa" accept-charset="utf-8" action="" enctype="multipart/form-data" method="post" class="ptt10">
               <div class="modal-body pt0 pb0">
                   <input id="eupdateid" name="updateid" placeholder="" type="hidden" class="form-control" value="" />
                   
                   <!-- Edit form content similar to add form but with edit fields -->
                   <div class="row">
                       <div class="col-md-6">
                           <div class="form-group">
                               <label><?php echo $this->lang->line('name'); ?></label><small class="req"> *</small>
                               <input id="ename" name="name" placeholder="" type="text" class="form-control" value="<?php echo set_value('name'); ?>" />
                               <span class="text-danger"><?php echo form_error('name'); ?></span>
                           </div>
                       </div>
                       
                       <div class="col-sm-6">
                           <div class="form-group">
                               <label><?php echo $this->lang->line('gender'); ?></label>
                               <select class="form-control" name="gender" id="egender">
                                   <option value=""><?php echo $this->lang->line('select'); ?></option>
                                   <?php foreach ($genderList as $key => $value) { ?>
                                       <option value="<?php echo $key; ?>" <?php echo set_select('gender', $key); ?>><?php echo $value; ?></option>
                                   <?php } ?>
                               </select>
                               <span class="text-danger"><?php echo form_error('gender'); ?></span>
                           </div>
                       </div>
                   </div>

                   <!-- Rest of edit form fields... -->
                   <!-- (Similar structure to add form but with edit prefixes) -->
                   
               </div>
               <div class="modal-footer">
                   <div class="pull-right">
                       <button type="submit" id="formeditpabtn" data-loading-text="<?php echo $this->lang->line('processing'); ?>" class="btn btn-info pull-right">
                           <i class="fa fa-check-circle"></i> <?php echo $this->lang->line('save'); ?>
                       </button>
                   </div>
               </div>
           </form>
       </div>
   </div>
</div>

<!-- Patient Details Modal -->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel">
   <div class="modal-dialog pup100" role="document">
       <div class="modal-content modal-media-content">
           <div class="modal-header modal-media-header">
               <button type="button" class="close" data-placement="bottom" data-toggle="tooltip" title="<?php echo $this->lang->line('close'); ?>" data-dismiss="modal">&times;</button>
               <div class="modalicon">
                   <div id='edit_delete'>
                       <?php if ($this->rbac->hasPrivilege('revisit', 'can_edit')) { ?>
                           <a href="#" data-placement="bottom" data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>"><i class="fa fa-pencil"></i></a>
                       <?php
                       }
                       if ($this->rbac->hasPrivilege('revisit', 'can_delete')) {
                       ?>
                           <a href="#" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?php echo $this->lang->line('delete'); ?>"><i class="fa fa-trash"></i></a>
                       <?php } ?>
                   </div>
               </div>
               <h4 class="modal-title" id="modal_head"></h4>
           </div>
           <div class="pup-scroll-area">
               <div class="modal-body pt0 pb0">
                   <div class="row">
                       <div class="col-lg-12 col-md-12 col-sm-12">
                           <form id="formadd" accept-charset="utf-8" action="<?php echo base_url() ?>admin/patient/create" enctype="multipart/form-data" method="post">
                               <div class="row">
                                   <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                       <div id="visit_report"></div>
                                   </div>
                               </div>
                           </form>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </div>
</div>

<!-- Workflow Guide Modal -->
<div class="modal fade" id="workflowGuideModal" tabindex="-1" role="dialog">
   <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
           <div class="modal-header">
               <h4 class="modal-title">
                   <i class="fa fa-question-circle"></i> Workflow Guide & Restrictions
               </h4>
               <button type="button" class="close" data-dismiss="modal">&times;</button>
           </div>
           <div class="modal-body">
               <div class="row">
                   <div class="col-md-4">
                       <div class="panel panel-primary">
                           <div class="panel-heading">
                               <h5>GCC Workflow</h5>
                           </div>
                           <div class="panel-body">
                               <p><strong>Process:</strong> Registration → Triage → Lab → Radiology → Consultation</p>
                               <p><strong>Restrictions:</strong></p>
                               <ul>
                                   <li>Triage must be completed before Lab/Radiology</li>
                                   <li>All services must be completed before Consultation</li>
                                   <li>Requires fingerprint and photo</li>
                               </ul>
                               <p><strong>Fee:</strong> KES 10,500</p>
                           </div>
                       </div>
                   </div>
                   
                   <div class="col-md-4">
                       <div class="panel panel-warning">
                           <div class="panel-heading">
                               <h5>Specialized Workflow</h5>
                           </div>
                           <div class="panel-body">
                               <p><strong>Process:</strong> Registration → Triage → Consultation</p>
                               <p><strong>Restrictions:</strong></p>
                               <ul>
                                   <li>Triage must be completed before Consultation</li>
                                   <li>Other services are optional after Triage</li>
                               </ul>
                               <p><strong>Fee:</strong> KES 1,900</p>
                           </div>
                       </div>
                   </div>
                   
                   <div class="col-md-4">
                       <div class="panel panel-default">
                           <div class="panel-heading">
                               <h5>General Workflow</h5>
                           </div>
                           <div class="panel-body">
                               <p><strong>Process:</strong> Registration → Flexible routing</p>
                               <p><strong>Restrictions:</strong></p>
                               <ul>
                                   <li>No ordering restrictions</li>
                                   <li>All services are optional</li>
                                   <li>Access any service as needed</li>
                               </ul>
                               <p><strong>Fee:</strong> KES 900</p>
                           </div>
                       </div>
                   </div>
               </div>
               
               <div class="alert alert-info">
                   <h4><i class="fa fa-lightbulb-o"></i> Key Points:</h4>
                   <ul>
                       <li>The system will automatically enforce workflow restrictions</li>
                       <li>Patients cannot access restricted services until prerequisites are met</li>
                       <li>Workflow status is tracked automatically</li>
                       <li>Staff will receive clear error messages if restrictions are violated</li>
                   </ul>
               </div>
           </div>
           <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
           </div>
       </div>
   </div>
</div>

<!-- Workflow Restriction Modal -->
<div class="modal fade" id="workflowRestrictionModal" tabindex="-1" role="dialog">
   <div class="modal-dialog" role="document">
       <div class="modal-content">
           <div class="modal-header bg-warning">
               <h4 class="modal-title">
                   <i class="fa fa-exclamation-triangle"></i> Workflow Restriction
               </h4>
               <button type="button" class="close" data-dismiss="modal">&times;</button>
           </div>
           <div class="modal-body" id="restriction-modal-body">
               <!-- Content will be populated by JavaScript -->
           </div>
           <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="button" class="btn btn-primary" id="go-to-next-step-btn">
                   Go to Required Step
               </button>
           </div>
       </div>
   </div>
</div>

<script type="text/javascript">
// Enhanced workflow configuration with pricing
const workflowPricing = {
    'gcc': {
        'name': 'GCC Workflow',
        'base_cost': 10500.00,
        'currency': 'KES',
        'description': 'Comprehensive health screening package',
        'includes': [
            'Initial consultation',
            'Laboratory tests (Full blood count, Lipid profile, Blood glucose)',
            'Radiology (Chest X-ray, ECG)',
            'Final consultation with report',
            'Health certificate'
        ],
        'color': '#28a745'
    },
    'general': {
        'name': 'General Workflow',
        'base_cost': 900.00,
        'currency': 'KES',
        'description': 'Basic consultation and flexible services',
        'includes': [
            'Initial consultation',
            'Basic examination',
            'Prescription if needed'
        ],
        'color': '#17a2b8'
    },
    'specialized': {
        'name': 'Specialized Workflow',
        'base_cost': 1900.00,
        'currency': 'KES',
        'description': 'Priority specialist consultation',
        'includes': [
            'Priority triage assessment',
            'Specialist consultation',
            'Treatment plan',
            'Follow-up recommendations'
        ],
        'color': '#dc3545'
    }
};

// Enhanced workflow configuration with step tracking
const workflowConfig = {
    'gcc': {
        'name': 'GCC Workflow',
        'description': 'Registration → Mandatory Triage → Lab → Radiology → Consultation → Complete',
        'mandatory_steps': ['triage', 'lab', 'radiology', 'consultation'],
        'requires_triage': true,
        'excludes_icd_diagnosis': true,
        'base_cost': 10500.00,
        'step_restrictions': {
            'lab': ['triage'],
            'radiology': ['triage'],
            'consultation': ['triage', 'lab', 'radiology']
        }
    },
    'general': {
        'name': 'General Workflow',
        'description': 'Registration → (Optional services) → Flexible routing',
        'mandatory_steps': [],
        'requires_triage': false,
        'excludes_icd_diagnosis': false,
        'base_cost': 900.00,
        'step_restrictions': {}
    },
    'specialized': {
        'name': 'Specialized Workflow',
        'description': 'Registration → Mandatory Triage → Mandatory Consultation → (Optional services)',
        'mandatory_steps': ['triage', 'consultation'],
        'requires_triage': true,
        'excludes_icd_diagnosis': false,
        'base_cost': 1900.00,
        'step_restrictions': {
            'consultation': ['triage'],
            'lab': ['triage'],
            'radiology': ['triage']
        }
    }
};

// ENHANCED DataTable initialization
(function($) {
    'use strict';
    $(document).ready(function() {
        var search_text = $('#search_text').val();
        
        // Initialize DataTable with correct configuration
        var table = $('.ajaxlist').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": base_url + "admin/patient/getpatientdatatable",
                "type": "POST",
                "data": function(d) {
                    d.search_text = search_text;
                    d.patient_workflow = $('#workflow_filter').val() || '';
                    d.date_from = $('#date_from').val() || '';
                    d.date_to = $('#date_to').val() || '';
                    d.gender_filter = $('#gender_filter').val() || '';
                    d.age_range = $('#age_range').val() || '';
                    d.insurance_filter = $('#insurance_filter').val() || '';
                    d.fingerprint_filter = $('#fingerprint_filter').val() || '';
                },
                "error": function(xhr, error, code) {
                    console.error('DataTable AJAX Error:', {
                        status: xhr.status,
                        statusText: xhr.statusText,
                        responseText: xhr.responseText,
                        error: error,
                        code: code
                    });
                    alert('Error loading patient data. Please check console for details.');
                }
            },
            "columns": [
                {
                    "data": null,
                    "render": function(data, type, row, meta) {
                        var patientId = Array.isArray(row) ? row[7] : (row.id || row.patient_id);
                        return '<input type="checkbox" name="patient[]" class="enable_delete" value="' + patientId + '"> ' + (meta.row + meta.settings._iDisplayStart + 1);
                    },
                    "orderable": false
                },
                {"data": 0, "name": "patient_name"},
                {"data": 1, "name": "age"},
                {"data": 2, "name": "gender"},
                {"data": 3, "name": "phone"},
                {"data": 4, "name": "guardian_name"},
                {"data": 5, "name": "address"},
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var workflow = Array.isArray(row) ? row[8] : (row.patient_workflow || 'general');
                        const badges = {
                            'gcc': '<span class="label label-primary">GCC</span>',
                            'specialized': '<span class="label label-warning">Specialized</span>',
                            'general': '<span class="label label-default">General</span>'
                        };
                        return badges[workflow] || '<span class="label label-secondary">Unknown</span>';
                    },
                    "orderable": false
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var patientId = Array.isArray(row) ? row[7] : (row.id || row.patient_id);
                        
                        var actions = '<div class="btn-group">';
                        // Updated to use new profile page
                        actions += '<button type="button" class="btn btn-xs btn-primary" onclick="getpatientData(' + patientId + ')" title="View Profile"><i class="fa fa-eye"></i></button>';
                        actions += '<button type="button" class="btn btn-xs btn-info" onclick="editRecord(' + patientId + ')" title="Edit"><i class="fa fa-pencil"></i></button>';
                        actions += '</div>';
                        return actions;
                    },
                    "orderable": false
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var patientId = Array.isArray(row) ? row[7] : (row.id || row.patient_id);
                        
                        var actions = '<div class="btn-group">';
                        actions += '<button type="button" class="btn btn-xs btn-primary" onclick="getpatientData(' + patientId + ')" title="View Details"><i class="fa fa-eye"></i></button>';
                        actions += '<button type="button" class="btn btn-xs btn-info" onclick="editRecord(' + patientId + ')" title="Edit"><i class="fa fa-pencil"></i></button>';
                        actions += '</div>';
                        return actions;
                    },
                    "orderable": false
                }
            ],
            "order": [[1, "desc"]],
            "pageLength": 25,
            "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "All"]],
            "language": {
                "search": "Search Patients:",
                "lengthMenu": "Show _MENU_ patients per page",
                "info": "Showing _START_ to _END_ of _TOTAL_ patients",
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Next",
                    "previous": "Previous"
                },
                "processing": "Loading patient data...",
                "emptyTable": "No patient data available",
                "loadingRecords": "Loading..."
            },
            "initComplete": function() {
                console.log('DataTable initialization complete');
                addCustomFilters();
                
                $('.ajaxlist_filter input').off().on('keyup', function() {
                    table.search(this.value).draw();
                });
            },
            "drawCallback": function() {
                console.log('DataTable draw completed');
            }
        });
        
        // Store table reference globally
        window.table = table;
        
        // Helper function to get status class for workflow status dots
        function getStatusClass(status) {
            switch (status) {
                case 'completed': return 'status-completed';
                case 'pending': return 'status-pending';
                case 'skipped': return 'status-skipped';
                case 'not_required': return 'status-not-required';
                default: return 'status-unknown';
            }
        }

        function addCustomFilters() {
            // Add any custom filter functionality here
            $('.search-filter').on('change', function() {
                table.ajax.reload();
            });
        }
    });
}(jQuery));

// Utility functions
function showdate(value) {
    if (value == 'period') {
        $('#fromdate').show();
        $('#todate').show();
    } else {
        $('#fromdate').hide();
        $('#todate').hide();
    }
}

function holdModal(modalId) {
    $('#' + modalId).modal({
        backdrop: 'static',
        keyboard: false,
        show: true
    });
}

function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}

// Enhanced patient data function with workflow support
function getpatientData(id) {
    console.log('Loading patient data for ID:', id);
    
    // Set modal title
    $('#modal_head').html('<i class="fa fa-user"></i> <?php echo $this->lang->line("patient_details"); ?>');
    
    // Show loading state in modal body
    $('#myModal .modal-body').html(`
        <div class="text-center" style="padding: 50px;">
            <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
            <h4 style="margin-top: 20px;">Loading patient details...</h4>
        </div>
    `);
    
    // Show the modal immediately
    $('#myModal').modal('show');
    
    $.ajax({
        url: baseurl + 'admin/patient/getpatientDetails',  // Use your existing endpoint
        type: "POST",
        data: { id: id },
        dataType: 'json',
        timeout: 10000,
        success: function(data) {
            console.log('Patient Data Response:', data);
            
            if (!data || data.error) {
                $('#myModal .modal-body').html(`
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i> Error: ${data?.error || 'Failed to load patient data'}
                    </div>
                `);
                return;
            }
            
            // Generate the patient details HTML using your existing data structure
            const patientHtml = generatePatientModalContent(data);
            $('#myModal .modal-body').html(patientHtml);
            
            // Update action buttons in modal header
            updateModalActionButtons(data);
            
            // Initialize tooltips and other components
            $('[data-toggle="tooltip"]').tooltip();
            
            // Trigger visit data loading
            patientvisit(id);
            
            // Add barcode buttons if available
            if (data.getbarcode || data.getqrcode) {
                addBarcodeButtons(data.id, data.patient_name, data.getbarcode, data.getqrcode);
            }
            
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', {
                status: xhr.status,
                statusText: xhr.statusText,
                responseText: xhr.responseText,
                error: error
            });
            
            let errorMessage = 'Failed to load patient details. ';
            if (xhr.status === 0) {
                errorMessage += 'Please check your internet connection.';
            } else if (xhr.status === 404) {
                errorMessage += 'Patient details endpoint not found.';
            } else if (xhr.status === 500) {
                errorMessage += 'Server error occurred.';
            } else {
                errorMessage += `HTTP ${xhr.status} error.`;
            }
            
            $('#myModal .modal-body').html(`
                <div class="alert alert-danger">
                    <h4><i class="fa fa-exclamation-triangle"></i> Error Loading Patient</h4>
                    <p>${errorMessage}</p>
                    <button class="btn btn-primary" onclick="getpatientData(${id})">
                        <i class="fa fa-refresh"></i> Try Again
                    </button>
                </div>
            `);
        }
    });
}

// Generate patient modal content using your existing data structure
function generatePatientModalContent(data) {
    return `
    <div class="row">
        <!-- Left Column - Patient Photo and Basic Info -->
        <div class="col-lg-12 col-md-12 col-sm-12 paddlr">
            <div class="row">
                <div class="col-md-4">
                    <div class="ptt10">
                        <img src="${baseurl}${data.image}" 
                             class="img-thumbnail width150" 
                             alt="Patient Photo"
                             onerror="this.src='${baseurl}uploads/patient_images/no_image.png'">
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="table-responsive">
                        <table class="table table-striped mb0">
                            <tbody id="field_data">
                                <tr>
                                    <th width="30%"><?php echo $this->lang->line('patient_name'); ?></th>
                                    <td><span id="patient_name">${data.patient_name || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                                    <td><span id="patient_unique_id">${data.id || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('guardian_name'); ?></th>
                                    <td><span id="guardian">${data.guardian_name || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('gender'); ?></th>
                                    <td><span id="genders">${data.gender || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('marital_status'); ?></th>
                                    <td><span id="marital_status">${data.marital_status || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('phone'); ?></th>
                                    <td><span id="contact">${data.mobileno || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('email'); ?></th>
                                    <td><span id="email">${data.email || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('address'); ?></th>
                                    <td><span id="address">${data.address || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('age'); ?></th>
                                    <td><span id="age">${data.patient_age || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('as_of_date'); ?></th>
                                    <td><span id="as_of_date">${data.as_of_date || ''}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('date_of_birth'); ?></th>
                                    <td><span id="dob">${data.dob || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('blood_group'); ?></th>
                                    <td><span id="blood_group">${data.blood_group_name || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('known_allergies'); ?></th>
                                    <td><span id="allergies">${data.known_allergies || 'None'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('organisation'); ?></th>
                                    <td><span id="organisation_name">${data.organisation_name || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('insurance_id'); ?></th>
                                    <td><span id="insurance_id">${data.insurance_id || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('insurance_validity'); ?></th>
                                    <td><span id="validity">${data.insurance_validity || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('identification_number'); ?></th>
                                    <td><span id="identification_number">${data.identification_number || 'N/A'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('note'); ?></th>
                                    <td><span id="note">${data.note || 'No notes'}</span></td>
                                </tr>
                                <tr>
                                    <th><?php echo $this->lang->line('status'); ?></th>
                                    <td><span id="is_active">${data.is_active === 'yes' ? 'Active' : 'Inactive'}</span></td>
                                </tr>
                                ${generateCustomFieldsHTML(data.field_data)}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Fingerprint Section -->
    ${generateFingerprintSection(data)}
    
    <!-- Patient Visit History Section -->
    <div class="row">
        <div class="col-md-12">
            <div class="ptt10" id="visit_report_id">
                <!-- Visit data will be loaded here by patientvisit() function -->
            </div>
        </div>
    </div>
    `;
}

// Generate custom fields HTML
function generateCustomFieldsHTML(fieldData) {
    if (!fieldData || fieldData.length === 0) {
        return '';
    }
    
    let html = '';
    fieldData.forEach(field => {
        html += `
        <tr>
            <th>${field.name}</th>
            <td>${field.default_value || 'N/A'}</td>
        </tr>`;
    });
    return html;
}

// Generate fingerprint section if available
function generateFingerprintSection(data) {
    if (!data.fingerprint_template && !data.fingerprint_image) {
        return '';
    }
    
    return `
    <div class="row">
        <div class="col-md-12">
            <div class="ptt10">
                <h4><i class="fa fa-fingerprint"></i> Fingerprint Information</h4>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <tr>
                            <th>Fingerprint Status</th>
                            <td>
                                <span class="label label-success">
                                    <i class="fa fa-check"></i> Available
                                </span>
                            </td>
                        </tr>
                        ${data.fingerprint_image ? `
                        <tr>
                            <th>Fingerprint Image</th>
                            <td>
                                <img src="data:image/bmp;base64,${data.fingerprint_image}" 
                                     style="width: 100px; height: 100px; border: 1px solid #ddd;"
                                     alt="Fingerprint">
                            </td>
                        </tr>` : ''}
                    </table>
                </div>
            </div>
        </div>
    </div>`;
}

// Update modal action buttons in header
function updateModalActionButtons(data) {
    let actionHtml = '';
    
    // Edit button
    <?php if ($this->rbac->hasPrivilege('patient', 'can_edit')) { ?>
    actionHtml += `<a href="#" onclick="editRecord(${data.id})" data-toggle="tooltip" data-placement="bottom" title="<?php echo $this->lang->line('edit'); ?>">
                      <i class="fa fa-pencil"></i>
                   </a>`;
    <?php } ?>
    
    // Active/Deactive button
    <?php if ($this->rbac->hasPrivilege('enabled_disabled', 'can_view')) { ?>
    if (data.is_active === 'yes') {
        actionHtml += `<a href="#" data-toggle="tooltip" title="<?php echo $this->lang->line('disable'); ?>" 
                          onclick="patient_deactive(${data.id})" data-placement="bottom">
                          <i class="fa fa-thumbs-o-down"></i>
                       </a>`;
    } else {
        actionHtml += `<a href="#" data-toggle="tooltip" title="<?php echo $this->lang->line('enable'); ?>" 
                          onclick="patient_active(${data.id})" data-placement="bottom">
                          <i class="fa fa-thumbs-o-up"></i>
                       </a>`;
    }
    <?php } ?>
    
    // Delete button
    <?php if ($this->rbac->hasPrivilege('patient', 'can_delete')) { ?>
    actionHtml += `<a href="#" data-toggle="tooltip" data-placement="bottom" 
                      title="<?php echo $this->lang->line('delete'); ?>" 
                      onclick="deletePatient(${data.id})">
                      <i class="fa fa-trash"></i>
                   </a>`;
    <?php } ?>
    
    $('#edit_delete').html(actionHtml);
}

// Add barcode/QR code buttons
function addBarcodeButtons(patientId, patientName, barcodeUrl, qrcodeUrl) {
    let buttonsHtml = '<div class="ptt10">';
    
    if (barcodeUrl) {
        buttonsHtml += `<button class="btn btn-info btn-sm" onclick="window.open('${barcodeUrl}', '_blank')">
                           <i class="fa fa-barcode"></i> View Barcode
                        </button> `;
    }
    
    if (qrcodeUrl) {
        buttonsHtml += `<button class="btn btn-success btn-sm" onclick="window.open('${qrcodeUrl}', '_blank')">
                           <i class="fa fa-qrcode"></i> View QR Code
                        </button>`;
    }
    
    buttonsHtml += '</div>';
    
    // Append to the modal body
    $('#myModal .modal-body').append(buttonsHtml);
}

// Display workflow information in patient details
function displayWorkflowInfo(workflowType, workflowStatus) {
    var workflowHtml = `
        <li>
            <i class="fa fa-route" data-toggle="tooltip" data-placement="top" title="Patient Workflow"></i>
            <span><strong>Workflow:</strong> ${capitalizeFirstLetter(workflowType)}</span>
            <br>
            <small class="text-muted">Status: ${workflowStatus || 'In Progress'}</small>
        </li>
    `;
    $("#field_data").append(workflowHtml);
}

function displayFingerprint(fingerprintImage, fingerprintTemplate) {
    // Set the fingerprint image source
    $("#patient_fingerprint_display").attr("src", "data:image/bmp;base64," + fingerprintImage);

    // Update the status and other details
    $("#fingerprint_status_badge").html('<span class="badge badge-success"><i class="fa fa-check"></i> Available</span>');
    $("#fingerprint_detail_status").html('<span style="color: #5cb85c;"><i class="fa fa-check-circle"></i> Captured</span>');

    // Update template size and image size
    $("#fingerprint_template_size").text(formatBytes(fingerprintTemplate.length));
    $("#fingerprint_image_size").text(formatBytes(fingerprintImage.length));

    // Enable the buttons for actions related to the fingerprint
    $("#verifyFingerprint, #downloadFingerprint, #clearPatientFingerprint").prop('disabled', false);
}

function formatBytes(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}

function patientvisit(id) {
    $.ajax({
        url: baseurl + 'admin/patient/patientvisit',
        type: "POST",
        data: { id: id },
        dataType: 'json',
        success: function(data) {
            $('#visit_report_id').html(data);
        }
    });
}

// Edit and form submission functions
function editRecord(id) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient/getpatientDetails',
        type: "POST",
        data: { id: id },
        dataType: 'json',
        success: function(data) {
            $("#eupdateid").val(data.id);
            $('#customfield').html(data.custom_fields_value);
            $("#ename").val(data.patient_name);
            $("#eguardian_name").val(data.guardian_name);
            $("#emobileno").val(data.mobileno);
            $("#eemail").val(data.email);
            $("#eaddress").val(data.address);
            $("#age_year").val(data.age);
            $("#age_month").val(data.month);
            $("#age_day").val(data.day);
            $(".editpatient_dob").val(data.dob);
            $("#enote").val(data.note);
            $("#exampleInputFile").attr("data-default-file", '<?php echo base_url() ?>' + data.image);
            $(".dropify-render").find("img").attr("src", '<?php echo base_url() ?>' + data.image);
            $("#eknown_allergies").val(data.known_allergies);
            $('select[id="blood_groups"] option[value="' + data.blood_bank_product_id + '"]').attr("selected", "selected");
            $('select[id="egenders"] option[value="' + data.gender + '"]').attr("selected", "selected");
            $('select[id="marital_statuss"] option[value="' + data.marital_status + '"]').attr("selected", "selected");
            $("#edit_insurance_id").val(data.insurance_id);
            $("#insurance_validity").val(data.insurance_validity);
            $("#edit_identification_number").val(data.identification_number);
            $("#blood_group").html(data.blood_group_name);
            $("#myModal").modal('hide');
            holdModal('editModal');
        },
    });
}

// Enhanced patient registration with workflow integration
$(document).ready(function() {
    
    // =============================================
    // ENHANCED DATE PICKER INITIALIZATION
    // =============================================
    
    function initializeDatePickers() {
        // Date of Birth Picker
        $('.patient_dob').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true,
            endDate: 'today',
            orientation: 'bottom auto',
            container: '#myModalpa',
            zIndexOffset: 9999
        }).on('changeDate', function(e) {
            calculateAgeFromDOB(e.date);
        });

        // TPA Validity Date Picker
        $('.datepicker-tpa').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true,
            startDate: 'today',
            orientation: 'bottom auto',
            container: '#myModalpa',
            zIndexOffset: 9999
        });

        // Preferred Appointment Date Picker (for GCC workflow)
        $('.datepicker-appointment').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true,
            startDate: 'today',
            daysOfWeekDisabled: [0],
            orientation: 'bottom auto',
            container: '#myModalpa',
            zIndexOffset: 9999
        });

        console.log('Date pickers initialized successfully');
    }

    function calculateAgeFromDOB(birthDate) {
        if (!birthDate) return;
        
        const today = new Date();
        const birth = new Date(birthDate);
        
        let age = today.getFullYear() - birth.getFullYear();
        let months = today.getMonth() - birth.getMonth();
        let days = today.getDate() - birth.getDate();
        
        if (days < 0) {
            months--;
            days += new Date(today.getFullYear(), today.getMonth(), 0).getDate();
        }
        
        if (months < 0) {
            age--;
            months += 12;
        }
        
        $('.patient_age_year').val(age);
        $('.patient_age_month').val(months);
        $('.patient_age_day').val(days);
        
        console.log(`Age calculated: ${age} years, ${months} months, ${days} days`);
    }

    // Initialize date pickers when document is ready
    initializeDatePickers();

    // Re-initialize date pickers when modal is shown
    $('#myModalpa').on('shown.bs.modal', function() {
        initializeDatePickers();
        console.log('Date pickers re-initialized for modal');
    });

    // =============================================
    // WORKFLOW MANAGEMENT
    // =============================================
    
    const workflows = {
        'gcc': {
            'name': 'GCC Workflow',
            'description': 'Registration → Mandatory Triage → Lab → Radiology → Consultation → Complete',
            'mandatory_steps': ['triage', 'lab', 'radiology', 'consultation'],
            'optional_steps': [],
            'sequence': ['registration', 'triage', 'lab', 'radiology', 'consultation'],
            'color': '#28a745'
        },
        'general': {
            'name': 'General Workflow', 
            'description': 'Registration → (Optional services) → Flexible routing',
            'mandatory_steps': [],
            'optional_steps': ['triage', 'lab', 'radiology', 'consultation', 'pharmacy'],
            'sequence': ['registration'],
            'color': '#17a2b8'
        },
        'specialized': {
            'name': 'Specialized Workflow',
            'description': 'Registration → Mandatory Triage → Mandatory Consultation → (Optional services)',
            'mandatory_steps': ['triage', 'consultation'],
            'optional_steps': ['lab', 'radiology', 'pharmacy'],
            'sequence': ['registration', 'triage', 'consultation'],
            'color': '#dc3545'
        }
    };
    
// Handle workflow selection
$('input[name="patient_workflow"]').on('change', function() {
    const selectedWorkflow = $(this).val();
    const workflow = workflows[selectedWorkflow];
    const pricing = workflowPricing[selectedWorkflow];
    
    // Remove all workflow classes
    $('#myModalpa').removeClass('gcc-selected general-selected specialized-selected');
    
    // Add the selected workflow class
    $('#myModalpa').addClass(selectedWorkflow + '-selected');
    
    if (workflow && pricing) {
        updateWorkflowUI(selectedWorkflow, workflow, pricing);
        showWorkflowPreview(selectedWorkflow, workflow, pricing);
        toggleWorkflowFields(selectedWorkflow);
        displayPricingInfo(selectedWorkflow, pricing);
    }
});
    
    function updateWorkflowUI(workflowKey, workflow) {
        $('.workflow-card').css({
            'border-color': '#e9ecef',
            'background-color': '#fff'
        });
        
        $(`input[value="${workflowKey}"]`).closest('.workflow-card').css({
            'border-color': workflow.color,
            'background-color': workflow.color + '10'
        });
    }
    
    function formatCurrency(amount, currency = 'KES') {
        return new Intl.NumberFormat('en-KE', {
            style: 'currency',
            currency: currency,
            minimumFractionDigits: 0,
            maximumFractionDigits: 0
        }).format(amount);
    }
    
    function showWorkflowPreview(workflowKey, workflow, pricing) {
        let previewHtml = `
            <div class="alert alert-info">
                <h6><i class="fa fa-info-circle"></i> Selected: ${workflow.name}</h6>
                <p><strong>Patient Journey:</strong> ${workflow.description}</p>
                <p><strong>Total Cost:</strong> 
                    <span style="font-size: 16px; font-weight: bold; color: ${pricing.color};">
                        ${formatCurrency(pricing.base_cost)}
                    </span>
                </p>
                
                <div class="row">
                    <div class="col-md-6">
                        <strong>Mandatory Steps:</strong>
                        <ul class="mb-1">
                            ${workflow.mandatory_steps.length > 0 ? 
                                workflow.mandatory_steps.map(step => `<li>${capitalizeFirst(step)}</li>`).join('') : 
                                '<li><em>None - Flexible workflow</em></li>'
                            }
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <strong>Optional Steps:</strong>
                        <ul class="mb-1">
                            ${workflow.optional_steps.length > 0 ? 
                                workflow.optional_steps.map(step => `<li>${capitalizeFirst(step)}</li>`).join('') : 
                                '<li><em>None</em></li>'
                            }
                        </ul>
                    </div>
                </div>
            </div>
        `;
        
        $('#workflowPreview').html(previewHtml).show();
    }
    
    function viewPatientModal(id) {
    // Create a full-screen modal with iframe
    const modalHtml = `
        <div class="modal fade" id="patientProfileModal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" style="width: 95%; max-width: 1200px;">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">Patient Profile</h4>
                    </div>
                    <div class="modal-body" style="padding: 0;">
                        <iframe src="${base_url}admin/patient/profile/${id}" 
                                style="width: 100%; height: 80vh; border: none;">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // Remove existing modal if any
    $('#patientProfileModal').remove();
    
    // Add modal to body and show
    $('body').append(modalHtml);
    $('#patientProfileModal').modal('show');
}

function printPatientCard(patientId) {
    // Open print page in new window
    window.open(base_url + 'admin/patient/printCard/' + patientId, '_blank');
}

// Enhanced search functionality
function initializeEnhancedSearch() {
    // Add quick action buttons to search results
    $(document).on('click', '.quick-action-btn', function() {
        const action = $(this).data('action');
        const patientId = $(this).data('patient-id');
        
        switch(action) {
            case 'view':
                getpatientData(patientId);
                break;
            case 'edit':
                editRecord(patientId);
                break;
            case 'delete':
                deletePatient(patientId);
                break;
            case 'print':
                printPatientCard(patientId);
                break;
        }
    });
}
    
    function displayPricingInfo(workflowKey, pricing) {
        const pricingHtml = `
            <div id="pricing-display" class="pricing-container" style="
                margin-top: 15px; 
                padding: 15px; 
                border: 2px solid ${pricing.color}; 
                border-radius: 8px; 
                background: linear-gradient(135deg, ${pricing.color}10, ${pricing.color}05);
                box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            ">
                <div class="pricing-header" style="text-align: center; margin-bottom: 15px;">
                    <h4 style="color: ${pricing.color}; margin: 0; font-weight: bold;">
                        <i class="fa fa-money"></i> ${pricing.name} Pricing
                    </h4>
                    <div class="price-display" style="font-size: 24px; font-weight: bold; color: ${pricing.color}; margin: 8px 0;">
                        ${formatCurrency(pricing.base_cost, pricing.currency)}
                    </div>
                    <p style="margin: 0; color: #666; font-style: italic;">
                        ${pricing.description}
                    </p>
                </div>
                
                <div class="pricing-details">
                    <h6 style="color: #333; font-weight: bold; margin-bottom: 10px;">
                        <i class="fa fa-list-check"></i> Package Includes:
                    </h6>
                    <ul style="margin: 0; padding-left: 20px; color: #555;">
                        ${pricing.includes.map(item => `<li style="margin-bottom: 4px;">${item}</li>`).join('')}
                    </ul>
                </div>
                
                <div class="pricing-breakdown" style="margin-top: 15px; padding-top: 15px; border-top: 1px solid ${pricing.color}30;">
                    <div class="row">
                        <div class="col-md-6">
                            <small><strong>Base Fee:</strong> ${formatCurrency(pricing.base_cost)}</small>
                        </div>
                        <div class="col-md-6 text-right">
                            <small><strong>Payment Due:</strong> 
                                <span style="color: ${pricing.color}; font-weight: bold;">
                                    ${formatCurrency(pricing.base_cost)}
                                </span>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Remove existing pricing display
        $('#pricing-display').remove();
        
        // Add new pricing display after workflow preview
        $('#workflowPreview').after(pricingHtml);
        
        // Animate the pricing display
        $('#pricing-display').hide().fadeIn(500);
        
        // Update any hidden form fields for pricing
        updatePricingFormFields(workflowKey, pricing);
    }
    
    function updatePricingFormFields(workflowKey, pricing) {
        // Remove existing pricing fields
        $('input[name="workflow_cost"]').remove();
        $('input[name="base_fee"]').remove();
        
        // Add new hidden fields to the form
        $('#formaddpa').append(`
            <input type="hidden" name="workflow_cost" value="${pricing.base_cost}">
            <input type="hidden" name="base_fee" value="${pricing.base_cost}">
            <input type="hidden" name="pricing_breakdown" value='${JSON.stringify(pricing)}'>
        `);
        
        console.log(`Pricing updated for ${workflowKey}: ${formatCurrency(pricing.base_cost)}`);
    }
    
function toggleWorkflowFields(workflowKey) {
    $('.workflow-fields').hide();
    $('#workflowSpecificFields').hide();
    
    if (workflowKey === 'specialized') {
        $('.specialized-fields').show();
        $('#workflowSpecificFields').show();
        $('textarea[name="chief_complaint"]').attr('required', true);
    } else if (workflowKey === 'gcc') {
        $('.gcc-fields').show();
        $('#workflowSpecificFields').show();
        
        // Show fingerprint and photo capture for GCC workflow
        $('.fingerprint-container').closest('.form-group').show();
        $('.photo-upload-container').closest('.form-group').show();
        
        setTimeout(function() {
            $('.datepicker-appointment').datepicker('destroy').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
                startDate: 'today',
                daysOfWeekDisabled: [0],
                orientation: 'bottom auto',
                container: '#myModalpa',
                zIndexOffset: 9999
            });
            console.log('GCC appointment date picker re-initialized');
        }, 100);
    } else if (workflowKey === 'general') {
        $('.general-fields').show();
        $('#workflowSpecificFields').show();
        
        // Hide fingerprint and photo capture for General workflow
        $('.fingerprint-container').closest('.form-group').hide();
        $('.photo-upload-container').closest('.form-group').hide();
    }
    
    if (workflowKey !== 'specialized') {
        $('textarea[name="chief_complaint"]').removeAttr('required');
    }
    
    // Show/hide biometric requirements based on workflow
    if (workflowKey === 'gcc') {
        // Make fingerprint and photo mandatory for GCC
        $('#fingerprint_template').attr('data-required', 'true');
        $('#camera_image_data, input[name="file"]').attr('data-required', 'true');
        
        // Show biometric requirement message
        if (!$('#biometric-requirement-msg').length) {
            $('.fingerprint-container').before(`
                <div id="biometric-requirement-msg" class="alert alert-warning">
                    <i class="fa fa-exclamation-triangle"></i>
                    <strong>Required for GCC:</strong> Both fingerprint and photo capture are mandatory for GCC workflow patients.
                </div>
            `);
        }
    } else {
        // Remove biometric requirements for other workflows
        $('#fingerprint_template').removeAttr('data-required');
        $('#camera_image_data, input[name="file"]').removeAttr('data-required');
        $('#biometric-requirement-msg').remove();
    }
}
   
   function capitalizeFirst(str) {
       return str.charAt(0).toUpperCase() + str.slice(1);
   }
   
   // Payment summary function for checkout confirmation
   function generatePaymentSummary() {
       const selectedWorkflow = $('input[name="patient_workflow"]:checked').val();
       
       if (!selectedWorkflow) {
           return null;
       }
       
       const pricing = workflowPricing[selectedWorkflow];
       
       return {
           workflow_type: selectedWorkflow,
           workflow_name: pricing.name,
           base_cost: pricing.base_cost,
           currency: pricing.currency,
           total_amount: pricing.base_cost,
           payment_due: pricing.base_cost,
           includes: pricing.includes
       };
   }
   
   // Validate pricing before form submission
   function validatePricingSelection() {
       const selectedWorkflow = $('input[name="patient_workflow"]:checked').val();
       
       if (!selectedWorkflow) {
           alert('Please select a workflow type to see pricing and continue.');
           return false;
       }
       
       const pricing = workflowPricing[selectedWorkflow];
       const paymentSummary = generatePaymentSummary();
       
       // Show confirmation dialog with pricing
       const confirmMessage = `
           Please confirm your selection:
           
           Workflow: ${paymentSummary.workflow_name}
           Total Amount: ${formatCurrency(paymentSummary.total_amount)}
           
           Do you want to proceed with registration?
       `;
       
       return confirm(confirmMessage);
   }

   // =============================================
   // SECUGEN ADVANCED TROUBLESHOOTING INTEGRATION
   // =============================================
   
   var secugenConfig = {
       baseUrl: 'https://localhost:8443',
       httpUrl: 'http://localhost:8443',
       endpoints: {
           capture: '/SGIFPCapture',
           getInfo: '/SGIFPGetInfo',
           getVersion: '/SGIFPGetVersion'
       },
       serviceActive: false,
       quality: 50,
       timeout: 20000,
       lastError: null
   };

   function logDiagnostic(message, type = 'info') {
       const timestamp = new Date().toLocaleTimeString();
       const colorClass = type === 'error' ? 'text-danger' : type === 'success' ? 'text-success' : 'text-info';
       $("#diagnosticResults").append(
           `<div class="${colorClass}">[${timestamp}] ${message}</div>`
       );
       console.log(`[SecuGen] ${message}`);
       
       const diagnosticLines = $("#diagnosticResults div");
       if (diagnosticLines.length > 10) {
           diagnosticLines.first().remove();
       }
   }

   function testHttpsConnection() {
       logDiagnostic("Testing HTTPS connection to localhost:8443...");
       
       const xhr = new XMLHttpRequest();
       xhr.open('GET', secugenConfig.baseUrl + secugenConfig.endpoints.getInfo, true);
       xhr.timeout = 5000;
       
       xhr.onreadystatechange = function() {
           if (xhr.readyState === 4) {
               if (xhr.status === 200) {
                   logDiagnostic("✓ HTTPS connection successful!", 'success');
                   secugenConfig.serviceActive = true;
                   $("#scanFingerprint").prop('disabled', false);
                   $("#secugen_service_status").html('<div class="alert alert-success"><i class="fa fa-check"></i> SecuGen HTTPS service active</div>');
               } else if (xhr.status === 0) {
                   logDiagnostic("✗ HTTPS blocked - possibly CORS or SSL certificate issue", 'error');
                   suggestHttpsFix();
               } else {
                   logDiagnostic(`✗ HTTPS failed with status: ${xhr.status}`, 'error');
               }
           }
       };
       
       xhr.onerror = function() {
           logDiagnostic("✗ HTTPS connection error - network or SSL issue", 'error');
           suggestHttpsFix();
       };
       
       xhr.ontimeout = function() {
           logDiagnostic("✗ HTTPS connection timeout", 'error');
       };
       
       xhr.send();
   }

   function testHttpConnection() {
       logDiagnostic("Testing HTTP connection to localhost:8443...");
       
       $.ajax({
           url: secugenConfig.httpUrl + secugenConfig.endpoints.getInfo,
           type: 'GET',
           timeout: 5000,
           success: function(data) {
               logDiagnostic("✓ HTTP connection successful!", 'success');
               secugenConfig.baseUrl = secugenConfig.httpUrl;
               secugenConfig.serviceActive = true;
               $("#scanFingerprint").prop('disabled', false);
               $("#secugen_service_status").html('<div class="alert alert-success"><i class="fa fa-check"></i> SecuGen HTTP service active</div>');
           },
           error: function(xhr) {
               if (xhr.status === 0) {
                   logDiagnostic("✗ HTTP blocked - possibly CORS issue", 'error');
               } else {
                   logDiagnostic(`✗ HTTP failed with status: ${xhr.status}`, 'error');
               }
           }
       });
   }

   function suggestHttpsFix() {
       const suggestions = `
           <div class="alert alert-warning" style="font-size: 11px; margin-top: 10px;">
               <strong>HTTPS Connection Issues - Try these fixes:</strong><br>
               1. <strong>Accept SSL Certificate:</strong> Visit <a href="https://localhost:8443/SGIFPGetInfo" target="_blank">https://localhost:8443/SGIFPGetInfo</a> and accept the security warning<br>
               2. <strong>Run browser as Administrator</strong><br>
               3. <strong>Disable CORS temporarily:</strong> Start Chrome with --disable-web-security --user-data-dir=temp<br>
               4. <strong>Check Windows Firewall</strong> - ensure port 8443 is allowed<br>
               5. <strong>Try the Manual Capture button</strong> below
           </div>
       `;
       $("#secugen_service_status").html(suggestions);
   }

   function manualFingerprintCapture() {
       logDiagnostic("Attempting manual fingerprint capture...");
       
       const captureUrl = secugenConfig.baseUrl + secugenConfig.endpoints.capture;
       
       $("#fingerprintStatus").html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Manual capture - place finger on scanner...</div>');
       $("#manualCapture").prop('disabled', true).text('Scanning...');

       const xhr = new XMLHttpRequest();
       xhr.open('POST', captureUrl, true);
       xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
       xhr.timeout = secugenConfig.timeout;
       
       xhr.onreadystatechange = function() {
           if (xhr.readyState === 4) {
               $("#manualCapture").prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Capture');
               
               if (xhr.status === 200) {
                   try {
                       const result = JSON.parse(xhr.responseText);
                       logDiagnostic("✓ Manual capture successful!", 'success');
                       handleFingerprintResult(result);
                   } catch (e) {
                       logDiagnostic("✗ Invalid response format", 'error');
                       $("#fingerprintStatus").html('<div class="alert alert-danger">Invalid response from scanner</div>');
                   }
               } else {
                   logDiagnostic(`✗ Manual capture failed: HTTP ${xhr.status}`, 'error');
                   $("#fingerprintStatus").html(`<div class="alert alert-danger">Capture failed: HTTP ${xhr.status}</div>`);
               }
           }
       };
       
       xhr.onerror = function() {
           $("#manualCapture").prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Capture');
           logDiagnostic("✗ Manual capture network error", 'error');
           $("#fingerprintStatus").html('<div class="alert alert-danger">Network error during capture</div>');
       };
       
       xhr.ontimeout = function() {
           $("#manualCapture").prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Capture');
           logDiagnostic("✗ Manual capture timeout", 'error');
           $("#fingerprintStatus").html('<div class="alert alert-danger">Capture timeout</div>');
       };
       
       const postData = `Quality=${secugenConfig.quality}&Timeout=${secugenConfig.timeout}&WSQCompression=2.25`;
       xhr.send(postData);
   }

   function handleFingerprintResult(result) {
       if (result.ErrorCode === 0) {
           if (result.BMPBase64) {
               $("#fingerprintImage").attr("src", "data:image/bmp;base64," + result.BMPBase64);
               $("#fingerprint_image").val(result.BMPBase64);
           }
           
           if (result.TemplateBase64) {
               $("#fingerprint_template").val(result.TemplateBase64);
           }
           
           let successMsg = '<div class="alert alert-success"><i class="fa fa-check"></i> Fingerprint captured successfully!</div>';
           if (result.SerialNumber) {
               successMsg += `<div class="alert alert-info"><small>Device: ${result.Manufacturer || 'SecuGen'} ${result.Model || ''} (SN: ${result.SerialNumber})</small></div>`;
           }
           
           $("#fingerprintStatus").html(successMsg);
           $("#clearFingerprint").show();
           
           logDiagnostic(`✓ Template: ${result.TemplateBase64 ? result.TemplateBase64.length : 0} chars, Image: ${result.BMPBase64 ? result.BMPBase64.length : 0} chars`, 'success');
           
       } else {
           let errorMsg = 'Fingerprint capture error';
           switch(result.ErrorCode) {
               case 1: errorMsg = 'Reader not found or driver error'; break;
               case 2: errorMsg = 'Function failed - check reader connection'; break;
               case 3: errorMsg = 'Invalid parameters'; break;
               case 5:
               case 6:
               case 7: errorMsg = 'Driver DLL load failed'; break;
               default: 
                   errorMsg = result.ErrorDescription || `Error code: ${result.ErrorCode}`;
           }
           
           $("#fingerprintStatus").html(`<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ${errorMsg}</div>`);
           logDiagnostic(`✗ ${errorMsg}`, 'error');
       }
   }

   function captureFingerprint() {
       if (!secugenConfig.serviceActive) {
           $("#fingerprintStatus").html('<div class="alert alert-warning">Service not detected. Try Manual Capture or check diagnostics above.</div>');
           return;
       }
       
       const captureUrl = secugenConfig.baseUrl + secugenConfig.endpoints.capture;
       
       $("#fingerprintStatus").html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Place finger on scanner...</div>');
       $("#scanFingerprint").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Scanning...');

       $.ajax({
           url: captureUrl,
           type: 'POST',
           data: {
               Quality: secugenConfig.quality,
               Timeout: secugenConfig.timeout,
               WSQCompression: 2.25
           },
           timeout: secugenConfig.timeout + 5000,
           success: function(response) {
               $("#scanFingerprint").prop('disabled', false).html('<i class="fa fa-fingerprint"></i> <?php echo $this->lang->line('scan_fingerprint'); ?>');
               
               const result = typeof response === 'string' ? JSON.parse(response) : response;
               handleFingerprintResult(result);
           },
           error: function(xhr, status, error) {
               $("#scanFingerprint").prop('disabled', false).html('<i class="fa fa-fingerprint"></i> <?php echo $this->lang->line('scan_fingerprint'); ?>');
               
               let errorMsg = 'Capture failed';
               if (status === 'timeout') {
                   errorMsg = 'Scanner timeout';
               } else if (xhr.status === 0) {
                   errorMsg = 'Connection blocked - try Manual Capture';
               } else {
                   errorMsg = `HTTP ${xhr.status}: ${error}`;
               }
               
               $("#fingerprintStatus").html(`<div class="alert alert-danger">${errorMsg}</div>`);
               logDiagnostic(`✗ ${errorMsg}`, 'error');
           }
       });
   }

   function clearFingerprint() {
       $("#fingerprint_template").val('');
       $("#fingerprint_image").val('');
       $("#fingerprintImage").attr("src", "./Images/PlaceFinger.bmp");
       $("#fingerprintStatus").html('');
       $("#clearFingerprint").hide();
       logDiagnostic("Fingerprint data cleared");
   }

   // SecuGen Event bindings
   $("#testConnection").on('click', function() {
       $("#diagnosticResults").html('');
       testHttpsConnection();
       setTimeout(testHttpConnection, 2000);
   });

   $("#testHttps").on('click', testHttpsConnection);
   $("#testHttp").on('click', testHttpConnection);
   
   $("#openSecuGenDemo").on('click', function() {
       window.open('https://webapi.secugen.com/Demo1', '_blank');
       logDiagnostic("Opened SecuGen official demo - test if it works there first");
   });

   $("#scanFingerprint").on('click', function(e) {
      e.preventDefault();
      captureFingerprint();
   });

   $("#manualCapture").on('click', function(e) {
      e.preventDefault();
      manualFingerprintCapture();
   });

   $("#clearFingerprint").on('click', function(e) {
      e.preventDefault();
      clearFingerprint();
   });

   // Initialize service detection
   $("#secugen_service_status").html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Initializing SecuGen service detection...</div>');
   
   setTimeout(function() {
       logDiagnostic("Starting SecuGen service detection...");
       testHttpsConnection();
       setTimeout(function() {
           if (!secugenConfig.serviceActive) {
               testHttpConnection();
           }
       }, 3000);
   }, 1000);

   // =============================================
   // CAMERA FUNCTIONALITY
   // =============================================
   
   let videoStream = null;

   async function startCamera() {
       try {
           const stream = await navigator.mediaDevices.getUserMedia({ video: true });
           const videoElement = document.getElementById('camera_stream');
           videoElement.srcObject = stream;
           videoStream = stream;
           $('#camera_container').show();
           $('#capturePhotoBtn').prop('disabled', true);
       } catch (err) {
           console.error('Error accessing camera:', err);
           alert('<?php echo $this->lang->line("error_accessing_camera"); ?>');
       }
   }

   function stopCamera() {
       if (videoStream) {
           videoStream.getTracks().forEach(track => track.stop());
           videoStream = null;
           $('#camera_container').hide();
           $('#capturePhotoBtn').prop('disabled', false);
       }
   }

   function capturePhoto() {
       const video = document.getElementById('camera_stream');
       const canvas = document.getElementById('photo_canvas');
       const context = canvas.getContext('2d');

       context.drawImage(video, 0, 0, canvas.width, canvas.height);

       const capturedImage = document.getElementById('captured_image');
       capturedImage.src = canvas.toDataURL('image/jpeg');
       capturedImage.style.display = 'block';

       if (!document.getElementById('camera_image_data')) {
           $('#formaddpa').append('<input type="hidden" name="camera_image" id="camera_image_data">');
       }
       document.getElementById('camera_image_data').value = canvas.toDataURL('image/jpeg');

       stopCamera();
       
       const photoContainer = $('#camera_container').closest('.form-group');
       photoContainer.append('<div class="alert alert-success photo-success-msg" style="margin-top: 10px;"><i class="fa fa-check"></i> Photo captured successfully!</div>');
       
       setTimeout(function() {
           $('.photo-success-msg').fadeOut();
       }, 3000);
   }

   // Camera event bindings
   $('#capturePhotoBtn').on('click', function() {
       startCamera();
   });
   
   $('#takePhotoBtn').on('click', function() {
       capturePhoto();
   });

   $('#cancelPhotoBtn').on('click', function() {
       stopCamera();
   });

   // =============================================
   // ENHANCED FORM SUBMISSION WITH WORKFLOW ROUTING
   // =============================================
   
   $("#formaddpa").on('submit', function(e) {
       let clicked_submit_btn = $(this).find(':submit');
       e.preventDefault();
       
       // Validate workflow and pricing selection
       if (!validatePricingSelection()) {
           return false;
       }
       
       // Clear any existing pricing display
       $('#pricing-display').remove();
       
       // Validate workflow selection
       const selectedWorkflow = $('input[name="patient_workflow"]:checked').val();
       if (!selectedWorkflow) {
           alert('Please select a patient workflow before proceeding.');
           return false;
       }
       
       // Validate workflow-specific requirements
       if (selectedWorkflow === 'specialized') {
           const chiefComplaint = $('textarea[name="chief_complaint"]').val().trim();
           if (!chiefComplaint) {
               alert('Chief complaint is required for specialized workflow.');
               $('textarea[name="chief_complaint"]').focus();
               return false;
           }
       }
       
       // Validate GCC biometric requirements
    if (selectedWorkflow === 'gcc') {
        const hasFingerprint = $("#fingerprint_template").val().trim() !== '';
        const hasPhoto = $('#camera_image_data').val() || $('input[name="file"]')[0].files.length > 0;
        
        if (!hasFingerprint) {
            alert('Fingerprint capture is required for GCC workflow. Please scan your fingerprint before proceeding.');
            // Scroll to fingerprint section
            $('.fingerprint-container')[0].scrollIntoView({ behavior: 'smooth' });
            return false;
        }
        
        if (!hasPhoto) {
            alert('Photo capture is required for GCC workflow. Please capture a photo or upload an image before proceeding.');
            // Scroll to photo section
            $('.photo-upload-container')[0].scrollIntoView({ behavior: 'smooth' });
            return false;
        }
    }
       
       // Validate dates if provided
       const dobValue = $('.patient_dob').val();
       const tpaValidityValue = $('.datepicker-tpa').val();
       const appointmentDateValue = $('.datepicker-appointment').val();
       
       if (dobValue && !isValidDate(dobValue)) {
           alert('Please select a valid date of birth.');
           $('.patient_dob').focus();
           return false;
       }
       
       if (tpaValidityValue && !isValidDate(tpaValidityValue)) {
           alert('Please select a valid TPA validity date.');
           $('.datepicker-tpa').focus();
           return false;
       }
       
       if (appointmentDateValue && !isValidDate(appointmentDateValue)) {
           alert('Please select a valid appointment date.');
           $('.datepicker-appointment').focus();
           return false;
       }
       
       // Add pricing information to form data
       const paymentSummary = generatePaymentSummary();
       console.log('Submitting with payment summary:', paymentSummary);
       
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/addpatient',
           type: "POST",
           data: new FormData(this),
           dataType: 'json',
           contentType: false,
           cache: false,
           processData: false,
           beforeSend: function() {
               clicked_submit_btn.button('loading');
           },
           success: function (data) {
               if (data.status == "fail") {
                   let message = "";
                   $.each(data.error, function (index, value) {
                       message += value;
                   });
                   errorMsg(message);
               } else {
                   successMsg(data.message);
                   $("#myModalpa").modal('toggle');
                   
                   // Route patient based on workflow
                   routePatientByWorkflow(data.id, selectedWorkflow);
                   
                   // Log successful submission with fingerprint data
                   const hasFingerprint = $("#fingerprint_template").val().length > 0;
                   logDiagnostic(`Patient saved successfully ${hasFingerprint ? 'with' : 'without'} fingerprint data`, 'success');

                   // Reload the patient list
                   if (typeof table !== 'undefined') {
                       table.ajax.reload();
                   } else {
                       window.location.reload(true);
                   }
               }
               clicked_submit_btn.button('reset');
           },
           error: function(xhr) {
               alert('<?php echo $this->lang->line("error_occurred_please_try_again"); ?>');
               clicked_submit_btn.button('reset');
               logDiagnostic("Form submission failed", 'error');
           },
           complete: function() {
               clicked_submit_btn.button('reset');
           }
       });
   });
   
   // Utility function to validate date format
   function isValidDate(dateString) {
       const regex = /^\d{4}-\d{2}-\d{2}$/;
       if (!regex.test(dateString)) return false;
       
       const date = new Date(dateString);
       const timestamp = date.getTime();
       
       if (typeof timestamp !== 'number' || Number.isNaN(timestamp)) return false;
       
       return dateString === date.toISOString().split('T')[0];
   }
   
   // Workflow-based patient routing
   function routePatientByWorkflow(patientId, workflowType) {
       const workflow = workflows[workflowType];
       
       switch(workflowType) {
           case 'gcc':
               routeGCCWorkflow(patientId, workflow);
               break;
           case 'general':
               routeGeneralWorkflow(patientId, workflow);
               break;
           case 'specialized':
               routeSpecializedWorkflow(patientId, workflow);
               break;
       }
   }
   
   function routeGCCWorkflow(patientId, workflow) {
       console.log('Initiating GCC workflow for patient:', patientId);
       
       const needsTriage = confirm('Would you like to include triage screening for this GCC patient?');
       
       if (needsTriage) {
           createTriageAppointment(patientId, 'gcc', function() {
               scheduleGCCServices(patientId, ['lab', 'radiology', 'consultation']);
           });
       } else {
           scheduleGCCServices(patientId, ['lab', 'radiology', 'consultation']);
       }
   }
   
   function routeGeneralWorkflow(patientId, workflow) {
       console.log('Initiating General workflow for patient:', patientId);
       showServiceSelectionModal(patientId, workflow.optional_steps);
   }
   
   function routeSpecializedWorkflow(patientId, workflow) {
       console.log('Initiating Specialized workflow for patient:', patientId);
       
       const chiefComplaint = $('textarea[name="chief_complaint"]').val();
       
       createTriageAppointment(patientId, 'specialized', function(triageId) {
           createConsultationAppointment(patientId, triageId, function() {
               showOptionalServicesModal(patientId, workflow.optional_steps);
           });
       }, chiefComplaint);
   }

   // AGE CALCULATION ENHANCEMENTS
   $('.patient_age_year, .patient_age_month, .patient_age_day').on('input', function() {
       const years = parseInt($('.patient_age_year').val()) || 0;
       const months = parseInt($('.patient_age_month').val()) || 0;
       const days = parseInt($('.patient_age_day').val()) || 0;
       
       if (years > 0 || months > 0 || days > 0) {
           const today = new Date();
           const birthDate = new Date(today.getFullYear() - years, today.getMonth() - months, today.getDate() - days);
           
           const formattedDate = birthDate.getFullYear() + '-' + 
                              String(birthDate.getMonth() + 1).padStart(2, '0') + '-' + 
                              String(birthDate.getDate()).padStart(2, '0');
           
           $('.patient_dob').datepicker('setDate', birthDate);
           console.log(`DOB calculated from age: ${formattedDate}`);
       }
   });

   // Global functions for external access
   window.captureFingerprint = captureFingerprint;
   window.clearFingerprint = clearFingerprint;
   window.manualCapture = manualFingerprintCapture;
   window.routePatientByWorkflow = routePatientByWorkflow;
   
   // Debug functions
   window.debugWorkflowSystem = function() {
       console.log('=== Workflow System Debug Info ===');
       console.log('Available workflows:', workflows);
       console.log('Selected workflow:', $('input[name="patient_workflow"]:checked').val());
       console.log('Current form data:', $('#formaddpa').serialize());
       
       console.log('=== Date Picker Status ===');
       console.log('DOB value:', $('.patient_dob').val());
       console.log('TPA validity value:', $('.datepicker-tpa').val());
       console.log('Appointment date value:', $('.datepicker-appointment').val());
       console.log('DOB picker initialized:', $('.patient_dob').data('datepicker') ? 'Yes' : 'No');
       console.log('TPA picker initialized:', $('.datepicker-tpa').data('datepicker') ? 'Yes' : 'No');
       console.log('Appointment picker initialized:', $('.datepicker-appointment').data('datepicker') ? 'Yes' : 'No');
   };

   window.testDatePickers = function() {
       console.log('=== Testing Date Picker Functionality ===');
       
       $('.patient_dob').datepicker('show');
       console.log('DOB picker should be visible now');
       
       setTimeout(function() {
           $('.patient_dob').datepicker('hide');
           
           $('.datepicker-tpa').datepicker('show');
           console.log('TPA picker should be visible now');
           
           setTimeout(function() {
               $('.datepicker-tpa').datepicker('hide');
               
               if ($('.datepicker-appointment').is(':visible')) {
                   $('.datepicker-appointment').datepicker('show');
                   console.log('Appointment picker should be visible now');
                   
                   setTimeout(function() {
                       $('.datepicker-appointment').datepicker('hide');
                   }, 2000);
               }
           }, 2000);
       }, 2000);
   };

   window.reinitializeDatePickers = function() {
       console.log('Reinitializing all date pickers...');
       initializeDatePickers();
   };
});

// =============================================
// STANDARD PATIENT MANAGEMENT FUNCTIONS
// =============================================

// Edit form submission
$(document).ready(function(e) {
   $("#formeditpa").on('submit', (function(e) {
       $("#formeditpabtn").button('loading');
       e.preventDefault();
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/update',
           type: "POST",
           data: new FormData(this),
           dataType: 'json',
           contentType: false,
           cache: false,
           processData: false,
           success: function(data) {
               if (data.status == "fail") {
                   var message = "";
                   $.each(data.error, function(index, value) {
                       message += value;
                   });
                   errorMsg(message);
               } else {
                   successMsg(data.message);
                   window.location.reload(true);
               }
               $("#formeditpabtn").button('reset');
           },
           error: function() {
               $("#formeditpabtn").button('reset');
           }
       });
   }));
});

// Delete functions
function delete_record(id) {
   if (confirm(<?php echo "'" . $this->lang->line('patient_delete_alert_message') . "'"; ?>)) {
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/deletePatient',
           type: "POST",
           data: { delid: id },
           dataType: 'json',
           success: function(data) {
               successMsg(<?php echo "'" . $this->lang->line('delete_message') . "'"; ?>);
               $("#myModal").modal("hide");
               table.ajax.reload();
           }
       })
   }
}

function patient_deactive(id) {
   if (confirm(<?php echo "'" . $this->lang->line('are_you_sure_to_deactivate_account') . "'"; ?>)) {
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/deactivePatient',
           type: "POST",
           data: { id: id },
           dataType: 'json',
           success: function(data) {
               if (data.status == "fail") {
                   var message = (data.message);
                   errorMsg(message);
               } else {
                   successMsg(<?php echo "'" . $this->lang->line('record_disable') . "'"; ?>);
                   window.getpatientData(id);
               }
           }
       })
   }
}

function patient_active(id) {
   if (confirm(<?php echo "'" . $this->lang->line('are_you_sure_to_active_account') . "'"; ?>)) {
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/activePatient',
           type: "POST",
           data: { activeid: id },
           dataType: 'json',
           success: function(data) {
               successMsg(<?php echo "'" . $this->lang->line('record_active') . "'"; ?>);
               window.getpatientData(id);
           }
       })
   }
}

// Bulk delete
$(document).on('click', '.delete_selected', function() {
   var $this = $(this);
   let obj = [];
   $('input:checkbox.enable_delete').each(function() {
       (this.checked ? obj.push($(this).val()) : "");
   });
   if (confirm('<?php echo $this->lang->line('patient_delete_alert_message'); ?>')) {
       $.ajax({
           url: base_url + 'admin/patient/bulk_delete',
           type: "POST",
           dataType: 'json',
           data: { 'delete_id': obj },
           beforeSend: function() {
               $this.button('loading');
           },
           success: function(res) {
               $this.button('reset');
               if (res.status == 1) {
                   successMsg(res.msg);
                   table.ajax.reload();
               } else {
                   var message = "";
                   $.each(res.error, function(index, value) {
                       message += value;
                   });
                   errorMsg(message);
               }
           },
           error: function(xhr) {
               alert("<?php echo $this->lang->line('error_occured_please_try_again'); ?>");
               $this.button('reset');
           },
           complete: function() {
               $this.button('reset');
           }
       });
   }
});

// Patient modal handlers
$(".newpatient").click(function() {
   $('#formaddpa').trigger("reset");
   $(".dropify-clear").trigger("click");
});

$(".modalbtnpatient").click(function() {
   $('#formaddpa').trigger("reset");
   $(".dropify-clear").trigger("click");
});

$("input[name='checkAll']").click(function() {
   $("input[name='patient[]']").not(this).prop('checked', this.checked);
});

// Age calculation for edit form
$(".editpatient_dob").on('changeDate', function(event, date) {
   var birth_date = $(".editpatient_dob").val();
   $.ajax({
       url: '<?php echo base_url(); ?>admin/patient/getpatientage',
       type: "POST",
       dataType: "json",
       data: { birth_date: birth_date },
       success: function(data) {
           $('.patient_age_year').val(data.year);
           $('.patient_age_month').val(data.month);
           $('.patient_age_day').val(data.day);
       }
   });
});

// Barcode functions
function addBarcodeButtons(patientId, patientName) {
   setTimeout(function() {
       const barcodeImg = $('#getbarcode');
       const showBarcodeSection = $('#show_barcode');
       
       if (barcodeImg.length && barcodeImg.attr('src') && showBarcodeSection.is(':visible') && !barcodeImg.attr('src').includes('no_image')) {
           const barcodeImageSrc = barcodeImg.attr('src');
           
           $('#barcode-buttons').remove();
           
           const barcodeButtons = `
               <li id="barcode-buttons" style="margin-top: 10px; padding: 8px; border: 1px solid #e0e0e0; border-radius: 4px; background-color: #f9f9f9;">
                   <b><i class="fa fa-barcode"></i> Barcode Actions</b>
                   <div style="margin-top: 8px;">
                       <div class="btn-group" role="group">
                           <button type="button" class="btn btn-primary btn-xs" onclick="printBarcode('${patientId}', '${patientName}')" title="Print Barcode Label">
                               <i class="fa fa-print"></i> Print
                           </button>
                           <button type="button" class="btn btn-success btn-xs" onclick="downloadBarcode('${patientId}', '${patientName}', '${barcodeImageSrc}')" title="Download Barcode">
                               <i class="fa fa-download"></i> Download
                           </button>
                       </div>
                       <div style="margin-top: 5px;">
                           <small class="text-muted">
                               <i class="fa fa-info-circle"></i> Print barcode label for patient identification
                           </small>
                       </div>
                   </div>
               </li>
           `;
           
           showBarcodeSection.after(barcodeButtons);
       }
   }, 1500);
}

function printBarcode(patientId, patientName) {
   console.log('Attempting to print barcode for patient:', patientId);
   
   $.ajax({
       url: base_url + 'admin/admin/printPatientBarcode/' + patientId,
       type: 'GET',
       dataType: 'json',
       beforeSend: function() {
           $('button[onclick*="printBarcode(\'' + patientId + '\'"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Printing...');
       },
       success: function(response) {
           console.log('Response received:', response);
           
           if (response && response.status === 'success') {
               console.log('Success response, trying to open popup...');
               
               if (typeof popup === 'function') {
                   console.log('Using popup function');
                   popup(response.page);
               } else {
                   console.log('Popup function not found, using window.open');
                   var printWindow = window.open('', '_blank', 'width=800,height=600');
                   printWindow.document.write(response.page);
                   printWindow.document.close();
                   printWindow.focus();
                   
                   setTimeout(function() {
                       printWindow.print();
                   }, 1000);
               }
           } else {
               console.error('Error in response:', response);
               alert('Server Error: ' + (response ? (response.error || response.message) : 'Unknown error'));
           }
       },
       error: function(xhr, status, error) {
           console.error('AJAX Error Details:');
           console.error('Status:', status);
           console.error('Error:', error);
           console.error('Response Text:', xhr.responseText);
           console.error('Status Code:', xhr.status);
           
           var errorMessage = 'Print Error: ';
           if (xhr.status === 0) {
               errorMessage += 'Network connection failed';
           } else if (xhr.status === 404) {
               errorMessage += 'Print function not found (404)';
           } else if (xhr.status === 500) {
               errorMessage += 'Server error (500)';
           } else {
               errorMessage += error || 'Unknown error';
           }
           
           alert(errorMessage);
       },
       complete: function() {
           setTimeout(function() {
               $('button[onclick*="printBarcode"]').prop('disabled', false).html('<i class="fa fa-print"></i> Print');
           }, 1000);
       }
   });
}

function downloadBarcode(patientId, patientName, barcodeImageSrc) {
   const link = document.createElement('a');
   link.href = barcodeImageSrc;
   link.download = `barcode_${patientId}_${patientName.replace(/\s+/g, '_')}.png`;
   link.target = '_blank';
   document.body.appendChild(link);
   link.click();
   document.body.removeChild(link);
   
   if (typeof successMsg === 'function') {
       successMsg('Barcode download started');
   }
}

// Helper functions
function addappointmentModal(patient_id = '', modalid) {
   $.ajax({
       url: '<?php echo base_url(); ?>admin/patient/getpatientDetails',
       type: "POST",
       data: {id: patient_id},
       dataType: 'json',
       success: function (data) {
           const option = new Option(data.patient_name + " (" + data.id + ")", data.id, true, true);
           $(".patient_list_ajax").append(option).trigger('change');
           $("#" + modalid).modal('show');
           holdModal(modalid);
       }
   });
}

// Show workflow guide modal
window.showWorkflowGuide = function() {
   $('#workflowGuideModal').modal('show');
};

// Success and error message functions
function successMsg(message) {
   $.notify({
       message: message
   }, {
       type: 'success',
       allow_dismiss: true,
       newest_on_top: false,
       timer: 1000,
       animate: {
           enter: 'animated bounceInDown',
           exit: 'animated bounceOutUp'
       }
   });
}

function errorMsg(message) {
   $.notify({
       message: message
   }, {
       type: 'danger',
       allow_dismiss: true,
       newest_on_top: false,
       timer: 1000,
       animate: {
           enter: 'animated shake',
           exit: 'animated bounceOutUp'
       }
   });
}

// Print and Export Functions
function printDiv() {
   document.getElementById("print").style.display = "none";
   document.getElementById("btnExport").style.display = "none";
   var divElements = document.getElementById('visit_report').innerHTML;
   var oldPage = document.body.innerHTML;
   document.body.innerHTML =
       "<html><head><title>Patient Bill Report</title></head><body>" +
       divElements + "</body>";
   window.print();
   document.body.innerHTML = oldPage;
   location.reload(true);
}

// Excel export functionality
var tablesToExcel = (function() {
   var uri = 'data:application/vnd.ms-excel;base64,',
       template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets>',
       templateend = '</x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head>',
       body = '<body>',
       tablevar = '<table>{table',
       tablevarend = '}</table>',
       bodyend = '</body></html>',
       worksheet = '<x:ExcelWorksheet><x:Name>',
       worksheetend = '</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet>',
       worksheetvar = '{worksheet',
       worksheetvarend = '}',
       base64 = function(s) {
           return window.btoa(unescape(encodeURIComponent(s)))
       },
       format = function(s, c) {
           return s.replace(/{(\w+)}/g, function(m, p) {
               return c[p];
           })
       },
       wstemplate = '',
       tabletemplate = '';

   return function(table, name, filename) {
       var tables = table;
       for (var i = 0; i < tables.length; ++i) {
           wstemplate += worksheet + worksheetvar + i + worksheetvarend + worksheetend;
           tabletemplate += tablevar + i + tablevarend;
       }

       var allTemplate = template + wstemplate + templateend;
       var allWorksheet = body + tabletemplate + bodyend;
       var allOfIt = allTemplate + allWorksheet;
       var ctx = {};
       for (var j = 0; j < tables.length; ++j) {
           ctx['worksheet' + j] = name[j];
       }

       for (var k = 0; k < tables.length; ++k) {
           var exceltable;
           if (!tables[k].nodeType) exceltable = document.getElementById(tables[k]);
           ctx['table' + k] = exceltable.innerHTML;
       }

       window.location.href = uri + base64(format(allOfIt, ctx));
   }
})();

// System status and debug console
console.log(`
=== Enhanced Patient Registration System ===

🏥 WORKFLOW FEATURES:
✓ GCC Workflow - Structured health screening with appointment booking
✓ General Workflow - Flexible service selection  
✓ Specialized Workflow - Priority care with mandatory triage
✓ Dynamic form fields based on workflow selection
✓ Integrated appointment scheduling and routing

📅 DATE PICKER FEATURES:
✓ Bootstrap DatePicker integration with proper modal support
✓ DOB picker - restricts future dates, auto-calculates age
✓ TPA validity picker - restricts past dates
✓ GCC appointment picker - excludes Sundays, future dates only
✓ Proper z-index handling for Bootstrap modals
✓ Auto-sync between DOB and age fields (both directions)

🔍 ADVANCED SEARCH FEATURES:
✓ Real-time DataTable search with server-side processing
✓ Workflow-based filtering (GCC, General, Specialized)
✓ Gender and age range filters
✓ Date range filtering for registration dates
✓ Fingerprint status filtering (with/without)
✓ Advanced column rendering with workflow badges
✓ Inline search functionality with custom filters

🔐 SECUGEN FINGERPRINT INTEGRATION:
✓ Advanced troubleshooting and diagnostics panel
✓ HTTPS/HTTP connection testing
✓ Manual capture fallback methods
✓ Real-time service status monitoring
✓ Template and image storage
✓ Verification capabilities

📸 CAMERA FUNCTIONALITY:
✓ Live camera capture for patient photos
✓ Canvas-based image processing
✓ Base64 encoding for form submission
✓ Success notifications and error handling

💡 DEBUGGING COMMANDS:
- debugWorkflowSystem() - Show workflow and date picker status
- testDatePickers() - Test all date picker functionality  
- reinitializeDatePickers() - Manually reinitialize date pickers

The system now provides comprehensive patient registration with:
- Workflow-driven patient journeys
- Advanced search and filtering
- Biometric integration
- Photo capture capabilities
- Real-time validation and routing
   `);
</script>

<!-- Enhanced CSS for workflow features -->
<style>
/* Workflow-specific styling */
.workflow-radio {
   transition: all 0.3s ease;
}

.workflow-radio:hover {
   background-color: #f5f5f5;
   border-color: #337ab7 !important;
}

.workflow-radio input[type="radio"]:checked + strong {
   color: #337ab7;
}

.workflow-cost {
   float: right;
   font-weight: bold;
}

.workflow-fields {
   margin-top: 20px;
}

.step-status {
   margin: 5px 0;
   padding: 5px 0;
}

.step-status .step-name {
   display: inline-block;
   width: 100px;
   font-weight: bold;
}

/* Biometric section styling */
.fingerprint-capture-section,
.camera-capture-section {
   border: 1px solid #ddd;
   padding: 15px;
   border-radius: 5px;
   background-color: #fafafa;
}

#fingerprint_container,
#camera_container {
   min-height: 250px;
   display: flex;
   flex-direction: column;
   justify-content: center;
   align-items: center;
}

.fingerprint-actions,
.camera-controls {
   margin-top: 15px;
}

.fingerprint-actions button,
.camera-controls button {
   margin: 0 5px;
}

/* Status badges */
.label {
   font-size: 0.9em;
   padding: 4px 8px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
   .workflow-radio {
       margin-bottom: 10px;
       padding: 10px;
   }
   
   .workflow-cost {
       float: none;
       display: block;
       margin-top: 5px;
   }
   
   .btn-group .btn {
       padding: 2px 6px;
       font-size: 0.8em;
       margin: 1px;
   }
   
   .step-status .step-name {
       width: 80px;
       font-size: 0.9em;
   }
   
   #fingerprint_container,
   #camera_container {
       min-height: 200px;
   }
}

/* Alert styling */
#alert-container {
   position: fixed;
   top: 20px;
   right: 20px;
   z-index: 9999;
   width: 300px;
}

/* Panel styling improvements */
.panel-heading h4,
.panel-heading h5 {
   margin: 0;
}

.checkbox-group {
   margin-top: 10px;
}

.checkbox-inline {
   margin-right: 15px;
   margin-bottom: 5px;
}

/* DataTable enhancements */
.dataTables_wrapper .dataTables_filter {
   float: right;
   text-align: right;
}

.dataTables_wrapper .dataTables_length {
   float: left;
}

/* Workflow info panel */
#workflow-info-panel {
   border-left: 4px solid #f0ad4e;
   margin-top: 15px;
}

/* Modal improvements */
.modal-lg {
   width: 95%;
   max-width: 1200px;
}

.modal-body {
   max-height: 70vh;
   overflow-y: auto;
}

/* Form validation styling */
.form-group.has-error .form-control {
   border-color: #a94442;
}

.form-group.has-success .form-control {
   border-color: #3c763d;
}

/* Loading state */
.btn[disabled] {
   opacity: 0.6;
   cursor: not-allowed;
}

/* Workflow restriction modal */
#workflowRestrictionModal .modal-header {
   background-color: #f0ad4e;
   color: white;
}

#workflowRestrictionModal .step-status {
   border-bottom: 1px solid #eee;
   padding: 8px 0;
}

#workflowRestrictionModal .step-status:last-child {
   border-bottom: none;
}
</style>
<style>
/* Ensure biometric fields are visible by default but can be hidden */
.fingerprint-container,
.photo-upload-container {
    display: block;
}

/* Hide biometric fields initially */
.fingerprint-container:not(.gcc-visible),
.photo-upload-container:not(.gcc-visible) {
    display: none;
}

/* Show biometric fields when GCC is selected */
.gcc-selected .fingerprint-container,
.gcc-selected .photo-upload-container {
    display: block !important;
}

/* Biometric requirement message styling */
#biometric-requirement-msg {
    margin-bottom: 15px;
    border-left: 4px solid #f0ad4e;
}
/* Fix for modal display issues */
.modal {
    z-index: 1050 !important;
}

.modal-backdrop {
    z-index: 1040 !important;
}

.modal.fade.in {
    display: block !important;
}

.modal-dialog {
    margin: 30px auto;
}

.pup100 {
    width: 90%;
    max-width: 1000px;
}

/* Ensure modal content is visible */
.modal-content {
    background-color: #fff;
    border-radius: 6px;
    box-shadow: 0 3px 9px rgba(0,0,0,.5);
}

/* Fix for loading state */
.modal-body {
    max-height: 70vh;
    overflow-y: auto;
    padding: 15px;
}

/* Table styling inside modal */
.table-striped > tbody > tr:nth-of-type(odd) {
    background-color: #f9f9f9;
}

.table th {
    background-color: #f5f5f5;
    font-weight: 600;
}

/* Patient image styling */
.width150 {
    width: 150px;
    height: 150px;
    object-fit: cover;
}

/* Responsive design */
@media (max-width: 768px) {
    .pup100 {
        width: 95%;
        margin: 10px auto;
    }
    
    .modal-dialog {
        margin: 10px auto;
    }
    
    .width150 {
        width: 100px;
        height: 100px;
    }
}
</style>
