<!-- Location: application/views/admin/reports/dashboard.php -->

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-chart-line"></i> Reports Dashboard
            <small>Comprehensive Analytics & Insights</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Reports Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Filter Section -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Report Filters</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date From</label>
                            <input type="date" id="date_from" class="form-control" value="<?php echo $date_from; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date To</label>
                            <input type="date" id="date_to" class="form-control" value="<?php echo $date_to; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Report Category</label>
                            <select id="report_category" class="form-control">
                                <option value="all">All Reports</option>
                                <?php foreach($available_reports as $category => $reports): ?>
                                    <option value="<?php echo strtolower(str_replace(' ', '_', $category)); ?>">
                                        <?php echo $category; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="btn-group btn-block">
                                <button class="btn btn-primary btn-block" onclick="loadReports()">
                                    <i class="fa fa-search"></i> Generate Reports
                                </button>
                                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                                    <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="#" onclick="scheduleReport()"><i class="fa fa-clock"></i> Schedule Report</a></li>
                                    <li><a href="#" onclick="saveReportConfig()"><i class="fa fa-save"></i> Save Configuration</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats (Executive Dashboard) -->
        <?php if(in_array('executive_dashboard', $permissions)): ?>
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="today-revenue">₹0</h3>
                        <p>Today's Revenue</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-rupee-sign"></i>
                    </div>
                    <a href="#revenue-section" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="today-patients">0</h3>
                        <p>Today's Patients</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="#patient-section" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="pending-claims">0</h3>
                        <p>Pending Insurance Claims</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-file-invoice"></i>
                    </div>
                    <a href="#insurance-section" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="outstanding-amount">₹0</h3>
                        <p>Outstanding Payments</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="#outstanding-section" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Financial Reports Section -->
        <?php if(in_array('revenue_reports', $permissions) || in_array('cash_payment_reports', $permissions)): ?>
        <div class="row" id="revenue-section">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-chart-bar"></i> Revenue Analysis</h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" class="btn btn-box-tool dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-download"></i> Export
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="#" onclick="exportReport('revenue', 'pdf')"><i class="fa fa-file-pdf text-red"></i> PDF</a></li>
                                    <li><a href="#" onclick="exportReport('revenue', 'excel')"><i class="fa fa-file-excel text-green"></i> Excel</a></li>
                                    <li><a href="#" onclick="exportReport('revenue', 'csv')"><i class="fa fa-file-csv text-blue"></i> CSV</a></li>
                                </ul>
                            </div>
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-8">
                                <canvas id="revenue-trend-chart" height="80"></canvas>
                            </div>
                            <div class="col-md-4">
                                <canvas id="payment-method-chart" height="160"></canvas>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <table class="table table-bordered table-striped" id="revenue-details-table">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Cash</th>
                                            <th>Card</th>
                                            <th>Insurance</th>
                                            <th>Other</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Patient Analytics Section -->
        <?php if(in_array('patient_visit_reports', $permissions)): ?>
        <div class="row" id="patient-section">
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-users"></i> Patient Visit Statistics</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <canvas id="patient-visit-chart" height="120"></canvas>
                        <div class="row text-center mt-3">
                            <div class="col-sm-4">
                                <div class="description-block border-right">
                                    <h5 class="description-header text-green" id="total-visits">0</h5>
                                    <span class="description-text">Total Visits</span>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="description-block border-right">
                                    <h5 class="description-header text-blue" id="walk-ins">0</h5>
                                    <span class="description-text">Walk-ins</span>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="description-block">
                                    <h5 class="description-header text-yellow" id="registered">0</h5>
                                    <span class="description-text">Registered</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-chart-pie"></i> Patient Demographics</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <canvas id="age-distribution-chart" height="200"></canvas>
                            </div>
                            <div class="col-md-6">
                                <canvas id="gender-distribution-chart" height="200"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Department Revenue Section -->
        <?php if(in_array('department_revenue_reports', $permissions)): ?>
        <div class="row" id="department-section">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-building"></i> Department-wise Revenue Analysis</h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" class="btn btn-box-tool dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-download"></i> Export
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="#" onclick="exportReport('department', 'pdf')"><i class="fa fa-file-pdf text-red"></i> PDF</a></li>
                                    <li><a href="#" onclick="exportReport('department', 'excel')"><i class="fa fa-file-excel text-green"></i> Excel</a></li>
                                </ul>
                            </div>
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <canvas id="department-revenue-chart" height="100"></canvas>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-hover" id="department-summary-table">
                                    <thead>
                                        <tr>
                                            <th>Department</th>
                                            <th>Patients</th>
                                            <th>Revenue</th>
                                            <th>Avg/Patient</th>
                                            <th>% of Total</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Insurance Reports Section -->
        <?php if(in_array('insurance_reports', $permissions)): ?>
        <div class="row" id="insurance-section">
            <div class="col-md-12">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-shield-alt"></i> Insurance Claims Analysis</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-red"><i class="fa fa-clock"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Pending Claims</span>
                                        <span class="info-box-number" id="pending-claims-count">0</span>
                                        <span class="progress-description" id="pending-claims-amount">₹0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-green"><i class="fa fa-check"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Approved Claims</span>
                                        <span class="info-box-number" id="approved-claims-count">0</span>
                                        <span class="progress-description" id="approved-claims-amount">₹0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-yellow"><i class="fa fa-times"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Rejected Claims</span>
                                        <span class="info-box-number" id="rejected-claims-count">0</span>
                                        <span class="progress-description" id="rejected-claims-amount">₹0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box">
                                    <span class="info-box-icon bg-blue"><i class="fa fa-percentage"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Approval Rate</span>
                                        <span class="info-box-number" id="approval-rate">0%</span>
                                        <span class="progress-description">Success Rate</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-bordered" id="insurance-company-table">
                                    <thead>
                                        <tr>
                                            <th>Insurance Company</th>
                                            <th>Total Claims</th>
                                            <th>Pending</th>
                                            <th>Approved</th>
                                            <th>Rejected</th>
                                            <th>Total Amount</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Outstanding Payments Section -->
        <?php if(in_array('outstanding_payment_reports', $permissions)): ?>
        <div class="row" id="outstanding-section">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Outstanding Payments Analysis</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4>Aging Analysis</h4>
                                <canvas id="aging-analysis-chart" height="100"></canvas>
                            </div>
                            <div class="col-md-6">
                                <h4>Top Outstanding Patients</h4>
                                <div class="table-responsive">
                                    <table class="table table-striped" id="outstanding-patients-table">
                                        <thead>
                                            <tr>
                                                <th>Patient</th>
                                                <th>Outstanding</th>
                                                <th>Days</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Custom Report Builder -->
        <?php if(in_array('custom_report_builder', $permissions)): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-cogs"></i> Custom Report Builder</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <a href="<?php echo base_url(); ?>admin/reports_dashboard/custom_report" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Create Custom Report
                        </a>
                        <a href="#" class="btn btn-info" onclick="loadSavedReports()">
                            <i class="fa fa-folder-open"></i> Saved Reports
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

    </section>
</div>

<!-- JavaScript for Reports Dashboard -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
// Global variables
var revenueChart, patientChart, departmentChart, agingChart;
var paymentMethodChart, ageChart, genderChart;

// Initialize on page load
$(document).ready(function() {
    initializeCharts();
    loadQuickStats();
    loadReports();
    
    // Set up auto-refresh every 5 minutes
    setInterval(loadQuickStats, 300000);
});

// Initialize all charts
function initializeCharts() {
    // Revenue Trend Chart
    var ctx1 = document.getElementById('revenue-trend-chart');
    if (ctx1) {
        revenueChart = new Chart(ctx1.getContext('2d'), {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Revenue',
                    data: [],
                    borderColor: 'rgb(75, 192, 192)',
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    tension: 0.1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Revenue Trend'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return '₹' + value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Payment Method Chart
    var ctx2 = document.getElementById('payment-method-chart');
    if (ctx2) {
        paymentMethodChart = new Chart(ctx2.getContext('2d'), {
            type: 'doughnut',
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: [
                        'rgb(255, 99, 132)',
                        'rgb(54, 162, 235)',
                        'rgb(255, 205, 86)',
                        'rgb(75, 192, 192)'
                    ]
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    },
                    title: {
                        display: true,
                        text: 'Payment Methods'
                    }
                }
            }
        });
    }
    
    // Patient Visit Chart
    var ctx3 = document.getElementById('patient-visit-chart');
    if (ctx3) {
        patientChart = new Chart(ctx3.getContext('2d'), {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    label: 'Visits',
                    data: [],
                    backgroundColor: 'rgba(75, 192, 192, 0.6)'
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    }
    
    // Department Revenue Chart
    var ctx4 = document.getElementById('department-revenue-chart');
    if (ctx4) {
        departmentChart = new Chart(ctx4.getContext('2d'), {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    label: 'Revenue',
                    data: [],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.6)',
                        'rgba(54, 162, 235, 0.6)',
                        'rgba(255, 206, 86, 0.6)',
                        'rgba(75, 192, 192, 0.6)',
                        'rgba(153, 102, 255, 0.6)',
                        'rgba(255, 159, 64, 0.6)',
                        'rgba(199, 199, 199, 0.6)'
                    ]
                }]
            },
            options: {
                responsive: true,
                indexAxis: 'y',
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    x: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return '₹' + value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }
}

// Load all reports based on filters
function loadReports() {
    var dateFrom = $('#date_from').val();
    var dateTo = $('#date_to').val();
    var category = $('#report_category').val();
    
    // Show loading indicator
    showLoading();
    
    // Load different report sections
    if (category === 'all' || category === 'financial') {
        loadRevenueAnalysis(dateFrom, dateTo);
        loadDepartmentRevenue(dateFrom, dateTo);
    }
    
    if (category === 'all' || category === 'patient_analytics') {
        loadPatientVisits(dateFrom, dateTo);
    }
    
    if (category === 'all' || category === 'financial') {
        loadInsuranceReports(dateFrom, dateTo);
        loadOutstandingPayments();
    }
    
    hideLoading();
}

// Load revenue analysis
function loadRevenueAnalysis(dateFrom, dateTo) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/reports_dashboard/revenue_analysis',
        type: 'POST',
        data: {
            date_from: dateFrom,
            date_to: dateTo,
            '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
        },
        success: function(response) {
            var data = JSON.parse(response);
            if (data.status === 1) {
                updateRevenueCharts(data.data);
                updateRevenueTable(data.data);
            }
        },
        error: function() {
            showAlert('Error loading revenue analysis', 'error');
        }
    });
}

// Update revenue charts with data
function updateRevenueCharts(data) {
    // Update revenue trend chart
    if (revenueChart && data.revenue_trend) {
        revenueChart.data.labels = data.revenue_trend.map(item => item.period);
        revenueChart.data.datasets[0].data = data.revenue_trend.map(item => item.revenue);
        revenueChart.update();
    }
    
    // Update payment method chart
    if (paymentMethodChart && data.payment_methods) {
        paymentMethodChart.data.labels = data.payment_methods.map(item => item.payment_mode);
        paymentMethodChart.data.datasets[0].data = data.payment_methods.map(item => item.total_amount);
        paymentMethodChart.update();
    }
    
    // Update total revenue display
    if (data.total_revenue) {
        $('#total-revenue').text('₹' + parseFloat(data.total_revenue.total_revenue).toLocaleString());
    }
}

// Export report function
function exportReport(reportType, format) {
    var dateFrom = $('#date_from').val();
    var dateTo = $('#date_to').val();
    
    var url = '<?php echo base_url(); ?>admin/reports_dashboard/export_report/' + 
              reportType + '/' + format + 
              '?date_from=' + dateFrom + 
              '&date_to=' + dateTo;
    
    window.open(url, '_blank');
}

// Show loading indicator
function showLoading() {
    $.LoadingOverlay("show");
}

// Hide loading indicator
function hideLoading() {
    $.LoadingOverlay("hide");
}

// Show alert message
function showAlert(message, type) {
    toastr[type](message);
}

// Load quick stats
function loadQuickStats() {
    <?php if(isset($quick_stats)): ?>
    $('#today-revenue').text('₹' + <?php echo $quick_stats['today']['revenue']; ?>.toLocaleString());
    $('#today-patients').text(<?php echo $quick_stats['today']['patients']; ?>);
    <?php endif; ?>
}
</script>