<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-stethoscope"></i>
        </div>
        <div class="header-title">
            <h1><?php echo $title; ?></h1>
            <small><?php echo $this->lang->line('configure_radiology_tests'); ?></small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> <?php echo $this->lang->line('radiology_tests'); ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group" style="margin-right: 10px;">
                                <button type="button" class="btn btn-info btn-sm dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-filter"></i> Filter <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" onclick="filterByGCCStatus('')">All Tests</a></li>
                                    <li><a href="#" onclick="filterByGCCStatus('1')"><i class="fa fa-star text-warning"></i> GCC Tests Only</a></li>
                                    <li><a href="#" onclick="filterByGCCStatus('0')">Regular Tests Only</a></li>
                                    <li class="divider"></li>
                                    <li><a href="#" onclick="loadGCCPackages()"><i class="fa fa-package"></i> View GCC Packages</a></li>
                                </ul>
                            </div>
                            <?php if (method_exists($this, 'checkPermission') ? $this->checkPermission('can_add') : true): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addRadiologyTestModal">
                                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_test'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="radiologyTestsTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('test_name'); ?></th>
                                        <th><?php echo $this->lang->line('test_code'); ?></th>
                                        <th><?php echo $this->lang->line('category'); ?></th>
                                        <th><?php echo $this->lang->line('duration'); ?> (mins)</th>
                                        <th><?php echo $this->lang->line('price'); ?></th>
                                        <th><?php echo $this->lang->line('requires_contrast'); ?></th>
                                        <th><?php echo $this->lang->line('requires_fasting'); ?></th>
                                        <th><i class="fa fa-star text-warning"></i> GCC Test</th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data loaded via DataTables -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Radiology Test Modal -->
<div class="modal fade" id="addRadiologyTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_radiology_test'); ?>
                </h4>
            </div>
            <form id="addRadiologyTestForm" method="post" role="form">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="test_name"><?php echo $this->lang->line('test_name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="test_name" name="test_name" placeholder="<?php echo $this->lang->line('enter_test_name'); ?>" required>
                                <span class="text-danger" id="test_name_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="test_code"><?php echo $this->lang->line('test_code'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="test_code" name="test_code" placeholder="<?php echo $this->lang->line('enter_test_code'); ?>" required>
                                <span class="text-danger" id="test_code_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category"><?php echo $this->lang->line('category'); ?> <span class="text-danger">*</span></label>
                                <select class="form-control" id="category" name="category" required>
                                    <option value=""><?php echo $this->lang->line('select_category'); ?></option>
                                    <option value="X-Ray">X-Ray</option>
                                    <option value="CT Scan">CT Scan</option>
                                    <option value="MRI">MRI</option>
                                    <option value="Ultrasound">Ultrasound</option>
                                    <option value="Mammography">Mammography</option>
                                    <option value="Fluoroscopy">Fluoroscopy</option>
                                    <option value="Nuclear Medicine">Nuclear Medicine</option>
                                    <option value="Interventional">Interventional Radiology</option>
                                    <option value="Special">Special Procedures</option>
                                </select>
                                <span class="text-danger" id="category_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="estimated_duration"><?php echo $this->lang->line('estimated_duration'); ?> (minutes)</label>
                                <input type="number" class="form-control" id="estimated_duration" name="estimated_duration" min="5" max="180" placeholder="30" value="30">
                                <span class="text-danger" id="estimated_duration_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="price"><?php echo $this->lang->line('price'); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon">Ksh.</span>
                                    <input type="number" class="form-control" id="price" name="price" step="0.01" min="0" placeholder="0.00" required>
                                </div>
                                <span class="text-danger" id="price_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="requires_contrast"><?php echo $this->lang->line('requires_contrast'); ?></label>
                                <select class="form-control" id="requires_contrast" name="requires_contrast">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="requires_fasting"><?php echo $this->lang->line('requires_fasting'); ?></label>
                                <select class="form-control" id="requires_fasting" name="requires_fasting">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="is_gcc">
                                    <input type="checkbox" id="is_gcc" name="is_gcc" value="1"> 
                                    <i class="fa fa-star text-warning"></i> Mark as GCC Test
                                </label>
                                <small class="help-block">Check this if the test is part of the GCC medical examination workflow</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description"><?php echo $this->lang->line('description'); ?></label>
                                <textarea class="form-control" id="description" name="description" rows="3" placeholder="<?php echo $this->lang->line('test_description'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="preparation_instructions"><?php echo $this->lang->line('preparation_instructions'); ?></label>
                                <textarea class="form-control" id="preparation_instructions" name="preparation_instructions" rows="3" placeholder="<?php echo $this->lang->line('patient_preparation_instructions'); ?>"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <?php echo $this->lang->line('cancel'); ?>
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> <?php echo $this->lang->line('save'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Radiology Test Modal -->
<div class="modal fade" id="editRadiologyTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> <?php echo $this->lang->line('edit_radiology_test'); ?>
                </h4>
            </div>
            <div id="editRadiologyTestModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- View Radiology Test Modal -->
<div class="modal fade" id="viewRadiologyTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> <?php echo $this->lang->line('view_test_details'); ?>
                </h4>
            </div>
            <div id="viewRadiologyTestModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Fix dropdown text color
    $('head').append(`
        <style>
        .form-control {
            color: #555 !important;
            background-color: #fff !important;
        }
        .form-control option {
            color: #333 !important;
            background-color: #fff !important;
        }
        select.form-control {
            color: #555 !important;
        }
        select.form-control option {
            color: #333 !important;
            background-color: #fff !important;
        }
        </style>
    `);

    // Initialize DataTable
    var radiologyTestsTable = $('#radiologyTestsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: base_url + 'admin/radiology-setup/get-tests-datatable',
            type: 'POST',
            error: function(xhr, error, code) {
                console.error('DataTable AJAX Error:', {
                    status: xhr.status,
                    statusText: xhr.statusText,
                    responseText: xhr.responseText,
                    error: error,
                    code: code
                });
                showMessage('Error loading radiology tests data. Check console for details.', 'error');
            }
        },
        columns: [
            { data: 0, name: 'test_name', title: 'Test Name' },
            { data: 1, name: 'test_code', title: 'Test Code' },
            { data: 2, name: 'category', title: 'Category' },
            { data: 3, name: 'estimated_duration', title: 'Duration (mins)', className: 'text-center' },
            { data: 4, name: 'price', title: 'Price', className: 'text-right' },
            { data: 5, name: 'requires_contrast', title: 'Contrast', orderable: false, className: 'text-center' },
            { data: 6, name: 'requires_fasting', title: 'Fasting', orderable: false, className: 'text-center' },
            { data: 7, name: 'is_gcc', title: 'GCC Test', orderable: false, className: 'text-center' },
            { data: 8, name: 'is_active', title: 'Status', orderable: false, className: 'text-center' },
            { data: 9, name: 'actions', title: 'Actions', orderable: false, searchable: false, className: 'text-right' }
        ],
        order: [[0, 'asc']],
        pageLength: 25,
        responsive: true,
        language: {
            processing: 'Processing...',
            search: 'Search:',
            lengthMenu: 'Show _MENU_ entries',
            info: 'Showing _START_ to _END_ of _TOTAL_ entries',
            infoEmpty: 'No entries found',
            infoFiltered: '(filtered from _MAX_ total entries)',
            zeroRecords: 'No matching records found',
            emptyTable: 'No data available in table',
            paginate: {
                first: 'First',
                previous: 'Previous',
                next: 'Next',
                last: 'Last'
            }
        }
    });

    // Add Radiology Test Form Submission
    $('#addRadiologyTestForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        
        // Debug: Log form submission attempt
        console.log('Form submission started');
        console.log('Base URL:', base_url);
        
        var $form = $(this);
        var $submitBtn = $form.find('button[type="submit"]');
        var formData = $form.serialize();
        
        // Show loading state
        $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        
        // Clear previous errors
        $('.text-danger').text('');
        
        // Debug: Log form data
        console.log('Form data being sent:', formData);
        console.log('Submit URL:', base_url + 'admin/radiology-setup/add-test');
        
        $.ajax({
            url: base_url + 'admin/radiology-setup/add-test',
            type: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function(xhr) {
                console.log('AJAX request starting...');
            },
            success: function(response) {
                console.log('Response received:', response);
                
                if (response.status === 'success') {
                    // Success - close modal and refresh table
                    $('#addRadiologyTestModal').modal('hide');
                    $form[0].reset();
                    radiologyTestsTable.ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    // Handle validation errors
                    if (response.error && typeof response.error === 'object') {
                        $.each(response.error, function(field, error) {
                            $('#' + field + '_error').text(error);
                        });
                    }
                    if (response.message) {
                        showMessage(response.message, 'error');
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error Details:');
                console.error('Status:', status);
                console.error('Error:', error);
                console.error('Response Text:', xhr.responseText);
                console.error('Response Status:', xhr.status);
                
                // Try to parse error response
                let errorMessage = 'An error occurred while saving the radiology test.';
                try {
                    const errorResponse = JSON.parse(xhr.responseText);
                    if (errorResponse.message) {
                        errorMessage = errorResponse.message;
                    }
                } catch (e) {
                    // If response is not JSON, use the status text
                    if (xhr.status === 404) {
                        errorMessage = 'The server endpoint was not found. Please check the URL.';
                    } else if (xhr.status === 500) {
                        errorMessage = 'Server error occurred. Please check the logs.';
                    } else if (xhr.status === 0) {
                        errorMessage = 'Network error. Please check your connection.';
                    }
                }
                
                showMessage(errorMessage, 'error');
            },
            complete: function() {
                // Reset button state
                $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> <?php echo $this->lang->line('save'); ?>');
                console.log('AJAX request completed');
            }
        });
        
        return false; // Ensure form doesn't submit normally
    });

    // Auto-generate test code from test name
    $('#test_name').on('input', function() {
        var testName = $(this).val();
        var testCode = generateTestCode(testName);
        $('#test_code').val(testCode);
    });
});

// Ensure base_url is defined
if (typeof base_url === 'undefined') {
    var base_url = '<?php echo base_url(); ?>';
    console.log('Base URL set to:', base_url);
}

// Generate test code from test name
function generateTestCode(testName) {
    if (!testName) return '';
    
    // Remove common words and get initials
    var commonWords = ['test', 'scan', 'examination', 'imaging', 'study', 'procedure'];
    var words = testName.toLowerCase().split(' ');
    
    // Filter out common words
    words = words.filter(function(word) {
        return commonWords.indexOf(word) === -1 && word.length > 1;
    });
    
    // Get first letters of remaining words
    var testCode = words.map(function(word) {
        return word.charAt(0).toUpperCase();
    }).join('');
    
    // If too short, use first word + abbreviation
    if (testCode.length < 2) {
        var firstWord = testName.split(' ')[0];
        testCode = firstWord.substring(0, 4).toUpperCase();
    }
    
    return testCode;
}

// Enhanced message function with better error handling
function showMessage(message, type) {
    // Remove any existing alerts first
    $('.alert').remove();
    
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check' : 'fa-exclamation-triangle';
    
    var alert = '<div class="alert ' + alertClass + ' alert-dismissible" style="margin: 15px 0;">' +
                '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                '<h4><i class="icon fa ' + icon + '"></i> ' + 
                (type === 'success' ? '<?php echo $this->lang->line('success'); ?>' : '<?php echo $this->lang->line('error'); ?>') + '</h4>' +
                message + '</div>';
    
    // Insert the alert at the top of the content wrapper
    $('.content-wrapper').prepend(alert);
    
    // Auto-hide after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow', function() {
            $(this).remove();
        });
    }, 5000);
    
    // Scroll to top to show the message
    $('html, body').animate({
        scrollTop: $('.content-wrapper').offset().top
    }, 'fast');
}

// Edit Radiology Test Function
function editRadiologyTest(id) {
    $.ajax({
        url: base_url + 'admin/radiology-setup/edit-test/' + id,
        type: 'GET',
        success: function(response) {
            $('#editRadiologyTestModalContent').html(response);
            $('#editRadiologyTestModal').modal('show');
        },
        error: function() {
            showMessage('Error loading radiology test data.', 'error');
        }
    });
}

// View Radiology Test Function
function viewRadiologyTest(id) {
    $.ajax({
        url: base_url + 'admin/radiology-setup/view-test/' + id,
        type: 'GET',
        success: function(response) {
            $('#viewRadiologyTestModalContent').html(response);
            $('#viewRadiologyTestModal').modal('show');
        },
        error: function() {
            showMessage('Error loading radiology test data.', 'error');
        }
    });
}

// Delete Radiology Test Function
function deleteRadiologyTest(id) {
    if (confirm('Are you sure you want to delete this radiology test?')) {
        $.ajax({
            url: base_url + 'admin/radiology-setup/delete-test/' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#radiologyTestsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('An error occurred while deleting.', 'error');
            }
        });
    }
}

// Toggle GCC Status
function toggleGCCStatus(id, currentStatus) {
    var newStatus = currentStatus == 1 ? 0 : 1;
    var statusText = newStatus == 1 ? 'mark as GCC test' : 'unmark as GCC test';
    
    if (confirm('Are you sure you want to ' + statusText + '?')) {
        $.ajax({
            url: base_url + 'admin/radiology-setup/toggle-gcc-status',
            type: 'POST',
            data: {
                test_id: id,
                gcc_status: newStatus
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#radiologyTestsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('An error occurred while updating GCC status.', 'error');
            }
        });
    }
}

// Filter by GCC status
function filterByGCCStatus(gccStatus) {
    var table = $('#radiologyTestsTable').DataTable();
    if (gccStatus === '') {
        table.column(7).search('').draw(); // Column 7 is GCC status
    } else if (gccStatus === '1') {
        table.column(7).search('GCC').draw();
    } else {
        table.column(7).search('Regular').draw();
    }
}

// Load GCC tests only
function loadGCCTests() {
    $.ajax({
        url: base_url + 'admin/radiology-setup/get-gcc-tests',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                console.log('GCC Tests:', response.data);
                showMessage('Found ' + response.count + ' GCC tests', 'success');
                
                // Filter the table to show only GCC tests
                filterByGCCStatus('1');
            } else {
                showMessage(response.message, 'error');
            }
        },
        error: function() {
            showMessage('Error loading GCC tests.', 'error');
        }
    });
}

// Load GCC packages
function loadGCCPackages() {
    $.ajax({
        url: base_url + 'admin/radiology-setup/get-gcc-packages',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                console.log('GCC Packages:', response.data);
                showMessage('Found ' + response.count + ' GCC packages', 'success');
                
                // You can display packages in a modal or separate section
                displayGCCPackages(response.data);
            } else {
                showMessage(response.message, 'error');
            }
        },
        error: function() {
            showMessage('Error loading GCC packages.', 'error');
        }
    });
}

// Display GCC packages (example function)
function displayGCCPackages(packages) {
    var html = '<div class="modal fade" id="gccPackagesModal"><div class="modal-dialog modal-lg"><div class="modal-content">';
    html += '<div class="modal-header"><h4>GCC Radiology Packages</h4></div><div class="modal-body">';
    
    if (packages.length > 0) {
        html += '<div class="row">';
        packages.forEach(function(pkg) {
            html += '<div class="col-md-6"><div class="panel panel-default">';
            html += '<div class="panel-heading"><h5>' + pkg.package_name + ' <span class="label label-info">' + pkg.package_code + '</span></h5></div>';
            html += '<div class="panel-body">';
            html += '<p><strong>Price:</strong> Ksh. ' + parseFloat(pkg.discounted_price || pkg.total_price).toFixed(2) + '</p>';
            html += '<p><strong>Duration:</strong> ' + pkg.estimated_total_duration + ' minutes</p>';
            html += '<p><strong>Tests:</strong> ' + (pkg.included_tests || 'No tests assigned') + '</p>';
            html += '</div></div></div>';
        });
        html += '</div>';
    } else {
        html += '<p>No GCC packages found.</p>';
    }
    
    html += '</div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Close</button></div>';
    html += '</div></div></div>';
    
    $('body').append(html);
    $('#gccPackagesModal').modal('show');
    
    // Remove modal after hiding
    $('#gccPackagesModal').on('hidden.bs.modal', function() {
        $(this).remove();
    });
}

// Export radiology tests to CSV
function exportRadiologyTests() {
    window.location.href = base_url + 'admin/radiology_setup/export_radiology_tests';
}

// Bulk actions
function bulkToggleRadiologyStatus(status) {
    var selectedTests = [];
    $('.radiology-test-checkbox:checked').each(function() {
        selectedTests.push($(this).val());
    });
    
    if (selectedTests.length === 0) {
        alert('<?php echo $this->lang->line('please_select_tests'); ?>');
        return;
    }
    
    if (confirm('<?php echo $this->lang->line('are_you_sure'); ?>')) {
        $.ajax({
            url: base_url + 'admin/radiology_setup/bulk_toggle_status',
            type: 'POST',
            data: {
                test_ids: selectedTests,
                status: status
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#radiologyTestsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('<?php echo $this->lang->line('error_occurred'); ?>', 'error');
            }
        });
    }
}

// Toggle all checkboxes
function toggleAllRadiologyTests() {
    var isChecked = $('#selectAllRadiologyTests').is(':checked');
    $('.radiology-test-checkbox').prop('checked', isChecked);
}

// Print radiology test list
function printRadiologyTestList() {
    var printWindow = window.open('', '_blank');
    var content = '<html><head><title><?php echo $this->lang->line('radiology_tests'); ?></title>';
    content += '<style>table { border-collapse: collapse; width: 100%; }';
    content += 'th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }';
    content += 'th { background-color: #f2f2f2; }</style></head><body>';
    content += '<h1><?php echo $this->lang->line('radiology_tests'); ?></h1>';
    content += '<table>' + $('#radiologyTestsTable thead').html();
    content += '<tbody>' + $('#radiologyTestsTable tbody').html() + '</tbody></table>';
    content += '</body></html>';
    
    printWindow.document.write(content);
    printWindow.document.close();
    printWindow.print();
}

// Category filter
function filterByRadiologyCategory(categoryValue) {
    if (categoryValue === '') {
        $('#radiologyTestsTable').DataTable().column(2).search('').draw();
    } else {
        $('#radiologyTestsTable').DataTable().column(2).search(categoryValue).draw();
    }
}

// Search functionality
function searchRadiologyTests() {
    var searchTerm = $('#radiologyTestSearch').val();
    $('#radiologyTestsTable').DataTable().search(searchTerm).draw();
}
</script>