<?php
/**
 * Queue Configuration Edit View
 * File: application/views/admin/queue/config_edit.php
 */
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cog"></i> <?php echo $title; ?>
            <small><?php echo $this->lang->line('configure_department_queue'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li><a href="<?php echo base_url(); ?>admin/queue"><?php echo $this->lang->line('queue_management'); ?></a></li>
            <li><a href="<?php echo base_url(); ?>admin/queue/config"><?php echo $this->lang->line('configuration'); ?></a></li>
            <li class="active"><?php echo ucfirst($department); ?></li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-edit"></i> 
                            <?php echo ucfirst($department); ?> Queue Configuration
                        </h3>
                    </div>
                    
                    <?php echo form_open('admin/queue/save_config', array('id' => 'queue-config-form', 'class' => 'form-horizontal')); ?>
                    <input type="hidden" name="department" value="<?php echo $department; ?>">
                    
                    <div class="box-body">
                        <!-- Basic Settings -->
                        <div class="form-group">
                            <label class="col-sm-3 control-label">
                                <?php echo $this->lang->line('queue_prefix'); ?> <span class="text-red">*</span>
                            </label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="queue_prefix" 
                                       value="<?php echo isset($config['queue_prefix']) ? $config['queue_prefix'] : strtoupper(substr($department, 0, 3)); ?>" 
                                       required maxlength="5">
                                <small class="help-block">Short prefix for queue numbers (e.g., REG, TRI, CON)</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">
                                <?php echo $this->lang->line('average_service_time'); ?>
                            </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <input type="number" class="form-control" name="average_service_time" 
                                           value="<?php echo isset($config['average_service_time']) ? $config['average_service_time'] : 15; ?>" 
                                           min="1" max="120">
                                    <span class="input-group-addon">minutes</span>
                                </div>
                                <small class="help-block">Estimated time per patient for wait time calculations</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">
                                <?php echo $this->lang->line('max_queue_size'); ?>
                            </label>
                            <div class="col-sm-9">
                                <input type="number" class="form-control" name="max_queue_size" 
                                       value="<?php echo isset($config['max_queue_size']) ? $config['max_queue_size'] : 50; ?>" 
                                       min="1" max="200">
                                <small class="help-block">Maximum number of patients allowed in queue</small>
                            </div>
                        </div>

                        <!-- Working Hours -->
                        <hr>
                        <h4><i class="fa fa-clock-o"></i> Working Hours</h4>
                        
                        <div class="form-group">
                            <label class="col-sm-3 control-label">
                                <?php echo $this->lang->line('start_time'); ?>
                            </label>
                            <div class="col-sm-4">
                                <input type="time" class="form-control" name="working_hours_start" 
                                       value="<?php echo isset($config['working_hours_start']) ? $config['working_hours_start'] : '08:00'; ?>">
                            </div>
                            
                            <label class="col-sm-2 control-label">
                                <?php echo $this->lang->line('end_time'); ?>
                            </label>
                            <div class="col-sm-3">
                                <input type="time" class="form-control" name="working_hours_end" 
                                       value="<?php echo isset($config['working_hours_end']) ? $config['working_hours_end'] : '17:00'; ?>">
                            </div>
                        </div>

                        <!-- Queue Behavior -->
                        <hr>
                        <h4><i class="fa fa-cogs"></i> Queue Behavior</h4>
                        
                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="auto_call_next" value="1" 
                                               <?php echo (isset($config['auto_call_next']) && $config['auto_call_next']) ? 'checked' : ''; ?>>
                                        Auto-call next patient when current is completed
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="allow_priority_queue" value="1" 
                                               <?php echo (isset($config['allow_priority_queue']) && $config['allow_priority_queue']) ? 'checked' : ''; ?>>
                                        Allow priority queue (urgent patients first)
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Display Settings -->
                        <hr>
                        <h4><i class="fa fa-desktop"></i> Display Settings</h4>
                        
                        <div class="form-group">
                            <label class="col-sm-3 control-label">
                                Department Color
                            </label>
                            <div class="col-sm-9">
                                <input type="color" class="form-control" name="department_color" 
                                       value="<?php echo isset($config['department_color']) ? $config['department_color'] : '#007bff'; ?>" 
                                       style="height: 40px;">
                                <small class="help-block">Color used in queue displays and notifications</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">
                                Display Language
                            </label>
                            <div class="col-sm-9">
                                <select class="form-control" name="display_language">
                                    <option value="en" <?php echo (isset($config['display_language']) && $config['display_language'] == 'en') ? 'selected' : ''; ?>>English</option>
                                    <option value="sw" <?php echo (isset($config['display_language']) && $config['display_language'] == 'sw') ? 'selected' : ''; ?>>Kiswahili</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> <?php echo $this->lang->line('save_configuration'); ?>
                                </button>
                                <a href="<?php echo site_url('admin/queue/config'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> <?php echo $this->lang->line('back'); ?>
                                </a>
                                <a href="<?php echo site_url('admin/queue/department/' . $department); ?>" class="btn btn-info">
                                    <i class="fa fa-eye"></i> View Queue
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <?php echo form_close(); ?>
                </div>
            </div>

            <!-- Current Settings Preview -->
            <div class="col-md-4">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-info-circle"></i> Current Settings
                        </h3>
                    </div>
                    <div class="box-body">
                        <table class="table table-bordered">
                            <tr>
                                <td><strong>Department:</strong></td>
                                <td><?php echo ucfirst($department); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Current Counter:</strong></td>
                                <td>
                                    <span class="label label-info">
                                        <?php echo isset($config['counter_current']) ? $config['counter_current'] : 1; ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    <?php if (isset($config['is_active']) && $config['is_active']): ?>
                                        <span class="label label-success">Active</span>
                                    <?php else: ?>
                                        <span class="label label-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Last Updated:</strong></td>
                                <td>
                                    <small>
                                        <?php echo isset($config['updated_at']) ? date('M j, Y H:i', strtotime($config['updated_at'])) : 'Never'; ?>
                                    </small>
                                </td>
                            </tr>
                        </table>
                        
                        <hr>
                        
                        <h5><i class="fa fa-wrench"></i> Quick Actions</h5>
                        <div class="btn-group-vertical btn-block">
                            <button type="button" class="btn btn-warning btn-sm" onclick="resetCounter()">
                                <i class="fa fa-refresh"></i> Reset Counter
                            </button>
                            <button type="button" class="btn btn-success btn-sm" onclick="testQueue()">
                                <i class="fa fa-play"></i> Test Queue
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Help Information -->
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-question-circle"></i> Help
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <h5>Queue Prefix</h5>
                        <p><small>A short code (2-5 characters) that appears before queue numbers. Example: REG001, TRI025</small></p>
                        
                        <h5>Service Time</h5>
                        <p><small>Average time spent with each patient. Used to estimate wait times for patients in queue.</small></p>
                        
                        <h5>Priority Queue</h5>
                        <p><small>When enabled, urgent patients will be called before normal priority patients.</small></p>
                        
                        <h5>Auto-call Next</h5>
                        <p><small>Automatically calls the next patient when the current one is marked as completed.</small></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Form submission handling
    $('#queue-config-form').on('submit', function(e) {
        e.preventDefault();
        
        const formData = $(this).serialize();
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function() {
                $('button[type="submit"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function(response) {
                if (response.status === 'success') {
                    showSuccessToast(response.message);
                    setTimeout(function() {
                        window.location.href = '<?php echo site_url('admin/queue/config'); ?>';
                    }, 1500);
                } else {
                    showErrorToast(response.message);
                }
            },
            error: function() {
                showErrorToast('Failed to save configuration');
            },
            complete: function() {
                $('button[type="submit"]').prop('disabled', false).html('<i class="fa fa-save"></i> <?php echo $this->lang->line('save_configuration'); ?>');
            }
        });
    });
    
    // Form validation
    $('#queue-config-form').validate({
        rules: {
            queue_prefix: {
                required: true,
                minlength: 2,
                maxlength: 5
            },
            average_service_time: {
                required: true,
                min: 1,
                max: 120
            },
            max_queue_size: {
                required: true,
                min: 1,
                max: 200
            }
        },
        messages: {
            queue_prefix: {
                required: "Queue prefix is required",
                minlength: "Minimum 2 characters",
                maxlength: "Maximum 5 characters"
            },
            average_service_time: {
                required: "Service time is required",
                min: "Minimum 1 minute",
                max: "Maximum 120 minutes"
            },
            max_queue_size: {
                required: "Queue size is required",
                min: "Minimum 1 patient",
                max: "Maximum 200 patients"
            }
        }
    });
});

/**
 * Reset counter for this department
 */
function resetCounter() {
    if (confirm('Reset queue counter to 1? This action cannot be undone.')) {
        $.ajax({
            url: '<?php echo site_url('admin/queue/reset_counters'); ?>',
            type: 'POST',
            data: { department: '<?php echo $department; ?>' },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showSuccessToast(response.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showErrorToast(response.message);
                }
            },
            error: function() {
                showErrorToast('Failed to reset counter');
            }
        });
    }
}

/**
 * Test queue functionality
 */
function testQueue() {
    window.open('<?php echo site_url('admin/queue/department/' . $department); ?>', '_blank');
}

/**
 * Toast notifications
 */
function showSuccessToast(message) {
    if (typeof toastr !== 'undefined') {
        toastr.success(message);
    } else {
        alert(message);
    }
}

function showErrorToast(message) {
    if (typeof toastr !== 'undefined') {
        toastr.error(message);
    } else {
        alert(message);
    }
}
</script>

<style>
.form-horizontal .control-label {
    text-align: left;
}

.input-group .form-control:not(:first-child):not(:last-child) {
    border-radius: 4px;
}

.btn-group-vertical .btn {
    margin-bottom: 5px;
}

.btn-group-vertical .btn:last-child {
    margin-bottom: 0;
}

.box-footer {
    background-color: #f4f4f4;
}

.help-block {
    margin-bottom: 0;
}

.table > tbody > tr > td {
    border-top: 1px solid #f4f4f4;
}

@media (max-width: 768px) {
    .form-horizontal .control-label {
        text-align: left;
        margin-bottom: 5px;
    }
    
    .form-horizontal .form-group {
        margin-left: 0;
        margin-right: 0;
    }
}
</style>