<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i> Items Management
            <small>Manage inventory items and stock levels</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/procurement"><i class="fa fa-shopping-cart"></i> Procurement</a></li>
            <li class="active">Items</li>
        </ol>
    </section>

    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-cubes"></i> Items List
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#newItemModal">
                        <i class="fa fa-plus"></i> New Item
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="itemsTable" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Item Name</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th>Unit Cost</th>
                                <th>Current Stock</th>
                                <th>Reorder Level</th>
                                <th>Stock Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (isset($items) && !empty($items)): ?>
                                <?php foreach ($items as $item): ?>
                                    <tr>
                                        <td><?php echo $item['item_code']; ?></td>
                                        <td><?php echo $item['item_name']; ?></td>
                                        <td><?php echo isset($item['category_name']) ? $item['category_name'] : 'N/A'; ?></td>
                                        <td><?php echo $item['unit_of_measure']; ?></td>
                                        <td>KES <?php echo number_format($item['unit_cost'], 2); ?></td>
                                        <td><?php echo $item['current_stock']; ?></td>
                                        <td><?php echo $item['reorder_level']; ?></td>
                                        <td>
                                            <?php if ($item['current_stock'] <= 0): ?>
                                                <span class="label label-danger">Out of Stock</span>
                                            <?php elseif ($item['current_stock'] <= $item['reorder_level']): ?>
                                                <span class="label label-warning">Low Stock</span>
                                            <?php else: ?>
                                                <span class="label label-success">In Stock</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button class="btn btn-xs btn-info" onclick="viewItem(<?php echo $item['id']; ?>)">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                                <button class="btn btn-xs btn-warning" onclick="editItem(<?php echo $item['id']; ?>)">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="9" class="text-center text-muted">No items found. Add some items to get started.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- New Item Modal -->
<div class="modal fade" id="newItemModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form id="itemForm" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-plus"></i> Add New Item
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Item Name <span class="text-red">*</span></label>
                                <input type="text" name="item_name" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Item Code</label>
                                <input type="text" name="item_code" class="form-control" placeholder="Auto-generated if empty">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Category <span class="text-red">*</span></label>
                                <select name="category_id" class="form-control" required>
                                    <option value="">Select Category</option>
                                    <?php if (isset($categories)): ?>
                                        <?php foreach ($categories as $category): ?>
                                            <option value="<?php echo $category['id']; ?>">
                                                <?php echo $category['category_name']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Unit of Measure</label>
                                <select name="unit_of_measure" class="form-control">
                                    <option value="pieces">Pieces</option>
                                    <option value="box">Box</option>
                                    <option value="tablets">Tablets</option>
                                    <option value="vials">Vials</option>
                                    <option value="liters">Liters</option>
                                    <option value="kg">Kilograms</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Unit Cost</label>
                                <input type="number" name="unit_cost" class="form-control" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Current Stock</label>
                                <input type="number" name="current_stock" class="form-control" min="0" value="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Minimum Stock</label>
                                <input type="number" name="minimum_stock" class="form-control" min="0" value="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Reorder Level</label>
                                <input type="number" name="reorder_level" class="form-control" min="0" value="0">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Item
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable if not already done in PHP
    if (!$.fn.DataTable.isDataTable('#itemsTable')) {
        $('#itemsTable').DataTable({
            order: [[1, 'asc']],
            responsive: true
        });
    }

    // Form submission
    $('#itemForm').on('submit', function(e) {
        e.preventDefault();
        
        $.ajax({
            url: '<?php echo base_url("admin/procurement/saveItem"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#newItemModal').modal('hide');
                    location.reload(); // Reload page to show new item
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message, 'error');
                }
            }
        });
    });
});

function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible">';
    alertHtml += '<button type="button" class="close" data-dismiss="alert">&times;</button>';
    alertHtml += message + '</div>';
    $('section.content').prepend(alertHtml);
    setTimeout(function() { $('.alert').fadeOut(); }, 5000);
}
</script>