<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patient Barcode - <?php echo $patient->patient_name; ?></title>
    <style>
        /* PRINT STYLES - Only show barcode when printing */
        @media print {
            * {
                margin: 0 !important;
                padding: 0 !important;
                box-sizing: border-box;
            }
            
            body {
                margin: 0;
                padding: 20px;
                background: white;
                font-family: Arial, sans-serif;
            }
            
            /* Hide everything except barcode section when printing */
            .no-print,
            .hospital-header,
            .patient-info,
            .footer-info,
            .print-button {
                display: none !important;
            }
            
            /* Show only barcode */
            .barcode-only-print {
                width: 100%;
                max-width: 700px;
                margin: 0 auto;
                text-align: center;
                page-break-inside: avoid;
            }
            
            .barcode-image {
                width: 100%;
                max-width: 650px;
                height: auto;
                margin: 0 auto;
                display: block;
            }
            
            .barcode-container {
                border: none;
                box-shadow: none;
                padding: 0;
                margin: 0;
            }
        }
        
        /* SCREEN STYLES - Show preview on screen */
        @media screen {
            body {
                font-family: Arial, sans-serif;
                padding: 20px;
                background: #f0f0f0;
            }
            
            .preview-notice {
                text-align: center;
                margin-bottom: 20px;
                padding: 15px;
                background: #e3f2fd;
                border-radius: 5px;
                border-left: 4px solid #2196f3;
            }
            
            .barcode-container {
                max-width: 700px;
                margin: 0 auto;
                background: white;
                padding: 30px;
                border: 1px solid #ddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            }
            
            .hospital-header {
                text-align: center;
                margin-bottom: 20px;
                border-bottom: 2px solid #333;
                padding-bottom: 10px;
            }
            
            .patient-info table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 15px;
            }
            
            .patient-info td {
                padding: 5px 8px;
                border-bottom: 1px solid #eee;
            }
            
            .patient-info td:first-child {
                font-weight: bold;
                width: 35%;
            }
            
            .barcode-section {
                text-align: center;
                margin: 20px 0;
                padding: 20px;
                border: 2px solid #4caf50;
                border-radius: 8px;
                background: #f8fff8;
            }
            
            .barcode-image {
                max-width: 100%;
                height: auto;
                border: 1px solid #ddd;
                border-radius: 4px;
                padding: 10px;
                background: white;
            }
            
            .barcode-info {
                margin-top: 15px;
                padding: 10px;
                background: #fff3cd;
                border-radius: 4px;
                font-size: 12px;
                color: #856404;
            }
            
            .print-button {
                text-align: center;
                margin: 20px 0;
            }
            
            .btn {
                padding: 12px 24px;
                margin: 0 5px;
                border: none;
                border-radius: 4px;
                cursor: pointer;
                font-size: 14px;
                font-weight: bold;
            }
            
            .btn-primary {
                background: #007bff;
                color: white;
            }
            
            .btn-secondary {
                background: #6c757d;
                color: white;
            }
            
            .btn:hover {
                opacity: 0.8;
            }
            
            .footer-info {
                text-align: center;
                margin-top: 20px;
                font-size: 12px;
                color: #666;
                border-top: 1px solid #eee;
                padding-top: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Screen Preview Notice -->
    <div class="preview-notice no-print">
        <h3>🖨️ Print Preview - Barcode Only</h3>
        <p><strong>When printed, only the barcode will appear on the page.</strong></p>
        <p>Patient: <?php echo htmlspecialchars($patient->patient_name); ?> (ID: <?php echo htmlspecialchars($patient->id); ?>)</p>
    </div>

    <div class="barcode-container">
        <!-- Hospital Header (only visible on screen) -->
        <div class="hospital-header no-print">
            <h2><?php echo !empty($hospital_name) ? $hospital_name : 'Hospital Management System'; ?></h2>
            <h3>Patient Barcode Label</h3>
        </div>
        
        <!-- Patient Info (only visible on screen) -->
        <div class="patient-info no-print">
            <table>
                <tr><td>Patient Name:</td><td><?php echo htmlspecialchars($patient->patient_name); ?></td></tr>
                <tr><td>Patient ID:</td><td><strong><?php echo htmlspecialchars($patient->id); ?></strong></td></tr>
                <tr><td>Phone:</td><td><?php echo !empty($patient->mobileno) ? htmlspecialchars($patient->mobileno) : 'N/A'; ?></td></tr>
                <tr><td>Age:</td><td><?php echo !empty($patient->age) ? htmlspecialchars($patient->age) . ' years' : 'N/A'; ?></td></tr>
                <tr><td>Gender:</td><td><?php echo !empty($patient->gender) ? ucfirst(htmlspecialchars($patient->gender)) : 'N/A'; ?></td></tr>
            </table>
        </div>
        
        <!-- BARCODE SECTION - This will be the ONLY thing that prints -->
        <div class="barcode-only-print">
            <div class="barcode-section">
                <?php if (!empty($barcode_image)) { ?>
                    <!-- Generated barcode from patient name -->
                    <img src="<?php echo $barcode_image; ?>" alt="Patient Barcode" class="barcode-image">
                    
                <?php } elseif (!empty($patient->barcode)) { ?>
                    <!-- Fallback: existing barcode -->
                    <img src="<?php echo $patient->barcode; ?>" alt="Patient Barcode" class="barcode-image">
                    
                <?php } else { ?>
                    <!-- Final fallback: text representation -->
                    <div style="padding: 30px; border: 2px dashed #999; font-family: 'Courier New', monospace; background: white;">
                        <div style="font-size: 24px; margin-bottom: 15px; letter-spacing: 2px;">
                            <?php 
                            // Create visual pattern from patient name
                            $cleanName = strtoupper(preg_replace('/[^A-Za-z0-9\s]/', '', $patient->patient_name));
                            $pattern = '';
                            for ($i = 0; $i < strlen($cleanName) && $i < 20; $i++) {
                                $char = $cleanName[$i];
                                if (ctype_alpha($char)) {
                                    $pattern .= '|||';
                                } elseif (ctype_digit($char)) {
                                    $pattern .= '||';
                                } elseif ($char == ' ') {
                                    $pattern .= '  ';
                                } else {
                                    $pattern .= '|';
                                }
                                $pattern .= ' ';
                            }
                            echo htmlspecialchars($pattern);
                            ?>
                        </div>
                        <div style="font-size: 16px; font-weight: bold;">
                            <?php echo htmlspecialchars($cleanName); ?> ID:<?php echo htmlspecialchars($patient->id); ?>
                        </div>
                    </div>
                <?php } ?>
                
                <!-- Barcode info (only visible on screen) -->
                <div class="barcode-info no-print">
                    <strong>📊 What this barcode contains:</strong><br>
                    Patient Name: <?php echo htmlspecialchars($patient->patient_name); ?><br>
                    Patient ID: <?php echo htmlspecialchars($patient->id); ?><br>
                    Encoded as: <?php 
                        $cleanName = strtoupper(preg_replace('/[^A-Za-z0-9\s]/', '', $patient->patient_name));
                        $cleanName = trim(preg_replace('/\s+/', ' ', $cleanName));
                        if (strlen($cleanName) > 25) {
                            $cleanName = substr($cleanName, 0, 25);
                        }
                        echo htmlspecialchars($cleanName . " ID:" . $patient->id);
                    ?>
                </div>
            </div>
        </div>
        
        <!-- Footer (only visible on screen) -->
        <div class="footer-info no-print">
            <p>Generated on: <?php echo $print_date; ?></p>
            <p>When printed, only the barcode above will appear on the page</p>
        </div>
        
        <!-- Print Buttons (only visible on screen) -->
        <div class="print-button no-print">
            <button onclick="window.print();" class="btn btn-primary">
                🖨️ Print Barcode Only
            </button>
            <button onclick="window.close();" class="btn btn-secondary">
                ❌ Close
            </button>
        </div>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            setTimeout(function() { 
                window.print(); 
            }, 1000);
        });
        
        // Debug info
        console.log('🏷️ Barcode-only print page loaded');
        console.log('Patient: <?php echo addslashes($patient->patient_name); ?>');
        console.log('Patient ID: <?php echo $patient->id; ?>');
        console.log('Barcode available: <?php echo !empty($barcode_image) ? "Yes" : "No"; ?>');
    </script>
</body>
</html>