<?php $currency_symbol = $this->customlib->getHospitalCurrencyFormat(); ?>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- Dashboard Stats -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="total_medicines"><?php echo $dashboard_stats['total_medicines'] ?? 0; ?></h3>
                        <p><?php echo $this->lang->line('total_medicines'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-medkit"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/pharmacy" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="low_stock_count"><?php echo $dashboard_stats['low_stock_count'] ?? 0; ?></h3>
                        <p><?php echo $this->lang->line('low_stock_medicines'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="#" onclick="showLowStockMedicines()" class="small-box-footer">
                        <?php echo $this->lang->line('view_details'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $currency_symbol; ?><span id="today_sales"><?php echo number_format($dashboard_stats['today_sales'] ?? 0, 2); ?></span></h3>
                        <p><?php echo $this->lang->line('today_sales'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-shopping-cart"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/pharmacy/billreport" class="small-box-footer">
                        <?php echo $this->lang->line('view_bills'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="expired_count"><?php echo $dashboard_stats['expired_count'] ?? 0; ?></h3>
                        <p><?php echo $this->lang->line('expired_medicines'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-ban"></i>
                    </div>
                    <a href="#" onclick="showExpiredMedicines()" class="small-box-footer">
                        <?php echo $this->lang->line('view_details'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Quick Actions Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('patient_search_pharmacy'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('search_patient'); ?></label>
                                    <div class="input-group">
                                        <input type="text" id="patient_search_main" class="form-control" 
                                               placeholder="<?php echo $this->lang->line('enter_patient_name_id_phone'); ?>" autocomplete="off">
                                        <span class="input-group-btn">
                                            <button class="btn btn-primary" type="button" onclick="clearPatientSearch()">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <div id="patient_search_results_main" class="search-results"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('selected_patient'); ?></label>
                                    <div id="selected_patient_display" class="selected-patient-display">
                                        <div class="alert alert-info">
                                            <i class="fa fa-info-circle"></i> <?php echo $this->lang->line('no_patient_selected'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Patient Actions -->
                        <div class="row" id="patient_actions" style="display: none;">
                            <div class="col-md-12">
                                <div class="btn-group btn-group-justified" role="group">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-success" onclick="createNewBill()">
                                            <i class="fa fa-plus"></i> <?php echo $this->lang->line('create_pharmacy_bill'); ?>
                                        </button>
                                    </div>
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-info" onclick="viewPatientHistory()">
                                            <i class="fa fa-history"></i> <?php echo $this->lang->line('pharmacy_history'); ?>
                                        </button>
                                    </div>
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-warning" onclick="viewPendingBills()">
                                            <i class="fa fa-exclamation-circle"></i> <?php echo $this->lang->line('pending_bills'); ?>
                                        </button>
                                    </div>
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-primary" onclick="quickDispenseModal()">
                                            <i class="fa fa-shopping-cart"></i> <?php echo $this->lang->line('quick_dispense'); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions Grid -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-medkit"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $this->lang->line('medicine_stock'); ?></span>
                        <span class="info-box-number"><?php echo $this->lang->line('manage'); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <a href="<?php echo base_url(); ?>admin/pharmacy" class="btn btn-sm btn-primary">
                                <?php echo $this->lang->line('view_stock'); ?>
                            </a>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-shopping-cart"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $this->lang->line('pharmacy_billing'); ?></span>
                        <span class="info-box-number"><?php echo $this->lang->line('manage'); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <a href="<?php echo base_url(); ?>admin/pharmacy/bill" class="btn btn-sm btn-success">
                                <?php echo $this->lang->line('create_bill'); ?>
                            </a>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-plus"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $this->lang->line('purchase_medicine'); ?></span>
                        <span class="info-box-number"><?php echo $this->lang->line('add_stock'); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <a href="<?php echo base_url(); ?>admin/pharmacy/purchase" class="btn btn-sm btn-warning">
                                <?php echo $this->lang->line('purchase'); ?>
                            </a>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-file-text"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $this->lang->line('reports'); ?></span>
                        <span class="info-box-number"><?php echo $this->lang->line('view'); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <a href="<?php echo base_url(); ?>admin/pharmacy/billreport" class="btn btn-sm btn-danger">
                                <?php echo $this->lang->line('view_reports'); ?>
                            </a>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities & Alerts -->
        <div class="row">
            <!-- Recent Pharmacy Bills -->
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo $this->lang->line('recent_pharmacy_bills'); ?></h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshRecentBills()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" id="recent_bills_content">
                        <!-- Recent bills will be loaded here -->
                        <div class="text-center">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo $this->lang->line('loading'); ?>...
                        </div>
                    </div>
                </div>
            </div>

            <!-- Alerts & Notifications -->
            <div class="col-md-4">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo $this->lang->line('alerts_notifications'); ?></h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshAlerts()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" id="alerts_content">
                        <!-- Alerts will be loaded here -->
                        <div class="text-center">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo $this->lang->line('loading'); ?>...
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Medicine Search Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('medicine_search'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('search_medicine'); ?></label>
                                    <input type="text" id="medicine_search" class="form-control" 
                                           placeholder="<?php echo $this->lang->line('enter_medicine_name'); ?>" autocomplete="off">
                                    <div id="medicine_search_results" class="search-results"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('filter_by_category'); ?></label>
                                    <select id="medicine_category_filter" class="form-control">
                                        <option value=""><?php echo $this->lang->line('all_categories'); ?></option>
                                        <?php foreach ($medicineCategory as $category) { ?>
                                            <option value="<?php echo $category['id']; ?>">
                                                <?php echo $category['medicine_category']; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div id="medicine_search_display" style="display: none;">
                            <!-- Medicine search results will be displayed here -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Patient History Modal -->
<div class="modal fade" id="patientHistoryModal" role="dialog" aria-labelledby="patientHistoryModalLabel">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('patient_pharmacy_history'); ?></h4> 
            </div>
            <div class="modal-body" id="patient_history_content">
                <!-- Patient history will be loaded here -->
            </div>
        </div>
    </div>    
</div>

<!-- Quick Dispense Modal -->
<div class="modal fade" id="quickDispenseModal" role="dialog" aria-labelledby="quickDispenseModalLabel">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('quick_medicine_dispense'); ?></h4> 
            </div>
            <div class="modal-body" id="quick_dispense_content">
                <!-- Quick dispense form will be loaded here -->
            </div>
        </div>
    </div>    
</div>

<!-- Medicine Details Modal -->
<div class="modal fade" id="medicineDetailsModal" role="dialog" aria-labelledby="medicineDetailsModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('medicine_details'); ?></h4> 
            </div>
            <div class="modal-body" id="medicine_details_content">
                <!-- Medicine details will be loaded here -->
            </div>
        </div>
    </div>    
</div>

<style>
.search-results {
    position: absolute;
    z-index: 1000;
    background: white;
    border: 1px solid #ddd;
    border-top: none;
    max-height: 250px;
    overflow-y: auto;
    width: 100%;
    display: none;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

.search-results .search-item {
    padding: 12px 15px;
    border-bottom: 1px solid #eee;
    cursor: pointer;
    transition: background-color 0.2s;
}

.search-results .search-item:hover {
    background-color: #f8f9fa;
}

.search-results .search-item:last-child {
    border-bottom: none;
}

.selected-patient-display {
    min-height: 80px;
}

.selected-patient-info {
    background: #e8f5e8;
    border: 1px solid #4CAF50;
    border-radius: 5px;
    padding: 15px;
}

.selected-patient-info h5 {
    margin: 0 0 10px 0;
    color: #2e7d32;
}

.selected-patient-info .patient-meta {
    font-size: 0.9em;
    color: #666;
}

.info-box:hover {
    transform: translateY(-2px);
    transition: transform 0.2s;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.small-box:hover {
    transform: translateY(-2px);
    transition: transform 0.2s;
}

.medicine-item {
    background: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 15px;
    margin-bottom: 10px;
    cursor: pointer;
    transition: all 0.2s;
}

.medicine-item:hover {
    background: #e8f5e8;
    border-color: #4CAF50;
}

.stock-badge {
    position: absolute;
    top: 10px;
    right: 10px;
}

.recent-bill-item {
    padding: 10px;
    border-bottom: 1px solid #eee;
    cursor: pointer;
}

.recent-bill-item:hover {
    background-color: #f8f9fa;
}

.alert-item {
    padding: 8px 12px;
    margin-bottom: 8px;
    border-radius: 4px;
    font-size: 0.9em;
}

.alert-low-stock {
    background-color: #fff3cd;
    border: 1px solid #ffeaa7;
    color: #856404;
}

.alert-expired {
    background-color: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
}

.alert-expiring {
    background-color: #d1ecf1;
    border: 1px solid #bee5eb;
    color: #0c5460;
}
</style>

<script type="text/javascript">
$(document).ready(function() {
    // Initialize the page
    loadRecentBills();
    loadAlerts();
    
    // Auto-refresh every 5 minutes
    setInterval(function() {
        loadRecentBills();
        loadAlerts();
        updateDashboardStats();
    }, 300000);
});

// Global variables
var selectedPatientId = null;
var selectedPatientData = null;

// Patient search functionality
$('#patient_search_main').on('input', function() {
    var searchTerm = $(this).val();
    if (searchTerm.length >= 2) {
        searchPatients(searchTerm, 'main');
    } else {
        $('#patient_search_results_main').hide();
    }
});

// Medicine search functionality
$('#medicine_search').on('input', function() {
    var searchTerm = $(this).val();
    var category = $('#medicine_category_filter').val();
    
    if (searchTerm.length >= 2) {
        searchMedicines(searchTerm, category);
    } else {
        $('#medicine_search_results').hide();
        $('#medicine_search_display').hide();
    }
});

$('#medicine_category_filter').on('change', function() {
    var searchTerm = $('#medicine_search').val();
    var category = $(this).val();
    
    if (searchTerm.length >= 2) {
        searchMedicines(searchTerm, category);
    }
});

// Search patients function
function searchPatients(searchTerm, target = 'main') {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient/searchPatients',
        type: 'POST',
        data: { search_term: searchTerm },
        dataType: 'json',
        success: function(response) {
            if (response.status && response.patients.length > 0) {
                displayPatientSearchResults(response.patients, target);
            } else {
                $('#patient_search_results_' + target).hide();
            }
        },
        error: function() {
            $('#patient_search_results_' + target).hide();
        }
    });
}

// Display patient search results
function displayPatientSearchResults(patients, target = 'main') {
    var html = '';
    $.each(patients, function(index, patient) {
        html += '<div class="search-item" onclick="selectPatient(' + patient.id + ', \'' + 
                patient.patient_name.replace(/'/g, "\\'") + '\', \'' + 
                patient.patient_unique_id + '\', \'' + target + '\')">';
        html += '<strong>' + patient.patient_name + '</strong><br>';
        html += '<small>ID: ' + patient.patient_unique_id + ' | Phone: ' + (patient.mobileno || 'N/A');
        
        // Add pharmacy summary if available
        if (patient.pharmacy_summary) {
            html += ' | Bills: ' + patient.pharmacy_summary.total_bills;
            if (patient.pharmacy_summary.balance_amount > 0) {
                html += ' | Balance: <?php echo $currency_symbol; ?>' + patient.pharmacy_summary.balance_amount;
            }
        }
        html += '</small></div>';
    });
    $('#patient_search_results_' + target).html(html).show();
}

// Select a patient
function selectPatient(patientId, patientName, patientUniqueId, target = 'main') {
    selectedPatientId = patientId;
    selectedPatientData = {
        id: patientId,
        name: patientName,
        unique_id: patientUniqueId
    };
    
    $('#patient_search_' + target).val(patientName);
    $('#patient_search_results_' + target).hide();
    
    if (target === 'main') {
        displaySelectedPatient();
        $('#patient_actions').show();
    }
}

// Display selected patient information
function displaySelectedPatient() {
    if (!selectedPatientData) return;
    
    // Get detailed patient information
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient/getPatientForPharmacy',
        type: 'POST',
        data: { patient_id: selectedPatientId },
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                var patient = response.data.patient;
                var summary = response.data.pharmacy_summary;
                
                var html = '<div class="selected-patient-info">';
                html += '<h5><i class="fa fa-user"></i> ' + patient.patient_name + '</h5>';
                html += '<div class="patient-meta">';
                html += '<strong>ID:</strong> ' + patient.patient_unique_id + ' | ';
                html += '<strong>Phone:</strong> ' + (patient.mobileno || 'N/A') + ' | ';
                html += '<strong>Age:</strong> ' + (patient.age || 'N/A') + '<br>';
                html += '<strong>Total Bills:</strong> ' + summary.total_bills + ' | ';
                html += '<strong>Total Amount:</strong> <?php echo $currency_symbol; ?>' + summary.total_amount + ' | ';
                html += '<strong>Balance:</strong> <span class="' + (summary.balance_amount > 0 ? 'text-danger' : 'text-success') + '">'; 
                html += '<?php echo $currency_symbol; ?>' + Math.abs(summary.balance_amount) + '</span>';
                if (summary.last_visit) {
                    html += '<br><strong>Last Visit:</strong> ' + formatDate(summary.last_visit);
                }
                html += '</div></div>';
                
                $('#selected_patient_display').html(html);
            }
        }
    });
}

// Clear patient search
function clearPatientSearch() {
    selectedPatientId = null;
    selectedPatientData = null;
    $('#patient_search_main').val('');
    $('#patient_search_results_main').hide();
    $('#selected_patient_display').html('<div class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo $this->lang->line('no_patient_selected'); ?></div>');
    $('#patient_actions').hide();
}

// Search medicines function
function searchMedicines(searchTerm, category = '') {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/searchMedicinesForDispensing',
        type: 'POST',
        data: { 
            search_term: searchTerm,
            category_id: category
        },
        dataType: 'json',
        success: function(response) {
            if (response.status && response.medicines.length > 0) {
                displayMedicineSearchResults(response.medicines);
            } else {
                $('#medicine_search_results').hide();
                $('#medicine_search_display').hide();
            }
        }
    });
}

// Display medicine search results
function displayMedicineSearchResults(medicines) {
    var html = '';
    var displayHtml = '<div class="row">';
    
    $.each(medicines, function(index, medicine) {
        // Search dropdown results
        html += '<div class="search-item" onclick="selectMedicine(' + medicine.id + ')">';
        html += '<strong>' + medicine.medicine_name + '</strong><br>';
        html += '<small>' + medicine.company_name + ' | Available: ' + medicine.available_qty + '</small>';
        html += '</div>';
        
        // Detailed display
        if (index < 8) { // Limit to 8 results in detailed view
            displayHtml += '<div class="col-md-3">';
            displayHtml += '<div class="medicine-item" onclick="viewMedicineDetails(' + medicine.id + ')">';
            displayHtml += '<h6>' + medicine.medicine_name + '</h6>';
            displayHtml += '<small class="text-muted">' + medicine.company_name + '</small><br>';
            displayHtml += '<small><strong>Available:</strong> ' + medicine.available_qty + ' ' + medicine.unit_name + '</small>';
            
            // Stock status badge
            if (medicine.available_qty <= 0) {
                displayHtml += '<span class="label label-danger stock-badge">Out of Stock</span>';
            } else if (medicine.available_qty <= 10) {
                displayHtml += '<span class="label label-warning stock-badge">Low Stock</span>';
            } else {
                displayHtml += '<span class="label label-success stock-badge">In Stock</span>';
            }
            
            if (selectedPatientId && medicine.available_qty > 0) {
                displayHtml += '<br><br><button class="btn btn-xs btn-primary" onclick="quickDispenseMedicine(' + medicine.id + ')">Quick Dispense</button>';
            }
            
            displayHtml += '</div></div>';
        }
    });
    
    displayHtml += '</div>';
    
    $('#medicine_search_results').html(html).show();
    $('#medicine_search_display').html(displayHtml).show();
}

// Patient action functions
function createNewBill() {
    if (!selectedPatientId) {
        alert('<?php echo $this->lang->line('please_select_patient'); ?>');
        return;
    }
    
    // Redirect to pharmacy bill page with patient pre-selected
    window.location.href = '<?php echo base_url(); ?>admin/pharmacy/bill?patient_id=' + selectedPatientId;
}

function viewPatientHistory() {
    if (!selectedPatientId) {
        alert('<?php echo $this->lang->line('please_select_patient'); ?>');
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getPatientBills',
        type: 'POST',
        data: { patient_id: selectedPatientId },
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                $('#patient_history_content').html(response.page);
                $('#patientHistoryModal').modal('show');
            } else {
                alert('<?php echo $this->lang->line('no_bills_found'); ?>');
            }
        }
    });
}

function viewPendingBills() {
    if (!selectedPatientId) {
        alert('<?php echo $this->lang->line('please_select_patient'); ?>');
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getPatientPendingBills',
        type: 'POST',
        data: { patient_id: selectedPatientId },
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                $('#patient_history_content').html(response.page);
                $('#patientHistoryModal').modal('show');
            } else {
                alert('<?php echo $this->lang->line('no_pending_bills'); ?>');
            }
        }
    });
}

function quickDispenseModal() {
    if (!selectedPatientId) {
        alert('<?php echo $this->lang->line('please_select_patient_first'); ?>');
        return;
    }
    
    // Load quick dispense interface
    var html = '<div class="row">';
    html += '<div class="col-md-12">';
    html += '<div class="alert alert-info">';
    html += '<h5><i class="fa fa-user"></i> Patient: ' + selectedPatientData.name + ' (' + selectedPatientData.unique_id + ')</h5>';
    html += '</div>';
    html += '</div>';
    html += '<div class="col-md-12">';
    html += '<div class="form-group">';
    html += '<label>Search Medicine to Dispense</label>';
    html += '<input type="text" id="dispense_medicine_search" class="form-control" placeholder="Enter medicine name..." autocomplete="off">';
    html += '<div id="dispense_medicine_results" class="search-results"></div>';
    html += '</div>';
    html += '</div>';
    html += '</div>';
    html += '<div id="dispense_medicine_form" style="display: none;"></div>';
    
    $('#quick_dispense_content').html(html);
    $('#quickDispenseModal').modal('show');
    
    // Bind medicine search for dispensing
    $('#dispense_medicine_search').on('input', function() {
        var searchTerm = $(this).val();
        if (searchTerm.length >= 2) {
            searchMedicinesForDispensing(searchTerm);
        } else {
            $('#dispense_medicine_results').hide();
        }
    });
}

function searchMedicinesForDispensing(searchTerm) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/searchMedicinesForDispensing',
        type: 'POST',
        data: { search_term: searchTerm },
        dataType: 'json',
        success: function(response) {
            if (response.status && response.medicines.length > 0) {
                var html = '';
                $.each(response.medicines, function(index, medicine) {
                    if (medicine.available_qty > 0) {
                        html += '<div class="search-item" onclick="selectMedicineForDispensing(' + medicine.id + ', \'' + 
                                medicine.medicine_name.replace(/'/g, "\\'") + '\')">';
                        html += '<strong>' + medicine.medicine_name + '</strong><br>';
                        html += '<small>' + medicine.company_name + ' | Available: ' + medicine.available_qty + ' ' + medicine.unit_name + '</small>';
                        html += '</div>';
                    }
                });
                $('#dispense_medicine_results').html(html).show();
            } else {
                $('#dispense_medicine_results').hide();
            }
        }
    });
}

function selectMedicineForDispensing(medicineId, medicineName) {
    $('#dispense_medicine_search').val(medicineName);
    $('#dispense_medicine_results').hide();
    
    // Load quick dispense form for selected medicine
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/quickDispense',
        type: 'POST',
        data: { 
            patient_id: selectedPatientId,
            medicine_id: medicineId
        },
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                $('#dispense_medicine_form').html(response.page).show();
            } else {
                alert(response.message || '<?php echo $this->lang->line('error_loading_form'); ?>');
            }
        }
    });
}

// Medicine functions
function selectMedicine(medicineId) {
    $('#medicine_search_results').hide();
    viewMedicineDetails(medicineId);
}

function viewMedicineDetails(medicineId) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getDetails',
        type: 'POST',
        data: { pharmacy_id: medicineId },
        dataType: 'json',
        success: function(response) {
            if (response) {
                var html = '<div class="row">';
                html += '<div class="col-md-4">';
                if (response.medicine_image) {
                    html += '<img src="<?php echo base_url(); ?>' + response.medicine_image + '" class="img-responsive" style="max-height: 200px;">';
                } else {
                    html += '<img src="<?php echo base_url(); ?>uploads/patient_images/no_image.png" class="img-responsive" style="max-height: 200px;">';
                }
                html += '</div>';
                html += '<div class="col-md-8">';
                html += '<table class="table table-striped">';
                html += '<tr><th>Medicine Name</th><td>' + response.medicine_name + '</td></tr>';
                html += '<tr><th>Company</th><td>' + (response.company_name || 'N/A') + '</td></tr>';
                html += '<tr><th>Composition</th><td>' + (response.medicine_composition || 'N/A') + '</td></tr>';
                html += '<tr><th>Category</th><td>' + (response.medicine_category || 'N/A') + '</td></tr>';
                html += '<tr><th>Unit</th><td>' + (response.unit_name || 'N/A') + '</td></tr>';
                html += '<tr><th>Min Level</th><td>' + (response.min_level || 'N/A') + '</td></tr>';
                html += '<tr><th>Reorder Level</th><td>' + (response.reorder_level || 'N/A') + '</td></tr>';
                html += '</table>';
                html += '</div>';
                html += '</div>';
                
                // Add batch information
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/pharmacy/getMedicineBatch',
                    type: 'POST',
                    data: { pharmacy_id: medicineId },
                    success: function(batchData) {
                        html += '<hr><h5>Batch Information</h5>' + batchData;
                        $('#medicine_details_content').html(html);
                        $('#medicineDetailsModal').modal('show');
                    }
                });
            }
        }
    });
}

function quickDispenseMedicine(medicineId) {
    if (!selectedPatientId) {
        alert('<?php echo $this->lang->line('please_select_patient_first'); ?>');
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/quickDispense',
        type: 'POST',
        data: { 
            patient_id: selectedPatientId,
            medicine_id: medicineId
        },
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                $('#quick_dispense_content').html(response.page);
                $('#quickDispenseModal').modal('show');
            } else {
                alert(response.message || '<?php echo $this->lang->line('error_creating_bill'); ?>');
            }
        }
    });
}

// Dashboard functions
function updateDashboardStats() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getDashboardStats',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                $('#total_medicines').text(response.stats.total_medicines);
                $('#low_stock_count').text(response.stats.low_stock_count);
                $('#today_sales').text(parseFloat(response.stats.today_sales).toFixed(2));
                $('#expired_count').text(response.stats.expired_count);
            }
        }
    });
}

function loadRecentBills() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getRecentBills',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                var html = '';
                if (response.bills.length > 0) {
                    $.each(response.bills, function(index, bill) {
                        html += '<div class="recent-bill-item" onclick="viewBillDetails(' + bill.id + ')">';
                        html += '<div class="row">';
                        html += '<div class="col-md-6">';
                        html += '<strong>Bill #' + bill.bill_no + '</strong><br>';
                        html += '<small>' + bill.patient_name + ' (' + bill.patient_unique_id + ')</small>';
                        html += '</div>';
                        html += '<div class="col-md-3 text-right">';
                        html += '<strong><?php echo $currency_symbol; ?>' + parseFloat(bill.net_amount).toFixed(2) + '</strong><br>';
                        html += '<small>' + formatDate(bill.date) + '</small>';
                        html += '</div>';
                        html += '<div class="col-md-3 text-right">';
                        if (bill.balance > 0) {
                            html += '<span class="label label-warning">Pending</span>';
                        } else if (bill.balance < 0) {
                            html += '<span class="label label-info">Refund Due</span>';
                        } else {
                            html += '<span class="label label-success">Paid</span>';
                        }
                        html += '</div>';
                        html += '</div>';
                        html += '</div>';
                    });
                } else {
                    html = '<div class="text-center text-muted"><i class="fa fa-info-circle"></i> No recent bills found</div>';
                }
                $('#recent_bills_content').html(html);
            }
        },
        error: function() {
            $('#recent_bills_content').html('<div class="text-center text-danger"><i class="fa fa-exclamation-triangle"></i> Error loading recent bills</div>');
        }
    });
}

function loadAlerts() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getPharmacyAlerts',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status) {
                var html = '';
                
                // Low stock alerts
                if (response.alerts.low_stock.length > 0) {
                    $.each(response.alerts.low_stock, function(index, medicine) {
                        html += '<div class="alert-item alert-low-stock">';
                        html += '<i class="fa fa-exclamation-triangle"></i> ';
                        html += '<strong>Low Stock:</strong> ' + medicine.medicine_name + ' (' + medicine.available_qty + ' left)';
                        html += '</div>';
                    });
                }
                
                // Expired medicines
                if (response.alerts.expired.length > 0) {
                    $.each(response.alerts.expired, function(index, medicine) {
                        html += '<div class="alert-item alert-expired">';
                        html += '<i class="fa fa-ban"></i> ';
                        html += '<strong>Expired:</strong> ' + medicine.medicine_name + ' (Batch: ' + medicine.batch_no + ')';
                        html += '</div>';
                    });
                }
                
                // Expiring soon
                if (response.alerts.expiring_soon.length > 0) {
                    $.each(response.alerts.expiring_soon, function(index, medicine) {
                        html += '<div class="alert-item alert-expiring">';
                        html += '<i class="fa fa-clock-o"></i> ';
                        html += '<strong>Expiring Soon:</strong> ' + medicine.medicine_name + ' (' + medicine.expiry + ')';
                        html += '</div>';
                    });
                }
                
                if (html === '') {
                    html = '<div class="text-center text-success"><i class="fa fa-check-circle"></i> No alerts at this time</div>';
                }
                
                $('#alerts_content').html(html);
            }
        },
        error: function() {
            $('#alerts_content').html('<div class="text-center text-danger"><i class="fa fa-exclamation-triangle"></i> Error loading alerts</div>');
        }
    });
}

function refreshRecentBills() {
    $('#recent_bills_content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</div>');
    loadRecentBills();
}

function refreshAlerts() {
    $('#alerts_content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</div>');
    loadAlerts();
}

// Alert functions
function showLowStockMedicines() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getLowStockMedicines',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status && response.medicines.length > 0) {
                var html = '<div class="table-responsive"><table class="table table-striped">';
                html += '<thead><tr><th>Medicine</th><th>Category</th><th>Available</th><th>Min Level</th><th>Action</th></tr></thead><tbody>';
                
                $.each(response.medicines, function(index, medicine) {
                    html += '<tr>';
                    html += '<td>' + medicine.medicine_name + '</td>';
                    html += '<td>' + (medicine.medicine_category || 'N/A') + '</td>';
                    html += '<td><span class="label label-warning">' + medicine.total_qty + '</span></td>';
                    html += '<td>' + (medicine.min_level || 'N/A') + '</td>';
                    html += '<td><button class="btn btn-xs btn-primary" onclick="addStock(' + medicine.id + ')">Add Stock</button></td>';
                    html += '</tr>';
                });
                
                html += '</tbody></table></div>';
                $('#medicine_details_content').html(html);
                $('#medicineDetailsModal').modal('show');
            } else {
                alert('No low stock medicines found');
            }
        }
    });
}

function showExpiredMedicines() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getExpiredMedicines',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status && response.medicines.length > 0) {
                var html = '<div class="table-responsive"><table class="table table-striped">';
                html += '<thead><tr><th>Medicine</th><th>Batch No</th><th>Expiry Date</th><th>Quantity</th><th>Action</th></tr></thead><tbody>';
                
                $.each(response.medicines, function(index, medicine) {
                    html += '<tr>';
                    html += '<td>' + medicine.medicine_name + '</td>';
                    html += '<td>' + medicine.batch_no + '</td>';
                    html += '<td><span class="label label-danger">' + medicine.expiry + '</span></td>';
                    html += '<td>' + medicine.available_quantity + '</td>';
                    html += '<td><button class="btn btn-xs btn-danger" onclick="addBadStock(' + medicine.id + ')">Mark as Bad Stock</button></td>';
                    html += '</tr>';
                });
                
                html += '</tbody></table></div>';
                $('#medicine_details_content').html(html);
                $('#medicineDetailsModal').modal('show');
            } else {
                alert('No expired medicines found');
            }
        }
    });
}

// Utility functions
function formatDate(dateString) {
    var date = new Date(dateString);
    return date.toLocaleDateString() + ' ' + date.toLocaleTimeString();
}

function addStock(medicineId) {
    // Redirect to add stock page or open modal
    window.location.href = '<?php echo base_url(); ?>admin/pharmacy/purchase';
}

function addBadStock(medicineId) {
    // This would open the bad stock modal - integrate with existing functionality
    window.location.href = '<?php echo base_url(); ?>admin/pharmacy#addBadStock-' + medicineId;
}

function viewBillDetails(billId) {
    window.open('<?php echo base_url(); ?>admin/pharmacy/bill/details/' + billId, '_blank');
}

// Hide search results when clicking outside
$(document).click(function(e) {
    if (!$(e.target).closest('#patient_search_main, #patient_search_results_main').length) {
        $('#patient_search_results_main').hide();
    }
    if (!$(e.target).closest('#medicine_search, #medicine_search_results').length) {
        $('#medicine_search_results').hide();
    }
    if (!$(e.target).closest('#dispense_medicine_search, #dispense_medicine_results').length) {
        $('#dispense_medicine_results').hide();
    }
});

// Keyboard navigation for search results
$('#patient_search_main, #medicine_search').keydown(function(e) {
    var $results = $(this).siblings('.search-results');
    var $items = $results.find('.search-item');
    var $current = $items.filter('.selected');
    
    if (e.keyCode === 40) { // Down arrow
        e.preventDefault();
        if ($current.length === 0) {
            $items.first().addClass('selected');
        } else {
            $current.removeClass('selected').next().addClass('selected');
        }
    } else if (e.keyCode === 38) { // Up arrow
        e.preventDefault();
        if ($current.length === 0) {
            $items.last().addClass('selected');
        } else {
            $current.removeClass('selected').prev().addClass('selected');
        }
    } else if (e.keyCode === 13) { // Enter
        e.preventDefault();
        if ($current.length > 0) {
            $current.click();
        }
    } else if (e.keyCode === 27) { // Escape
        $results.hide();
    }
});
</script>