<?php
// File: admin/pharmacy/_quickDispense.php
?>
<form id="quickDispenseForm" method="post">
    <div class="row">
        <!-- Patient Information -->
        <div class="col-md-12">
            <div class="alert alert-info">
                <h4><i class="fa fa-user"></i> <?php echo $this->lang->line('patient_information'); ?></h4>
                <div class="row">
                    <div class="col-md-6">
                        <strong><?php echo $this->lang->line('name'); ?>:</strong> <?php echo $patient->patient_name; ?><br>
                        <strong><?php echo $this->lang->line('patient_id'); ?>:</strong> <?php echo $patient->patient_unique_id; ?>
                    </div>
                    <div class="col-md-6">
                        <strong><?php echo $this->lang->line('phone'); ?>:</strong> <?php echo $patient->mobileno ?: 'N/A'; ?><br>
                        <strong><?php echo $this->lang->line('age'); ?>:</strong> <?php echo $patient->age ?: 'N/A'; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Medicine Information -->
        <div class="col-md-12">
            <div class="alert alert-warning">
                <h4><i class="fa fa-medkit"></i> <?php echo $this->lang->line('medicine_information'); ?></h4>
                <div class="row">
                    <div class="col-md-6">
                        <strong><?php echo $this->lang->line('medicine_name'); ?>:</strong> <?php echo $medicine->medicine_name; ?><br>
                        <strong><?php echo $this->lang->line('company'); ?>:</strong> <?php echo $medicine->company_name; ?>
                    </div>
                    <div class="col-md-6">
                        <strong><?php echo $this->lang->line('composition'); ?>:</strong> <?php echo $medicine->medicine_composition; ?><br>
                        <strong><?php echo $this->lang->line('unit'); ?>:</strong> <?php echo $medicine->unit_name; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dispensing Form -->
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h4><?php echo $this->lang->line('dispensing_details'); ?></h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <!-- Batch Selection -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('batch_no'); ?> <span class="text-danger">*</span></label>
                                <select name="batch_id" id="batch_id" class="form-control" onchange="updateBatchDetails()" required>
                                    <option value=""><?php echo $this->lang->line('select_batch'); ?></option>
                                    <?php foreach ($batches as $batch) { ?>
                                        <option value="<?php echo $batch->id; ?>" 
                                                data-expiry="<?php echo $batch->expiry; ?>"
                                                data-available="<?php echo $batch->available_quantity; ?>"
                                                data-mrp="<?php echo $batch->mrp; ?>"
                                                data-sale-price="<?php echo $batch->sale_rate; ?>"
                                                data-batch-no="<?php echo $batch->batch_no; ?>">
                                            <?php echo $batch->batch_no; ?> (Available: <?php echo $batch->available_quantity; ?>)
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <!-- Expiry Date -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('expiry_date'); ?></label>
                                <input type="text" id="expiry_date" name="expiry_date" class="form-control" readonly>
                            </div>
                        </div>

                        <!-- Available Quantity -->
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('available_qty'); ?></label>
                                <input type="text" id="available_qty" class="form-control" readonly>
                            </div>
                        </div>

                        <!-- MRP -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('mrp'); ?> (<?php echo $currency_symbol; ?>)</label>
                                <input type="text" id="mrp" name="mrp" class="form-control" readonly>
                            </div>
                        </div>

                        <!-- Quantity to Dispense -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('quantity'); ?> <span class="text-danger">*</span></label>
                                <input type="number" name="quantity" id="quantity" class="form-control" 
                                       min="1" step="1" onchange="calculateAmount()" required>
                            </div>
                        </div>

                        <!-- Sale Price -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('sale_price'); ?> (<?php echo $currency_symbol; ?>) <span class="text-danger">*</span></label>
                                <input type="number" name="sale_price" id="sale_price" class="form-control" 
                                       step="0.01" min="0" onchange="calculateAmount()" required>
                            </div>
                        </div>

                        <!-- Total Amount -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('total_amount'); ?> (<?php echo $currency_symbol; ?>)</label>
                                <input type="text" id="total_amount" class="form-control" readonly>
                            </div>
                        </div>

                        <!-- Payment Mode -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('payment_mode'); ?></label>
                                <select name="payment_mode" class="form-control">
                                    <?php foreach ($payment_mode as $key => $value) { ?>
                                        <option value="<?php echo $key; ?>"><?php echo $value; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <!-- Instructions -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('instructions'); ?></label>
                                <textarea name="instructions" class="form-control" rows="3" 
                                         placeholder="<?php echo $this->lang->line('dosage_instructions'); ?>"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary -->
        <div class="col-md-12">
            <div class="alert alert-success" id="summary_section" style="display: none;">
                <h4><?php echo $this->lang->line('dispensing_summary'); ?></h4>
                <div class="row">
                    <div class="col-md-6">
                        <strong><?php echo $this->lang->line('patient'); ?>:</strong> <span id="summary_patient"><?php echo $patient->patient_name; ?></span><br>
                        <strong><?php echo $this->lang->line('medicine'); ?>:</strong> <span id="summary_medicine"><?php echo $medicine->medicine_name; ?></span><br>
                        <strong><?php echo $this->lang->line('batch'); ?>:</strong> <span id="summary_batch"></span>
                    </div>
                    <div class="col-md-6">
                        <strong><?php echo $this->lang->line('quantity'); ?>:</strong> <span id="summary_quantity"></span><br>
                        <strong><?php echo $this->lang->line('unit_price'); ?>:</strong> <span id="summary_price"></span><br>
                        <strong><?php echo $this->lang->line('total'); ?>:</strong> <span id="summary_total"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Hidden Fields -->
    <input type="hidden" name="patient_id" value="<?php echo $patient->id; ?>">
    <input type="hidden" name="medicine_id" value="<?php echo $medicine->id; ?>">
    <input type="hidden" name="medicine_category_id" value="<?php echo $medicine->medicine_category_id; ?>">
    <input type="hidden" name="batch_no" id="batch_no_hidden">
    <input type="hidden" name="bill_no" value="<?php echo $bill_no; ?>">

    <!-- Action Buttons -->
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">
            <?php echo $this->lang->line('cancel'); ?>
        </button>
        <button type="submit" class="btn btn-success" id="dispenseBtn">
            <i class="fa fa-check"></i> <?php echo $this->lang->line('dispense_medicine'); ?>
        </button>
    </div>
</form>

<script>
function updateBatchDetails() {
    var selectedBatch = $('#batch_id option:selected');
    if (selectedBatch.val()) {
        $('#expiry_date').val(selectedBatch.data('expiry'));
        $('#available_qty').val(selectedBatch.data('available'));
        $('#mrp').val(selectedBatch.data('mrp'));
        $('#sale_price').val(selectedBatch.data('sale-price'));
        $('#batch_no_hidden').val(selectedBatch.data('batch-no'));
        
        // Set max quantity
        $('#quantity').attr('max', selectedBatch.data('available'));
        
        calculateAmount();
        updateSummary();
    } else {
        clearBatchDetails();
    }
}

function clearBatchDetails() {
    $('#expiry_date, #available_qty, #mrp, #sale_price, #total_amount').val('');
    $('#quantity').attr('max', '');
    $('#summary_section').hide();
}

function calculateAmount() {
    var quantity = parseFloat($('#quantity').val()) || 0;
    var salePrice = parseFloat($('#sale_price').val()) || 0;
    var total = quantity * salePrice;
    
    $('#total_amount').val(total.toFixed(2));
    updateSummary();
}

function updateSummary() {
    var quantity = $('#quantity').val();
    var salePrice = $('#sale_price').val();
    var batchNo = $('#batch_id option:selected').data('batch-no');
    var total = $('#total_amount').val();
    
    if (quantity && salePrice && batchNo) {
        $('#summary_batch').text(batchNo);
        $('#summary_quantity').text(quantity + ' <?php echo $medicine->unit_name; ?>');
        $('#summary_price').text('<?php echo $currency_symbol; ?>' + salePrice);
        $('#summary_total').text('<?php echo $currency_symbol; ?>' + total);
        $('#summary_section').show();
    } else {
        $('#summary_section').hide();
    }
}

// Form submission
$('#quickDispenseForm').on('submit', function(e) {
    e.preventDefault();
    
    var availableQty = parseInt($('#available_qty').val());
    var requestedQty = parseInt($('#quantity').val());
    
    if (requestedQty > availableQty) {
        alert('<?php echo $this->lang->line('insufficient_stock'); ?>');
        return;
    }
    
    if (!confirm('<?php echo $this->lang->line('confirm_dispense_medicine'); ?>')) {
        return;
    }
    
    $('#dispenseBtn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> <?php echo $this->lang->line('processing'); ?>');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/processQuickDispensing',
        type: 'POST',
        data: $(this).serialize(),
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                alert(response.message);
                $('#quickBillModal').modal('hide');
                
                // Refresh the medicine stock table
                if (typeof table !== 'undefined') {
                    table.ajax.reload();
                }
                
                // Ask if user wants to print the bill
                if (confirm('<?php echo $this->lang->line('print_bill_question'); ?>')) {
                    window.open('<?php echo base_url(); ?>admin/pharmacy/printBill/' + response.bill_id, '_blank');
                }
            } else {
                var errorMsg = '';
                if (response.error && typeof response.error === 'object') {
                    $.each(response.error, function(index, value) {
                        errorMsg += value + '\n';
                    });
                } else {
                    errorMsg = response.message || '<?php echo $this->lang->line('something_went_wrong'); ?>';
                }
                alert(errorMsg);
            }
        },
        error: function() {
            alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
        },
        complete: function() {
            $('#dispenseBtn').prop('disabled', false).html('<i class="fa fa-check"></i> <?php echo $this->lang->line('dispense_medicine'); ?>');
        }
    });
});

// Initialize
$(document).ready(function() {
    // Clear form on modal close
    $('#quickBillModal').on('hidden.bs.modal', function () {
        $('#quickDispenseForm')[0].reset();
        clearBatchDetails();
    });
});
</script>