<?php
// File: admin/pharmacy/_patientPendingBills.php
?>
<div class="row">
    <div class="col-md-12">
        <div class="patient-info-header" style="margin-bottom: 20px; padding: 15px; background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 5px;">
            <h4><i class="fa fa-exclamation-triangle text-warning"></i> <?php echo $patient->patient_name; ?> - <?php echo $this->lang->line('pending_bills'); ?></h4>
            <p class="text-muted">
                <strong><?php echo $this->lang->line('patient_id'); ?>:</strong> <?php echo $patient->patient_unique_id; ?> | 
                <strong><?php echo $this->lang->line('phone'); ?>:</strong> <?php echo $patient->mobileno ?: 'N/A'; ?>
            </p>
        </div>

        <?php if (!empty($bills)) { ?>
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('bill_no'); ?></th>
                            <th><?php echo $this->lang->line('date'); ?></th>
                            <th><?php echo $this->lang->line('total'); ?> (<?php echo $currency_symbol; ?>)</th>
                            <th><?php echo $this->lang->line('paid'); ?> (<?php echo $currency_symbol; ?>)</th>
                            <th><?php echo $this->lang->line('balance'); ?> (<?php echo $currency_symbol; ?>)</th>
                            <th><?php echo $this->lang->line('days_overdue'); ?></th>
                            <th><?php echo $this->lang->line('action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_balance = 0;
                        foreach ($bills as $bill) { 
                            $total_balance += $bill->balance;
                            $days_overdue = ceil((time() - strtotime($bill->date)) / (60 * 60 * 24));
                        ?>
                            <tr>
                                <td>
                                    <?php echo $this->customlib->getSessionPrefixByType('pharmacy_billing') . $bill->id; ?>
                                </td>
                                <td>
                                    <?php echo $this->customlib->YYYYMMDDHisTodateFormat($bill->date, $this->customlib->getHospitalTimeFormat()); ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $currency_symbol . amountFormat($bill->net_amount); ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $currency_symbol . amountFormat($bill->paid_amount); ?>
                                </td>
                                <td class="text-right">
                                    <span class="text-danger">
                                        <strong><?php echo $currency_symbol . amountFormat($bill->balance); ?></strong>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <?php if ($days_overdue > 30) { ?>
                                        <span class="label label-danger"><?php echo $days_overdue; ?> days</span>
                                    <?php } elseif ($days_overdue > 7) { ?>
                                        <span class="label label-warning"><?php echo $days_overdue; ?> days</span>
                                    <?php } else { ?>
                                        <span class="label label-info"><?php echo $days_overdue; ?> days</span>
                                    <?php } ?>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="#" onclick="viewBillDetails(<?php echo $bill->id; ?>)" 
                                           class="btn btn-default btn-xs" data-toggle="tooltip" 
                                           title="<?php echo $this->lang->line('view'); ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <a href="#" onclick="addPayment(<?php echo $bill->id; ?>)" 
                                           class="btn btn-success btn-xs" data-toggle="tooltip" 
                                           title="<?php echo $this->lang->line('add_payment'); ?>">
                                            <i class="fa fa-money"></i>
                                        </a>
                                        <a href="#" onclick="printBill(<?php echo $bill->id; ?>)" 
                                           class="btn btn-default btn-xs" data-toggle="tooltip" 
                                           title="<?php echo $this->lang->line('print'); ?>">
                                            <i class="fa fa-print"></i>
                                        </a>
                                        <a href="#" onclick="sendReminder(<?php echo $bill->id; ?>)" 
                                           class="btn btn-warning btn-xs" data-toggle="tooltip" 
                                           title="<?php echo $this->lang->line('send_reminder'); ?>">
                                            <i class="fa fa-bell"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr class="info">
                            <th colspan="4" class="text-right"><?php echo $this->lang->line('total_outstanding'); ?>:</th>
                            <th class="text-right">
                                <span class="text-danger">
                                    <strong><?php echo $currency_symbol . amountFormat($total_balance); ?></strong>
                                </span>
                            </th>
                            <th colspan="2"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Payment Options -->
            <div class="row" style="margin-top: 20px;">
                <div class="col-md-12">
                    <div class="alert alert-warning">
                        <h5><i class="fa fa-info-circle"></i> <?php echo $this->lang->line('payment_options'); ?></h5>
                        <div class="btn-group">
                            <button type="button" class="btn btn-success" onclick="payAllBills()">
                                <i class="fa fa-money"></i> <?php echo $this->lang->line('pay_all_bills'); ?>
                                (<?php echo $currency_symbol . amountFormat($total_balance); ?>)
                            </button>
                            <button type="button" class="btn btn-info" onclick="partialPayment()">
                                <i class="fa fa-calculator"></i> <?php echo $this->lang->line('partial_payment'); ?>
                            </button>
                            <button type="button" class="btn btn-warning" onclick="sendAllReminders()">
                                <i class="fa fa-envelope"></i> <?php echo $this->lang->line('send_reminders'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

        <?php } else { ?>
            <div class="alert alert-success text-center">
                <i class="fa fa-check-circle"></i>
                <h4><?php echo $this->lang->line('no_pending_bills'); ?></h4>
                <p><?php echo $this->lang->line('patient_has_no_outstanding_balance'); ?></p>
            </div>
        <?php } ?>
    </div>
</div>

<script>
function addPayment(billId) {
    // Open payment modal - integrate with existing payment functionality
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getPharmacyTransaction',
        type: 'POST',
        data: { id: billId },
        success: function(response) {
            if (response.status) {
                // Display payment form
                // This would integrate with your existing payment modal
                console.log('Payment modal for bill: ' + billId);
            }
        }
    });
}

function payAllBills() {
    var totalAmount = <?php echo $total_balance; ?>;
    if (confirm('<?php echo $this->lang->line('confirm_pay_all_bills'); ?> ' + '<?php echo $currency_symbol; ?>' + totalAmount.toFixed(2))) {
        // Implement bulk payment functionality
        var billIds = [];
        <?php foreach ($bills as $bill) { ?>
            billIds.push(<?php echo $bill->id; ?>);
        <?php } ?>
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/processBulkPayment',
            type: 'POST',
            data: { 
                bill_ids: billIds,
                total_amount: totalAmount,
                patient_id: <?php echo $patient->id; ?>
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert(response.message);
                    // Refresh the modal content
                    viewPendingBills();
                } else {
                    alert(response.message || '<?php echo $this->lang->line('payment_failed'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }
}

function partialPayment() {
    var totalAmount = <?php echo $total_balance; ?>;
    var amount = prompt('<?php echo $this->lang->line('enter_payment_amount'); ?>', totalAmount.toFixed(2));
    
    if (amount && parseFloat(amount) > 0) {
        if (parseFloat(amount) > totalAmount) {
            alert('<?php echo $this->lang->line('amount_cannot_exceed_balance'); ?>');
            return;
        }
        
        // Implement partial payment functionality
        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/processPartialPayment',
            type: 'POST',
            data: { 
                patient_id: <?php echo $patient->id; ?>,
                amount: parseFloat(amount)
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert(response.message);
                    // Refresh the modal content
                    viewPendingBills();
                } else {
                    alert(response.message || '<?php echo $this->lang->line('payment_failed'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }
}

function sendReminder(billId) {
    if (confirm('<?php echo $this->lang->line('confirm_send_reminder'); ?>')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/sendPaymentReminder',
            type: 'POST',
            data: { bill_id: billId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert('<?php echo $this->lang->line('reminder_sent_successfully'); ?>');
                } else {
                    alert(response.message || '<?php echo $this->lang->line('failed_to_send_reminder'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }
}

function sendAllReminders() {
    if (confirm('<?php echo $this->lang->line('confirm_send_all_reminders'); ?>')) {
        var billIds = [];
        <?php foreach ($bills as $bill) { ?>
            billIds.push(<?php echo $bill->id; ?>);
        <?php } ?>
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/sendBulkReminders',
            type: 'POST',
            data: { 
                bill_ids: billIds,
                patient_id: <?php echo $patient->id; ?>
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert(response.message);
                } else {
                    alert(response.message || '<?php echo $this->lang->line('failed_to_send_reminders'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }
}

function viewBillDetails(billId) {
    window.open('<?php echo base_url(); ?>admin/pharmacy/bill/details/' + billId, '_blank');
}

function printBill(billId) {
    window.open('<?php echo base_url(); ?>admin/pharmacy/printBill/' + billId, '_blank');
}
</script>