<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patient Financial View - <?php echo $patient->name; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f9fafb;
            color: #374151;
            line-height: 1.6;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .header-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            padding: 30px;
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .patient-info {
            display: flex;
            align-items: center;
        }
        
        .patient-avatar {
            width: 60px;
            height: 60px;
            background: #dbeafe;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 20px;
        }
        
        .patient-avatar i {
            font-size: 24px;
            color: #2563eb;
        }
        
        .patient-details h1 {
            font-size: 28px;
            font-weight: bold;
            color: #111827;
            margin-bottom: 5px;
        }
        
        .patient-details p {
            color: #6b7280;
            font-size: 16px;
        }
        
        .last-visit {
            text-align: right;
        }
        
        .last-visit p:first-child {
            color: #6b7280;
            font-size: 14px;
        }
        
        .last-visit p:last-child {
            font-size: 18px;
            font-weight: 600;
            color: #111827;
        }
        
        .summary-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .summary-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            padding: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .summary-card-content p:first-child {
            color: #6b7280;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .summary-card-content p:last-child {
            font-size: 24px;
            font-weight: bold;
        }
        
        .summary-card-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .summary-card-icon i {
            font-size: 24px;
        }
        
        .billed-card .summary-card-content p:last-child { color: #111827; }
        .billed-card .summary-card-icon { background: #dbeafe; }
        .billed-card .summary-card-icon i { color: #2563eb; }
        
        .paid-card .summary-card-content p:last-child { color: #059669; }
        .paid-card .summary-card-icon { background: #d1fae5; }
        .paid-card .summary-card-icon i { color: #059669; }
        
        .balance-card .summary-card-content p:last-child { color: #dc2626; }
        .balance-card .summary-card-icon { background: #fee2e2; }
        .balance-card .summary-card-icon i { color: #dc2626; }
        
        .insurance-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            padding: 30px;
            margin-bottom: 30px;
        }
        
        .insurance-header {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .insurance-header i {
            margin-right: 10px;
            color: #2563eb;
        }
        
        .insurance-header h2 {
            font-size: 20px;
            font-weight: 600;
            color: #111827;
        }
        
        .insurance-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        
        .insurance-detail p:first-child {
            color: #6b7280;
            font-size: 14px;
            margin-bottom: 5px;
        }
        
        .insurance-detail p:last-child {
            font-size: 16px;
            font-weight: 500;
            color: #111827;
        }
        
        .tabs-container {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .tabs-nav {
            display: flex;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .tab-button {
            padding: 15px 30px;
            background: none;
            border: none;
            font-size: 16px;
            font-weight: 500;
            color: #6b7280;
            cursor: pointer;
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
        }
        
        .tab-button.active {
            color: #2563eb;
            border-bottom-color: #2563eb;
        }
        
        .tab-button:hover {
            color: #374151;
        }
        
        .tab-content {
            padding: 30px;
        }
        
        .tab-pane {
            display: none;
        }
        
        .tab-pane.active {
            display: block;
        }
        
        .overview-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 30px;
        }
        
        .overview-section h3 {
            font-size: 18px;
            font-weight: 600;
            color: #111827;
            margin-bottom: 20px;
        }
        
        .overview-item {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .overview-item:last-child {
            border-bottom: none;
            padding-top: 12px;
            border-top: 1px solid #e5e7eb;
            font-weight: 600;
        }
        
        .overview-item span:first-child {
            color: #6b7280;
        }
        
        .overview-item span:last-child {
            color: #111827;
        }
        
        .table-container {
            overflow-x: auto;
        }
        
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        .data-table th {
            background: #f9fafb;
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #374151;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .data-table td {
            padding: 15px;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .data-table tr:hover {
            background: #f9fafb;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .status-badge i {
            margin-right: 5px;
            font-size: 10px;
        }
        
        .status-paid {
            background: #d1fae5;
            color: #059669;
        }
        
        .status-pending {
            background: #fef3c7;
            color: #d97706;
        }
        
        .status-overdue {
            background: #fee2e2;
            color: #dc2626;
        }
        
        .status-completed {
            background: #d1fae5;
            color: #059669;
        }
        
        @media (max-width: 768px) {
            .header-card {
                flex-direction: column;
                text-align: center;
            }
            
            .patient-info {
                margin-bottom: 20px;
            }
            
            .summary-cards {
                grid-template-columns: 1fr;
            }
            
            .insurance-details {
                grid-template-columns: 1fr;
            }
            
            .tabs-nav {
                flex-direction: column;
            }
            
            .overview-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header-card">
            <div class="patient-info">
                <div class="patient-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="patient-details">
                    <h1><?php echo htmlspecialchars($patient->name); ?></h1>
                    <p>Patient ID: <?php echo htmlspecialchars($patient->patient_number); ?></p>
                </div>
            </div>
            <div class="last-visit">
                <p>Last Visit</p>
                <p><?php echo date('Y-m-d', strtotime($patient->last_visit)); ?></p>
            </div>
        </div>

        <!-- Financial Summary Cards -->
        <div class="summary-cards">
            <div class="summary-card billed-card">
                <div class="summary-card-content">
                    <p>Total Billed</p>
                    <p>KSh <?php echo number_format($financial_summary->total_billed, 2); ?></p>
                </div>
                <div class="summary-card-icon">
                    <i class="fas fa-file-invoice"></i>
                </div>
            </div>

            <div class="summary-card paid-card">
                <div class="summary-card-content">
                    <p>Total Paid</p>
                    <p>KSh <?php echo number_format($financial_summary->total_paid, 2); ?></p>
                </div>
                <div class="summary-card-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>

            <div class="summary-card balance-card">
                <div class="summary-card-content">
                    <p>Outstanding Balance</p>
                    <p>KSh <?php echo number_format($financial_summary->balance, 2); ?></p>
                </div>
                <div class="summary-card-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
            </div>
        </div>

        <!-- Insurance Information -->
        <?php if (isset($patient->insurance)): ?>
        <div class="insurance-card">
            <div class="insurance-header">
                <i class="fas fa-credit-card"></i>
                <h2>Insurance Information</h2>
            </div>
            <div class="insurance-details">
                <div class="insurance-detail">
                    <p>Insurance Provider</p>
                    <p><?php echo htmlspecialchars($patient->insurance->provider_name); ?></p>
                </div>
                <div class="insurance-detail">
                    <p>Insurance Number</p>
                    <p><?php echo htmlspecialchars($patient->insurance->insurance_number); ?></p>
                </div>
                <div class="insurance-detail">
                    <p>Coverage Type</p>
                    <p><?php echo htmlspecialchars($patient->insurance->coverage_type); ?></p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Tabs -->
        <div class="tabs-container">
            <div class="tabs-nav">
                <button class="tab-button active" onclick="showTab(event, 'overview')">Overview</button>
                <button class="tab-button" onclick="showTab(event, 'billing')">Billing History</button>
                <button class="tab-button" onclick="showTab(event, 'payments')">Payment History</button>
            </div>

            <div class="tab-content">
                <!-- Overview Tab -->
                <div id="overview" class="tab-pane active">
                    <div class="overview-grid">
                        <div class="overview-section">
                            <h3>Patient Information</h3>
                            <div class="overview-item">
                                <span>Registration Date:</span>
                                <span><?php echo date('Y-m-d', strtotime($patient->registration_date)); ?></span>
                            </div>
                            <div class="overview-item">
                                <span>Last Visit:</span>
                                <span><?php echo date('Y-m-d', strtotime($patient->last_visit)); ?></span>
                            </div>
                            <div class="overview-item">
                                <span>Total Visits:</span>
                                <span><?php echo $patient->total_visits ?? 0; ?></span>
                            </div>
                        </div>
                        
                        <div class="overview-section">
                            <h3>Financial Summary</h3>
                            <div class="overview-item">
                                <span>Total Billed:</span>
                                <span>KSh <?php echo number_format($financial_summary->total_billed, 2); ?></span>
                            </div>
                            <div class="overview-item">
                                <span>Total Paid:</span>
                                <span style="color: #059669;">KSh <?php echo number_format($financial_summary->total_paid, 2); ?></span>
                            </div>
                            <div class="overview-item">
                                <span>Outstanding Balance:</span>
                                <span style="color: #dc2626;">KSh <?php echo number_format($financial_summary->balance, 2); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Billing History Tab -->
                <div id="billing" class="tab-pane">
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Service</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Payment Method</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($billing_history as $bill): ?>
                                <tr>
                                    <td><?php echo date('Y-m-d', strtotime($bill->date)); ?></td>
                                    <td><?php echo htmlspecialchars($bill->service_name); ?></td>
                                    <td>KSh <?php echo number_format($bill->amount, 2); ?></td>
                                    <td>
                                        <span class="status-badge status-<?php echo strtolower($bill->status); ?>">
                                            <?php
                                            $icon = '';
                                            switch(strtolower($bill->status)) {
                                                case 'paid':
                                                    $icon = 'fas fa-check-circle';
                                                    break;
                                                case 'pending':
                                                    $icon = 'fas fa-clock';
                                                    break;
                                                case 'overdue':
                                                    $icon = 'fas fa-exclamation-circle';
                                                    break;
                                                default:
                                                    $icon = 'fas fa-clock';
                                            }
                                            ?>
                                            <i class="<?php echo $icon; ?>"></i>
                                            <?php echo ucfirst($bill->status); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($bill->payment_method); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Payment History Tab -->
                <div id="payments" class="tab-pane">
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Payment Method</th>
                                    <th>Reference</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($payment_history as $payment): ?>
                                <tr>
                                    <td><?php echo date('Y-m-d', strtotime($payment->payment_date)); ?></td>
                                    <td>KSh <?php echo number_format($payment->amount, 2); ?></td>
                                    <td><?php echo htmlspecialchars($payment->payment_method); ?></td>
                                    <td><?php echo htmlspecialchars($payment->reference_number); ?></td>
                                    <td>
                                        <span class="status-badge status-<?php echo strtolower($payment->status); ?>">
                                            <?php
                                            $icon = '';
                                            switch(strtolower($payment->status)) {
                                                case 'completed':
                                                    $icon = 'fas fa-check-circle';
                                                    break;
                                                case 'pending':
                                                    $icon = 'fas fa-clock';
                                                    break;
                                                case 'failed':
                                                    $icon = 'fas fa-times-circle';
                                                    break;
                                                default:
                                                    $icon = 'fas fa-clock';
                                            }
                                            ?>
                                            <i class="<?php echo $icon; ?>"></i>
                                            <?php echo ucfirst($payment->status); ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showTab(event, tabName) {
            // Hide all tab panes
            var tabPanes = document.querySelectorAll('.tab-pane');
            tabPanes.forEach(function(pane) {
                pane.classList.remove('active');
            });

            // Remove active class from all tab buttons
            var tabButtons = document.querySelectorAll('.tab-button');
            tabButtons.forEach(function(button) {
                button.classList.remove('active');
            });

            // Show the selected tab pane
            document.getElementById(tabName).classList.add('active');
            
            // Add active class to clicked button
            event.target.classList.add('active');
        }
    </script>
</body>
</html>