<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Enhanced Specialized Patient Registration</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper {
            background-color: #ecf0f5;
        }
        
        .specialized-header {
            background: linear-gradient(135deg, #dd4b39 0%, #f56954 100%);
            color: white;
            padding: 20px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .priority-notice {
            background: #fcf8e3;
            border: 1px solid #faebcc;
            color: #8a6d3b;
            padding: 15px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .workflow-step {
            padding: 10px 15px;
            border-bottom: 1px solid #f4f4f4;
            display: flex;
            align-items: center;
        }
        
        .workflow-step:last-child {
            border-bottom: none;
        }
        
        .step-number {
            background: #dd4b39;
            color: white;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 10px;
            font-weight: bold;
            font-size: 12px;
        }
        
        .step-content h6 {
            margin: 0 0 3px 0;
            color: #333;
            font-weight: 600;
        }
        
        .step-content small {
            color: #777;
        }
        
        .mandatory-step {
            background: #fff5f5;
            border-left: 4px solid #dd4b39;
        }
        
        .optional-step {
            background: #f8f9fa;
            border-left: 4px solid #6c757d;
        }
        
        .specialist-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
            gap: 10px;
            margin: 15px 0;
        }
        
        .specialist-option {
            background: white;
            border: 2px solid #ddd;
            border-radius: 5px;
            padding: 12px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            min-height: 85px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .specialist-option:hover {
            border-color: #dd4b39;
            background-color: #fff5f5;
        }
        
        .specialist-option.selected {
            border-color: #dd4b39;
            background-color: #dd4b39;
            color: white;
        }
        
        .specialist-option i {
            font-size: 20px;
            margin-bottom: 5px;
            display: block;
        }
        
        .specialist-option strong {
            font-size: 11px;
            margin-bottom: 2px;
        }
        
        .specialist-option small {
            font-size: 9px;
        }
        
        .service-checkbox {
            background: white;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 12px;
            margin: 8px 0;
            transition: all 0.3s ease;
        }
        
        .service-checkbox:hover {
            border-color: #dd4b39;
            background-color: #fff5f5;
        }
        
        .service-checkbox input[type="checkbox"]:checked + label {
            font-weight: bold;
            color: #dd4b39;
        }
        
        .service-checkbox input[type="checkbox"]:disabled + label {
            color: #6c757d;
            font-style: italic;
        }
        
        .required {
            color: #dd4b39;
        }
        
        .btn-specialized {
            background-color: #dd4b39;
            border-color: #dd4b39;
            color: white;
        }
        
        .btn-specialized:hover {
            background-color: #c23321;
            border-color: #c23321;
            color: white;
        }
        
        .cost-display {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 8px 15px;
            border-radius: 15px;
            font-weight: bold;
            text-align: center;
        }
        
        .chief-complaint-section {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .priority-levels {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .priority-option {
            padding: 8px 12px;
            margin: 5px 0;
            border-radius: 3px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .priority-routine { border-left: 4px solid #28a745; }
        .priority-urgent { border-left: 4px solid #ffc107; }
        .priority-emergency { border-left: 4px solid #dc3545; }
        
        .priority-option:hover {
            background-color: #f8f9fa;
        }
        
        .priority-option.selected {
            background-color: #e9ecef;
            font-weight: bold;
        }

        .insurance-section {
            background: #e8f5e8;
            border: 1px solid #c3e6c3;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }

        .copay-section {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 3px;
            padding: 10px;
            margin: 10px 0;
            display: none;
        }

        .dob-section {
            background: #f0f8ff;
            border: 1px solid #b0d4f0;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }

        .age-display {
            font-size: 14px;
            font-weight: bold;
            color: #2c5aa0;
            margin-top: 10px;
            padding: 8px;
            background: rgba(44, 90, 160, 0.1);
            border-radius: 3px;
        }

        .routing-section {
            background: #f5f5f5;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 15px;
            margin: 15px 0;
        }

        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
        }

        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .toggle-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 24px;
        }

        .toggle-slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked + .toggle-slider {
            background-color: #dd4b39;
        }

        input:checked + .toggle-slider:before {
            transform: translateX(26px);
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Enhanced Specialized Patient Registration
                <small>Priority Care with Insurance Support & Advanced Queuing</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="#">Patient</a></li>
                <li class="active">Enhanced Specialized Registration</li>
            </ol>
        </section>

        <section class="content">
            <!-- Specialized Header -->
            <div class="specialized-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-user-md"></i> Enhanced Specialized Patient Registration</h3>
                        <p class="margin-bottom-none">Priority care with insurance support, auto-age calculation & advanced department queuing</p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="cost-display">
                            <i class="fa fa-money"></i> Registration Fee: <span id="registration_fee">KES 1,500</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Priority Notice -->
            <div class="priority-notice">
                <h4><i class="fa fa-exclamation-triangle"></i> Enhanced Priority Care Pathway</h4>
                <p class="margin-bottom-none">Features insurance support with copay calculation, automatic age calculation from DOB, and direct routing to specialists. Triage and consultation are mandatory with automatic department queuing.</p>
            </div>

            <!-- Workflow Process -->
            <div class="box box-danger">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-route"></i> Enhanced Specialized Workflow Process</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="workflow-step mandatory-step">
                                <div class="step-number">1</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-plus"></i> Registration <span class="label label-danger">MANDATORY</span></h6>
                                    <small>Patient details with insurance verification & DOB calculation</small>
                                </div>
                            </div>
                            <div class="workflow-step mandatory-step">
                                <div class="step-number">2</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-stethoscope"></i> Priority Triage <span class="label label-danger">MANDATORY</span></h6>
                                    <small>Immediate health assessment with auto-queuing</small>
                                </div>
                            </div>
                            <div class="workflow-step mandatory-step">
                                <div class="step-number">3</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-md"></i> Specialist Direct Routing <span class="label label-danger">MANDATORY</span></h6>
                                    <small>Direct routing to selected specialist doctor</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="workflow-step optional-step">
                                <div class="step-number">4</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-flask"></i> Laboratory Tests <span class="label label-default">OPTIONAL</span></h6>
                                    <small>As prescribed by specialist with queue management</small>
                                </div>
                            </div>
                            <div class="workflow-step optional-step">
                                <div class="step-number">5</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-pills"></i> Pharmacy Services <span class="label label-default">OPTIONAL</span></h6>
                                    <small>Medication dispensing with auto-queuing</small>
                                </div>
                            </div>
                            <div class="workflow-step optional-step">
                                <div class="step-number">6</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-camera"></i> Radiology/Imaging <span class="label label-default">OPTIONAL</span></h6>
                                    <small>Medical imaging with department routing</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Registration Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-edit"></i> Enhanced Patient Information</h3>
                </div>
                
                <form id="enhancedSpecializedForm" action="<?php echo base_url(); ?>admin/patient/add" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="workflow_type" value="specialized">
                    <input type="hidden" name="auto_queue" value="true">
                    
                    <div class="box-body">
                        <!-- Basic Information -->
                        <h4><i class="fa fa-user"></i> Basic Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient Name <span class="required">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
                                </div>
                                
                                <!-- Enhanced DOB Section with Auto Age Calculation -->
                                <div class="dob-section">
                                    <label>Date of Birth <span class="required">*</span></label>
                                    <input type="date" name="date_of_birth" id="date_of_birth" class="form-control" required>
                                    <div id="age_display" class="age-display" style="display: none;">
                                        <i class="fa fa-birthday-cake"></i> <span id="calculated_age">Age will be calculated automatically</span>
                                    </div>
                                    <!-- Hidden fields for age submission -->
                                    <input type="hidden" name="age[year]" id="age_year">
                                    <input type="hidden" name="age[month]" id="age_month">
                                    <input type="hidden" name="age[day]" id="age_day">
                                </div>
                                
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select name="gender" class="form-control">
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label>Mobile Number</label>
                                    <input type="tel" name="mobileno" class="form-control" placeholder="+254 700 000 000">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email Address</label>
                                    <input type="email" name="email" class="form-control" placeholder="patient@example.com">
                                </div>
                                
                                <div class="form-group">
                                    <label>National ID Number</label>
                                    <input type="text" name="national_id" class="form-control" placeholder="ID Number">
                                </div>
                                
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea name="address" class="form-control" rows="2" placeholder="Patient residential address"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Patient Photo</label>
                                    <input type="file" name="file" class="form-control" accept="image/*">
                                    <small class="text-muted">Optional: Upload patient photo</small>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Enhanced Insurance Section -->
                        <div class="insurance-section">
                            <h4><i class="fa fa-shield"></i> Insurance Information</h4>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Has Insurance?</label>
                                        <div>
                                            <label class="toggle-switch">
                                                <input type="checkbox" id="has_insurance" name="has_insurance" value="1">
                                                <span class="toggle-slider"></span>
                                            </label>
                                            <span style="margin-left: 10px;">Enable Insurance</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-9" id="insurance_details" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Insurance Company <span class="required">*</span></label>
                                                <select name="insurance_company" id="insurance_company" class="form-control">
                                                    <option value="">Select Insurance Company</option>
                                                    <option value="AAR Insurance">AAR Insurance</option>
                                                    <option value="Madison Insurance">Madison Insurance</option>
                                                    <option value="Britam Insurance">Britam Insurance</option>
                                                    <option value="NHIF">NHIF (National Hospital Insurance Fund)</option>
                                                    <option value="Jubilee Insurance">Jubilee Insurance</option>
                                                    <option value="CIC Insurance">CIC Insurance</option>
                                                    <option value="UAP Insurance">UAP Insurance</option>
                                                    <option value="Heritage Insurance">Heritage Insurance</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Member Number <span class="required">*</span></label>
                                                <input type="text" name="insurance_member_number" id="insurance_member_number" class="form-control" placeholder="Enter member number">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Insurance Scheme</label>
                                                <select name="insurance_scheme" id="insurance_scheme" class="form-control">
                                                    <option value="">Select Scheme</option>
                                                    <option value="individual">Individual Plan</option>
                                                    <option value="family">Family Plan</option>
                                                    <option value="corporate">Corporate Plan</option>
                                                    <option value="student">Student Plan</option>
                                                    <option value="senior">Senior Citizen Plan</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Copay Section -->
                                    <div class="copay-section" id="copay_section">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Copay Percentage (%) <small class="text-muted">0 = Full coverage</small></label>
                                                    <input type="number" name="copay_percentage" id="copay_percentage" class="form-control" min="0" max="100" step="0.1" placeholder="0 for full coverage, 100 for no coverage">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Calculated Copay Amount</label>
                                                    <div class="input-group">
                                                        <span class="input-group-addon">KES</span>
                                                        <input type="text" id="copay_amount" class="form-control" readonly placeholder="0.00">
                                                        <input type="hidden" name="copay_amount" id="copay_amount_hidden">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Chief Complaint Section -->
                        <div class="chief-complaint-section">
                            <h4><i class="fa fa-notes-medical"></i> Chief Complaint & Symptoms</h4>
                            <p class="text-muted">Detailed description of symptoms (optional but recommended for better specialist routing and triage)</p>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Chief Complaint / Presenting Symptoms</label>
                                        <textarea name="chief_complaint" class="form-control" rows="4" 
                                                placeholder="Describe the primary reason for visit, main symptoms, duration, severity, and any relevant details..."></textarea>
                                        <small class="text-muted">Optional: Providing symptom details helps with better specialist routing and triage assessment.</small>
                                        <div id="complaint_counter" class="text-right text-muted" style="margin-top: 5px;">
                                            <small>0 characters</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Symptom Duration</label>
                                        <select name="symptom_duration" class="form-control">
                                            <option value="">Select Duration</option>
                                            <option value="acute">Acute (Less than 3 days)</option>
                                            <option value="subacute">Subacute (3 days - 3 weeks)</option>
                                            <option value="chronic">Chronic (More than 3 weeks)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Severity Level</label>
                                        <select name="severity_level" class="form-control">
                                            <option value="">Select Severity</option>
                                            <option value="mild">Mild - Minimal impact on daily activities</option>
                                            <option value="moderate">Moderate - Some limitation of activities</option>
                                            <option value="severe">Severe - Significant impact on function</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Priority Level Selection -->
                        <div class="priority-levels">
                            <h4><i class="fa fa-exclamation-triangle"></i> Priority Level</h4>
                            <p class="text-muted">Select the appropriate priority level based on patient condition</p>
                            
                            <div class="priority-option priority-routine" data-value="routine">
                                <strong><i class="fa fa-circle text-success"></i> Routine - Standard Appointment</strong>
                                <br><small>Non-urgent conditions, scheduled appointment within 1-2 weeks</small>
                            </div>
                            
                            <div class="priority-option priority-urgent" data-value="urgent">
                                <strong><i class="fa fa-circle text-warning"></i> Urgent - Same Day Required</strong>
                                <br><small>Conditions requiring attention within 24 hours</small>
                            </div>
                            
                            <div class="priority-option priority-emergency" data-value="emergency">
                                <strong><i class="fa fa-circle text-danger"></i> Emergency - Immediate Attention</strong>
                                <br><small>Life-threatening or severely debilitating conditions</small>
                            </div>
                            
                            <input type="hidden" name="priority_level" id="selected_priority" value="routine">
                        </div>

                        <hr>

                        <!-- Enhanced Specialist Selection -->
                        <h4><i class="fa fa-user-md"></i> Enhanced Specialist Department Selection</h4>
                        <p class="text-muted">Choose the most appropriate specialist department - patient will be routed directly to selected specialist</p>
                        
                        <div class="specialist-grid">
                            <div class="specialist-option" data-value="cardiology">
                                <i class="fa fa-heartbeat"></i>
                                <strong>Cardiology</strong>
                                <small>Heart & Cardiovascular</small>
                            </div>
                            <div class="specialist-option" data-value="neurology">
                                <i class="fa fa-brain"></i>
                                <strong>Neurology</strong>
                                <small>Brain & Nervous System</small>
                            </div>
                            <div class="specialist-option" data-value="orthopedics">
                                <i class="fa fa-bone"></i>
                                <strong>Orthopedics</strong>
                                <small>Bones & Joints</small>
                            </div>
                            <div class="specialist-option" data-value="dermatology">
                                <i class="fa fa-hand-paper"></i>
                                <strong>Dermatology</strong>
                                <small>Skin & Hair</small>
                            </div>
                            <div class="specialist-option" data-value="pediatrics">
                                <i class="fa fa-child"></i>
                                <strong>Pediatrics</strong>
                                <small>Children's Health</small>
                            </div>
                            <div class="specialist-option" data-value="gynecology">
                                <i class="fa fa-female"></i>
                                <strong>Gynecology</strong>
                                <small>Women's Health</small>
                            </div>
                            <div class="specialist-option" data-value="psychiatry">
                                <i class="fa fa-head-side-virus"></i>
                                <strong>Psychiatry</strong>
                                <small>Mental Health</small>
                            </div>
                            <div class="specialist-option" data-value="psychology">
                                <i class="fa fa-user-circle"></i>
                                <strong>Psychology</strong>
                                <small>Behavioral Health</small>
                            </div>
                            <div class="specialist-option" data-value="ent">
                                <i class="fa fa-ear-listen"></i>
                                <strong>ENT</strong>
                                <small>Ear, Nose & Throat</small>
                            </div>
                            <div class="specialist-option" data-value="optometrics">
                                <i class="fa fa-eye"></i>
                                <strong>Optometrics</strong>
                                <small>Eye Care & Vision</small>
                            </div>
                            <div class="specialist-option" data-value="urology">
                                <i class="fa fa-kidneys"></i>
                                <strong>Urology</strong>
                                <small>Urinary System</small>
                            </div>
                            <div class="specialist-option" data-value="physiotherapy">
                                <i class="fa fa-dumbbell"></i>
                                <strong>Physiotherapy</strong>
                                <small>Physical Rehabilitation</small>
                            </div>
                            <div class="specialist-option" data-value="physician">
                                <i class="fa fa-user-md"></i>
                                <strong>Physician</strong>
                                <small>Internal Medicine</small>
                            </div>
                            <div class="specialist-option" data-value="dental">
                                <i class="fa fa-tooth"></i>
                                <strong>Dental</strong>
                                <small>Oral & Dental Care</small>
                            </div>
                            <div class="specialist-option" data-value="general_surgeon">
                                <i class="fa fa-cut"></i>
                                <strong>General Surgeon</strong>
                                <small>Surgical Procedures</small>
                            </div>
                            <div class="specialist-option" data-value="nutritionist">
                                <i class="fa fa-apple-alt"></i>
                                <strong>Nutritionist</strong>
                                <small>Diet & Nutrition</small>
                            </div>
                            <div class="specialist-option" data-value="speech_therapist">
                                <i class="fa fa-comment"></i>
                                <strong>Speech Therapist</strong>
                                <small>Speech & Language</small>
                            </div>
                        </div>
                        <input type="hidden" name="preferred_specialist" id="selected_specialist">

                        <hr>

                        <!-- Enhanced Routing Section -->
                        <div class="routing-section">
                            <h4><i class="fa fa-route"></i> Direct Specialist Routing</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Route Directly to Specialist?</label>
                                        <div>
                                            <label class="toggle-switch">
                                                <input type="checkbox" id="direct_routing" name="direct_routing" value="1" checked>
                                                <span class="toggle-slider"></span>
                                            </label>
                                            <span style="margin-left: 10px;">Enable Direct Routing</span>
                                        </div>
                                        <small class="text-muted">When enabled, patient will be routed directly to the selected specialist after triage</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Preferred Doctor (Optional)</label>
                                        <select name="preferred_doctor" id="preferred_doctor" class="form-control">
                                            <option value="">Any Available Doctor</option>
                                            <!-- Will be populated based on selected specialist -->
                                        </select>
                                        <small class="text-muted">Select specific doctor or leave blank for any available</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Mandatory and Optional Services -->
                        <h4><i class="fa fa-list-check"></i> Required & Optional Services</h4>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Mandatory Services</h5>
                                <div class="service-checkbox">
                                    <input type="checkbox" name="mandatory_services[]" value="triage" id="spec_triage" checked disabled>
                                    <label for="spec_triage">
                                        <strong><i class="fa fa-stethoscope"></i> Mandatory Triage</strong>
                                        <br><small class="text-muted">Priority assessment and vital signs monitoring</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="mandatory_services[]" value="consultation" id="spec_consultation" checked disabled>
                                    <label for="spec_consultation">
                                        <strong><i class="fa fa-user-md"></i> Required Specialist Consultation</strong>
                                        <br><small class="text-muted">Specialist doctor examination and diagnosis</small>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5>Optional Services</h5>
                                <div class="service-checkbox">
                                    <input type="checkbox" name="optional_services[]" value="laboratory" id="spec_lab">
                                    <label for="spec_lab">
                                        <strong><i class="fa fa-flask"></i> Laboratory Tests</strong>
                                        <br><small class="text-muted">Blood work, cultures, pathology</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="optional_services[]" value="pharmacy" id="spec_pharmacy">
                                    <label for="spec_pharmacy">
                                        <strong><i class="fa fa-pills"></i> Pharmacy Services</strong>
                                        <br><small class="text-muted">Medication dispensing and counseling</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="optional_services[]" value="radiology" id="spec_radiology">
                                    <label for="spec_radiology">
                                        <strong><i class="fa fa-camera"></i> Radiology/Imaging</strong>
                                        <br><small class="text-muted">X-rays, MRI, CT scans, ultrasound</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Additional Medical Information -->
                        <h4><i class="fa fa-info-circle"></i> Additional Medical Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Previous Medical History</label>
                                    <textarea name="medical_history" class="form-control" rows="3" placeholder="Relevant previous conditions, surgeries, hospitalizations"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Known Allergies</label>
                                    <textarea name="allergies" class="form-control" rows="2" placeholder="Drug allergies, food allergies, environmental allergies"></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Current Medications</label>
                                    <textarea name="current_medications" class="form-control" rows="3" placeholder="List current medications and dosages"></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label>Emergency Contact</label>
                                    <input type="text" name="emergency_contact" class="form-control" placeholder="Name and phone number">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Patient List
                                </a>
                            </div>
                            <div class="col-md-6 text-right">
                                <button type="submit" class="btn btn-specialized btn-lg">
                                    <i class="fa fa-save"></i> Register & Queue Patient
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Navigation Links -->
            <div class="box box-default">
                <div class="box-header">
                    <h3 class="box-title">Other Registration Types</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/gcc_registration" class="btn btn-success btn-block btn-lg">
                                <i class="fa fa-globe"></i> GCC Process<br>
                                <small>KES 10,500</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/general_registration" class="btn btn-info btn-block btn-lg">
                                <i class="fa fa-users"></i> General Process<br>
                                <small>KES 900</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default btn-block btn-lg">
                                <i class="fa fa-list"></i> Patient Dashboard<br>
                                <small>View All Patients</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>

<script>
$(document).ready(function() {
    // =============================================
    // ENHANCED DATE OF BIRTH & AGE CALCULATION
    // =============================================
    
    $('#date_of_birth').on('change', function() {
        const dob = new Date($(this).val());
        const today = new Date();
        
        if (dob && dob <= today) {
            const age = calculateAge(dob, today);
            
            // Update hidden fields
            $('#age_year').val(age.years);
            $('#age_month').val(age.months);
            $('#age_day').val(age.days);
            
            // Display calculated age
            const ageText = `${age.years} years, ${age.months} months, ${age.days} days old`;
            $('#calculated_age').text(ageText);
            $('#age_display').show();
            
            // Auto-suggest specialist based on age
            autoSuggestSpecialistByAge(age.years);
            
            console.log('Age calculated:', age);
        } else {
            $('#age_display').hide();
            $('#age_year, #age_month, #age_day').val('');
        }
    });
    
    function calculateAge(birthDate, currentDate) {
        let years = currentDate.getFullYear() - birthDate.getFullYear();
        let months = currentDate.getMonth() - birthDate.getMonth();
        let days = currentDate.getDate() - birthDate.getDate();
        
        if (days < 0) {
            months--;
            const lastMonth = new Date(currentDate.getFullYear(), currentDate.getMonth(), 0);
            days += lastMonth.getDate();
        }
        
        if (months < 0) {
            years--;
            months += 12;
        }
        
        return { years, months, days };
    }
    
    function autoSuggestSpecialistByAge(years) {
        if (years < 18) {
            // Suggest pediatrics for minors
            $('.specialist-option[data-value="pediatrics"]').addClass('suggested').css({
                'border-color': '#28a745',
                'background-color': '#f8fff8'
            });
            console.log('Auto-suggested: Pediatrics (patient is minor)');
        } else if (years >= 65) {
            // Suggest physician for elderly
            $('.specialist-option[data-value="physician"]').addClass('suggested').css({
                'border-color': '#17a2b8',
                'background-color': '#f0f9ff'
            });
            console.log('Auto-suggested: Physician (patient is elderly)');
        }
    }

    // =============================================
    // ENHANCED INSURANCE FUNCTIONALITY
    // =============================================
    
    $('#has_insurance').on('change', function() {
        if ($(this).is(':checked')) {
            $('#insurance_details').show();
            $('#copay_section').show();
            
            // Make insurance fields required
            $('#insurance_company, #insurance_member_number').attr('required', true);
            
            console.log('Insurance enabled');
        } else {
            $('#insurance_details').hide();
            $('#copay_section').hide();
            
            // Remove required attribute
            $('#insurance_company, #insurance_member_number').removeAttr('required');
            
            // Clear insurance fields
            $('#insurance_company, #insurance_member_number, #insurance_scheme').val('');
            $('#copay_percentage, #copay_amount, #copay_amount_hidden').val('');
            
            // Reset registration fee
            updateRegistrationFee(1500);
            
            console.log('Insurance disabled');
        }
    });
    
    // Calculate copay amount
    $('#copay_percentage').on('input', function() {
        const percentage = parseFloat($(this).val()) || 0;
        const registrationFee = 1500; // Base fee
        const copayAmount = (registrationFee * percentage / 100);
        const finalAmount = registrationFee - copayAmount;
        
        $('#copay_amount').val(copayAmount.toFixed(2));
        $('#copay_amount_hidden').val(copayAmount);
        
        updateRegistrationFee(finalAmount);
        
        console.log(`Copay calculation: ${percentage}% of ${registrationFee} = ${copayAmount}`);
    });
    
    function updateRegistrationFee(amount) {
        $('#registration_fee').text('KES ' + amount.toFixed(2));
    }

    // =============================================
    // ENHANCED SPECIALIST SELECTION
    // =============================================
    
    $('.specialist-option').on('click', function() {
        // Remove selection from all options
        $('.specialist-option').removeClass('selected');
        
        // Add selection to clicked option
        $(this).addClass('selected');
        
        // Update hidden input
        const specialistValue = $(this).data('value');
        $('#selected_specialist').val(specialistValue);
        
        // Load available doctors for selected specialist
        loadSpecialistDoctors(specialistValue);
        
        console.log('Selected specialist:', specialistValue);
        
        // Show confirmation
        const specialistName = $(this).find('strong').text();
        showNotification(`Selected: ${specialistName}`, 'success');
    });
    
    function loadSpecialistDoctors(specialistType) {
        // This would typically be an AJAX call to get doctors
        const doctorSelect = $('#preferred_doctor');
        doctorSelect.html('<option value="">Loading doctors...</option>');
        
        // Simulate loading doctors (replace with actual AJAX call)
        setTimeout(() => {
            const mockDoctors = getDoctorsBySpecialist(specialistType);
            let options = '<option value="">Any Available Doctor</option>';
            
            mockDoctors.forEach(doctor => {
                options += `<option value="${doctor.id}">${doctor.name} - ${doctor.specialization}</option>`;
            });
            
            doctorSelect.html(options);
        }, 500);
    }
    
    function getDoctorsBySpecialist(specialistType) {
        // Mock data - replace with actual data from server
        const doctors = {
            'cardiology': [
                { id: 1, name: 'Dr. Sarah Johnson', specialization: 'Cardiologist' },
                { id: 2, name: 'Dr. Michael Chen', specialization: 'Interventional Cardiologist' }
            ],
            'neurology': [
                { id: 3, name: 'Dr. Emily Rodriguez', specialization: 'Neurologist' },
                { id: 4, name: 'Dr. David Kim', specialization: 'Pediatric Neurologist' }
            ],
            'pediatrics': [
                { id: 5, name: 'Dr. Lisa Thompson', specialization: 'Pediatrician' },
                { id: 6, name: 'Dr. James Wilson', specialization: 'Pediatric Specialist' }
            ]
            // Add more specialists as needed
        };
        
        return doctors[specialistType] || [];
    }

    // =============================================
    // PRIORITY LEVEL SELECTION
    // =============================================
    
    $('.priority-option').on('click', function() {
        // Remove selection from all options
        $('.priority-option').removeClass('selected');
        
        // Add selection to clicked option
        $(this).addClass('selected');
        
        // Update hidden input
        const priorityValue = $(this).data('value');
        $('#selected_priority').val(priorityValue);
        
        console.log('Selected priority:', priorityValue);
        
        // Show priority-specific alert
        if (priorityValue === 'emergency') {
            showNotification('Emergency priority selected. Patient will be routed for immediate triage and specialist attention.', 'warning');
        } else if (priorityValue === 'urgent') {
            showNotification('Urgent priority selected. Patient will be scheduled for same-day assessment.', 'info');
        }
    });

    // =============================================
    // CHIEF COMPLAINT VALIDATION & SUGGESTIONS
    // =============================================
    
    $('textarea[name="chief_complaint"]').on('input', function() {
        const length = $(this).val().length;
        
        // Update character counter
        $('#complaint_counter small').text(length + ' characters');
        
        // Color coding for helpful feedback (but not required)
        if (length > 0) {
            $(this).css('border-color', '#00a65a');
            $('#complaint_counter').removeClass('text-danger').addClass('text-success');
            
            // Auto-suggest specialist based on symptoms
            if (length > 20) {
                autoSuggestSpecialistBySymptoms($(this).val());
            }
        } else {
            $(this).css('border-color', '#ddd');
            $('#complaint_counter').removeClass('text-success text-danger').addClass('text-muted');
        }
    });
    
    function autoSuggestSpecialistBySymptoms(symptoms) {
        const symptomText = symptoms.toLowerCase();
        const suggestions = [];
        
        // Enhanced keyword-based suggestions
        if (symptomText.includes('chest pain') || symptomText.includes('heart') || symptomText.includes('palpitation') || symptomText.includes('shortness of breath')) {
            suggestions.push('cardiology');
        }
        if (symptomText.includes('headache') || symptomText.includes('seizure') || symptomText.includes('numbness') || symptomText.includes('dizziness')) {
            suggestions.push('neurology');
        }
        if (symptomText.includes('joint pain') || symptomText.includes('back pain') || symptomText.includes('fracture') || symptomText.includes('muscle')) {
            suggestions.push('orthopedics');
        }
        if (symptomText.includes('skin') || symptomText.includes('rash') || symptomText.includes('itching') || symptomText.includes('acne')) {
            suggestions.push('dermatology');
        }
        if (symptomText.includes('eye') || symptomText.includes('vision') || symptomText.includes('blurred') || symptomText.includes('blind')) {
            suggestions.push('optometrics');
        }
        if (symptomText.includes('ear') || symptomText.includes('throat') || symptomText.includes('nose') || symptomText.includes('hearing')) {
            suggestions.push('ent');
        }
        if (symptomText.includes('dental') || symptomText.includes('tooth') || symptomText.includes('gum') || symptomText.includes('oral')) {
            suggestions.push('dental');
        }
        if (symptomText.includes('urinary') || symptomText.includes('kidney') || symptomText.includes('bladder')) {
            suggestions.push('urology');
        }
        if (symptomText.includes('speech') || symptomText.includes('language') || symptomText.includes('communication')) {
            suggestions.push('speech_therapist');
        }
        if (symptomText.includes('nutrition') || symptomText.includes('diet') || symptomText.includes('weight')) {
            suggestions.push('nutritionist');
        }
        
        if (suggestions.length > 0) {
            console.log('Auto-suggested specialists based on symptoms:', suggestions);
            
            // Clear previous suggestions
            $('.specialist-option').removeClass('auto-suggested').css({
                'border-color': '#ddd',
                'background-color': 'white'
            });
            
            // Highlight suggested specialists
            suggestions.forEach(specialist => {
                $(`.specialist-option[data-value="${specialist}"]`).addClass('auto-suggested').css({
                    'border-color': '#ffc107',
                    'background-color': '#fff9e6'
                });
            });
        }
    }

    // =============================================
    // ENHANCED FORM SUBMISSION WITH QUEUING
    // =============================================
    
    $('#enhancedSpecializedForm').on('submit', function(e) {
        e.preventDefault();
        
        // Validate required fields
        if (!validateEnhancedForm()) {
            return false;
        }
        
        // Show loading state
        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();
        submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Registering & Queuing...').prop('disabled', true);
        
        // Prepare enhanced form data
        const formData = new FormData(this);
        
        // Add additional data for queuing
        formData.append('auto_queue_triage', '1');
        formData.append('auto_queue_specialist', $('#selected_specialist').val());
        formData.append('queue_priority', $('#selected_priority').val());
        formData.append('direct_routing_enabled', $('#direct_routing').is(':checked') ? '1' : '0');
        
        // Debug: Log enhanced form data
        console.log('=== Enhanced Form Submission Debug ===');
        for (let pair of formData.entries()) {
            console.log(pair[0] + ':', pair[1]);
        }
        
        // Submit form with enhanced processing
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                console.log('Enhanced Success Response:', response);
                
                if (response && response.status === 'success') {
                    let message = 'Enhanced Specialized Patient Registered Successfully!\n\n';
                    message += 'Patient ID: ' + response.patient_id + '\n';
                    message += 'Workflow: ' + response.workflow_type + '\n';
                    
                    if (response.insurance_info) {
                        message += 'Insurance: ' + response.insurance_info + '\n';
                    }
                    
                    if (response.copay_amount) {
                        message += 'Copay Applied: KES ' + response.copay_amount + '\n';
                    }
                    
                    if (response.queue_info) {
                        message += '\nQueue Information:\n';
                        message += 'Triage Queue: ' + response.queue_info.triage_number + '\n';
                        if (response.queue_info.specialist_queue) {
                            message += 'Specialist Queue: ' + response.queue_info.specialist_queue + '\n';
                        }
                    }
                    
                    if (response.specialist_dept) {
                        message += 'Specialist Department: ' + response.specialist_dept + '\n';
                    }
                    
                    if (response.preferred_doctor) {
                        message += 'Assigned Doctor: ' + response.preferred_doctor + '\n';
                    }
                    
                    if (response.priority_level) {
                        message += 'Priority Level: ' + response.priority_level;
                    }
                    
                    alert(message);
                    
                    // Reset form
                    resetEnhancedForm();
                    
                    // Optionally redirect to queue management
                    if (response.redirect_to_queue) {
                        window.location.href = response.redirect_to_queue;
                    }
                    
                } else {
                    console.log('Enhanced Error Response:', response);
                    handleFormError(response);
                }
            },
            error: function(xhr, status, error) {
                console.error('Enhanced AJAX Error:', {
                    status: status,
                    error: error,
                    responseText: xhr.responseText,
                    statusCode: xhr.status
                });
                
                handleAjaxError(xhr, status, error);
            },
            complete: function() {
                submitBtn.html(originalText).prop('disabled', false);
            }
        });
    });
    
    function validateEnhancedForm() {
        console.log('=== Enhanced Form Validation ===');
        
        const name = $('input[name="name"]').val().trim();
        const dob = $('#date_of_birth').val();
        const chiefComplaint = $('textarea[name="chief_complaint"]').val().trim();
        const selectedSpecialist = $('#selected_specialist').val();
        const hasInsurance = $('#has_insurance').is(':checked');
        
        // Basic validation
        if (!name) {
            showNotification('Patient name is required', 'error');
            $('input[name="name"]').focus();
            return false;
        }
        
        if (!dob) {
            showNotification('Date of birth is required', 'error');
            $('#date_of_birth').focus();
            return false;
        }
        
        if (!selectedSpecialist) {
            showNotification('Please select a specialist department', 'error');
            $('.specialist-grid').get(0).scrollIntoView();
            return false;
        }
        
        // Insurance validation
        if (hasInsurance) {
            const insuranceCompany = $('#insurance_company').val();
            const memberNumber = $('#insurance_member_number').val();
            
            if (!insuranceCompany || !memberNumber) {
                showNotification('Insurance company and member number are required when insurance is enabled', 'error');
                $('#insurance_company').focus();
                return false;
            }
        }
        
        console.log('✓ Enhanced form validation passed');
        return true;
    }
    
    function resetEnhancedForm() {
        $('#enhancedSpecializedForm')[0].reset();
        $('.specialist-option').removeClass('selected auto-suggested');
        $('.priority-option').removeClass('selected');
        $('.priority-routine').addClass('selected');
        $('#selected_specialist').val('');
        $('#selected_priority').val('routine');
        $('#age_display').hide();
        $('#insurance_details').hide();
        $('#copay_section').hide();
        $('#preferred_doctor').html('<option value="">Any Available Doctor</option>');
        updateRegistrationFee(1500);
    }
    
    function handleFormError(response) {
        let errorMsg = 'Registration Failed:\n\n';
        
        if (response && response.error) {
            if (typeof response.error === 'object') {
                for (let field in response.error) {
                    if (response.error[field]) {
                        errorMsg += field + ': ' + response.error[field] + '\n';
                    }
                }
            } else {
                errorMsg += response.error + '\n';
            }
        } else if (response && response.message) {
            errorMsg += response.message;
        } else {
            errorMsg += 'Unknown error occurred';
        }
        
        alert(errorMsg);
    }
    
    function handleAjaxError(xhr, status, error) {
        let errorMessage = 'Server Error:\n\n';
        
        if (xhr.status === 404) {
            errorMessage += 'Method not found (404)\nCheck if admin/patient/add exists';
        } else if (xhr.status === 500) {
            errorMessage += 'Server error (500)\nCheck PHP error logs';
            if (xhr.responseText) {
                errorMessage += '\n\nServer Response:\n' + xhr.responseText.substring(0, 300);
            }
        } else if (xhr.status === 0) {
            errorMessage += 'Network error or CORS issue';
        } else {
            errorMessage += 'HTTP ' + xhr.status + ': ' + error;
        }
        
        alert(errorMessage);
    }
    
    function showNotification(message, type) {
        // Simple notification system
        const alertClass = type === 'error' ? 'alert-danger' : 
                          type === 'warning' ? 'alert-warning' : 
                          type === 'info' ? 'alert-info' : 'alert-success';
        
        const notification = $(`
            <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                ${message}
            </div>
        `);
        
        $('body').append(notification);
        
        // Auto-dismiss after 5 seconds
        setTimeout(() => {
            notification.fadeOut();
        }, 5000);
    }

    // =============================================
    // SERVICE SELECTION TRACKING
    // =============================================
    
    $('input[name="optional_services[]"]').on('change', function() {
        const selectedServices = [];
        $('input[name="optional_services[]"]:checked').each(function() {
            selectedServices.push($(this).val());
        });
        
        console.log('Selected optional services:', selectedServices);
    });

    // =============================================
    // INITIALIZATION
    // =============================================
    
    // Initialize form with defaults
    $('.priority-routine').addClass('selected');
    $('#selected_priority').val('routine');
    
    // Auto-enable direct routing by default
    $('#direct_routing').prop('checked', true);
    
    console.log('Enhanced specialized patient registration form initialized');
    console.log('Features enabled: DOB auto-calculation, Insurance with copay, Direct specialist routing, Enhanced queuing');
});
</script>

</body>
</html>