<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
$genderList = $this->customlib->getGender();
$genderList_Patient = $this->customlib->getGender_Patient();
$marital_status = $this->config->item('marital_status');

// ENHANCED workflow types with step tracking and restrictions
$workflows = [
    'gcc' => [
        'name' => 'GCC Workflow',
        'description' => 'Registration → Mandatory Triage → Lab → Radiology → Consultation → Complete',
        'mandatory_steps' => ['triage', 'lab', 'radiology', 'consultation'],
        'optional_steps' => [],
        'sequence' => ['registration', 'triage', 'lab', 'radiology', 'consultation'],
        'requires_triage' => true,
        'excludes_icd_diagnosis' => true,
        'base_cost' => 10500.00,
        'step_restrictions' => [
            'lab' => ['triage'],
            'radiology' => ['triage'],
            'consultation' => ['triage', 'lab', 'radiology']
        ]
    ],
    'general' => [
        'name' => 'General Workflow', 
        'description' => 'Registration → (Optional services) → Flexible routing',
        'mandatory_steps' => [],
        'optional_steps' => ['triage', 'lab', 'radiology', 'consultation', 'pharmacy'],
        'sequence' => ['registration'],
        'requires_triage' => false,
        'excludes_icd_diagnosis' => false,
        'base_cost' => 900.00,
        'step_restrictions' => []
    ],
    'specialized' => [
        'name' => 'Specialized Workflow',
        'description' => 'Registration → Mandatory Triage → Mandatory Consultation → (Optional services)',
        'mandatory_steps' => ['triage', 'consultation'],
        'optional_steps' => ['lab', 'radiology', 'pharmacy'],
        'sequence' => ['registration', 'triage', 'consultation'],
        'requires_triage' => true,
        'excludes_icd_diagnosis' => false,
        'base_cost' => 1900.00,
        'step_restrictions' => [
            'consultation' => ['triage'],
            'lab' => ['triage'],
            'radiology' => ['triage']
        ]
    ]
];
?>

<!-- Include Required CSS and JS Libraries -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<link rel="stylesheet" href="<?php echo base_url('assets/css/patient-registration.css'); ?>">

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> <?php echo $this->lang->line('patient_information'); ?>
            <small><?php echo $this->lang->line('patient_registration'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('home'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('patient_information'); ?></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <!-- Patient Registry Box -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> Patient Registry Management
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addpatientModal">
                                <i class="fa fa-plus"></i> New Patient
                            </button>
                            <button type="button" class="btn btn-info btn-sm" onclick="showWorkflowGuide()">
                                <i class="fa fa-question-circle"></i> Workflow Guide
                            </button>
                            <button type="button" class="btn btn-default btn-sm" onclick="exportPatients()">
                                <i class="fa fa-download"></i> Export
                            </button>
                            <!-- Debug tools for development -->
                            <div class="btn-group debug-tools" style="margin-left: 10px; display: none;">
                                <button type="button" class="btn btn-xs btn-warning" onclick="debugPatientTable()" title="Debug Table">
                                    <i class="fa fa-bug"></i>
                                </button>
                                <button type="button" class="btn btn-xs btn-default" onclick="refreshPatientTable()" title="Refresh Table">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <!-- Enhanced Search and Filter Section -->
                        <div class="row filter-section">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-filter"></i> Search & Filter Options
                                            <button type="button" class="btn btn-xs btn-default pull-right" onclick="clearFilters()">
                                                <i class="fa fa-times"></i> Clear
                                            </button>
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-route"></i> Workflow Type</label>
                                                    <select class="form-control" id="workflow_filter">
                                                        <option value="">All Workflows</option>
                                                        <option value="gcc">GCC Workflow</option>
                                                        <option value="specialized">Specialized</option>
                                                        <option value="general">General</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-venus-mars"></i> Gender</label>
                                                    <select class="form-control" id="gender_filter">
                                                        <option value="">All Genders</option>
                                                        <option value="male">Male</option>
                                                        <option value="female">Female</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-calendar"></i> Registration From</label>
                                                    <input type="date" class="form-control" id="date_from">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-calendar"></i> Registration To</label>
                                                    <input type="date" class="form-control" id="date_to">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-user-md"></i> Age Range</label>
                                                    <select class="form-control" id="age_filter">
                                                        <option value="">All Ages</option>
                                                        <option value="0-18">0-18 years</option>
                                                        <option value="19-35">19-35 years</option>
                                                        <option value="36-50">36-50 years</option>
                                                        <option value="51-65">51-65 years</option>
                                                        <option value="65+">65+ years</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-building"></i> Organization</label>
                                                    <select class="form-control" id="organization_filter">
                                                        <option value="">All Organizations</option>
                                                        <!-- Organizations will be populated via AJAX -->
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-toggle-on"></i> Status</label>
                                                    <select class="form-control" id="status_filter">
                                                        <option value="">All Status</option>
                                                        <option value="yes">Active</option>
                                                        <option value="no">Inactive</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><i class="fa fa-fingerprint"></i> Biometric</label>
                                                    <select class="form-control" id="biometric_filter">
                                                        <option value="">All Patients</option>
                                                        <option value="yes">With Fingerprint</option>
                                                        <option value="no">Without Fingerprint</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Statistics Cards -->
                        <div class="row stats-section" style="margin-bottom: 20px;">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-blue"><i class="fa fa-users"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Patients</span>
                                        <span class="info-box-number" id="total_patients">-</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">All registered patients</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-green"><i class="fa fa-globe"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">GCC Patients</span>
                                        <span class="info-box-number" id="gcc_patients">-</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 70%"></div>
                                        </div>
                                        <span class="progress-description">GCC workflow patients</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-yellow"><i class="fa fa-star"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Specialized</span>
                                        <span class="info-box-number" id="specialized_patients">-</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 50%"></div>
                                        </div>
                                        <span class="progress-description">Priority care patients</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-red"><i class="fa fa-calendar-plus-o"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Today's Registrations</span>
                                        <span class="info-box-number" id="today_registrations">-</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 30%"></div>
                                        </div>
                                        <span class="progress-description">New registrations today</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Patient Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover ajaxlist" cellspacing="0" width="100%" data-export-title="<?php echo $this->lang->line('patient_list'); ?>">
                                <thead>
                                    <tr>
                                        <th width="3%" class="text-center">#</th>
                                        <th width="12%" class="text-center">Patient ID</th>
                                        <th width="18%">Patient Name</th>
                                        <th width="15%">Guardian Name</th>
                                        <th width="8%" class="text-center">Gender</th>
                                        <th width="12%" class="text-center">Phone</th>
                                        <th width="10%" class="text-center">Workflow</th>
                                        <th width="8%" class="text-center">Status</th>
                                        <th width="14%" class="text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be loaded via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Enhanced Patient Details Modal -->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="modal_head">
                    <i class="fa fa-user"></i> Patient Details
                </h4>
                <div class="modal-actions" id="edit_delete">
                    <!-- Action buttons will be populated here -->
                </div>
            </div>
            <div class="modal-body">
                <!-- Loading state -->
                <div id="modal-loading" class="text-center" style="padding: 50px;">
                    <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
                    <h4 style="margin-top: 20px; color: #007bff;">Loading patient details...</h4>
                    <p class="text-muted">Please wait while we fetch the information</p>
                </div>

                <!-- Patient content container -->
                <div id="modal-content" style="display: none;">
                    <!-- Patient Basic Information Card -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="patient-photo-card text-center">
                                <div class="patient-photo-container">
                                    <img id="patient_photo" src="" class="patient-photo" alt="Patient Photo">
                                </div>
                                <div class="patient-id-section">
                                    <span class="patient-id-badge" id="patient_id_display"></span>
                                    <div class="patient-verification-status" id="verification_status" style="margin-top: 10px;">
                                        <!-- Verification status will be shown here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="row">
                                <!-- Basic Information Panel -->
                                <div class="col-md-6">
                                    <div class="info-panel">
                                        <h5 class="panel-header">
                                            <i class="fa fa-user text-primary"></i> Basic Information
                                        </h5>
                                        <div class="info-table">
                                            <div class="info-row">
                                                <span class="info-label">Full Name:</span>
                                                <span class="info-value" id="patient_name">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Age:</span>
                                                <span class="info-value" id="patient_age">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Gender:</span>
                                                <span class="info-value" id="patient_gender">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Date of Birth:</span>
                                                <span class="info-value" id="patient_dob">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Blood Group:</span>
                                                <span class="info-value" id="patient_blood_group">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Marital Status:</span>
                                                <span class="info-value" id="patient_marital_status">-</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Contact Information Panel -->
                                <div class="col-md-6">
                                    <div class="info-panel">
                                        <h5 class="panel-header">
                                            <i class="fa fa-phone text-success"></i> Contact Information
                                        </h5>
                                        <div class="info-table">
                                            <div class="info-row">
                                                <span class="info-label">Phone:</span>
                                                <span class="info-value" id="patient_phone">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Email:</span>
                                                <span class="info-value" id="patient_email">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Address:</span>
                                                <span class="info-value" id="patient_address">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Guardian:</span>
                                                <span class="info-value" id="patient_guardian">-</span>
                                            </div>
                                            <div class="info-row">
                                                <span class="info-label">Emergency Contact:</span>
                                                <span class="info-value" id="patient_emergency_contact">-</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Workflow Information Card -->
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <div class="panel panel-info">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-route"></i> Workflow & Progress Information
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="workflow-info">
                                                <div class="info-row">
                                                    <span class="info-label">Workflow Type:</span>
                                                    <span class="info-value" id="workflow_type">-</span>
                                                </div>
                                                <div class="info-row">
                                                    <span class="info-label">Current Status:</span>
                                                    <span class="info-value" id="workflow_status">-</span>
                                                </div>
                                                <div class="info-row">
                                                    <span class="info-label">Registration Date:</span>
                                                    <span class="info-value" id="registration_date">-</span>
                                                </div>
                                                <div class="info-row">
                                                    <span class="info-label">Last Visit:</span>
                                                    <span class="info-value" id="last_visit_date">-</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="workflow-progress-section">
                                                <h6><i class="fa fa-tasks"></i> Progress Tracker</h6>
                                                <div id="workflow_progress">
                                                    <!-- Workflow progress will be displayed here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Medical & Organization Information -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="panel panel-warning">
                                <div class="panel-heading">
                                    <h5 class="panel-title">
                                        <i class="fa fa-heartbeat"></i> Medical Information
                                    </h5>
                                </div>
                                <div class="panel-body">
                                    <div class="info-table">
                                        <div class="info-row">
                                            <span class="info-label">Known Allergies:</span>
                                            <span class="info-value" id="patient_allergies">-</span>
                                        </div>
                                        <div class="info-row">
                                            <span class="info-label">Medical Notes:</span>
                                            <span class="info-value" id="patient_notes">-</span>
                                        </div>
                                        <div class="info-row">
                                            <span class="info-label">Chronic Conditions:</span>
                                            <span class="info-value" id="patient_conditions">-</span>
                                        </div>
                                        <div class="info-row">
                                            <span class="info-label">Medications:</span>
                                            <span class="info-value" id="patient_medications">-</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h5 class="panel-title">
                                        <i class="fa fa-building"></i> Organization & Insurance
                                    </h5>
                                </div>
                                <div class="panel-body">
                                    <div class="info-table">
                                        <div class="info-row">
                                            <span class="info-label">Organization:</span>
                                            <span class="info-value" id="patient_organization">-</span>
                                        </div>
                                        <div class="info-row">
                                            <span class="info-label">Insurance ID:</span>
                                            <span class="info-value" id="patient_insurance_id">-</span>
                                        </div>
                                        <div class="info-row">
                                            <span class="info-label">Insurance Validity:</span>
                                            <span class="info-value" id="patient_insurance_validity">-</span>
                                        </div>
                                        <div class="info-row">
                                            <span class="info-label">ID Number:</span>
                                            <span class="info-value" id="patient_identification">-</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Biometric Information (if available) -->
                    <div id="biometric_section" style="display: none;">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">
                                            <i class="fa fa-fingerprint"></i> Biometric & Security Information
                                        </h5>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="biometric-info">
                                                    <div class="info-row">
                                                        <span class="info-label">Fingerprint Status:</span>
                                                        <span class="info-value" id="fingerprint_status">-</span>
                                                    </div>
                                                    <div id="fingerprint_display" class="text-center" style="margin-top: 15px;">
                                                        <!-- Fingerprint image will be displayed here -->
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="verification-info">
                                                    <div class="info-row">
                                                        <span class="info-label">Verification Status:</span>
                                                        <span class="badge badge-success">Verified</span>
                                                    </div>
                                                    <div class="info-row">
                                                        <span class="info-label">Last Updated:</span>
                                                        <span class="info-value" id="biometric_updated">-</span>
                                                    </div>
                                                    <div class="info-row">
                                                        <span class="info-label">Capture Quality:</span>
                                                        <span class="info-value" id="biometric_quality">-</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Visit History Section -->
                    
                </div>
            </div>
            <div class="modal-footer">
                <div class="btn-group pull-left">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <i class="fa fa-times"></i> Close
                    </button>
                </div>
                <div class="btn-group pull-right">
                    <button type="button" class="btn btn-info" id="editPatientBtn">
                        <i class="fa fa-edit"></i> Edit Patient
                    </button>
                    <button type="button" class="btn btn-success" id="addVisitBtn">
                        <i class="fa fa-plus"></i> Add Visit
                    </button>
                    <button type="button" class="btn btn-warning" id="printPatientBtn">
                        <i class="fa fa-print"></i> Print Card
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Patient Modal -->
<div class="modal fade" id="addpatientModal" role="dialog" aria-labelledby="addPatientModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="addPatientModalLabel">
                    <i class="fa fa-user-plus"></i> New Patient Registration
                </h4>
            </div>
            
            <form id="formaddpa" accept-charset="utf-8" action="<?php echo base_url() ?>admin/patient/create" enctype="multipart/form-data" method="post">
                <div class="modal-body">
                    <!-- Workflow Selection Section -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-info">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-route"></i> Step 1: Select Patient Workflow
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <p class="help-text">
                                        <i class="fa fa-info-circle"></i>
                                        Choose the appropriate workflow type to determine the patient's care pathway and required services.
                                    </p>
                                    
                                    <div class="workflow-selection">
                                        <?php foreach ($workflows as $key => $workflow): ?>
                                        <div class="workflow-option" data-workflow="<?php echo $key; ?>">
                                            <label class="workflow-label">
                                                <input type="radio" name="patient_workflow" value="<?php echo $key; ?>" 
                                                       data-description="<?php echo $workflow['description']; ?>"
                                                       data-cost="<?php echo $workflow['base_cost']; ?>"
                                                       data-restrictions='<?php echo json_encode($workflow['step_restrictions']); ?>'
                                                       onchange="updateWorkflowInfo()" required>
                                                <div class="workflow-card">
                                                    <div class="workflow-header">
                                                        <h5 class="workflow-name"><?php echo $workflow['name']; ?></h5>
                                                        <span class="workflow-cost">KES <?php echo number_format($workflow['base_cost']); ?></span>
                                                    </div>
                                                    <div class="workflow-description">
                                                        <p><?php echo $workflow['description']; ?></p>
                                                    </div>
                                                    <div class="workflow-features">
                                                        <small class="text-muted">
                                                            <?php if (!empty($workflow['mandatory_steps'])): ?>
                                                                <strong>Required:</strong> <?php echo implode(', ', $workflow['mandatory_steps']); ?>
                                                            <?php else: ?>
                                                                <strong>Flexible workflow</strong> - No mandatory steps
                                                            <?php endif; ?>
                                                        </small>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>

                                    <!-- Workflow Information Panel -->
                                    <div id="workflow-info-panel" class="alert alert-info" style="display: none; margin-top: 20px;">
                                        <h5><i class="fa fa-info-circle"></i> Selected Workflow Details</h5>
                                        <div id="workflow-description"></div>
                                        <div id="workflow-restrictions" class="mt-2"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Basic Patient Information -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-primary">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-user"></i> Step 2: Basic Patient Information
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                                                <input id="name" name="name" type="text" class="form-control" 
                                                       placeholder="Enter patient's full name" 
                                                       value="<?php echo set_value('name'); ?>" required />
                                                <span class="text-danger"><?php echo form_error('name'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('gender'); ?> <span class="required">*</span></label>
                                                <select class="form-control" name="gender" required>
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                    <?php foreach ($genderList_Patient as $key => $value) { ?>
                                                        <option value="<?php echo $key; ?>" <?php echo set_select('gender', $key); ?>>
                                                            <?php echo $value; ?>
                                                        </option>
                                                    <?php } ?>
                                                </select>
                                                <span class="text-danger"><?php echo form_error('gender'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('patient') . " " . $this->lang->line('photo'); ?></label>
                                                <input class="form-control" type='file' name='file' id="file" 
                                                       accept="image/*" />
                                                <small class="text-muted">Optional: Upload patient photo</small>
                                                <span class="text-danger"><?php echo form_error('file'); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('date_of_birth'); ?></label>
                                                <input id="dob" name="dob" placeholder="yyyy-mm-dd" type="date" 
                                                       class="form-control patient_dob" 
                                                       value="<?php echo set_value('dob'); ?>" />
                                                <span class="text-danger"><?php echo form_error('dob'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('age'); ?> (Years)</label>
                                                <input type="number" name="age" id="age_year" class="form-control" 
                                                       placeholder="Years" value="<?php echo set_value('age'); ?>" />
                                                <span class="text-danger"><?php echo form_error('age'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('blood_group'); ?></label>
                                                <select class="form-control" name="blood_group" id="blood_group">
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                    <?php if(isset($bloodgroup)): ?>
                                                        <?php foreach ($bloodgroup as $key => $value) { ?>
                                                            <option value="<?php echo $value; ?>" <?php echo set_select('blood_group', $value); ?>>
                                                                <?php echo $value; ?>
                                                            </option>
                                                        <?php } ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('marital_status'); ?></label>
                                                <select class="form-control" name="marital_status">
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                    <?php foreach ($marital_status as $mkey => $mvalue) { ?>
                                                        <option value="<?php echo $mkey; ?>" <?php echo set_select('marital_status', $mkey); ?>>
                                                            <?php echo $mvalue; ?>
                                                        </option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-success">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-phone"></i> Step 3: Contact Information
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('phone'); ?> <span class="required">*</span></label>
                                                <input id="contact" name="mobileno" type="text" class="form-control" 
                                                       placeholder="Enter phone number" 
                                                       value="<?php echo set_value('mobileno'); ?>" required />
                                                <span class="text-danger"><?php echo form_error('mobileno'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('email'); ?></label>
                                                <input type="email" id="email" name="email" class="form-control" 
                                                       placeholder="Enter email address" 
                                                       value="<?php echo set_value('email'); ?>" />
                                                <span class="text-danger"><?php echo form_error('email'); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('address'); ?></label>
                                                <textarea name="address" id="address" class="form-control" rows="3" 
                                                          placeholder="Enter complete address"><?php echo set_value('address'); ?></textarea>
                                                <span class="text-danger"><?php echo form_error('address'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('guardian_name'); ?></label>
                                                <input type="text" name="guardian_name" id="guardian_name" class="form-control" 
                                                       placeholder="Enter guardian/next of kin name" 
                                                       value="<?php echo set_value('guardian_name'); ?>" />
                                                <span class="text-danger"><?php echo form_error('guardian_name'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Medical Information -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-warning">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-heartbeat"></i> Step 4: Medical Information
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('known_allergies'); ?></label>
                                                <textarea name="known_allergies" id="known_allergies" class="form-control" rows="3" 
                                                          placeholder="List any known allergies or drug reactions"><?php echo set_value('known_allergies'); ?></textarea>
                                                <span class="text-danger"><?php echo form_error('known_allergies'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('note'); ?></label>
                                                <textarea name="note" id="note" class="form-control" rows="3" 
                                                          placeholder="Additional medical notes or comments"><?php echo set_value('note'); ?></textarea>
                                                <span class="text-danger"><?php echo form_error('note'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Insurance Information -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-building"></i> Step 5: Insurance & Organization (Optional)
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('organisation'); ?></label>
                                                <select class="form-control select2" name="organisation" id="organisation">
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                    <?php if(isset($organisation)): ?>
                                                        <?php foreach ($organisation as $orgkey => $orgvalue) { ?>
                                                            <option value="<?php echo $orgvalue["id"]; ?>" <?php echo set_select('organisation', $orgvalue["id"]); ?>>
                                                                <?php echo $orgvalue["organisation_name"] ?>
                                                            </option>
                                                        <?php } ?>
                                                    <?php endif; ?>
                                                </select>
                                                <span class="text-danger"><?php echo form_error('organisation'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('insurance_id'); ?></label>
                                                <input type="text" name="insurance_id" id="insurance_id" class="form-control" 
                                                       placeholder="Insurance ID number" 
                                                       value="<?php echo set_value('insurance_id'); ?>" />
                                                <span class="text-danger"><?php echo form_error('insurance_id'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('insurance_validity'); ?></label>
                                                <input id="insurance_validity" name="insurance_validity" type="date" 
                                                       class="form-control" 
                                                       value="<?php echo set_value('insurance_validity'); ?>" />
                                                <span class="text-danger"><?php echo form_error('insurance_validity'); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('identification_number'); ?></label>
                                                <input type="text" name="identification_number" id="identification_number" 
                                                       class="form-control" placeholder="National ID / Passport number" 
                                                       value="<?php echo set_value('identification_number'); ?>" />
                                                <span class="text-danger"><?php echo form_error('identification_number'); ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('patient_type'); ?></label>
                                                <select class="form-control" name="patient_type" id="patient_type">
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                    <?php if(isset($patienttype)): ?>
                                                        <?php foreach ($patienttype as $ptkey => $ptvalue) { ?>
                                                            <option value="<?php echo $ptvalue["id"]; ?>" <?php echo set_select('patient_type', $ptvalue["id"]); ?>>
                                                                <?php echo $ptvalue["patient_type"] ?>
                                                            </option>
                                                        <?php } ?>
                                                    <?php endif; ?>
                                                </select>
                                                <span class="text-danger"><?php echo form_error('patient_type'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Workflow-Specific Fields (will be shown/hidden based on selection) -->
                    <div id="workflow-specific-fields" style="display: none;">
                        <!-- GCC Specific Fields -->
                        <div id="gcc-fields" class="workflow-fields" style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="panel panel-info">
                                        <div class="panel-heading">
                                            <h4 class="panel-title">
                                                <i class="fa fa-globe"></i> GCC Workflow Requirements
                                            </h4>
                                        </div>
                                        <div class="panel-body">
                                            <div class="alert alert-info">
                                                <i class="fa fa-info-circle"></i>
                                                <strong>GCC Requirements:</strong> This workflow requires biometric capture and specific documentation for Gulf Cooperation Council health screenings.
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>GCC Package Type</label>
                                                        <select name="gcc_package" class="form-control">
                                                            <option value="">Select Package</option>
                                                            <option value="basic">Basic Health Screening</option>
                                                            <option value="comprehensive">Comprehensive Health Check</option>
                                                            <option value="executive">Executive Health Package</option>
                                                            <option value="women">Women's Health Package</option>
                                                            <option value="cardiac">Cardiac Screening</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Purpose of Visit</label>
                                                        <select name="gcc_purpose" class="form-control">
                                                            <option value="">Select Purpose</option>
                                                            <option value="employment">Employment Medical</option>
                                                            <option value="visa">Visa Application</option>
                                                            <option value="residence">Residence Permit</option>
                                                            <option value="renewal">Medical Renewal</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Nationality</label>
                                                        <input type="text" name="nationality" class="form-control" 
                                                               placeholder="Patient's nationality">
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Preferred Appointment Date</label>
                                                        <input type="date" name="gcc_appointment_date" class="form-control" 
                                                               min="<?php echo date('Y-m-d'); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Specialized Workflow Fields -->
                        <div id="specialized-fields" class="workflow-fields" style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="panel panel-warning">
                                        <div class="panel-heading">
                                            <h4 class="panel-title">
                                                <i class="fa fa-star"></i> Specialized Medical Process
                                            </h4>
                                        </div>
                                        <div class="panel-body">
                                            <div class="alert alert-warning">
                                                <i class="fa fa-exclamation-triangle"></i>
                                                <strong>Priority Care:</strong> This workflow provides expedited service with mandatory triage assessment.
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label>Chief Complaint / Presenting Symptoms <span class="required">*</span></label>
                                                        <textarea name="chief_complaint" class="form-control" rows="3" 
                                                                  placeholder="Describe the primary reason for visit and symptoms" 
                                                                  required></textarea>
                                                        <small class="text-muted">Required for specialized workflow triage assessment</small>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Priority Level</label>
                                                        <select name="priority_level" class="form-control">
                                                            <option value="normal">Normal Priority</option>
                                                            <option value="high">High Priority</option>
                                                            <option value="urgent">Urgent</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Specialty Required</label>
                                                        <select name="specialty_required" class="form-control">
                                                            <option value="">Select Specialty</option>
                                                            <option value="cardiology">Cardiology</option>
                                                            <option value="neurology">Neurology</option>
                                                            <option value="orthopedics">Orthopedics</option>
                                                            <option value="gastroenterology">Gastroenterology</option>
                                                            <option value="endocrinology">Endocrinology</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- General Workflow Fields -->
                        <div id="general-fields" class="workflow-fields" style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title">
                                                <i class="fa fa-user"></i> General Medical Process
                                            </h4>
                                        </div>
                                        <div class="panel-body">
                                            <div class="alert alert-info">
                                                <i class="fa fa-info-circle"></i>
                                                <strong>Flexible Workflow:</strong> You can access any service as needed without strict ordering requirements.
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label>Services Requested (Optional)</label>
                                                        <div class="checkbox-group" style="margin-top: 10px;">
                                                            <label class="checkbox-inline" style="margin-right: 20px;">
                                                                <input type="checkbox" name="requested_services[]" value="triage"> 
                                                                <i class="fa fa-stethoscope"></i> Triage Assessment
                                                            </label>
                                                            <label class="checkbox-inline" style="margin-right: 20px;">
                                                                <input type="checkbox" name="requested_services[]" value="consultation"> 
                                                                <i class="fa fa-user-md"></i> Doctor Consultation
                                                            </label>
                                                            <label class="checkbox-inline" style="margin-right: 20px;">
                                                                <input type="checkbox" name="requested_services[]" value="laboratory"> 
                                                                <i class="fa fa-flask"></i> Laboratory Tests
                                                            </label>
                                                            <label class="checkbox-inline" style="margin-right: 20px;">
                                                                <input type="checkbox" name="requested_services[]" value="radiology"> 
                                                                <i class="fa fa-camera"></i> Radiology/Imaging
                                                            </label>
                                                            <label class="checkbox-inline">
                                                                <input type="checkbox" name="requested_services[]" value="pharmacy"> 
                                                                <i class="fa fa-medkit"></i> Pharmacy
                                                            </label>
                                                        </div>
                                                        <small class="text-muted">Select the services you anticipate the patient may need</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Custom Fields -->
                    <div class="row">
                        <div class="col-md-12">
                            <?php if(function_exists('display_custom_fields')): ?>
                                <?php echo display_custom_fields('patient'); ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Hidden Fields for Workflow Tracking -->
                    <input type="hidden" name="is_triage" id="is_triage" value="not_required">
                    <input type="hidden" name="is_consultation" id="is_consultation" value="not_required">
                    <input type="hidden" name="is_laboratory" id="is_laboratory" value="not_required">
                    <input type="hidden" name="is_radiology" id="is_radiology" value="not_required">
                    <input type="hidden" name="workflow_restrictions" id="workflow_restrictions" value="">
                </div>
                
                <div class="modal-footer">
                    <div class="btn-group pull-left">
                        <button type="button" class="btn btn-default" data-dismiss="modal">
                            <i class="fa fa-times"></i> Cancel
                        </button>
                        <button type="button" class="btn btn-info" onclick="resetForm()">
                            <i class="fa fa-refresh"></i> Reset
                        </button>
                    </div>
                    <div class="btn-group pull-right">
                        <button type="submit" id="formaddpabtn" data-loading-text="Processing..." class="btn btn-success">
                            <i class="fa fa-check-circle"></i> Register Patient
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Workflow Guide Modal -->
<div class="modal fade" id="workflowGuideModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-question-circle"></i> Patient Workflow Guide
                </h4>
            </div>
            <div class="modal-body">
                <!-- Workflow guide content will be populated by JavaScript -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    <i class="fa fa-times"></i> Close
                </button>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript Configuration -->
<script type="text/javascript">
    // Configuration variables for JavaScript
    var PatientConfig = {
        baseUrl: '<?php echo base_url(); ?>',
        workflows: <?php echo json_encode($workflows); ?>,
        currency: '<?php echo $currency_symbol; ?>',
        isDevelopment: <?php echo (ENVIRONMENT === 'development') ? 'true' : 'false'; ?>,
        lang: {
            loading: '<?php echo $this->lang->line("loading") ?: "Loading..."; ?>',
            error: '<?php echo $this->lang->line("error") ?: "Error"; ?>',
            success: '<?php echo $this->lang->line("success") ?: "Success"; ?>',
            confirm_delete: '<?php echo $this->lang->line("are_you_sure") ?: "Are you sure?"; ?>',
            processing: '<?php echo $this->lang->line("processing") ?: "Processing..."; ?>'
        }
    };
</script>

<!-- Include JavaScript files -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<script>
/**
 * Enhanced Patient Registration System
 * JavaScript functionality for patient management
 */

(function($) {
    'use strict';

    // Global variables
    var table = null;
    var base_url = PatientConfig.baseUrl || window.base_url || '';
    var workflows = PatientConfig.workflows || {};
    var isDevelopment = PatientConfig.isDevelopment || false;

    // Initialize on document ready
    $(document).ready(function() {
        initializeSystem();
    });

    /**
     * Initialize the entire patient registration system
     */
    function initializeSystem() {
        console.log('Initializing Patient Registration System...');
        
        // Detect and set base URL if not available
        detectBaseUrl();
        
        // Show debug tools in development
        if (isDevelopment) {
            $('.debug-tools').show();
        }
        
        // Initialize DataTable with error handling
        initializeDataTable();
        
        // Initialize filters
        initializeFilters();
        
        // Initialize modals
        initializeModals();
        
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
        
        console.log('Patient Registration System initialized successfully');
    }

    /**
     * Detect and set base URL from various sources
     */
    function detectBaseUrl() {
        if (!base_url) {
            // Try different global variables
            if (typeof site_url !== 'undefined') {
                base_url = site_url;
            } else if (typeof baseurl !== 'undefined') {
                base_url = baseurl;
            } else {
                // Extract from current URL
                const path = window.location.pathname;
                const segments = path.split('/').filter(segment => segment);
                
                if (segments.includes('admin')) {
                    const adminIndex = segments.indexOf('admin');
                    const basePath = '/' + segments.slice(0, adminIndex).join('/') + '/';
                    base_url = window.location.origin + basePath;
                } else {
                    base_url = window.location.origin + '/';
                }
            }
            
            console.log('Detected base_url:', base_url);
        }
        
        // Make available globally
        window.base_url = base_url;
    }

    /**
     * Initialize DataTable with comprehensive error handling
     */
    function initializeDataTable() {
        console.log('Initializing DataTable...');
        
        // Test endpoint first
        testDataTableEndpoint().then(function(isWorking) {
            if (isWorking) {
                initializeServerSideTable();
            } else {
                console.warn('Server-side endpoint not working, falling back to client-side');
                initializeClientSideTable();
            }
        }).catch(function(error) {
            console.error('DataTable initialization failed:', error);
            showErrorAlert('Failed to initialize patient table. Please refresh the page.');
        });
    }

    /**
     * Test if the DataTable endpoint is working
     */
    function testDataTableEndpoint() {
        return new Promise(function(resolve) {
            $.ajax({
                url: base_url + "admin/patient/getpatientdatatable",
                type: "POST",
                data: { 
                    start: 0, 
                    length: 1,
                    draw: 1,
                    search: { value: "" }
                },
                timeout: 5000,
                success: function(response) {
                    console.log('DataTable endpoint test successful:', response);
                    resolve(true);
                },
                error: function(xhr, status, error) {
                    console.warn('DataTable endpoint test failed:', error);
                    resolve(false);
                }
            });
        });
    }

    /**
     * Initialize server-side DataTable
     */
    function initializeServerSideTable() {
        try {
            table = $('.ajaxlist').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": base_url + "admin/patient/getpatientdatatable",
                    "type": "POST",
                    "data": function(d) {
                        d.workflow_filter = $('#workflow_filter').val() || '';
                        d.gender_filter = $('#gender_filter').val() || '';
                        d.date_from = $('#date_from').val() || '';
                        d.date_to = $('#date_to').val() || '';
                    },
                    "error": function(xhr, error, code) {
                        console.error('DataTable AJAX Error:', error);
                        showErrorAlert('Error loading patient data: ' + error);
                    }
                },
                "columns": getDataTableColumns(),
                "order": [[1, "desc"]],
                "pageLength": 25,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "All"]],
                "language": getDataTableLanguage(),
                "responsive": true,
                "autoWidth": false,
                "columnDefs": getColumnDefinitions(),
                "drawCallback": function() {
                    // Reinitialize tooltips after each draw
                    $('[data-toggle="tooltip"]').tooltip();
                }
            });
            
            // Store table reference globally
            window.table = table;
            console.log('Server-side DataTable initialized successfully');
            
        } catch (error) {
            console.error('Server-side DataTable initialization failed:', error);
            initializeClientSideTable();
        }
    }

    /**
     * Initialize client-side DataTable as fallback
     */
    function initializeClientSideTable() {
        try {
            // Destroy any existing table first
            if ($.fn.DataTable.isDataTable('.ajaxlist')) {
                $('.ajaxlist').DataTable().destroy();
            }
            
            table = $('.ajaxlist').DataTable({
                "processing": false,
                "serverSide": false,
                "ajax": {
                    "url": base_url + "admin/patient/getAllPatients",
                    "type": "GET",
                    "dataSrc": function(json) {
                        console.log('Client-side data received:', json);
                        return json.data || json || [];
                    },
                    "error": function(xhr, error, code) {
                        console.error('Client-side AJAX Error:', error);
                        showErrorAlert('Error loading patient data. Please contact support.');
                    }
                },
                "columns": getDataTableColumns(),
                "order": [[1, "desc"]],
                "pageLength": 25,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "All"]],
                "language": getDataTableLanguage(),
                "responsive": true,
                "autoWidth": false,
                "columnDefs": getColumnDefinitions(),
                "drawCallback": function() {
                    $('[data-toggle="tooltip"]').tooltip();
                }
            });
            
            window.table = table;
            console.log('Client-side DataTable initialized successfully');
            
        } catch (error) {
            console.error('Client-side DataTable initialization failed:', error);
            showFallbackTable();
        }
    }

    /**
     * Get DataTable column definitions
     */
    function getDataTableColumns() {
        return [
            {
                "data": null,
                "render": function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                },
                "orderable": false,
                "className": "text-center"
            },
            {
                "data": function(row) {
                    return getRowData(row, ['patient_unique_id', 'id', 7], 'N/A');
                },
                "render": function(data, type, row) {
                    return '<span class="badge badge-info">' + data + '</span>';
                },
                "className": "text-center"
            },
            {
                "data": function(row) {
                    return getRowData(row, ['patient_name', 'name', 0], 'N/A');
                },
                "render": function(data, type, row) {
                    return '<strong>' + data + '</strong>';
                }
            },
            {
                "data": function(row) {
                    // Based on debug: Index 4 is guardian name (Nova), Index 5 is address
                    return getRowData(row, ['guardian_name', 4], 'N/A');
                },
                "render": function(data, type, row) {
                    return data && data !== 'N/A' ? data : '<span class="text-muted">N/A</span>';
                }
            },
            {
                "data": function(row) {
                    return getRowData(row, ['gender', 2], 'N/A');
                },
                "render": function(data, type, row) {
                    if (!data || data === 'N/A') return '<span class="text-muted">N/A</span>';
                    const genderIcon = data.toLowerCase() === 'male' ? 'fa-mars text-primary' : 'fa-venus text-pink';
                    return '<i class="fa ' + genderIcon + '"></i> ' + data;
                },
                "className": "text-center"
            },
            {
                "data": function(row) {
                    return getRowData(row, ['mobileno', 'phone', 3], 'N/A');
                },
                "render": function(data, type, row) {
                    return data && data !== 'N/A' ? '<i class="fa fa-phone text-success"></i> ' + data : '<span class="text-muted">N/A</span>';
                },
                "className": "text-center"
            },
            {
                "data": function(row) {
                    return getRowData(row, ['patient_workflow', 8], 'general');
                },
                "render": function(data, type, row) {
                    const badges = {
                        'gcc': '<span class="label label-primary"><i class="fa fa-globe"></i> GCC</span>',
                        'specialized': '<span class="label label-warning"><i class="fa fa-star"></i> Specialized</span>',
                        'general': '<span class="label label-default"><i class="fa fa-user"></i> General</span>'
                    };
                    return badges[data] || badges['general'];
                },
                "orderable": false,
                "className": "text-center"
            },
            {
                "data": function(row) {
                    // Based on your debug output, we need to look at a different index for actual patient status
                    // Index 9 contains workflow status ("not_required", "pending"), not patient active status
                    // Let's check indices 10, 11, 12 for the actual patient status
                    return getRowData(row, [10, 11, 12, 'is_active', 'status', 'active'], 'yes');
                },
                "render": function(data, type, row) {
                    // Handle different status value formats
                    let isActive = false;
                    
                    // Debug what we're actually getting
                    console.log('Status render - data:', data, 'full row:', row);
                    
                    // Check for various active status indicators
                    if (data === 'yes' || data === 'Yes' || data === 'YES' || 
                        data === '1' || data === 1 || data === true || 
                        data === 'active' || data === 'Active' || data === 'ACTIVE') {
                        isActive = true;
                    }
                    // Handle workflow status values that might indicate active patients
                    else if (data === 'not_required' || data === 'pending' || data === 'completed') {
                        // These workflow statuses usually mean the patient is active
                        isActive = true;
                    }
                    // If we get undefined/null/empty, assume patient is active by default
                    else if (!data || data === '' || data === null || data === undefined) {
                        isActive = true;
                    }
                    
                    return isActive ? 
                        '<span class="label label-success"><i class="fa fa-check"></i> Active</span>' :
                        '<span class="label label-danger"><i class="fa fa-times"></i> Inactive</span>';
                },
                "orderable": false,
                "className": "text-center"
            },
            {
                "data": null,
                "render": function(data, type, row) {
                    var patientId = getRowData(row, ['id', 'patient_id', 'patient_unique_id', 7], null);
                    
                    if (!patientId) {
                        return '<span class="text-muted">No ID</span>';
                    }
                    
                    var actions = '<div class="btn-group">';
                    actions += '<button type="button" class="btn btn-xs btn-primary" onclick="getpatientData(' + patientId + ')" title="View Details" data-toggle="tooltip">';
                    actions += '<i class="fa fa-eye"></i></button>';
                    actions += '<button type="button" class="btn btn-xs btn-info" onclick="editRecord(' + patientId + ')" title="Edit" data-toggle="tooltip">';
                    actions += '<i class="fa fa-pencil"></i></button>';
                    actions += '<button type="button" class="btn btn-xs btn-success" onclick="addVisit(' + patientId + ')" title="Add Visit" data-toggle="tooltip">';
                    actions += '<i class="fa fa-plus"></i></button>';
                    actions += '</div>';
                    return actions;
                },
                "orderable": false,
                "className": "text-center"
            }
        ];
    }

    /**
     * Helper function to safely get data from row (handles both array and object formats)
     */
    function getRowData(row, keys, defaultValue) {
        if (!row) return defaultValue;
        
        // Debug logging for the first few rows
        if (typeof window.debugRowCount === 'undefined') {
            window.debugRowCount = 0;
        }
        
        if (window.debugRowCount < 3) {
            console.log(`Row ${window.debugRowCount} structure:`, row);
            console.log(`Looking for keys:`, keys);
            window.debugRowCount++;
        }
        
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            
            if (Array.isArray(row) && typeof key === 'number') {
                if (row[key] !== undefined && row[key] !== null && row[key] !== '') {
                    console.log(`Found value at array index ${key}:`, row[key]);
                    return row[key];
                }
            } else if (typeof row === 'object' && typeof key === 'string') {
                if (row[key] !== undefined && row[key] !== null && row[key] !== '') {
                    console.log(`Found value at object key ${key}:`, row[key]);
                    return row[key];
                }
            }
        }
        
        console.log(`No value found for keys ${keys}, using default:`, defaultValue);
        return defaultValue;
    }

    /**
     * Get DataTable language configuration
     */
    function getDataTableLanguage() {
        return {
            "search": "Search Patients:",
            "lengthMenu": "Show _MENU_ patients per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ patients",
            "paginate": {
                "first": "First",
                "last": "Last",
                "next": "Next",
                "previous": "Previous"
            },
            "processing": "Loading patient data...",
            "emptyTable": "No patient data available",
            "loadingRecords": "Loading...",
            "zeroRecords": "No matching patients found"
        };
    }

    /**
     * Get DataTable column definitions
     */
    function getColumnDefinitions() {
        return [
            { "width": "3%", "targets": 0 },
            { "width": "15%", "targets": 1 },
            { "width": "20%", "targets": 2 },
            { "width": "15%", "targets": 3 },
            { "width": "8%", "targets": 4 },
            { "width": "12%", "targets": 5 },
            { "width": "10%", "targets": 6 },
            { "width": "8%", "targets": 7 },
            { "width": "9%", "targets": 8 }
        ];
    }

    /**
     * Show fallback table when all DataTable methods fail
     */
    function showFallbackTable() {
        $('.ajaxlist tbody').html(`
            <tr>
                <td colspan="9" class="text-center">
                    <div class="alert alert-warning">
                        <h4><i class="fa fa-exclamation-triangle"></i> Table Loading Error</h4>
                        <p>Unable to load the patient data table. Please try refreshing the page.</p>
                        <button class="btn btn-primary" onclick="window.location.reload()">
                            <i class="fa fa-refresh"></i> Refresh Page
                        </button>
                    </div>
                </td>
            </tr>
        `);
    }

    /**
     * Initialize filter functionality
     */
    function initializeFilters() {
        $('#workflow_filter, #gender_filter, #date_from, #date_to').on('change', function() {
            if (table && table.ajax) {
                table.ajax.reload();
            }
        });
    }

    /**
     * Initialize modal functionality
     */
    function initializeModals() {
        // Reset modal content when closed
        $('#myModal').on('hidden.bs.modal', function() {
            resetPatientModal();
        });
        
        // Initialize form validation
        initializeFormValidation();
    }

    /**
     * Reset patient modal to initial state
     */
    function resetPatientModal() {
        $('#modal-loading').show();
        $('#modal-content').hide();
        $('#modal_head').html('<i class="fa fa-user"></i> Patient Details');
        $('#edit_delete').empty();
    }

    /**
     * Initialize form validation
     */
    function initializeFormValidation() {
        $('#formaddpa').on('submit', function(e) {
            e.preventDefault();
            
            // Validate workflow selection
            const selectedWorkflow = $('input[name="patient_workflow"]:checked').val();
            if (!selectedWorkflow) {
                showErrorAlert('Please select a patient workflow before proceeding.');
                return false;
            }
            
            // Submit form via AJAX
            submitPatientForm();
        });
    }

    /**
     * Submit patient registration form
     */
    function submitPatientForm() {
        const submitBtn = $('#formaddpabtn');
        
        $.ajax({
            url: base_url + 'admin/patient/addpatient',
            type: "POST",
            data: new FormData($('#formaddpa')[0]),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function() {
                submitBtn.button('loading');
            },
            success: function(data) {
                if (data.status == "fail") {
                    let message = "";
                    $.each(data.error, function(index, value) {
                        message += value + "<br>";
                    });
                    showErrorAlert(message);
                } else {
                    showSuccessAlert(data.message);
                    $("#addpatientModal").modal('hide');
                    
                    // Reload table
                    if (table && table.ajax) {
                        table.ajax.reload();
                    } else {
                        window.location.reload();
                    }
                }
            },
            error: function(xhr) {
                showErrorAlert('Error occurred while saving patient. Please try again.');
            },
            complete: function() {
                submitBtn.button('reset');
            }
        });
    }

    /**
     * Load and display patient data in modal
     */
    window.getpatientData = function(id) {
        console.log('Loading patient data for ID:', id);
        
        // Show modal with loading state
        $('#myModal').modal('show');
        resetPatientModal();
        
        $.ajax({
            url: base_url + 'admin/patient/getpatientDetails',
            type: "POST",
            data: { id: id },
            dataType: 'json',
            timeout: 10000,
            success: function(data) {
                console.log('Patient data received:', data);
                
                if (!data || data.error) {
                    showModalError('Failed to load patient data: ' + (data?.error || 'Unknown error'));
                    return;
                }
                
                // Update modal header
                $('#modal_head').html('<i class="fa fa-user"></i> ' + (data.patient_name || 'Patient') + ' - Details');
                
                // Populate patient data
                populatePatientModal(data);
                
                // Load visit history
                loadVisitHistory(id);
                
                // Show content
                $('#modal-loading').hide();
                $('#modal-content').show();
                
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error loading patient:', error);
                showModalError('Failed to load patient details. Please try again.');
            }
        });
    };

    /**
     * Populate patient modal with data
     */
    function populatePatientModal(data) {
        // Set patient photo
        const photoSrc = data.image && data.image !== 'no_image.png' ? 
            base_url + data.image : 
            base_url + 'uploads/patient_images/no_image.png';
        $('#patient_photo').attr('src', photoSrc);
        
        // Set patient ID badge
        $('#patient_id_display').text('ID: ' + (data.patient_unique_id || data.id || 'N/A'));
        
        // Populate basic information
        $('#patient_name').text(data.patient_name || 'N/A');
        $('#patient_age').text(data.age ? data.age + ' years' : 'N/A');
        $('#patient_gender').html(getGenderDisplay(data.gender));
        $('#patient_dob').text(data.dob || 'N/A');
        $('#patient_blood_group').text(data.blood_group_name || 'N/A');
        
        // Populate contact information
        $('#patient_phone').html(data.mobileno ? '<i class="fa fa-phone"></i> ' + data.mobileno : 'N/A');
        $('#patient_email').html(data.email ? '<i class="fa fa-envelope"></i> ' + data.email : 'N/A');
        $('#patient_address').text(data.address || 'N/A');
        $('#patient_guardian').text(data.guardian_name || 'N/A');
        $('#patient_marital_status').text(data.marital_status || 'N/A');
        
        // Populate workflow information
        populateWorkflowInfo(data);
        
        // Populate medical information
        $('#patient_allergies').text(data.known_allergies || 'None reported');
        $('#patient_notes').text(data.note || 'No notes');
        
        // Populate organization information
        $('#patient_organization').text(data.organisation_name || 'N/A');
        $('#patient_insurance_id').text(data.insurance_id || 'N/A');
        $('#patient_insurance_validity').text(data.insurance_validity || 'N/A');
        $('#patient_identification').text(data.identification_number || 'N/A');
        
        // Show biometric section if available
        if (data.fingerprint_template || data.fingerprint_image) {
            showBiometricSection(data);
        }
        
        // Update action buttons
        updateActionButtons(data.id || data.patient_id);
    }

    /**
     * Get gender display with icon
     */
    function getGenderDisplay(gender) {
        if (!gender) return 'N/A';
        const icon = gender.toLowerCase() === 'male' ? 'fa-mars text-primary' : 'fa-venus text-danger';
        return `<i class="fa ${icon}"></i> ${gender}`;
    }

    /**
     * Populate workflow information
     */
    function populateWorkflowInfo(data) {
        const workflow = data.patient_workflow || 'general';
        
        const workflowInfo = {
            'gcc': {
                name: 'GCC Workflow',
                color: 'primary',
                icon: 'fa-globe',
                description: 'Comprehensive health screening'
            },
            'specialized': {
                name: 'Specialized Workflow',
                color: 'warning',
                icon: 'fa-star',
                description: 'Priority specialist care'
            },
            'general': {
                name: 'General Workflow',
                color: 'default',
                icon: 'fa-user',
                description: 'Flexible healthcare services'
            }
        };
        
        const info = workflowInfo[workflow] || workflowInfo['general'];
        
        $('#workflow_type').html(`
            <span class="label label-${info.color}">
                <i class="fa ${info.icon}"></i> ${info.name}
            </span>
            <br><small class="text-muted">${info.description}</small>
        `);
        
        // Show workflow status
        const status = data.workflow_status || 'Active';
        const statusClass = status === 'Active' ? 'success' : 'warning';
        $('#workflow_status').html(`
            <span class="label label-${statusClass}">${status}</span>
        `);
        
        // Show workflow progress
        const progress = generateWorkflowProgress(workflow, data);
        $('#workflow_progress').html(progress);
    }

    /**
     * Generate workflow progress display
     */
    function generateWorkflowProgress(workflow, data) {
        const steps = {
            'gcc': ['Registration', 'Triage', 'Laboratory', 'Radiology', 'Consultation'],
            'specialized': ['Registration', 'Triage', 'Consultation'],
            'general': ['Registration', 'Services']
        };
        
        const workflowSteps = steps[workflow] || steps['general'];
        let progressHtml = '<div class="workflow-steps">';
        
        workflowSteps.forEach((step, index) => {
            const isCompleted = index === 0; // Registration is always completed
            const statusClass = isCompleted ? 'success' : 'default';
            const icon = isCompleted ? 'fa-check' : 'fa-clock-o';
            
            progressHtml += `
                <div class="step-item">
                    <span class="label label-${statusClass}">
                        <i class="fa ${icon}"></i> ${step}
                    </span>
                </div>
            `;
        });
        
        progressHtml += '</div>';
        return progressHtml;
    }

    /**
     * Show biometric section
     */
    function showBiometricSection(data) {
        $('#biometric_section').show();
        
        if (data.fingerprint_image) {
            $('#fingerprint_display').html(`
                <img src="data:image/bmp;base64,${data.fingerprint_image}" 
                     style="width: 100px; height: 100px; border: 1px solid #ddd; border-radius: 4px;"
                     alt="Fingerprint">
            `);
            $('#fingerprint_status').html('<span class="label label-success"><i class="fa fa-check"></i> Available</span>');
        } else {
            $('#fingerprint_status').html('<span class="label label-warning"><i class="fa fa-exclamation"></i> Not Available</span>');
        }
        
        $('#biometric_updated').text(data.updated_at || 'Unknown');
    }

    /**
     * Update action buttons in modal
     */
    function updateActionButtons(patientId) {
        let actionHtml = '';
        
        actionHtml += `<a href="#" onclick="editRecord(${patientId})" data-toggle="tooltip" 
                         data-placement="bottom" title="Edit Patient" class="btn btn-xs btn-info">
                         <i class="fa fa-pencil"></i>
                       </a> `;
        
        actionHtml += `<a href="#" onclick="printPatientCard(${patientId})" data-toggle="tooltip" 
                         data-placement="bottom" title="Print Card" class="btn btn-xs btn-success">
                         <i class="fa fa-print"></i>
                       </a> `;
        
        actionHtml += `<a href="#" onclick="deletePatient(${patientId})" data-toggle="tooltip" 
                         data-placement="bottom" title="Delete Patient" class="btn btn-xs btn-danger">
                         <i class="fa fa-trash"></i>
                       </a>`;
        
        $('#edit_delete').html(actionHtml);
        
        // Update footer buttons
        $('#editPatientBtn').off('click').on('click', function() { editRecord(patientId); });
        $('#addVisitBtn').off('click').on('click', function() { addVisit(patientId); });
        
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
    }

    /**
     * Load visit history
     */
    function loadVisitHistory(patientId) {
        $('#visit_report').html('<p class="text-muted"><i class="fa fa-spinner fa-spin"></i> Loading visit history...</p>');
        
        $.ajax({
            url: base_url + 'admin/patient/patientvisit',
            type: "POST",
            data: { id: patientId },
            success: function(data) {
                if (data && data.trim() !== '') {
                    $('#visit_report').html(data);
                } else {
                    $('#visit_report').html(`
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No visit history found for this patient.
                            <button class="btn btn-sm btn-primary" onclick="addVisit(${patientId})" style="margin-left: 10px;">
                                <i class="fa fa-plus"></i> Add First Visit
                            </button>
                        </div>
                    `);
                }
            },
            error: function() {
                $('#visit_report').html(`
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i> Failed to load visit history.
                    </div>
                `);
            }
        });
    }

    /**
     * Show error in modal
     */
    function showModalError(message) {
        $('#modal-loading').hide();
        $('#modal-content').html(`
            <div class="alert alert-danger">
                <h4><i class="fa fa-exclamation-triangle"></i> Error</h4>
                <p>${message}</p>
                <button class="btn btn-primary" onclick="window.location.reload()">
                    <i class="fa fa-refresh"></i> Refresh Page
                </button>
            </div>
        `).show();
    }

    /**
     * Utility functions for patient management
     */
    window.editRecord = function(id) {
        console.log('Edit patient:', id);
        window.location.href = base_url + 'admin/patient/edit/' + id;
    };

    window.addVisit = function(patientId) {
        console.log('Add visit for patient:', patientId);
        window.location.href = base_url + 'admin/patient/visit/' + patientId;
    };

    window.deletePatient = function(id) {
        if (confirm('Are you sure you want to delete this patient? This action cannot be undone.')) {
            $.ajax({
                url: base_url + 'admin/patient/deletePatient',
                type: "POST",
                data: { delid: id },
                dataType: 'json',
                success: function(data) {
                    if (data.status === 'success') {
                        $('#myModal').modal('hide');
                        if (table && table.ajax) {
                            table.ajax.reload();
                        } else {
                            window.location.reload();
                        }
                        showSuccessAlert('Patient deleted successfully');
                    } else {
                        showErrorAlert('Failed to delete patient');
                    }
                },
                error: function() {
                    showErrorAlert('Error occurred while deleting patient');
                }
            });
        }
    };

    window.printPatientCard = function(patientId) {
        window.open(base_url + 'admin/patient/printCard/' + patientId, '_blank');
    };

    /**
     * Show workflow guide modal
     */
    window.showWorkflowGuide = function() {
        const modalHtml = `
            <div class="modal fade" id="workflowGuideModal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header bg-info">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">
                                <i class="fa fa-question-circle"></i> Workflow Guide & Information
                            </h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="panel panel-primary">
                                        <div class="panel-heading">
                                            <h5><i class="fa fa-globe"></i> GCC Workflow</h5>
                                        </div>
                                        <div class="panel-body">
                                            <p><strong>Process:</strong> Registration → Triage → Lab → Radiology → Consultation</p>
                                            <p><strong>Features:</strong></p>
                                            <ul>
                                                <li>Mandatory biometric capture</li>
                                                <li>Structured health screening</li>
                                                <li>Complete medical assessment</li>
                                            </ul>
                                            <p><strong>Fee:</strong> <span class="text-success">KES 10,500</span></p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="panel panel-warning">
                                        <div class="panel-heading">
                                            <h5><i class="fa fa-star"></i> Specialized Workflow</h5>
                                        </div>
                                        <div class="panel-body">
                                            <p><strong>Process:</strong> Registration → Triage → Consultation</p>
                                            <p><strong>Features:</strong></p>
                                            <ul>
                                                <li>Priority care pathway</li>
                                                <li>Specialist consultation</li>
                                                <li>Expedited service</li>
                                            </ul>
                                            <p><strong>Fee:</strong> <span class="text-warning">KES 1,900</span></p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5><i class="fa fa-user"></i> General Workflow</h5>
                                        </div>
                                        <div class="panel-body">
                                            <p><strong>Process:</strong> Registration → Flexible Services</p>
                                            <p><strong>Features:</strong></p>
                                            <ul>
                                                <li>Flexible service access</li>
                                                <li>Basic consultation</li>
                                                <li>Standard care pathway</li>
                                            </ul>
                                            <p><strong>Fee:</strong> <span class="text-info">KES 900</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="alert alert-info">
                                <h4><i class="fa fa-lightbulb-o"></i> Key Points:</h4>
                                <ul>
                                    <li>Each workflow enforces specific service ordering</li>
                                    <li>System automatically tracks patient progress</li>
                                    <li>Staff receive clear guidance for each step</li>
                                    <li>Billing is automated based on workflow selection</li>
                                </ul>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Remove existing modal if any
        $('#workflowGuideModal').remove();
        
        // Add modal to body and show
        $('body').append(modalHtml);
        $('#workflowGuideModal').modal('show');
    };

    /**
     * Alert functions
     */
    function showSuccessAlert(message) {
        showAlert(message, 'success');
    }

    function showErrorAlert(message) {
        showAlert(message, 'danger');
    }

    function showAlert(message, type) {
        const alertClass = 'alert-' + type;
        const icon = type === 'success' ? 'fa-check' : 'fa-exclamation-triangle';
        
        const alertHtml = `
            <div class="alert ${alertClass} alert-dismissible alert-custom">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa ${icon}"></i> ${message}
            </div>
        `;
        
        // Remove existing alerts
        $('.alert-custom').remove();
        
        // Add new alert at the top of the content
        $('.content-wrapper .content').prepend(alertHtml);
        
        // Auto-dismiss after 5 seconds
        setTimeout(function() {
            $('.alert-custom').fadeOut();
        }, 5000);
    }

    /**
     * Debug functions
     */
    window.debugPatientTable = function() {
        console.log('=== Patient Table Debug Report ===');
        console.log('Base URL:', base_url);
        console.log('DataTable initialized:', $.fn.DataTable.isDataTable('.ajaxlist'));
        console.log('Table instance exists:', typeof table !== 'undefined');
        
        if (table) {
            console.log('Table data count:', table.data().count());
            console.log('Current table data:', table.data().toArray());
            
            // Show first row structure in detail
            const firstRow = table.data().toArray()[0];
            if (firstRow) {
                console.log('=== FIRST ROW DETAILED ANALYSIS ===');
                console.log('Row type:', Array.isArray(firstRow) ? 'Array' : 'Object');
                console.log('Full row data:', firstRow);
                
                if (Array.isArray(firstRow)) {
                    console.log('=== ARRAY INDICES ===');
                    firstRow.forEach((value, index) => {
                        console.log(`Index ${index}:`, value, `(${typeof value})`);
                    });
                } else if (typeof firstRow === 'object') {
                    console.log('=== OBJECT PROPERTIES ===');
                    Object.keys(firstRow).forEach(key => {
                        console.log(`${key}:`, firstRow[key], `(${typeof firstRow[key]})`);
                    });
                }
            }
        }
        
        // Test endpoints
        const endpoints = [
            'admin/patient/getpatientdatatable',
            'admin/patient/getAllPatients',
            'admin/patient/getpatientDetails'
        ];
        
        console.log('=== TESTING ENDPOINTS ===');
        endpoints.forEach(endpoint => {
            $.ajax({
                url: base_url + endpoint,
                type: 'POST',
                data: { 
                    start: 0, 
                    length: 1,
                    draw: 1,
                    search: { value: "" }
                },
                success: function(response) {
                    console.log(`✓ ${endpoint} response:`, response);
                    if (response && response.data && response.data.length > 0) {
                        console.log(`First row from ${endpoint}:`, response.data[0]);
                    }
                },
                error: function(xhr) {
                    console.log(`✗ ${endpoint} failed:`, xhr.status, xhr.statusText);
                }
            });
        });
    };

    window.debugColumnMapping = function() {
        console.log('=== COLUMN MAPPING DEBUG ===');
        
        if (!table) {
            console.log('Table not initialized');
            return;
        }
        
        const data = table.data().toArray();
        if (data.length === 0) {
            console.log('No data in table');
            return;
        }
        
        const sampleRow = data[0];
        console.log('Sample row:', sampleRow);
        
        // Test each column mapping
        const columnTests = [
            { name: 'Patient ID', keys: ['patient_unique_id', 'id', 7] },
            { name: 'Patient Name', keys: ['patient_name', 'name', 0] },
            { name: 'Guardian Name', keys: ['guardian_name', 5] },
            { name: 'Gender', keys: ['gender', 2] },
            { name: 'Phone', keys: ['mobileno', 'phone', 3] },
            { name: 'Workflow', keys: ['patient_workflow', 8] },
            { name: 'Status', keys: ['is_active', 'status', 'active', 9] }
        ];
        
        console.log('=== COLUMN MAPPING RESULTS ===');
        columnTests.forEach(test => {
            const value = getRowData(sampleRow, test.keys, 'NOT_FOUND');
            console.log(`${test.name}:`, value, `(Keys: ${test.keys.join(', ')})`);
        });
    };

    window.analyzeArrayStructure = function() {
        console.log('=== COMPLETE ARRAY STRUCTURE ANALYSIS ===');
        
        if (!table) {
            console.log('Table not initialized');
            return;
        }
        
        const data = table.data().toArray();
        if (data.length === 0) {
            console.log('No data in table');
            return;
        }
        
        // Analyze first 3 rows completely
        const sampleRows = data.slice(0, 3);
        
        sampleRows.forEach((row, rowIndex) => {
            console.log(`\n=== ROW ${rowIndex} COMPLETE BREAKDOWN ===`);
            console.log('Full row:', row);
            
            if (Array.isArray(row)) {
                row.forEach((value, index) => {
                    console.log(`Index ${index}: "${value}" (${typeof value})`);
                });
                
                console.log('\n=== SUGGESTED COLUMN MAPPING ===');
                console.log('Index 0 (Patient Name):', row[0]);
                console.log('Index 1 (Age):', row[1]);
                console.log('Index 2 (Gender):', row[2]);
                console.log('Index 3 (Phone):', row[3]);
                console.log('Index 4 (?):', row[4]);
                console.log('Index 5 (Address/Guardian?):', row[5]);
                console.log('Index 6 (?):', row[6]);
                console.log('Index 7 (Patient ID):', row[7]);
                console.log('Index 8 (Workflow):', row[8]);
                console.log('Index 9 (Workflow Status):', row[9]);
                console.log('Index 10 (?):', row[10]);
                console.log('Index 11 (?):', row[11]);
                console.log('Index 12 (Patient Status?):', row[12]);
            }
        });
        
        // Suggest the correct mapping
        console.log('\n=== RECOMMENDED FIXES ===');
        console.log('1. Patient Status might be at index 10, 11, or 12');
        console.log('2. Guardian Name should probably be index 4 (Nova) not 5 (address)');
        console.log('3. Address appears to be at index 5');
        console.log('4. Run: fixColumnMapping() to apply suggested fixes');
    };

    window.fixColumnMapping = function() {
        console.log('=== APPLYING COLUMN MAPPING FIXES ===');
        
        // This will require reloading the DataTable with corrected column definitions
        if (table) {
            table.destroy();
        }
        
        // Update the column mapping based on your actual data structure
        console.log('Reinitializing table with corrected mappings...');
        
        // Note: This would require updating the getDataTableColumns function
        // For now, let's just refresh with current settings
        initializeServerSideTable();
        
        console.log('Table reinitialized. Check if status column is now correct.');
    };

    window.refreshPatientTable = function() {
        if (table && table.ajax) {
            console.log('Refreshing server-side table...');
            table.ajax.reload();
        } else {
            console.log('Reloading page to refresh table...');
            window.location.reload();
        }
    };

})(jQuery);
</script>
<style>
    /* Enhanced Patient Registration System Styles */

/* ==========================================================================
   Table Styling Improvements
   ========================================================================== */

.table th {
    background-color: #f8f9fa;
    font-weight: 600;
    border-bottom: 2px solid #dee2e6;
    text-align: center;
    vertical-align: middle;
    padding: 12px 8px;
    font-size: 13px;
    color: #495057;
}

.table td {
    vertical-align: middle;
    padding: 10px 8px;
    font-size: 13px;
    border-top: 1px solid #dee2e6;
}

.table-striped > tbody > tr:nth-of-type(odd) {
    background-color: rgba(0,0,0,.02);
}

.table-hover tbody tr:hover {
    background-color: rgba(60,141,188,0.05);
    transition: background-color 0.15s ease-in-out;
}

.table-bordered {
    border: 1px solid #dee2e6;
}

.table-bordered th,
.table-bordered td {
    border: 1px solid #dee2e6;
}

/* ==========================================================================
   Badge and Label Styling
   ========================================================================== */

.badge {
    font-size: 11px;
    font-weight: 600;
    padding: 4px 8px;
    border-radius: 3px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.badge-primary {
    background-color: #007bff;
    color: white;
}

.label {
    font-size: 11px;
    font-weight: 600;
    padding: 4px 8px;
    border-radius: 3px;
    display: inline-block;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.label-success {
    background-color: #28a745;
    color: white;
}

.label-warning {
    background-color: #ffc107;
    color: #212529;
}

.label-danger {
    background-color: #dc3545;
    color: white;
}

.label-info {
    background-color: #17a2b8;
    color: white;
}

.label-primary {
    background-color: #007bff;
    color: white;
}

.label-default {
    background-color: #6c757d;
    color: white;
}

/* ==========================================================================
   Modal Enhancements
   ========================================================================== */

.modal-lg {
    width: 90%;
    max-width: 1000px;
}

.modal-header.bg-primary {
    background-color: #007bff;
    color: white;
    border-bottom: 1px solid #0056b3;
    border-radius: 6px 6px 0 0;
}

.modal-header h4 {
    margin: 0;
    font-weight: 600;
    font-size: 18px;
}

.modal-header .close {
    color: white;
    opacity: 0.8;
    font-size: 24px;
    font-weight: 300;
}

.modal-header .close:hover {
    opacity: 1;
}

.modal-actions {
    position: absolute;
    right: 50px;
    top: 50%;
    transform: translateY(-50%);
}

.modal-actions .btn {
    margin-left: 5px;
    border-radius: 3px;
    padding: 4px 8px;
    font-size: 12px;
}

.modal-body {
    padding: 20px;
    max-height: 70vh;
    overflow-y: auto;
}

.modal-footer {
    border-top: 1px solid #dee2e6;
    padding: 15px 20px;
}

/* ==========================================================================
   Patient Photo and Layout Styling
   ========================================================================== */

.patient-photo-card {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    position: relative;
}

.patient-photo-container {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-bottom: 15px;
}

.patient-photo {
    width: 120px;
    height: 120px;
    object-fit: cover;
    border: 3px solid #007bff;
    border-radius: 50%;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transition: transform 0.2s ease-in-out;
    background: white;
}

.patient-photo:hover {
    transform: scale(1.05);
}

.patient-id-section {
    text-align: center;
}

.patient-id-badge {
    display: inline-block;
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: white;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
    letter-spacing: 0.5px;
    box-shadow: 0 2px 6px rgba(0,123,255,0.3);
}

.patient-verification-status {
    margin-top: 10px;
}

/* ==========================================================================
   Information Panel Styling
   ========================================================================== */

.info-panel {
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    margin-bottom: 20px;
    overflow: hidden;
}

.panel-header {
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
    border-bottom: 1px solid #dee2e6;
    padding: 12px 15px;
    margin: 0;
    font-size: 14px;
    font-weight: 600;
    color: #495057;
}

.info-table {
    padding: 15px;
}

.info-row {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    padding: 8px 0;
    border-bottom: 1px solid #f1f3f4;
    min-height: 32px;
}

.info-row:last-child {
    border-bottom: none;
}

.info-label {
    font-weight: 600;
    color: #495057;
    min-width: 100px;
    flex-shrink: 0;
    font-size: 13px;
}

.info-value {
    color: #212529;
    font-size: 13px;
    text-align: right;
    flex: 1;
    margin-left: 10px;
    word-break: break-word;
}

.info-value.empty {
    color: #6c757d;
    font-style: italic;
}

/* ==========================================================================
   Panel Styling
   ========================================================================== */

.panel {
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 6px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    margin-bottom: 20px;
    transition: box-shadow 0.15s ease-in-out;
}

.panel:hover {
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
}

.panel-heading {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
    border-radius: 6px 6px 0 0;
    padding: 12px 15px;
}

.panel-heading h5,
.panel-heading h4 {
    margin: 0;
    font-weight: 600;
    font-size: 14px;
    color: #495057;
}

.panel-body {
    padding: 15px;
}

.panel-primary .panel-heading {
    background-color: #007bff;
    color: white;
    border-color: #0056b3;
}

.panel-info .panel-heading {
    background-color: #17a2b8;
    color: white;
    border-color: #138496;
}

.panel-success .panel-heading {
    background-color: #28a745;
    color: white;
    border-color: #1e7e34;
}

.panel-warning .panel-heading {
    background-color: #ffc107;
    color: #212529;
    border-color: #e0a800;
}

/* ==========================================================================
   Workflow Progress Styling
   ========================================================================== */

.workflow-progress-section {
    background: #f8f9fa;
    border-radius: 6px;
    padding: 15px;
    border: 1px solid #dee2e6;
}

.workflow-steps {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-top: 10px;
}

.step-item {
    margin-bottom: 5px;
}

.step-item .label {
    font-size: 10px;
    padding: 4px 8px;
    border-radius: 12px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.step-item .fa {
    font-size: 9px;
}

/* ==========================================================================
   Workflow Selection Styling
   ========================================================================== */

.workflow-selection {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 15px;
    margin-top: 15px;
}

.workflow-option {
    border: 2px solid #dee2e6;
    border-radius: 8px;
    transition: all 0.3s ease;
    cursor: pointer;
    overflow: hidden;
}

.workflow-option:hover {
    border-color: #007bff;
    box-shadow: 0 4px 12px rgba(0,123,255,0.15);
    transform: translateY(-2px);
}

.workflow-option input[type="radio"] {
    display: none;
}

.workflow-option input[type="radio"]:checked + .workflow-card {
    background: linear-gradient(135deg, #e3f2fd, #bbdefb);
    border-color: #007bff;
}

.workflow-label {
    cursor: pointer;
    margin: 0;
    display: block;
    width: 100%;
}

.workflow-card {
    padding: 20px;
    background: white;
    transition: all 0.3s ease;
}

.workflow-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.workflow-name {
    font-size: 16px;
    font-weight: 600;
    color: #495057;
    margin: 0;
}

.workflow-cost {
    font-size: 14px;
    font-weight: 700;
    color: #28a745;
    background: #e8f5e8;
    padding: 4px 8px;
    border-radius: 12px;
}

.workflow-description {
    margin-bottom: 10px;
}

.workflow-description p {
    margin: 0;
    font-size: 13px;
    color: #6c757d;
    line-height: 1.4;
}

.workflow-features {
    border-top: 1px solid #f1f3f4;
    padding-top: 10px;
}

.workflow-features small {
    font-size: 11px;
    color: #868e96;
}

/* ==========================================================================
   Button Styling
   ========================================================================== */

.btn-group .btn {
    margin-right: 2px;
    transition: all 0.15s ease-in-out;
}

.btn-xs {
    padding: 4px 8px;
    font-size: 11px;
    border-radius: 3px;
    font-weight: 500;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.btn-primary {
    background-color: #007bff;
    border-color: #007bff;
}

.btn-primary:hover {
    background-color: #0056b3;
    border-color: #004085;
}

.btn-info {
    background-color: #17a2b8;
    border-color: #17a2b8;
}

.btn-info:hover {
    background-color: #138496;
    border-color: #117a8b;
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
}

.btn-success:hover {
    background-color: #1e7e34;
    border-color: #1c7430;
}

.btn-danger {
    background-color: #dc3545;
    border-color: #dc3545;
}

.btn-danger:hover {
    background-color: #c82333;
    border-color: #bd2130;
}

/* ==========================================================================
   Statistics Cards Styling
   ========================================================================== */

.stats-section {
    margin-bottom: 25px;
}

.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
    border-radius: 6px;
    margin-bottom: 15px;
    transition: all 0.3s ease;
}

.info-box:hover {
    box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);
    transform: translateY(-2px);
}

.info-box-icon {
    border-top-left-radius: 6px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 6px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}

.info-box-icon > i {
    color: #fff;
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.info-box-text {
    display: block;
    font-size: 14px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.progress {
    background: rgba(0,0,0,0.2);
    margin: 5px -10px 5px -10px;
    height: 2px;
}

.progress-bar {
    background: rgba(255,255,255,0.4);
    float: left;
    width: 0;
    height: 100%;
    font-size: 12px;
    line-height: 20px;
    color: #fff;
    text-align: center;
    background-color: #337ab7;
    -webkit-box-shadow: inset 0 -1px 0 rgba(0,0,0,.15);
    box-shadow: inset 0 -1px 0 rgba(0,0,0,.15);
    -webkit-transition: width .6s ease;
    -o-transition: width .6s ease;
    transition: width .6s ease;
}

.progress-description {
    display: block;
    font-size: 13px;
    margin: 0;
}

.bg-blue { background-color: #3c8dbc !important; }
.bg-green { background-color: #00a65a !important; }
.bg-yellow { background-color: #f39c12 !important; }
.bg-red { background-color: #dd4b39 !important; }

/* ==========================================================================
   Alert Styling
   ========================================================================== */

.alert {
    border-radius: 6px;
    border: 1px solid transparent;
    margin-bottom: 15px;
    padding: 12px 15px;
    font-size: 14px;
}

.alert-custom {
    position: relative;
    z-index: 1050;
    margin-top: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.alert-success {
    background-color: #d4edda;
    border-color: #c3e6cb;
    color: #155724;
}

.alert-danger {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

.alert-warning {
    background-color: #fff3cd;
    border-color: #ffeaa7;
    color: #856404;
}

.alert-info {
    background-color: #d1ecf1;
    border-color: #bee5eb;
    color: #0c5460;
}

.alert-dismissible .close {
    padding: 8px 10px;
    font-size: 18px;
    color: inherit;
    opacity: 0.6;
}

.alert-dismissible .close:hover {
    opacity: 1;
}

/* ==========================================================================
   Filter Section Styling
   ========================================================================== */

.filter-section {
    margin-bottom: 20px;
}

.filter-section .panel {
    margin-bottom: 0;
}

.filter-section .form-group {
    margin-bottom: 15px;
}

.filter-section label {
    font-weight: 600;
    color: #495057;
    margin-bottom: 5px;
    font-size: 13px;
}

.form-control {
    border-radius: 4px;
    border: 1px solid #ced4da;
    box-shadow: inset 0 1px 2px rgba(0,0,0,0.05);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    font-size: 13px;
    padding: 8px 12px;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 2px rgba(0,123,255,0.2);
    outline: 0;
}

/* ==========================================================================
   DataTable Styling
   ========================================================================== */

.dataTables_wrapper {
    margin-top: 15px;
}

.dataTables_wrapper .dataTables_filter {
    text-align: right;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    border-radius: 4px;
    border: 1px solid #ced4da;
    padding: 8px 12px;
    margin-left: 8px;
    font-size: 13px;
    transition: border-color 0.15s ease-in-out;
}

.dataTables_wrapper .dataTables_filter input:focus {
    border-color: #007bff;
    outline: 0;
}

.dataTables_wrapper .dataTables_length {
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length select {
    border-radius: 4px;
    border: 1px solid #ced4da;
    padding: 6px 10px;
    font-size: 13px;
    margin-left: 5px;
    margin-right: 5px;
}

.dataTables_wrapper .dataTables_info {
    color: #6c757d;
    font-size: 13px;
    padding-top: 15px;
}

.dataTables_wrapper .dataTables_paginate {
    padding-top: 15px;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    padding: 6px 12px;
    margin-left: 2px;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    background: white;
    color: #007bff;
    text-decoration: none;
    font-size: 13px;
    transition: all 0.15s ease-in-out;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background-color: #e9ecef;
    border-color: #adb5bd;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background-color: #007bff;
    color: white;
    border-color: #007bff;
}

.dataTables_wrapper .dataTables_processing {
    position: absolute;
    top: 50%;
    left: 50%;
    width: 200px;
    margin-left: -100px;
    margin-top: -26px;
    text-align: center;
    padding: 12px 0;
    background: rgba(255,255,255,0.9);
    border: 1px solid #dee2e6;
    border-radius: 4px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

/* ==========================================================================
   Gender Icon Styling
   ========================================================================== */

.text-pink {
    color: #e91e63 !important;
}

.fa-mars {
    color: #007bff !important;
}

.fa-venus {
    color: #e91e63 !important;
}

/* ==========================================================================
   Form Styling
   ========================================================================== */

.required {
    color: #dc3545;
    font-weight: bold;
}

.form-group label {
    font-weight: 600;
    color: #495057;
    margin-bottom: 5px;
    font-size: 13px;
}

.help-text {
    background: #f8f9fa;
    border-left: 4px solid #007bff;
    padding: 12px 15px;
    margin-bottom: 20px;
    border-radius: 0 4px 4px 0;
    font-size: 14px;
    color: #495057;
}

.checkbox-group {
    margin-top: 10px;
}

.checkbox-inline {
    margin-right: 15px;
    margin-bottom: 8px;
    display: inline-flex;
    align-items: center;
    font-size: 13px;
    color: #495057;
}

.checkbox-inline input[type="checkbox"] {
    margin-right: 6px;
}

.checkbox-inline .fa {
    margin-left: 4px;
    color: #6c757d;
}

/* ==========================================================================
   Responsive Design
   ========================================================================== */

@media (max-width: 768px) {
    .modal-lg {
        width: 95%;
        margin: 10px auto;
    }
    
    .patient-photo {
        width: 80px;
        height: 80px;
    }
    
    .btn-group .btn {
        padding: 4px 6px;
        font-size: 10px;
        margin: 1px;
    }
    
    .workflow-steps {
        flex-direction: column;
        gap: 4px;
    }
    
    .table-responsive {
        font-size: 12px;
    }
    
    .filter-section {
        padding: 10px;
    }
    
    .filter-section .col-md-3 {
        margin-bottom: 10px;
    }
    
    .workflow-selection {
        grid-template-columns: 1fr;
    }
    
    .workflow-card {
        padding: 15px;
    }
    
    .modal-actions {
        position: static;
        transform: none;
        margin-top: 10px;
        text-align: center;
    }
    
    .info-row {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .info-label {
        margin-bottom: 4px;
        min-width: auto;
    }
    
    .info-value {
        text-align: left;
        margin-left: 0;
    }
    
    .panel-body {
        padding: 10px;
    }
    
    .table th,
    .table td {
        padding: 6px 4px;
        font-size: 11px;
    }
    
    .btn-xs {
        padding: 2px 4px;
        font-size: 9px;
    }
    
    .info-box-icon {
        width: 70px;
        height: 70px;
        font-size: 30px;
        line-height: 70px;
    }
    
    .info-box-content {
        margin-left: 70px;
    }
}

@media (max-width: 576px) {
    .patient-photo {
        width: 60px;
        height: 60px;
    }
    
    .modal-body {
        padding: 15px;
    }
    
    .table-responsive {
        font-size: 10px;
    }
    
    .btn-group {
        display: flex;
        flex-direction: column;
        width: 100%;
    }
    
    .btn-group .btn {
        width: 100%;
        margin: 1px 0;
        border-radius: 3px;
    }
    
    .workflow-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .info-box {
        min-height: 70px;
    }
    
    .info-box-icon {
        width: 60px;
        height: 70px;
        font-size: 24px;
        line-height: 70px;
    }
    
    .info-box-content {
        margin-left: 60px;
        padding: 5px 8px;
    }
}

/* ==========================================================================
   Print Styles
   ========================================================================== */

@media print {
    .modal-header, 
    .modal-footer, 
    .btn, 
    .box-tools,
    .filter-section,
    .stats-section,
    .dataTables_wrapper .dataTables_filter,
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
        display: none !important;
    }
    
    .modal-body {
        padding: 0 !important;
        max-height: none !important;
        overflow: visible !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .panel {
        break-inside: avoid;
        box-shadow: none;
        border: 1px solid #ccc;
    }
    
    .patient-photo {
        max-width: 80px;
        max-height: 80px;
    }
    
    .workflow-steps {
        display: none;
    }
    
    .info-row {
        padding: 4px 0;
        font-size: 12px;
    }
}

/* ==========================================================================
   Loading and Animation Effects
   ========================================================================== */

.fa-spin {
    animation: fa-spin 1s infinite linear;
}

@keyframes fa-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.fade-in {
    animation: fadeIn 0.3s ease-in-out;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255,255,255,0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

/* ==========================================================================
   Custom Scrollbar
   ========================================================================== */

.modal-body::-webkit-scrollbar {
    width: 8px;
}

.modal-body::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: #007bff;
    border-radius: 4px;
}

.modal-body::-webkit-scrollbar-thumb:hover {
    background: #0056b3;
}

/* ==========================================================================
   Debug Tools (Development Only)
   ========================================================================== */

.debug-tools {
    border-left: 1px solid #dee2e6;
    padding-left: 10px;
    margin-left: 10px;
}

.debug-tools .btn {
    font-size: 11px;
    padding: 4px 8px;
}

/* ==========================================================================
   Accessibility Improvements
   ========================================================================== */

.btn:focus,
.form-control:focus {
    outline: 2px solid #007bff;
    outline-offset: 2px;
}

.table thead th {
    position: sticky;
    top: 0;
    z-index: 10;
    background-color: #f8f9fa;
}

/* High contrast mode support */
@media (prefers-contrast: high) {
    .table th {
        background-color: #000;
        color: #fff;
    }
    
    .label,
    .badge {
        border: 2px solid currentColor;
    }
}

/* Reduced motion support */
@media (prefers-reduced-motion: reduce) {
    *,
    *::before,
    *::after {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
    
    .btn:hover {
        transform: none;/* Enhanced Patient Registration System Styles */

/* ==========================================================================
   Table Styling Improvements
   ========================================================================== */

.table th {
    background-color: #f8f9fa;
    font-weight: 600;
    border-bottom: 2px solid #dee2e6;
    text-align: center;
    vertical-align: middle;
    padding: 12px 8px;
    font-size: 13px;
    color: #495057;
}

.table td {
    vertical-align: middle;
    padding: 10px 8px;
    font-size: 13px;
    border-top: 1px solid #dee2e6;
}

.table-striped > tbody > tr:nth-of-type(odd) {
    background-color: rgba(0,0,0,.02);
}

.table-hover tbody tr:hover {
    background-color: rgba(60,141,188,0.05);
    transition: background-color 0.15s ease-in-out;
}

.table-bordered {
    border: 1px solid #dee2e6;
}

.table-bordered th,
.table-bordered td {
    border: 1px solid #dee2e6;
}

/* ==========================================================================
   Badge and Label Styling
   ========================================================================== */

.badge {
    font-size: 11px;
    font-weight: 600;
    padding: 4px 8px;
    border-radius: 3px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.badge-primary {
    background-color: #007bff;
    color: white;
}

.label {
    font-size: 11px;
    font-weight: 600;
    padding: 4px 8px;
    border-radius: 3px;
    display: inline-block;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.label-success {
    background-color: #28a745;
    color: white;
}

.label-warning {
    background-color: #ffc107;
    color: #212529;
}

.label-danger {
    background-color: #dc3545;
    color: white;
}

.label-info {
    background-color: #17a2b8;
    color: white;
}

.label-primary {
    background-color: #007bff;
    color: white;
}

.label-default {
    background-color: #6c757d;
    color: white;
}

/* ==========================================================================
   Modal Enhancements
   ========================================================================== */

.modal-lg {
    width: 90%;
    max-width: 1000px;
}

.modal-header.bg-primary {
    background-color: #007bff;
    color: white;
    border-bottom: 1px solid #0056b3;
    border-radius: 6px 6px 0 0;
}

.modal-header h4 {
    margin: 0;
    font-weight: 600;
    font-size: 18px;
}

.modal-header .close {
    color: white;
    opacity: 0.8;
    font-size: 24px;
    font-weight: 300;
}

.modal-header .close:hover {
    opacity: 1;
}

.modal-actions {
    margin-top: -5px;
}

.modal-actions .btn {
    margin-left: 5px;
    border-radius: 3px;
    padding: 4px 8px;
    font-size: 12px;
}

.modal-body {
    padding: 20px;
    max-height: 70vh;
    overflow-y: auto;
}

.modal-footer {
    border-top: 1px solid #dee2e6;
    padding: 15px 20px;
}

/* ==========================================================================
   Patient Photo Styling
   ========================================================================== */

.patient-photo {
    width: 150px;
    height: 150px;
    object-fit: cover;
    border: 3px solid #dee2e6;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    transition: transform 0.2s ease-in-out;
}

.patient-photo:hover {
    transform: scale(1.05);
}

.patient-photo-section {
    text-align: center;
    margin-bottom: 20px;
}

.patient-id-badge {
    margin-top: 10px;
}

.patient-id-badge .badge {
    font-size: 12px;
    padding: 6px 12px;
    background-color: #007bff;
    border-radius: 15px;
}

/* ==========================================================================
   Panel Styling
   ========================================================================== */

.panel {
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 6px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    margin-bottom: 20px;
    transition: box-shadow 0.15s ease-in-out;
}

.panel:hover {
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
}

.panel-heading {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
    border-radius: 6px 6px 0 0;
    padding: 12px 15px;
}

.panel-heading h5 {
    margin: 0;
    font-weight: 600;
    font-size: 14px;
    color: #495057;
}

.panel-body {
    padding: 15px;
}

.panel-primary .panel-heading {
    background-color: #007bff;
    color: white;
    border-color: #0056b3;
}

.panel-info .panel-heading {
    background-color: #17a2b8;
    color: white;
    border-color: #138496;
}

.panel-success .panel-heading {
    background-color: #28a745;
    color: white;
    border-color: #1e7e34;
}

.panel-warning .panel-heading {
    background-color: #ffc107;
    color: #212529;
    border-color: #e0a800;
}

/* ==========================================================================
   Workflow Progress Styling
   ========================================================================== */

.workflow-steps {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-top: 10px;
}

.step-item {
    margin-bottom: 5px;
}

.step-item .label {
    font-size: 10px;
    padding: 4px 8px;
    border-radius: 12px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.step-item .fa {
    font-size: 9px;
}

/* ==========================================================================
   Button Styling
   ========================================================================== */

.btn-group .btn {
    margin-right: 2px;
    transition: all 0.15s ease-in-out;
}

.btn-xs {
    padding: 4px 8px;
    font-size: 11px;
    border-radius: 3px;
    font-weight: 500;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.btn-primary {
    background-color: #007bff;
    border-color: #007bff;
}

.btn-primary:hover {
    background-color: #0056b3;
    border-color: #004085;
}

.btn-info {
    background-color: #17a2b8;
    border-color: #17a2b8;
}

.btn-info:hover {
    background-color: #138496;
    border-color: #117a8b;
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
}

.btn-success:hover {
    background-color: #1e7e34;
    border-color: #1c7430;
}

.btn-danger {
    background-color: #dc3545;
    border-color: #dc3545;
}

.btn-danger:hover {
    background-color: #c82333;
    border-color: #bd2130;
}

/* ==========================================================================
   Alert Styling
   ========================================================================== */

.alert {
    border-radius: 6px;
    border: 1px solid transparent;
    margin-bottom: 15px;
    padding: 12px 15px;
    font-size: 14px;
}

.alert-custom {
    position: relative;
    z-index: 1050;
    margin-top: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.alert-success {
    background-color: #d4edda;
    border-color: #c3e6cb;
    color: #155724;
}

.alert-danger {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

.alert-warning {
    background-color: #fff3cd;
    border-color: #ffeaa7;
    color: #856404;
}

.alert-info {
    background-color: #d1ecf1;
    border-color: #bee5eb;
    color: #0c5460;
}

.alert-dismissible .close {
    padding: 8px 10px;
    font-size: 18px;
    color: inherit;
    opacity: 0.6;
}

.alert-dismissible .close:hover {
    opacity: 1;
}

/* ==========================================================================
   Filter Section Styling
   ========================================================================== */

.filter-section {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 6px;
    border: 1px solid #dee2e6;
    margin-bottom: 20px;
}

.filter-section .form-group {
    margin-bottom: 0;
}

.filter-section label {
    font-weight: 600;
    color: #495057;
    margin-bottom: 5px;
    font-size: 13px;
}

.form-control {
    border-radius: 4px;
    border: 1px solid #ced4da;
    box-shadow: inset 0 1px 2px rgba(0,0,0,0.05);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    font-size: 13px;
    padding: 8px 12px;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 2px rgba(0,123,255,0.2);
    outline: 0;
}

/* ==========================================================================
   DataTable Styling
   ========================================================================== */

.dataTables_wrapper {
    margin-top: 15px;
}

.dataTables_wrapper .dataTables_filter {
    text-align: right;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    border-radius: 4px;
    border: 1px solid #ced4da;
    padding: 8px 12px;
    margin-left: 8px;
    font-size: 13px;
    transition: border-color 0.15s ease-in-out;
}

.dataTables_wrapper .dataTables_filter input:focus {
    border-color: #007bff;
    outline: 0;
}

.dataTables_wrapper .dataTables_length {
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length select {
    border-radius: 4px;
    border: 1px solid #ced4da;
    padding: 6px 10px;
    font-size: 13px;
    margin-left: 5px;
    margin-right: 5px;
}

.dataTables_wrapper .dataTables_info {
    color: #6c757d;
    font-size: 13px;
    padding-top: 15px;
}

.dataTables_wrapper .dataTables_paginate {
    padding-top: 15px;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    padding: 6px 12px;
    margin-left: 2px;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    background: white;
    color: #007bff;
    text-decoration: none;
    font-size: 13px;
    transition: all 0.15s ease-in-out;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background-color: #e9ecef;
    border-color: #adb5bd;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background-color: #007bff;
    color: white;
    border-color: #007bff;
}

.dataTables_wrapper .dataTables_processing {
    position: absolute;
    top: 50%;
    left: 50%;
    width: 200px;
    margin-left: -100px;
    margin-top: -26px;
    text-align: center;
    padding: 12px 0;
    background: rgba(255,255,255,0.9);
    border: 1px solid #dee2e6;
    border-radius: 4px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

/* ==========================================================================
   Gender Icon Styling
   ========================================================================== */

.text-pink {
    color: #e91e63 !important;
}

.fa-mars {
    color: #007bff !important;
}

.fa-venus {
    color: #e91e63 !important;
}

/* ==========================================================================
   Workflow Selection Styling
   ========================================================================== */

.workflow-radio {
    transition: all 0.3s ease;
    cursor: pointer;
}

.workflow-radio:hover {
    background-color: #f8f9fa;
    border-color: #007bff !important;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.workflow-radio input[type="radio"]:checked + label strong {
    color: #007bff;
}

.workflow-cost {
    float: right;
    font-weight: bold;
    color: #28a745;
}

.workflow-fields {
    margin-top: 20px;
}

/* ==========================================================================
   Responsive Design
   ========================================================================== */

@media (max-width: 768px) {
    .modal-lg {
        width: 95%;
        margin: 10px auto;
    }
    
    .patient-photo {
        width: 100px;
        height: 100px;
    }
    
    .btn-group .btn {
        padding: 4px 6px;
        font-size: 10px;
        margin: 1px;
    }
    
    .workflow-steps {
        flex-direction: column;
        gap: 4px;
    }
    
    .table-responsive {
        font-size: 12px;
    }
    
    .filter-section {
        padding: 10px;
    }
    
    .filter-section .col-md-3 {
        margin-bottom: 10px;
    }
    
    .workflow-radio {
        margin-bottom: 10px;
        padding: 10px;
    }
    
    .workflow-cost {
        float: none;
        display: block;
        margin-top: 5px;
    }
    
    .modal-actions {
        margin-top: 10px;
        text-align: center;
    }
    
    .modal-actions .btn {
        margin: 2px;
        display: inline-block;
    }
    
    .panel-body {
        padding: 10px;
    }
    
    .table th,
    .table td {
        padding: 6px 4px;
        font-size: 11px;
    }
    
    .btn-xs {
        padding: 2px 4px;
        font-size: 9px;
    }
}

@media (max-width: 576px) {
    .patient-photo {
        width: 80px;
        height: 80px;
    }
    
    .modal-body {
        padding: 15px;
    }
    
    .filter-section {
        padding: 8px;
    }
    
    .table-responsive {
        font-size: 10px;
    }
    
    .btn-group {
        display: flex;
        flex-direction: column;
        width: 100%;
    }
    
    .btn-group .btn {
        width: 100%;
        margin: 1px 0;
        border-radius: 3px;
    }
}

/* ==========================================================================
   Print Styles
   ========================================================================== */

@media print {
    .modal-header, 
    .modal-footer, 
    .btn, 
    .box-tools,
    .filter-section,
    .dataTables_wrapper .dataTables_filter,
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
        display: none !important;
    }
    
    .modal-body {
        padding: 0 !important;
        max-height: none !important;
        overflow: visible !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .panel {
        break-inside: avoid;
        box-shadow: none;
        border: 1px solid #ccc;
    }
    
    .patient-photo {
        max-width: 100px;
        max-height: 100px;
    }
    
    .workflow-steps {
        display: none;
    }
}

/* ==========================================================================
   Loading and Animation Effects
   ========================================================================== */

.fa-spin {
    animation: fa-spin 1s infinite linear;
}

@keyframes fa-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.fade-in {
    animation: fadeIn 0.3s ease-in-out;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255,255,255,0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

/* ==========================================================================
   Custom Scrollbar
   ========================================================================== */

.modal-body::-webkit-scrollbar {
    width: 8px;
}

.modal-body::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: #007bff;
    border-radius: 4px;
}

.modal-body::-webkit-scrollbar-thumb:hover {
    background: #0056b3;
}

/* ==========================================================================
   Debug Tools (Development Only)
   ========================================================================== */

.debug-tools {
    border-left: 1px solid #dee2e6;
    padding-left: 10px;
    margin-left: 10px;
}

.debug-tools .btn {
    font-size: 11px;
    padding: 4px 8px;
}

/* ==========================================================================
   Accessibility Improvements
   ========================================================================== */

.btn:focus,
.form-control:focus {
    outline: 2px solid #007bff;
    outline-offset: 2px;
}

.table thead th {
    position: sticky;
    top: 0;
    z-index: 10;
    background-color: #f8f9fa;
}

/* High contrast mode support */
@media (prefers-contrast: high) {
    .table th {
        background-color: #000;
        color: #fff;
    }
    
    .label,
    .badge {
        border: 2px solid currentColor;
    }
}

/* Reduced motion support */
@media (prefers-reduced-motion: reduce) {
    *,
    *::before,
    *::after {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
    
    .btn:hover {
        transform: none;
    }
    
    .patient-photo:hover {
        transform: none;
    }
    
    .info-box:hover {
        transform: none;
    }
    
    .workflow-option:hover {
        transform: none;
    }
}

/* ==========================================================================
   Biometric Section Styling
   ========================================================================== */

.biometric-info {
    background: #f8f9fa;
    border-radius: 6px;
    padding: 15px;
    border: 1px solid #dee2e6;
}

.verification-info {
    background: #e8f5e8;
    border-radius: 6px;
    padding: 15px;
    border: 1px solid #c3e6cb;
}

#fingerprint_display {
    margin: 15px 0;
    padding: 20px;
    background: white;
    border: 2px dashed #dee2e6;
    border-radius: 8px;
    min-height: 120px;
    display: flex;
    align-items: center;
    justify-content: center;
}

#fingerprint_display img {
    max-width: 100px;
    max-height: 100px;
    border: 1px solid #28a745;
    border-radius: 4px;
    background: white;
    padding: 5px;
}

/* ==========================================================================
   Visit History Styling
   ========================================================================== */

#visit_report {
    max-height: 300px;
    overflow-y: auto;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    background: white;
}

#visit_report .table {
    margin-bottom: 0;
}

#visit_report .table th {
    background: #f8f9fa;
    font-size: 12px;
    padding: 8px;
    border-bottom: 2px solid #dee2e6;
}

#visit_report .table td {
    font-size: 12px;
    padding: 8px;
    vertical-align: middle;
}

#visit_count {
    background: #17a2b8;
    color: white;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 600;
}

/* ==========================================================================
   Empty States
   ========================================================================== */

.empty-state {
    text-align: center;
    padding: 40px 20px;
    color: #6c757d;
}

.empty-state .fa {
    font-size: 48px;
    margin-bottom: 15px;
    opacity: 0.5;
}

.empty-state h4 {
    color: #495057;
    margin-bottom: 10px;
}

.empty-state p {
    margin-bottom: 20px;
    max-width: 400px;
    margin-left: auto;
    margin-right: auto;
}

/* ==========================================================================
   Status Indicators
   ========================================================================== */

.status-dot {
    display: inline-block;
    width: 8px;
    height: 8px;
    border-radius: 50%;
    margin-right: 6px;
}

.status-dot.active {
    background-color: #28a745;
}

.status-dot.inactive {
    background-color: #dc3545;
}

.status-dot.pending {
    background-color: #ffc107;
}

.status-dot.processing {
    background-color: #17a2b8;
    animation: pulse 1.5s infinite;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

/* ==========================================================================
   Tooltip Enhancements
   ========================================================================== */

.tooltip {
    font-size: 12px;
}

.tooltip-inner {
    background-color: #212529;
    color: white;
    padding: 6px 10px;
    border-radius: 4px;
    max-width: 200px;
}

.tooltip.top .tooltip-arrow {
    border-top-color: #212529;
}

.tooltip.bottom .tooltip-arrow {
    border-bottom-color: #212529;
}

.tooltip.left .tooltip-arrow {
    border-left-color: #212529;
}

.tooltip.right .tooltip-arrow {
    border-right-color: #212529;
}

/* ==========================================================================
   Loading States
   ========================================================================== */

.btn.loading {
    position: relative;
    color: transparent !important;
}

.btn.loading:after {
    content: "";
    position: absolute;
    width: 16px;
    height: 16px;
    top: 50%;
    left: 50%;
    margin-left: -8px;
    margin-top: -8px;
    border: 2px solid transparent;
    border-top-color: currentColor;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.table-loading {
    position: relative;
    pointer-events: none;
    opacity: 0.6;
}

.table-loading:after {
    content: "";
    position: absolute;
    top: 50%;
    left: 50%;
    width: 32px;
    height: 32px;
    margin: -16px 0 0 -16px;
    border: 3px solid #f3f3f3;
    border-top: 3px solid #007bff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

/* ==========================================================================
   Error States
   ========================================================================== */

.error-state {
    text-align: center;
    padding: 40px 20px;
    background: #fff5f5;
    border: 1px solid #fed7d7;
    border-radius: 6px;
    margin: 20px 0;
}

.error-state .fa {
    font-size: 48px;
    color: #e53e3e;
    margin-bottom: 15px;
}

.error-state h4 {
    color: #c53030;
    margin-bottom: 10px;
}

.error-state p {
    color: #744210;
    margin-bottom: 20px;
}

/* ==========================================================================
   Success States
   ========================================================================== */

.success-state {
    text-align: center;
    padding: 40px 20px;
    background: #f0fff4;
    border: 1px solid #9ae6b4;
    border-radius: 6px;
    margin: 20px 0;
}

.success-state .fa {
    font-size: 48px;
    color: #38a169;
    margin-bottom: 15px;
}

.success-state h4 {
    color: #2f855a;
    margin-bottom: 10px;
}

.success-state p {
    color: #276749;
    margin-bottom: 20px;
}

/* ==========================================================================
   Modal Specific Fixes for Image Overlap
   ========================================================================== */

#modal-content .row {
    margin-left: 0;
    margin-right: 0;
}

#modal-content .col-md-4,
#modal-content .col-md-8,
#modal-content .col-md-6 {
    padding-left: 10px;
    padding-right: 10px;
}

.patient-photo-card {
    min-height: 200px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    margin-bottom: 20px;
}

.patient-photo-container {
    flex-shrink: 0;
}

/* Ensure info panels don't overlap */
.info-panel {
    position: relative;
    z-index: 1;
    clear: both;
    width: 100%;
    box-sizing: border-box;
}

/* Fix for mobile devices */
@media (max-width: 767px) {
    #modal-content .col-md-4,
    #modal-content .col-md-8 {
        width: 100%;
        float: none;
        margin-bottom: 15px;
    }
    
    .patient-photo-card {
        min-height: auto;
        padding: 15px;
    }
    
    .patient-photo {
        width: 80px;
        height: 80px;
    }
    
    .info-panel {
        margin-bottom: 15px;
    }
    
    .panel-body {
        padding: 10px;
    }
}

/* ==========================================================================
   Form Validation Styling
   ========================================================================== */

.form-group.has-error .form-control {
    border-color: #dc3545;
    box-shadow: 0 0 0 2px rgba(220, 53, 69, 0.2);
}

.form-group.has-success .form-control {
    border-color: #28a745;
    box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.2);
}

.form-group .error-message {
    color: #dc3545;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

.form-group .success-message {
    color: #28a745;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

/* ==========================================================================
   Advanced Search Styling
   ========================================================================== */

.search-controls {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 20px;
}

.search-controls .form-group {
    margin-bottom: 10px;
}

.search-controls .btn-group {
    margin-top: 5px;
}

.quick-search {
    position: relative;
}

.quick-search .form-control {
    padding-right: 40px;
}

.quick-search .search-icon {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #6c757d;
    pointer-events: none;
}

/* ==========================================================================
   Progress Indicators
   ========================================================================== */

.progress-stepper {
    display: flex;
    align-items: center;
    margin: 20px 0;
}

.progress-step {
    flex: 1;
    text-align: center;
    position: relative;
}

.progress-step:not(:last-child):after {
    content: '';
    position: absolute;
    top: 50%;
    right: -50%;
    width: 100%;
    height: 2px;
    background: #dee2e6;
    z-index: 1;
}

.progress-step.completed:not(:last-child):after {
    background: #28a745;
}

.progress-step-circle {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: #dee2e6;
    color: #6c757d;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    font-weight: 600;
    position: relative;
    z-index: 2;
}

.progress-step.completed .progress-step-circle {
    background: #28a745;
    color: white;
}

.progress-step.active .progress-step-circle {
    background: #007bff;
    color: white;
}

.progress-step-label {
    display: block;
    margin-top: 8px;
    font-size: 12px;
    color: #6c757d;
    font-weight: 500;
}

.progress-step.completed .progress-step-label,
.progress-step.active .progress-step-label {
    color: #495057;
    font-weight: 600;
}

/* ==========================================================================
   Custom Buttons
   ========================================================================== */

.btn-outline-primary {
    color: #007bff;
    border-color: #007bff;
    background-color: transparent;
}

.btn-outline-primary:hover {
    color: #fff;
    background-color: #007bff;
    border-color: #007bff;
}

.btn-gradient-primary {
    background: linear-gradient(135deg, #007bff, #0056b3);
    border: none;
    color: white;
}

.btn-gradient-primary:hover {
    background: linear-gradient(135deg, #0056b3, #004085);
    color: white;
}

.btn-gradient-success {
    background: linear-gradient(135deg, #28a745, #1e7e34);
    border: none;
    color: white;
}

.btn-gradient-success:hover {
    background: linear-gradient(135deg, #1e7e34, #155724);
    color: white;
}

/* ==========================================================================
   Utilities
   ========================================================================== */

.text-truncate {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.cursor-pointer {
    cursor: pointer;
}

.cursor-not-allowed {
    cursor: not-allowed;
}

.user-select-none {
    user-select: none;
}

.border-radius-lg {
    border-radius: 8px;
}

.border-radius-xl {
    border-radius: 12px;
}

.shadow-sm {
    box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
}

.shadow-md {
    box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);
}

.shadow-lg {
    box-shadow: 0 10px 20px rgba(0,0,0,0.19), 0 6px 6px rgba(0,0,0,0.23);
}

/* ==========================================================================
   Print Optimization
   ========================================================================== */

@page {
    margin: 1cm;
    size: A4;
}

@media print {
    body {
        font-size: 12pt;
        line-height: 1.4;
        color: #000;
    }
    
    .patient-photo {
        width: 3cm !important;
        height: 3cm !important;
        border: 1pt solid #000;
    }
    
    .panel {
        border: 1pt solid #000;
        break-inside: avoid;
        margin-bottom: 0.5cm;
    }
    
    .panel-heading {
        background: #f0f0f0 !important;
        color: #000 !important;
        border-bottom: 1pt solid #000;
    }
    
    .info-row {
        border-bottom: 0.5pt solid #ccc;
        padding: 0.2cm 0;
    }
    
    .info-label {
        font-weight: bold;
    }
    
    .table th,
    .table td {
        border: 1pt solid #000 !important;
        padding: 0.2cm;
    }
    
    .table th {
        background: #f0f0f0 !important;
        color: #000 !important;
    }
    
    .label,
    .badge {
        border: 1pt solid #000;
        background: transparent !important;
        color: #000 !important;
        padding: 0.1cm 0.2cm;
    }
    
    /* Hide non-essential elements */
    .btn,
    .modal-footer,
    .debug-tools,
    .box-tools,
    .workflow-progress-section,
    .progress,
    .fa-spin {
        display: none !important;
    }
}

/* ==========================================================================
   Dark Mode Support (Future Enhancement)
   ========================================================================== */

@media (prefers-color-scheme: dark) {
    /* Dark mode styles would go here if needed */
    /* Currently commented out to maintain compatibility */
    /*
    .modal-content {
        background-color: #2d3748;
        color: #e2e8f0;
    }
    
    .panel {
        background-color: #4a5568;
        border-color: #2d3748;
    }
    
    .form-control {
        background-color: #4a5568;
        border-color: #2d3748;
        color: #e2e8f0;
    }
    */
}
</style>