<?php
// File: application/views/admin/patient/print_barcode.php
// CodeIgniter Barcode Print View Template
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('barcode'); ?> - <?php echo $patient->patient_name; ?></title>
    
    <style type="text/css">
        /* Print-specific styles */
        @media print {
            body {
                margin: 0;
                padding: 15px;
                font-family: Arial, sans-serif;
                font-size: 12px;
                line-height: 1.4;
                color: #000;
                background: white;
            }
            
            .no-print {
                display: none !important;
            }
            
            .page-break {
                page-break-after: always;
            }
            
            .barcode-container {
                width: 100%;
                max-width: none;
                background: white;
                padding: 0;
                margin: 0;
                box-shadow: none;
                border: none;
            }
        }
        
        /* Screen styles */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        
        .barcode-container {
            max-width: 400px;
            margin: 0 auto;
            background-color: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border: 1px solid #ddd;
        }
        
        .hospital-header {
            text-align: center;
            margin-bottom: 25px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .hospital-name {
            font-size: 18px;
            font-weight: bold;
            margin: 0 0 5px 0;
            color: #333;
        }
        
        .barcode-title {
            font-size: 14px;
            color: #666;
            margin: 0;
        }
        
        .patient-info {
            margin-bottom: 20px;
        }
        
        .patient-info table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }
        
        .patient-info td {
            padding: 6px 8px;
            border-bottom: 1px solid #eee;
            vertical-align: top;
        }
        
        .patient-info td:first-child {
            font-weight: bold;
            width: 35%;
            color: #555;
        }
        
        .barcode-section {
            text-align: center;
            margin: 25px 0;
            padding: 15px;
            border: 2px solid #333;
            background-color: #fafafa;
        }
        
        .barcode-image {
            max-width: 100%;
            height: auto;
            margin-bottom: 10px;
        }
        
        .barcode-number {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            letter-spacing: 2px;
        }
        
        .instructions {
            text-align: center;
            font-size: 11px;
            color: #666;
            margin-top: 15px;
            font-style: italic;
        }
        
        .footer-info {
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            font-size: 10px;
            color: #888;
            text-align: center;
        }
        
        .print-button {
            text-align: center;
            margin: 20px 0;
        }
        
        .btn-print {
            background-color: #337ab7;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        
        .btn-print:hover {
            background-color: #286090;
        }
        
        .emergency-contact {
            background-color: #f9f9f9;
            padding: 10px;
            border-radius: 4px;
            margin: 10px 0;
            border-left: 4px solid #d9534f;
        }
        
        .qr-section {
            float: right;
            width: 80px;
            text-align: center;
            margin-left: 15px;
        }
        
        .clearfix {
            clear: both;
        }
    </style>
</head>
<body>
    <div class="barcode-container">
        <!-- Hospital Header -->
        <div class="hospital-header">
            <h1 class="hospital-name"><?php echo !empty($hospital_name) ? $hospital_name : $this->config->item('name'); ?></h1>
            <p class="barcode-title"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('barcode'); ?> <?php echo $this->lang->line('label'); ?></p>
        </div>
        
        <!-- Patient Information -->
        <div class="patient-info">
            <table>
                <tr>
                    <td><?php echo $this->lang->line('patient_name'); ?>:</td>
                    <td><?php echo !empty($patient->patient_name) ? $patient->patient_name : 'N/A'; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('patient_id'); ?>:</td>
                    <td><strong><?php echo $patient->id; ?></strong></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('phone'); ?>:</td>
                    <td><?php echo !empty($patient->mobileno) ? $patient->mobileno : 'N/A'; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('age'); ?>:</td>
                    <td>
                        <?php 
                        if (!empty($patient->age)) {
                            echo $patient->age . ' ' . $this->lang->line('years');
                        } else {
                            echo 'N/A';
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('gender'); ?>:</td>
                    <td><?php echo !empty($patient->gender) ? ucfirst($patient->gender) : 'N/A'; ?></td>
                </tr>
                <?php if (!empty($patient->blood_group)) { ?>
                <tr>
                    <td><?php echo $this->lang->line('blood_group'); ?>:</td>
                    <td><?php echo $patient->blood_group; ?></td>
                </tr>
                <?php } ?>
                <?php if (!empty($patient->known_allergies) && $patient->known_allergies != 'Unknown') { ?>
                <tr>
                    <td><?php echo $this->lang->line('allergies'); ?>:</td>
                    <td style="color: #d9534f; font-weight: bold;"><?php echo $patient->known_allergies; ?></td>
                </tr>
                <?php } ?>
            </table>
        </div>
        
        <!-- Emergency Contact Section (if available) -->
        <?php if (!empty($patient->guardian_name) || !empty($patient->guardian_phone)) { ?>
        <div class="emergency-contact">
            <strong><?php echo $this->lang->line('emergency_contact'); ?>:</strong><br>
            <?php if (!empty($patient->guardian_name)) { ?>
                <?php echo $this->lang->line('name'); ?>: <?php echo $patient->guardian_name; ?><br>
            <?php } ?>
            <?php if (!empty($patient->guardian_phone)) { ?>
                <?php echo $this->lang->line('phone'); ?>: <?php echo $patient->guardian_phone; ?>
            <?php } ?>
        </div>
        <?php } ?>
        
        <!-- Barcode Section -->
        <div class="barcode-section">
            <?php if (!empty($barcode_image)) { ?>
                <img src="<?php echo $barcode_image; ?>" alt="Patient Barcode" class="barcode-image">
                <div class="barcode-number"><?php echo $patient->id; ?></div>
            <?php } else { ?>
                <div style="padding: 40px; border: 2px dashed #ccc; color: #999;">
                    <?php echo $this->lang->line('barcode_not_available'); ?>
                </div>
            <?php } ?>
        </div>
        
        <!-- Instructions -->
        <div class="instructions">
            <p><?php echo $this->lang->line('scan_barcode_instructions') ?: 'Scan this barcode for quick patient identification and record access'; ?></p>
        </div>
        
        <!-- Footer Information -->
        <div class="footer-info">
            <p>
                <strong><?php echo $this->lang->line('generated_on'); ?>:</strong> <?php echo $print_date; ?><br>
                <strong><?php echo $this->lang->line('printed_by'); ?>:</strong> <?php echo $this->session->userdata('username') ?: 'System'; ?>
            </p>
            <?php if (!empty($this->config->item('address'))) { ?>
            <p><?php echo $this->config->item('address'); ?></p>
            <?php } ?>
            <?php if (!empty($this->config->item('phone'))) { ?>
            <p><?php echo $this->lang->line('phone'); ?>: <?php echo $this->config->item('phone'); ?></p>
            <?php } ?>
        </div>
        
        <!-- Print Button (only visible on screen) -->
        <div class="print-button no-print">
            <button class="btn-print" onclick="window.print();">
                <i class="fa fa-print"></i> <?php echo $this->lang->line('print'); ?>
            </button>
            <button class="btn-print" onclick="window.close();" style="background-color: #666; margin-left: 10px;">
                <i class="fa fa-times"></i> <?php echo $this->lang->line('close'); ?>
            </button>
        </div>
    </div>
    
    <script type="text/javascript">
        // Auto-print when page loads (optional)
        window.onload = function() {
            // Uncomment the line below if you want auto-print
            // setTimeout(function() { window.print(); }, 1000);
        };
        
        // Print function
        function printBarcode() {
            window.print();
        }
        
        // Close function
        function closeWindow() {
            window.close();
        }
        
        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            // Ctrl+P for print
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
            // Escape to close
            if (e.key === 'Escape') {
                window.close();
            }
        });
    </script>
</body>
</html>