<?php
$genderList = $this->customlib->getGender_Patient();
$marital_status = $this->config->item('marital_status');
?>

<!-- Include SecuGen WebAPI scripts -->
<script src="<?php echo base_url('WebAPI-JavaScript/secugen.js'); ?>"></script>

<div class="modal fade" id="myModalpa" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('add_patient'); ?></h4>
            </div>
            <form id="formaddpa" accept-charset="utf-8" action="" enctype="multipart/form-data" method="post">
                <div class="scroll-area">
                    <div class="modal-body pt0 pb0">
                        <div class="ptt10">
                            <div class="row row-eq">
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="row">
                                        <!-- Patient Name -->
                                        <div class="col-lg-6 col-md-6 col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('name'); ?></label><small class="req"> *</small>
                                                <input id="name" name="name" placeholder="" type="text" class="form-control" value="<?php echo set_value('name'); ?>" />
                                                <span class="text-danger"><?php echo form_error('name'); ?></span>
                                            </div>
                                        </div>

                                        <!-- Guardian Name -->
                                        <div class="col-lg-6 col-md-6 col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('guardian_name') ?></label>
                                                <input type="text" name="guardian_name" placeholder="" value="" class="form-control">
                                            </div>
                                        </div>

                                        <!-- Gender, DOB, and Age -->
                                        <div class="col-md-6 col-sm-12">
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label><?php echo $this->lang->line('gender'); ?></label>
                                                        <select class="form-control" name="gender" id="addformgender">
                                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                            <?php foreach ($genderList as $key => $value) { ?>
                                                                <option value="<?php echo $key; ?>" <?php if (set_value('gender') == $key) echo "selected"; ?>><?php echo $value; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="dob"><?php echo $this->lang->line('date_of_birth'); ?></label>
                                                        <input type="text" name="dob" id="birth_date" placeholder="" class="form-control date patient_dob" value="<?php echo set_value('dob'); ?>" />
                                                    </div>
                                                </div>
                                                <div class="col-sm-5" id="calculate">
                                                    <div class="form-group">
                                                        <label><?php echo $this->lang->line('age') . ' (' . $this->lang->line('yy_mm_dd') . ')'; ?></label><small class="req"> *</small>
                                                        <div style="clear: both;overflow: hidden;">
                                                            <input type="text" placeholder="<?php echo $this->lang->line('year'); ?>" name="age[year]" id="age_year" value="" class="form-control patient_age_year" style="width: 30%; float: left;">
                                                            <input type="text" id="age_month" placeholder="<?php echo $this->lang->line('month'); ?>" name="age[month]" value="" class="form-control patient_age_month" style="width: 36%;float: left; margin-left: 4px;">
                                                            <input type="text" id="age_day" placeholder="<?php echo $this->lang->line('day'); ?>" name="age[day]" value="" class="form-control patient_age_day" style="width: 26%;float: left; margin-left: 4px;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Blood Group, Marital Status, Photo -->
                                        <div class="col-md-6 col-sm-12">
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label><?php echo $this->lang->line('blood_group'); ?></label>
                                                        <select name="blood_group" class="form-control">
                                                            <option value=""><?php echo $this->lang->line('select') ?></option>
                                                            <?php foreach ($bloodgroup as $key => $value) { ?>
                                                                <option value="<?php echo $key; ?>" <?php if (set_value('blood_group') == $key) echo "selected"; ?>><?php echo $value; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="pwd"><?php echo $this->lang->line('marital_status'); ?></label>
                                                        <select name="marital_status" class="form-control">
                                                            <option value=""><?php echo $this->lang->line('select') ?></option>
                                                            <?php foreach ($marital_status as $mkey => $mvalue) { ?>
                                                                <option value="<?php echo $mvalue; ?>" <?php if (set_value('marital_status') == $mkey) echo "selected"; ?>><?php echo $mvalue; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label for="exampleInputFile"><?php echo $this->lang->line('patient_photo'); ?></label>
                                                        <div class="photo-upload-container" style="margin-bottom: 10px;">
                                                            <input class="filestyle form-control" type='file' name='file' id="file" size='20' data-height="26" style="margin-bottom: 8px;" />
                                                            <div class="btn-group" role="group" style="width: 100%;">
                                                                <button type="button" id="capturePhotoBtn" class="btn btn-default" style="width: 50%;">
                                                                    <i class="fa fa-camera"></i> <?php echo $this->lang->line('capture_photo'); ?>
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <span class="text-danger"><?php echo form_error('file'); ?></span>
                                                        <div id="camera_container" style="display:none; margin-top:10px; text-align: center;">
                                                            <video id="camera_stream" width="240" height="180" autoplay style="border: 1px solid #ddd; border-radius: 4px;"></video>
                                                            <div style="margin-top: 8px;">
                                                                <button type="button" id="takePhotoBtn" class="btn btn-primary">
                                                                    <i class="fa fa-camera"></i> <?php echo $this->lang->line('take_photo'); ?>
                                                                </button>
                                                                <button type="button" id="cancelPhotoBtn" class="btn btn-default">
                                                                    <i class="fa fa-times"></i> Cancel
                                                                </button>
                                                            </div>
                                                            <canvas id="photo_canvas" width="240" height="180" style="display:none;"></canvas>
                                                            <img id="captured_image" src="#" alt="Captured Photo" style="display:none; margin-top:10px; max-width:240px; border: 1px solid #ddd; border-radius: 4px;"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Contact Information -->
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('phone'); ?></label>
                                                <input id="number" autocomplete="off" name="mobileno" type="text" placeholder="" class="form-control" value="<?php echo set_value('mobileno'); ?>" />
                                                <span class="text-danger"><?php echo form_error('mobileno'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('email'); ?></label>
                                                <input type="text" placeholder="" id="addformemail" value="<?php echo set_value('email'); ?>" name="email" class="form-control">
                                                <span class="text-danger"><?php echo form_error('email'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="address"><?php echo $this->lang->line('address'); ?></label>
                                                <input name="address" placeholder="" class="form-control" value="<?php echo set_value('address'); ?>" />
                                            </div>
                                        </div>

                                        <!-- National ID -->
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label>National Identification Number/Passport Number</label>
                                                <input name="identification_number" placeholder="" class="form-control" value="<?php echo set_value('identification_number'); ?>" />
                                            </div>
                                        </div>

                                        <!-- Fingerprint Section with Advanced Troubleshooting -->
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('fingerprint'); ?></label>
                                                <div class="fingerprint-container">
                                                    <!-- Troubleshooting Panel -->
                                                    <div class="panel panel-info" style="margin-bottom: 10px;">
                                                        <div class="panel-heading" style="padding: 8px 15px;">
                                                            <h6 class="panel-title">
                                                                <a data-toggle="collapse" href="#troubleshootingPanel">
                                                                    <i class="fa fa-wrench"></i> SecuGen Service Diagnostics
                                                                </a>
                                                            </h6>
                                                        </div>
                                                        <div id="troubleshootingPanel" class="panel-collapse collapse">
                                                            <div class="panel-body" style="padding: 10px;">
                                                                <div class="btn-group" role="group" style="margin-bottom: 8px;">
                                                                    <button type="button" id="testConnection" class="btn btn-info btn-xs">Test Connection</button>
                                                                    <button type="button" id="testHttps" class="btn btn-warning btn-xs">Test HTTPS</button>
                                                                    <button type="button" id="testHttp" class="btn btn-secondary btn-xs">Test HTTP</button>
                                                                </div>
                                                                <div>
                                                                    <button type="button" id="openSecuGenDemo" class="btn btn-success btn-xs">Open SecuGen Demo</button>
                                                                </div>
                                                                <div id="diagnosticResults" style="margin-top: 10px; font-size: 11px;"></div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Service Status Indicator -->
                                                    <div id="secugen_service_status" class="mb-2"></div>
                                                    
                                                    <!-- Fingerprint Image Display -->
                                                    <div class="text-center mb-2">
                                                        <img id="fingerprintImage" src="./Images/PlaceFinger.bmp" alt="Fingerprint Image" 
                                                             style="height: 150px; width: 120px; border: 1px solid #ddd; border-radius: 4px; display: block; margin: 0 auto;">
                                                    </div>
                                                    
                                                    <!-- Scan Buttons - Harmonized Sizing -->
                                                    <div class="text-center mb-2">
                                                        <div class="btn-group" role="group" style="margin-bottom: 8px;">
                                                            <button type="button" id="scanFingerprint" class="btn btn-primary" disabled>
                                                                <i class="fa fa-fingerprint"></i> <?php echo $this->lang->line('scan_fingerprint'); ?>
                                                            </button>
                                                            <button type="button" id="manualCapture" class="btn btn-info">
                                                                <i class="fa fa-hand-pointer-o"></i> Manual Capture
                                                            </button>
                                                        </div>
                                                        <div>
                                                            <button type="button" id="clearFingerprint" class="btn btn-warning" style="display: none;">
                                                                <i class="fa fa-trash"></i> Clear Fingerprint
                                                            </button>
                                                        </div>
                                                    </div>
                                                    
                                                    <!-- Hidden Template Storage -->
                                                    <input type="hidden" name="fingerprint_template" id="fingerprint_template" value="">
                                                    <input type="hidden" name="fingerprint_image" id="fingerprint_image" value="">
                                                    
                                                    <!-- Status Messages -->
                                                    <div id="fingerprintStatus"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div>
                                            <?php echo display_custom_fields('patient'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="pull-right">
                        <button type="submit" id="formaddpabtn" data-loading-text="<?php echo $this->lang->line('processing'); ?>" class="btn btn-info pull-right">
                            <i class="fa fa-check-circle"></i> <?php echo $this->lang->line('save'); ?>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    // =============================================
    // SECUGEN ADVANCED TROUBLESHOOTING INTEGRATION
    // =============================================
    
    // Enhanced SecuGen Configuration
    var secugenConfig = {
        baseUrl: 'https://localhost:8443',
        httpUrl: 'http://localhost:8443',
        endpoints: {
            capture: '/SGIFPCapture',
            getInfo: '/SGIFPGetInfo',
            getVersion: '/SGIFPGetVersion'
        },
        serviceActive: false,
        quality: 50,
        timeout: 20000,
        lastError: null
    };

    // Diagnostic functions
    function logDiagnostic(message, type = 'info') {
        const timestamp = new Date().toLocaleTimeString();
        const colorClass = type === 'error' ? 'text-danger' : type === 'success' ? 'text-success' : 'text-info';
        $("#diagnosticResults").append(
            `<div class="${colorClass}">[${timestamp}] ${message}</div>`
        );
        console.log(`[SecuGen] ${message}`);
        
        // Keep only last 10 messages
        const diagnosticLines = $("#diagnosticResults div");
        if (diagnosticLines.length > 10) {
            diagnosticLines.first().remove();
        }
    }

    // Test HTTPS connection specifically
    function testHttpsConnection() {
        logDiagnostic("Testing HTTPS connection to localhost:8443...");
        
        const xhr = new XMLHttpRequest();
        xhr.open('GET', secugenConfig.baseUrl + secugenConfig.endpoints.getInfo, true);
        xhr.timeout = 5000;
        
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    logDiagnostic("✓ HTTPS connection successful!", 'success');
                    secugenConfig.serviceActive = true;
                    $("#scanFingerprint").prop('disabled', false);
                    $("#secugen_service_status").html('<div class="alert alert-success"><i class="fa fa-check"></i> SecuGen HTTPS service active</div>');
                } else if (xhr.status === 0) {
                    logDiagnostic("✗ HTTPS blocked - possibly CORS or SSL certificate issue", 'error');
                    suggestHttpsFix();
                } else {
                    logDiagnostic(`✗ HTTPS failed with status: ${xhr.status}`, 'error');
                }
            }
        };
        
        xhr.onerror = function() {
            logDiagnostic("✗ HTTPS connection error - network or SSL issue", 'error');
            suggestHttpsFix();
        };
        
        xhr.ontimeout = function() {
            logDiagnostic("✗ HTTPS connection timeout", 'error');
        };
        
        xhr.send();
    }

    // Test HTTP connection as fallback
    function testHttpConnection() {
        logDiagnostic("Testing HTTP connection to localhost:8443...");
        
        $.ajax({
            url: secugenConfig.httpUrl + secugenConfig.endpoints.getInfo,
            type: 'GET',
            timeout: 5000,
            success: function(data) {
                logDiagnostic("✓ HTTP connection successful!", 'success');
                secugenConfig.baseUrl = secugenConfig.httpUrl; // Switch to HTTP
                secugenConfig.serviceActive = true;
                $("#scanFingerprint").prop('disabled', false);
                $("#secugen_service_status").html('<div class="alert alert-success"><i class="fa fa-check"></i> SecuGen HTTP service active</div>');
            },
            error: function(xhr) {
                if (xhr.status === 0) {
                    logDiagnostic("✗ HTTP blocked - possibly CORS issue", 'error');
                } else {
                    logDiagnostic(`✗ HTTP failed with status: ${xhr.status}`, 'error');
                }
            }
        });
    }

    // Suggest HTTPS fixes
    function suggestHttpsFix() {
        const suggestions = `
            <div class="alert alert-warning" style="font-size: 11px; margin-top: 10px;">
                <strong>HTTPS Connection Issues - Try these fixes:</strong><br>
                1. <strong>Accept SSL Certificate:</strong> Visit <a href="https://localhost:8443/SGIFPGetInfo" target="_blank">https://localhost:8443/SGIFPGetInfo</a> and accept the security warning<br>
                2. <strong>Run browser as Administrator</strong><br>
                3. <strong>Disable CORS temporarily:</strong> Start Chrome with --disable-web-security --user-data-dir=temp<br>
                4. <strong>Check Windows Firewall</strong> - ensure port 8443 is allowed<br>
                5. <strong>Try the Manual Capture button</strong> below
            </div>
        `;
        $("#secugen_service_status").html(suggestions);
    }

    // Manual capture using direct XMLHttpRequest (bypasses some CORS issues)
    function manualFingerprintCapture() {
        logDiagnostic("Attempting manual fingerprint capture...");
        
        const captureUrl = secugenConfig.baseUrl + secugenConfig.endpoints.capture;
        
        $("#fingerprintStatus").html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Manual capture - place finger on scanner...</div>');
        $("#manualCapture").prop('disabled', true).text('Scanning...');

        // Use native XMLHttpRequest for better control
        const xhr = new XMLHttpRequest();
        xhr.open('POST', captureUrl, true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.timeout = secugenConfig.timeout;
        
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                $("#manualCapture").prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Capture');
                
                if (xhr.status === 200) {
                    try {
                        const result = JSON.parse(xhr.responseText);
                        logDiagnostic("✓ Manual capture successful!", 'success');
                        handleFingerprintResult(result);
                    } catch (e) {
                        logDiagnostic("✗ Invalid response format", 'error');
                        $("#fingerprintStatus").html('<div class="alert alert-danger">Invalid response from scanner</div>');
                    }
                } else {
                    logDiagnostic(`✗ Manual capture failed: HTTP ${xhr.status}`, 'error');
                    $("#fingerprintStatus").html(`<div class="alert alert-danger">Capture failed: HTTP ${xhr.status}</div>`);
                }
            }
        };
        
        xhr.onerror = function() {
            $("#manualCapture").prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Capture');
            logDiagnostic("✗ Manual capture network error", 'error');
            $("#fingerprintStatus").html('<div class="alert alert-danger">Network error during capture</div>');
        };
        
        xhr.ontimeout = function() {
            $("#manualCapture").prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual Capture');
            logDiagnostic("✗ Manual capture timeout", 'error');
            $("#fingerprintStatus").html('<div class="alert alert-danger">Capture timeout</div>');
        };
        
        // Send the capture request
        const postData = `Quality=${secugenConfig.quality}&Timeout=${secugenConfig.timeout}&WSQCompression=2.25`;
        xhr.send(postData);
    }

    // Handle fingerprint result
    function handleFingerprintResult(result) {
        if (result.ErrorCode === 0) {
            // Success
            if (result.BMPBase64) {
                $("#fingerprintImage").attr("src", "data:image/bmp;base64," + result.BMPBase64);
                $("#fingerprint_image").val(result.BMPBase64);
            }
            
            if (result.TemplateBase64) {
                $("#fingerprint_template").val(result.TemplateBase64);
            }
            
            let successMsg = '<div class="alert alert-success"><i class="fa fa-check"></i> Fingerprint captured successfully!</div>';
            if (result.SerialNumber) {
                successMsg += `<div class="alert alert-info"><small>Device: ${result.Manufacturer || 'SecuGen'} ${result.Model || ''} (SN: ${result.SerialNumber})</small></div>`;
            }
            
            $("#fingerprintStatus").html(successMsg);
            $("#clearFingerprint").show();
            
            logDiagnostic(`✓ Template: ${result.TemplateBase64 ? result.TemplateBase64.length : 0} chars, Image: ${result.BMPBase64 ? result.BMPBase64.length : 0} chars`, 'success');
            
        } else {
            // Error handling
            let errorMsg = 'Fingerprint capture error';
            switch(result.ErrorCode) {
                case 1: errorMsg = 'Reader not found or driver error'; break;
                case 2: errorMsg = 'Function failed - check reader connection'; break;
                case 3: errorMsg = 'Invalid parameters'; break;
                case 5:
                case 6:
                case 7: errorMsg = 'Driver DLL load failed'; break;
                default: 
                    errorMsg = result.ErrorDescription || `Error code: ${result.ErrorCode}`;
            }
            
            $("#fingerprintStatus").html(`<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ${errorMsg}</div>`);
            logDiagnostic(`✗ ${errorMsg}`, 'error');
        }
    }

    // Regular fingerprint capture
    function captureFingerprint() {
        if (!secugenConfig.serviceActive) {
            $("#fingerprintStatus").html('<div class="alert alert-warning">Service not detected. Try Manual Capture or check diagnostics above.</div>');
            return;
        }
        
        const captureUrl = secugenConfig.baseUrl + secugenConfig.endpoints.capture;
        
        $("#fingerprintStatus").html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Place finger on scanner...</div>');
        $("#scanFingerprint").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Scanning...');

        $.ajax({
            url: captureUrl,
            type: 'POST',
            data: {
                Quality: secugenConfig.quality,
                Timeout: secugenConfig.timeout,
                WSQCompression: 2.25
            },
            timeout: secugenConfig.timeout + 5000,
            success: function(response) {
                $("#scanFingerprint").prop('disabled', false).html('<i class="fa fa-fingerprint"></i> <?php echo $this->lang->line('scan_fingerprint'); ?>');
                
                const result = typeof response === 'string' ? JSON.parse(response) : response;
                handleFingerprintResult(result);
            },
            error: function(xhr, status, error) {
                $("#scanFingerprint").prop('disabled', false).html('<i class="fa fa-fingerprint"></i> <?php echo $this->lang->line('scan_fingerprint'); ?>');
                
                let errorMsg = 'Capture failed';
                if (status === 'timeout') {
                    errorMsg = 'Scanner timeout';
                } else if (xhr.status === 0) {
                    errorMsg = 'Connection blocked - try Manual Capture';
                } else {
                    errorMsg = `HTTP ${xhr.status}: ${error}`;
                }
                
                $("#fingerprintStatus").html(`<div class="alert alert-danger">${errorMsg}</div>`);
                logDiagnostic(`✗ ${errorMsg}`, 'error');
            }
        });
    }

    // Clear fingerprint
    function clearFingerprint() {
        $("#fingerprint_template").val('');
        $("#fingerprint_image").val('');
        $("#fingerprintImage").attr("src", "./Images/PlaceFinger.bmp");
        $("#fingerprintStatus").html('');
        $("#clearFingerprint").hide();
        logDiagnostic("Fingerprint data cleared");
    }

    // Event bindings
    $("#testConnection").on('click', function() {
        $("#diagnosticResults").html('');
        testHttpsConnection();
        setTimeout(testHttpConnection, 2000);
    });

    $("#testHttps").on('click', testHttpsConnection);
    $("#testHttp").on('click', testHttpConnection);
    
    $("#openSecuGenDemo").on('click', function() {
        window.open('https://webapi.secugen.com/Demo1', '_blank');
        logDiagnostic("Opened SecuGen official demo - test if it works there first");
    });

    $("#scanFingerprint").on('click', function(e) {
       e.preventDefault();
       captureFingerprint();
   });

   $("#manualCapture").on('click', function(e) {
       e.preventDefault();
       manualFingerprintCapture();
   });

   $("#clearFingerprint").on('click', function(e) {
       e.preventDefault();
       clearFingerprint();
   });

   // Initialize service detection
   $("#secugen_service_status").html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Initializing SecuGen service detection...</div>');
   
   setTimeout(function() {
       logDiagnostic("Starting SecuGen service detection...");
       testHttpsConnection();
       setTimeout(function() {
           if (!secugenConfig.serviceActive) {
               testHttpConnection();
           }
       }, 3000);
   }, 1000);

   // =============================================
   // CAMERA FUNCTIONALITY - ENHANCED
   // =============================================
   
   let videoStream = null;

   async function startCamera() {
       try {
           const stream = await navigator.mediaDevices.getUserMedia({ video: true });
           const videoElement = document.getElementById('camera_stream');
           videoElement.srcObject = stream;
           videoStream = stream;
           $('#camera_container').show();
           $('#capturePhotoBtn').prop('disabled', true);
       } catch (err) {
           console.error('Error accessing camera:', err);
           alert('<?php echo $this->lang->line("error_accessing_camera"); ?>');
       }
   }

   function stopCamera() {
       if (videoStream) {
           videoStream.getTracks().forEach(track => track.stop());
           videoStream = null;
           $('#camera_container').hide();
           $('#capturePhotoBtn').prop('disabled', false);
       }
   }

   function capturePhoto() {
       const video = document.getElementById('camera_stream');
       const canvas = document.getElementById('photo_canvas');
       const context = canvas.getContext('2d');

       context.drawImage(video, 0, 0, canvas.width, canvas.height);

       const capturedImage = document.getElementById('captured_image');
       capturedImage.src = canvas.toDataURL('image/jpeg');
       capturedImage.style.display = 'block';

       // Store image data
       if (!document.getElementById('camera_image_data')) {
           $('#formaddpa').append('<input type="hidden" name="camera_image" id="camera_image_data">');
       }
       document.getElementById('camera_image_data').value = canvas.toDataURL('image/jpeg');

       stopCamera();
       
       // Show success message
       const photoContainer = $('#camera_container').closest('.form-group');
       photoContainer.append('<div class="alert alert-success photo-success-msg" style="margin-top: 10px;"><i class="fa fa-check"></i> Photo captured successfully!</div>');
       
       // Remove success message after 3 seconds
       setTimeout(function() {
           $('.photo-success-msg').fadeOut();
       }, 3000);
   }

   // Enhanced Camera event bindings
   $('#capturePhotoBtn').on('click', function() {
       startCamera();
   });
   
   $('#takePhotoBtn').on('click', function() {
       capturePhoto();
   });

   // Add cancel button functionality
   $('#cancelPhotoBtn').on('click', function() {
       stopCamera();
   });

   // =============================================
   // DATE OF BIRTH / AGE CALCULATION
   // =============================================
   
   $(".patient_dob").on('changeDate', function(event, date) {
       const birth_date = $(".patient_dob").val();
       
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/getpatientage',
           type: "POST",
           dataType: "json",
           data: {birth_date: birth_date},
           success: function (data) {
               $('.patient_age_year').val(data.year); 
               $('.patient_age_month').val(data.month);
               $('.patient_age_day').val(data.day);
           }
       });
   });

   // =============================================
   // FORM SUBMISSION
   // =============================================
   
   $("#formaddpa").on('submit', function(e) {
       let clicked_submit_btn = $(this).find(':submit');
       e.preventDefault();
       
       // Optional: Validate fingerprint before submission
       // Uncomment if fingerprint is mandatory
       /*
       const fingerprintTemplate = $("#fingerprint_template").val();
       if (!fingerprintTemplate || fingerprintTemplate.trim() === '') {
           alert('Please capture fingerprint before submitting the form.');
           return false;
       }
       */
       
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/addpatient',
           type: "POST",
           data: new FormData(this),
           dataType: 'json',
           contentType: false,
           cache: false,
           processData: false,
           beforeSend: function() {
               clicked_submit_btn.button('loading');
           },
           success: function (data) {
               if (data.status == "fail") {
                   let message = "";
                   $.each(data.error, function (index, value) {
                       message += value;
                   });
                   errorMsg(message);
               } else {
                   successMsg(data.message);
                   $("#myModalpa").modal('toggle');
                   
                   // Log successful submission with fingerprint data
                   const hasFingerprint = $("#fingerprint_template").val().length > 0;
                   logDiagnostic(`Patient saved successfully ${hasFingerprint ? 'with' : 'without'} fingerprint data`, 'success');
                   
                   addappointmentModal(data.id, 'myModal');
               }
               clicked_submit_btn.button('reset');
           },
           error: function(xhr) {
               alert('<?php echo $this->lang->line("error_occurred_please_try_again"); ?>');
               clicked_submit_btn.button('reset');
               logDiagnostic("Form submission failed", 'error');
           },
           complete: function() {
               clicked_submit_btn.button('reset');
           }
       });
   });

   // =============================================
   // HELPER FUNCTIONS
   // =============================================
   
   function addappointmentModal(patient_id = '', modalid) {
       $.ajax({
           url: '<?php echo base_url(); ?>admin/patient/getpatientDetails',
           type: "POST",
           data: {id: patient_id},
           dataType: 'json',
           success: function (data) {
               const option = new Option(data.patient_name + " (" + data.id + ")", data.id, true, true);
               $(".patient_list_ajax").append(option).trigger('change');
               $("#" + modalid).modal('show');
               holdModal(modalid);
           }
       });
   }

   // Additional debugging and utility functions
   window.debugSecuGen = function() {
       console.log('=== SecuGen Debug Info ===');
       console.log('Base URL:', secugenConfig.baseUrl);
       console.log('Service Active:', secugenConfig.serviceActive);
       console.log('Last Error:', secugenConfig.lastError);
       console.log('Template Length:', $("#fingerprint_template").val().length);
       console.log('Image Length:', $("#fingerprint_image").val().length);
       
       // Test current configuration
       if (secugenConfig.serviceActive) {
           testHttpsConnection();
       }
   };

   // Global functions for external access
   window.captureFingerprint = captureFingerprint;
   window.clearFingerprint = clearFingerprint;
   window.manualCapture = manualFingerprintCapture;
});

// Additional troubleshooting instructions for console
console.log(`
=== SecuGen Troubleshooting Guide ===

If the fingerprint scanner is not working, try these steps:

1. CERTIFICATE ISSUE (Most Common):
  - Visit: https://localhost:8443/SGIFPGetInfo
  - Accept the security warning/certificate
  - Refresh this page

2. BROWSER PERMISSIONS:
  - Run browser as Administrator
  - Try in Chrome with: --disable-web-security --user-data-dir=temp

3. SERVICE CHECK:
  - Open Windows Services (services.msc)
  - Look for "SecuGen WebAPI" service
  - Ensure it's running on port 8443

4. FIREWALL:
  - Ensure Windows Firewall allows port 8443
  - Temporarily disable antivirus

5. MANUAL TESTING:
  - Use the "Manual Capture" button
  - Check the diagnostic panel for detailed errors

6. DEBUG COMMANDS:
  - Run debugSecuGen() in console for detailed info
  - Check Network tab in Developer Tools for blocked requests

For more help, visit: https://webapi.secugen.com/Demo1
`);
</script>