<!-- 
Create this file as: application/views/admin/patient/patient_profile.php 
-->

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-user"></i> <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('profile'); ?>
            <small><?php echo $patient['patient_name']; ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li><a href="<?php echo base_url(); ?>admin/patient/search"><?php echo $this->lang->line('patient'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('profile'); ?></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Patient Header -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-user"></i> <?php echo $patient['patient_name']; ?> 
                            <small>(ID: <?php echo $patient['id']; ?>)</small>
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('patient', 'can_edit')) { ?>
                                <a href="<?php echo base_url('admin/patient/edit/' . $patient['id']); ?>" class="btn btn-primary btn-sm">
                                    <i class="fa fa-edit"></i> <?php echo $this->lang->line('edit'); ?>
                                </a>
                            <?php } ?>
                            <a href="<?php echo base_url('admin/patient/search'); ?>" class="btn btn-default btn-sm">
                                <i class="fa fa-arrow-left"></i> <?php echo $this->lang->line('back'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column - Patient Info -->
            <div class="col-md-4">
                <!-- Patient Photo and Basic Info -->
                <div class="box box-primary">
                    <div class="box-body box-profile">
                        <img class="profile-user-img img-responsive img-circle" 
                             src="<?php echo base_url($patient['image']); ?>" 
                             alt="Patient Photo"
                             style="width: 150px; height: 150px; object-fit: cover;"
                             onerror="this.src='<?php echo base_url('uploads/patient_images/no_image.png'); ?>'">

                        <h3 class="profile-username text-center"><?php echo $patient['patient_name']; ?></h3>
                        <p class="text-muted text-center">
                            <?php echo $this->lang->line('patient_id'); ?>: <?php echo $patient['id']; ?>
                        </p>

                        <!-- Workflow Badge -->
                        <div class="text-center" style="margin-bottom: 15px;">
                            <?php 
                            $workflow_class = 'label-default';
                            $workflow_name = 'General';
                            if ($patient['patient_workflow'] == 'gcc') {
                                $workflow_class = 'label-success';
                                $workflow_name = 'GCC';
                            } elseif ($patient['patient_workflow'] == 'specialized') {
                                $workflow_class = 'label-warning';
                                $workflow_name = 'Specialized';
                            }
                            ?>
                            <span class="label <?php echo $workflow_class; ?>"><?php echo $workflow_name; ?> Workflow</span>
                        </div>

                        <!-- Quick Stats -->
                        <ul class="list-group list-group-unbordered">
                            <li class="list-group-item">
                                <b><?php echo $this->lang->line('total_visits'); ?></b>
                                <a class="pull-right"><?php echo count($patient['visit_history']); ?></a>
                            </li>
                            <li class="list-group-item">
                                <b><?php echo $this->lang->line('status'); ?></b>
                                <a class="pull-right">
                                    <span class="label <?php echo ($patient['is_active'] == 'yes') ? 'label-success' : 'label-danger'; ?>">
                                        <?php echo ($patient['is_active'] == 'yes') ? $this->lang->line('active') : $this->lang->line('inactive'); ?>
                                    </span>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Fingerprint</b>
                                <a class="pull-right">
                                    <span class="label <?php echo !empty($patient['fingerprint_template']) ? 'label-success' : 'label-default'; ?>">
                                        <?php echo !empty($patient['fingerprint_template']) ? 'Available' : 'Not Captured'; ?>
                                    </span>
                                </a>
                            </li>
                        </ul>

                        <!-- Action Buttons -->
                        <div class="row">
                            <div class="col-xs-12">
                                <?php if ($patient['getbarcode']) { ?>
                                    <a href="<?php echo $patient['getbarcode']; ?>" target="_blank" class="btn btn-info btn-block btn-sm">
                                        <i class="fa fa-barcode"></i> View Barcode
                                    </a>
                                <?php } ?>
                                <?php if ($patient['getqrcode']) { ?>
                                    <a href="<?php echo $patient['getqrcode']; ?>" target="_blank" class="btn btn-success btn-block btn-sm">
                                        <i class="fa fa-qrcode"></i> View QR Code
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Workflow Status -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-tasks"></i> Workflow Progress</h3>
                    </div>
                    <div class="box-body">
                        <?php foreach ($patient['workflow_status'] as $step => $status): ?>
                            <div class="progress-group">
                                <span class="progress-text">
                                    <?php echo ucfirst($step); ?>
                                    <span class="label <?php echo ($status['status'] == 'completed') ? 'label-success' : 'label-warning'; ?> pull-right">
                                        <?php echo ($status['status'] == 'completed') ? 'Done' : 'Pending'; ?>
                                    </span>
                                </span>
                                <div class="progress progress-sm">
                                    <div class="progress-bar <?php echo ($status['status'] == 'completed') ? 'progress-bar-success' : 'progress-bar-warning'; ?>" 
                                         style="width: <?php echo ($status['status'] == 'completed') ? '100%' : '0%'; ?>"></div>
                                </div>
                                <?php if ($status['count'] > 0): ?>
                                    <small class="text-muted">
                                        <?php echo $status['count']; ?> completed
                                        <?php if ($status['last_date']): ?>
                                            - Last: <?php echo date('d M Y', strtotime($status['last_date'])); ?>
                                        <?php endif; ?>
                                    </small>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Right Column - Detailed Information -->
            <div class="col-md-8">
                <!-- Personal Information -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-user"></i> <?php echo $this->lang->line('personal_information'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <th><?php echo $this->lang->line('patient_name'); ?></th>
                                        <td><?php echo $patient['patient_name']; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('age'); ?></th>
                                        <td><?php echo $patient['patient_age']; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('gender'); ?></th>
                                        <td><?php echo $patient['gender']; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('date_of_birth'); ?></th>
                                        <td><?php echo $patient['dob'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('blood_group'); ?></th>
                                        <td><?php echo $patient['blood_group_name'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('marital_status'); ?></th>
                                        <td><?php echo $patient['marital_status']; ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <th><?php echo $this->lang->line('guardian_name'); ?></th>
                                        <td><?php echo $patient['guardian_name'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <td><?php echo $patient['mobileno'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('email'); ?></th>
                                        <td><?php echo $patient['email'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('address'); ?></th>
                                        <td><?php echo $patient['address'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('known_allergies'); ?></th>
                                        <td><?php echo $patient['known_allergies'] ?: 'None'; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Registration Date</th>
                                        <td><?php echo date('d M Y', strtotime($patient['created_at'])); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Insurance Information -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-id-card"></i> Insurance & Identification</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <th><?php echo $this->lang->line('organisation'); ?></th>
                                        <td><?php echo $patient['organisation_name'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('insurance_id'); ?></th>
                                        <td><?php echo $patient['insurance_id'] ?: 'Not specified'; ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <th><?php echo $this->lang->line('insurance_validity'); ?></th>
                                        <td><?php echo $patient['insurance_validity'] ?: 'Not specified'; ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo $this->lang->line('identification_number'); ?></th>
                                        <td><?php echo $patient['identification_number'] ?: 'Not specified'; ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Visit History -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-history"></i> Recent Visit History</h3>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($patient['visit_history'])): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Case Reference</th>
                                            <th>Doctor</th>
                                            <th>Symptoms</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($patient['visit_history'] as $visit): ?>
                                            <tr>
                                                <td><?php echo date('d M Y', strtotime($visit['appointment_date'])); ?></td>
                                                <td><?php echo $visit['case_reference_id']; ?></td>
                                                <td><?php echo trim($visit['doctor_name'] . ' ' . $visit['doctor_surname']); ?></td>
                                                <td><?php echo substr($visit['symptoms'] ?: 'Not specified', 0, 50); ?></td>
                                                <td><?php echo $visit['amount'] ? number_format($visit['amount'], 2) : 'N/A'; ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No visit history found.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Notes -->
                <?php if (!empty($patient['note'])): ?>
                    <div class="box box-warning">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-sticky-note"></i> <?php echo $this->lang->line('note'); ?></h3>
                        </div>
                        <div class="box-body">
                            <p><?php echo nl2br(htmlspecialchars($patient['note'])); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Custom Fields -->
                <?php if (!empty($patient['field_data'])): ?>
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-list"></i> Additional Information</h3>
                        </div>
                        <div class="box-body">
                            <table class="table table-striped">
                                <?php foreach ($patient['field_data'] as $field): ?>
                                    <tr>
                                        <th><?php echo $field['name']; ?></th>
                                        <td><?php echo $field['default_value'] ?: 'Not specified'; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<style>
.profile-user-img {
    border: 3px solid #adb5bd;
    margin: 0 auto;
    padding: 3px;
}

.progress-group {
    margin-bottom: 15px;
}

.progress-text {
    font-weight: 600;
    margin-bottom: 5px;
    display: block;
}

.box {
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
}

.table th {
    background-color: #f4f4f4;
    font-weight: 600;
}

@media (max-width: 768px) {
    .profile-user-img {
        width: 100px;
        height: 100px;
    }
}
/* Beautiful Patient Profile Styles */
/* Add this CSS to your main stylesheet or create a separate CSS file */

/* Global Styles */
* {
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    line-height: 1.6;
    color: #333;
}

/* Header Styles */
.profile-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 30px;
    padding: 0 15px;
}

.back-btn {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    padding: 12px 20px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.3);
}

.back-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
}

.header-actions {
    display: flex;
    gap: 10px;
}

.action-btn {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    padding: 12px 20px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    border-radius: 25px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
    cursor: pointer;
}

.action-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
}

.edit-btn:hover {
    background: #4CAF50;
    border-color: #4CAF50;
}

.print-btn:hover {
    background: #2196F3;
    border-color: #2196F3;
}

/* Patient Card Styles */
.patient-card {
    background: white;
    border-radius: 20px;
    padding: 30px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
    position: relative;
    overflow: hidden;
}

.patient-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
}

.patient-avatar-section {
    text-align: center;
    margin-bottom: 30px;
}

.avatar-container {
    position: relative;
    display: inline-block;
    margin-bottom: 20px;
}

.patient-avatar {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid #f0f0f0;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s ease;
}

.patient-avatar:hover {
    transform: scale(1.05);
}

.status-indicator {
    position: absolute;
    bottom: 5px;
    right: 5px;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    border: 3px solid white;
}

.status-indicator.active {
    background: #4CAF50;
}

.status-indicator.inactive {
    background: #f44336;
}

.patient-name {
    font-size: 24px;
    font-weight: 700;
    color: #333;
    margin: 0 0 5px 0;
}

.patient-id {
    color: #666;
    font-size: 14px;
    margin: 0 0 20px 0;
}

/* Workflow Badge */
.workflow-badge-container {
    margin-bottom: 30px;
}

.workflow-badge {
    display: inline-block;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.workflow-badge.gcc {
    background: linear-gradient(135deg, #4CAF50, #45a049);
    color: white;
}

.workflow-badge.specialized {
    background: linear-gradient(135deg, #FF9800, #F57C00);
    color: white;
}

.workflow-badge.default {
    background: linear-gradient(135deg, #607D8B, #455A64);
    color: white;
}

/* Quick Stats */
.quick-stats {
    display: flex;
    flex-direction: column;
    gap: 15px;
    margin-bottom: 30px;
}

.stat-item {
    display: flex;
    align-items: center;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 12px;
    transition: transform 0.3s ease;
}

.stat-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.stat-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea, #764ba2);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    margin-right: 15px;
}

.stat-content {
    flex: 1;
}

.stat-number {
    display: block;
    font-size: 20px;
    font-weight: 700;
    color: #333;
}

.stat-label {
    display: block;
    font-size: 12px;
    color: #666;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.action-button {
    display: flex;
    align-items: center;
    padding: 12px 16px;
    border-radius: 10px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
}

.action-button.barcode {
    background: linear-gradient(135deg, #2196F3, #1976D2);
    color: white;
}

.action-button.qrcode {
    background: linear-gradient(135deg, #4CAF50, #388E3C);
    color: white;
}

.action-button i {
    margin-right: 8px;
}

.action-button:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    text-decoration: none;
    color: white;
}

/* Workflow Progress Card */
.workflow-progress-card {
    background: white;
    border-radius: 20px;
    padding: 25px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #333;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
}

.card-title i {
    margin-right: 10px;
    color: #667eea;
}

.progress-items {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.progress-item {
    display: flex;
    align-items: center;
    padding: 15px;
    border-radius: 12px;
    transition: all 0.3s ease;
    border-left: 4px solid #e0e0e0;
}

.progress-item.completed {
    background: #f1f8e9;
    border-left-color: #4CAF50;
}

.progress-item.pending {
    background: #fff3e0;
    border-left-color: #FF9800;
}

.progress-item:hover {
    transform: translateX(5px);
}

.progress-icon {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: white;
}

.progress-item.completed .progress-icon {
    background: #4CAF50;
}

.progress-item.pending .progress-icon {
    background: #FF9800;
}

.progress-content {
    flex: 1;
}

.progress-title {
    display: block;
    font-weight: 600;
    color: #333;
    font-size: 14px;
}

.progress-status {
    display: block;
    font-size: 12px;
    color: #666;
    margin-top: 2px;
}

.progress-details {
    display: block;
    font-size: 11px;
    color: #999;
    margin-top: 5px;
}

.progress-indicator {
    font-size: 18px;
}

.progress-item.completed .progress-indicator {
    color: #4CAF50;
}

.progress-item.pending .progress-indicator {
    color: #FF9800;
}

/* Info Cards */
.info-card {
    background: white;
    border-radius: 20px;
    margin-bottom: 30px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
    padding: 20px 25px;
    border-bottom: 1px solid #e0e0e0;
}

.card-body {
    padding: 25px;
}

/* Info Grid */
.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.info-item {
    display: flex;
    flex-direction: column;
}

.info-item.full-width {
    grid-column: 1 / -1;
}

.info-item label {
    font-size: 12px;
    font-weight: 600;
    color: #666;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 5px;
}

.info-item value {
    font-size: 14px;
    color: #333;
    font-weight: 500;
}

/* Special Badges */
.gender-badge {
    display: inline-flex;
    align-items: center;
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: 600;
}

.gender-badge.male {
    background: #e3f2fd;
    color: #1976d2;
}

.gender-badge.female {
    background: #fce4ec;
    color: #c2185b;
}

.gender-badge i {
    margin-right: 5px;
}

.blood-group-badge {
    background: #ffebee;
    color: #d32f2f;
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: 600;
    display: inline-block;
}

.allergy-badge {
    background: #fff3e0;
    color: #f57c00;
    padding: 6px 12px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
}

.allergy-badge i {
    margin-right: 5px;
}

.no-allergies {
    color: #4caf50;
    font-style: italic;
}

/* Contact Links */
.phone-link, .email-link {
    color: #667eea;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    transition: color 0.3s ease;
}

.phone-link:hover, .email-link:hover {
    color: #764ba2;
    text-decoration: none;
}

.phone-link i, .email-link i {
    margin-right: 8px;
}

/* Visit Timeline */
.visit-timeline {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.visit-item {
    display: flex;
    background: #f8f9fa;
    border-radius: 15px;
    padding: 20px;
    transition: all 0.3s ease;
    border-left: 4px solid #667eea;
}

.visit-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
}

.visit-date {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    border-radius: 12px;
    padding: 15px;
    margin-right: 20px;
    min-width: 70px;
    text-align: center;
}

.visit-date .date {
    font-size: 24px;
    font-weight: 700;
    line-height: 1;
}

.visit-date .month {
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-top: 2px;
}

.visit-content {
    flex: 1;
}

.visit-content h4 {
    font-size: 16px;
    font-weight: 600;
    color: #333;
    margin: 0 0 8px 0;
}

.visit-content .doctor {
    font-size: 14px;
    color: #666;
    margin: 0 0 8px 0;
    display: flex;
    align-items: center;
}

.visit-content .doctor i {
    margin-right: 8px;
    color: #667eea;
}

.visit-content .symptoms {
    font-size: 14px;
    color: #555;
    line-height: 1.5;
    margin: 0 0 10px 0;
}

.visit-content .amount {
    background: #e8f5e8;
    color: #2e7d32;
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
    display: inline-block;
}

/* Notes */
.note-content {
    background: #f8f9fa;
    border-left: 4px solid #667eea;
    padding: 20px;
    border-radius: 0 10px 10px 0;
    font-style: italic;
    color: #555;
    line-height: 1.6;
}

/* Responsive Design */
@media (max-width: 768px) {
    .profile-header {
        flex-direction: column;
        gap: 15px;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: center;
    }
    
    .patient-card {
        padding: 20px;
    }
    
    .patient-avatar {
        width: 100px;
        height: 100px;
    }
    
    .patient-name {
        font-size: 20px;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
        gap: 15px;
    }
    
    .quick-stats {
        gap: 10px;
    }
    
    .stat-item {
        padding: 12px;
    }
    
    .stat-number {
        font-size: 18px;
    }
    
    .progress-items {
        gap: 10px;
    }
    
    .progress-item {
        padding: 12px;
    }
    
    .visit-item {
        flex-direction: column;
        gap: 15px;
    }
    
    .visit-date {
        align-self: flex-start;
        margin-right: 0;
    }
    
    .card-body {
        padding: 20px;
    }
    
    .card-header {
        padding: 15px 20px;
    }
}

@media (max-width: 480px) {
    .content-wrapper {
        padding: 10px;
    }
    
    .patient-card,
    .workflow-progress-card,
    .info-card {
        margin-bottom: 20px;
        border-radius: 15px;
    }
    
    .patient-name {
        font-size: 18px;
    }
    
    .card-title {
        font-size: 16px;
    }
    
    .back-btn,
    .action-btn {
        padding: 10px 16px;
        font-size: 14px;
    }
}

/* Print Styles */
@media print {
    .profile-header,
    .action-buttons {
        display: none !important;
    }
    
    .content-wrapper {
        background: white !important;
        padding: 20px !important;
    }
    
    .patient-card,
    .workflow-progress-card,
    .info-card {
        box-shadow: none !important;
        border: 1px solid #ddd;
        break-inside: avoid;
        margin-bottom: 20px;
    }
    
    .card-header {
        background: #f5f5f5 !important;
    }
    
    .visit-item {
        background: #f9f9f9 !important;
    }
    
    .visit-date {
        background: #333 !important;
    }
}

/* Loading Animation */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.patient-card,
.workflow-progress-card,
.info-card {
    animation: fadeInUp 0.6s ease forwards;
}

.patient-card {
    animation-delay: 0.1s;
}

.workflow-progress-card {
    animation-delay: 0.2s;
}

.info-card:nth-child(1) {
    animation-delay: 0.3s;
}

.info-card:nth-child(2) {
    animation-delay: 0.4s;
}

.info-card:nth-child(3) {
    animation-delay: 0.5s;
}

/* Scrollbar Styling */
::-webkit-scrollbar {
    width: 8px;
}

::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #667eea, #764ba2);
    border-radius: 10px;
}

::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(135deg, #764ba2, #667eea);
}
</style>
<script>
    // Add this JavaScript to enhance the patient profile with interactive features

$(document).ready(function() {
    // Smooth scroll animation for cards
    $('.info-card, .patient-card, .workflow-progress-card').css('opacity', '0').each(function(index) {
        $(this).delay(index * 100).animate({
            opacity: 1
        }, 600);
    });

    // Add click-to-copy functionality for patient ID
    $('.patient-id').click(function() {
        const patientId = $(this).text().replace('ID: ', '');
        copyToClipboard(patientId);
        showNotification('Patient ID copied to clipboard!', 'success');
    }).css('cursor', 'pointer').attr('title', 'Click to copy Patient ID');

    // Add hover effects for progress items
    $('.progress-item').hover(
        function() {
            $(this).find('.progress-icon').addClass('pulse');
        },
        function() {
            $(this).find('.progress-icon').removeClass('pulse');
        }
    );

    // Add click functionality for phone numbers
    $('.phone-link').click(function(e) {
        e.preventDefault();
        const phone = $(this).text().trim();
        if (confirm(`Call ${phone}?`)) {
            window.open(`tel:${phone}`);
        }
    });

    // Add click functionality for email addresses
    $('.email-link').click(function(e) {
        e.preventDefault();
        const email = $(this).text().trim();
        if (confirm(`Send email to ${email}?`)) {
            window.open(`mailto:${email}`);
        }
    });

    // Add print functionality with custom styling
    $('.print-btn').click(function(e) {
        e.preventDefault();
        window.print();
    });

    // Add tooltips for workflow status
    $('.progress-item').each(function() {
        const step = $(this).find('.progress-title').text();
        const status = $(this).find('.progress-status').text();
        const details = $(this).find('.progress-details').text();
        
        let tooltipText = `${step}: ${status}`;
        if (details) {
            tooltipText += `\n${details}`;
        }
        
        $(this).attr('title', tooltipText);
    });

    // Add expand/collapse functionality for long content
    $('.note-content, .symptoms').each(function() {
        const maxLength = 150;
        const text = $(this).text();
        
        if (text.length > maxLength) {
            const shortText = text.substring(0, maxLength);
            const remainingText = text.substring(maxLength);
            
            $(this).html(`
                <span class="short-text">${shortText}...</span>
                <span class="remaining-text" style="display: none;">${remainingText}</span>
                <a href="#" class="read-more" style="color: #667eea; font-weight: 600; margin-left: 5px;">Read More</a>
            `);
        }
    });

    // Handle read more/less functionality
    $(document).on('click', '.read-more', function(e) {
        e.preventDefault();
        const parent = $(this).parent();
        const shortText = parent.find('.short-text');
        const remainingText = parent.find('.remaining-text');
        
        if (remainingText.is(':visible')) {
            remainingText.hide();
            shortText.show();
            $(this).text('Read More');
        } else {
            remainingText.show();
            shortText.hide();
            $(this).text('Read Less');
        }
    });

    // Add floating action button for quick actions
    if ($('.action-buttons').children().length > 0) {
        $('body').append(`
            <div class="floating-actions">
                <button class="fab-main" title="Quick Actions">
                    <i class="fa fa-plus"></i>
                </button>
                <div class="fab-menu">
                    <button class="fab-item" onclick="window.print()" title="Print Profile">
                        <i class="fa fa-print"></i>
                    </button>
                    <button class="fab-item" onclick="shareProfile()" title="Share Profile">
                        <i class="fa fa-share"></i>
                    </button>
                    <button class="fab-item" onclick="downloadProfile()" title="Download PDF">
                        <i class="fa fa-download"></i>
                    </button>
                </div>
            </div>
        `);
        
        // Add CSS for floating action button
        $('head').append(`
            <style>
                .floating-actions {
                    position: fixed;
                    bottom: 30px;
                    right: 30px;
                    z-index: 1000;
                }
                
                .fab-main {
                    width: 60px;
                    height: 60px;
                    border-radius: 50%;
                    background: linear-gradient(135deg, #667eea, #764ba2);
                    border: none;
                    color: white;
                    font-size: 24px;
                    cursor: pointer;
                    box-shadow: 0 5px 20px rgba(0,0,0,0.3);
                    transition: all 0.3s ease;
                }
                
                .fab-main:hover {
                    transform: scale(1.1) rotate(45deg);
                }
                
                .fab-menu {
                    position: absolute;
                    bottom: 70px;
                    right: 0;
                    display: none;
                    flex-direction: column;
                    gap: 10px;
                }
                
                .fab-item {
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    background: white;
                    border: 2px solid #667eea;
                    color: #667eea;
                    font-size: 18px;
                    cursor: pointer;
                    box-shadow: 0 3px 15px rgba(0,0,0,0.2);
                    transition: all 0.3s ease;
                    opacity: 0;
                    transform: translateY(20px);
                }
                
                .fab-item:hover {
                    background: #667eea;
                    color: white;
                    transform: translateY(0) scale(1.1);
                }
                
                .fab-menu.active .fab-item {
                    opacity: 1;
                    transform: translateY(0);
                }
                
                .fab-menu.active .fab-item:nth-child(1) { transition-delay: 0.1s; }
                .fab-menu.active .fab-item:nth-child(2) { transition-delay: 0.2s; }
                .fab-menu.active .fab-item:nth-child(3) { transition-delay: 0.3s; }
                
                @media (max-width: 768px) {
                    .floating-actions {
                        bottom: 20px;
                        right: 20px;
                    }
                    
                    .fab-main {
                        width: 50px;
                        height: 50px;
                        font-size: 20px;
                    }
                    
                    .fab-item {
                        width: 40px;
                        height: 40px;
                        font-size: 16px;
                    }
                }
            </style>
        `);
    }

    // Handle floating action button menu
    $('.fab-main').click(function() {
        $('.fab-menu').toggleClass('active');
        $(this).toggleClass('active');
    });

    // Close fab menu when clicking outside
    $(document).click(function(e) {
        if (!$(e.target).closest('.floating-actions').length) {
            $('.fab-menu').removeClass('active');
            $('.fab-main').removeClass('active');
        }
    });

    // Add CSS for pulse animation
    $('head').append(`
        <style>
            .pulse {
                animation: pulse 1s infinite;
            }
            
            @keyframes pulse {
                0% { transform: scale(1); }
                50% { transform: scale(1.1); }
                100% { transform: scale(1); }
            }
        </style>
    `);
});

// Utility Functions
function copyToClipboard(text) {
    if (navigator.clipboard) {
        navigator.clipboard.writeText(text);
    } else {
        const textArea = document.createElement('textarea');
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
    }
}

function showNotification(message, type = 'info') {
    const notification = $(`
        <div class="notification ${type}" style="
            position: fixed;
            top: 20px;
            right: 20px;
            background: ${type === 'success' ? '#4CAF50' : type === 'error' ? '#f44336' : '#2196F3'};
            color: white;
            padding: 15px 20px;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.3);
            z-index: 10000;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        ">
            <i class="fa ${type === 'success' ? 'fa-check' : type === 'error' ? 'fa-times' : 'fa-info'}"></i>
            ${message}
        </div>
    `);
    
    $('body').append(notification);
    
    setTimeout(() => {
        notification.css('transform', 'translateX(0)');
    }, 100);
    
    setTimeout(() => {
        notification.css('transform', 'translateX(100%)');
        setTimeout(() => {
            notification.remove();
        }, 300);
    }, 3000);
}

function shareProfile() {
    if (navigator.share) {
        navigator.share({
            title: 'Patient Profile',
            text: `Patient profile for ${$('.patient-name').text()}`,
            url: window.location.href
        });
    } else {
        copyToClipboard(window.location.href);
        showNotification('Profile link copied to clipboard!', 'success');
    }
}

function downloadProfile() {
    showNotification('PDF download feature coming soon!', 'info');
    // You can implement PDF generation here using libraries like jsPDF
}

// Add smooth scrolling for anchor links
$('a[href^="#"]').click(function(e) {
    e.preventDefault();
    const target = $($(this).attr('href'));
    if (target.length) {
        $('html, body').animate({
            scrollTop: target.offset().top - 100
        }, 500);
    }
});

// Add loading states for async operations
function showLoading(element) {
    element.html('<i class="fa fa-spinner fa-spin"></i> Loading...');
}

function hideLoading(element, originalContent) {
    element.html(originalContent);
}
</script>