<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('billing'); ?>
            <small><?php echo $this->lang->line('patient_billing_management'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('home'); ?></a></li>
            <li><a href="#"><?php echo $this->lang->line('patient'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('billing'); ?></li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Dashboard Statistics Row -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="totalPatients">0</h3>
                        <p><?php echo $this->lang->line('total_patients'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <div class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="totalRevenue"><?php echo $currency_symbol; ?>0.00</h3>
                        <p><?php echo $this->lang->line('total_revenue'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                    <div class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="todayConsultations">0</h3>
                        <p><?php echo $this->lang->line('today_consultations'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-stethoscope"></i>
                    </div>
                    <div class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="pendingLabs">0</h3>
                        <p><?php echo $this->lang->line('pending_lab_results'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                    <div class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </div>
                </div>
            </div>
        </div>
        <!-- Patient Selection Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-user"></i> <?php echo $this->lang->line('patient_selection'); ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="display: none;">
                        <form id="searchForm" class="ptt10" autocomplete="off">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><i class="fa fa-search"></i> <?php echo $this->lang->line('search_patient'); ?></label>
                                        <div class="input-group">
                                            <input type="text" name="search_text" id="patientSearchInput" class="form-control" placeholder="Search by name, phone, or patient ID">
                                            <div class="input-group-btn">
                                                <button type="button" class="btn btn-primary" onclick="searchPatients()">
                                                    <i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?>
                                                </button>
                                            </div>
                                        </div>
                                        <small class="text-muted"><?php echo $this->lang->line('enter_at_least'); ?> 2 <?php echo $this->lang->line('characters_to_search'); ?></small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><i class="fa fa-user-circle"></i> <?php echo $this->lang->line('selected_patient'); ?></label>
                                        <select class="form-control" name="selected_patient_id" id="selectedPatient">
                                            <option value=""><?php echo $this->lang->line('select_a_patient'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('status'); ?></label>
                                        <select class="form-control" name="status_filter" id="statusFilter">
                                            <option value=""><?php echo $this->lang->line('all_patients'); ?></option>
                                            <option value="active"><?php echo $this->lang->line('active'); ?></option>
                                            <option value="inactive"><?php echo $this->lang->line('inactive'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('sort_by'); ?></label>
                                        <select class="form-control" name="sort_by" id="sortBy">
                                            <option value="name"><?php echo $this->lang->line('patient_name'); ?></option>
                                            <option value="total_billing"><?php echo $this->lang->line('total_billing'); ?></option>
                                            <option value="last_visit"><?php echo $this->lang->line('last_visit'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="button" class="btn btn-success btn-block" onclick="refreshPatientsList()">
                                            <i class="fa fa-refresh"></i> <?php echo $this->lang->line('refresh'); ?>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="button" class="btn btn-info btn-block" onclick="selectTests()">
                                            <i class="fa fa-flask"></i> <?php echo $this->lang->line('select_tests'); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Patients Table -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix">
                            <i class="fa fa-list"></i> <?php echo $this->lang->line('patient_billing_list'); ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addPatientModal">
                                <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_patient'); ?>
                            </button>
                            <button type="button" class="btn btn-success btn-sm" onclick="exportBillingData()">
                                <i class="fa fa-download"></i> Export CSV
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="download_label"><?php echo $this->lang->line('patient_billing_list'); ?></div>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="patientsTable">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('patient_info'); ?></th>
                                        <th><?php echo $this->lang->line('contact'); ?></th>
                                        <th><i class="fa fa-stethoscope"></i> Consultation</th>
                                        <th><i class="fa fa-flask"></i> Laboratory</th>
                                        <th><i class="fa fa-medkit"></i> Pharmacy</th>
                                        <th><i class="fa fa-radiologic"></i> Radiology</th>
                                        <th><?php echo $this->lang->line('total_amount'); ?></th>
                                        <th><?php echo $this->lang->line('last_visit'); ?></th>
                                        <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="patientsTableBody">
                                    <tr>
                                        <td colspan="9" class="text-center">
                                            <i class="fa fa-spinner fa-spin"></i> Loading patients...
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<!-- Add Patient Modal -->
<div class="modal fade" id="addPatientModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-user-plus"></i> <?php echo $this->lang->line('add_patient'); ?>
                </h4>
            </div>
            <div class="modal-body pt0 pb0">
                <form id="addPatientForm" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="row">
                                <!-- Personal Information -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="patient_name"><?php echo $this->lang->line('name'); ?></label>
                                        <small class="req">*</small>
                                        <input id="patient_name" name="patient_name" placeholder="" type="text" class="form-control" value="" />
                                        <span class="text-danger"></span>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="age"><?php echo $this->lang->line('age'); ?></label>
                                        <small class="req">*</small>
                                        <input type="number" name="age" id="age" class="form-control" min="0" max="150">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                                        <small class="req">*</small>
                                        <select class="form-control" name="gender" id="gender">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <option value="Male"><?php echo $this->lang->line('male'); ?></option>
                                            <option value="Female"><?php echo $this->lang->line('female'); ?></option>
                                            <option value="Other"><?php echo $this->lang->line('other'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="mobileno"><?php echo $this->lang->line('phone'); ?></label>
                                        <small class="req">*</small>
                                        <input id="mobileno" name="mobileno" placeholder="" type="text" class="form-control" value="" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email"><?php echo $this->lang->line('email'); ?></label>
                                        <input type="email" name="email" id="email" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="blood_group_id"><?php echo $this->lang->line('blood_group'); ?></label>
                                        <select name="blood_group_id" id="blood_group_id" class="form-control">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php foreach ($bloodgroups as $bloodgroup) { ?>
                                                <option value="<?php echo $bloodgroup['id']; ?>"><?php echo $bloodgroup['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="address"><?php echo $this->lang->line('address'); ?></label>
                                        <textarea name="address" id="address" class="form-control" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="button" class="btn btn-primary" onclick="addNewPatient()">
                    <i class="fa fa-check"></i> <?php echo $this->lang->line('save'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<style>
/* Custom styles to match your system design */
.billing-cell {
    text-align: center;
    font-weight: bold;
    padding: 8px !important;
}
.billing-amount {
    color: #27ae60;
    font-size: 13px;
}
.billing-zero {
    color: #95a5a6;
    font-style: italic;
}
.total-amount {
    font-size: 14px;
    font-weight: bold;
    color: #e74c3c;
    background-color: #fff5f5;
    padding: 8px;
    border-radius: 4px;
}
.patient-row {
    cursor: pointer;
}
.patient-row:hover {
    background-color: #f5f5f5;
}
.billing-summary {
    background: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 4px;
    padding: 15px;
    margin-bottom: 15px;
}
.billing-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid #eee;
}
.billing-item:last-child {
    border-bottom: none;
    font-weight: bold;
    font-size: 16px;
    color: #27ae60;
}
.service-section {
    margin-top: 15px;
}
.service-section .panel-heading {
    background-color: #f5f5f5;
    border-bottom: 1px solid #ddd;
}
.no-patients {
    text-align: center;
    padding: 40px;
    color: #999;
}
.no-patients i {
    font-size: 48px;
    margin-bottom: 15px;
    opacity: 0.3;
}
/* Highlighting for financial columns */
.financial-column {
    background-color: #f8f9fa;
    border-left: 3px solid #007bff;
}
.consultation-col { border-left-color: #17a2b8; }
.laboratory-col { border-left-color: #dc3545; }
.pharmacy-col { border-left-color: #28a745; }
.radiology-col { border-left-color: #ffc107; }
.total-col { border-left-color: #e74c3c; background-color: #fff5f5; }
</style>

<script type="text/javascript">
// Define currency symbol globally
const currency_symbol = '<?php echo $currency_symbol; ?>';

$(document).ready(function() {
    console.log('Patient Billing System - Initializing...');
    console.log('Currency symbol:', currency_symbol);

    // Initialize page
    loadDashboardStats();
    loadPatientsList();

    // Set up functionality
    $('#statusFilter, #sortBy').on('change', function() {
        console.log('Filter changed, reloading patients...');
        loadPatientsList();
    });

    // Initialize tooltips if available
    if ($.fn.tooltip) {
        $('[data-toggle="tooltip"]').tooltip();
    }

    // Enter key search
    $('#patientSearchInput').on('keypress', function(e) {
        if (e.which === 13) {
            searchPatients();
        }
    });

    // Handle patient selection - KEY FIX
    $('#selectedPatient').on('change', function() {
        var patientId = $(this).val();
        console.log('Patient selected:', patientId);
        
        if (patientId && patientId !== '') {
            // Load ONLY the selected patient's billing
            loadSelectedPatientBilling(patientId);
        } else {
            // If no patient selected, show all patients
            loadPatientsList();
        }
    });
});

function searchPatients() {
    var searchTerm = $('#patientSearchInput').val().trim();

    if (searchTerm.length < 2) {
        warningMsg('Please enter at least 2 characters');
        return;
    }

    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/patient_search',
        type: 'GET',
        data: { q: searchTerm },
        dataType: 'json',
        beforeSend: function() {
            $('#selectedPatient').html('<option value="">Searching...</option>');
        },
        success: function(response) {
            console.log('Search response:', response);
            var select = $('#selectedPatient');
            select.empty();
            select.append('<option value="">Select a patient</option>');

            if (response.items && response.items.length > 0) {
                $.each(response.items, function(index, patient) {
                    select.append('<option value="' + patient.id + '">' + patient.text + '</option>');
                });

                if (response.items.length === 1) {
                    select.val(response.items[0].id);
                    // Immediately load this patient's billing
                    loadSelectedPatientBilling(response.items[0].id);
                    successMsg('Patient selected: ' + response.items[0].patient_name);
                } else {
                    successMsg('Found ' + response.items.length + ' patient(s). Please select one.');
                }
            } else {
                select.append('<option value="">No patients found</option>');
                warningMsg('No patients found');
                // Show all patients if no search results
                loadPatientsList();
            }
        },
        error: function(xhr, status, error) {
            console.error('Patient search error:', error);
            console.error('Response text:', xhr.responseText);
            $('#selectedPatient').html('<option value="">Error searching patients</option>');
            errorMsg('Error searching patients: ' + error);
        }
    });
}

function loadSelectedPatientBilling(patientId) {
    console.log('Loading billing for selected patient:', patientId);
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getPatientBillingDetails',
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        beforeSend: function() {
            $('#patientsTableBody').html('<tr><td colspan="9" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading patient billing details...</td></tr>');
        },
        success: function(response) {
            console.log('Selected patient billing response:', response);
            if (response.status === 'success') {
                displaySelectedPatientBilling(response.billing_details, patientId);
            } else {
                displayNoPatients('Error loading patient billing: ' + (response.message || 'Unknown error'));
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading selected patient billing:', error);
            console.error('Response text:', xhr.responseText);
            displayNoPatients('Network error loading patient billing: ' + error);
        }
    });
}

function displaySelectedPatientBilling(billingDetails, patientId) {
    console.log('Displaying selected patient billing:', billingDetails);
    var tbody = $('#patientsTableBody');
    tbody.empty();

    // Get patient info from the selected dropdown
    var selectedPatientText = $('#selectedPatient option:selected').text();
    var patientInfo = selectedPatientText.split('(');
    var patientName = patientInfo[0].trim();
    
    // Extract patient details from dropdown text
    var patientDetails = '';
    if (patientInfo.length > 1) {
        patientDetails = patientInfo[1].replace(')', '');
    }

    // Create summary row for the selected patient
    var summaryRow = `
        <tr class="info" style="background-color: #d9edf7;">
            <td colspan="9">
                <h4><i class="fa fa-user"></i> Patient Billing Summary: ${patientName}</h4>
                <p><strong>Patient Details:</strong> ${patientDetails}</p>
                <button type="button" class="btn btn-sm btn-default pull-right" onclick="clearPatientSelection()">
                    <i class="fa fa-times"></i> Show All Patients
                </button>
            </td>
        </tr>
    `;
    tbody.append(summaryRow);

    // Create billing summary row
    var billingRow = `
        <tr>
            <td>
                <strong>${patientName}</strong><br>
                <small class="text-muted">
                    Patient ID: ${patientId}<br>
                    Selected Patient
                </small>
            </td>
            <td>
                <small class="text-muted">Contact details from patient record</small>
            </td>
            <td class="billing-cell consultation-col">
                <span class="billing-amount">${currency_symbol}${formatNumber(billingDetails.totals.consultations || 0)}</span>
            </td>
            <td class="billing-cell laboratory-col">
                <span class="billing-amount">${currency_symbol}${formatNumber(billingDetails.totals.laboratory || 0)}</span>
            </td>
            <td class="billing-cell pharmacy-col">
                <span class="billing-amount">${currency_symbol}${formatNumber(billingDetails.totals.pharmacy || 0)}</span>
            </td>
            <td class="billing-cell radiology-col">
                <span class="billing-amount">${currency_symbol}${formatNumber(billingDetails.totals.radiology || 0)}</span>
            </td>
            <td class="billing-cell total-col">
                <span class="total-amount">${currency_symbol}${formatNumber(billingDetails.totals.grand_total || 0)}</span>
            </td>
            <td>
                <small>Detailed Billing</small>
            </td>
            <td class="text-right">
                <button class="btn btn-primary btn-xs" onclick="showDetailedBilling(${patientId})">
                    <i class="fa fa-list"></i> Show Details
                </button>
                <button class="btn btn-success btn-xs" onclick="printPatientBilling(${patientId})">
                    <i class="fa fa-print"></i> Print Bill
                </button>
            </td>
        </tr>
    `;
    tbody.append(billingRow);

    // Add detailed billing sections
    addDetailedBillingSections(billingDetails, tbody);

    // Destroy existing DataTable if it exists
    if ($.fn.DataTable && $.fn.DataTable.isDataTable('#patientsTable')) {
        $('#patientsTable').DataTable().destroy();
    }

    // Don't reinitialize DataTable for single patient view
}

function addDetailedBillingSections(billingDetails, tbody) {
    // Consultations section
    if (billingDetails.consultations && billingDetails.consultations.length > 0) {
        var consultationsHeader = `
            <tr class="active">
                <td colspan="9">
                    <h5><i class="fa fa-stethoscope"></i> Consultations (${billingDetails.consultations.length} records)</h5>
                </td>
            </tr>
        `;
        tbody.append(consultationsHeader);

        billingDetails.consultations.forEach(function(consultation) {
            var consultationRow = `
                <tr>
                    <td colspan="2">
                        <strong>Date:</strong> ${formatDate(consultation.date)}<br>
                        <strong>Doctor:</strong> ${consultation.doctor_name || 'N/A'}<br>
                        <strong>Symptoms:</strong> ${consultation.symptoms || 'N/A'}
                    </td>
                    <td class="billing-cell consultation-col">
                        <span class="billing-amount">${currency_symbol}${formatNumber(consultation.amount || 0)}</span>
                    </td>
                    <td colspan="4">
                        <strong>Diagnosis:</strong> ${consultation.diagnosis || 'N/A'}
                    </td>
                    <td>
                        <span class="label label-${consultation.status === 'paid' ? 'success' : 'warning'}">${consultation.status || 'Pending'}</span>
                    </td>
                    <td class="text-right">
                        <button class="btn btn-xs btn-default" onclick="printConsultation(${consultation.id})">
                            <i class="fa fa-print"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(consultationRow);
        });
    }

    // Laboratory section
    if (billingDetails.laboratory && billingDetails.laboratory.length > 0) {
        var labHeader = `
            <tr class="active">
                <td colspan="9">
                    <h5><i class="fa fa-flask"></i> Laboratory Tests (${billingDetails.laboratory.length} records)</h5>
                </td>
            </tr>
        `;
        tbody.append(labHeader);

        billingDetails.laboratory.forEach(function(lab) {
            var labRow = `
                <tr>
                    <td colspan="2">
                        <strong>Date:</strong> ${formatDate(lab.date)}<br>
                        <strong>Test:</strong> ${lab.test_name || 'Lab Test'}<br>
                        <strong>Doctor:</strong> ${lab.doctor_name || 'N/A'}
                    </td>
                    <td colspan="2">
                        <span class="billing-amount">${currency_symbol}${formatNumber(lab.amount || 0)}</span>
                    </td>
                    <td class="billing-cell laboratory-col">
                        <span class="billing-amount">${currency_symbol}${formatNumber(lab.amount || 0)}</span>
                    </td>
                    <td colspan="2">
                        <strong>Result:</strong> ${lab.result || 'Pending'}
                    </td>
                    <td>
                        <span class="label label-${lab.status === 'Completed' ? 'success' : 'warning'}">${lab.status || 'Pending'}</span>
                    </td>
                    <td class="text-right">
                        <button class="btn btn-xs btn-default" onclick="printLabResult(${lab.id})">
                            <i class="fa fa-print"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(labRow);
        });
    }

    // Pharmacy section
    if (billingDetails.pharmacy && billingDetails.pharmacy.length > 0) {
        var pharmacyHeader = `
            <tr class="active">
                <td colspan="9">
                    <h5><i class="fa fa-medkit"></i> Pharmacy Bills (${billingDetails.pharmacy.length} records)</h5>
                </td>
            </tr>
        `;
        tbody.append(pharmacyHeader);

        billingDetails.pharmacy.forEach(function(pharmacy) {
            var pharmacyRow = `
                <tr>
                    <td colspan="2">
                        <strong>Date:</strong> ${formatDate(pharmacy.date)}<br>
                        <strong>Medications:</strong> ${pharmacy.medications || 'Pharmacy Bill'}<br>
                        <strong>Discount:</strong> ${currency_symbol}${formatNumber(pharmacy.discount || 0)}
                    </td>
                    <td colspan="3">
                        <span class="billing-amount">${currency_symbol}${formatNumber(pharmacy.amount || 0)}</span>
                    </td>
                    <td class="billing-cell pharmacy-col">
                        <span class="billing-amount">${currency_symbol}${formatNumber(pharmacy.amount || 0)}</span>
                    </td>
                    <td colspan="2">
                        <span class="label label-${pharmacy.status === 'Dispensed' ? 'success' : 'warning'}">${pharmacy.status || 'Pending'}</span>
                    </td>
                    <td class="text-right">
                        <button class="btn btn-xs btn-default" onclick="printPharmacyBill(${pharmacy.id})">
                            <i class="fa fa-print"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(pharmacyRow);
        });
    }

    // Radiology section
    if (billingDetails.radiology && billingDetails.radiology.length > 0) {
        var radiologyHeader = `
            <tr class="active">
                <td colspan="9">
                    <h5><i class="fa fa-radiologic"></i> Radiology Tests (${billingDetails.radiology.length} records)</h5>
                </td>
            </tr>
        `;
        tbody.append(radiologyHeader);

        billingDetails.radiology.forEach(function(radiology) {
            var radiologyRow = `
                <tr>
                    <td colspan="2">
                        <strong>Date:</strong> ${formatDate(radiology.date)}<br>
                        <strong>Scan:</strong> ${radiology.scan_name || 'Radiology Test'}<br>
                        <strong>Doctor:</strong> ${radiology.doctor_name || 'N/A'}
                    </td>
                    <td colspan="4">
                        <span class="billing-amount">${currency_symbol}${formatNumber(radiology.amount || 0)}</span>
                    </td>
                    <td class="billing-cell radiology-col">
                        <span class="billing-amount">${currency_symbol}${formatNumber(radiology.amount || 0)}</span>
                    </td>
                    <td>
                        <span class="label label-${radiology.status === 'Completed' ? 'success' : 'warning'}">${radiology.status || 'Pending'}</span>
                    </td>
                    <td class="text-right">
                        <button class="btn btn-xs btn-default" onclick="printRadiologyResult(${radiology.id})">
                            <i class="fa fa-print"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(radiologyRow);
        });
    }

    // If no services found
    if ((!billingDetails.consultations || billingDetails.consultations.length === 0) &&
        (!billingDetails.laboratory || billingDetails.laboratory.length === 0) &&
        (!billingDetails.pharmacy || billingDetails.pharmacy.length === 0) &&
        (!billingDetails.radiology || billingDetails.radiology.length === 0)) {
        
        var noServicesRow = `
            <tr>
                <td colspan="9" class="text-center text-muted">
                    <br><i class="fa fa-info-circle"></i> No detailed billing records found for this patient<br><br>
                </td>
            </tr>
        `;
        tbody.append(noServicesRow);
    }
}

function clearPatientSelection() {
    $('#selectedPatient').val('');
    $('#patientSearchInput').val('');
    loadPatientsList();
    successMsg('Showing all patients');
}

function toggleDetailedBilling(patientId) {
    // This function can be used to toggle detailed view if needed
    console.log('Toggle detailed billing for patient:', patientId);
}

// Print functions for individual services
function printConsultation(consultationId) {
    window.open('<?php echo base_url(); ?>admin/patient_billing/printConsultation/' + consultationId, '_blank');
}

function printLabResult(labId) {
    window.open('<?php echo base_url(); ?>admin/patient_billing/printLabResult/' + labId, '_blank');
}

function printPharmacyBill(pharmacyId) {
    window.open('<?php echo base_url(); ?>admin/patient_billing/printPharmacyBill/' + pharmacyId, '_blank');
}

function printRadiologyResult(radiologyId) {
    window.open('<?php echo base_url(); ?>admin/patient_billing/printRadiologyResult/' + radiologyId, '_blank');
}

function selectTests() {
    var patientId = $('#selectedPatient').val();
    if (!patientId) {
        warningMsg('Please select a patient first');
        return;
    }

    window.location.href = '<?php echo base_url(); ?>admin/pathology?patient_id=' + patientId;
}

function loadDashboardStats() {
    console.log('Loading dashboard stats...');
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getDashboardStats',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log('Dashboard stats response:', response);
            if (response.status === 'success') {
                $('#totalPatients').text(response.stats.total_patients || 0);
                $('#totalRevenue').text(currency_symbol + formatNumber(response.stats.total_revenue || 0));
                $('#todayConsultations').text(response.stats.today_consultations || 0);
                $('#pendingLabs').text(response.stats.pending_labs || 0);
            } else {
                console.error('Dashboard stats error:', response.message);
                errorMsg('Error loading dashboard stats: ' + (response.message || 'Unknown error'));
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading dashboard stats:', error);
            console.error('Response text:', xhr.responseText);
            $('#totalPatients').text('0');
            $('#totalRevenue').text(currency_symbol + '0.00');
            $('#todayConsultations').text('0');
            $('#pendingLabs').text('0');
            errorMsg('Network error loading dashboard stats');
        }
    });
}

function loadPatientsList() {
    console.log('Loading patients list...');
    var statusFilter = $('#statusFilter').val();
    var sortBy = $('#sortBy').val();

    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getAllPatientsWithBilling',
        type: 'GET',
        dataType: 'json',
        data: {
            status: statusFilter,
            sort: sortBy
        },
        beforeSend: function() {
            $('#patientsTableBody').html('<tr><td colspan="9" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading patients...</td></tr>');
        },
        success: function(response) {
            console.log('Patients list response:', response);
            if (response.status === 'success' && response.patients) {
                console.log('Number of patients loaded:', response.patients.length);
                displayPatientsList(response.patients);
            } else {
                console.error('Patients list error:', response.message);
                displayNoPatients('Error: ' + (response.message || 'Unknown error'));
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading patients:', error);
            console.error('Response text:', xhr.responseText);
            displayNoPatients('Network error occurred: ' + error);
        }
    });
}

function displayPatientsList(patients) {
    console.log('Displaying patients list:', patients.length, 'patients');
    var tbody = $('#patientsTableBody');
    tbody.empty();

    if (patients.length === 0) {
        displayNoPatients('No patients found');
        return;
    }

    $.each(patients, function(index, patient) {
        console.log('Processing patient:', patient.patient_name, 'with billing data:', {
            consultation: patient.consultation_total,
            lab: patient.lab_total,
            pharmacy: patient.pharmacy_total,
            radiology: patient.radiology_total,
            total: patient.total_billing
        });
        var row = createPatientRow(patient);
        tbody.append(row);
    });

    // Destroy existing DataTable if it exists
    if ($.fn.DataTable && $.fn.DataTable.isDataTable('#patientsTable')) {
        $('#patientsTable').DataTable().destroy();
    }

    // Initialize DataTable if available
    if ($.fn.DataTable) {
        try {
            $('#patientsTable').DataTable({
                searching: false,
                lengthChange: false,
                pageLength: 50,
                order: [[0, 'asc']],
                columnDefs: [
                    { orderable: false, targets: [8] }
                ],
                language: {
                    paginate: {
                        next: 'Next',
                        previous: 'Previous'
                    }
                }
            });
        } catch (e) {
            console.warn('DataTable initialization failed:', e);
        }
    }

    // Initialize tooltips
    if ($.fn.tooltip) {
        $('[data-toggle="tooltip"]').tooltip();
    }
}

function displayNoPatients(message) {
    var tbody = $('#patientsTableBody');
    tbody.html('<tr><td colspan="9" class="no-patients"><i class="fa fa-users"></i><p>' + (message || 'No patients found') + '</p></td></tr>');
}

function createPatientRow(patient) {
    console.log('Creating row for patient:', patient.patient_name);

    // Safely parse billing amounts
    var consultationAmount = parseFloat(patient.consultation_total || 0);
    var labAmount = parseFloat(patient.lab_total || 0);
    var pharmacyAmount = parseFloat(patient.pharmacy_total || 0);
    var radiologyAmount = parseFloat(patient.radiology_total || 0);
    var totalAmount = parseFloat(patient.total_billing || 0);
    var lastVisit = patient.last_visit ? formatDate(patient.last_visit) : 'Never';

    // Safe property access with fallbacks
    var patientName = patient.patient_name || 'Unknown';
    var patientId = patient.id || 'N/A';
    var age = patient.age || 'N/A';
    var gender = patient.gender || 'N/A';
    var bloodGroup = patient.blood_group_name || 'Unknown';
    var phone = patient.mobileno || 'N/A';
    var email = patient.email || '';
    var address = patient.address || '';

    return `
        <tr class="patient-row" data-patient-id="${patientId}">
            <td>
                <strong>${patientName}</strong><br>
                <small class="text-muted">
                    ID: ${patientId}<br>
                    ${age} years, ${gender}<br>
                    Blood: ${bloodGroup}
                </small>
            </td>
            <td>
                <i class="fa fa-phone"></i> ${phone}<br>
                ${email ? `<i class="fa fa-envelope"></i> ${email}<br>` : ''}
                ${address ? `<small class="text-muted">${address}</small>` : ''}
            </td>
            <td class="billing-cell consultation-col">
                ${consultationAmount > 0 ?
                    `<span class="billing-amount">${currency_symbol}${formatNumber(consultationAmount)}</span>` :
                    `<span class="billing-zero">0.00</span>`
                }
            </td>
            <td class="billing-cell laboratory-col">
                ${labAmount > 0 ?
                    `<span class="billing-amount">${currency_symbol}${formatNumber(labAmount)}</span>` :
                    `<span class="billing-zero">0.00</span>`
                }
            </td>
            <td class="billing-cell pharmacy-col">
                ${pharmacyAmount > 0 ?
                    `<span class="billing-amount">${currency_symbol}${formatNumber(pharmacyAmount)}</span>` :
                    `<span class="billing-zero">0.00</span>`
                }
            </td>
            <td class="billing-cell radiology-col">
                ${radiologyAmount > 0 ?
                    `<span class="billing-amount">${currency_symbol}${formatNumber(radiologyAmount)}</span>` :
                    `<span class="billing-zero">0.00</span>`
                }
            </td>
            <td class="billing-cell total-col">
                <span class="total-amount">${currency_symbol}${formatNumber(totalAmount)}</span>
            </td>
            <td>
                <small>${lastVisit}</small>
            </td>
            <td class="text-right">
                <a href="javascript:void(0)" class="btn btn-default btn-xs" onclick="viewBillingDetails(${patientId})"
                   data-toggle="tooltip" title="View Details">
                    <i class="fa fa-eye"></i>
                </a>
                <a href="javascript:void(0)" class="btn btn-default btn-xs" onclick="editPatient(${patientId})"
                   data-toggle="tooltip" title="Edit">
                    <i class="fa fa-pencil"></i>
                </a>
                <a href="javascript:void(0)" class="btn btn-default btn-xs" onclick="printPatientBilling(${patientId})"
                   data-toggle="tooltip" title="Print Bill">
                    <i class="fa fa-print"></i>
                </a>
            </td>
        </tr>
    `;
}

function viewBillingDetails(patientId) {
    console.log('Viewing billing details for patient:', patientId);
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getPatientBillingDetails',
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        beforeSend: function() {
            // Show loading indicator
            var loadingRow = '<tr id="loadingRow"><td colspan="9" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading billing details...</td></tr>';
            $('#patientsTableBody').append(loadingRow);
        },
        success: function(response) {
            console.log('Billing details response:', response);
            $('#loadingRow').remove();
            
            if (response.status === 'success') {
                displayBillingDetailsOnPage(response.billing_details, patientId);
            } else {
                errorMsg('Failed to load billing details: ' + (response.message || 'Unknown error'));
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading billing details:', error);
            console.error('Response text:', xhr.responseText);
            $('#loadingRow').remove();
            errorMsg('Error loading billing details: ' + error);
        }
    });
}

function displayBillingDetailsOnPage(details, patientId) {
    console.log('Displaying billing details:', details);
    
    // Remove any existing billing details
    $('.billing-details-row').remove();
    
    // Create billing details row
    var billingRow = `
        <tr class="billing-details-row">
            <td colspan="9">
                <div class="billing-summary">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                        <h5><i class="fa fa-calculator"></i> Detailed Billing Summary</h5>
                        <button type="button" class="btn btn-sm btn-default" onclick="closeBillingDetails()">
                            <i class="fa fa-times"></i> Close
                        </button>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="billing-item">
                                <span><i class="fa fa-stethoscope"></i> Consultations</span>
                                <span>${currency_symbol}${formatNumber(details.totals.consultations || 0)}</span>
                            </div>
                            <div class="billing-item">
                                <span><i class="fa fa-flask"></i> Laboratory</span>
                                <span>${currency_symbol}${formatNumber(details.totals.laboratory || 0)}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="billing-item">
                                <span><i class="fa fa-medkit"></i> Pharmacy</span>
                                <span>${currency_symbol}${formatNumber(details.totals.pharmacy || 0)}</span>
                            </div>
                            <div class="billing-item">
                                <span><i class="fa fa-radiologic"></i> Radiology</span>
                                <span>${currency_symbol}${formatNumber(details.totals.radiology || 0)}</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="billing-item" style="border-top: 2px solid #ddd; margin-top: 10px; padding-top: 10px;">
                        <span><strong><i class="fa fa-calculator"></i> Grand Total</strong></span>
                        <span><strong>${currency_symbol}${formatNumber(details.totals.grand_total || 0)}</strong></span>
                    </div>
                    
                    <!-- Service Details -->
                    <div style="margin-top: 20px;">
                        <div class="row">
                            ${createServiceDetailsSection('Consultations', details.consultations || [], 'stethoscope')}
                            ${createServiceDetailsSection('Laboratory', details.laboratory || [], 'flask')}
                            ${createServiceDetailsSection('Pharmacy', details.pharmacy || [], 'medkit')}
                            ${createServiceDetailsSection('Radiology', details.radiology || [], 'radiologic')}
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    `;
    
    // Find the patient row and insert details after it
    var patientRow = $('tr[data-patient-id="' + patientId + '"]');
    if (patientRow.length > 0) {
        patientRow.after(billingRow);
    } else {
        $('#patientsTableBody').append(billingRow);
    }
}

function createServiceDetailsSection(title, services, icon) {
    if (!services || services.length === 0) {
        return `
            <div class="col-md-6" style="margin-bottom: 15px;">
                <h6><i class="fa fa-${icon}"></i> ${title}</h6>
                <p class="text-muted"><em>No records found</em></p>
            </div>
        `;
    }
    
    var serviceHtml = `
        <div class="col-md-6" style="margin-bottom: 15px;">
            <h6><i class="fa fa-${icon}"></i> ${title} (${services.length} records)</h6>
            <div style="max-height: 200px; overflow-y: auto;">
                <table class="table table-condensed table-striped">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Service</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
    `;
    
    services.forEach(function(service) {
        var serviceName = service.test_name || service.medications || service.scan_name || service.type || 'Service';
        var amount = formatNumber(service.amount || 0);
        var date = formatDate(service.date);
        var status = service.status || 'Unknown';
        var statusClass = status.toLowerCase() === 'completed' ? 'success' : 'warning';
        
        serviceHtml += `
            <tr>
                <td><small>${date}</small></td>
                <td><small>${serviceName}</small></td>
                <td><small>${currency_symbol}${amount}</small></td>
                <td><small><span class="label label-${statusClass}">${status}</span></small></td>
            </tr>
        `;
    });
    
    serviceHtml += `
                    </tbody>
                </table>
            </div>
        </div>
    `;
    
    return serviceHtml;
}

function closeBillingDetails() {
    $('.billing-details-row').remove();
}

function addNewPatient() {
    var form = $('#addPatientForm');

    // Basic validation
    var patientName = $('#patient_name').val().trim();
    var age = $('#age').val().trim();
    var gender = $('#gender').val();
    var mobile = $('#mobileno').val().trim();

    if (!patientName) {
        errorMsg('Patient name is required');
        return;
    }
    if (!age) {
        errorMsg('Age is required');
        return;
    }
    if (!gender) {
        errorMsg('Gender is required');
        return;
    }
    if (!mobile) {
        errorMsg('Mobile number is required');
        return;
    }

    var formData = new FormData(form[0]);

    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/addPatient',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        beforeSend: function() {
            $('button[onclick="addNewPatient()"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        },
        success: function(response) {
            console.log('Add patient response:', response);
            if (response.status === 'success') {
                successMsg('Patient added successfully');
                $('#addPatientModal').modal('hide');
                form[0].reset();
                loadPatientsList();
                loadDashboardStats();
            } else {
                errorMsg(response.message || 'Failed to add patient');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error adding patient:', error);
            console.error('Response text:', xhr.responseText);
            errorMsg('Error adding patient: ' + error);
        },
        complete: function() {
            $('button[onclick="addNewPatient()"]').prop('disabled', false).html('<i class="fa fa-check"></i> Save');
        }
    });
}

function editPatient(patientId) {
    warningMsg('Edit functionality will be implemented in the next version');
}

function printBill(patientId) {
    printPatientBilling(patientId);
}

function printPatientBilling(patientId) {
    console.log('Printing patient billing for ID:', patientId);
    
    // Get patient billing details AND patient info from the backend
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getPatientFinancialReport',
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        beforeSend: function() {
            // Show loading message
            if (typeof toastr !== 'undefined') {
                toastr.info('Loading patient billing details...');
            }
        },
        success: function(response) {
            console.log('Financial report response:', response);
            
            if (response.status === 'success') {
                var patient = response.report.patient_info;
                var billingDetails = response.report.billing_details;
                
                console.log('Patient info:', patient);
                console.log('Billing details:', billingDetails);
                
                if (!patient) {
                    console.error('Patient info is missing from response');
                    errorMsg('Patient information not found in response');
                    return;
                }
                
                // Format patient details properly
                var patientName = patient.patient_name || 'Unknown Patient';
                var patientDetails = `ID: ${patient.id}, Phone: ${patient.mobileno || 'N/A'}, ${patient.age || 'N/A'}y, ${patient.gender || 'N/A'}`;
                
                console.log('Formatted patient name:', patientName);
                console.log('Formatted patient details:', patientDetails);
                
                generatePrintableBill(patientId, patientName, patientDetails, billingDetails, patient);
            } else {
                console.error('Financial report error:', response.message);
                errorMsg('Failed to load billing details for printing: ' + (response.message || 'Unknown error'));
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading billing details for printing:', error);
            console.error('Response text:', xhr.responseText);
            errorMsg('Error loading billing details for printing: ' + error);
        }
    });
}

function generatePrintableBill(patientId, patientName, patientDetails, billingDetails, patientInfo) {
    var currentDate = new Date().toLocaleDateString('en-GB');
    var currentTime = new Date().toLocaleTimeString('en-GB');
    
    var printContent = `
        <!DOCTYPE html>
        <html>
        <head>
            <title>Patient Billing Statement - ${patientName}</title>
            <style>
                body { 
                    font-family: Arial, sans-serif; 
                    margin: 20px; 
                    color: #333;
                    line-height: 1.4;
                }
                .header { 
                    text-align: center; 
                    margin-bottom: 30px; 
                    border-bottom: 2px solid #333;
                    padding-bottom: 20px;
                }
                .hospital-info {
                    text-align: center;
                    margin-bottom: 20px;
                }
                .hospital-info h1 {
                    color: #2c5aa0;
                    margin-bottom: 5px;
                }
                .patient-info { 
                    background: #f8f9fa;
                    padding: 15px; 
                    margin-bottom: 20px; 
                    border: 1px solid #ddd;
                    border-radius: 5px;
                }
                .billing-summary {
                    background: #e7f3ff;
                    padding: 15px;
                    margin-bottom: 20px;
                    border: 1px solid #b3d9ff;
                    border-radius: 5px;
                }
                .service-section { 
                    margin-bottom: 25px; 
                }
                .service-section h3 {
                    background: #2c5aa0;
                    color: white;
                    padding: 10px;
                    margin: 0 0 10px 0;
                    border-radius: 3px;
                }
                table { 
                    width: 100%; 
                    border-collapse: collapse; 
                    margin-bottom: 15px;
                }
                th, td { 
                    border: 1px solid #ddd; 
                    padding: 8px; 
                    text-align: left; 
                }
                th { 
                    background-color: #f2f2f2; 
                    font-weight: bold;
                }
                .amount { 
                    text-align: right; 
                    font-weight: bold;
                }
                .total-row {
                    background-color: #fff3cd;
                    font-weight: bold;
                }
                .grand-total {
                    background-color: #d4edda;
                    font-size: 16px;
                    font-weight: bold;
                }
                .footer {
                    margin-top: 40px;
                    text-align: center;
                    font-size: 12px;
                    color: #666;
                    border-top: 1px solid #ddd;
                    padding-top: 20px;
                }
                .status-completed { color: #28a745; font-weight: bold; }
                .status-pending { color: #ffc107; font-weight: bold; }
                .no-records { 
                    text-align: center; 
                    font-style: italic; 
                    color: #666; 
                    padding: 20px;
                }
                @media print {
                    body { margin: 0; }
                    .no-print { display: none; }
                }
            </style>
        </head>
        <body>
            <div class="hospital-info">
                <h1>Medisure 360</h1>
                <p>Comprehensive Healthcare Management System</p>
                <p>KP Flats Nairobi | Phone: +254798805300 | Email: hi@myne.co.ke</p>
            </div>
            
            <div class="header">
                <h2>PATIENT BILLING STATEMENT</h2>
                <p>Generated on: ${currentDate} at ${currentTime}</p>
            </div>
            
            <div class="patient-info">
                <h3>Patient Information</h3>
                <table>
                    <tr>
                        <td><strong>Patient Name:</strong></td>
                        <td>${patientName}</td>
                        <td><strong>Patient ID:</strong></td>
                        <td>${patientId}</td>
                    </tr>
                    <tr>
                        <td><strong>Age:</strong></td>
                        <td>${patientInfo.age || 'N/A'} years</td>
                        <td><strong>Gender:</strong></td>
                        <td>${patientInfo.gender || 'N/A'}</td>
                    </tr>
                    <tr>
                        <td><strong>Phone:</strong></td>
                        <td>${patientInfo.mobileno || 'N/A'}</td>
                        <td><strong>Blood Group:</strong></td>
                        <td>${patientInfo.blood_group_name || 'N/A'}</td>
                    </tr>
                    <tr>
                        <td><strong>Email:</strong></td>
                        <td>${patientInfo.email || 'N/A'}</td>
                        <td><strong>Address:</strong></td>
                        <td>${patientInfo.address || 'N/A'}</td>
                    </tr>
                </table>
            </div>
            
            <div class="billing-summary">
                <h3>Billing Summary</h3>
                <table>
                    <tr>
                        <th>Service Type</th>
                        <th>Number of Records</th>
                        <th class="amount">Total Amount</th>
                    </tr>
                    <tr>
                        <td><i>🩺</i> Consultations</td>
                        <td>${(billingDetails.consultations || []).length}</td>
                        <td class="amount">${currency_symbol}${formatNumber(billingDetails.totals.consultations || 0)}</td>
                    </tr>
                    <tr>
                        <td><i>🧪</i> Laboratory Tests</td>
                        <td>${(billingDetails.laboratory || []).length}</td>
                        <td class="amount">${currency_symbol}${formatNumber(billingDetails.totals.laboratory || 0)}</td>
                    </tr>
                    <tr>
                        <td><i>💊</i> Pharmacy</td>
                        <td>${(billingDetails.pharmacy || []).length}</td>
                        <td class="amount">${currency_symbol}${formatNumber(billingDetails.totals.pharmacy || 0)}</td>
                    </tr>
                    <tr>
                        <td><i>📡</i> Radiology</td>
                        <td>${(billingDetails.radiology || []).length}</td>
                        <td class="amount">${currency_symbol}${formatNumber(billingDetails.totals.radiology || 0)}</td>
                    </tr>
                    <tr class="grand-total">
                        <td colspan="2"><strong>GRAND TOTAL</strong></td>
                        <td class="amount"><strong>${currency_symbol}${formatNumber(billingDetails.totals.grand_total || 0)}</strong></td>
                    </tr>
                </table>
            </div>
    `;
    
    // Add detailed sections
    printContent += generatePrintableSection('Consultations', billingDetails.consultations || [], 'consultation');
    printContent += generatePrintableSection('Laboratory Tests', billingDetails.laboratory || [], 'laboratory');
    printContent += generatePrintableSection('Pharmacy Bills', billingDetails.pharmacy || [], 'pharmacy');
    printContent += generatePrintableSection('Radiology Tests', billingDetails.radiology || [], 'radiology');
    
    printContent += `
            <div class="footer">
                <p>This is a computer-generated billing statement from Medisure 360</p>
                <p>For any queries regarding this bill, please contact us at +254798805300</p>
                <p>Generated on ${currentDate} at ${currentTime}</p>
            </div>
        </body>
        </html>
    `;
    
    // Open print window
    var printWindow = window.open('', '_blank', 'width=800,height=600');
    printWindow.document.write(printContent);
    printWindow.document.close();
    printWindow.focus();
    
    // Auto-print after content loads
    setTimeout(function() {
        printWindow.print();
    }, 500);
}

function generatePrintableSection(title, records, type) {
    if (!records || records.length === 0) {
        return `
            <div class="service-section">
                <h3>${title}</h3>
                <div class="no-records">No ${title.toLowerCase()} records found</div>
            </div>
        `;
    }
    
    var sectionHtml = `
        <div class="service-section">
            <h3>${title} (${records.length} records)</h3>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Description</th>
                        <th>Details</th>
                        <th class="amount">Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
    `;
    
    var sectionTotal = 0;
    
    records.forEach(function(record) {
        var amount = parseFloat(record.amount || 0);
        sectionTotal += amount;
        
        var description = '';
        var details = '';
        
        switch(type) {
            case 'consultation':
                description = 'Medical Consultation';
                details = `Doctor: ${record.doctor_name || 'N/A'}<br>Symptoms: ${record.symptoms || 'N/A'}<br>Diagnosis: ${record.diagnosis || 'N/A'}`;
                break;
            case 'laboratory':
                description = record.test_name || 'Laboratory Test';
                details = `Doctor: ${record.doctor_name || 'N/A'}<br>Result: ${record.result || 'Pending'}`;
                break;
            case 'pharmacy':
                description = record.medications || 'Pharmacy Bill';
                details = `Discount: ${currency_symbol}${formatNumber(record.discount || 0)}`;
                break;
            case 'radiology':
                description = record.scan_name || 'Radiology Test';
                details = `Doctor: ${record.doctor_name || 'N/A'}<br>Result: ${record.result || 'Pending'}`;
                break;
        }
        
        var statusClass = (record.status || '').toLowerCase() === 'completed' ? 'status-completed' : 'status-pending';
        
        sectionHtml += `
            <tr>
                <td>${formatDate(record.date)}</td>
                <td>${description}</td>
                <td>${details}</td>
                <td class="amount">${currency_symbol}${formatNumber(amount)}</td>
                <td><span class="${statusClass}">${record.status || 'Pending'}</span></td>
            </tr>
        `;
    });
    
    sectionHtml += `
                    <tr class="total-row">
                        <td colspan="3"><strong>${title} Subtotal</strong></td>
                        <td class="amount"><strong>${currency_symbol}${formatNumber(sectionTotal)}</strong></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    `;
    
    return sectionHtml;
}

function showDetailedBilling(patientId) {
    // This will expand/collapse detailed view - for now just scroll to details
    var detailsSection = $('.billing-details-row');
    if (detailsSection.length > 0) {
        $('html, body').animate({
            scrollTop: detailsSection.offset().top - 100
        }, 500);
    }
}

function exportBillingData() {
    window.location.href = '<?php echo base_url(); ?>admin/patient_billing/exportBillingData';
}

function refreshPatientsList() {
    console.log('Refreshing patients list...');
    loadPatientsList();
    loadDashboardStats();
    successMsg('Data refreshed successfully');
}

// Utility functions
function formatNumber(number) {
    try {
        return new Intl.NumberFormat('en-KE', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }).format(parseFloat(number) || 0);
    } catch (e) {
        // Fallback if Intl is not supported
        var num = parseFloat(number) || 0;
        return num.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ',');
    }
}

function formatDate(dateString) {
    if (!dateString) return 'N/A';
    try {
        var date = new Date(dateString);
        if (isNaN(date.getTime())) return 'N/A';
        
        return date.toLocaleDateString('en-GB', {
            day: '2-digit',
            month: '2-digit',
            year: 'numeric'
        });
    } catch (e) {
        return 'N/A';
    }
}

// Message functions with fallbacks
function successMsg(message) {
    console.log('Success:', message);
    if (typeof toastr !== 'undefined') {
        toastr.success(message);
    } else if (typeof $.notify !== 'undefined') {
        $.notify({
            message: message
        }, {
            type: 'success',
            allow_dismiss: true,
            delay: 5000
        });
    } else {
        alert('Success: ' + message);
    }
}

function errorMsg(message) {
    console.error('Error:', message);
    if (typeof toastr !== 'undefined') {
        toastr.error(message);
    } else if (typeof $.notify !== 'undefined') {
        $.notify({
            message: message
        }, {
            type: 'danger',
            allow_dismiss: true,
            delay: 5000
        });
    } else {
        alert('Error: ' + message);
    }
}

function warningMsg(message) {
    console.warn('Warning:', message);
    if (typeof toastr !== 'undefined') {
        toastr.warning(message);
    } else if (typeof $.notify !== 'undefined') {
        $.notify({
            message: message
        }, {
            type: 'warning',
            allow_dismiss: true,
            delay: 5000
        });
    } else {
        alert('Warning: ' + message);
    }
}

// Debug function for troubleshooting
function debugPatientData() {
    console.log('=== DEBUG PATIENT DATA ===');
    
    // Test dashboard stats
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getDashboardStats',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log('Dashboard Stats Test:', response);
        },
        error: function(xhr, status, error) {
            console.error('Dashboard Stats Error:', error, xhr.responseText);
        }
    });
    
    // Test patients list
    $.ajax({
        url: '<?php echo base_url(); ?>admin/patient_billing/getAllPatientsWithBilling',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log('Patients List Test:', response);
        },
        error: function(xhr, status, error) {
            console.error('Patients List Error:', error, xhr.responseText);
        }
    });
}

// Make debug function available globally
window.debugPatientData = debugPatientData;
</script>