<?php
$currency_symbol = 'KES';
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Agent Patient Registration - Medical Tourism</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper { background-color: #ecf0f5; }
        
        .agent-header {
            background: linear-gradient(135deg, #e74c3c 0%, #f39c12 100%);
            color: white; padding: 20px; border-radius: 3px; margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .workflow-step {
            padding: 15px; border-bottom: 1px solid #f4f4f4; display: flex;
            align-items: center; transition: background-color 0.3s ease;
        }
        
        .workflow-step:hover { background-color: #f9f9f9; }
        .workflow-step:last-child { border-bottom: none; }
        
        .step-number {
            background: #e74c3c; color: white; width: 30px; height: 30px;
            border-radius: 50%; display: flex; align-items: center;
            justify-content: center; margin-right: 15px; font-weight: bold;
            font-size: 14px; box-shadow: 0 2px 4px rgba(231,76,60,0.3);
        }
        
        .step-content h6 {
            margin: 0 0 5px 0; color: #333; font-weight: 600; font-size: 16px;
        }
        
        .step-content small { color: #777; font-size: 13px; }
        
        .agent-selection {
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            border: 2px solid #e74c3c; border-radius: 8px; padding: 25px;
            margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .agent-card {
            border: 2px dashed #ddd; border-radius: 8px; padding: 20px;
            background: white; text-align: center; margin-bottom: 15px;
            min-height: 120px; display: flex; align-items: center;
            justify-content: center; flex-direction: column;
            transition: border-color 0.3s ease; cursor: pointer;
        }
        
        .agent-card:hover { border-color: #e74c3c; }
        .agent-card.selected { border-color: #e74c3c; background-color: #fff5f5; }
        
        .country-selection {
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            border: 2px solid #f39c12; border-radius: 8px; padding: 25px;
            margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            display: none;
        }
        
        .country-option {
            border: 2px dashed #ddd; border-radius: 8px; padding: 15px;
            background: white; margin-bottom: 12px;
            cursor: pointer; transition: all 0.3s ease;
        }
        
        .country-option:hover { border-color: #f39c12; }
        .country-option.selected { border-color: #f39c12; background-color: #fef9e7; }
        
        .country-flag {
            width: 24px; height: 16px; margin-right: 10px; border: 1px solid #ddd;
        }
        
        .cost-breakdown {
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            border: 2px solid #28a745; border-radius: 8px; padding: 25px;
            margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            display: none;
        }
        
        .cost-item {
            display: flex; justify-content: space-between; margin-bottom: 10px;
            padding: 8px 0; border-bottom: 1px solid #dee2e6;
        }
        
        .cost-item:last-child {
            border-bottom: none; font-weight: bold; font-size: 1.1em; color: #28a745;
        }
        
        .alert-quota {
            background: #fff3cd; border: 1px solid #ffeaa7; color: #856404;
            padding: 12px; border-radius: 6px; margin-top: 10px;
        }
        
        .alert-quota.warning {
            background: #f8d7da; border-color: #f5c6cb; color: #721c24;
        }
        
        .progress { height: 20px; margin-top: 5px; }
        
        .required { color: #dd4b39; font-weight: bold; }
        
        .btn-agent {
            background: linear-gradient(135deg, #e74c3c, #c0392b);
            border: none; color: white; font-weight: 600; padding: 12px 24px;
            border-radius: 6px; transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(231,76,60,0.3);
        }
        
        .btn-agent:hover {
            background: linear-gradient(135deg, #c0392b, #a93226);
            color: white; transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(231,76,60,0.4);
        }
        
        .cost-display {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white; padding: 12px 20px; border-radius: 20px;
            font-weight: bold; text-align: center; font-size: 16px;
            backdrop-filter: blur(10px);
        }
        
        .medical-purpose {
            background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 6px;
            padding: 15px; margin-bottom: 15px;
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                <i class="fa fa-plane"></i> Agent Patient Registration
                <small>Medical Tourism Registration Process</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="<?php echo base_url(); ?>admin/patient/search">Patient</a></li>
                <li class="active">Agent Registration</li>
            </ol>
        </section>

        <section class="content">
            <!-- Agent Header -->
            <div class="agent-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-plane"></i> Agent Patient Registration</h3>
                        <p class="margin-bottom-none">Medical tourism registration through authorized agents with pre-negotiated rates and commission tracking</p>
                        <div class="progress-indicator">
                            <div class="progress">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: 20%;" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100">
                                    Step 1 of 5: Agent & Destination Selection
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="cost-display">
                            <i class="fa fa-money"></i> Base Rate: <span id="display-rate">KES 0</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Workflow Steps -->
            <div class="box box-danger">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-route"></i> Medical Tourism Registration Workflow</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-danger">Agent Required</span>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="workflow-step">
                                <div class="step-number">1</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-md"></i> Agent & Destination Selection</h6>
                                    <small>Select authorized agent and destination country with rates</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">2</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-plus"></i> Patient Registration</h6>
                                    <small>Complete patient details and identification information</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">3</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-heartbeat"></i> Medical Information</h6>
                                    <small>Purpose of travel and medical requirements</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="workflow-step">
                                <div class="step-number">4</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-calendar"></i> Travel Planning</h6>
                                    <small>Travel dates and special requirements</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">5</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-check-circle"></i> Final Registration</h6>
                                    <small>Review and complete registration process</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

                        <!-- Registration Form -->
                        <form id="agentRegistrationForm" action="<?php echo base_url(); ?>admin/patient/add_agent_patient" method="post" enctype="multipart/form-data">
                            <!-- Hidden fields -->
                            <input type="hidden" name="workflow_type" value="agent">
                            <input type="hidden" name="patient_type" value="Agent Referral">
                            <input type="hidden" name="selected_agent_id" id="selected_agent_id">
                            <input type="hidden" name="selected_contract_id" id="selected_contract_id">
                            <input type="hidden" name="selected_country_id" id="selected_country_id">
                            <input type="hidden" name="total_cost" id="total_cost">
                            <input type="hidden" name="agent_commission" id="agent_commission">
                            <input type="hidden" name="hospital_amount" id="hospital_amount">

                            <!-- Agent Selection -->
                            <div class="box box-danger">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-user-md"></i> Step 1: Select Agent</h3>
                                    <div class="box-tools pull-right">
                                        <span class="label label-danger">Required</span>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="agent-selection">
                                        <div class="row" id="agents-list">
                                            <!-- Agents will be loaded here via AJAX -->
                                        </div>
                                        <div class="text-center" id="agents-loading">
                                            <i class="fa fa-spinner fa-spin"></i> Loading agents...
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Country/Destination Selection -->
                            <div class="box box-warning">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-globe"></i> Step 2: Select Destination Country</h3>
                                    <div class="box-tools pull-right">
                                        <span class="label label-warning">Select Agent First</span>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="country-selection" id="country-selection">
                                        <div id="countries-list">
                                            <!-- Countries will be populated based on selected agent -->
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Cost Breakdown -->
                            <div class="box box-success">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-calculator"></i> Step 3: Cost Breakdown</h3>
                                    <div class="box-tools pull-right">
                                        <span class="label label-success">Auto-Calculated</span>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="cost-breakdown" id="cost-breakdown">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="cost-item">
                                                    <span>Total Package Cost:</span>
                                                    <span id="display-total-cost">KES 0.00</span>
                                                </div>
                                                <div class="cost-item">
                                                    <span>Agent Commission:</span>
                                                    <span id="display-agent-commission">KES 0.00</span>
                                                </div>
                                                <div class="cost-item">
                                                    <span>Hospital Amount:</span>
                                                    <span id="display-hospital-amount">KES 0.00</span>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div id="contract-info">
                                                    <!-- Contract details will be displayed here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Patient Information -->
                            <div class="box box-primary">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-user"></i> Step 4: Patient Information</h3>
                                    <div class="box-tools pull-right">
                                        <span class="label label-primary">Required Fields</span>
                                    </div>
                                </div>
                                <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Patient Name <span class="required">*</span></label>
                                            <input type="text" name="name" class="form-control" placeholder="Enter full patient name" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Date of Birth <span class="required">*</span></label>
                                            <input type="date" name="dob" id="patient_dob" class="form-control" required max="<?php echo date('Y-m-d'); ?>">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Gender <span class="required">*</span></label>
                                            <select name="gender" class="form-control" required>
                                                <option value="">Select Gender</option>
                                                <option value="Male">Male</option>
                                                <option value="Female">Female</option>
                                                <option value="Other">Other</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Mobile Number <span class="required">*</span></label>
                                            <input type="tel" name="mobileno" class="form-control" placeholder="+254 700 000 000" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Email Address</label>
                                            <input type="email" name="email" class="form-control" placeholder="patient@example.com">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Passport/ID Number <span class="required">*</span></label>
                                            <input type="text" name="identification_number" class="form-control" placeholder="Passport or National ID" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Guardian/Next of Kin</label>
                                            <input type="text" name="guardian_name" class="form-control" placeholder="Guardian name">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Blood Group</label>
                                            <select name="blood_group" class="form-control">
                                                <option value="">Select Blood Group</option>
                                                <option value="A+">A+</option>
                                                <option value="A-">A-</option>
                                                <option value="B+">B+</option>
                                                <option value="B-">B-</option>
                                                <option value="AB+">AB+</option>
                                                <option value="AB-">AB-</option>
                                                <option value="O+">O+</option>
                                                <option value="O-">O-</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Known Allergies</label>
                                            <input type="text" name="known_allergies" class="form-control" placeholder="Any known allergies">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Address</label>
                                            <textarea name="address" class="form-control" rows="3" placeholder="Patient address"></textarea>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>

                            <!-- Medical Information -->
                            <div class="box box-info">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-heartbeat"></i> Step 5: Medical & Travel Information</h3>
                                    <div class="box-tools pull-right">
                                        <span class="label label-info">Medical Purpose Required</span>
                                    </div>
                                </div>
                                <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Medical Purpose <span class="required">*</span></label>
                                            <div class="medical-purpose">
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="medical_purpose[]" value="Surgery"> Surgical Treatment</label>
                                                </div>
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="medical_purpose[]" value="Consultation"> Specialist Consultation</label>
                                                </div>
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="medical_purpose[]" value="Diagnosis"> Advanced Diagnostics</label>
                                                </div>
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="medical_purpose[]" value="Treatment"> Medical Treatment</label>
                                                </div>
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="medical_purpose[]" value="Emergency"> Emergency Care</label>
                                                </div>
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="medical_purpose[]" value="Other"> Other</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Planned Travel Date</label>
                                            <input type="date" name="travel_date" class="form-control" min="<?php echo date('Y-m-d'); ?>">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Expected Return Date</label>
                                            <input type="date" name="return_date" class="form-control" min="<?php echo date('Y-m-d'); ?>">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Detailed Medical Condition/Reason</label>
                                            <textarea name="medical_condition" class="form-control" rows="4" placeholder="Describe the medical condition or reason for travel"></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Special Requirements</label>
                                            <textarea name="special_requirements" class="form-control" rows="3" placeholder="Any special requirements (wheelchair access, dietary restrictions, etc.)"></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Notes</label>
                                            <textarea name="notes" class="form-control" rows="2" placeholder="Additional notes"></textarea>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>

                            <!-- Submit Section -->
                            <div class="box box-success">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-check-circle"></i> Complete Registration</h3>
                                </div>
                                <div class="box-body text-center">
                                    <button type="submit" class="btn btn-agent btn-lg" id="register-btn" disabled>
                                        <i class="fa fa-check-circle"></i> Register Patient for Medical Tourism
                                    </button>
                                    <div style="margin-top: 15px;">
                                        <small class="text-muted">Please complete all required fields and selections above</small>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <!-- Scripts -->
    <script src="<?php echo base_url(); ?>backend/plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/dist/js/app.min.js"></script>

    <script>
    $(document).ready(function() {
        // Load agents on page load
        loadAgents();
        
        // Agent selection handler
        $(document).on('click', '.agent-card', function() {
            $('.agent-card').removeClass('selected');
            $(this).addClass('selected');
            
            const agentId = $(this).data('agent-id');
            $('#selected_agent_id').val(agentId);
            
            // Load countries for selected agent
            loadAgentCountries(agentId);
            $('#country-selection').slideDown();
            
            // Reset other selections
            resetCountrySelection();
            resetCostBreakdown();
        });
        
        // Country selection handler
        $(document).on('click', '.country-option', function() {
            $('.country-option').removeClass('selected');
            $(this).addClass('selected');
            
            const contractId = $(this).data('contract-id');
            const countryId = $(this).data('country-id');
            
            $('#selected_contract_id').val(contractId);
            $('#selected_country_id').val(countryId);
            
            // Load cost breakdown
            loadCostBreakdown(contractId);
            $('#cost-breakdown').slideDown();
            
            // Enable form validation
            validateForm();
        });
        
        // Form validation
        $('#agentRegistrationForm input[required], #agentRegistrationForm select[required]').on('input change', function() {
            validateForm();
        });
        
        // Medical purpose validation
        $('input[name="medical_purpose[]"]').on('change', function() {
            validateForm();
        });
        
        // Form submission
        $('#agentRegistrationForm').on('submit', function(e) {
            e.preventDefault();
            submitRegistration();
        });
        
        function loadAgents() {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/agent/get_active_agents',
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        displayAgents(response.agents);
                    } else {
                        $('#agents-list').html('<div class="col-md-12"><div class="alert alert-warning">No active agents found</div></div>');
                    }
                    $('#agents-loading').hide();
                },
                error: function() {
                    $('#agents-list').html('<div class="col-md-12"><div class="alert alert-danger">Error loading agents</div></div>');
                    $('#agents-loading').hide();
                }
            });
        }
        
        function displayAgents(agents) {
            let html = '';
            agents.forEach(function(agent) {
                html += `
                    <div class="col-md-6">
                        <div class="agent-card" data-agent-id="${agent.id}">
                            <div class="row">
                                <div class="col-md-8">
                                    <h4 style="margin: 0 0 5px 0; color: #333;">${agent.agent_name}</h4>
                                    <p style="margin: 0; color: #666; font-size: 14px;">${agent.company_name || ''}</p>
                                    <small style="color: #999;">Code: ${agent.agent_code}</small>
                                </div>
                                <div class="col-md-4 text-right">
                                    <span class="badge badge-success">${agent.status}</span>
                                    <div style="margin-top: 5px;">
                                        <small style="color: #666;">
                                            <i class="fa fa-phone"></i> ${agent.phone || 'N/A'}
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            });
            $('#agents-list').html(html);
        }
        
        function loadAgentCountries(agentId) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/agent/get_agent_countries',
                type: 'POST',
                data: { agent_id: agentId },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        displayCountries(response.countries);
                    } else {
                        $('#countries-list').html('<div class="alert alert-warning">No available destinations for this agent</div>');
                    }
                },
                error: function() {
                    $('#countries-list').html('<div class="alert alert-danger">Error loading countries</div>');
                }
            });
        }
        
        function displayCountries(countries) {
            let html = '';
            countries.forEach(function(country) {
                const remaining = country.patient_limit - country.patients_registered;
                const percentage = country.patient_limit > 0 ? 
                    Math.round((country.patients_registered / country.patient_limit) * 100) : 0;
                
                let quotaClass = '';
                let quotaText = '';
                
                if (remaining <= 0) {
                    quotaClass = 'warning';
                    quotaText = 'QUOTA FULL';
                } else if (percentage > 80) {
                    quotaClass = 'warning';
                    quotaText = 'QUOTA ALMOST FULL';
                } else {
                    quotaText = `${remaining} slots remaining`;
                }
                
                html += `
                    <div class="country-option ${remaining <= 0 ? 'disabled' : ''}" 
                         data-contract-id="${country.contract_id}" 
                         data-country-id="${country.country_id}"
                         ${remaining <= 0 ? 'style="opacity: 0.5; cursor: not-allowed;"' : ''}>
                        <div class="row" style="width: 100%;">
                            <div class="col-md-2">
                                <img src="<?php echo base_url(); ?>assets/images/flags/${country.country_code.toLowerCase()}.png" 
                                     class="country-flag" alt="${country.country_code}"
                                     onerror="this.src='<?php echo base_url(); ?>assets/images/flags/default.png'">
                            </div>
                            <div class="col-md-6">
                                <h5 style="margin: 0; color: #333;">${country.country_name}</h5>
                                <p style="margin: 0; color: #666; font-size: 14px;">${country.contract_name}</p>
                                <small style="color: #999;">Cost: ${country.currency_code} ${parseFloat(country.total_cost_per_patient).toLocaleString()}</small>
                            </div>
                            <div class="col-md-4 text-right">
                                <div class="alert-quota ${quotaClass}" style="margin: 0; padding: 5px 8px;">
                                    <small><strong>${quotaText}</strong></small>
                                </div>
                                <div class="progress" style="height: 8px; margin-top: 5px;">
                                    <div class="progress-bar ${percentage > 80 ? 'progress-bar-danger' : percentage > 60 ? 'progress-bar-warning' : 'progress-bar-success'}" 
                                         style="width: ${percentage}%"></div>
                                </div>
                                <small style="color: #666;">${country.patients_registered}/${country.patient_limit} patients</small>
                            </div>
                        </div>
                    </div>
                `;
            });
            $('#countries-list').html(html);
        }
        
        function loadCostBreakdown(contractId) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/agent/get_contract_details',
                type: 'POST',
                data: { contract_id: contractId },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        const contract = response.contract;
                        displayCostBreakdown(contract);
                        
                        // Set hidden form values
                        $('#total_cost').val(contract.total_cost_per_patient);
                        $('#agent_commission').val(contract.agent_commission_per_patient);
                        $('#hospital_amount').val(contract.hospital_amount_per_patient);
                    }
                },
                error: function() {
                    alert('Error loading contract details');
                }
            });
        }
        
        function displayCostBreakdown(contract) {
            // Always display in KES format as default for this system
            const currencySymbol = 'KES ';
            
            $('#display-total-cost').text(currencySymbol + parseFloat(contract.total_cost_per_patient).toLocaleString());
            $('#display-agent-commission').text(currencySymbol + parseFloat(contract.agent_commission_per_patient).toLocaleString());
            $('#display-hospital-amount').text(currencySymbol + parseFloat(contract.hospital_amount_per_patient).toLocaleString());
            
            const contractInfo = `
                <h5>Contract Details</h5>
                <p><strong>Contract:</strong> ${contract.contract_name}</p>
                <p><strong>Agent:</strong> ${contract.agent_name} (${contract.agent_code})</p>
                <p><strong>Destination:</strong> ${contract.country_name}</p>
                <p><strong>Remaining Quota:</strong> ${contract.remaining_slots} patients</p>
                <p><strong>Contract Valid Until:</strong> ${new Date(contract.contract_end_date).toLocaleDateString()}</p>
                ${contract.needs_renewal ? '<div class="alert alert-warning"><small>Contract expires in ' + contract.days_to_expiry + ' days</small></div>' : ''}
            `;
            
            $('#contract-info').html(contractInfo);
        }
        
        function resetCountrySelection() {
            $('.country-option').removeClass('selected');
            $('#selected_contract_id').val('');
            $('#selected_country_id').val('');
        }
        
        function resetCostBreakdown() {
            $('#cost-breakdown').slideUp();
            $('#total_cost').val('');
            $('#agent_commission').val('');
            $('#hospital_amount').val('');
        }
        
        function validateForm() {
            const agentSelected = $('#selected_agent_id').val();
            const countrySelected = $('#selected_contract_id').val();
            const nameField = $('input[name="name"]').val().trim();
            const dobField = $('input[name="dob"]').val();
            const genderField = $('select[name="gender"]').val();
            const phoneField = $('input[name="mobileno"]').val().trim();
            const idField = $('input[name="identification_number"]').val().trim();
            const medicalPurpose = $('input[name="medical_purpose[]"]:checked').length > 0;
            
            const allValid = agentSelected && countrySelected && nameField && dobField && 
                           genderField && phoneField && idField && medicalPurpose;
            
            $('#register-btn').prop('disabled', !allValid);
        }
        
        function submitRegistration() {
            const formData = new FormData($('#agentRegistrationForm')[0]);
            const btn = $('#register-btn');
            const originalText = btn.html();
            
            btn.html('<i class="fa fa-spinner fa-spin"></i> Registering Patient...').prop('disabled', true);
            
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/add_agent_patient',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        alert('Patient registered successfully!\nRegistration Number: ' + response.registration_number);
                        // Reset form or redirect
                        window.location.reload();
                    } else {
                        alert('Registration failed: ' + response.message);
                    }
                    btn.html(originalText).prop('disabled', false);
                },
                error: function(xhr) {
                    alert('Registration failed. Please try again.');
                    btn.html(originalText).prop('disabled', false);
                }
            });
        }
    });
    </script>
</body>
</html>