<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> Nursing Reports
            <small>Comprehensive Nursing Analytics and Documentation</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/nursing"><i class="fa fa-stethoscope"></i> Nursing</a></li>
            <li class="active">Reports</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Statistics Overview Row -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo $daily_stats['vital_signs'] ?? 0; ?></h3>
                        <p>Vital Signs Today</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-heartbeat"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $daily_stats['procedures'] ?? 0; ?></h3>
                        <p>Procedures Completed</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-tasks"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $daily_stats['nursing_notes'] ?? 0; ?></h3>
                        <p>Nursing Notes</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-edit"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $daily_stats['assessments'] ?? 0; ?></h3>
                        <p>Assessments Done</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clipboard"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Reports Row -->
        <div class="row">
            <!-- Procedure Statistics -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-tasks"></i> Procedure Statistics (Last 30 Days)
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($procedure_stats)): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Procedure Type</th>
                                            <th>Status</th>
                                            <th>Count</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($procedure_stats as $stat): ?>
                                            <tr>
                                                <td><?php echo ucfirst(str_replace('_', ' ', $stat['procedure_type'])); ?></td>
                                                <td>
                                                    <?php 
                                                    $status_class = '';
                                                    switch($stat['status']) {
                                                        case 'completed': $status_class = 'label-success'; break;
                                                        case 'in_progress': $status_class = 'label-warning'; break;
                                                        case 'scheduled': $status_class = 'label-info'; break;
                                                        case 'cancelled': $status_class = 'label-danger'; break;
                                                        default: $status_class = 'label-default';
                                                    }
                                                    ?>
                                                    <span class="label <?php echo $status_class; ?>">
                                                        <?php echo ucfirst(str_replace('_', ' ', $stat['status'])); ?>
                                                    </span>
                                                </td>
                                                <td><strong><?php echo $stat['count']; ?></strong></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No procedure data available for the last 30 days.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Staff Workload -->
            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-users"></i> Staff Workload (Last 7 Days)
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Procedures Tab -->
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#procedures-tab" data-toggle="tab">Procedures</a></li>
                                <li><a href="#notes-tab" data-toggle="tab">Notes</a></li>
                                <li><a href="#assessments-tab" data-toggle="tab">Assessments</a></li>
                            </ul>
                            <div class="tab-content">
                                <div class="active tab-pane" id="procedures-tab">
                                    <?php if (!empty($staff_workload['procedures'])): ?>
                                        <table class="table table-condensed">
                                            <thead>
                                                <tr>
                                                    <th>Staff Name</th>
                                                    <th>Procedures</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($staff_workload['procedures'] as $staff): ?>
                                                    <tr>
                                                        <td><?php echo $staff['name'] . ' ' . $staff['surname']; ?></td>
                                                        <td><span class="badge bg-blue"><?php echo $staff['procedure_count']; ?></span></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    <?php else: ?>
                                        <p class="text-muted">No procedure data available.</p>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="tab-pane" id="notes-tab">
                                    <?php if (!empty($staff_workload['nursing_notes'])): ?>
                                        <table class="table table-condensed">
                                            <thead>
                                                <tr>
                                                    <th>Staff Name</th>
                                                    <th>Notes</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($staff_workload['nursing_notes'] as $staff): ?>
                                                    <tr>
                                                        <td><?php echo $staff['name'] . ' ' . $staff['surname']; ?></td>
                                                        <td><span class="badge bg-green"><?php echo $staff['note_count']; ?></span></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    <?php else: ?>
                                        <p class="text-muted">No nursing notes data available.</p>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="tab-pane" id="assessments-tab">
                                    <?php if (!empty($staff_workload['assessments'])): ?>
                                        <table class="table table-condensed">
                                            <thead>
                                                <tr>
                                                    <th>Staff Name</th>
                                                    <th>Assessments</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($staff_workload['assessments'] as $staff): ?>
                                                    <tr>
                                                        <td><?php echo $staff['name'] . ' ' . $staff['surname']; ?></td>
                                                        <td><span class="badge bg-yellow"><?php echo $staff['assessment_count']; ?></span></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    <?php else: ?>
                                        <p class="text-muted">No assessment data available.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- All Nursing Notes Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-edit"></i> All Nursing Notes
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-sm btn-success" onclick="refreshNursingNotes()">
                                <i class="fa fa-refresh"></i> Refresh
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Filter Controls -->
                        <div class="row" style="margin-bottom: 15px;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="date_filter">Date Range</label>
                                    <select class="form-control" id="date_filter" onchange="filterNursingNotes()">
                                        <option value="today">Today</option>
                                        <option value="yesterday">Yesterday</option>
                                        <option value="week" selected>This Week</option>
                                        <option value="month">This Month</option>
                                        <option value="all">All Time</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="staff_filter">Staff Filter</label>
                                    <select class="form-control" id="staff_filter" onchange="filterNursingNotes()">
                                        <option value="">All Staff</option>
                                        <!-- Staff options will be populated via JavaScript -->
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="patient_search">Patient Search</label>
                                    <input type="text" class="form-control" id="patient_search" placeholder="Patient name or ID..." onkeyup="filterNursingNotes()">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <div>
                                        <button type="button" class="btn btn-default btn-block" onclick="exportNursingNotes()">
                                            <i class="fa fa-download"></i> Export to CSV
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Nursing Notes Table -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="nursingNotesTable">
                                <thead>
                                    <tr>
                                        <th width="8%">Date/Time</th>
                                        <th width="15%">Patient</th>
                                        <th width="12%">Staff</th>
                                        <th width="10%">Type</th>
                                        <th width="35%">Note</th>
                                        <th width="15%">Follow-up</th>
                                        <th width="5%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="nursingNotesBody">
                                    <tr>
                                        <td colspan="7" class="text-center">
                                            <i class="fa fa-spinner fa-spin"></i> Loading nursing notes...
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="row">
                            <div class="col-md-5">
                                <div class="dataTables_info" id="nursingNotesInfo">
                                    Showing 0 to 0 of 0 entries
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="dataTables_paginate paging_simple_numbers" id="nursingNotesPagination">
                                    <!-- Pagination will be populated via JavaScript -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions Row -->
        <div class="row">
            <div class="col-md-4">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-download"></i> Export Reports
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="list-group">
                            <a href="#" onclick="exportVitalSigns()" class="list-group-item">
                                <i class="fa fa-heartbeat text-red"></i> Export Vital Signs
                            </a>
                            <a href="#" onclick="exportProcedures()" class="list-group-item">
                                <i class="fa fa-tasks text-yellow"></i> Export Procedures
                            </a>
                            <a href="#" onclick="exportNursingNotes()" class="list-group-item">
                                <i class="fa fa-edit text-green"></i> Export Nursing Notes
                            </a>
                            <a href="#" onclick="exportAssessments()" class="list-group-item">
                                <i class="fa fa-clipboard text-blue"></i> Export Assessments
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-calendar"></i> Quick Date Reports
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="list-group">
                            <a href="#" onclick="generateDailyReport()" class="list-group-item">
                                <i class="fa fa-calendar-o text-blue"></i> Today's Report
                            </a>
                            <a href="#" onclick="generateWeeklyReport()" class="list-group-item">
                                <i class="fa fa-calendar text-green"></i> Weekly Report
                            </a>
                            <a href="#" onclick="generateMonthlyReport()" class="list-group-item">
                                <i class="fa fa-calendar-plus-o text-orange"></i> Monthly Report
                            </a>
                            <a href="#" onclick="generateCustomReport()" class="list-group-item">
                                <i class="fa fa-calendar-check-o text-purple"></i> Custom Date Range
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-line-chart"></i> Analytics
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="list-group">
                            <a href="#" onclick="showVitalTrends()" class="list-group-item">
                                <i class="fa fa-line-chart text-red"></i> Vital Signs Trends
                            </a>
                            <a href="#" onclick="showStaffPerformance()" class="list-group-item">
                                <i class="fa fa-users text-blue"></i> Staff Performance
                            </a>
                            <a href="#" onclick="showPatientOutcomes()" class="list-group-item">
                                <i class="fa fa-user-md text-green"></i> Patient Outcomes
                            </a>
                            <a href="#" onclick="showQualityMetrics()" class="list-group-item">
                                <i class="fa fa-star text-yellow"></i> Quality Metrics
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Note Details Modal -->
<div class="modal fade" id="noteDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Nursing Note Details
                </h4>
            </div>
            <div class="modal-body" id="noteDetailsContent">
                <!-- Note details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .table-condensed td {
        padding: 4px 8px;
        vertical-align: middle;
    }
    
    .nav-tabs-custom > .nav-tabs {
        margin: 0;
        border-bottom-color: #f4f4f4;
    }
    
    .nav-tabs-custom > .nav-tabs > li.active {
        border-top-color: #3c8dbc;
    }
    
    .tab-content {
        padding: 10px;
    }
    
    .nursing-note-content {
        max-width: 300px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .nursing-note-content:hover {
        white-space: normal;
        overflow: visible;
        position: relative;
        z-index: 10;
        background: white;
        border: 1px solid #ddd;
        padding: 5px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }
    
    .filter-controls {
        background: #f9f9f9;
        padding: 15px;
        margin-bottom: 15px;
        border-radius: 3px;
    }
    
    .badge {
        font-size: 11px;
        padding: 3px 6px;
    }
    
    .label {
        font-size: 11px;
        padding: 3px 6px;
    }
    
    .pagination > li > a {
        padding: 4px 8px;
    }
    
    .small-box .inner h3 {
        font-size: 38px;
        font-weight: bold;
        margin: 0;
    }
    
    .dataTables_info {
        margin-top: 8px;
    }
    
    .dataTables_paginate {
        margin-top: 0;
    }
    
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 12px;
        }
        
        .nursing-note-content {
            max-width: 150px;
        }
    }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    initializeReports();
    loadNursingNotes();
    loadStaffFilter();
});

// Global variables
let currentPage = 1;
let totalPages = 1;
let totalRecords = 0;
let recordsPerPage = 25;

function initializeReports() {
    console.log('Initializing Nursing Reports...');
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    console.log('Nursing Reports initialized successfully');
}

// Load nursing notes with filters
function loadNursingNotes(page = 1, useSimple = false) {
    const dateFilter = $('#date_filter').val();
    const staffFilter = $('#staff_filter').val();
    const patientSearch = $('#patient_search').val();
    
    console.log('📊 Loading nursing notes with filters:', {
        page: page,
        dateFilter: dateFilter,
        staffFilter: staffFilter,
        patientSearch: patientSearch,
        useSimple: useSimple
    });
    
    // Show loading
    $('#nursingNotesBody').html(`
        <tr>
            <td colspan="7" class="text-center">
                <i class="fa fa-spinner fa-spin"></i> Loading nursing notes...
            </td>
        </tr>
    `);
    
    // Choose endpoint based on useSimple flag
    const endpoint = useSimple ? 
        '<?php echo base_url("admin/nursing/getAllNursingNotesSimple"); ?>' : 
        '<?php echo base_url("admin/nursing/getAllNursingNotes"); ?>';
    
    const requestData = useSimple ? {} : {
        page: page,
        per_page: recordsPerPage,
        date_filter: dateFilter,
        staff_filter: staffFilter,
        patient_search: patientSearch
    };
    
    $.ajax({
        url: endpoint,
        type: 'POST',
        data: requestData,
        dataType: 'json',
        timeout: 15000, // 15 second timeout
        success: function(response) {
            console.log('📊 Nursing notes response:', response);
            
            if (response.status === 'success') {
                displayNursingNotes(response.notes);
                updatePagination(response.pagination);
                updateInfo(response.pagination);
                
                // Show success message if using simple mode
                if (useSimple) {
                    showAlert('Loaded notes using simplified mode (IPD linking disabled)', 'info');
                }
            } else {
                console.error('❌ Server error:', response.message);
                
                // If main method failed, try simple method
                if (!useSimple) {
                    console.log('🔄 Trying simple method as fallback...');
                    loadNursingNotes(page, true);
                } else {
                    showErrorMessage(response.message + ' (Both methods failed)');
                }
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ AJAX Error Details:', {
                status: status,
                error: error,
                responseText: xhr.responseText,
                statusCode: xhr.status
            });
            
            // If main method failed, try simple method
            if (!useSimple) {
                console.log('🔄 AJAX failed, trying simple method as fallback...');
                loadNursingNotes(page, true);
                return;
            }
            
            let errorMsg = 'Failed to load nursing notes: ';
            
            if (xhr.status === 404) {
                errorMsg += 'Controller method not found (404)';
            } else if (xhr.status === 500) {
                errorMsg += 'Server error (500) - Check PHP logs';
            } else if (status === 'timeout') {
                errorMsg += 'Request timeout - Server may be slow';
            } else if (status === 'parsererror') {
                errorMsg += 'JSON parse error - Server returned invalid JSON';
            } else {
                errorMsg += error + ' (' + xhr.status + ')';
            }
            
            showErrorMessage(errorMsg);
        }
    });
}

// Display nursing notes in table
function displayNursingNotes(notes) {
    if (!notes || notes.length === 0) {
        $('#nursingNotesBody').html(`
            <tr>
                <td colspan="7" class="text-center text-muted">
                    <i class="fa fa-info-circle"></i> No nursing notes found for the selected criteria.
                    <br><br>
                    <button onclick="loadNursingNotes(1, true)" class="btn btn-sm btn-info">
                        <i class="fa fa-list"></i> Try Simple View
                    </button>
                </td>
            </tr>
        `);
        return;
    }
    
    let html = '';
    notes.forEach(note => {
        const noteDate = new Date(note.date).toLocaleString();
        const patientName = note.patient_name || 'General Note';
        const staffName = (note.nurse_name || '') + ' ' + (note.nurse_surname || '');
        const noteType = note.note_type || 'General';
        const noteContent = note.note || '';
        const followUp = note.comment || '';
        const patientId = note.patient_id || 'N/A';
        
        // Handle different patient display scenarios
        let patientDisplay = patientName;
        if (patientName === 'General Note') {
            patientDisplay = '<em>General Note</em>';
        } else if (note.patient_unique_id && note.patient_unique_id !== 'N/A') {
            patientDisplay = `<strong>${patientName}</strong><br><small>ID: ${note.patient_unique_id}</small>`;
        } else {
            patientDisplay = `<strong>${patientName}</strong><br><small>ID: ${patientId}</small>`;
        }
        
        html += `
            <tr>
                <td><small>${noteDate}</small></td>
                <td>${patientDisplay}</td>
                <td>${staffName.trim() || 'Unknown'}</td>
                <td><span class="label label-info">${noteType}</span></td>
                <td>
                    <div class="nursing-note-content" title="${noteContent}">
                        ${noteContent}
                    </div>
                </td>
                <td>
                    <div class="nursing-note-content" title="${followUp}">
                        ${followUp || '-'}
                    </div>
                </td>
                <td>
                    <button class="btn btn-xs btn-info" onclick="viewNoteDetails(${note.id})">
                        <i class="fa fa-eye"></i>
                    </button>
                </td>
            </tr>
        `;
    });
    
    $('#nursingNotesBody').html(html);
}

function diagnoseJsonIssue() {
    console.log('🔧 DIAGNOSING JSON ISSUE...');
    
    // Test 1: Raw output test
    console.log('📋 Test 1: Raw PHP Output');
    $.ajax({
        url: '<?php echo base_url("admin/nursing/testRawOutput"); ?>',
        type: 'GET',
        success: function(data) {
            console.log('✅ Raw output:', data);
        },
        error: function(xhr) {
            console.error('❌ Raw output failed:', xhr.responseText);
        }
    });
    
    // Test 2: JSON debug test
    console.log('📋 Test 2: JSON Debug Test');
    $.ajax({
        url: '<?php echo base_url("admin/nursing/debugJsonOutput"); ?>',
        type: 'POST',
        dataType: 'text', // Get as text first to see raw response
        success: function(data) {
            console.log('✅ Raw JSON response:', data);
            
            try {
                const parsed = JSON.parse(data);
                console.log('✅ Parsed JSON:', parsed);
            } catch (e) {
                console.error('❌ JSON parse failed:', e);
                console.error('Raw response that failed to parse:', data);
                
                // Show what's wrong with the JSON
                showJsonError(data);
            }
        },
        error: function(xhr) {
            console.error('❌ JSON debug failed:', xhr.responseText);
        }
    });
    
    // Test 3: Simple nursing notes test
    console.log('📋 Test 3: Simple Nursing Notes');
    $.ajax({
        url: '<?php echo base_url("admin/nursing/getAllNursingNotesSimple"); ?>',
        type: 'POST',
        dataType: 'text', // Get as text to check for issues
        success: function(data) {
            console.log('✅ Simple notes raw response:', data);
            
            try {
                const parsed = JSON.parse(data);
                console.log('✅ Simple notes parsed:', parsed);
                
                if (parsed.status === 'success') {
                    displayNursingNotes(parsed.notes);
                    showAlert('Diagnostic complete - notes loaded successfully!', 'success');
                }
            } catch (e) {
                console.error('❌ Simple notes JSON parse failed:', e);
                showJsonError(data);
            }
        },
        error: function(xhr) {
            console.error('❌ Simple notes failed:', xhr.responseText);
        }
    });
}

function showJsonError(rawResponse) {
    console.log('🔍 ANALYZING JSON ERROR...');
    
    // Check for common issues
    const issues = [];

    if (rawResponse.includes('Warning:') || rawResponse.includes('Notice:') || rawResponse.includes('Error:')) {
        issues.push('PHP errors/warnings are being displayed');
    }
    
    if (rawResponse.includes('<br')) {
        issues.push('HTML line breaks in output');
    }
    
    if (rawResponse.includes('<!DOCTYPE') || rawResponse.includes('<html')) {
        issues.push('Full HTML page returned instead of JSON');
    }
    
    if (rawResponse.trim().charAt(0) !== '{' && rawResponse.trim().charAt(0) !== '[') {
        issues.push('Response does not start with { or [ (not valid JSON)');
    }
    
    if (rawResponse.includes('\n\n')) {
        issues.push('Extra whitespace/newlines in output');
    }
    
    // Show analysis
    console.log('🔍 JSON Issues Found:', issues);
    console.log('🔍 First 200 characters:', rawResponse.substring(0, 200));
    console.log('🔍 Last 200 characters:', rawResponse.substring(rawResponse.length - 200));
    
    // Display in UI
    const errorHtml = `
        <tr>
            <td colspan="7" class="text-center text-danger" style="padding: 20px;">
                <h4><i class="fa fa-exclamation-triangle"></i> JSON Parse Error Detected</h4>
                <div class="alert alert-warning text-left" style="margin: 15px 0;">
                    <strong>Issues Found:</strong><br>
                    ${issues.length > 0 ? issues.map(issue => `• ${issue}`).join('<br>') : 'Unknown JSON format issue'}
                </div>
                <div class="well text-left" style="max-height: 200px; overflow-y: scroll; font-family: monospace; font-size: 12px;">
                    <strong>Raw Response (first 500 chars):</strong><br>
                    ${rawResponse.substring(0, 500).replace(/</g, '&lt;').replace(/>/g, '&gt;')}
                    ${rawResponse.length > 500 ? '...(truncated)' : ''}
                </div>
                <div class="btn-group">
                    <button onclick="fixJsonIssues()" class="btn btn-sm btn-primary">
                        <i class="fa fa-wrench"></i> Try Fixes
                    </button>
                    <button onclick="viewFullResponse()" class="btn btn-sm btn-info">
                        <i class="fa fa-eye"></i> View Full Response
                    </button>
                    <button onclick="diagnoseJsonIssue()" class="btn btn-sm btn-warning">
                        <i class="fa fa-refresh"></i> Re-diagnose
                    </button>
                </div>
            </td>
        </tr>
    `;
    
    $('#nursingNotesBody').html(errorHtml);
}

function fixJsonIssues() {
    console.log('🔧 ATTEMPTING JSON FIXES...');
    
    // Try different approaches
    const fixes = [
        { name: 'Simple Method', url: '<?php echo base_url("admin/nursing/getAllNursingNotesSimple"); ?>' },
        { name: 'Debug JSON', url: '<?php echo base_url("admin/nursing/debugJsonOutput"); ?>' }
    ];
    
    let fixIndex = 0;
    
    function tryNextFix() {
        if (fixIndex >= fixes.length) {
            showAlert('All fixes attempted. Please check PHP error logs and server configuration.', 'error');
            return;
        }
        
        const fix = fixes[fixIndex];
        console.log(`🔧 Trying fix ${fixIndex + 1}: ${fix.name}`);
        
        $.ajax({
            url: fix.url,
            type: 'POST',
            dataType: 'json', // Try as JSON directly
            success: function(response) {
                console.log(`✅ Fix ${fixIndex + 1} worked!`, response);
                
                if (response.status === 'success' && response.notes) {
                    displayNursingNotes(response.notes);
                    showAlert(`Fix successful using: ${fix.name}`, 'success');
                } else {
                    showAlert(`Fix ${fixIndex + 1} returned success but no notes`, 'warning');
                }
            },
            error: function(xhr) {
                console.log(`❌ Fix ${fixIndex + 1} failed, trying next...`);
                fixIndex++;
                tryNextFix();
            }
        });
    }
    
    tryNextFix();
}

function viewFullResponse() {
    // Open new window with full response
    $.ajax({
        url: '<?php echo base_url("admin/nursing/getAllNursingNotesSimple"); ?>',
        type: 'POST',
        dataType: 'text',
        success: function(data) {
            const newWindow = window.open('', '_blank');
            newWindow.document.write(`
                <html>
                <head><title>Raw Response Debug</title></head>
                <body>
                    <h3>Raw Server Response</h3>
                    <pre style="background: #f5f5f5; padding: 10px; border: 1px solid #ddd; white-space: pre-wrap;">${data.replace(/</g, '&lt;').replace(/>/g, '&gt;')}</pre>
                </body>
                </html>
            `);
        }
    });
}

// Enhanced loadNursingNotes with JSON diagnosis
function loadNursingNotes(page = 1, useSimple = false) {
    const dateFilter = $('#date_filter').val();
    const staffFilter = $('#staff_filter').val();
    const patientSearch = $('#patient_search').val();
    
    // Show loading
    $('#nursingNotesBody').html(`
        <tr>
            <td colspan="7" class="text-center">
                <i class="fa fa-spinner fa-spin"></i> Loading nursing notes...
            </td>
        </tr>
    `);
    
    const endpoint = useSimple ? 
        '<?php echo base_url("admin/nursing/getAllNursingNotesSimple"); ?>' : 
        '<?php echo base_url("admin/nursing/getAllNursingNotes"); ?>';
    
    const requestData = useSimple ? {} : {
        page: page,
        per_page: recordsPerPage || 25,
        date_filter: dateFilter,
        staff_filter: staffFilter,
        patient_search: patientSearch
    };
    
    $.ajax({
        url: endpoint,
        type: 'POST',
        data: requestData,
        dataType: 'text', // Get as text first to diagnose issues
        timeout: 15000,
        success: function(rawData) {
            console.log('📊 Raw response received:', rawData.substring(0, 200));
            
            try {
                const response = JSON.parse(rawData);
                console.log('📊 Parsed response:', response);
                
                if (response.status === 'success') {
                    displayNursingNotes(response.notes);
                    updatePagination(response.pagination);
                    updateInfo(response.pagination);
                } else {
                    showErrorMessage(response.message);
                }
            } catch (e) {
                console.error('❌ JSON Parse Error:', e);
                console.error('Raw data causing error:', rawData);
                showJsonError(rawData);
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ AJAX Error:', { status, error, response: xhr.responseText });
            
            if (!useSimple) {
                console.log('🔄 Trying simple method...');
                loadNursingNotes(page, true);
            } else {
                showErrorMessage(`AJAX Error: ${error} (${xhr.status})`);
            }
        }
    });
}


// Load staff filter options
function loadStaffFilter() {
    $.ajax({
        url: '<?php echo base_url("admin/nursing/getNursingStaff"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                let options = '<option value="">All Staff</option>';
                response.staff.forEach(staff => {
                    const staffName = (staff.name || '') + ' ' + (staff.surname || '');
                    options += `<option value="${staff.id}">${staffName.trim()}</option>`;
                });
                $('#staff_filter').html(options);
            }
        },
        error: function() {
            console.log('Failed to load staff list');
        }
    });
}

// Filter nursing notes
function filterNursingNotes() {
    currentPage = 1;
    loadNursingNotes(currentPage);
}

// Refresh nursing notes
function refreshNursingNotes() {
    loadNursingNotes(currentPage);
}

// Update pagination
function updatePagination(pagination) {
    totalPages = pagination.total_pages || 1;
    totalRecords = pagination.total_records || 0;
    currentPage = pagination.current_page || 1;
    
    let html = '';
    
    // Previous button
    if (currentPage > 1) {
        html += `<li><a href="#" onclick="changePage(${currentPage - 1})">‹ Previous</a></li>`;
    }
    
    // Page numbers
    const startPage = Math.max(1, currentPage - 2);
    const endPage = Math.min(totalPages, currentPage + 2);
    
    for (let i = startPage; i <= endPage; i++) {
        const activeClass = i === currentPage ? 'active' : '';
        html += `<li class="${activeClass}"><a href="#" onclick="changePage(${i})">${i}</a></li>`;
    }
    
    // Next button
    if (currentPage < totalPages) {
        html += `<li><a href="#" onclick="changePage(${currentPage + 1})">Next ›</a></li>`;
    }
    
    $('#nursingNotesPagination').html(`<ul class="pagination pagination-sm">${html}</ul>`);
}

// Update info display
function updateInfo(pagination) {
    const start = ((pagination.current_page - 1) * recordsPerPage) + 1;
    const end = Math.min(pagination.current_page * recordsPerPage, pagination.total_records);
    
    $('#nursingNotesInfo').text(`Showing ${start} to ${end} of ${pagination.total_records} entries`);
}

// Change page
function changePage(page) {
    if (page >= 1 && page <= totalPages) {
        currentPage = page;
        loadNursingNotes(page);
    }
}

// View note details
function viewNoteDetails(noteId) {
    $.ajax({
        url: '<?php echo base_url("admin/nursing/getNoteDetails"); ?>',
        type: 'POST',
        data: { note_id: noteId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                displayNoteDetails(response.note);
                $('#noteDetailsModal').modal('show');
            } else {
                showAlert('Failed to load note details', 'error');
            }
        },
        error: function() {
            showAlert('Failed to load note details', 'error');
        }
    });
}

// Display note details in modal
function displayNoteDetails(note) {
    const noteDate = new Date(note.date).toLocaleString();
    const staffName = (note.nurse_name || '') + ' ' + (note.nurse_surname || '');
    
    const html = `
        <div class="row">
            <div class="col-md-6">
                <h5><i class="fa fa-user"></i> Patient Information</h5>
                <table class="table table-bordered table-condensed">
                    <tr><td><strong>Name:</strong></td><td>${note.patient_name || 'N/A'}</td></tr>
                    <tr><td><strong>ID:</strong></td><td>${note.patient_id}</td></tr>
                    <tr><td><strong>IPD No:</strong></td><td>${note.ipd_no || 'N/A'}</td></tr>
                </table>
            </div>
            <div class="col-md-6">
                <h5><i class="fa fa-info-circle"></i> Note Information</h5>
                <table class="table table-bordered table-condensed">
                    <tr><td><strong>Date/Time:</strong></td><td>${noteDate}</td></tr>
                    <tr><td><strong>Staff:</strong></td><td>${staffName.trim() || 'Unknown'}</td></tr>
                    <tr><td><strong>Type:</strong></td><td><span class="label label-info">${note.note_type || 'General'}</span></td></tr>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h5><i class="fa fa-edit"></i> Nursing Note</h5>
                <div class="well">
                    ${note.note || 'No note content available'}
                </div>
            </div>
        </div>
        ${note.comment ? `
        <div class="row">
            <div class="col-md-12">
                <h5><i class="fa fa-comment"></i> Follow-up/Comments</h5>
                <div class="well">
                    ${note.comment}
                </div>
            </div>
        </div>
        ` : ''}
    `;
    
    $('#noteDetailsContent').html(html);
}

// Export functions
function exportNursingNotes() {
    const dateFilter = $('#date_filter').val();
    const staffFilter = $('#staff_filter').val();
    const patientSearch = $('#patient_search').val();
    
    window.location.href = `<?php echo base_url("admin/nursing/exportNursingNotes"); ?>?date_filter=${dateFilter}&staff_filter=${staffFilter}&patient_search=${patientSearch}`;
}

function exportVitalSigns() {
    window.location.href = '<?php echo base_url("admin/nursing/exportVitalSigns"); ?>';
}

function exportProcedures() {
    window.location.href = '<?php echo base_url("admin/nursing/exportProcedures"); ?>';
}

function exportAssessments() {
    window.location.href = '<?php echo base_url("admin/nursing/exportAssessments"); ?>';
}

// Report generation functions
function generateDailyReport() {
    window.open('<?php echo base_url("admin/nursing/generateDailyReport"); ?>', '_blank');
}

function generateWeeklyReport() {
    window.open('<?php echo base_url("admin/nursing/generateWeeklyReport"); ?>', '_blank');
}

function generateMonthlyReport() {
    window.open('<?php echo base_url("admin/nursing/generateMonthlyReport"); ?>', '_blank');
}

function generateCustomReport() {
    // Show date range picker modal (implementation would depend on your date picker library)
    showAlert('Custom date range report feature coming soon!', 'info');
}

// Analytics functions
function showVitalTrends() {
    showAlert('Vital signs trends analytics coming soon!', 'info');
}

function showStaffPerformance() {
    showAlert('Staff performance analytics coming soon!', 'info');
}

function showPatientOutcomes() {
    showAlert('Patient outcomes analytics coming soon!', 'info');
}

function showQualityMetrics() {
    showAlert('Quality metrics dashboard coming soon!', 'info');
}

// Error handling
function showErrorMessage(message) {
    $('#nursingNotesBody').html(`
        <tr>
            <td colspan="7" class="text-center text-danger">
                <i class="fa fa-exclamation-triangle"></i> ${message}
            </td>
        </tr>
    `);
}

// Alert function
function showAlert(message, type = 'info') {
    const alertClass = `alert-${type}`;
    const iconClass = type === 'success' ? 'fa-check-circle' : 
                     type === 'error' ? 'fa-exclamation-circle' : 
                     type === 'warning' ? 'fa-warning' : 'fa-info-circle';
    
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <i class="fa ${iconClass}"></i> ${message}
        </div>
    `;
    
    $('body').append(alertHtml);
    
    // Auto-remove after 5 seconds
    setTimeout(() => {
        $('.alert').fadeOut();
    }, 5000);
}
</script>