<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-user-md"></i> Patient Nursing Profile
            <small><?php echo $patient['patient_name'] ?? 'Unknown Patient'; ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/nursing"><i class="fa fa-stethoscope"></i> Nursing</a></li>
            <li class="active">Patient Profile</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Patient Information Row -->
        <div class="row">
            <!-- Patient Details -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-user"></i> Patient Information
                        </h3>
                    </div>
                    <div class="box-body">
                        <?php if ($patient): ?>
                            <table class="table table-bordered table-striped">
                                <tr>
                                    <td><strong>Name:</strong></td>
                                    <td><?php echo $patient['patient_name'] ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Patient ID:</strong></td>
                                    <td><?php echo $patient['patient_unique_id'] ?? $patient['id'] ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Age:</strong></td>
                                    <td><?php echo $patient['age_display'] ?? ($patient['age'] . ' years') ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Gender:</strong></td>
                                    <td><?php echo ucfirst($patient['gender'] ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Contact:</strong></td>
                                    <td><?php echo $patient['mobileno'] ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Blood Group:</strong></td>
                                    <td><?php echo $patient['blood_group'] ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Address:</strong></td>
                                    <td><?php echo $patient['address'] ?? 'N/A'; ?></td>
                                </tr>
                            </table>
                        <?php else: ?>
                            <p class="text-danger">Patient information not available.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- IPD Details -->
                <?php if ($ipd_details): ?>
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-hospital-o"></i> IPD Details
                            </h3>
                        </div>
                        <div class="box-body">
                            <table class="table table-bordered table-striped">
                                <tr>
                                    <td><strong>IPD No:</strong></td>
                                    <td><?php echo $ipd_details['case_reference_id'] ?? $ipd_details['id'] ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Admission Date:</strong></td>
                                    <td><?php echo date('d M Y', strtotime($ipd_details['date'])); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Bed No:</strong></td>
                                    <td><?php echo $ipd_details['bed'] ?? 'N/A'; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Doctor:</strong></td>
                                    <td><?php echo ($ipd_details['doctor_name'] ?? '') . ' ' . ($ipd_details['doctor_surname'] ?? ''); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        <span class="label label-<?php echo ($ipd_details['discharged'] == 'no') ? 'success' : 'default'; ?>">
                                            <?php echo ($ipd_details['discharged'] == 'no') ? 'Active' : 'Discharged'; ?>
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-bolt"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <button class="btn btn-info btn-block" onclick="recordVitalSigns()">
                            <i class="fa fa-heartbeat"></i> Record Vital Signs
                        </button>
                        <button class="btn btn-warning btn-block" onclick="addNursingNote()" style="margin-top: 5px;">
                            <i class="fa fa-edit"></i> Add Nursing Kardex
                        </button>
                        <button class="btn btn-primary btn-block" onclick="addAssessment()" style="margin-top: 5px;">
                            <i class="fa fa-clipboard"></i> Add Assessment
                        </button>
                        <button class="btn btn-success btn-block" onclick="addProcedure()" style="margin-top: 5px;">
                            <i class="fa fa-tasks"></i> Add Procedure
                        </button>
                    </div>
                </div>
            </div>

            <!-- Main Content Area -->
            <div class="col-md-8">
                <!-- Navigation Tabs -->
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#vital-signs" data-toggle="tab">Vital Signs</a></li>
                        <li><a href="#nursing-notes" data-toggle="tab">Nursing Kardexs</a></li>
                        <li><a href="#procedures" data-toggle="tab">Procedures</a></li>
                        <li><a href="#assessments" data-toggle="tab">Assessments</a></li>
                        <li><a href="#care-plans" data-toggle="tab">Care Plans</a></li>
                        <li><a href="#medications" data-toggle="tab">Medications</a></li>
                        <li><a href="#doctor-consultations" data-toggle="tab">Doctor Consultations</a></li>
                        <li><a href="#prescriptions" data-toggle="tab">Prescriptions</a></li>
                        <li><a href="#clinical-notes" data-toggle="tab">Clinical Notes</a></li>
                        <li><a href="#visit-history" data-toggle="tab">Visit History</a></li>
                    </ul>
                    <div class="tab-content">
                        <!-- Vital Signs Tab -->
                        <div class="active tab-pane" id="vital-signs">
                            <div class="box-header">
                                <h3 class="box-title">Recent Vital Signs</h3>
                                <div class="box-tools pull-right">
                                    <button class="btn btn-sm btn-primary" onclick="recordVitalSigns()">
                                        <i class="fa fa-plus"></i> Record New
                                    </button>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <?php if (!empty($vital_signs)): ?>
                                    <table class="table table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th>Date/Time</th>
                                                <th>Temperature</th>
                                                <th>BP</th>
                                                <th>Pulse</th>
                                                <th>Resp. Rate</th>
                                                <th>O2 Sat</th>
                                                <th>Recorded By</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($vital_signs as $vs): ?>
                                                <tr>
                                                    <td><?php echo date('d M Y H:i', strtotime($vs['recorded_at'])); ?></td>
                                                    <td><?php echo $vs['temperature'] ? $vs['temperature'] . '째C' : '-'; ?></td>
                                                    <td><?php echo ($vs['systolic_bp'] && $vs['diastolic_bp']) ? $vs['systolic_bp'] . '/' . $vs['diastolic_bp'] : '-'; ?></td>
                                                    <td><?php echo $vs['pulse_rate'] ? $vs['pulse_rate'] . ' bpm' : '-'; ?></td>
                                                    <td><?php echo $vs['respiratory_rate'] ? $vs['respiratory_rate'] . '/min' : '-'; ?></td>
                                                    <td><?php echo $vs['oxygen_saturation'] ? $vs['oxygen_saturation'] . '%' : '-'; ?></td>
                                                    <td><?php echo ($vs['recorded_by_name'] ?? '') . ' ' . ($vs['recorded_by_surname'] ?? ''); ?></td>
                                                    <td>
                                                        <button class="btn btn-xs btn-info" onclick="viewVitalDetails(<?php echo $vs['id']; ?>)">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No vital signs recorded yet.
                                        <button class="btn btn-sm btn-primary pull-right" onclick="recordVitalSigns()">
                                            Record First Vital Signs
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Nursing Notes Tab -->
                        <div class="tab-pane" id="nursing-notes">
                            <div class="box-header">
                                <h3 class="box-title">Nursing Kardex</h3>
                                <div class="box-tools pull-right">
                                    <button class="btn btn-sm btn-warning" onclick="addNursingNote()">
                                        <i class="fa fa-plus"></i> Add Note
                                    </button>
                                </div>
                            </div>
                            <div class="timeline">
                                <?php if (!empty($nurse_notes)): ?>
                                    <?php foreach ($nurse_notes as $note): ?>
                                        <div class="time-label">
                                            <span class="bg-blue">
                                                <?php echo date('d M Y', strtotime($note['date'])); ?>
                                            </span>
                                        </div>
                                        <div>
                                            <i class="fa fa-edit bg-yellow"></i>
                                            <div class="timeline-item">
                                                <span class="time">
                                                    <i class="fa fa-clock-o"></i> <?php echo date('H:i', strtotime($note['date'])); ?>
                                                </span>
                                                <h3 class="timeline-header">
                                                    <a href="#"><?php echo ($note['nurse_name'] ?? '') . ' ' . ($note['nurse_surname'] ?? ''); ?></a>
                                                    added a nursing kardex
                                                </h3>
                                                <div class="timeline-body">
                                                    <?php echo nl2br(htmlspecialchars($note['note'])); ?>
                                                    <?php if (!empty($note['comment'])): ?>
                                                        <hr>
                                                        <strong>Follow-up:</strong> <?php echo nl2br(htmlspecialchars($note['comment'])); ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                    <div>
                                        <i class="fa fa-clock-o bg-gray"></i>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No nursing kardex recorded yet.
                                        <button class="btn btn-sm btn-warning pull-right" onclick="addNursingNote()">
                                            Add First Note
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- NEW TAB: Doctor Consultations -->
        <div class="tab-pane" id="doctor-consultations">
            <div class="box-header">
                <h3 class="box-title">Doctor Consultations & Notes</h3>
                <div class="box-tools pull-right">
                    <span class="label label-info"><?php echo count($doctor_consultations); ?> consultations</span>
                </div>
            </div>
            <div class="table-responsive">
                <?php if (!empty($doctor_consultations)): ?>
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Doctor</th>
                                <th>Symptoms</th>
                                <th>Diagnosis</th>
                                <th>Status</th>
                                <th>Prescription</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($doctor_consultations as $consultation): ?>
                                <tr>
                                    <td><?php echo date('d M Y', strtotime($consultation['consultation_date'])); ?></td>
                                    <td>
                                        Dr. <?php echo ($consultation['doctor_name'] ?? '') . ' ' . ($consultation['doctor_surname'] ?? ''); ?>
                                        <?php if (!empty($consultation['doctor_employee_id'])): ?>
                                            <br><small class="text-muted"><?php echo $consultation['doctor_employee_id']; ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="consultation-summary">
                                            <?php echo strlen($consultation['symptoms'] ?? '') > 50 ? 
                                                substr($consultation['symptoms'], 0, 50) . '...' : 
                                                ($consultation['symptoms'] ?: 'No symptoms recorded'); ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if (!empty($consultation['diagnosis'])): ?>
                                            <div class="diagnosis-summary">
                                                <?php echo strlen($consultation['diagnosis']) > 40 ? 
                                                    substr($consultation['diagnosis'], 0, 40) . '...' : 
                                                    $consultation['diagnosis']; ?>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted">Pending</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="label label-<?php 
                                            echo $consultation['verification_status'] == 'verified' ? 'success' : 
                                                ($consultation['verification_status'] == 'unverified' ? 'warning' : 'default'); 
                                        ?>">
                                            <?php echo ucfirst($consultation['verification_status'] ?? 'pending'); ?>
                                        </span>
                                        <?php if (!empty($consultation['verification_score'])): ?>
                                            <br><small>Score: <?php echo $consultation['verification_score']; ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($consultation['has_prescription']): ?>
                                            <span class="label label-info">
                                                <?php echo $consultation['prescription_count']; ?> items
                                            </span>
                                            <?php if ($consultation['prescription_total_cost'] > 0): ?>
                                                <br><small>KES <?php echo number_format($consultation['prescription_total_cost'], 2); ?></small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-muted">None</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button class="btn btn-xs btn-info" onclick="viewConsultationDetails(<?php echo $consultation['id']; ?>)">
                                            <i class="fa fa-eye"></i> View
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> No doctor consultations recorded yet.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- NEW TAB: Prescriptions -->
        <div class="tab-pane" id="prescriptions">
            <div class="box-header">
                <h3 class="box-title">Prescription History</h3>
                <div class="box-tools pull-right">
                    <span class="label label-primary"><?php echo count($prescriptions); ?> prescriptions</span>
                </div>
            </div>
            <div class="table-responsive">
                <?php if (!empty($prescriptions)): ?>
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Prescribed By</th>
                                <th>Status</th>
                                <th>Items/Medications</th>
                                <th>Total Cost</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($prescriptions as $prescription): ?>
                                <tr>
                                    <td><?php echo date('d M Y', strtotime($prescription['prescription_date'])); ?></td>
                                    <td>
                                        <?php if (!empty($prescription['prescription_time'])): ?>
                                            <?php echo date('H:i', strtotime($prescription['prescription_time'])); ?>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        Dr. <?php echo ($prescription['doctor_name'] ?? '') . ' ' . ($prescription['doctor_surname'] ?? ''); ?>
                                    </td>
                                    <td>
                                        <span class="label label-<?php 
                                            echo $prescription['status'] == 'dispensed' ? 'success' : 
                                                ($prescription['status'] == 'pending' ? 'warning' : 
                                                ($prescription['status'] == 'partially_dispensed' ? 'info' : 'default')); 
                                        ?>">
                                            <?php echo ucfirst(str_replace('_', ' ', $prescription['status'])); ?>
                                        </span>
                                        <?php if (!empty($prescription['dispensed_at'])): ?>
                                            <br><small>Dispensed: <?php echo date('d M Y', strtotime($prescription['dispensed_at'])); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($prescription['items'])): ?>
                                            <div class="prescription-items">
                                                <?php foreach (array_slice($prescription['items'], 0, 2) as $item): ?>
                                                    <div class="prescription-item">
                                                        <strong><?php echo $item['medicine_name']; ?></strong>
                                                        <br><small><?php echo $item['dosage_instructions']; ?></small>
                                                    </div>
                                                <?php endforeach; ?>
                                                <?php if (count($prescription['items']) > 2): ?>
                                                    <small class="text-muted">... and <?php echo count($prescription['items']) - 2; ?> more</small>
                                                <?php endif; ?>
                                            </div>
                                        <?php elseif (!empty($prescription['medicine_name'])): ?>
                                            <!-- Fallback for consultation_prescriptions format -->
                                            <div class="prescription-item">
                                                <strong><?php echo $prescription['medicine_name']; ?></strong>
                                                <br><small><?php echo $prescription['dosage_instructions']; ?></small>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted">No items listed</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($prescription['total_cost'] > 0): ?>
                                            <strong>KES <?php echo number_format($prescription['total_cost'], 2); ?></strong>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button class="btn btn-xs btn-info" onclick="viewPrescriptionDetails(<?php echo $prescription['id']; ?>)">
                                            <i class="fa fa-eye"></i> View
                                        </button>
                                        <?php if ($prescription['status'] == 'dispensed'): ?>
                                            <button class="btn btn-xs btn-success" onclick="printPrescription(<?php echo $prescription['id']; ?>)">
                                                <i class="fa fa-print"></i>
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> No prescriptions found for this patient.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- NEW TAB: Clinical Notes -->
        <div class="tab-pane" id="clinical-notes">
            <div class="box-header">
                <h3 class="box-title">Clinical Notes & Visit History</h3>
                <div class="box-tools pull-right">
                    <span class="label label-warning"><?php echo count($clinical_notes); ?> notes</span>
                </div>
            </div>
            <div class="timeline">
                <?php if (!empty($clinical_notes)): ?>
                    <?php 
                    $current_date = '';
                    foreach ($clinical_notes as $note): 
                        $note_date = date('Y-m-d', strtotime($note['date']));
                        if ($current_date != $note_date):
                            $current_date = $note_date;
                    ?>
                        <div class="time-label">
                            <span class="bg-blue">
                                <?php echo date('d M Y', strtotime($note['date'])); ?>
                            </span>
                        </div>
                    <?php endif; ?>
                        <div>
                            <i class="fa fa-<?php echo $note['type'] == 'OPD Visit' ? 'user-md' : 'stethoscope'; ?> bg-<?php echo $note['type'] == 'OPD Visit' ? 'green' : 'yellow'; ?>"></i>
                            <div class="timeline-item">
                                <span class="time">
                                    <i class="fa fa-clock-o"></i> <?php echo date('H:i', strtotime($note['date'])); ?>
                                </span>
                                <h3 class="timeline-header">
                                    <strong><?php echo $note['type']; ?></strong> 
                                    <?php if (!empty($note['doctor_name'])): ?>
                                        by <a href="#">Dr. <?php echo $note['doctor_name']; ?></a>
                                    <?php endif; ?>
                                    <?php if (!empty($note['reference'])): ?>
                                        <span class="label label-default pull-right"><?php echo $note['reference']; ?></span>
                                    <?php endif; ?>
                                </h3>
                                <div class="timeline-body">
                                    <?php if (!empty($note['content'])): ?>
                                        <p><strong>Primary Note:</strong> <?php echo nl2br(htmlspecialchars($note['content'])); ?></p>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($note['additional_info'])): ?>
                                        <p><strong>Additional Information:</strong> <?php echo nl2br(htmlspecialchars($note['additional_info'])); ?></p>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($note['allergies'])): ?>
                                        <div class="alert alert-warning" style="margin-top: 10px;">
                                            <i class="fa fa-exclamation-triangle"></i> 
                                            <strong>Known Allergies:</strong> <?php echo htmlspecialchars($note['allergies']); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <div>
                        <i class="fa fa-clock-o bg-gray"></i>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> No clinical notes found for this patient.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- NEW TAB: Visit History -->
        <div class="tab-pane" id="visit-history">
            <div class="box-header">
                <h3 class="box-title">Patient Visit History</h3>
            </div>
            
            <!-- OPD Visits Section -->
            <?php if (!empty($opd_visits)): ?>
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-hospital-o"></i> OPD Visits</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-success"><?php echo count($opd_visits); ?> visits</span>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed">
                                <thead>
                                    <tr>
                                        <th>OPD No</th>
                                        <th>Date</th>
                                        <th>Time</th>
                                        <th>Doctor</th>
                                        <th>Symptoms</th>
                                        <th>Vital Signs</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($opd_visits as $visit): ?>
                                        <tr>
                                            <td><?php echo $visit['opd_no']; ?></td>
                                            <td><?php echo date('d M Y', strtotime($visit['appointment_date'])); ?></td>
                                            <td>
                                                <?php if (!empty($visit['appointment_time'])): ?>
                                                    <?php echo date('H:i', strtotime($visit['appointment_time'])); ?>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            <td>Dr. <?php echo ($visit['doctor_name'] ?? '') . ' ' . ($visit['doctor_surname'] ?? ''); ?></td>
                                            <td>
                                                <div class="visit-symptoms">
                                                    <?php echo strlen($visit['symptoms'] ?? '') > 30 ? 
                                                        substr($visit['symptoms'], 0, 30) . '...' : 
                                                        ($visit['symptoms'] ?: 'Not recorded'); ?>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="vital-signs-summary">
                                                    <?php if (!empty($visit['bp'])): ?>
                                                        <span class="vital-item">BP: <?php echo $visit['bp']; ?></span><br>
                                                    <?php endif; ?>
                                                    <?php if (!empty($visit['pulse'])): ?>
                                                        <span class="vital-item">Pulse: <?php echo $visit['pulse']; ?></span><br>
                                                    <?php endif; ?>
                                                    <?php if (!empty($visit['temperature'])): ?>
                                                        <span class="vital-item">Temp: <?php echo $visit['temperature']; ?>°C</span>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                            <td>
                                                <button class="btn btn-xs btn-info" onclick="viewOPDDetails(<?php echo $visit['id']; ?>)">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

                        <!-- Procedures Tab -->
                        <div class="tab-pane" id="procedures">
                            <div class="box-header">
                                <h3 class="box-title">Nursing Procedures</h3>
                                <div class="box-tools pull-right">
                                    <button class="btn btn-sm btn-success" onclick="addProcedure()">
                                        <i class="fa fa-plus"></i> Add Procedure
                                    </button>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <?php if (!empty($procedures)): ?>
                                    <table class="table table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Procedure</th>
                                                <th>Type</th>
                                                <th>Status</th>
                                                <th>Performed By</th>
                                                <th>Duration</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($procedures as $proc): ?>
                                                <tr>
                                                    <td><?php echo date('d M Y', strtotime($proc['created_at'])); ?></td>
                                                    <td><?php echo $proc['procedure_name']; ?></td>
                                                    <td><?php echo ucfirst(str_replace('_', ' ', $proc['procedure_type'])); ?></td>
                                                    <td>
                                                        <span class="label label-<?php 
                                                            echo $proc['status'] == 'completed' ? 'success' : 
                                                                ($proc['status'] == 'in_progress' ? 'warning' : 'info'); 
                                                        ?>">
                                                            <?php echo ucfirst(str_replace('_', ' ', $proc['status'])); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo ($proc['performed_by_name'] ?? '') . ' ' . ($proc['performed_by_surname'] ?? ''); ?></td>
                                                    <td><?php echo $proc['duration_minutes'] ? $proc['duration_minutes'] . ' min' : '-'; ?></td>
                                                    <td>
                                                        <button class="btn btn-xs btn-info" onclick="viewProcedureDetails(<?php echo $proc['id']; ?>)">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No procedures recorded yet.
                                        <button class="btn btn-sm btn-success pull-right" onclick="addProcedure()">
                                            Add First Procedure
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Assessments Tab -->
                        <div class="tab-pane" id="assessments">
                            <div class="box-header">
                                <h3 class="box-title">Nursing Assessments</h3>
                                <div class="box-tools pull-right">
                                    <button class="btn btn-sm btn-primary" onclick="addAssessment()">
                                        <i class="fa fa-plus"></i> Add Assessment
                                    </button>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <?php if (!empty($nursing_assessments)): ?>
                                    <table class="table table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Type</th>
                                                <th>Category</th>
                                                <th>Risk Level</th>
                                                <th>Assessed By</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($nursing_assessments as $assessment): ?>
                                                <tr>
                                                    <td><?php echo date('d M Y', strtotime($assessment['assessment_date'])); ?></td>
                                                    <td><?php echo ucfirst(str_replace('_', ' ', $assessment['assessment_type'])); ?></td>
                                                    <td><?php echo ucfirst($assessment['assessment_category']); ?></td>
                                                    <td>
                                                        <span class="label label-<?php 
                                                            echo $assessment['risk_level'] == 'critical' ? 'danger' : 
                                                                ($assessment['risk_level'] == 'high' ? 'warning' : 
                                                                ($assessment['risk_level'] == 'medium' ? 'info' : 'success')); 
                                                        ?>">
                                                            <?php echo ucfirst($assessment['risk_level']); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo ($assessment['assessed_by_name'] ?? '') . ' ' . ($assessment['assessed_by_surname'] ?? ''); ?></td>
                                                    <td>
                                                        <button class="btn btn-xs btn-info" onclick="viewAssessmentDetails(<?php echo $assessment['id']; ?>)">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No assessments recorded yet.
                                        <button class="btn btn-sm btn-primary pull-right" onclick="addAssessment()">
                                            Add First Assessment
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Care Plans Tab -->
                        <div class="tab-pane" id="care-plans">
                            <div class="box-header">
                                <h3 class="box-title">Care Plans</h3>
                                <div class="box-tools pull-right">
                                    <button class="btn btn-sm btn-primary" onclick="createCarePlan()">
                                        <i class="fa fa-plus"></i> Create Care Plan
                                    </button>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <?php if (!empty($care_plans)): ?>
                                    <table class="table table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th>Plan Name</th>
                                                <th>Priority</th>
                                                <th>Status</th>
                                                <th>Start Date</th>
                                                <th>Target Date</th>
                                                <th>Created By</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($care_plans as $plan): ?>
                                                <tr>
                                                    <td><?php echo $plan['plan_name']; ?></td>
                                                    <td>
                                                        <span class="label label-<?php 
                                                            echo $plan['priority'] == 'urgent' ? 'danger' : 
                                                                ($plan['priority'] == 'high' ? 'warning' : 'info'); 
                                                        ?>">
                                                            <?php echo ucfirst($plan['priority']); ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="label label-<?php 
                                                            echo $plan['status'] == 'active' ? 'success' : 
                                                                ($plan['status'] == 'completed' ? 'primary' : 'default'); 
                                                        ?>">
                                                            <?php echo ucfirst($plan['status']); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo date('d M Y', strtotime($plan['start_date'])); ?></td>
                                                    <td><?php echo $plan['target_date'] ? date('d M Y', strtotime($plan['target_date'])) : '-'; ?></td>
                                                    <td><?php echo ($plan['created_by_name'] ?? '') . ' ' . ($plan['created_by_surname'] ?? ''); ?></td>
                                                    <td>
                                                        <button class="btn btn-xs btn-info" onclick="viewCarePlanDetails(<?php echo $plan['id']; ?>)">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No care plans created yet.
                                        <button class="btn btn-sm btn-primary pull-right" onclick="createCarePlan()">
                                            Create First Care Plan
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Medications Tab -->
                        <div class="tab-pane" id="medications">
                            <div class="box-header">
                                <h3 class="box-title">Medication Administration</h3>
                            </div>
                            <div class="table-responsive">
                                <?php if (!empty($medications)): ?>
                                    <table class="table table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th>Date/Time</th>
                                                <th>Medication</th>
                                                <th>Dosage</th>
                                                <th>Route</th>
                                                <th>Given By</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($medications as $med): ?>
                                                <tr>
                                                    <td><?php echo date('d M Y H:i', strtotime($med['date'])); ?></td>
                                                    <td><?php echo $med['medicine_name'] ?? 'N/A'; ?></td>
                                                    <td><?php echo $med['dosage'] ?? 'N/A'; ?></td>
                                                    <td><?php echo $med['route'] ?? 'N/A'; ?></td>
                                                    <td><?php echo ($med['given_by_name'] ?? '') . ' ' . ($med['given_by_surname'] ?? ''); ?></td>
                                                    <td>
                                                        <button class="btn btn-xs btn-info" onclick="viewMedicationDetails(<?php echo $med['id']; ?>)">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No medications administered yet.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Modal for Consultation Details -->
<div class="modal fade" id="consultationDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-user-md"></i> Consultation Details</h4>
            </div>
            <div class="modal-body">
                <div id="consultationDetailsContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading consultation details...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Prescription Details -->
<div class="modal fade" id="prescriptionDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-prescription"></i> Prescription Details</h4>
            </div>
            <div class="modal-body">
                <div id="prescriptionDetailsContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading prescription details...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="printCurrentPrescription()">
                    <i class="fa fa-print"></i> Print
                </button>
            </div>
        </div>
    </div>
</div>


<!-- Modal for Recording Vital Signs -->
<div class="modal fade" id="vitalSignsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-heartbeat"></i> Record Vital Signs</h4>
            </div>
            <form id="vitalSignsForm" method="post" action="<?php echo base_url('admin/nursing/save_vital_signs'); ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Temperature (째C)</label>
                                <input type="number" class="form-control" name="temperature" step="0.1" min="30" max="45">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Pulse Rate (bpm)</label>
                                <input type="number" class="form-control" name="pulse_rate" min="30" max="200">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Systolic BP</label>
                                <input type="number" class="form-control" name="systolic_bp" min="60" max="250">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Diastolic BP</label>
                                <input type="number" class="form-control" name="diastolic_bp" min="30" max="150">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Respiratory Rate (/min)</label>
                                <input type="number" class="form-control" name="respiratory_rate" min="8" max="60">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Oxygen Saturation (%)</label>
                                <input type="number" class="form-control" name="oxygen_saturation" min="70" max="100">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Notes</label>
                                <textarea class="form-control" name="notes" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="patient_id" id="modalPatientId">
                    <input type="hidden" name="ipd_id" id="modalIPDId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Vital Signs</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal for Adding Nursing Note -->
<div class="modal fade" id="nursingNoteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-edit"></i> Add Nursing Kardex</h4>
            </div>
            <form id="nursingNoteForm" method="post" action="<?php echo base_url('admin/nursing/save_nursing_note'); ?>">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Note Type</label>
                        <select class="form-control" name="note_type" required>
                            <option value="">Select Type</option>
                            <option value="assessment">Assessment</option>
                            <option value="intervention">Intervention</option>
                            <option value="evaluation">Evaluation</option>
                            <option value="general">General</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Note</label>
                        <textarea class="form-control" name="note" rows="5" required></textarea>
                    </div>
                    <div class="form-group">
                        <label>Follow-up Required</label>
                        <textarea class="form-control" name="comment" rows="2" placeholder="Optional follow-up notes"></textarea>
                    </div>
                    <input type="hidden" name="patient_id" id="notePatientId">
                    <input type="hidden" name="ipd_id" id="noteIPDId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">Save Note</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal for Adding Assessment -->
<div class="modal fade" id="assessmentModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-clipboard"></i> Add Assessment</h4>
            </div>
            <form id="assessmentForm" method="post" action="<?php echo base_url('admin/nursing/save_assessment'); ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Assessment Type</label>
                                <select class="form-control" name="assessment_type" required>
                                    <option value="">Select Type</option>
                                    <option value="fall_risk">Fall Risk</option>
                                   <option value="pressure_ulcer">Pressure Ulcer Risk</option>
                                   <option value="nutritional">Nutritional</option>
                                   <option value="pain">Pain Assessment</option>
                                   <option value="mental_health">Mental Health</option>
                                   <option value="neurological">Neurological</option>
                                   <option value="respiratory">Respiratory</option>
                                   <option value="cardiovascular">Cardiovascular</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Category</label>
                               <select class="form-control" name="assessment_category" required>
                                   <option value="">Select Category</option>
                                   <option value="admission">Admission</option>
                                   <option value="routine">Routine</option>
                                   <option value="pre_operative">Pre-operative</option>
                                   <option value="post_operative">Post-operative</option>
                                   <option value="discharge">Discharge</option>
                                   <option value="emergency">Emergency</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Risk Level</label>
                               <select class="form-control" name="risk_level" required>
                                   <option value="">Select Risk Level</option>
                                   <option value="low">Low</option>
                                   <option value="medium">Medium</option>
                                   <option value="high">High</option>
                                   <option value="critical">Critical</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Score (if applicable)</label>
                               <input type="number" class="form-control" name="assessment_score" min="0" max="100">
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Assessment Details</label>
                               <textarea class="form-control" name="assessment_details" rows="4" required></textarea>
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Recommendations</label>
                               <textarea class="form-control" name="recommendations" rows="3"></textarea>
                           </div>
                       </div>
                   </div>
                   <input type="hidden" name="patient_id" id="assessmentPatientId">
                   <input type="hidden" name="ipd_id" id="assessmentIPDId">
               </div>
               <div class="modal-footer">
                   <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                   <button type="submit" class="btn btn-primary">Save Assessment</button>
               </div>
           </form>
       </div>
   </div>
</div>

<!-- Modal for Adding Procedure -->
<div class="modal fade" id="procedureModal" tabindex="-1" role="dialog">
   <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
           <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title"><i class="fa fa-tasks"></i> Add Procedure</h4>
           </div>
           <form id="procedureForm" method="post" action="<?php echo base_url('admin/nursing/save_procedure'); ?>">
               <div class="modal-body">
                   <div class="row">
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Procedure Name</label>
                               <input type="text" class="form-control" name="procedure_name" required>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Procedure Type</label>
                               <select class="form-control" name="procedure_type" required>
                                   <option value="">Select Type</option>
                                   <option value="wound_care">Wound Care</option>
                                   <option value="medication_admin">Medication Administration</option>
                                   <option value="iv_therapy">IV Therapy</option>
                                   <option value="catheter_care">Catheter Care</option>
                                   <option value="respiratory_care">Respiratory Care</option>
                                   <option value="patient_positioning">Patient Positioning</option>
                                   <option value="hygiene_care">Hygiene Care</option>
                                   <option value="diagnostic">Diagnostic</option>
                                   <option value="therapeutic">Therapeutic</option>
                                   <option value="preventive">Preventive</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Status</label>
                               <select class="form-control" name="status" required>
                                   <option value="scheduled">Scheduled</option>
                                   <option value="in_progress">In Progress</option>
                                   <option value="completed">Completed</option>
                                   <option value="cancelled">Cancelled</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Duration (minutes)</label>
                               <input type="number" class="form-control" name="duration_minutes" min="1">
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Procedure Description</label>
                               <textarea class="form-control" name="procedure_description" rows="3"></textarea>
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Notes/Observations</label>
                               <textarea class="form-control" name="procedure_notes" rows="3"></textarea>
                           </div>
                       </div>
                   </div>
                   <input type="hidden" name="patient_id" id="procedurePatientId">
                   <input type="hidden" name="ipd_id" id="procedureIPDId">
               </div>
               <div class="modal-footer">
                   <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                   <button type="submit" class="btn btn-success">Save Procedure</button>
               </div>
           </form>
       </div>
   </div>
</div>

<!-- Modal for Creating Care Plan -->
<div class="modal fade" id="carePlanModal" tabindex="-1" role="dialog">
   <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
           <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title"><i class="fa fa-clipboard"></i> Create Care Plan</h4>
           </div>
           <form id="carePlanForm" method="post" action="<?php echo base_url('admin/nursing/save_care_plan'); ?>">
               <div class="modal-body">
                   <div class="row">
                       <div class="col-md-8">
                           <div class="form-group">
                               <label>Plan Name</label>
                               <input type="text" class="form-control" name="plan_name" required>
                           </div>
                       </div>
                       <div class="col-md-4">
                           <div class="form-group">
                               <label>Priority</label>
                               <select class="form-control" name="priority" required>
                                   <option value="low">Low</option>
                                   <option value="normal">Normal</option>
                                   <option value="high">High</option>
                                   <option value="urgent">Urgent</option>
                               </select>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Start Date</label>
                               <input type="date" class="form-control" name="start_date" required>
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="form-group">
                               <label>Target Date</label>
                               <input type="date" class="form-control" name="target_date">
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Nursing Diagnosis</label>
                               <textarea class="form-control" name="nursing_diagnosis" rows="2" required></textarea>
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Goals/Outcomes</label>
                               <textarea class="form-control" name="goals_outcomes" rows="3" required></textarea>
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Interventions</label>
                               <textarea class="form-control" name="interventions" rows="4" required></textarea>
                           </div>
                       </div>
                       <div class="col-md-12">
                           <div class="form-group">
                               <label>Evaluation Criteria</label>
                               <textarea class="form-control" name="evaluation_criteria" rows="2"></textarea>
                           </div>
                       </div>
                   </div>
                   <input type="hidden" name="patient_id" id="carePlanPatientId">
                   <input type="hidden" name="ipd_id" id="carePlanIPDId">
               </div>
               <div class="modal-footer">
                   <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                   <button type="submit" class="btn btn-primary">Create Care Plan</button>
               </div>
           </form>
       </div>
   </div>
</div>

<!-- Hidden Patient Data -->
<input type="hidden" id="currentPatientId" value="<?php echo $patient['id'] ?? ''; ?>">
<input type="hidden" id="currentPatientName" value="<?php echo $patient['patient_name'] ?? ''; ?>">
<input type="hidden" id="currentIPDId" value="<?php echo $ipd_details['id'] ?? ''; ?>">

<script>
// Global variables for current data
var currentConsultationId = null;
var currentPrescriptionId = null;

/**
 * View consultation details
 */
function viewConsultationDetails(consultationId) {
    currentConsultationId = consultationId;
    
    $('#consultationDetailsModal').modal('show');
    $('#consultationDetailsContent').html(`
        <div class="text-center">
            <i class="fa fa-spinner fa-spin fa-2x"></i>
            <p>Loading consultation details...</p>
        </div>
    `);
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/get_consultation_details"); ?>',
        method: 'POST',
        data: { consultation_id: consultationId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showConsultationDetailsContent(response.data);
            } else {
                $('#consultationDetailsContent').html(`
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i> ${response.message}
                    </div>
                `);
            }
        },
        error: function() {
            $('#consultationDetailsContent').html(`
                <div class="alert alert-danger">
                    <i class="fa fa-exclamation-triangle"></i> Error loading consultation details
                </div>
            `);
        }
    });
}

/**
 * Display consultation details content
 */
function showConsultationDetailsContent(consultation) {
    let html = `
        <div class="row">
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr><td><strong>Patient:</strong></td><td>${consultation.patient_name} (${consultation.patient_unique_id})</td></tr>
                    <tr><td><strong>Date:</strong></td><td>${formatDate(consultation.consultation_date)}</td></tr>
                    <tr><td><strong>Doctor:</strong></td><td>Dr. ${consultation.doctor_name} ${consultation.doctor_surname}</td></tr>
                    <tr><td><strong>Status:</strong></td><td><span class="label label-${getStatusClass(consultation.verification_status)}">${consultation.verification_status}</span></td></tr>
                    ${consultation.verification_score ? `<tr><td><strong>Score:</strong></td><td>${consultation.verification_score}</td></tr>` : ''}
                </table>
            </div>
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr><td><strong>Has Prescription:</strong></td><td>${consultation.has_prescription ? 'Yes' : 'No'}</td></tr>
                    ${consultation.prescription_count ? `<tr><td><strong>Medications:</strong></td><td>${consultation.prescription_count} items</td></tr>` : ''}
                    ${consultation.prescription_total_cost ? `<tr><td><strong>Total Cost:</strong></td><td>KES ${parseFloat(consultation.prescription_total_cost).toFixed(2)}</td></tr>` : ''}
                </table>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-12">
                <h5>Symptoms:</h5>
                <div class="well well-sm">
                    ${consultation.symptoms || 'No symptoms recorded'}
                </div>
            </div>
        </div>
        
        ${consultation.diagnosis ? `
        <div class="row">
            <div class="col-md-12">
                <h5>Diagnosis:</h5>
                <div class="well well-sm">
                    ${consultation.diagnosis}
                </div>
            </div>
        </div>
        ` : ''}
        
        ${consultation.consultation_notes ? `
        <div class="row">
            <div class="col-md-12">
                <h5>Doctor's Notes:</h5>
                <div class="well well-sm">
                    ${consultation.consultation_notes}
                </div>
            </div>
        </div>
        ` : ''}
        
        ${consultation.general_prescription_notes ? `
        <div class="row">
            <div class="col-md-12">
                <h5>Prescription Instructions:</h5>
                <div class="well well-sm">
                    ${consultation.general_prescription_notes}
                </div>
            </div>
        </div>
        ` : ''}
        
        ${consultation.prescriptions && consultation.prescriptions.length > 0 ? `
        <div class="row">
            <div class="col-md-12">
                <h5>Prescribed Medications:</h5>
                <table class="table table-striped table-condensed">
                    <thead>
                        <tr>
                            <th>Medicine</th>
                            <th>Dosage</th>
                            <th>Duration</th>
                            <th>Instructions</th>
                            <th>Cost</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${consultation.prescriptions.map(prescription => `
                            <tr>
                                <td>${prescription.medicine_name}</td>
                                <td>${prescription.dosage_instructions}</td>
                                <td>${prescription.duration || '-'} ${prescription.duration_unit || ''}</td>
                                <td>${prescription.special_instructions || '-'}</td>
                                <td>KES ${parseFloat(prescription.total_cost || 0).toFixed(2)}</td>
                            </tr>
                        `).join('')}
                    </tbody>
                </table>
            </div>
        </div>
        ` : ''}
    `;
    
    $('#consultationDetailsContent').html(html);
}

/**
 * View prescription details
 */
function viewPrescriptionDetails(prescriptionId) {
    currentPrescriptionId = prescriptionId;
    
    $('#prescriptionDetailsModal').modal('show');
    $('#prescriptionDetailsContent').html(`
        <div class="text-center">
            <i class="fa fa-spinner fa-spin fa-2x"></i>
            <p>Loading prescription details...</p>
        </div>
    `);
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/get_prescription_details"); ?>',
        method: 'POST',
        data: { prescription_id: prescriptionId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showPrescriptionDetailsContent(response.data);
            } else {
                $('#prescriptionDetailsContent').html(`
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i> ${response.message}
                    </div>
                `);
            }
        },
        error: function() {
            $('#prescriptionDetailsContent').html(`
                <div class="alert alert-danger">
                    <i class="fa fa-exclamation-triangle"></i> Error loading prescription details
                </div>
            `);
        }
    });
}

/**
 * Display prescription details content
 */
function showPrescriptionDetailsContent(prescription) {
    let html = `
        <div class="row">
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr><td><strong>Patient:</strong></td><td>${prescription.patient_name}</td></tr>
                    <tr><td><strong>Date:</strong></td><td>${formatDate(prescription.prescription_date)}</td></tr>
                    <tr><td><strong>Time:</strong></td><td>${prescription.prescription_time || '-'}</td></tr>
                    <tr><td><strong>Prescribed By:</strong></td><td>Dr. ${prescription.doctor_name} ${prescription.doctor_surname}</td></tr>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr><td><strong>Status:</strong></td><td><span class="label label-${getPrescriptionStatusClass(prescription.status)}">${prescription.status}</span></td></tr>
                    <tr><td><strong>Total Cost:</strong></td><td>KES ${parseFloat(prescription.total_cost || 0).toFixed(2)}</td></tr>
                    ${prescription.dispensed_at ? `<tr><td><strong>Dispensed:</strong></td><td>${formatDate(prescription.dispensed_at)}</td></tr>` : ''}
                    ${prescription.dispensed_by_name ? `<tr><td><strong>Dispensed By:</strong></td><td>${prescription.dispensed_by_name} ${prescription.dispensed_by_surname}</td></tr>` : ''}
                </table>
            </div>
        </div>
        
        ${prescription.general_instructions ? `
        <div class="row">
            <div class="col-md-12">
                <h5>General Instructions:</h5>
                <div class="well well-sm">
                    ${prescription.general_instructions}
                </div>
            </div>
        </div>
        ` : ''}
        
        ${prescription.pharmacy_notes ? `
        <div class="row">
            <div class="col-md-12">
                <h5>Pharmacy Notes:</h5>
                <div class="well well-sm">
                    ${prescription.pharmacy_notes}
                </div>
            </div>
        </div>
        ` : ''}
        
        ${prescription.items && prescription.items.length > 0 ? `
        <div class="row">
            <div class="col-md-12">
                <h5>Prescribed Items:</h5>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Medicine</th>
                            <th>Category</th>
                            <th>Quantity</th>
                            <th>Dosage Instructions</th>
                            <th>Duration</th>
                            <th>Special Instructions</th>
                            <th>Unit Cost</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${prescription.items.map(item => `
                            <tr>
                                <td><strong>${item.medicine_name}</strong></td>
                                <td>${item.medicine_category || '-'}</td>
                                <td>${item.quantity}</td>
                                <td>${item.dosage_instructions}</td>
                                <td>${item.duration_days ? item.duration_days + ' days' : '-'}</td>
                                <td>${item.special_instructions || '-'}</td>
                                <td>KES ${parseFloat(item.unit_cost || 0).toFixed(2)}</td>
                                <td>KES ${parseFloat(item.total_cost || 0).toFixed(2)}</td>
                            </tr>
                        `).join('')}
                    </tbody>
                </table>
            </div>
        </div>
        ` : ''}
    `;
    
    $('#prescriptionDetailsContent').html(html);
}

/**
 * Helper functions
 */
function formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    return date.toLocaleDateString('en-GB', { 
        day: '2-digit', 
        month: 'short', 
        year: 'numeric' 
    });
}

function getStatusClass(status) {
    switch(status) {
        case 'verified': return 'success';
        case 'unverified': return 'warning';
        default: return 'default';
    }
}

function getPrescriptionStatusClass(status) {
    switch(status) {
        case 'dispensed': return 'success';
        case 'pending': return 'warning';
        case 'partially_dispensed': return 'info';
        case 'cancelled': return 'danger';
        default: return 'default';
    }
}

/**
 * Print prescription
 */
function printPrescription(prescriptionId) {
    window.open('<?php echo base_url("admin/nursing/print_prescription/"); ?>' + prescriptionId, '_blank');
}

function printCurrentPrescription() {
    if (currentPrescriptionId) {
        printPrescription(currentPrescriptionId);
    }
}

/**
 * View OPD details
 */
function viewOPDDetails(opdId) {
    // You can implement this to show detailed OPD visit information
    alert('OPD Details for ID: ' + opdId + ' - Feature coming soon!');
}

/**
 * View IPD details  
 */
function viewIPDDetails(ipdId) {
    // You can implement this to show detailed IPD admission information
    alert('IPD Details for ID: ' + ipdId + ' - Feature coming soon!');
}

// Patient profile JavaScript functions
function recordVitalSigns() {
   const patientId = $('#currentPatientId').val();
   const patientName = $('#currentPatientName').val();
   const ipdId = $('#currentIPDId').val();
   
   if (!patientId) {
       alert('Patient ID not found');
       return;
   }
   
   // Set modal data
   $('#modalPatientId').val(patientId);
   $('#modalIPDId').val(ipdId);
   
   // Show modal
   $('#vitalSignsModal').modal('show');
}

function addNursingNote() {
   const patientId = $('#currentPatientId').val();
   const patientName = $('#currentPatientName').val();
   const ipdId = $('#currentIPDId').val();
   
   if (!patientId) {
       alert('Patient ID not found');
       return;
   }
   
   // Set modal data
   $('#notePatientId').val(patientId);
   $('#noteIPDId').val(ipdId);
   
   // Show modal
   $('#nursingNoteModal').modal('show');
}

function addAssessment() {
   const patientId = $('#currentPatientId').val();
   const ipdId = $('#currentIPDId').val();
   
   if (!patientId) {
       alert('Patient ID not found');
       return;
   }
   
   // Set modal data
   $('#assessmentPatientId').val(patientId);
   $('#assessmentIPDId').val(ipdId);
   
   // Show modal
   $('#assessmentModal').modal('show');
}

function addProcedure() {
   const patientId = $('#currentPatientId').val();
   const ipdId = $('#currentIPDId').val();
   
   if (!patientId) {
       alert('Patient ID not found');
       return;
   }
   
   // Set modal data
   $('#procedurePatientId').val(patientId);
   $('#procedureIPDId').val(ipdId);
   
   // Show modal
   $('#procedureModal').modal('show');
}

function createCarePlan() {
   const patientId = $('#currentPatientId').val();
   const ipdId = $('#currentIPDId').val();
   
   if (!patientId) {
       alert('Patient ID not found');
       return;
   }
   
   // Set modal data
   $('#carePlanPatientId').val(patientId);
   $('#carePlanIPDId').val(ipdId);
   
   // Show modal
   $('#carePlanModal').modal('show');
}

function viewVitalDetails(vitalId) {
   // AJAX call to get vital details
   $.ajax({
       url: '<?php echo base_url("admin/nursing/get_vital_details"); ?>',
       method: 'POST',
       data: { vital_id: vitalId },
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               showVitalDetailsModal(response.data);
           } else {
               alert('Error loading vital details');
           }
       },
       error: function() {
           alert('Error loading vital details');
       }
   });
}

function showVitalDetailsModal(vitalData) {
   let detailsHtml = `
       <div class="modal fade" id="vitalDetailsModal" tabindex="-1" role="dialog">
           <div class="modal-dialog" role="document">
               <div class="modal-content">
                   <div class="modal-header">
                       <button type="button" class="close" data-dismiss="modal">&times;</button>
                       <h4 class="modal-title">Vital Signs Details</h4>
                   </div>
                   <div class="modal-body">
                       <table class="table table-bordered">
                           <tr><td><strong>Date/Time:</strong></td><td>${vitalData.recorded_at}</td></tr>
                           <tr><td><strong>Temperature:</strong></td><td>${vitalData.temperature || '-'}째C</td></tr>
                           <tr><td><strong>Blood Pressure:</strong></td><td>${vitalData.systolic_bp || '-'}/${vitalData.diastolic_bp || '-'} mmHg</td></tr>
                           <tr><td><strong>Pulse Rate:</strong></td><td>${vitalData.pulse_rate || '-'} bpm</td></tr>
                           <tr><td><strong>Respiratory Rate:</strong></td><td>${vitalData.respiratory_rate || '-'}/min</td></tr>
                           <tr><td><strong>Oxygen Saturation:</strong></td><td>${vitalData.oxygen_saturation || '-'}%</td></tr>
                           <tr><td><strong>Recorded By:</strong></td><td>${vitalData.recorded_by_name || ''}</td></tr>
                           <tr><td><strong>Notes:</strong></td><td>${vitalData.notes || 'No notes'}</td></tr>
                       </table>
                   </div>
                   <div class="modal-footer">
                       <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                   </div>
               </div>
           </div>
       </div>
   `;
   
   // Remove existing modal if any
   $('#vitalDetailsModal').remove();
   
   // Add new modal and show
   $('body').append(detailsHtml);
   $('#vitalDetailsModal').modal('show');
}

function viewProcedureDetails(procedureId) {
   $.ajax({
       url: '<?php echo base_url("admin/nursing/get_procedure_details"); ?>',
       method: 'POST',
       data: { procedure_id: procedureId },
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               showProcedureDetailsModal(response.data);
           } else {
               alert('Error loading procedure details');
           }
       },
       error: function() {
           alert('Error loading procedure details');
       }
   });
}

function showProcedureDetailsModal(procData) {
   let detailsHtml = `
       <div class="modal fade" id="procedureDetailsModal" tabindex="-1" role="dialog">
           <div class="modal-dialog modal-lg" role="document">
               <div class="modal-content">
                   <div class="modal-header">
                       <button type="button" class="close" data-dismiss="modal">&times;</button>
                       <h4 class="modal-title">Procedure Details</h4>
                   </div>
                   <div class="modal-body">
                       <div class="row">
                           <div class="col-md-6">
                               <table class="table table-bordered">
                                   <tr><td><strong>Procedure:</strong></td><td>${procData.procedure_name}</td></tr>
                                   <tr><td><strong>Type:</strong></td><td>${procData.procedure_type}</td></tr>
                                   <tr><td><strong>Status:</strong></td><td>${procData.status}</td></tr>
                                   <tr><td><strong>Duration:</strong></td><td>${procData.duration_minutes || '-'} minutes</td></tr>
                                   <tr><td><strong>Performed By:</strong></td><td>${procData.performed_by_name || ''}</td></tr>
                                   <tr><td><strong>Date:</strong></td><td>${procData.created_at}</td></tr>
                               </table>
                           </div>
                           <div class="col-md-6">
                               <h5>Description:</h5>
                               <p>${procData.procedure_description || 'No description provided'}</p>
                               <h5>Notes:</h5>
                               <p>${procData.procedure_notes || 'No notes'}</p>
                           </div>
                       </div>
                   </div>
                   <div class="modal-footer">
                       <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                   </div>
               </div>
           </div>
       </div>
   `;
   
   $('#procedureDetailsModal').remove();
   $('body').append(detailsHtml);
   $('#procedureDetailsModal').modal('show');
}

function viewAssessmentDetails(assessmentId) {
   $.ajax({
       url: '<?php echo base_url("admin/nursing/get_assessment_details"); ?>',
       method: 'POST',
       data: { assessment_id: assessmentId },
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               showAssessmentDetailsModal(response.data);
           } else {
               alert('Error loading assessment details');
           }
       },
       error: function() {
           alert('Error loading assessment details');
       }
   });
}

function showAssessmentDetailsModal(assessData) {
   let detailsHtml = `
       <div class="modal fade" id="assessmentDetailsModal" tabindex="-1" role="dialog">
           <div class="modal-dialog modal-lg" role="document">
               <div class="modal-content">
                   <div class="modal-header">
                       <button type="button" class="close" data-dismiss="modal">&times;</button>
                       <h4 class="modal-title">Assessment Details</h4>
                   </div>
                   <div class="modal-body">
                       <div class="row">
                           <div class="col-md-6">
                               <table class="table table-bordered">
                                   <tr><td><strong>Type:</strong></td><td>${assessData.assessment_type}</td></tr>
                                   <tr><td><strong>Category:</strong></td><td>${assessData.assessment_category}</td></tr>
                                   <tr><td><strong>Risk Level:</strong></td><td>${assessData.risk_level}</td></tr>
                                   <tr><td><strong>Score:</strong></td><td>${assessData.assessment_score || 'N/A'}</td></tr>
                                   <tr><td><strong>Date:</strong></td><td>${assessData.assessment_date}</td></tr>
                                   <tr><td><strong>Assessed By:</strong></td><td>${assessData.assessed_by_name || ''}</td></tr>
                               </table>
                           </div>
                           <div class="col-md-6">
                               <h5>Assessment Details:</h5>
                               <p>${assessData.assessment_details}</p>
                               <h5>Recommendations:</h5>
                               <p>${assessData.recommendations || 'No recommendations'}</p>
                           </div>
                       </div>
                   </div>
                   <div class="modal-footer">
                       <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                   </div>
               </div>
           </div>
       </div>
   `;
   
   $('#assessmentDetailsModal').remove();
   $('body').append(detailsHtml);
   $('#assessmentDetailsModal').modal('show');
}

function viewCarePlanDetails(planId) {
   $.ajax({
       url: '<?php echo base_url("admin/nursing/get_care_plan_details"); ?>',
       method: 'POST',
       data: { plan_id: planId },
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               showCarePlanDetailsModal(response.data);
           } else {
               alert('Error loading care plan details');
           }
       },
       error: function() {
           alert('Error loading care plan details');
       }
   });
}

function showCarePlanDetailsModal(planData) {
   let detailsHtml = `
       <div class="modal fade" id="carePlanDetailsModal" tabindex="-1" role="dialog">
           <div class="modal-dialog modal-lg" role="document">
               <div class="modal-content">
                   <div class="modal-header">
                       <button type="button" class="close" data-dismiss="modal">&times;</button>
                       <h4 class="modal-title">Care Plan Details</h4>
                   </div>
                   <div class="modal-body">
                       <div class="row">
                           <div class="col-md-12">
                               <h4>${planData.plan_name}</h4>
                               <p><strong>Priority:</strong> <span class="label label-info">${planData.priority}</span> 
                                  <strong>Status:</strong> <span class="label label-success">${planData.status}</span></p>
                               <p><strong>Start Date:</strong> ${planData.start_date} | <strong>Target Date:</strong> ${planData.target_date || 'Not set'}</p>
                               <hr>
                               <h5>Nursing Diagnosis:</h5>
                               <p>${planData.nursing_diagnosis}</p>
                               <h5>Goals/Outcomes:</h5>
                               <p>${planData.goals_outcomes}</p>
                               <h5>Interventions:</h5>
                               <p>${planData.interventions}</p>
                               <h5>Evaluation Criteria:</h5>
                               <p>${planData.evaluation_criteria || 'Not specified'}</p>
                               <hr>
                               <p><small><strong>Created by:</strong> ${planData.created_by_name || ''} on ${planData.created_at}</small></p>
                           </div>
                       </div>
                   </div>
                   <div class="modal-footer">
                       <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                       <button type="button" class="btn btn-warning" onclick="editCarePlan(${planData.id})">Edit</button>
                   </div>
               </div>
           </div>
       </div>
   `;
   
   $('#carePlanDetailsModal').remove();
   $('body').append(detailsHtml);
   $('#carePlanDetailsModal').modal('show');
}

function viewMedicationDetails(medicationId) {
   $.ajax({
       url: '<?php echo base_url("admin/nursing/get_medication_details"); ?>',
       method: 'POST',
       data: { medication_id: medicationId },
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               showMedicationDetailsModal(response.data);
           } else {
               alert('Error loading medication details');
           }
       },
       error: function() {
           alert('Error loading medication details');
       }
   });
}

function showMedicationDetailsModal(medData) {
   let detailsHtml = `
       <div class="modal fade" id="medicationDetailsModal" tabindex="-1" role="dialog">
           <div class="modal-dialog" role="document">
               <div class="modal-content">
                   <div class="modal-header">
                       <button type="button" class="close" data-dismiss="modal">&times;</button>
                       <h4 class="modal-title">Medication Administration Details</h4>
                   </div>
                   <div class="modal-body">
                       <table class="table table-bordered">
                           <tr><td><strong>Medication:</strong></td><td>${medData.medicine_name}</td></tr>
                           <tr><td><strong>Dosage:</strong></td><td>${medData.dosage}</td></tr>
                           <tr><td><strong>Route:</strong></td><td>${medData.route}</td></tr>
                           <tr><td><strong>Date/Time:</strong></td><td>${medData.date}</td></tr>
                           <tr><td><strong>Given By:</strong></td><td>${medData.given_by_name || ''}</td></tr>
                           <tr><td><strong>Notes:</strong></td><td>${medData.notes || 'No notes'}</td></tr>
                       </table>
                   </div>
                   <div class="modal-footer">
                       <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                   </div>
               </div>
           </div>
       </div>
   `;
   
   $('#medicationDetailsModal').remove();
   $('body').append(detailsHtml);
   $('#medicationDetailsModal').modal('show');
}

// Initialize page
$(document).ready(function() {
   console.log('Patient profile loaded for patient ID: ' + $('#currentPatientId').val());
   
   // Form submission handlers
   $('#vitalSignsForm').on('submit', function(e) {
       e.preventDefault();
       
       $.ajax({
           url: $(this).attr('action'),
           method: 'POST',
           data: $(this).serialize(),
           dataType: 'json',
           success: function(response) {
               if (response.status === 'success') {
                   $('#vitalSignsModal').modal('hide');
                   location.reload(); // Refresh to show new data
               } else {
                   alert(response.message || 'Error saving vital signs');
               }
           },
           error: function() {
               alert('Error saving vital signs');
           }
       });
   });
   
// Enhanced debugging for nursing note form
$('#nursingNoteForm').on('submit', function(e) {
    e.preventDefault();
    console.log('=== NURSING NOTE FORM SUBMISSION DEBUG ===');
    console.log('Form submitted');
    console.log('Preventing default form submission');
    
    var formData = $(this).serialize();
    console.log('Form data:', formData);
    
    // Check if required fields are present
    var patientId = $('#notePatientId').val();
    var note = $('textarea[name="note"]').val();
    
    console.log('Patient ID:', patientId);
    console.log('Note content:', note);
    
    if (!patientId) {
        alert('❌ Patient ID is missing');
        console.error('Patient ID is missing');
        return;
    }
    
    if (!note || note.trim() === '') {
        alert('❌ Note content is required');
        console.error('Note content is empty');
        return;
    }
    
    var submitBtn = $(this).find('button[type="submit"]');
    var originalText = submitBtn.html();
    submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Saving...').prop('disabled', true);
    
    console.log('Making AJAX request to:', '<?php echo base_url("admin/nursing/save_nursing_note"); ?>');
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/save_nursing_note"); ?>',
        method: 'POST',
        data: formData,
        dataType: 'json',
        timeout: 15000,
        beforeSend: function() {
            console.log('AJAX request starting...');
        },
        success: function(response) {
            console.log('AJAX Success - Response received:', response);
            
            if (response && response.status === 'success') {
                console.log('✅ Success response');
                alert('✅ ' + response.message);
                $('#nursingNoteModal').modal('hide');
                $('#nursingNoteForm')[0].reset();
                setTimeout(function() {
                    location.reload();
                }, 1000);
            } else {
                console.log('❌ Error response');
                var errorMsg = response && response.message ? response.message : 'Unknown error occurred';
                alert('❌ Error: ' + errorMsg);
                console.error('Response error:', response);
            }
        },
        error: function(xhr, status, error) {
            console.log('AJAX Error occurred');
            console.error('XHR object:', xhr);
            console.error('Status:', status);
            console.error('Error:', error);
            console.error('Response Text:', xhr.responseText);
            console.error('Status Code:', xhr.status);
            
            var errorMsg = 'Failed to save nursing kardex';
            if (xhr.status === 404) {
                errorMsg += ' (Route not found - check controller method)';
            } else if (xhr.status === 500) {
                errorMsg += ' (Server error - check logs)';
            } else if (status === 'timeout') {
                errorMsg += ' (Request timed out)';
            } else if (status === 'parsererror') {
                errorMsg += ' (Invalid JSON response)';
            }
            
            alert('❌ ' + errorMsg);
            
            // Show detailed error for debugging
            if (xhr.responseText) {
                console.log('=== SERVER RESPONSE ===');
                console.log(xhr.responseText);
                console.log('=== END SERVER RESPONSE ===');
            }
        },
        complete: function() {
            console.log('AJAX request completed');
            // Restore button state
            submitBtn.html(originalText).prop('disabled', false);
        }
    });
    
    console.log('=== END NURSING NOTE DEBUG ===');
});
   
   $('#assessmentForm').on('submit', function(e) {
       e.preventDefault();
       
       $.ajax({
           url: $(this).attr('action'),
           method: 'POST',
           data: $(this).serialize(),
           dataType: 'json',
           success: function(response) {
               if (response.status === 'success') {
                   $('#assessmentModal').modal('hide');
                   location.reload();
               } else {
                   alert(response.message || 'Error saving assessment');
               }
           },
           error: function() {
               alert('Error saving assessment');
           }
       });
   });
   
   $('#procedureForm').on('submit', function(e) {
       e.preventDefault();
       
       $.ajax({
           url: $(this).attr('action'),
           method: 'POST',
           data: $(this).serialize(),
           dataType: 'json',
           success: function(response) {
               if (response.status === 'success') {
                   $('#procedureModal').modal('hide');
                   location.reload();
               } else {
                   alert(response.message || 'Error saving procedure');
               }
           },
           error: function() {
               alert('Error saving procedure');
           }
       });
   });
   
   $('#carePlanForm').on('submit', function(e) {
       e.preventDefault();
       
       $.ajax({
           url: $(this).attr('action'),
           method: 'POST',
           data: $(this).serialize(),
           dataType: 'json',
           success: function(response) {
               if (response.status === 'success') {
                   $('#carePlanModal').modal('hide');
                   location.reload();
               } else {
                   alert(response.message || 'Error saving care plan');
               }
           },
           error: function() {
               alert('Error saving care plan');
           }
       });
   });
});
</script>

<style>
.timeline {
   position: relative;
   margin: 0 0 30px 0;
   padding: 0;
   list-style: none;
}

.timeline:before {
   content: '';
   position: absolute;
   top: 0;
   bottom: 0;
   width: 4px;
   background: #ddd;
   left: 31px;
   margin: 0;
   border-radius: 2px;
}

.timeline > div {
   position: relative;
   margin-right: 10px;
   margin-bottom: 15px;
}

.timeline > div > .timeline-item {
   box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
   border-radius: 3px;
   margin-top: 0;
   background: #fff;
   color: #444;
   margin-left: 60px;
   margin-right: 15px;
   margin-bottom: 15px;
   padding: 0;
   position: relative;
}

.timeline > div > .fa,
.timeline > div > .glyphicon,
.timeline > div > .ion {
   width: 30px;
   height: 30px;
   font-size: 15px;
   line-height: 30px;
   position: absolute;
   color: #666;
   background: #d2d6de;
   border-radius: 50%;
   text-align: center;
   left: 18px;
   top: 0;
}

.timeline > .time-label > span {
   font-weight: 600;
   color: #fff;
   font-size: 16px;
   background-color: #00a65a;
   display: inline-block;
   padding: 5px 10px;
   border-radius: 4px;
}

.timeline-header {
   margin: 0;
   color: #555;
   border-bottom: 1px solid #f4f4f4;
   padding: 10px;
   font-weight: 600;
   font-size: 16px;
}

.timeline-body,
.timeline-footer {
   padding: 10px;
}

.nav-tabs-custom {
   margin-bottom: 20px;
   background: #fff;
   box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
   border-radius: 3px;
}

.nav-tabs-custom > .nav-tabs {
   margin: 0;
   border-bottom-color: #f4f4f4;
}

.nav-tabs-custom > .nav-tabs > li {
   border-top: 3px solid transparent;
   margin-bottom: -2px;
   margin-right: 5px;
}

.nav-tabs-custom > .nav-tabs > li > a {
   border-radius: 0;
   border-top: 0;
   color: #444;
   background-color: #fafafa;
}

.nav-tabs-custom > .nav-tabs > li.active > a {
   background-color: #fff;
   color: #444;
   border-bottom-color: transparent;
   border-left-color: #ddd;
   border-right-color: #ddd;
}

.nav-tabs-custom > .nav-tabs > li.active {
   border-top-color: #3c8dbc;
}

.box {
   position: relative;
   border-radius: 3px;
   background: #ffffff;
   border-top: 3px solid #d2d6de;
   margin-bottom: 20px;
   width: 100%;
   box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.box.box-primary {
   border-top-color: #3c8dbc;
}

.box.box-info {
   border-top-color: #00c0ef;
}

.box.box-success {
   border-top-color: #00a65a;
}

.box-header {
   color: #444;
   display: block;
   padding: 10px;
   position: relative;
}

.box-header.with-border {
   border-bottom: 1px solid #f4f4f4;
}

.box-title {
   font-size: 18px;
   margin: 0;
   line-height: 1;
}

.box-body {
   border-top-left-radius: 0;
   border-top-right-radius: 0;
   border-bottom-right-radius: 3px;
   border-bottom-left-radius: 3px;
   padding: 10px;
}

.box-tools {
   position: absolute;
   right: 10px;
   top: 5px;
}

.label {
   display: inline;
   padding: .2em .6em .3em;
   font-size: 75%;
   font-weight: 700;
   line-height: 1;
   color: #fff;
   text-align: center;
   white-space: nowrap;
   vertical-align: baseline;
   border-radius: .25em;
}

.label-default {
   background-color: #777;
}

.label-primary {
   background-color: #337ab7;
}

.label-success {
   background-color: #5cb85c;
}

.label-info {
   background-color: #5bc0de;
}

.label-warning {
   background-color: #f0ad4e;
}

.label-danger {
   background-color: #d9534f;
}

.table-hover tbody tr:hover {
   background-color: #f5f5f5;
}

.btn-block {
   display: block;
   width: 100%;
}

.pull-right {
   float: right !important;
}

.text-danger {
   color: #d9534f !important;
}

.bg-blue {
   background-color: #3c8dbc !important;
}

.bg-yellow {
   background-color: #f39c12 !important;
}

.bg-gray {
   background-color: #d2d6de !important;
}

.alert {
   padding: 15px;
   margin-bottom: 20px;
   border: 1px solid transparent;
   border-radius: 4px;
}

.alert-info {
   color: #31708f;
   background-color: #d9edf7;
   border-color: #bce8f1;
}

.modal-header .close {
   margin-top: -2px;
}

.form-control {
   display: block;
   width: 100%;
   height: 34px;
   padding: 6px 12px;
   font-size: 14px;
   line-height: 1.42857143;
   color: #555;
   background-color: #fff;
   background-image: none;
   border: 1px solid #ccc;
   border-radius: 4px;
   -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
   box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
   -webkit-transition: border-color ease-in-out .15s,-webkit-box-shadow ease-in-out .15s;
   -o-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
   transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
}

.form-control:focus {
   border-color: #66afe9;
   outline: 0;
   -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102,175,233,.6);
   box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102,175,233,.6);
}

.form-group {
   margin-bottom: 15px;
}

.form-group label {
   display: inline-block;
   max-width: 100%;
   margin-bottom: 5px;
   font-weight: bold;
}

textarea.form-control {
   height: auto;
}

.btn {
   display: inline-block;
   padding: 6px 12px;
   margin-bottom: 0;
   font-size: 14px;
   font-weight: normal;
   line-height: 1.42857143;
   text-align: center;
   white-space: nowrap;
   vertical-align: middle;
   -ms-touch-action: manipulation;
   touch-action: manipulation;
   cursor: pointer;
   -webkit-user-select: none;
   -moz-user-select: none;
   -ms-user-select: none;
   user-select: none;
   background-image: none;
   border: 1px solid transparent;
   border-radius: 4px;
}

.btn-default {
   color: #333;
   background-color: #fff;
   border-color: #ccc;
}

.btn-primary {
   color: #fff;
   background-color: #337ab7;
   border-color: #2e6da4;
}

.btn-success {
   color: #fff;
   background-color: #5cb85c;
   border-color: #4cae4c;
}

.btn-info {
   color: #fff;
   background-color: #5bc0de;
   border-color: #46b8da;
}

.btn-warning {
   color: #fff;
   background-color: #f0ad4e;
   border-color: #eea236;
}

.btn-xs {
   padding: 1px 5px;
   font-size: 12px;
   line-height: 1.5;
   border-radius: 3px;
}

.btn-sm {
   padding: 5px 10px;
   font-size: 12px;
   line-height: 1.5;
   border-radius: 3px;
}

.modal {
   position: fixed;
   top: 0;
   right: 0;
   bottom: 0;
   left: 0;
   z-index: 1050;
   display: none;
   overflow: hidden;
   -webkit-overflow-scrolling: touch;
   outline: 0;
}

.modal.fade .modal-dialog {
   -webkit-transition: -webkit-transform .3s ease-out;
   -o-transition: -o-transform .3s ease-out;
   transition: transform .3s ease-out;
   -webkit-transform: translate(0,-25%);
   -ms-transform: translate(0,-25%);
   -o-transform: translate(0,-25%);
   transform: translate(0,-25%);
}

.modal.in .modal-dialog {
   -webkit-transform: translate(0,0);
   -ms-transform: translate(0,0);
   -o-transform: translate(0,0);
   transform: translate(0,0);
}

.modal-dialog {
   position: relative;
   width: auto;
   margin: 10px;
}

.modal-dialog.modal-lg {
   width: 900px;
}

.modal-content {
   position: relative;
   background-color: #fff;
   -webkit-background-clip: padding-box;
   background-clip: padding-box;
   border: 1px solid #999;
   border: 1px solid rgba(0,0,0,.2);
   border-radius: 6px;
   outline: 0;
   -webkit-box-shadow: 0 3px 9px rgba(0,0,0,.5);
   box-shadow: 0 3px 9px rgba(0,0,0,.5);
}

.modal-header {
   min-height: 16.43px;
   padding: 15px;
   border-bottom: 1px solid #e5e5e5;
}

.modal-header .modal-title {
   margin: 0;
   line-height: 1.42857143;
}

.modal-body {
   position: relative;
   padding: 15px;
}

.modal-footer {
   padding: 15px;
   text-align: right;
   border-top: 1px solid #e5e5e5;
}

.modal-footer .btn + .btn {
   margin-bottom: 0;
   margin-left: 5px;
}

.close {
   float: right;
   font-size: 21px;
   font-weight: bold;
   line-height: 1;
   color: #000;
   text-shadow: 0 1px 0 #fff;
   filter: alpha(opacity=20);
   opacity: .2;
}

.close:hover,
.close:focus {
   color: #000;
   text-decoration: none;
   cursor: pointer;
   filter: alpha(opacity=50);
   opacity: .5;
}

.table {
   width: 100%;
   max-width: 100%;
   margin-bottom: 20px;
}

.table > thead > tr > th,
.table > tbody > tr > th,
.table > tfoot > tr > th,
.table > thead > tr > td,
.table > tbody > tr > td,
.table > tfoot > tr > td {
   padding: 8px;
   line-height: 1.42857143;
   vertical-align: top;
   border-top: 1px solid #ddd;
}

.table > thead > tr > th {
   vertical-align: bottom;
   border-bottom: 2px solid #ddd;
}

.table-striped > tbody > tr:nth-of-type(odd) {
   background-color: #f9f9f9;
}

.table-bordered {
   border: 1px solid #ddd;
}

.table-bordered > thead > tr > th,
.table-bordered > tbody > tr > th,
.table-bordered > tfoot > tr > th,
.table-bordered > thead > tr > td,
.table-bordered > tbody > tr > td,
.table-bordered > tfoot > tr > td {
   border: 1px solid #ddd;
}

.table-responsive {
   min-height: .01%;
   overflow-x: auto;
}

.row {
   margin-right: -15px;
   margin-left: -15px;
}

.col-md-4,
.col-md-6,
.col-md-8,
.col-md-12 {
   position: relative;
   min-height: 1px;
   padding-right: 15px;
   padding-left: 15px;
}

@media (min-width: 992px) {
   .col-md-4 {
       width: 33.33333333%;
       float: left;
   }
   .col-md-6 {
       width: 50%;
       float: left;
   }
   .col-md-8 {
       width: 66.66666667%;
       float: left;
   }
   .col-md-12 {
       width: 100%;
       float: left;
   }
}

@media print {
   .box-tools, .btn, .modal {
       display: none !important;
   }
}

.breadcrumb {
   padding: 8px 15px;
   margin-bottom: 20px;
   list-style: none;
   background-color: #f5f5f5;
   border-radius: 4px;
}

.breadcrumb > li {
   display: inline-block;
}

.breadcrumb > li + li:before {
   padding: 0 5px;
   color: #ccc;
   content: "/\00a0";
}

.content-header > h1 {
   margin: 0;
   font-size: 24px;
}

.content-header > h1 > small {
   font-size: 15px;
   display: inline-block;
   padding-left: 4px;
   font-weight: 300;
   color: #6c757d;
}

.content {
   min-height: 250px;
   padding: 0 15px;
   margin-right: auto;
   margin-left: auto;
}

.fa:before {
   -webkit-font-smoothing: antialiased;
}

/* Font Awesome Icons - Add these if FontAwesome is not loaded */
.fa-user-md:before { content: "\f0f0"; }
.fa-dashboard:before { content: "\f0e4"; }
.fa-stethoscope:before { content: "\f0f1"; }
.fa-user:before { content: "\f007"; }
.fa-hospital-o:before { content: "\f0f8"; }
.fa-bolt:before { content: "\f0e7"; }
.fa-heartbeat:before { content: "\f21e"; }
.fa-edit:before { content: "\f044"; }
.fa-clipboard:before { content: "\f0ea"; }
.fa-tasks:before { content: "\f0ae"; }
.fa-plus:before { content: "\f067"; }
.fa-eye:before { content: "\f06e"; }
.fa-info-circle:before { content: "\f05a"; }
.fa-clock-o:before { content: "\f017"; }

/* Additional responsive styles */
@media (max-width: 768px) {
   .modal-dialog {
       width: 100%;
       margin: 0;
   }
   
   .col-md-4,
   .col-md-6,
   .col-md-8,
   .col-md-12 {
       width: 100%;
       margin-bottom: 15px;
   }
   
   .table-responsive {
       border: none;
   }
   
   .btn-block {
       margin-bottom: 10px;
   }
   
   .timeline {
       margin-left: 0;
   }
   
   .timeline:before {
       left: 15px;
   }
   
   .timeline > div > .timeline-item {
       margin-left: 45px;
   }
}

/* Custom animations */
@keyframes fadeIn {
   from { opacity: 0; }
   to { opacity: 1; }
}

.timeline-item {
   animation: fadeIn 0.5s ease-in;
}

/* Print styles */
@media print {
   .content-wrapper {
       margin: 0;
   }
   
   .box {
       border: 1px solid #000;
       box-shadow: none;
       page-break-inside: avoid;
   }
   
   .box-header {
       background: #f0f0f0;
       border-bottom: 1px solid #000;
   }
   
   .label {
       border: 1px solid #000;
       color: #000 !important;
       background: #fff !important;
   }
   
   .timeline:before {
       background: #000;
   }
   
   .nav-tabs-custom {
       display: none;
   }
   
   .tab-content > .tab-pane {
       display: block !important;
       opacity: 1 !important;
   }
}
</style>
<style>
.consultation-summary, .diagnosis-summary {
    font-size: 12px;
    line-height: 1.3;
}

.prescription-items {
    font-size: 11px;
}

.prescription-item {
    margin-bottom: 5px;
    padding: 3px;
    background-color: #f9f9f9;
    border-radius: 3px;
}

.visit-symptoms {
    font-size: 11px;
    line-height: 1.2;
}

.vital-signs-summary {
    font-size: 10px;
}

.vital-item {
    display: inline-block;
    margin-right: 5px;
}

.well-sm {
    padding: 9px;
    border-radius: 3px;
    background-color: #f5f5f5;
    border: 1px solid #e3e3e3;
    box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
}

.timeline-item .alert {
    margin-bottom: 5px;
    padding: 8px 12px;
}

@media (max-width: 768px) {
    .table-responsive {
        font-size: 11px;
    }
    
    .consultation-summary, .diagnosis-summary, .visit-symptoms {
        font-size: 10px;
    }
    
    .prescription-item {
        margin-bottom: 3px;
        padding: 2px;
    }
}
</style>
