<!-- Nursing Modals for Patient Profile -->

<!-- Vital Signs Modal -->
<div class="modal fade" id="vitalSignsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg-custom" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-heartbeat"></i> Record Vital Signs
                </h4>
            </div>
            <form id="vitalSignsForm">
                <div class="modal-body">
                    <input type="hidden" name="patient_id" value="<?php echo $patient['id']; ?>">
                    <input type="hidden" name="ipd_id" value="<?php echo !empty($ipd_details) ? $ipd_details['id'] : ''; ?>">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-thermometer-half"></i> Temperature</h6>
                                <div class="row">
                                    <div class="col-md-8">
                                        <input type="number" class="form-control" name="temperature" step="0.1" min="30" max="45" required>
                                    </div>
                                    <div class="col-md-4">
                                        <select class="form-control" name="temperature_unit">
                                            <option value="C">°C</option>
                                            <option value="F">°F</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-tint"></i> Blood Pressure</h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="number" class="form-control" name="systolic_bp" placeholder="Systolic" min="50" max="300" required>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" class="form-control" name="diastolic_bp" placeholder="Diastolic" min="30" max="200" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-heartbeat"></i> Pulse Rate</h6>
                                <input type="number" class="form-control" name="pulse_rate" placeholder="beats per minute" min="20" max="250" required>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-lungs"></i> Respiratory Rate</h6>
                                <input type="number" class="form-control" name="respiratory_rate" placeholder="breaths per minute" min="5" max="60" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-percentage"></i> Oxygen Saturation</h6>
                                <input type="number" class="form-control" name="oxygen_saturation" placeholder="%" min="50" max="100">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-exclamation-triangle"></i> Pain Scale (0-10)</h6>
                                <select class="form-control" name="pain_scale">
                                    <option value="">Select pain level</option>
                                    <option value="0">0 - No Pain</option>
                                    <option value="1">1 - Minimal</option>
                                    <option value="2">2 - Mild</option>
                                    <option value="3">3 - Uncomfortable</option>
                                    <option value="4">4 - Moderate</option>
                                    <option value="5">5 - Distracting</option>
                                    <option value="6">6 - Distressing</option>
                                    <option value="7">7 - Unmanageable</option>
                                    <option value="8">8 - Intense</option>
                                    <option value="9">9 - Severe</option>
                                    <option value="10">10 - Unable to Move</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-weight"></i> Weight (kg)</h6>
                                <input type="number" class="form-control" name="weight" step="0.1" min="0" max="500">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-arrows-v"></i> Height (cm)</h6>
                                <input type="number" class="form-control" name="height" step="0.1" min="0" max="300">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-comment"></i> Notes</h6>
                        <textarea class="form-control" name="notes" rows="3" placeholder="Additional observations or notes..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-save"></i> Record Vital Signs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Nurse Note Modal -->
<div class="modal fade" id="nurseNoteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg-custom" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Add Nursing Note
                </h4>
            </div>
            <form id="nurseNoteForm">
                <div class="modal-body">
                    <input type="hidden" name="patient_id" value="<?php echo $patient['id']; ?>">
                    <input type="hidden" name="ipd_id" value="<?php echo !empty($ipd_details) ? $ipd_details['id'] : ''; ?>">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-calendar"></i> Date & Time</h6>
                                <input type="datetime-local" class="form-control" name="date" value="<?php echo date('Y-m-d\TH:i'); ?>" required>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-tag"></i> Note Type</h6>
                                <select class="form-control" name="note_type" required>
                                    <option value="">Select note type</option>
                                    <option value="assessment">Assessment</option>
                                    <option value="intervention">Intervention</option>
                                    <option value="medication">Medication</option>
                                    <option value="education">Patient Education</option>
                                    <option value="communication">Communication</option>
                                    <option value="discharge_planning">Discharge Planning</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-exclamation-circle"></i> Priority</h6>
                                <select class="form-control" name="priority">
                                    <option value="normal">Normal</option>
                                    <option value="high">High</option>
                                    <option value="urgent">Urgent</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-clock-o"></i> Shift</h6>
                                <select class="form-control" name="shift">
                                    <option value="">Select shift</option>
                                    <option value="day">Day Shift</option>
                                    <option value="evening">Evening Shift</option>
                                    <option value="night">Night Shift</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-file-text-o"></i> Nursing Note</h6>
                        <textarea class="form-control" name="note" id="nurseNote" rows="6" placeholder="Enter detailed nursing note..." required></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-comment"></i> Additional Comments</h6>
                        <textarea class="form-control" name="comment" rows="3" placeholder="Additional comments or follow-up actions..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Add Note
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Procedure Modal -->
<div class="modal fade" id="procedureModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg-custom" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-tasks"></i> Schedule/Record Procedure
                </h4>
            </div>
            <form id="procedureForm">
                <div class="modal-body">
                    <input type="hidden" name="patient_id" value="<?php echo $patient['id']; ?>">
                    <input type="hidden" name="ipd_id" value="<?php echo !empty($ipd_details) ? $ipd_details['id'] : ''; ?>">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-list"></i> Procedure Type</h6>
                                <select class="form-control" name="procedure_type" id="procedureType" required>
                                    <option value="">Select procedure type</option>
                                    <option value="wound_care">Wound Care</option>
                                    <option value="catheter_care">Catheter Care</option>
                                    <option value="medication">Medication Administration</option>
                                    <option value="iv_therapy">IV Therapy</option>
                                    <option value="respiratory">Respiratory Care</option>
                                    <option value="vital_signs">Vital Signs Monitoring</option>
                                    <option value="mobility_assistance">Mobility Assistance</option>
                                    <option value="hygiene_care">Hygiene Care</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-file-text"></i> Procedure Name</h6>
                                <input type="text" class="form-control" name="procedure_name" placeholder="Enter procedure name" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-code"></i> Procedure Code</h6>
                                <input type="text" class="form-control" name="procedure_code" placeholder="Optional procedure code">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-clock-o"></i> Performed At</h6>
                                <input type="datetime-local" class="form-control" name="performed_at" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-info-circle"></i> Description</h6>
                        <textarea class="form-control" name="description" rows="3" placeholder="Procedure description and details..."></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-clipboard"></i> Pre-Procedure Notes</h6>
                        <textarea class="form-control" name="pre_procedure_notes" rows="3" placeholder="Pre-procedure assessment and preparation..."></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-check-circle"></i> Post-Procedure Notes</h6>
                        <textarea class="form-control" name="post_procedure_notes" rows="3" placeholder="Post-procedure observations and patient response..."></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-warning"></i> Complications</h6>
                                <textarea class="form-control" name="complications" rows="2" placeholder="Any complications encountered..."></textarea>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-flag"></i> Outcome</h6>
                                <select class="form-control" name="outcome">
                                    <option value="successful">Successful</option>
                                    <option value="partial">Partial Success</option>
                                    <option value="failed">Failed</option>
                                    <option value="complications">Complications</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-info"></i> Status</h6>
                        <select class="form-control" name="status">
                            <option value="completed">Completed</option>
                            <option value="scheduled">Scheduled</option>
                            <option value="in_progress">In Progress</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fa fa-save"></i> Record Procedure
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Assessment Modal -->
<div class="modal fade" id="assessmentModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg-custom" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-clipboard"></i> Nursing Assessment
                </h4>
            </div>
            <form id="assessmentForm">
                <div class="modal-body">
                    <input type="hidden" name="patient_id" value="<?php echo $patient['id']; ?>">
                    <input type="hidden" name="ipd_id" value="<?php echo !empty($ipd_details) ? $ipd_details['id'] : ''; ?>">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-list"></i> Assessment Type</h6>
                                <select class="form-control" name="assessment_type" id="assessmentType" required>
                                    <option value="">Select assessment type</option>
                                    <option value="pain">Pain Assessment</option>
                                    <option value="fall_risk">Fall Risk Assessment</option>
                                    <option value="skin_integrity">Skin Integrity Assessment</option>
                                    <option value="mental_status">Mental Status Assessment</option>
                                    <option value="mobility">Mobility Assessment</option>
                                    <option value="nutrition">Nutritional Assessment</option>
                                    <option value="respiratory">Respiratory Assessment</option>
                                    <option value="cardiovascular">Cardiovascular Assessment</option>
                                    <option value="neurological">Neurological Assessment</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-calendar"></i> Assessment Date</h6>
                                <input type="datetime-local" class="form-control" name="assessment_date" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-search"></i> Findings</h6>
                        <textarea class="form-control" name="findings" rows="4" placeholder="Assessment findings and observations..." required></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-lightbulb-o"></i> Recommendations</h6>
                        <textarea class="form-control" name="recommendations" rows="3" placeholder="Nursing interventions and recommendations..."></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-exclamation-triangle"></i> Risk Level</h6>
                        <select class="form-control" name="risk_level">
                            <option value="low">Low Risk</option>
                            <option value="medium">Medium Risk</option>
                            <option value="high">High Risk</option>
                            <option value="critical">Critical Risk</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-info">
                        <i class="fa fa-save"></i> Complete Assessment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Care Plan Modal -->
<div class="modal fade" id="carePlanModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg-custom" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-list-alt"></i> Create Care Plan
                </h4>
            </div>
            <form id="carePlanForm">
                <div class="modal-body">
                    <input type="hidden" name="patient_id" value="<?php echo $patient['id']; ?>">
                    <input type="hidden" name="ipd_id" value="<?php echo !empty($ipd_details) ? $ipd_details['id'] : ''; ?>">
                    
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-section">
                                <h6><i class="fa fa-tag"></i> Care Plan Name</h6>
                                <input type="text" class="form-control" name="plan_name" id="carePlanName" placeholder="Enter care plan name" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-section">
                                <h6><i class="fa fa-flag"></i> Priority</h6>
                                <select class="form-control" name="priority">
                                    <option value="low">Low</option>
                                    <option value="medium" selected>Medium</option>
                                    <option value="high">High</option>
                                    <option value="urgent">Urgent</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-stethoscope"></i> Nursing Diagnosis</h6>
                        <textarea class="form-control" name="nursing_diagnosis" id="nursingDiagnosis" rows="3" placeholder="Enter nursing diagnosis..."></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-bullseye"></i> Goals</h6>
                        <textarea class="form-control" name="goals" id="carePlanGoals" rows="4" placeholder="Enter measurable and achievable goals..." required></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-cogs"></i> Interventions</h6>
                        <textarea class="form-control" name="interventions" rows="4" placeholder="Enter specific nursing interventions..."></textarea>
                    </div>
                    
                    <div class="form-section">
                        <h6><i class="fa fa-check-square-o"></i> Evaluations</h6>
                        <textarea class="form-control" name="evaluations" rows="3" placeholder="Enter evaluation criteria and methods..."></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-calendar"></i> Start Date</h6>
                                <input type="date" class="form-control" name="start_date" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-section">
                                <h6><i class="fa fa-calendar-check-o"></i> Target Date</h6>
                                <input type="date" class="form-control" name="target_date">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Create Care Plan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Form Handlers -->
<script>
$(document).ready(function() {
    // Form submissions
    $('#vitalSignsForm').on('submit', function(e) {
        e.preventDefault();
        submitForm(this, '<?php echo base_url("admin/nursing/add_vital_signs"); ?>', 'Vital signs recorded successfully');
    });
    
    $('#nurseNoteForm').on('submit', function(e) {
        e.preventDefault();
        submitForm(this, '<?php echo base_url("admin/nursing/add_nurse_note"); ?>', 'Nursing note added successfully');
    });
    
    $('#procedureForm').on('submit', function(e) {
        e.preventDefault();
        submitForm(this, '<?php echo base_url("admin/nursing/add_procedure"); ?>', 'Procedure recorded successfully');
    });
    
    $('#assessmentForm').on('submit', function(e) {
        e.preventDefault();
        submitForm(this, '<?php echo base_url("admin/nursing/add_assessment"); ?>', 'Assessment completed successfully');
    });
    
    $('#carePlanForm').on('submit', function(e) {
        e.preventDefault();
        submitForm(this, '<?php echo base_url("admin/nursing/create_care_plan"); ?>', 'Care plan created successfully');
    });
});

// Generic form submission handler
function submitForm(form, url, successMessage) {
    var formData = $(form).serialize();
    var submitBtn = $(form).find('button[type="submit"]');
    var originalText = submitBtn.html();
    
    // Show loading state
    submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Saving...').prop('disabled', true);
    
    $.ajax({
        url: url,
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showAlert(successMessage, 'success');
                $(form).closest('.modal').modal('hide');
                $(form)[0].reset();
                
                // Reload page after short delay to show updated data
                setTimeout(function() {
                    location.reload();
                }, 1500);
            } else {
                if (response.errors) {
                    // Show validation errors
                    var errorMsg = 'Please correct the following errors:\n';
                    for (var field in response.errors) {
                        if (response.errors[field]) {
                            errorMsg += '- ' + response.errors[field] + '\n';
                        }
                    }
                    showAlert(errorMsg, 'error');
                } else {
                    showAlert(response.message || 'An error occurred', 'error');
                }
            }
        },
        error: function(xhr, status, error) {
            showAlert('Failed to save data. Please try again.', 'error');
            console.error('Form submission error:', error);
        },
        complete: function() {
            // Restore button state
            submitBtn.html(originalText).prop('disabled', false);
        }
    });
}

// Modal reset handlers
$('.modal').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $(this).find('.has-error').removeClass('has-error');
    $(this).find('.help-block').remove();
});

// Dynamic form field handlers
$('#procedureType').on('change', function() {
    var type = $(this).val();
    var procedureNames = {
        'wound_care': ['Wound Assessment', 'Dressing Change', 'Wound Irrigation', 'Suture Removal'],
        'catheter_care': ['Catheter Insertion', 'Catheter Care', 'Catheter Removal', 'Bladder Irrigation'],
        'medication': ['Oral Medication', 'IM Injection', 'IV Medication', 'Topical Application'],
        'iv_therapy': ['IV Insertion', 'IV Maintenance', 'IV Removal', 'Blood Draw'],
        'respiratory': ['Oxygen Therapy', 'Nebulizer Treatment', 'Chest Physiotherapy', 'Suction'],
        'vital_signs': ['Blood Pressure Check', 'Temperature Monitoring', 'Pulse Oximetry', 'Weight Check'],
        'mobility_assistance': ['Ambulation', 'Transfer Assistance', 'Range of Motion', 'Positioning'],
        'hygiene_care': ['Bed Bath', 'Oral Care', 'Hair Care', 'Skin Care']
    };
    
    var nameField = $('input[name="procedure_name"]');
    if (procedureNames[type]) {
        nameField.attr('list', 'procedureNamesList');
        var datalist = $('#procedureNamesList');
        if (datalist.length === 0) {
            datalist = $('<datalist id="procedureNamesList"></datalist>');
            nameField.after(datalist);
        }
        datalist.empty();
        procedureNames[type].forEach(function(name) {
            datalist.append('<option value="' + name + '">');
        });
    }
});

$('#assessmentType').on('change', function() {
    var type = $(this).val();
    var assessmentTemplates = {
        'pain': 'Patient reports pain level. Location, quality, duration, and aggravating/alleviating factors assessed.',
        'fall_risk': 'Fall risk assessment completed using standardized tool. Risk factors evaluated and safety measures implemented.',
        'skin_integrity': 'Skin assessment completed. Areas of concern noted and interventions planned.',
        'mental_status': 'Mental status evaluation completed. Orientation, mood, and cognitive function assessed.',
        'mobility': 'Mobility assessment completed. Range of motion, strength, and functional capacity evaluated.',
        'nutrition': 'Nutritional assessment completed. Dietary intake, weight status, and nutritional needs evaluated.',
        'respiratory': 'Respiratory assessment completed. Breathing patterns, oxygen saturation, and lung sounds evaluated.',
        'cardiovascular': 'Cardiovascular assessment completed. Heart rate, rhythm, and circulation evaluated.',
        'neurological': 'Neurological assessment completed. Level of consciousness, reflexes, and neurological function evaluated.'
    };
    
    if (assessmentTemplates[type]) {
        $('textarea[name="findings"]').attr('placeholder', assessmentTemplates[type]);
    }
});

// Vital signs validation
$('input[name="systolic_bp"], input[name="diastolic_bp"]').on('blur', function() {
    var systolic = parseInt($('input[name="systolic_bp"]').val());
    var diastolic = parseInt($('input[name="diastolic_bp"]').val());
    
    if (systolic && diastolic && systolic <= diastolic) {
        showAlert('Warning: Systolic pressure should be higher than diastolic pressure', 'warning');
    }
});

$('input[name="temperature"]').on('blur', function() {
    var temp = parseFloat($(this).val());
    var unit = $('select[name="temperature_unit"]').val();
    
    if (temp) {
        if (unit === 'C' && (temp < 35 || temp > 42)) {
            showAlert('Warning: Temperature reading seems unusual for Celsius', 'warning');
        } else if (unit === 'F' && (temp < 95 || temp > 108)) {
            showAlert('Warning: Temperature reading seems unusual for Fahrenheit', 'warning');
        }
    }
});

// Auto-populate fields based on templates
function populateVitalSignsFromLatest() {
    // This would populate from the latest vital signs if available
    // Implementation would depend on having the latest data available
}

// Advanced form features
function addMedicationToNote() {
    var medications = <?php echo json_encode($medications); ?>;
    var noteField = $('#nurseNote');
    var currentNote = noteField.val();
    
    if (medications.length > 0) {
        var medList = '\n\nCurrent Medications:\n';
        medications.forEach(function(med) {
            medList += '- ' + med.medicine_name + ' ' + med.medicine_dosage + ' ' + med.unit_name + '\n';
        });
        noteField.val(currentNote + medList);
    }
}

function addVitalSignsToNote() {
    var vitals = <?php echo json_encode(!empty($vital_signs) ? $vital_signs[0] : null); ?>;
    var noteField = $('#nurseNote');
    var currentNote = noteField.val();
    
    if (vitals) {
        var vitalsList = '\n\nLatest Vital Signs:\n';
        vitalsList += '- Temperature: ' + vitals.temperature + '°' + vitals.temperature_unit + '\n';
        vitalsList += '- Blood Pressure: ' + vitals.systolic_bp + '/' + vitals.diastolic_bp + ' mmHg\n';
        vitalsList += '- Pulse: ' + vitals.pulse_rate + ' bpm\n';
        vitalsList += '- Respiratory Rate: ' + vitals.respiratory_rate + ' bpm\n';
        if (vitals.oxygen_saturation) {
            vitalsList += '- O2 Saturation: ' + vitals.oxygen_saturation + '%\n';
        }
        if (vitals.pain_scale) {
            vitalsList += '- Pain Scale: ' + vitals.pain_scale + '/10\n';
        }
        noteField.val(currentNote + vitalsList);
    }
}

// Add helper buttons to nursing note modal
$('#nurseNoteModal .modal-body').append(`
    <div class="form-section">
        <h6><i class="fa fa-magic"></i> Quick Add</h6>
        <button type="button" class="btn btn-xs btn-info" onclick="addVitalSignsToNote()">
            <i class="fa fa-heartbeat"></i> Add Vital Signs
        </button>
        <button type="button" class="btn btn-xs btn-warning" onclick="addMedicationToNote()">
            <i class="fa fa-pills"></i> Add Medications
        </button>
    </div>
`);

console.log('Nursing modals initialized successfully!');
</script>