<div class="row">
    <div class="col-md-6">
        <h4><i class="fa fa-user"></i> Patient Information</h4>
        <table class="table table-bordered table-condensed">
            <tr>
                <td width="40%"><strong>Patient Name:</strong></td>
                <td><?php echo $vital['patient_name'] ?? 'N/A'; ?></td>
            </tr>
            <tr>
                <td><strong>Patient ID:</strong></td>
                <td><?php echo $vital['patient_unique_id'] ?? $vital['patient_id']; ?></td>
            </tr>
            <tr>
                <td><strong>Recorded Date:</strong></td>
                <td><?php echo date('M j, Y g:i A', strtotime($vital['recorded_at'])); ?></td>
            </tr>
            <tr>
                <td><strong>Recorded By:</strong></td>
                <td><?php echo $vital['recorded_by_name'] . ' ' . $vital['recorded_by_surname']; ?></td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h4><i class="fa fa-heartbeat"></i> Vital Signs Summary</h4>
        <div class="vital-signs-summary">
            <?php if ($vital['temperature']): ?>
                <div class="vital-item">
                    <span class="vital-label">Temperature:</span>
                    <span class="vital-value <?php echo $vital['temperature'] > 38 ? 'text-red' : ($vital['temperature'] < 36 ? 'text-blue' : 'text-green'); ?>">
                        <?php echo $vital['temperature']; ?>°<?php echo $vital['temperature_unit']; ?>
                    </span>
                </div>
            <?php endif; ?>
            
            <?php if ($vital['systolic_bp'] && $vital['diastolic_bp']): ?>
                <div class="vital-item">
                    <span class="vital-label">Blood Pressure:</span>
                    <span class="vital-value <?php echo ($vital['systolic_bp'] > 140 || $vital['diastolic_bp'] > 90) ? 'text-red' : 'text-green'; ?>">
                        <?php echo $vital['systolic_bp']; ?>/<?php echo $vital['diastolic_bp']; ?> mmHg
                    </span>
                </div>
            <?php endif; ?>
            
            <?php if ($vital['pulse_rate']): ?>
                <div class="vital-item">
                    <span class="vital-label">Pulse Rate:</span>
                    <span class="vital-value <?php echo ($vital['pulse_rate'] > 100 || $vital['pulse_rate'] < 60) ? 'text-yellow' : 'text-green'; ?>">
                        <?php echo $vital['pulse_rate']; ?> bpm
                    </span>
                </div>
            <?php endif; ?>
            
            <?php if ($vital['respiratory_rate']): ?>
                <div class="vital-item">
                    <span class="vital-label">Respiratory Rate:</span>
                    <span class="vital-value <?php echo ($vital['respiratory_rate'] > 20 || $vital['respiratory_rate'] < 12) ? 'text-yellow' : 'text-green'; ?>">
                        <?php echo $vital['respiratory_rate']; ?> /min
                    </span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="row" style="margin-top: 20px;">
    <div class="col-md-12">
        <h4><i class="fa fa-list"></i> Complete Vital Signs Record</h4>
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <tbody>
                    <tr>
                        <td width="25%"><strong>Temperature</strong></td>
                        <td width="25%">
                            <?php if ($vital['temperature']): ?>
                                <span class="label <?php echo $vital['temperature'] > 38 ? 'label-danger' : ($vital['temperature'] < 36 ? 'label-primary' : 'label-success'); ?>">
                                    <?php echo $vital['temperature']; ?>°<?php echo $vital['temperature_unit']; ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                        <td width="25%"><strong>Blood Pressure</strong></td>
                        <td width="25%">
                            <?php if ($vital['systolic_bp'] && $vital['diastolic_bp']): ?>
                                <span class="label <?php echo ($vital['systolic_bp'] > 140 || $vital['diastolic_bp'] > 90) ? 'label-danger' : 'label-success'; ?>">
                                    <?php echo $vital['systolic_bp']; ?>/<?php echo $vital['diastolic_bp']; ?> mmHg
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Pulse Rate</strong></td>
                        <td>
                            <?php if ($vital['pulse_rate']): ?>
                                <span class="label <?php echo ($vital['pulse_rate'] > 100 || $vital['pulse_rate'] < 60) ? 'label-warning' : 'label-success'; ?>">
                                    <?php echo $vital['pulse_rate']; ?> bpm
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                        <td><strong>Respiratory Rate</strong></td>
                        <td>
                            <?php if ($vital['respiratory_rate']): ?>
                                <span class="label <?php echo ($vital['respiratory_rate'] > 20 || $vital['respiratory_rate'] < 12) ? 'label-warning' : 'label-success'; ?>">
                                    <?php echo $vital['respiratory_rate']; ?> /min
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Oxygen Saturation</strong></td>
                        <td>
                            <?php if ($vital['oxygen_saturation']): ?>
                                <span class="label <?php echo $vital['oxygen_saturation'] < 95 ? 'label-danger' : 'label-success'; ?>">
                                    <?php echo $vital['oxygen_saturation']; ?>%
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                        <td><strong>Pain Scale</strong></td>
                        <td>
                            <?php if ($vital['pain_scale'] !== null): ?>
                                <span class="label <?php echo $vital['pain_scale'] > 7 ? 'label-danger' : ($vital['pain_scale'] > 4 ? 'label-warning' : 'label-success'); ?>">
                                    <?php echo $vital['pain_scale']; ?>/10
                                    <?php 
                                    if ($vital['pain_scale'] == 0) echo ' (No Pain)';
                                    elseif ($vital['pain_scale'] <= 3) echo ' (Mild)';
                                    elseif ($vital['pain_scale'] <= 6) echo ' (Moderate)';
                                    elseif ($vital['pain_scale'] <= 8) echo ' (Severe)';
                                    else echo ' (Worst)';
                                    ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Weight</strong></td>
                        <td>
                            <?php if ($vital['weight']): ?>
                                <span class="label label-info"><?php echo $vital['weight']; ?> kg</span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                        <td><strong>Height</strong></td>
                        <td>
                            <?php if ($vital['height']): ?>
                                <span class="label label-info"><?php echo $vital['height']; ?> cm</span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>BMI</strong></td>
                        <td>
                            <?php if ($vital['bmi']): ?>
                                <span class="label <?php echo ($vital['bmi'] > 30 || $vital['bmi'] < 18.5) ? 'label-warning' : 'label-success'; ?>">
                                    <?php echo $vital['bmi']; ?>
                                    <?php 
                                    if ($vital['bmi'] < 18.5) echo ' (Underweight)';
                                    elseif ($vital['bmi'] < 25) echo ' (Normal)';
                                    elseif ($vital['bmi'] < 30) echo ' (Overweight)';
                                    else echo ' (Obese)';
                                    ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not calculated</span>
                            <?php endif; ?>
                        </td>
                        <td><strong>Blood Glucose</strong></td>
                        <td>
                            <?php if ($vital['blood_glucose']): ?>
                                <span class="label <?php echo ($vital['blood_glucose'] > 180 || $vital['blood_glucose'] < 70) ? 'label-danger' : 'label-success'; ?>">
                                    <?php echo $vital['blood_glucose']; ?> mg/dL
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not recorded</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if ($vital['notes']): ?>
<div class="row" style="margin-top: 20px;">
    <div class="col-md-12">
        <h4><i class="fa fa-sticky-note"></i> Clinical Notes</h4>
        <div class="well">
            <?php echo nl2br(htmlspecialchars($vital['notes'])); ?>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="row" style="margin-top: 20px;">
    <div class="col-md-12">
        <h4><i class="fa fa-info-circle"></i> Normal Ranges Reference</h4>
        <div class="table-responsive">
            <table class="table table-striped table-condensed">
                <thead>
                    <tr>
                        <th>Parameter</th>
                        <th>Normal Range</th>
                        <th>Patient Value</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Temperature</td>
                        <td>36.1 - 37.2°C</td>
                        <td><?php echo $vital['temperature'] ? $vital['temperature'] . '°' . $vital['temperature_unit'] : 'Not recorded'; ?></td>
                        <td>
                            <?php if ($vital['temperature']): ?>
                                <?php if ($vital['temperature'] > 37.2): ?>
                                    <span class="label label-danger">High</span>
                                <?php elseif ($vital['temperature'] < 36.1): ?>
                                    <span class="label label-primary">Low</span>
                                <?php else: ?>
                                    <span class="label label-success">Normal</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Blood Pressure</td>
                        <td>&lt;120/80 mmHg</td>
                        <td><?php echo ($vital['systolic_bp'] && $vital['diastolic_bp']) ? $vital['systolic_bp'] . '/' . $vital['diastolic_bp'] . ' mmHg' : 'Not recorded'; ?></td>
                        <td>
                            <?php if ($vital['systolic_bp'] && $vital['diastolic_bp']): ?>
                                <?php if ($vital['systolic_bp'] > 140 || $vital['diastolic_bp'] > 90): ?>
                                    <span class="label label-danger">High</span>
                                <?php elseif ($vital['systolic_bp'] < 90 || $vital['diastolic_bp'] < 60): ?>
                                    <span class="label label-primary">Low</span>
                                <?php else: ?>
                                    <span class="label label-success">Normal</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Pulse Rate</td>
                        <td>60 - 100 bpm</td>
                        <td><?php echo $vital['pulse_rate'] ? $vital['pulse_rate'] . ' bpm' : 'Not recorded'; ?></td>
                        <td>
                            <?php if ($vital['pulse_rate']): ?>
                                <?php if ($vital['pulse_rate'] > 100): ?>
                                    <span class="label label-warning">High</span>
                                <?php elseif ($vital['pulse_rate'] < 60): ?>
                                    <span class="label label-primary">Low</span>
                                <?php else: ?>
                                    <span class="label label-success">Normal</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Respiratory Rate</td>
                        <td>12 - 20 /min</td>
                        <td><?php echo $vital['respiratory_rate'] ? $vital['respiratory_rate'] . ' /min' : 'Not recorded'; ?></td>
                        <td>
                            <?php if ($vital['respiratory_rate']): ?>
                                <?php if ($vital['respiratory_rate'] > 20): ?>
                                    <span class="label label-warning">High</span>
                                <?php elseif ($vital['respiratory_rate'] < 12): ?>
                                    <span class="label label-primary">Low</span>
                                <?php else: ?>
                                    <span class="label label-success">Normal</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Oxygen Saturation</td>
                        <td>&gt;95%</td>
                        <td><?php echo $vital['oxygen_saturation'] ? $vital['oxygen_saturation'] . '%' : 'Not recorded'; ?></td>
                        <td>
                            <?php if ($vital['oxygen_saturation']): ?>
                                <?php if ($vital['oxygen_saturation'] < 95): ?>
                                    <span class="label label-danger">Low</span>
                                <?php else: ?>
                                    <span class="label label-success">Normal</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<style>
.vital-signs-summary {
    background: #f9f9f9;
    padding: 15px;
    border-radius: 5px;
}

.vital-item {
    margin-bottom: 10px;
    padding: 8px;
    border-left: 4px solid #3c8dbc;
    background: white;
}

.vital-label {
    font-weight: bold;
    color: #333;
    margin-right: 10px;
}

.vital-value {
    font-size: 16px;
    font-weight: bold;
}

.text-red { color: #dd4b39; }
.text-green { color: #00a65a; }
.text-blue { color: #3c8dbc; }
.text-yellow { color: #f39c12; }
</style>