<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-balance-scale"></i>
        </div>
        <div class="header-title">
            <h1>Measurement Units</h1>
            <small>Manage Laboratory Measurement Units</small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-balance-scale"></i> Laboratory Measurement Units
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_add')): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addUnitModal">
                                    <i class="fa fa-plus"></i> Add Unit
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="unitsTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Unit Name</th>
                                        <th>Symbol</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($units)): ?>
                                        <?php foreach ($units as $unit): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($unit['unit_name']); ?></td>
                                                <td>
                                                    <span class="label label-info">
                                                        <?php echo htmlspecialchars($unit['unit_symbol']); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($unit['description']); ?></td>
                                                <td>
                                                    <?php if ($unit['is_active']): ?>
                                                        <span class="label label-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="label label-danger">Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-right">
                                                    <div class="btn-group">
                                                        <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_edit')): ?>
                                                            <button type="button" class="btn btn-default btn-xs" 
                                                                    onclick="editUnit(<?php echo $unit['id']; ?>)" 
                                                                    title="Edit">
                                                                <i class="fa fa-pencil"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                        <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_delete')): ?>
                                                            <button type="button" class="btn btn-default btn-xs" 
                                                                    onclick="deleteUnit(<?php echo $unit['id']; ?>)" 
                                                                    title="Delete">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center text-muted">
                                                No units found. Click "Add Unit" to create one.
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Common Units Quick Add -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-magic"></i> Quick Add Common Units
                        </h3>
                    </div>
                    <div class="box-body">
                        <p class="text-muted">Click any unit below to quickly add it to your system:</p>
                        <div class="row">
                            <div class="col-md-3">
                                <h5>Concentration</h5>
                                <div class="btn-group-vertical btn-group-sm" role="group">
                                    <button class="btn btn-default" onclick="quickAddUnit('Grams per deciliter', 'g/dL')">g/dL</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Milligrams per deciliter', 'mg/dL')">mg/dL</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Micrograms per deciliter', 'μg/dL')">μg/dL</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Millimoles per liter', 'mmol/L')">mmol/L</button>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <h5>Activity</h5>
                                <div class="btn-group-vertical btn-group-sm" role="group">
                                    <button class="btn btn-default" onclick="quickAddUnit('International Units per liter', 'IU/L')">IU/L</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Units per liter', 'U/L')">U/L</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Nanograms per milliliter', 'ng/mL')">ng/mL</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Picograms per milliliter', 'pg/mL')">pg/mL</button>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <h5>Count & Volume</h5>
                                <div class="btn-group-vertical btn-group-sm" role="group">
                                    <button class="btn btn-default" onclick="quickAddUnit('Cells per microliter', 'cells/μL')">cells/μL</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Count', 'count')">count</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Percentage', '%')">%</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Ratio', 'ratio')">ratio</button>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <h5>Time & Others</h5>
                                <div class="btn-group-vertical btn-group-sm" role="group">
                                    <button class="btn btn-default" onclick="quickAddUnit('Milliseconds', 'ms')">ms</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Millimeters per hour', 'mm/hr')">mm/hr</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Microliters', 'μL')">μL</button>
                                    <button class="btn btn-default" onclick="quickAddUnit('Milliliters', 'mL')">mL</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Unit Modal -->
<div class="modal fade" id="addUnitModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> Add Measurement Unit
                </h4>
            </div>
            <form id="addUnitForm" role="form">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="unit_name">Unit Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="unit_name" name="unit_name" 
                               placeholder="Enter unit name (e.g., Grams per deciliter)" required>
                        <span class="text-danger" id="unit_name_error"></span>
                    </div>
                    <div class="form-group">
                        <label for="unit_symbol">Unit Symbol <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="unit_symbol" name="unit_symbol" 
                               placeholder="Enter unit symbol (e.g., g/dL)" required>
                        <span class="text-danger" id="unit_symbol_error"></span>
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" 
                                  placeholder="Enter unit description"></textarea>
                        <span class="text-danger" id="description_error"></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Unit
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Unit Modal -->
<div class="modal fade" id="editUnitModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Edit Measurement Unit
                </h4>
            </div>
            <div id="editUnitModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#unitsTable').DataTable({
        responsive: true,
        pageLength: 25,
        order: [[0, 'asc']]
    });

    // Add Unit Form Submission
    $('#addUnitForm').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var $submitBtn = $(this).find('button[type="submit"]');
        
        $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        
        // Clear previous errors
        $('.text-danger').text('');
        
        $.ajax({
            url: base_url + 'admin/lab_setup/add_unit',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#addUnitModal').modal('hide');
                    $('#addUnitForm')[0].reset();
                    showMessage(response.message, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    if (response.error) {
                        $.each(response.error, function(field, error) {
                            $('#' + field + '_error').text(error);
                        });
                    }
                    if (response.message) {
                        showMessage(response.message, 'error');
                    }
                }
            },
            error: function() {
                showMessage('An error occurred. Please try again.', 'error');
            },
            complete: function() {
                $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Unit');
            }
        });
    });
});

// Quick Add Unit Function
function quickAddUnit(unitName, unitSymbol) {
    $('#unit_name').val(unitName);
    $('#unit_symbol').val(unitSymbol);
    $('#addUnitModal').modal('show');
}

// Edit Unit Function
function editUnit(id) {
    $.ajax({
        url: base_url + 'admin/lab_setup/edit_unit/' + id,
        type: 'GET',
        success: function(response) {
            $('#editUnitModalContent').html(response);
            $('#editUnitModal').modal('show');
        },
        error: function() {
            showMessage('Error loading unit data.', 'error');
        }
    });
}

// Delete Unit Function
function deleteUnit(id) {
    if (confirm('Are you sure you want to delete this unit?')) {
        $.ajax({
            url: base_url + 'admin/lab_setup/delete_unit/' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showMessage(response.message, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('An error occurred. Please try again.', 'error');
            }
        });
    }
}

// Show message function
function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check' : 'fa-exclamation-triangle';
    
    var alert = '<div class="alert ' + alertClass + ' alert-dismissible">' +
                '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                '<h4><i class="icon fa ' + icon + '"></i> ' + 
                (type === 'success' ? 'Success!' : 'Error!') + '</h4>' +
                message + '</div>';
    
    $('.content-wrapper').prepend(alert);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>