<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.all.min.js"></script>

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-flask"></i>
        </div>
        <div class="header-title">
            <h1><?php echo $title; ?></h1>
            <small><?php echo $this->lang->line('configure_laboratory_tests'); ?></small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> <?php echo $this->lang->line('laboratory_tests'); ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <!-- Filter by GCC Status -->
                            <div class="btn-group" style="margin-right: 10px;">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-filter"></i> Filter by GCC <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" onclick="filterByGCC('')">All Tests</a></li>
                                    <li><a href="#" onclick="filterByGCC('1')">GCC Required</a></li>
                                    <li><a href="#" onclick="filterByGCC('0')">Non-GCC</a></li>
                                </ul>
                            </div>
                            <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_add')): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addTestModal">
                                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_test'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="testsTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('test_name'); ?></th>
                                        <th><?php echo $this->lang->line('short_name'); ?></th>
                                        <th><?php echo $this->lang->line('category'); ?></th>
                                        <th><?php echo $this->lang->line('unit'); ?></th>
                                        <th><?php echo $this->lang->line('cost'); ?></th>
                                        <th><?php echo $this->lang->line('report_days'); ?></th>
                                        <th>GCC Required</th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data loaded via DataTables -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Test Modal with GCC Option -->
<div class="modal fade" id="addTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_laboratory_test'); ?>
                </h4>
            </div>
            <form id="addTestForm" method="post" role="form">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="test_name"><?php echo $this->lang->line('test_name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="test_name" name="test_name" placeholder="<?php echo $this->lang->line('enter_test_name'); ?>" required>
                                <span class="text-danger" id="test_name_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="short_name"><?php echo $this->lang->line('short_name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="short_name" name="short_name" placeholder="<?php echo $this->lang->line('enter_short_name'); ?>" required>
                                <span class="text-danger" id="short_name_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id"><?php echo $this->lang->line('category'); ?> <span class="text-danger">*</span></label>
                                <select class="form-control" id="category_id" name="category_id" required>
                                    <option value=""><?php echo $this->lang->line('select_category'); ?></option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>"><?php echo $category['category_name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <span class="text-danger" id="category_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="unit_id"><?php echo $this->lang->line('unit'); ?></label>
                                <select class="form-control" id="unit_id" name="unit_id">
                                    <option value=""><?php echo $this->lang->line('select_unit'); ?></option>
                                    <?php foreach ($units as $unit): ?>
                                        <option value="<?php echo $unit['id']; ?>"><?php echo $unit['unit_name']; ?> (<?php echo $unit['unit_symbol']; ?>)</option>
                                    <?php endforeach; ?>
                                </select>
                                <span class="text-danger" id="unit_id_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="cost"><?php echo $this->lang->line('cost'); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon">Ksh.</span>
                                    <input type="number" class="form-control" id="cost" name="cost" step="0.01" min="0" placeholder="0.00" required>
                                </div>
                                <span class="text-danger" id="cost_error"></span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="report_days"><?php echo $this->lang->line('report_days'); ?></label>
                                <input type="number" class="form-control" id="report_days" name="report_days" min="1" max="30" placeholder="1">
                                <span class="text-danger" id="report_days_error"></span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="test_type"><?php echo $this->lang->line('test_type'); ?></label>
                                <select class="form-control test-type-select" id="test_type" name="test_type">
                                    <option value="qualitative"><?php echo $this->lang->line('qualitative'); ?></option>
                                    <option value="quantitative"><?php echo $this->lang->line('quantitative'); ?></option>
                                    <option value="descriptive"><?php echo $this->lang->line('descriptive'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="is_gcc">GCC Required?</label>
                                <div class="checkbox" style="margin-top: 8px;">
                                    <label>
                                        <input type="checkbox" id="is_gcc" name="is_gcc" value="1">
                                        Requires Government Chemical Chemist
                                    </label>
                                </div>
                                <small class="text-muted">Check if this test requires GCC certification</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="method"><?php echo $this->lang->line('method'); ?></label>
                                <input type="text" class="form-control" id="method" name="method" placeholder="<?php echo $this->lang->line('test_method'); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="sample_type"><?php echo $this->lang->line('sample_type'); ?></label>
                                <select class="form-control" id="sample_type" name="sample_type">
                                    <option value=""><?php echo $this->lang->line('select_sample_type'); ?></option>
                                    <option value="Blood">Blood</option>
                                    <option value="Serum">Serum</option>
                                    <option value="Plasma">Plasma</option>
                                    <option value="Urine">Urine</option>
                                    <option value="Stool">Stool</option>
                                    <option value="Sputum">Sputum</option>
                                    <option value="CSF">CSF</option>
                                    <option value="Swab">Swab</option>
                                    <option value="Tissue">Tissue</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description"><?php echo $this->lang->line('description'); ?></label>
                                <textarea class="form-control" id="description" name="description" rows="3" placeholder="<?php echo $this->lang->line('test_description'); ?>"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <?php echo $this->lang->line('cancel'); ?>
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> <?php echo $this->lang->line('save'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Test Modal -->
<div class="modal fade" id="editTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> <?php echo $this->lang->line('edit_laboratory_test'); ?>
                </h4>
            </div>
            <div id="editTestModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- View Test Modal -->
<div class="modal fade" id="viewTestModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> <?php echo $this->lang->line('view_test_details'); ?>
                </h4>
            </div>
            <div id="viewTestModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    console.log('Initializing DataTable with SweetAlert2...');
    console.log('Base URL:', base_url);
    
    // Initialize DataTable with SweetAlert2 integration
    var testsTable = $('#testsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: base_url + 'admin/lab_setup/get_tests_datatable',
            type: 'POST',
            error: function(xhr, error, thrown) {
                console.error('DataTable Error:', xhr.responseText);
                
                // SweetAlert2 error message
                Swal.fire({
                    icon: 'error',
                    title: 'Data Loading Error',
                    html: `
                        <p>Failed to load laboratory tests data.</p>
                        <small class="text-muted">Status: ${xhr.status} - ${xhr.statusText}</small>
                    `,
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#d33',
                    footer: '<a href="#" onclick="testDataTableAjax()">Test Connection</a>'
                });
            }
        },
        columns: [
            { data: 0, title: 'Test Name' },
            { data: 1, title: 'Short Name' },
            { data: 2, title: 'Category' },
            { data: 3, title: 'Unit' },
            { data: 4, title: 'Cost', className: 'text-right' },
            { data: 5, title: 'Report Days', className: 'text-center' },
            { data: 6, title: 'GCC Required', className: 'text-center' },
            { data: 7, title: 'Status', className: 'text-center' },
            { data: 8, title: 'Actions', orderable: false, searchable: false, className: 'text-right' }
        ],
        order: [[0, 'asc']],
        pageLength: 25,
        language: {
            processing: '<i class="fa fa-spinner fa-spin"></i> Loading tests...',
            emptyTable: 'No tests found. <a href="#" onclick="showAddTestModal()">Add your first test</a>'
        },
        drawCallback: function(settings) {
            // Initialize tooltips for action buttons
            $('[data-toggle="tooltip"]').tooltip();
        }
    });
    
    // Store table reference
    window.testsTable = testsTable;
    
    console.log('DataTable initialized with SweetAlert2');
});

// Enhanced message function using SweetAlert2
function showMessage(message, type, title = null) {
    const config = {
        html: message,
        confirmButtonText: 'OK',
        timer: type === 'success' ? 3000 : null,
        timerProgressBar: type === 'success'
    };

    switch(type) {
        case 'success':
            config.icon = 'success';
            config.title = title || 'Success!';
            config.confirmButtonColor = '#28a745';
            break;
        case 'error':
            config.icon = 'error';
            config.title = title || 'Error!';
            config.confirmButtonColor = '#dc3545';
            break;
        case 'warning':
            config.icon = 'warning';
            config.title = title || 'Warning!';
            config.confirmButtonColor = '#ffc107';
            break;
        case 'info':
            config.icon = 'info';
            config.title = title || 'Information';
            config.confirmButtonColor = '#17a2b8';
            break;
        default:
            config.title = title || 'Notice';
    }

    Swal.fire(config);
}

// Enhanced form submission with SweetAlert2
$('#addTestForm').on('submit', function(e) {
    e.preventDefault();
    
    console.log('Form submission started');
    
    var $form = $(this);
    var $submitBtn = $form.find('button[type="submit"]');
    var formData = $form.serialize();
    
    // Show loading state
    $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
    
    // Clear previous errors
    $('.text-danger').text('');
    
    // Show loading SweetAlert
    Swal.fire({
        title: 'Saving Test...',
        html: 'Please wait while we save your laboratory test.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/lab_setup/add_test',
        type: 'POST',
        data: formData,
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('Add test response:', response);
            
            if (response.status === 'success') {
                $('#addTestModal').modal('hide');
                $form[0].reset();
                
                // Reload the DataTable
                if (window.testsTable) {
                    window.testsTable.ajax.reload(null, false);
                }
                
                // Success SweetAlert
                Swal.fire({
                    icon: 'success',
                    title: 'Test Added Successfully!',
                    html: response.message,
                    confirmButtonColor: '#28a745',
                    timer: 3000,
                    timerProgressBar: true
                });
            } else {
                // Handle validation errors
                if (response.error && typeof response.error === 'object') {
                    let errorList = '<ul class="text-left">';
                    $.each(response.error, function(field, error) {
                        $('#' + field + '_error').text(error);
                        errorList += '<li>' + error + '</li>';
                    });
                    errorList += '</ul>';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Errors',
                        html: errorList,
                        confirmButtonColor: '#dc3545'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error Adding Test',
                        html: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            }
        },
        error: function(xhr, status, error) {
            console.error('Add test AJAX error:', xhr.responseText);
            
            let errorMessage = 'An unexpected error occurred while saving the test.';
            
            if (xhr.status === 404) {
                errorMessage = 'The server endpoint was not found. Please check your configuration.';
            } else if (xhr.status === 500) {
                errorMessage = 'A server error occurred. Please contact your administrator.';
            } else if (xhr.status === 0) {
                errorMessage = 'Network connection error. Please check your internet connection.';
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Connection Error',
                html: errorMessage,
                confirmButtonColor: '#dc3545',
                footer: '<small>Check the browser console for more details</small>'
            });
        },
        complete: function() {
            // Reset button state
            $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save');
        }
    });
    
    return false;
});

// Enhanced view test function
function viewTest(id) {
    console.log('Viewing test ID:', id);
    
    // Show loading
    Swal.fire({
        title: 'Loading Test Details...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/lab_setup/view_test/' + id,
        type: 'GET',
        timeout: 10000,
        success: function(response) {
            Swal.close();
            $('#viewTestModalContent').html(response);
            $('#viewTestModal').modal('show');
        },
        error: function(xhr, status, error) {
            console.error('View test error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Failed to Load Test Details',
                html: 'Unable to retrieve test information. Please try again.',
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Enhanced edit test function
function editTest(id) {
    console.log('Editing test ID:', id);
    
    // Show loading
    Swal.fire({
        title: 'Loading Test for Editing...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/lab_setup/edit_test/' + id,
        type: 'GET',
        timeout: 10000,
        success: function(response) {
            Swal.close();
            $('#editTestModalContent').html(response);
            $('#editTestModal').modal('show');
        },
        error: function(xhr, status, error) {
            console.error('Edit test error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Failed to Load Test for Editing',
                html: 'Unable to retrieve test information for editing. Please try again.',
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Enhanced delete test function
function deleteTest(id) {
    console.log('Deleting test ID:', id);
    
    Swal.fire({
        title: 'Delete Laboratory Test?',
        html: `
            <p>Are you sure you want to delete this laboratory test?</p>
            <div class="alert alert-warning mt-3">
                <i class="fa fa-exclamation-triangle"></i>
                <strong>Warning:</strong> This action cannot be undone!
            </div>
        `,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="fa fa-trash"></i> Yes, Delete It!',
        cancelButtonText: '<i class="fa fa-times"></i> Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Show deleting progress
            Swal.fire({
                title: 'Deleting Test...',
                html: 'Please wait while we delete the laboratory test.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            $.ajax({
                url: base_url + 'admin/lab_setup/delete_test/' + id,
                type: 'POST',
                dataType: 'json',
                timeout: 10000,
                success: function(response) {
                    if (response.status === 'success') {
                        if (window.testsTable) {
                            window.testsTable.ajax.reload(null, false);
                        }
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Test Deleted!',
                            html: response.message,
                            confirmButtonColor: '#28a745',
                            timer: 3000,
                            timerProgressBar: true
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Delete Failed',
                            html: response.message,
                            confirmButtonColor: '#dc3545'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Delete test error:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Delete Failed',
                        html: 'An error occurred while deleting the test. Please try again.',
                        confirmButtonColor: '#dc3545'
                    });
                }
            });
        }
    });
}

// Enhanced GCC toggle function
function toggleGCC(testId, currentStatus) {
    console.log('Toggling GCC for test ID:', testId, 'Current status:', currentStatus);
    
    var newStatus = currentStatus == 1 ? 0 : 1;
    var actionText = newStatus == 1 ? 'require GCC certification' : 'remove GCC requirement';
    var iconHtml = newStatus == 1 ? 
        '<i class="fa fa-certificate" style="color: #f39c12; font-size: 2em;"></i>' : 
        '<i class="fa fa-minus-circle" style="color: #95a5a6; font-size: 2em;"></i>';
    
    Swal.fire({
        title: 'Change GCC Requirement?',
        html: `
            <div class="text-center mb-3">
                ${iconHtml}
            </div>
            <p>Are you sure you want to <strong>${actionText}</strong> for this test?</p>
            <div class="alert alert-info mt-3">
                <i class="fa fa-info-circle"></i>
                <strong>Note:</strong> This will affect how this test is processed and reported.
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: newStatus == 1 ? '#f39c12' : '#95a5a6',
        cancelButtonColor: '#6c757d',
        confirmButtonText: newStatus == 1 ? 
            '<i class="fa fa-certificate"></i> Require GCC' : 
            '<i class="fa fa-minus-circle"></i> Remove GCC',
        cancelButtonText: '<i class="fa fa-times"></i> Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Show updating progress
            Swal.fire({
                title: 'Updating GCC Status...',
                html: 'Please wait while we update the GCC requirement.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            $.ajax({
                url: base_url + 'admin/lab_setup/toggle_gcc_status',
                type: 'POST',
                data: {
                    test_id: testId,
                    is_gcc: newStatus
                },
                dataType: 'json',
                timeout: 10000,
                success: function(response) {
                    if (response.status === 'success') {
                        if (window.testsTable) {
                            window.testsTable.ajax.reload(null, false);
                        }
                        
                        const successIcon = newStatus == 1 ? 'fa-certificate' : 'fa-minus-circle';
                        const successColor = newStatus == 1 ? '#f39c12' : '#95a5a6';
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'GCC Status Updated!',
                            html: `
                                <div class="text-center mb-3">
                                    <i class="fa ${successIcon}" style="color: ${successColor}; font-size: 2em;"></i>
                                </div>
                                <p>${response.message}</p>
                            `,
                            confirmButtonColor: '#28a745',
                            timer: 3000,
                            timerProgressBar: true
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Update Failed',
                            html: response.message,
                            confirmButtonColor: '#dc3545'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Toggle GCC error:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Update Failed',
                        html: 'An error occurred while updating the GCC status. Please try again.',
                        confirmButtonColor: '#dc3545'
                    });
                }
            });
        }
    });
}

// Enhanced filter function with confirmation
function filterByGCC(gccStatus) {
    console.log('Filtering by GCC status:', gccStatus);
    
    if (!window.testsTable) {
        Swal.fire({
            icon: 'error',
            title: 'Filter Error',
            html: 'DataTable not initialized. Please refresh the page.',
            confirmButtonColor: '#dc3545'
        });
        return;
    }
    
    let filterText = '';
    switch(gccStatus) {
        case '':
            filterText = 'all tests';
            break;
        case '1':
            filterText = 'only GCC required tests';
            break;
        case '0':
            filterText = 'only non-GCC tests';
            break;
    }
    
    // Show filter confirmation with auto-close
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 2000,
        timerProgressBar: true
    });
    
    Toast.fire({
        icon: 'info',
        title: `Filtering: ${filterText}`
    });
    
    // Apply filter
    if (gccStatus === '') {
        window.testsTable.column(6).search('').draw();
    } else if (gccStatus === '1') {
        window.testsTable.column(6).search('GCC', true, false).draw();
    } else if (gccStatus === '0') {
        window.testsTable.column(6).search('^((?!GCC).)*$', true, false).draw();
    }
}

// Enhanced test function with detailed feedback
function testDataTableAjax() {
    Swal.fire({
        title: 'Testing DataTable Connection...',
        html: 'Checking if the DataTable endpoint is working properly.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/lab_setup/get_tests_datatable',
        type: 'POST',
        data: {
            draw: 1,
            start: 0,
            length: 5,
            search: { value: '' },
            order: [{ column: 0, dir: 'asc' }]
        },
        success: function(response) {
            console.log('DataTable AJAX Test Success:', response);
            
            let resultHtml = `
                <div class="text-left">
                    <p><strong>Status:</strong> <span class="text-success">Success</span></p>
                    <p><strong>Records Found:</strong> ${response.recordsTotal || 0}</p>
                    <p><strong>Data Rows:</strong> ${response.data ? response.data.length : 0}</p>
                </div>
            `;
            
            Swal.fire({
                icon: 'success',
                title: 'Connection Test Successful!',
                html: resultHtml,
                confirmButtonColor: '#28a745'
            });
        },
        error: function(xhr, status, error) {
            console.error('DataTable AJAX Test Error:', xhr.responseText);
            
            let errorHtml = `
                <div class="text-left">
                    <p><strong>Status:</strong> <span class="text-danger">Failed</span></p>
                    <p><strong>HTTP Status:</strong> ${xhr.status}</p>
                    <p><strong>Error:</strong> ${error}</p>
                    <hr>
                    <small class="text-muted">Check browser console for detailed error information.</small>
                </div>
            `;
            
            Swal.fire({
                icon: 'error',
                title: 'Connection Test Failed',
                html: errorHtml,
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Function to show add test modal
function showAddTestModal() {
    $('#addTestModal').modal('show');
}

// Auto-generate short name from test name with visual feedback
$('#test_name').on('input', function() {
    var testName = $(this).val();
    var shortName = generateShortName(testName);
    $('#short_name').val(shortName);
    
    // Show toast notification for auto-generation
    if (testName && shortName) {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 1500,
            timerProgressBar: true
        });
        
        Toast.fire({
            icon: 'info',
            title: `Short name: ${shortName}`
        });
    }
});

// Generate short name function
function generateShortName(testName) {
    if (!testName) return '';
    
    var commonWords = ['test', 'analysis', 'examination', 'level', 'count', 'screening'];
    var words = testName.toLowerCase().split(' ');
    
    words = words.filter(function(word) {
        return commonWords.indexOf(word) === -1 && word.length > 1;
    });
    
    var shortName = words.map(function(word) {
        return word.charAt(0).toUpperCase();
    }).join('');
    
    if (shortName.length < 2) {
        shortName = testName.substring(0, 4).toUpperCase();
    }
    
    return shortName;
}

// Make functions available globally
window.testDataTableAjax = testDataTableAjax;
window.showMessage = showMessage;

console.log('SweetAlert2 Lab Setup JavaScript loaded successfully');
</script>