<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-flask"></i>
        </div>
        <div class="header-title">
            <h1>Laboratory Setup Dashboard</h1>
            <small>Manage Laboratory Configuration and Tests</small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Quick Info Alert -->
        <div class="alert alert-info alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-info"></i> Welcome to Laboratory Setup!</h4>
            This dashboard helps you configure your laboratory system. You can manage test categories, individual tests, pricing, units, and reference ranges.
        </div>

        <!-- Statistics Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box bg-aqua">
                    <span class="info-box-icon"><i class="fa fa-list"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Categories</span>
                        <span class="info-box-number"><?php echo isset($stats['total_categories']) ? $stats['total_categories'] : '0'; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">Active Categories</span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-flask"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Lab Tests</span>
                        <span class="info-box-number"><?php echo isset($stats['total_tests']) ? $stats['total_tests'] : '0'; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">Configured Tests</span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-balance-scale"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Units</span>
                        <span class="info-box-number"><?php echo isset($stats['total_units']) ? $stats['total_units'] : '0'; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">Measurement Units</span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fa fa-chart-line"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Lab Results</span>
                        <span class="info-box-number"><?php echo isset($stats['total_lab_results']) ? $stats['total_lab_results'] : '0'; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">Total Results</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Cards Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-cogs"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="small-box bg-blue">
                                    <div class="inner">
                                        <h4>Manage Categories</h4>
                                        <p>Add, edit, and organize test categories</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fa fa-list"></i>
                                    </div>
                                    <a href="<?php echo base_url('admin/lab_setup/categories'); ?>" class="small-box-footer">
                                        Manage <i class="fa fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="small-box bg-green">
                                    <div class="inner">
                                        <h4>Configure Tests</h4>
                                        <p>Set up individual lab tests and pricing</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fa fa-flask"></i>
                                    </div>
                                    <a href="<?php echo base_url('admin/lab_setup/tests'); ?>" class="small-box-footer">
                                        Configure <i class="fa fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="small-box bg-yellow">
                                    <div class="inner">
                                        <h4>Manage Units</h4>
                                        <p>Configure measurement units</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fa fa-balance-scale"></i>
                                    </div>
                                    <a href="<?php echo base_url('admin/lab_setup/units'); ?>" class="small-box-footer">
                                        Setup <i class="fa fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="small-box bg-red">
                                    <div class="inner">
                                        <h4>View Results</h4>
                                        <p>Access laboratory test results</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fa fa-chart-line"></i>
                                    </div>
                                    <a href="<?php echo base_url('admin/lab/results'); ?>" class="small-box-footer">
                                        View Results <i class="fa fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts and Data Row -->
        <div class="row">
            <!-- Tests by Category Chart -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Tests by Category</h3>
                    </div>
                    <div class="box-body">
                        <canvas id="testsByCategoryChart" width="400" height="300"></canvas>
                    </div>
                </div>
            </div>

            <!-- Most Expensive Tests -->
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-money"></i> Most Expensive Tests</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Test Name</th>
                                        <th class="text-right">Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($stats['expensive_tests'])): ?>
                                        <?php foreach ($stats['expensive_tests'] as $test): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($test['test_name']); ?></td>
                                                <td class="text-right">
                                                    <span class="label label-success">
                                                        <?php echo isset($currency_symbol) ? $currency_symbol : 'Ksh.'; ?><?php echo number_format($test['cost'], 2); ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="2" class="text-center text-muted">
                                                No tests configured yet. <a href="<?php echo base_url('admin/lab_setup/tests'); ?>">Add some tests</a> to get started.
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Status Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> System Status & Setup Guide</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4>Setup Checklist</h4>
                                <ul class="list-unstyled">
                                    <li>
                                        <i class="fa fa-check text-green"></i>
                                        Database Tables: <strong>Created</strong>
                                    </li>
                                    <li>
                                        <i class="fa fa-<?php echo (isset($stats['total_categories']) && $stats['total_categories'] > 0) ? 'check text-green' : 'times text-red'; ?>"></i>
                                        Test Categories: <strong><?php echo isset($stats['total_categories']) ? $stats['total_categories'] : '0'; ?> Configured</strong>
                                    </li>
                                    <li>
                                        <i class="fa fa-<?php echo (isset($stats['total_tests']) && $stats['total_tests'] > 0) ? 'check text-green' : 'times text-red'; ?>"></i>
                                        Lab Tests: <strong><?php echo isset($stats['total_tests']) ? $stats['total_tests'] : '0'; ?> Configured</strong>
                                    </li>
                                    <li>
                                        <i class="fa fa-<?php echo (isset($stats['total_units']) && $stats['total_units'] > 0) ? 'check text-green' : 'times text-red'; ?>"></i>
                                        Measurement Units: <strong><?php echo isset($stats['total_units']) ? $stats['total_units'] : '0'; ?> Configured</strong>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h4>Getting Started</h4>
                                <div class="list-group">
                                    <div class="list-group-item">
                                        <h5 class="list-group-item-heading">Step 1: Setup Categories</h5>
                                        <p class="list-group-item-text">Create test categories like Hematology, Chemistry, etc.</p>
                                        <a href="<?php echo base_url('admin/lab_setup/categories'); ?>" class="btn btn-sm btn-primary">Manage Categories</a>
                                    </div>
                                    <div class="list-group-item">
                                        <h5 class="list-group-item-heading">Step 2: Configure Tests</h5>
                                        <p class="list-group-item-text">Add individual tests with pricing and details.</p>
                                        <a href="<?php echo base_url('admin/lab_setup/tests'); ?>" class="btn btn-sm btn-success">Configure Tests</a>
                                    </div>
                                    <div class="list-group-item">
                                        <h5 class="list-group-item-heading">Step 3: Start Testing</h5>
                                        <p class="list-group-item-text">Begin recording patient lab results.</p>
                                        <a href="<?php echo base_url('admin/lab/results'); ?>" class="btn btn-sm btn-info">Lab Results</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <h4>Quick Actions</h4>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-primary" onclick="initializeSystem()">
                                        <i class="fa fa-cogs"></i> Initialize System
                                    </button>
                                    <a href="<?php echo base_url('admin/lab_setup/export_tests'); ?>" class="btn btn-info">
                                        <i class="fa fa-download"></i> Export Tests
                                    </a>
                                    <a href="<?php echo base_url('admin/lab_setup/test_setup'); ?>" class="btn btn-warning" target="_blank">
                                        <i class="fa fa-wrench"></i> Test System
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Initialize System Modal -->
<div class="modal fade" id="initializeModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-cogs"></i> Initialize Laboratory System
                </h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <h4><i class="fa fa-info-circle"></i> System Initialization</h4>
                    This will create and populate:
                    <ul>
                        <li>Default test categories (Hematology, Chemistry, etc.)</li>
                        <li>Common measurement units (g/dL, mg/dL, %, etc.)</li>
                        <li>Sample lab tests with pricing</li>
                        <li>Database structure verification</li>
                    </ul>
                    <p><strong>Note:</strong> Existing data will be preserved.</p>
                </div>
                <div id="initializationProgress" style="display: none;">
                    <div class="progress">
                        <div class="progress-bar progress-bar-striped active" role="progressbar" style="width: 100%">
                            Initializing...
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmInitialize">
                    <i class="fa fa-cogs"></i> Initialize Now
                </button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
$(document).ready(function() {
    // Initialize Charts
    initializeCharts();
    
    // Initialize system modal handler
    $('#confirmInitialize').click(function() {
        var $btn = $(this);
        var $progress = $('#initializationProgress');
        
        $btn.prop('disabled', true);
        $progress.show();
        
        $.ajax({
            url: base_url + 'admin/lab_setup/initialize_system',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showMessage(response.message, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    showMessage(response.message, 'error');
                }
                $('#initializeModal').modal('hide');
            },
            error: function() {
                showMessage('Initialization failed. Please try again.', 'error');
                $('#initializeModal').modal('hide');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $progress.hide();
            }
        });
    });
});

function initializeSystem() {
    $('#initializeModal').modal('show');
}

function initializeCharts() {
    // Tests by Category Chart
    var categoryData = <?php echo json_encode(isset($stats['tests_by_category']) ? $stats['tests_by_category'] : []); ?>;
    
    if (categoryData.length > 0) {
        var ctx = document.getElementById('testsByCategoryChart').getContext('2d');
        var chart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: categoryData.map(item => item.category_name),
                datasets: [{
                    data: categoryData.map(item => item.test_count),
                    backgroundColor: [
                        '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0',
                        '#9966FF', '#FF9F40', '#FF6384', '#C9CBCF'
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    position: 'bottom'
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = data.labels[tooltipItem.index];
                            var value = data.datasets[0].data[tooltipItem.index];
                            return label + ': ' + value + ' tests';
                        }
                    }
                }
            }
        });
    } else {
        // Show no data message
        var canvas = document.getElementById('testsByCategoryChart');
        var ctx = canvas.getContext('2d');
        ctx.font = '16px Arial';
        ctx.textAlign = 'center';
        ctx.fillText('No data available', canvas.width/2, canvas.height/2);
    }
}

function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check' : 'fa-exclamation-triangle';
    
    var alert = '<div class="alert ' + alertClass + ' alert-dismissible">' +
                '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                '<h4><i class="icon fa ' + icon + '"></i> ' + 
                (type === 'success' ? 'Success!' : 'Error!') + '</h4>' +
                message + '</div>';
    
    $('.content-wrapper').prepend(alert);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>