<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-flask"></i> <?php echo $title; ?></h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix"> Lab Test List</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('lab_tests', 'can_add')) { ?>
                                <a data-toggle="modal" data-target="#add_test_modal" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add Lab Test</a>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="lab_test_table" class="table table-striped table-bordered table-hover example">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Short Name</th>
                                        <th>Category</th>
                                        <th>Charge (<?php echo $this->customlib->getSchoolCurrencyFormat(); ?>)</th>
                                        <th>Description</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($lab_tests)) { ?>
                                        <?php foreach ($lab_tests as $test) { ?>
                                            <tr>
                                                <td><?php echo $test['name']; ?></td>
                                                <td><?php echo $test['short_name']; ?></td>
                                                <td><?php echo $test['category_name']; ?></td>
                                                <td><?php echo $test['charge']; ?></td>
                                                <td><?php echo $test['description']; ?></td>
                                                <td class="text-right">
                                                    <?php if ($this->rbac->hasPrivilege('lab_tests', 'can_edit')) { ?>
                                                        <a href="#" onclick="edit_test('<?php echo $test['id']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" title="Edit"><i class="fa fa-pencil"></i></a>
                                                    <?php } ?>
                                                    <?php if ($this->rbac->hasPrivilege('lab_tests', 'can_delete')) { ?>
                                                        <a href="#" onclick="delete_test('<?php echo $test['id']; ?>', '<?php echo $test['name']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" title="Delete"><i class="fa fa-trash"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Lab Test Modal -->
<div class="modal fade" id="add_test_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add Lab Test</h4>
            </div>
            <form id="add_test_form" method="post" accept-charset="utf-8">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Test Name</label><small class="req"> *</small>
                                <input type="text" name="name" id="name" class="form-control">
                                <span class="text-danger" id="name_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="short_name">Short Name</label><small class="req"> *</small>
                                <input type="text" name="short_name" id="short_name" class="form-control">
                                <span class="text-danger" id="short_name_error"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Category</label><small class="req"> *</small>
                                <select name="category_id" id="category_id" class="form-control">
                                    <option value="">Select Category</option>
                                    <?php foreach ($categories as $category) { ?>
                                        <option value="<?php echo $category['id']; ?>"><?php echo $category['category_name']; ?></option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger" id="category_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="charge">Charge (<?php echo $this->customlib->getSchoolCurrencyFormat(); ?>)</label><small class="req"> *</small>
                                <input type="text" name="charge" id="charge" class="form-control">
                                <span class="text-danger" id="charge_error"></span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea name="description" id="description" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary pull-right">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Lab Test Modal -->
<div class="modal fade" id="edit_test_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Lab Test</h4>
            </div>
            <form id="edit_test_form" method="post" accept-charset="utf-8">
                <div class="modal-body" id="edit_test_modal_body">
                    <!-- Content will be loaded here by AJAX -->
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary pull-right">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#lab_test_table').DataTable({
            "aaSorting": [],
            rowReorder: {
                selector: 'td:nth-child(2)'
            },
            responsive: true
        });

        // Add Test Form Submission
        $("#add_test_form").on('submit', (function (e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/lab/add_test',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function (data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function (index, value) {
                            message += value;
                            $('#' + index + '_error').html(value);
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        $('#add_test_modal').modal('hide');
                        location.reload(); 
                    }
                },
                error: function () {
                    alert("Fail");
                }
            });
        }));

        // Edit Test Form Submission
        $("#edit_test_form").on('submit', (function (e) {
            e.preventDefault();
            var test_id = $('#edit_test_id').val(); // Assuming you have an input with id 'edit_test_id' in your edit modal
            $.ajax({
                url: '<?php echo base_url(); ?>admin/lab/update_test/' + test_id,
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function (data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function (index, value) {
                            message += value;
                             // You might need to adjust how errors are displayed in the edit modal
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        $('#edit_test_modal').modal('hide');
                        location.reload(); 
                    }
                },
                error: function () {
                    alert("Fail");
                }
            });
        }));
    });

    function edit_test(id) {
        $('#edit_test_modal').modal('show');
        $.ajax({
            url: '<?php echo base_url(); ?>admin/lab/edit_test/' + id,
            type: "GET",
            success: function (data) {
                $('#edit_test_modal_body').html(data);
            },
            error: function () {
                alert("Failed to load edit form.");
            }
        });
    }

    function delete_test(id, test_name) {
        if (confirm('Are you sure you want to delete lab test: ' + test_name + '?')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/lab/delete_test/' + id,
                type: "POST",
                dataType: 'json',
                success: function (data) {
                    if (data.status == "success") {
                        successMsg(data.message);
                        location.reload();
                    } else {
                        errorMsg('Failed to delete lab test.');
                    }
                },
                error: function () {
                    errorMsg('An error occurred.');
                }
            });
        }
    }
</script>