<?php
/**
 * Insurance Pricing List View
 * File: application/views/admin/insurance/pricing_list.php
 */
?>

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-money"></i> Insurance Pricing Management
            <small>Manage pricing data for all insurance companies</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/insurance">Insurance</a></li>
            <li class="active">Pricing</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa fa-check"></i> <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <!-- Statistics Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo number_format($total_count ?? 0); ?></h3>
                        <p>Total Items</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-list"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo count($companies ?? []); ?></h3>
                        <p>Companies</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-building"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo count($families ?? []); ?></h3>
                        <p>Categories</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-tags"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="selectedCount">0</h3>
                        <p>Selected</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check-square"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Filters -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-filter"></i> Search & Filters</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <form method="GET" action="<?php echo base_url(); ?>admin/insurance/pricing">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Insurance Company</label>
                                        <select name="insurance_id" class="form-control">
                                            <option value="">All Companies</option>
                                            <?php if (!empty($companies)): ?>
                                                <?php foreach ($companies as $company): ?>
                                                    <option value="<?php echo $company['id']; ?>" 
                                                        <?php echo (($filters['insurance_id'] ?? '') == $company['id']) ? 'selected' : ''; ?>>
                                                        <?php echo htmlspecialchars($company['company_name']); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Item Type</label>
                                        <select name="item_type" class="form-control">
                                            <option value="">All Types</option>
                                            <option value="Stock" <?php echo (($filters['item_type'] ?? '') == 'Stock') ? 'selected' : ''; ?>>Stock</option>
                                            <option value="Service" <?php echo (($filters['item_type'] ?? '') == 'Service') ? 'selected' : ''; ?>>Service</option>
                                            <option value="Medicine" <?php echo (($filters['item_type'] ?? '') == 'Medicine') ? 'selected' : ''; ?>>Medicine</option>
                                            <option value="Equipment" <?php echo (($filters['item_type'] ?? '') == 'Equipment') ? 'selected' : ''; ?>>Equipment</option>
                                            <option value="Procedure" <?php echo (($filters['item_type'] ?? '') == 'Procedure') ? 'selected' : ''; ?>>Procedure</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Item Family</label>
                                        <select name="item_family" class="form-control">
                                            <option value="">All Families</option>
                                            <?php if (!empty($families)): ?>
                                                <?php foreach ($families as $family): ?>
                                                    <option value="<?php echo htmlspecialchars($family['family_name']); ?>" 
                                                        <?php echo (($filters['item_family'] ?? '') == $family['family_name']) ? 'selected' : ''; ?>>
                                                        <?php echo htmlspecialchars($family['family_name']); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Search Items</label>
                                        <input type="text" name="search" class="form-control" 
                                               placeholder="Search by item name..." 
                                               value="<?php echo htmlspecialchars($filters['search'] ?? ''); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <button type="submit" class="btn btn-primary btn-block">
                                                <i class="fa fa-search"></i> Filter
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <a href="<?php echo base_url(); ?>admin/insurance/pricing" class="btn btn-default btn-sm">
                                        <i class="fa fa-refresh"></i> Reset Filters
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Data Table -->
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-table"></i> Pricing Data
                            <span class="label label-info"><?php echo number_format($total_count ?? 0); ?> Items</span>
                        </h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <a href="<?php echo base_url(); ?>admin/insurance/import_pricing" class="btn btn-success btn-sm">
                                    <i class="fa fa-upload"></i> Import
                                </a>
                                <a href="<?php echo base_url(); ?>admin/insurance/export_pricing?<?php echo http_build_query($filters ?? []); ?>" 
                                   class="btn btn-info btn-sm">
                                    <i class="fa fa-download"></i> Export
                                </a>
                                <a href="<?php echo base_url(); ?>admin/insurance/add_pricing" class="btn btn-primary btn-sm">
                                    <i class="fa fa-plus"></i> Add New
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <?php if (!empty($pricing_items)): ?>
                            <!-- Bulk Actions -->
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-success" onclick="bulkApprove()">
                                            <i class="fa fa-check"></i> Approve
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="bulkReject()">
                                            <i class="fa fa-times"></i> Reject
                                        </button>
                                        <button type="button" class="btn btn-sm btn-danger" onclick="bulkDelete()">
                                            <i class="fa fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="btn-group pull-right">
                                        <button type="button" class="btn btn-sm btn-default" onclick="selectAll()">
                                            <i class="fa fa-check-square-o"></i> Select All
                                        </button>
                                        <button type="button" class="btn btn-sm btn-default" onclick="selectNone()">
                                            <i class="fa fa-square-o"></i> Clear
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <br>

                            <!-- Data Table -->
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead style="background: #f5f5f5;">
                                        <tr>
                                            <th width="3%">
                                                <input type="checkbox" id="selectAllCheckbox" onchange="toggleSelectAll()">
                                            </th>
                                            <th width="30%">Item Name</th>
                                            <th width="10%">Type</th>
                                            <th width="12%">Family</th>
                                            <th width="20%">Company</th>
                                            <th width="10%">Price (KES)</th>
                                            <th width="8%">Status</th>
                                            <th width="7%">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($pricing_items as $item): ?>
                                            <tr data-id="<?php echo $item['id']; ?>">
                                                <td>
                                                    <input type="checkbox" class="item-checkbox" 
                                                           value="<?php echo $item['id']; ?>" 
                                                           onchange="updateSelectedCount()">
                                                </td>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($item['item_name']); ?></strong>
                                                    <?php if (!empty($item['item_code'])): ?>
                                                        <br><small class="text-muted"><?php echo htmlspecialchars($item['item_code']); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="label label-<?php echo ($item['item_type'] == 'Stock') ? 'primary' : 'info'; ?>">
                                                        <?php echo htmlspecialchars($item['item_type']); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($item['item_family']); ?></td>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($item['company_name']); ?></strong>
                                                </td>
                                                <td class="text-right">
                                                    <strong class="text-success">
                                                        <?php echo number_format($item['item_price'], 2); ?>
                                                    </strong>
                                                </td>
                                                <td>
                                                    <?php
                                                    $status = $item['approval_status'] ?? $item['status'] ?? 'pending';
                                                    $status_class = '';
                                                    switch ($status) {
                                                        case 'approved':
                                                            $status_class = 'success';
                                                            break;
                                                        case 'pending':
                                                            $status_class = 'warning';
                                                            break;
                                                        case 'rejected':
                                                            $status_class = 'danger';
                                                            break;
                                                        default:
                                                            $status_class = 'default';
                                                    }
                                                    ?>
                                                    <span class="label label-<?php echo $status_class; ?>">
                                                        <?php echo ucfirst($status); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="btn-group">
                                                        <button type="button" class="btn btn-xs btn-default dropdown-toggle" 
                                                                data-toggle="dropdown">
                                                            <i class="fa fa-cogs"></i> <span class="caret"></span>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-right">
                                                            <li>
                                                                <a href="<?php echo base_url(); ?>admin/insurance/edit_pricing/<?php echo $item['id']; ?>">
                                                                    <i class="fa fa-edit"></i> Edit
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="#" onclick="viewPriceHistory(<?php echo $item['id']; ?>)">
                                                                    <i class="fa fa-history"></i> History
                                                                </a>
                                                            </li>
                                                            <li class="divider"></li>
                                                            <li>
                                                                <a href="#" onclick="deleteItem(<?php echo $item['id']; ?>)" class="text-danger">
                                                                    <i class="fa fa-trash"></i> Delete
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Pagination -->
                            <?php if (($total_pages ?? 1) > 1): ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="dataTables_info">
                                            Showing <?php echo (($current_page - 1) * 20) + 1; ?> to 
                                            <?php echo min($current_page * 20, $total_count); ?> of 
                                            <?php echo number_format($total_count); ?> entries
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <nav class="pull-right">
                                            <ul class="pagination pagination-sm">
                                                <?php if ($current_page > 1): ?>
                                                    <li>
                                                        <a href="<?php echo base_url(); ?>admin/insurance/pricing?<?php echo http_build_query(array_merge($filters, ['page' => $current_page - 1])); ?>">
                                                            &laquo;
                                                        </a>
                                                    </li>
                                                <?php endif; ?>

                                                <?php for ($i = max(1, $current_page - 2); $i <= min($total_pages, $current_page + 2); $i++): ?>
                                                    <li class="<?php echo ($i == $current_page) ? 'active' : ''; ?>">
                                                        <a href="<?php echo base_url(); ?>admin/insurance/pricing?<?php echo http_build_query(array_merge($filters, ['page' => $i])); ?>">
                                                            <?php echo $i; ?>
                                                        </a>
                                                    </li>
                                                <?php endfor; ?>

                                                <?php if ($current_page < $total_pages): ?>
                                                    <li>
                                                        <a href="<?php echo base_url(); ?>admin/insurance/pricing?<?php echo http_build_query(array_merge($filters, ['page' => $current_page + 1])); ?>">
                                                            &raquo;
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </nav>
                                    </div>
                                </div>
                            <?php endif; ?>

                        <?php else: ?>
                            <div class="alert alert-info text-center" style="padding: 40px;">
                                <i class="fa fa-info-circle fa-3x text-muted"></i>
                                <h4>No Pricing Data Found</h4>
                                <p>No pricing items match your current filter criteria.</p>
                                <div class="btn-group">
                                    <a href="<?php echo base_url(); ?>admin/insurance/pricing" class="btn btn-warning">
                                        <i class="fa fa-refresh"></i> Clear Filters
                                    </a>
                                    <a href="<?php echo base_url(); ?>admin/insurance/import_pricing" class="btn btn-success">
                                        <i class="fa fa-upload"></i> Import Data
                                    </a>
                                    <a href="<?php echo base_url(); ?>admin/insurance/add_pricing" class="btn btn-primary">
                                        <i class="fa fa-plus"></i> Add New Item
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Price History Modal -->
<div class="modal fade" id="priceHistoryModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-history"></i> Price Change History
                </h4>
            </div>
            <div class="modal-body">
                <div id="priceHistoryContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading price history...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Reject Modal -->
<div class="modal fade" id="bulkRejectModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-times"></i> Bulk Reject Items
                </h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Rejection Reason</label>
                    <textarea id="rejectionReason" class="form-control" rows="3" 
                              placeholder="Please provide a reason for rejecting these items..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-warning" onclick="confirmBulkReject()">
                    <i class="fa fa-times"></i> Reject Items
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999;">
    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); text-align: center; color: white;">
        <i class="fa fa-spinner fa-spin fa-3x"></i>
        <div style="margin-top: 15px; font-size: 18px;">Processing...</div>
    </div>
</div>

<!-- CSS -->
<style>
.table-hover tbody tr:hover {
    background-color: #f8f9fa;
}

.btn-xs {
    padding: 2px 6px;
    font-size: 11px;
}

.item-checkbox {
    margin: 0;
}

.label {
    font-size: 11px;
    padding: 4px 6px;
}

.pagination {
    margin: 0;
}

.dataTables_info {
    padding-top: 8px;
    font-size: 13px;
    color: #666;
}

.dropdown-menu {
    min-width: 140px;
}

.dropdown-menu > li > a {
    padding: 6px 15px;
    font-size: 13px;
}

.small-box .inner h3 {
    font-size: 32px;
    font-weight: bold;
    margin: 0;
}

@media (max-width: 768px) {
    .table-responsive {
        font-size: 12px;
    }
    
    .btn-group .btn {
        display: block;
        width: 100%;
        margin-bottom: 5px;
    }
    
    .box-tools {
        text-align: center;
        margin-top: 10px;
    }
}
</style>

<!-- JavaScript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

<script>
$(document).ready(function() {
    updateSelectedCount();
    $('[title]').tooltip();
});

// Selection functions
function toggleSelectAll() {
    const selectAll = document.getElementById('selectAllCheckbox');
    const checkboxes = document.querySelectorAll('.item-checkbox');
    
    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAll.checked;
    });
    
    updateSelectedCount();
}

function selectAll() {
    document.getElementById('selectAllCheckbox').checked = true;
    toggleSelectAll();
}

function selectNone() {
    document.getElementById('selectAllCheckbox').checked = false;
    toggleSelectAll();
}

function updateSelectedCount() {
    const selectedCount = document.querySelectorAll('.item-checkbox:checked').length;
    document.getElementById('selectedCount').textContent = selectedCount;
    
    const totalCheckboxes = document.querySelectorAll('.item-checkbox').length;
    const selectAllCheckbox = document.getElementById('selectAllCheckbox');
    
    if (selectAllCheckbox) {
        selectAllCheckbox.indeterminate = selectedCount > 0 && selectedCount < totalCheckboxes;
        selectAllCheckbox.checked = selectedCount === totalCheckboxes && totalCheckboxes > 0;
    }
}

function getSelectedItems() {
    const checkboxes = document.querySelectorAll('.item-checkbox:checked');
    return Array.from(checkboxes).map(cb => cb.value);
}

// Bulk actions
function bulkApprove() {
    const selectedItems = getSelectedItems();
    
    if (selectedItems.length === 0) {
        alert('Please select at least one item to approve.');
        return;
    }
    
    if (!confirm(`Are you sure you want to approve ${selectedItems.length} selected item(s)?`)) {
        return;
    }
    
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/bulk_approve',
        type: 'POST',
        dataType: 'json',
        data: { item_ids: selectedItems },
        success: function(response) {
            hideLoading();
            if (response.status === 'success') {
                showAlert(response.message, 'success');
                setTimeout(() => location.reload(), 1500);
            } else {
                showAlert(response.message, 'error');
            }
        },
        error: function() {
            hideLoading();
            showAlert('Error occurred during bulk approval.', 'error');
        }
    });
}

function bulkReject() {
    const selectedItems = getSelectedItems();
    
    if (selectedItems.length === 0) {
        alert('Please select at least one item to reject.');
        return;
    }
    
    $('#bulkRejectModal').modal('show');
}

function confirmBulkReject() {
    const selectedItems = getSelectedItems();
    const reason = document.getElementById('rejectionReason').value.trim();
    
    if (!reason) {
        alert('Please provide a reason for rejection.');
        return;
    }
    
    $('#bulkRejectModal').modal('hide');
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/bulk_reject',
        type: 'POST',
        dataType: 'json',
        data: {
            item_ids: selectedItems,
            reason: reason
        },
        success: function(response) {
            hideLoading();
            if (response.status === 'success') {
                showAlert(response.message, 'success');
                setTimeout(() => location.reload(), 1500);
            } else {
                showAlert(response.message, 'error');
            }
        },
        error: function() {
            hideLoading();
            showAlert('Error occurred during bulk rejection.', 'error');
        }
    });
}

function bulkDelete() {
    const selectedItems = getSelectedItems();
    
    if (selectedItems.length === 0) {
        alert('Please select at least one item to delete.');
        return;
    }
    
    if (!confirm(`Are you sure you want to delete ${selectedItems.length} selected item(s)? This action cannot be undone.`)) {
        return;
    }
    
    showLoading();
    
    let deletedCount = 0;
    const totalItems = selectedItems.length;
    
    selectedItems.forEach(itemId => {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/insurance/delete_pricing',
            type: 'POST',
            dataType: 'json',
            data: { id: itemId },
            success: function(response) {
                deletedCount++;
                if (deletedCount === totalItems) {
                    hideLoading();
                    showAlert(`${deletedCount} item(s) deleted successfully.`, 'success');
                    setTimeout(() => location.reload(), 1500);
                }
            },
            error: function() {
                deletedCount++;
                if (deletedCount === totalItems) {
                    hideLoading();
                    showAlert('Some items could not be deleted.', 'warning');
                    setTimeout(() => location.reload(), 1500);
                }
            }
        });
    });
}

// Individual actions
function deleteItem(itemId) {
    if (!confirm('Are you sure you want to delete this pricing item?')) {
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/delete_pricing',
        type: 'POST',
        dataType: 'json',
        data: { id: itemId },
        success: function(response) {
            if (response.status === 'success') {
                showAlert(response.message, 'success');
                $(`tr[data-id="${itemId}"]`).fadeOut(300, function() {
                    $(this).remove();
                    updateSelectedCount();
                });
            } else {
                showAlert(response.message, 'error');
            }
        },
        error: function() {
            showAlert('Error occurred while deleting item.', 'error');
        }
    });
}

function viewPriceHistory(pricingId) {
    $('#priceHistoryModal').modal('show');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/price_history/' + pricingId,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                displayPriceHistory(response.data);
            } else {
                $('#priceHistoryContent').html('<div class="alert alert-warning">No price history available.</div>');
            }
        },
        error: function() {
            $('#priceHistoryContent').html('<div class="alert alert-danger">Error loading price history.</div>');
        }
    });
}

function displayPriceHistory(historyData) {
    let html = '';
    
    if (historyData.length === 0) {
        html = '<div class="alert alert-info">No price changes recorded for this item.</div>';
    } else {
        html = '<div class="table-responsive">';
        html += '<table class="table table-striped table-condensed">';
        html += '<thead><tr><th>Date</th><th>Old Price</th><th>New Price</th><th>Change</th><th>Reason</th><th>Changed By</th></tr></thead>';
        html += '<tbody>';
        
        historyData.forEach(change => {
            const priceDiff = change.new_price - change.old_price;
            const changeClass = priceDiff > 0 ? 'text-red' : 'text-green';
            const changeIcon = priceDiff > 0 ? 'fa-arrow-up' : 'fa-arrow-down';
            
            html += '<tr>';
            html += `<td>${new Date(change.created_at).toLocaleDateString()}</td>`;
            html += `<td>KES ${parseFloat(change.old_price || 0).toFixed(2)}</td>`;
            html += `<td>KES ${parseFloat(change.new_price).toFixed(2)}</td>`;
            html += `<td class="${changeClass}"><i class="fa ${changeIcon}"></i> KES ${Math.abs(priceDiff).toFixed(2)}</td>`;
            html += `<td>${change.change_reason || '-'}</td>`;
            html += `<td>${change.changed_by_name || 'System'}</td>`;
            html += '</tr>';
        });
        
        html += '</tbody></table></div>';
    }
    
    $('#priceHistoryContent').html(html);
}

// Utility functions
function showLoading() {
    $('#loadingOverlay').show();
}

function hideLoading() {
    $('#loadingOverlay').hide();
}

function showAlert(message, type) {
    const alertClass = type === 'success' ? 'alert-success' : 
                     type === 'warning' ? 'alert-warning' : 
                     type === 'info' ? 'alert-info' : 'alert-danger';
    
    const iconClass = type === 'success' ? 'fa-check-circle' : 
                     type === 'warning' ? 'fa-warning' : 
                     type === 'info' ? 'fa-info-circle' : 'fa-exclamation-circle';
    
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; max-width: 400px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);">
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
            <i class="fa ${iconClass}"></i> ${message}
        </div>
    `;
    
    // Remove existing alerts
    $('.alert').not('[data-permanent]').remove();
    
    $('body').append(alertHtml);
    
    // Auto-hide after 5 seconds for success and info
    if (type === 'success' || type === 'info') {
        setTimeout(() => {
            $('.alert').not('[data-permanent]').fadeOut(500, function() {
                $(this).remove();
            });
        }, 5000);
    }
}

// Enhanced search functionality
function initializeSearch() {
    // Real-time search with debounce
    let searchTimeout;
    $('input[name="search"]').on('input', function() {
        clearTimeout(searchTimeout);
        const query = $(this).val();
        
        if (query.length >= 3) {
            searchTimeout = setTimeout(() => {
                performQuickSearch(query);
            }, 500);
        }
    });
}

function performQuickSearch(query) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/quick_search',
        type: 'GET',
        data: { q: query },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                displaySearchResults(response.data);
            }
        },
        error: function() {
            console.log('Quick search failed');
        }
    });
}

function displaySearchResults(results) {
    // Create dropdown with search results
    const searchContainer = $('input[name="search"]').parent();
    let dropdown = searchContainer.find('.search-dropdown');
    
    if (dropdown.length === 0) {
        dropdown = $('<div class="search-dropdown" style="position: absolute; top: 100%; left: 0; right: 0; background: white; border: 1px solid #ddd; border-top: none; max-height: 300px; overflow-y: auto; z-index: 1000;"></div>');
        searchContainer.css('position', 'relative').append(dropdown);
    }
    
    if (results.length === 0) {
        dropdown.html('<div class="p-2 text-muted">No results found</div>').show();
        return;
    }
    
    let html = '';
    results.forEach(item => {
        html += `
            <div class="search-result-item" style="padding: 8px 12px; border-bottom: 1px solid #eee; cursor: pointer;" 
                 onclick="selectSearchResult('${item.item_name}', '${item.company_name}')">
                <strong>${item.item_name}</strong><br>
                <small class="text-muted">${item.company_name} - KES ${parseFloat(item.item_price).toFixed(2)}</small>
            </div>
        `;
    });
    
    dropdown.html(html).show();
    
    // Hide dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!searchContainer.is(e.target) && searchContainer.has(e.target).length === 0) {
            dropdown.hide();
        }
    });
}

function selectSearchResult(itemName, companyName) {
    $('input[name="search"]').val(itemName);
    $('.search-dropdown').hide();
    // Optionally trigger the form submission
    $('form').submit();
}

// Initialize enhanced features
$(document).ready(function() {
    initializeSearch();
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Auto-refresh data every 5 minutes
    setInterval(function() {
        if (document.visibilityState === 'visible') {
            checkForUpdates();
        }
    }, 300000); // 5 minutes
});

function checkForUpdates() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/check_updates',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.hasUpdates) {
                showUpdateNotification();
            }
        },
        error: function() {
            // Silently fail
        }
    });
}

function showUpdateNotification() {
    if ($('.update-notification').length === 0) {
        const notification = `
            <div class="alert alert-info update-notification" style="position: fixed; bottom: 20px; right: 20px; z-index: 9999; max-width: 300px;">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa fa-refresh"></i> New pricing data available. 
                <a href="javascript:void(0)" onclick="location.reload()" class="alert-link">Refresh page</a>
            </div>
        `;
        $('body').append(notification);
    }
}

// Export functionality
function exportPricingData(format) {
    const currentUrl = new URL(window.location);
    const params = new URLSearchParams(currentUrl.search);
    params.set('export', format);
    
    window.open(`<?php echo base_url(); ?>admin/insurance/export_pricing?${params.toString()}`, '_blank');
}

// Keyboard shortcuts
$(document).keydown(function(e) {
    // Ctrl+A for select all
    if (e.ctrlKey && e.keyCode === 65 && e.target.tagName !== 'INPUT') {
        e.preventDefault();
        selectAll();
    }
    
    // Escape to clear selection
    if (e.keyCode === 27) {
        selectNone();
        $('.search-dropdown').hide();
    }
    
    // Ctrl+F for search focus
    if (e.ctrlKey && e.keyCode === 70) {
        e.preventDefault();
        $('input[name="search"]').focus();
    }
});

console.log('Insurance Pricing List - Enhanced Version Loaded');
console.log('Available shortcuts: Ctrl+A (Select All), Escape (Clear), Ctrl+F (Search)');
</script>