<?php
/**
 * Insurance Pricing Import - Complete AdminLTE Template
 * File: application/views/admin/insurance/import_pricing.php
 */
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Import Insurance Pricing - CityHeal HMS</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper { 
            background-color: #ecf0f5; 
        }
        
        .gcc-header {
            background: linear-gradient(135deg, #00a65a 0%, #00c0ef 100%);
            color: white; 
            padding: 20px; 
            border-radius: 3px; 
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .upload-area {
            border: 2px dashed #00a65a;
            border-radius: 8px;
            padding: 40px;
            text-align: center;
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 20px;
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .upload-area:hover {
            border-color: #008d4c;
            background: linear-gradient(145deg, #f0f8f0, #f9fff9);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,166,90,0.2);
        }
        
        .upload-area.dragover {
            border-color: #28a745;
            background: linear-gradient(145deg, #d4edda, #e8f5e8);
            animation: pulse 1s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.02); }
            100% { transform: scale(1); }
        }
        
        .file-input {
            display: none;
        }
        
        .upload-icon {
            font-size: 48px;
            color: #00a65a;
            margin-bottom: 15px;
            transition: color 0.3s ease;
        }
        
        .upload-area:hover .upload-icon {
            color: #008d4c;
        }
        
        .upload-text {
            font-size: 18px;
            color: #333;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        .upload-hint {
            font-size: 14px;
            color: #666;
        }
        
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            padding: 0 20px;
        }
        
        .step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        
        .step:not(:last-child):after {
            content: '';
            position: absolute;
            top: 20px;
            left: 60%;
            width: 40%;
            height: 3px;
            background-color: #ddd;
            z-index: 1;
        }
        
        .step.active:not(:last-child):after {
            background: linear-gradient(90deg, #00a65a, #00c0ef);
        }
        
        .step.completed:not(:last-child):after {
            background: linear-gradient(90deg, #28a745, #20c997);
        }
        
        .step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, #ddd, #ccc);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
            color: #666;
            font-weight: bold;
            font-size: 14px;
            position: relative;
            z-index: 2;
            border: 3px solid white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        
        .step.active .step-circle {
            background: linear-gradient(135deg, #00a65a, #00c0ef);
            color: white;
            transform: scale(1.1);
            box-shadow: 0 4px 12px rgba(0,166,90,0.3);
        }
        
        .step.completed .step-circle {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
        }
        
        .step-label {
            font-size: 13px;
            color: #666;
            font-weight: 500;
        }
        
        .step.active .step-label {
            color: #00a65a;
            font-weight: 600;
        }
        
        .step.completed .step-label {
            color: #28a745;
            font-weight: 600;
        }
        
        .import-results {
            margin-top: 20px;
            display: none;
        }
        
        .validation-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        
        .stat-box {
            background: white;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            border: 1px solid #ddd;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.2s ease;
        }
        
        .stat-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        
        .stat-number {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .stat-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
        }
        
        .stat-box.total .stat-number { color: #007bb6; }
        .stat-box.valid .stat-number { color: #28a745; }
        .stat-box.invalid .stat-number { color: #dc3545; }
        .stat-box.duplicate .stat-number { color: #ffc107; }
        
        .progress {
            height: 8px;
            border-radius: 10px;
            background: #f4f4f4;
            overflow: hidden;
            box-shadow: inset 0 1px 2px rgba(0,0,0,0.1);
        }
        
        .progress-bar {
            background: linear-gradient(90deg, #00a65a, #00c0ef);
            border-radius: 10px;
            transition: width 0.3s ease;
        }
        
        .btn-gcc {
            background: linear-gradient(135deg, #00a65a, #008d4c);
            border: none;
            color: white;
            font-weight: 600;
            padding: 10px 20px;
            border-radius: 6px;
            transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(0,166,90,0.3);
        }
        
        .btn-gcc:hover {
            background: linear-gradient(135deg, #008d4c, #00704a);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,166,90,0.4);
        }
        
        .btn-gcc:active {
            transform: translateY(0);
        }
        
        .alert {
            border-radius: 6px;
            border: none;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 15px;
        }
        
        .box {
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: none;
        }
        
        .box-header {
            border-bottom: 1px solid #f4f4f4;
            border-radius: 8px 8px 0 0;
            padding: 15px 20px;
        }
        
        .box-body {
            padding: 20px;
        }
        
        .validation-rules {
            background: linear-gradient(135deg, #fff3cd, #ffeaa7);
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 20px;
            margin-top: 20px;
            box-shadow: 0 2px 4px rgba(255,193,7,0.2);
        }
        
        .required-columns {
            background: white;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 15px;
        }
        
        .required-columns ul {
            margin: 0;
            padding-left: 20px;
        }
        
        .required-columns li {
            margin: 5px 0;
            color: #333;
        }
        
        .text-green { color: #28a745 !important; }
        .text-blue { color: #007bb6 !important; }
        .text-red { color: #dc3545 !important; }
        .text-orange { color: #fd7e14 !important; }
        
        .file-info-card {
            background: linear-gradient(135deg, #e3f2fd, #bbdefb);
            border: 1px solid #90caf9;
            border-radius: 8px;
            padding: 20px;
            margin-top: 20px;
        }
        
        .warning-list {
            background: #fff;
            border-radius: 6px;
            padding: 15px;
            margin-top: 15px;
            border: 1px solid #dee2e6;
        }
        
        .warning-item {
            padding: 8px 0;
            border-bottom: 1px solid #f8f9fa;
            font-size: 13px;
        }
        
        .warning-item:last-child {
            border-bottom: none;
        }
        
        .final-summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }
        
        .summary-card {
            background: white;
            padding: 25px 20px;
            border-radius: 10px;
            text-align: center;
            border: 1px solid #ddd;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .summary-number {
            font-size: 32px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .summary-label {
            color: #666;
            font-size: 14px;
        }
        
        @media (max-width: 768px) {
            .step-indicator {
                padding: 0 10px;
            }
            
            .step-circle {
                width: 35px;
                height: 35px;
                font-size: 12px;
            }
            
            .upload-area {
                padding: 30px 20px;
            }
            
            .validation-stats {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .final-summary {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

    <!-- Include your existing header and sidebar here -->
    <?php $this->load->view('layout/header'); ?>

    <div class="content-wrapper">
        <!-- Content Header -->
        <section class="content-header">
            <h1>
                <i class="fa fa-upload"></i> Import Insurance Pricing Data
                <small>Upload and process pricing data from Excel/CSV files</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="<?php echo base_url(); ?>admin/insurance">Insurance</a></li>
                <li><a href="<?php echo base_url(); ?>admin/insurance/pricing">Pricing</a></li>
                <li class="active">Import</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <!-- Flash Messages -->
            <div id="flashMessages"></div>

            <!-- Enhanced Header -->
            <div class="gcc-header">
                <div class="row">
                    <div class="col-md-8">
                        <h2 style="margin: 0; font-size: 24px;">
                            <i class="fa fa-cloud-upload"></i> Insurance Pricing Import System
                        </h2>
                        <p style="margin: 5px 0 0 0; opacity: 0.9;">
                            Professional data import with validation and progress tracking
                        </p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div style="background: rgba(255,255,255,0.2); padding: 10px 15px; border-radius: 6px; display: inline-block;">
                            <i class="fa fa-shield"></i> Secure Import Process
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step Indicator -->
            <div class="step-indicator">
                <div class="step active" id="step1">
                    <div class="step-circle">1</div>
                    <div class="step-label">Select File</div>
                </div>
                <div class="step" id="step2">
                    <div class="step-circle">2</div>
                    <div class="step-label">Validate</div>
                </div>
                <div class="step" id="step3">
                    <div class="step-circle">3</div>
                    <div class="step-label">Import</div>
                </div>
                <div class="step" id="step4">
                    <div class="step-circle">4</div>
                    <div class="step-label">Complete</div>
                </div>
            </div>

            <div class="row">
                <!-- Upload Section -->
                <div class="col-md-8">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-cloud-upload"></i> File Upload
                            </h3>
                            <div class="box-tools pull-right">
                                <span class="label label-primary">Step 1 of 4</span>
                            </div>
                        </div>
                        <div class="box-body">
                            <!-- Upload Area -->
                            <div class="upload-area" id="uploadArea">
                                <div class="upload-icon">
                                    <i class="fa fa-cloud-upload"></i>
                                </div>
                                <div class="upload-text">
                                    <strong>Choose a file or drag it here</strong>
                                </div>
                                <div class="upload-hint">
                                    Supports Excel (.xlsx, .xls) and CSV (.csv) files up to 10MB
                                </div>
                                <input type="file" id="fileInput" class="file-input" accept=".xlsx,.xls,.csv">
                                <div style="margin-top: 15px;">
                                    <button type="button" class="btn btn-info btn-sm" onclick="downloadTemplate()">
                                        <i class="fa fa-download"></i> Download Template
                                    </button>
                                </div>
                            </div>

                            <!-- Progress Bar -->
                            <div id="uploadProgress" style="display: none; margin-top: 20px;">
                                <div class="progress">
                                    <div class="progress-bar progress-bar-striped active" role="progressbar" style="width: 0%">
                                        <span class="sr-only">0% Complete</span>
                                    </div>
                                </div>
                                <div style="text-align: center; margin-top: 10px; color: #666;">
                                    Processing file...
                                </div>
                            </div>

                            <!-- File Info -->
                            <div id="fileInfo" style="display: none;">
                                <div class="file-info-card">
                                    <h4><i class="fa fa-file"></i> Selected File</h4>
                                    <p id="fileName" style="margin: 5px 0; font-weight: 600;"></p>
                                    <p id="fileSize" style="margin: 5px 0; color: #666;"></p>
                                    <div style="margin-top: 15px;">
                                        <button type="button" class="btn-gcc" onclick="validateFile()">
                                            <i class="fa fa-check"></i> Validate File
                                        </button>
                                        <button type="button" class="btn btn-default" onclick="clearFile()" style="margin-left: 10px;">
                                            <i class="fa fa-times"></i> Remove
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Validation Results -->
                            <div class="import-results" id="validationResults">
                                <div class="alert alert-success">
                                    <h4><i class="fa fa-check-circle"></i> Validation Results</h4>
                                    
                                    <div class="validation-stats" id="validationSummary">
                                        <!-- Stats will be populated here -->
                                    </div>
                                    
                                    <div id="validationDetails">
                                        <!-- Details will be populated here -->
                                    </div>
                                    
                                    <div style="margin-top: 20px; text-align: center;">
                                        <button type="button" class="btn-gcc btn-lg" onclick="processImport()">
                                            <i class="fa fa-play"></i> Start Import
                                        </button>
                                        <button type="button" class="btn btn-default btn-lg" onclick="clearValidation()" style="margin-left: 15px;">
                                            <i class="fa fa-refresh"></i> Start Over
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Import Progress -->
                            <div class="import-results" id="importProgress">
                                <div class="alert alert-info">
                                    <h4><i class="fa fa-cog fa-spin"></i> Processing Import</h4>
                                    <div class="progress" style="margin: 15px 0;">
                                        <div class="progress-bar progress-bar-info progress-bar-striped active" 
                                             id="importProgressBar" role="progressbar" style="width: 0%">
                                            <span id="importProgressText">0%</span>
                                        </div>
                                    </div>
                                    <div id="importStatus" style="text-align: center; color: #666;">
                                        Preparing import...
                                    </div>
                                </div>
                            </div>

                            <!-- Final Results -->
                            <div class="import-results" id="finalResults">
                                <div class="alert alert-success">
                                    <h4><i class="fa fa-check-circle"></i> Import Complete!</h4>
                                    
                                    <div class="final-summary" id="finalSummary">
                                        <!-- Summary will be populated here -->
                                    </div>
                                    
                                    <p style="text-align: center; margin: 20px 0; font-size: 16px;">
                                        <strong>Import completed successfully!</strong> All valid pricing data has been imported and is ready for review.
                                    </p>
                                    
                                    <div style="text-align: center; margin-top: 25px;">
                                        <a href="<?php echo base_url(); ?>admin/insurance/pricing" class="btn-gcc btn-lg">
                                            <i class="fa fa-list"></i> View Imported Data
                                        </a>
                                        <button type="button" class="btn btn-success btn-lg" onclick="startNewImport()" style="margin-left: 15px;">
                                            <i class="fa fa-plus"></i> Import Another File
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Instructions and Help -->
                <div class="col-md-4">
                    <!-- Instructions Box -->
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-info-circle"></i> Import Instructions
                            </h3>
                        </div>
                        <div class="box-body">
                            <div class="required-columns">
                                <h5><strong>Required Columns:</strong></h5>
                                <ul>
                                    <li><i class="fa fa-check text-green"></i> Insurance Company</li>
                                    <li><i class="fa fa-check text-green"></i> Item Name</li>
                                    <li><i class="fa fa-check text-green"></i> Item Type</li>
                                    <li><i class="fa fa-check text-green"></i> Item Family</li>
                                    <li><i class="fa fa-check text-green"></i> Price (KES)</li>
                                    <li><i class="fa fa-check text-green"></i> Effective Date</li>
                                    <li><i class="fa fa-check text-green"></i> Status</li>
                                </ul>
                            </div>

                            <div class="required-columns">
                                <h5><strong>Item Types:</strong></h5>
                                <ul>
                                    <li><i class="fa fa-angle-right"></i> Stock</li>
                                    <li><i class="fa fa-angle-right"></i> Service</li>
                                    <li><i class="fa fa-angle-right"></i> Medicine</li>
                                    <li><i class="fa fa-angle-right"></i> Equipment</li>
                                    <li><i class="fa fa-angle-right"></i> Procedure</li>
                                </ul>
                            </div>

                            <div class="required-columns">
                                <h5><strong>Status Values:</strong></h5>
                                <ul>
                                    <li><i class="fa fa-angle-right"></i> Active</li>
                                    <li><i class="fa fa-angle-right"></i> Inactive</li>
                                    <li><i class="fa fa-angle-right"></i> Expired</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Important Notes -->
                    <div class="validation-rules">
                        <h5><i class="fa fa-exclamation-triangle"></i> <strong>Important Notes:</strong></h5>
                        <ul style="margin: 15px 0 0 20px;">
                            <li>Company names must match existing insurance companies</li>
                            <li>Prices must be numeric values greater than 0</li>
                            <li>Dates should be in YYYY-MM-DD format</li>
                            <li>Duplicate items will be updated with new prices</li>
                            <li>Maximum file size: 10MB</li>
                            <li>Maximum rows per import: 5,000</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Include your existing footer here -->
    <?php $this->load->view('layout/footer'); ?>

</div>

<!-- Scripts -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>

<script>
    let selectedFile = null;
    let validationData = null;

    $(document).ready(function() {
        initializeUpload();
        console.log('Insurance Pricing Import System - AdminLTE Theme Loaded');
    });

    function initializeUpload() {
        const uploadArea = document.getElementById('uploadArea');
        const fileInput = document.getElementById('fileInput');

        // Click to select file
        uploadArea.addEventListener('click', () => {
            fileInput.click();
        });

        // File selection
        fileInput.addEventListener('change', handleFileSelect);

        // Drag and drop
        uploadArea.addEventListener('dragover', (e) => {
            e.preventDefault();
            uploadArea.classList.add('dragover');
        });

        uploadArea.addEventListener('dragleave', () => {
            uploadArea.classList.remove('dragover');
        });

        uploadArea.addEventListener('drop', (e) => {
            e.preventDefault();
            uploadArea.classList.remove('dragover');
            
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                handleFile(files[0]);
            }
        });
    }

    function handleFileSelect(e) {
        const file = e.target.files[0];
        if (file) {
            handleFile(file);
        }
    }

    function handleFile(file) {
        // Validate file type
        const allowedTypes = [
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'application/vnd.ms-excel',
            'text/csv'
        ];

        if (!allowedTypes.includes(file.type) && !file.name.toLowerCase().endsWith('.csv')) {
            showAlert('Please select a valid Excel (.xlsx, .xls) or CSV (.csv) file.', 'error');
            return;
        }

        // Validate file size (10MB)
        if (file.size > 10 * 1024 * 1024) {
            showAlert('File size must be less than 10MB.', 'error');
            return;
        }

        selectedFile = file;
        displayFileInfo(file);
        updateStep(1);
    }

    function displayFileInfo(file) {
        const fileName = document.getElementById('fileName');
        const fileSize = document.getElementById('fileSize');
        const fileInfo = document.getElementById('fileInfo');

        fileName.textContent = `Name: ${file.name}`;
        fileSize.textContent = `Size: ${formatFileSize(file.size)}`;
        
        fileInfo.style.display = 'block';
    }

    function formatFileSize(bytes) {
        if (bytes === 0) return '0 Bytes';
        const k = 1024;
        const sizes = ['Bytes', 'KB', 'MB', 'GB'];
        const i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
    }

    function clearFile() {
        selectedFile = null;
        document.getElementById('fileInput').value = '';
        document.getElementById('fileInfo').style.display = 'none';
        clearValidation();
        updateStep(1);
    }

    function validateFile() {
        if (!selectedFile) {
            showAlert('Please select a file first.', 'error');
            return;
        }

        showProgress();
        updateStep(2);

        // TODO: Replace with actual validation AJAX call
        simulateValidation();
    }

    function simulateValidation() {
        let progress = 0;
        const interval = setInterval(() => {
            progress += Math.random() * 15;
            updateProgress(Math.min(progress, 95));

            if (progress >= 95) {
                clearInterval(interval);
                setTimeout(() => {
                    hideProgress();
                    showValidationResults();
                }, 500);
            }
        }, 200);
    }

    function showValidationResults() {
        // Mock validation data
        validationData = {
            totalRows: 1250,
            validRows: 1180,
            invalidRows: 70,
            duplicates: 15,
            newItems: 1000,
            updates: 180,
            companies: ['APA Insurance', 'Jubilee Insurance', 'UAP'],
            warnings: [
                'Row 45: Invalid item type "Equipment" should be "Medicine"',
                'Row 78: Missing effective date, using current date',
                'Row 123: Company "Unknown Insurance" not found'
            ]
        };

        const summary = document.getElementById('validationSummary');
        const details = document.getElementById('validationDetails');

        summary.innerHTML = `
            <div class="stat-box total">
                <div class="stat-number">${validationData.totalRows}</div>
                <div class="stat-label">Total Rows</div>
            </div>
            <div class="stat-box valid">
                <div class="stat-number">${validationData.validRows}</div>
                <div class="stat-label">Valid Rows</div>
            </div>
            <div class="stat-box invalid">
                <div class="stat-number">${validationData.invalidRows}</div>
                <div class="stat-label">Invalid Rows</div>
            </div>
            <div class="stat-box duplicate">
                <div class="stat-number">${validationData.duplicates}</div>
                <div class="stat-label">Duplicates</div>
            </div>
        `;

        if (validationData.warnings.length > 0) {
            details.innerHTML = `
                <div class="warning-list">
                    <h5><i class="fa fa-warning text-orange"></i> Validation Warnings:</h5>
                    ${validationData.warnings.map(warning => 
                        `<div class="warning-item">
                            <i class="fa fa-warning text-orange"></i> ${warning}
                        </div>`
                    ).join('')}
                </div>
            `;
        }

        document.getElementById('validationResults').style.display = 'block';
    }

    function processImport() {
        if (!validationData) {
            showAlert('Please validate the file first.', 'error');
            return;
        }

        document.getElementById('validationResults').style.display = 'none';
        document.getElementById('importProgress').style.display = 'block';
        updateStep(3);

        // TODO: Replace with actual import AJAX call
        simulateImport();
    }

    function simulateImport() {
        let progress = 0;
        let processed = 0;
        const total = validationData.validRows;

        const interval = setInterval(() => {
            const increment = Math.random() * 50;
            processed += increment;
            progress = (processed / total) * 100;

            updateImportProgress(Math.min(progress, 100), Math.min(processed, total), total);

            if (progress >= 100) {
                clearInterval(interval);
                setTimeout(() => {
                    showFinalResults();
                }, 500);
            }
        }, 300);
    }

    function updateImportProgress(percentage, processed, total) {
        const progressBar = document.getElementById('importProgressBar');
        const progressText = document.getElementById('importProgressText');
        const status = document.getElementById('importStatus');

        progressBar.style.width = percentage + '%';
        progressText.textContent = Math.round(percentage) + '%';
        status.textContent = `Processed ${Math.round(processed)} of ${total} records...`;
    }

    function showFinalResults() {
        document.getElementById('importProgress').style.display = 'none';
        
        const summary = document.getElementById('finalSummary');
        summary.innerHTML = `
            <div class="summary-card">
                <div class="summary-number text-green">${validationData.newItems}</div>
                <div class="summary-label">New Items Added</div>
            </div>
            <div class="summary-card">
                <div class="summary-number text-blue">${validationData.updates}</div>
                <div class="summary-label">Items Updated</div>
            </div>
            <div class="summary-card">
                <div class="summary-number text-red">${validationData.invalidRows}</div>
                <div class="summary-label">Rows Skipped</div>
            </div>
        `;

        document.getElementById('finalResults').style.display = 'block';
        updateStep(4);
    }

    function clearValidation() {
        document.getElementById('validationResults').style.display = 'none';
        document.getElementById('importProgress').style.display = 'none';
        document.getElementById('finalResults').style.display = 'none';
        validationData = null;
    }

    function startNewImport() {
        clearFile();
        clearValidation();
        updateStep(1);
    }

    function updateStep(stepNumber) {
        // Reset all steps
        for (let i = 1; i <= 4; i++) {
            const step = document.getElementById(`step${i}`);
            step.classList.remove('active', 'completed');
        }

        // Mark completed steps
        for (let i = 1; i < stepNumber; i++) {
            document.getElementById(`step${i}`).classList.add('completed');
        }

        // Mark current step
        document.getElementById(`step${stepNumber}`).classList.add('active');
    }

    function showProgress() {
        document.getElementById('uploadProgress').style.display = 'block';
    }

    function hideProgress() {
        document.getElementById('uploadProgress').style.display = 'none';
    }

    function updateProgress(percentage) {
        const progressBar = document.querySelector('#uploadProgress .progress-bar');
        progressBar.style.width = percentage + '%';
        progressBar.querySelector('.sr-only').textContent = Math.round(percentage) + '% Complete';
    }

    function downloadTemplate() {
        // Create a sample CSV template with more realistic data
        const csvContent = [
            'Insurance Company,Item Name,Item Type,Item Family,Price (KES),Effective Date,Status',
            'APA Insurance,Paracetamol 500mg,Medicine,Analgesics,50.00,2025-01-01,Active',
            'Jubilee Insurance,X-Ray Chest,Service,Diagnostic,2500.00,2025-01-01,Active',
            'UAP,Blood Pressure Monitor,Equipment,Monitoring,8500.00,2025-01-01,Active',
            'CIC Insurance,Blood Test - FBC,Service,Laboratory,800.00,2025-01-01,Active',
            'Britam,Consultation Fee,Service,Consultation,1500.00,2025-01-01,Active',
            'NHIF,ECG Test,Procedure,Cardiac,1200.00,2025-01-01,Active',
            'Madison Insurance,Insulin Injection,Medicine,Diabetes,350.00,2025-01-01,Active'
        ].join('\n');

        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const link = document.createElement('a');
        
        link.href = url;
        link.download = 'insurance_pricing_template.csv';
        link.click();
        
        window.URL.revokeObjectURL(url);
        
        showAlert('Template downloaded successfully! Check your downloads folder.', 'success');
    }

    function showAlert(message, type) {
        const alertClass = type === 'success' ? 'alert-success' : 
                         type === 'warning' ? 'alert-warning' : 
                         type === 'info' ? 'alert-info' : 'alert-danger';
        
        const iconClass = type === 'success' ? 'fa-check-circle' : 
                         type === 'warning' ? 'fa-warning' : 
                         type === 'info' ? 'fa-info-circle' : 'fa-exclamation-circle';
        
        const alertHtml = `
            <div class="alert ${alertClass} alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa ${iconClass}"></i> ${message}
            </div>
        `;
        
        document.getElementById('flashMessages').innerHTML = alertHtml;
        
        // Auto-hide success and info alerts
        if (type === 'success' || type === 'info') {
            setTimeout(() => {
                $('.alert').fadeOut(500, function() {
                    $(this).remove();
                });
            }, 5000);
        }
    }

    // Real file processing function for actual implementation
    function processFileWithFormData() {
        if (!selectedFile) return;

        const formData = new FormData();
        formData.append('import_file', selectedFile);
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/insurance/process_import',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhr: function() {
                const xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress", function(evt) {
                    if (evt.lengthComputable) {
                        const percentComplete = (evt.loaded / evt.total) * 100;
                        updateProgress(percentComplete);
                    }
                }, false);
                return xhr;
            },
            success: function(response) {
                hideProgress();
                if (response.status === 'success') {
                    validationData = response.data;
                    showValidationResults();
                } else {
                    showAlert(response.message || 'Validation failed', 'error');
                }
            },
            error: function() {
                hideProgress();
                showAlert('Error occurred during file processing', 'error');
            }
        });
    }

    // Debug functions for development
    window.IMPORT_DEBUG = {
        testValidation: function() {
            validationData = {
                totalRows: 500,
                validRows: 480,
                invalidRows: 20,
                duplicates: 5,
                newItems: 400,
                updates: 80,
                warnings: ['Test warning 1', 'Test warning 2']
            };
            showValidationResults();
            updateStep(2);
            console.log('✅ Validation test completed');
        },
        
        testImport: function() {
            if (!validationData) this.testValidation();
            processImport();
            console.log('⚡ Import test started');
        },
        
        testComplete: function() {
            this.testImport();
            setTimeout(() => {
                showFinalResults();
                updateStep(4);
                console.log('🎉 Complete workflow test finished');
            }, 2000);
        },
        
        resetSystem: function() {
            clearFile();
            clearValidation();
            updateStep(1);
            console.log('🔄 Import system reset');
        },
        
        getState: function() {
            console.log('📊 Current system state:', {
                selectedFile: selectedFile ? selectedFile.name : null,
                validationData: validationData,
                currentStep: getCurrentStep()
            });
        }
    };

    function getCurrentStep() {
        for (let i = 1; i <= 4; i++) {
            if (document.getElementById(`step${i}`).classList.contains('active')) {
                return i;
            }
        }
        return 1;
    }

    console.log('🎨 AdminLTE Insurance Import System Ready!');
    console.log('📁 Use IMPORT_DEBUG object for testing import functionality');
    console.log('🔧 Available commands: testValidation(), testImport(), testComplete(), resetSystem(), getState()');
</script>

</body>
</html>